/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.util.HashMap;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="cluster/replicas/migrate")
public class MigrateReplicasAPI
extends AdminAPIBase {
    @Inject
    public MigrateReplicasAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    @Operation(summary="Migrate Replicas from a given set of nodes.")
    public SolrJerseyResponse migrateReplicas(@RequestBody(description="Contains user provided parameters", required=true) MigrateReplicasRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = this.createRemoteMessage(requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.MIGRATE_REPLICAS, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public ZkNodeProps createRemoteMessage(MigrateReplicasRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        if (requestBody != null) {
            if (requestBody.sourceNodes == null || requestBody.sourceNodes.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No 'sourceNodes' provided in the request body. The MigrateReplicas API requires a 'sourceNodes' list in the request body.");
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No request body sent with request. The MigrateReplicas API requires a body.");
        }
        MigrateReplicasAPI.insertIfNotNull(remoteMessage, "sourceNodes", requestBody.sourceNodes);
        MigrateReplicasAPI.insertIfNotNull(remoteMessage, "targetNodes", requestBody.targetNodes);
        MigrateReplicasAPI.insertIfNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
        MigrateReplicasAPI.insertIfNotNull(remoteMessage, "async", requestBody.async);
        remoteMessage.put("operation", CollectionParams.CollectionAction.MIGRATE_REPLICAS.toLower());
        return new ZkNodeProps(remoteMessage);
    }

    public static class MigrateReplicasRequestBody
    implements JacksonReflectMapWriter {
        @Schema(description="The set of nodes which all replicas will be migrated off of.")
        @JsonProperty(value="sourceNodes", required=true)
        public Set<String> sourceNodes;
        @Schema(description="A set of nodes to migrate the replicas to. If this is not provided, then the API will use the live data nodes not in 'sourceNodes'.")
        @JsonProperty(value="targetNodes")
        public Set<String> targetNodes;
        @Schema(description="If true, the request will complete only when all affected replicas become active. If false, the API will return the status of the single action, which may be before the new replicas are online and active.")
        @JsonProperty(value="waitForFinalState")
        public Boolean waitForFinalState = false;
        @Schema(description="Request ID to track this action which will be processed asynchronously.")
        @JsonProperty(value="async")
        public String async;

        public MigrateReplicasRequestBody() {
        }

        public MigrateReplicasRequestBody(Set<String> sourceNodes, Set<String> targetNodes, Boolean waitForFinalState, String async) {
            this.sourceNodes = sourceNodes;
            this.targetNodes = targetNodes;
            this.waitForFinalState = waitForFinalState;
            this.async = async;
        }
    }
}

