/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.net.URL;
import java.security.spec.InvalidKeySpecException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.util.CryptoKeys;

public class SolrNodeKeyPair {
    private final CryptoKeys.RSAKeyPair keyPair;

    public SolrNodeKeyPair(CloudConfig cloudConfig) {
        this.keyPair = SolrNodeKeyPair.createKeyPair(cloudConfig);
    }

    public CryptoKeys.RSAKeyPair getKeyPair() {
        return this.keyPair;
    }

    private static CryptoKeys.RSAKeyPair createKeyPair(CloudConfig config) {
        if (config == null) {
            return new CryptoKeys.RSAKeyPair();
        }
        String publicKey = config.getPkiHandlerPublicKeyPath();
        String privateKey = config.getPkiHandlerPrivateKeyPath();
        if (StrUtils.isNullOrEmpty((String)publicKey) && StrUtils.isNullOrEmpty((String)privateKey)) {
            return new CryptoKeys.RSAKeyPair();
        }
        try {
            return new CryptoKeys.RSAKeyPair(new URL(privateKey), new URL(publicKey));
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new RuntimeException("Bad PublicKeyHandler configuration.", e);
        }
    }
}

