/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPUCircuitBreaker
extends CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean enabled = true;
    private double cpuUsageThreshold;
    private final SolrCore core;
    private static final ThreadLocal<Double> seenCPUUsage = ThreadLocal.withInitial(() -> 0.0);
    private static final ThreadLocal<Double> allowedCPUUsage = ThreadLocal.withInitial(() -> 0.0);

    public CPUCircuitBreaker(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        double localSeenCPUUsage = this.calculateLiveCPUUsage();
        if (localSeenCPUUsage < 0.0) {
            String msg = "Initialization failure for CPU circuit breaker. Unable to get 'systemCpuLoad', not supported by the JVM?";
            if (log.isErrorEnabled()) {
                log.error(msg);
            }
            this.enabled = false;
        }
    }

    @Override
    public boolean isTripped() {
        if (!this.enabled) {
            if (log.isDebugEnabled()) {
                log.debug("CPU circuit breaker is disabled due to initialization failure.");
            }
            return false;
        }
        double localAllowedCPUUsage = this.getCpuUsageThreshold();
        double localSeenCPUUsage = this.calculateLiveCPUUsage();
        allowedCPUUsage.set(localAllowedCPUUsage);
        seenCPUUsage.set(localSeenCPUUsage);
        return localSeenCPUUsage >= localAllowedCPUUsage;
    }

    @Override
    public String getErrorMessage() {
        return "CPU Circuit Breaker triggered as seen CPU usage is above allowed threshold. Seen CPU usage " + seenCPUUsage.get() + " and allocated threshold " + allowedCPUUsage.get();
    }

    public void setThreshold(double thresholdValueInPercentage) {
        if (thresholdValueInPercentage > 100.0) {
            throw new IllegalArgumentException("Invalid Invalid threshold value.");
        }
        if (thresholdValueInPercentage <= 0.0) {
            throw new IllegalStateException("Threshold cannot be less than or equal to zero");
        }
        this.cpuUsageThreshold = thresholdValueInPercentage;
    }

    public double getCpuUsageThreshold() {
        return this.cpuUsageThreshold;
    }

    protected double calculateLiveCPUUsage() {
        Metric metric = (Metric)this.core.getCoreContainer().getMetricManager().registry("solr.jvm").getMetrics().get("os.systemCpuLoad");
        if (metric == null) {
            return -1.0;
        }
        if (metric instanceof Gauge) {
            Gauge gauge = (Gauge)metric;
            if (gauge instanceof SolrMetricManager.GaugeWrapper) {
                gauge = ((SolrMetricManager.GaugeWrapper)gauge).getGauge();
            }
            return (Double)gauge.getValue() * 100.0;
        }
        return -1.0;
    }
}

