/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.tracing;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.solr.request.SolrQueryRequest;

public class TraceUtils {
    public static final Predicate<Span> DEFAULT_IS_RECORDING = span -> span != null && !(span instanceof NoopSpan);
    public static Predicate<Span> IS_RECORDING = DEFAULT_IS_RECORDING;

    public static void setDbInstance(SolrQueryRequest req, String coreOrColl) {
        if (req != null && coreOrColl != null) {
            TraceUtils.ifNotNoop(req.getSpan(), span -> span.setTag((Tag)Tags.DB_INSTANCE, (Object)coreOrColl));
        }
    }

    public static void ifNotNoop(Span span, Consumer<Span> consumer) {
        if (IS_RECORDING.test(span)) {
            consumer.accept(span);
        }
    }

    public static void setOperations(SolrQueryRequest req, String clazz, List<String> ops) {
        if (!ops.isEmpty()) {
            req.getSpan().setTag("ops", String.join((CharSequence)",", ops));
            req.getSpan().setTag("class", clazz);
        }
    }
}

