/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal;

import org.jetbrains.annotations.NotNull;
import org.semver4j.Semver;

public class Differ {
    @NotNull
    private final Semver version;

    public Differ(@NotNull Semver version) {
        this.version = version;
    }

    @NotNull
    public Semver.VersionDiff diff(@NotNull Semver other) {
        if (this.version.getMajor() != other.getMajor()) {
            return Semver.VersionDiff.MAJOR;
        }
        if (this.version.getMinor() != other.getMinor()) {
            return Semver.VersionDiff.MINOR;
        }
        if (this.version.getPatch() != other.getPatch()) {
            return Semver.VersionDiff.PATCH;
        }
        if (!this.version.getPreRelease().equals(other.getPreRelease())) {
            return Semver.VersionDiff.PRE_RELEASE;
        }
        if (!this.version.getBuild().equals(other.getBuild())) {
            return Semver.VersionDiff.BUILD;
        }
        return Semver.VersionDiff.NONE;
    }
}

