/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRules;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.Util;

public class Programs {
    @Deprecated
    public static final ImmutableList<RelOptRule> CALC_RULES = RelOptRules.CALC_RULES;
    public static final Program CALC_PROGRAM = Programs.calc(DefaultRelMetadataProvider.INSTANCE);
    public static final Program SUB_QUERY_PROGRAM = Programs.subQuery(DefaultRelMetadataProvider.INSTANCE);
    public static final ImmutableSet<RelOptRule> RULE_SET = ImmutableSet.of((Object)EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, (Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_AGGREGATE_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_LIMIT_RULE, EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_MERGE_UNION_RULE, EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_MATCH_RULE, CoreRules.PROJECT_TO_SEMI_JOIN, CoreRules.JOIN_ON_UNIQUE_TO_SEMI_JOIN, CoreRules.JOIN_TO_SEMI_JOIN, CoreRules.MATCH, CalciteSystemProperty.COMMUTE.value() != false ? CoreRules.JOIN_ASSOCIATE : CoreRules.PROJECT_MERGE, CoreRules.AGGREGATE_STAR_TABLE, CoreRules.AGGREGATE_PROJECT_STAR_TABLE, CoreRules.FILTER_SCAN, CoreRules.FILTER_PROJECT_TRANSPOSE, CoreRules.FILTER_INTO_JOIN, CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES, CoreRules.AGGREGATE_REDUCE_FUNCTIONS, CoreRules.FILTER_AGGREGATE_TRANSPOSE, CoreRules.JOIN_COMMUTE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, CoreRules.SORT_PROJECT_TRANSPOSE});

    private Programs() {
    }

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Util.transform(Arrays.asList(ruleSets), Programs::of);
    }

    public static List<Program> listOf(List<RuleSet> ruleSets) {
        return Util.transform(ruleSets, Programs::of);
    }

    public static Program ofRules(RelOptRule ... rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program ofRules(Iterable<? extends RelOptRule> rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program sequence(Program ... programs) {
        return new SequenceProgram((ImmutableList<Program>)ImmutableList.copyOf((Object[])programs));
    }

    public static Program hep(Iterable<? extends RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule relOptRule : rules) {
            builder.addRuleInstance(relOptRule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(HepProgram hepProgram, boolean noDag, RelMetadataProvider metadataProvider) {
        Objects.requireNonNull(metadataProvider, "metadataProvider");
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
            ArrayList list = Lists.newArrayList((Object[])new RelMetadataProvider[]{metadataProvider});
            hepPlanner.registerMetadataProviders(list);
            for (RelOptMaterialization materialization : materializations) {
                hepPlanner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                hepPlanner.addLattice(lattice);
            }
            RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
            rel.getCluster().setMetadataProvider(plannerChain);
            hepPlanner.setRoot(rel);
            return hepPlanner.findBestExp();
        };
    }

    public static Program heuristicJoinOrder(Iterable<? extends RelOptRule> rules, boolean bushy, int minJoinCount) {
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            Program program;
            int joinCount = RelOptUtil.countJoins(rel);
            if (joinCount < minJoinCount) {
                program = Programs.ofRules(rules);
            } else {
                HepProgram hep = new HepProgramBuilder().addRuleInstance(CoreRules.FILTER_INTO_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance(CoreRules.JOIN_TO_MULTI_JOIN).build();
                Program program1 = Programs.of(hep, false, DefaultRelMetadataProvider.INSTANCE);
                ArrayList list = Lists.newArrayList((Iterable)rules);
                list.removeAll((Collection<?>)ImmutableList.of((Object)CoreRules.JOIN_COMMUTE, (Object)CoreRules.JOIN_ASSOCIATE, (Object)JoinPushThroughJoinRule.LEFT, (Object)JoinPushThroughJoinRule.RIGHT));
                list.add(bushy ? CoreRules.MULTI_JOIN_OPTIMIZE_BUSHY : CoreRules.MULTI_JOIN_OPTIMIZE);
                Program program2 = Programs.ofRules(list);
                program = Programs.sequence(program1, program2);
            }
            return program.run(planner, rel, requiredOutputTraits, materializations, lattices);
        };
    }

    public static Program calc(RelMetadataProvider metadataProvider) {
        return Programs.hep(RelOptRules.CALC_RULES, true, metadataProvider);
    }

    @Deprecated
    public static Program subquery(RelMetadataProvider metadataProvider) {
        return Programs.subQuery(metadataProvider);
    }

    public static Program subQuery(RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        builder.addRuleCollection((Collection<RelOptRule>)ImmutableList.of((Object)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE, (Object)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE, (Object)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE));
        return Programs.of(builder.build(), true, metadataProvider);
    }

    @Deprecated
    public static Program getProgram() {
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> (RelNode)Nullness.castNonNull(null);
    }

    public static Program standard() {
        return Programs.standard(DefaultRelMetadataProvider.INSTANCE);
    }

    public static Program standard(RelMetadataProvider metadataProvider) {
        Program program1 = (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            RelNode rootRel2;
            for (RelOptMaterialization materialization : materializations) {
                planner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                planner.addLattice(lattice);
            }
            planner.setRoot(rel);
            RelNode relNode = rootRel2 = rel.getTraitSet().equals(requiredOutputTraits) ? rel : planner.changeTraits(rel, requiredOutputTraits);
            assert (rootRel2 != null);
            planner.setRoot(rootRel2);
            RelOptPlanner planner2 = planner.chooseDelegate();
            RelNode rootRel3 = planner2.findBestExp();
            assert (rootRel3 != null) : "could not implement exp";
            return rootRel3;
        };
        return Programs.sequence(Programs.subQuery(metadataProvider), new DecorrelateProgram(), new TrimFieldsProgram(), program1, Programs.calc(metadataProvider));
    }

    private static class TrimFieldsProgram
    implements Program {
        private TrimFieldsProgram() {
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            return new RelFieldTrimmer(null, relBuilder).trim(rel);
        }
    }

    private static class DecorrelateProgram
    implements Program {
        private DecorrelateProgram() {
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            CalciteConnectionConfig config = planner.getContext().maybeUnwrap(CalciteConnectionConfig.class).orElse(CalciteConnectionConfig.DEFAULT);
            if (config.forceDecorrelate()) {
                RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
                return RelDecorrelator.decorrelateQuery(rel, relBuilder);
            }
            return rel;
        }
    }

    private static class SequenceProgram
    implements Program {
        private final ImmutableList<Program> programs;

        SequenceProgram(ImmutableList<Program> programs) {
            this.programs = programs;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            for (Program program : this.programs) {
                rel = program.run(planner, rel, requiredOutputTraits, materializations, lattices);
            }
            return rel;
        }
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            for (RelOptMaterialization materialization : materializations) {
                planner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                planner.addLattice(lattice);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

