/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.TimeString;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TimeWithTimeZoneString
implements Comparable<TimeWithTimeZoneString> {
    final TimeString localTime;
    final TimeZone timeZone;
    final String v;

    public TimeWithTimeZoneString(TimeString localTime, TimeZone timeZone) {
        this.localTime = localTime;
        this.timeZone = timeZone;
        this.v = localTime.toString() + " " + timeZone.getID();
    }

    public TimeWithTimeZoneString(String v) {
        this.localTime = new TimeString(v.substring(0, 8));
        String timeZoneString = v.substring(9);
        Preconditions.checkArgument((boolean)DateTimeStringUtils.isValidTimeZone(timeZoneString));
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.v = v;
    }

    public TimeWithTimeZoneString(int h, int m, int s, String timeZone) {
        this(DateTimeStringUtils.hms(new StringBuilder(), h, m, s).toString() + " " + timeZone);
    }

    public TimeWithTimeZoneString withMillis(int millis) {
        Preconditions.checkArgument((millis >= 0 && millis < 1000 ? 1 : 0) != 0);
        return this.withFraction(DateTimeStringUtils.pad(3, millis));
    }

    public TimeWithTimeZoneString withNanos(int nanos) {
        Preconditions.checkArgument((nanos >= 0 && nanos < 1000000000 ? 1 : 0) != 0);
        return this.withFraction(DateTimeStringUtils.pad(9, nanos));
    }

    public TimeWithTimeZoneString withFraction(String fraction) {
        String v = this.v;
        int i = v.indexOf(46);
        v = i >= 0 ? v.substring(0, i) : v.substring(0, 8);
        while (fraction.endsWith("0")) {
            fraction = fraction.substring(0, fraction.length() - 1);
        }
        if (fraction.length() > 0) {
            v = v + "." + fraction;
        }
        v = v + this.v.substring(8);
        return new TimeWithTimeZoneString(v);
    }

    public TimeWithTimeZoneString withTimeZone(TimeZone timeZone) {
        String fraction;
        String v;
        if (this.timeZone.equals(timeZone)) {
            return this;
        }
        String localTimeString = this.localTime.toString();
        int i = localTimeString.indexOf(46);
        if (i >= 0) {
            v = localTimeString.substring(0, i);
            fraction = localTimeString.substring(i + 1);
        } else {
            v = localTimeString;
            fraction = null;
        }
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral((String)v, (DateFormat)new SimpleDateFormat("HH:mm:ss", Locale.ROOT), (TimeZone)this.timeZone, (int)-1);
        pt.getCalendar().setTimeZone(timeZone);
        if (fraction != null) {
            return new TimeWithTimeZoneString(pt.getCalendar().get(11), pt.getCalendar().get(12), pt.getCalendar().get(13), timeZone.getID()).withFraction(fraction);
        }
        return new TimeWithTimeZoneString(pt.getCalendar().get(11), pt.getCalendar().get(12), pt.getCalendar().get(13), timeZone.getID());
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof TimeWithTimeZoneString && ((TimeWithTimeZoneString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(TimeWithTimeZoneString o) {
        return this.v.compareTo(o.v);
    }

    public TimeWithTimeZoneString round(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0);
        return new TimeWithTimeZoneString(this.localTime.round(precision), this.timeZone);
    }

    public static TimeWithTimeZoneString fromMillisOfDay(int i) {
        return new TimeWithTimeZoneString(DateTimeUtils.unixTimeToString((int)i) + " " + DateTimeUtils.UTC_ZONE.getID()).withMillis((int)Math.floorMod((long)i, 1000L));
    }

    public String toString(int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0);
        return this.localTime.toString(precision) + " " + this.timeZone.getID();
    }

    public TimeString getLocalTimeString() {
        return this.localTime;
    }
}

