/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.apache.sis.internal.coverage.j2d.FillValues;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.collection.WeakHashSet;

public class TilePlaceholder {
    public static final boolean PENDING_JDK_FIX = true;
    private static final WeakHashSet<TilePlaceholder> CACHE = new WeakHashSet<TilePlaceholder>(TilePlaceholder.class);
    protected final SampleModel model;
    private BufferRef reference;

    protected TilePlaceholder(SampleModel sampleModel) {
        ArgumentChecks.ensureNonNull("model", sampleModel);
        this.model = sampleModel;
    }

    public static TilePlaceholder empty(SampleModel sampleModel) {
        return CACHE.unique(new TilePlaceholder(sampleModel));
    }

    public static TilePlaceholder filled(SampleModel sampleModel, Number number) {
        if (number == null) {
            return TilePlaceholder.empty(sampleModel);
        }
        Object[] objectArray = new Number[sampleModel.getNumBands()];
        Arrays.fill(objectArray, number);
        return TilePlaceholder.filled(sampleModel, new FillValues(sampleModel, (Number[])objectArray, true));
    }

    public static TilePlaceholder filled(SampleModel sampleModel, FillValues fillValues) {
        return CACHE.unique(fillValues.isFullyZero ? new TilePlaceholder(sampleModel) : new Filled(sampleModel, fillValues));
    }

    public static TilePlaceholder withCross(RenderedImage renderedImage) {
        return CACHE.unique(new WithCross(renderedImage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Raster create(Point point) {
        DataBuffer dataBuffer;
        TilePlaceholder tilePlaceholder = this;
        synchronized (tilePlaceholder) {
            if (this.reference == null || (dataBuffer = (DataBuffer)this.reference.get()) == null) {
                dataBuffer = this.model.createDataBuffer();
                this.reference = new BufferRef(this, dataBuffer);
                if (this.getClass() != TilePlaceholder.class) {
                    WritableRaster writableRaster = Raster.createWritableRaster(this.model, dataBuffer, point);
                    this.draw(writableRaster);
                    return writableRaster;
                }
            }
        }
        return Raster.createRaster(this.model, dataBuffer, point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCreatorOf(Raster raster) {
        if (raster != null) {
            BufferRef bufferRef;
            TilePlaceholder tilePlaceholder = this;
            synchronized (tilePlaceholder) {
                bufferRef = this.reference;
            }
            if (bufferRef != null) {
                return bufferRef.get() == raster.getDataBuffer();
            }
        }
        return false;
    }

    protected void draw(WritableRaster writableRaster) {
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.model.equals(((TilePlaceholder)object).model);
    }

    public int hashCode() {
        return this.getClass().hashCode() - this.model.hashCode();
    }

    private static final class Filled
    extends TilePlaceholder {
        private final FillValues fill;

        Filled(SampleModel sampleModel, FillValues fillValues) {
            super(sampleModel);
            this.fill = fillValues;
        }

        @Override
        protected void draw(WritableRaster writableRaster) {
            this.fill.fill(writableRaster);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.fill.equals(((Filled)object).fill);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.fill.hashCode();
        }
    }

    private static final class WithCross
    extends TilePlaceholder {
        private final double[] samples;

        WithCross(RenderedImage renderedImage) {
            super(renderedImage.getSampleModel());
            this.samples = new double[this.model.getNumBands()];
            if (ImageUtilities.isIntegerType(this.model)) {
                boolean bl = ImageUtilities.isUnsignedType(this.model);
                for (int i = 0; i < this.samples.length; ++i) {
                    int n = this.model.getSampleSize(i);
                    if (!bl) {
                        --n;
                    }
                    this.samples[i] = Numerics.bitmask(n) - 1L;
                }
            } else {
                ColorSpace colorSpace;
                ColorModel colorModel = renderedImage.getColorModel();
                if (colorModel != null && (colorSpace = colorModel.getColorSpace()) != null) {
                    int n = Math.min(colorSpace.getNumComponents(), this.samples.length);
                    while (--n >= 0) {
                        this.samples[n] = colorSpace.getMaxValue(n);
                    }
                } else {
                    Arrays.fill(this.samples, 1.0);
                }
            }
        }

        @Override
        protected void draw(WritableRaster writableRaster) {
            int n;
            int n2 = writableRaster.getWidth();
            int n3 = writableRaster.getHeight();
            int n4 = writableRaster.getMinX();
            int n5 = writableRaster.getMinY();
            int n6 = n2 + n4 - 1;
            int n7 = n3 + n5 - 1;
            if (n3 >= 4) {
                for (n = n4; n <= n6; ++n) {
                    writableRaster.setPixel(n, n7 - 1, this.samples);
                    writableRaster.setPixel(n, n5, this.samples);
                    if (++n > n6) break;
                    writableRaster.setPixel(n, n5 + 1, this.samples);
                    writableRaster.setPixel(n, n7, this.samples);
                }
            }
            if (n2 >= 4) {
                for (n = n5; n <= n7; ++n) {
                    writableRaster.setPixel(n6 - 1, n, this.samples);
                    writableRaster.setPixel(n4, n, this.samples);
                    if (++n > n7) break;
                    writableRaster.setPixel(n4 + 1, n, this.samples);
                    writableRaster.setPixel(n6, n, this.samples);
                }
            }
            if (n2 >= n3) {
                double d = (double)n3 / (double)n2;
                int n8 = n7 + n5;
                for (int i = n4; i <= n6; ++i) {
                    int n9 = n5 + (int)((double)(i - n4) * d);
                    int n10 = Math.min(i + 1, n6);
                    for (int j = Math.max(i - 1, n4); j <= n10; ++j) {
                        writableRaster.setPixel(j, n9, this.samples);
                        writableRaster.setPixel(j, n8 - n9, this.samples);
                    }
                }
            } else {
                double d = (double)n2 / (double)n3;
                int n11 = n6 + n4;
                for (int i = n5; i <= n7; ++i) {
                    int n12 = n4 + (int)((double)(i - n5) * d);
                    int n13 = Math.min(i + 1, n7);
                    for (int j = Math.max(i - 1, n5); j <= n13; ++j) {
                        writableRaster.setPixel(n12, j, this.samples);
                        writableRaster.setPixel(n11 - n12, j, this.samples);
                    }
                }
            }
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && Arrays.equals(((WithCross)object).samples, this.samples);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + Arrays.hashCode(this.samples);
        }
    }

    private static final class BufferRef
    extends WeakReference<DataBuffer>
    implements Disposable {
        private TilePlaceholder owner;

        BufferRef(TilePlaceholder tilePlaceholder, DataBuffer dataBuffer) {
            super(dataBuffer, ReferenceQueueConsumer.QUEUE);
            this.owner = tilePlaceholder;
        }

        @Override
        public void dispose() {
            this.owner = null;
        }
    }
}

