import { CallHierarchyIncomingCall, CallHierarchyItem, CallHierarchyOutgoingCall, CancellationToken, CodeAction, CodeActionContext, CodeLens, CompletionContext, DefinitionLink, Diagnostic, DocumentHighlight, FoldingRange, Hover, InlayHint, Location, Position, Range, ReferenceContext, SelectionRange, SemanticTokens, SignatureHelp, SignatureHelpContext, SymbolInformation, TextDocumentContentChangeEvent, WorkspaceEdit } from 'vscode-languageserver';
import { Document, DocumentManager } from '../../lib/documents';
import { LSConfigManager } from '../../ls-config';
import { AppCompletionItem, AppCompletionList, CallHierarchyProvider, CodeActionsProvider, CodeLensProvider, CompletionsProvider, DefinitionsProvider, DiagnosticsProvider, DocumentHighlightProvider, DocumentSymbolsProvider, FileReferencesProvider, FileRename, FindComponentReferencesProvider, FindReferencesProvider, FoldingRangeProvider, HoverProvider, ImplementationProvider, InlayHintProvider, OnWatchFileChanges, OnWatchFileChangesPara, RenameProvider, SelectionRangeProvider, SemanticTokensProvider, SignatureHelpProvider, TypeDefinitionProvider, UpdateImportsProvider, UpdateTsOrJsFile } from '../interfaces';
import { LSAndTSDocResolver } from './LSAndTSDocResolver';
import { CompletionResolveInfo } from './features/CompletionProvider';
export declare class TypeScriptPlugin implements DiagnosticsProvider, HoverProvider, DocumentSymbolsProvider, DefinitionsProvider, CodeActionsProvider, UpdateImportsProvider, RenameProvider, FindReferencesProvider, FileReferencesProvider, FindComponentReferencesProvider, SelectionRangeProvider, SignatureHelpProvider, SemanticTokensProvider, DocumentHighlightProvider, ImplementationProvider, TypeDefinitionProvider, InlayHintProvider, CallHierarchyProvider, FoldingRangeProvider, CodeLensProvider, OnWatchFileChanges, CompletionsProvider<CompletionResolveInfo>, UpdateTsOrJsFile {
    __name: string;
    private readonly configManager;
    private readonly documentManager;
    private readonly lsAndTsDocResolver;
    private readonly completionProvider;
    private readonly codeActionsProvider;
    private readonly updateImportsProvider;
    private readonly diagnosticsProvider;
    private readonly renameProvider;
    private readonly hoverProvider;
    private readonly findReferencesProvider;
    private readonly findFileReferencesProvider;
    private readonly findComponentReferencesProvider;
    private readonly selectionRangeProvider;
    private readonly signatureHelpProvider;
    private readonly semanticTokensProvider;
    private readonly implementationProvider;
    private readonly typeDefinitionProvider;
    private readonly inlayHintProvider;
    private readonly foldingRangeProvider;
    private readonly callHierarchyProvider;
    private readonly codLensProvider;
    private readonly documentHeightProvider;
    constructor(configManager: LSConfigManager, lsAndTsDocResolver: LSAndTSDocResolver, workspaceUris: string[], documentManager: DocumentManager);
    getDiagnostics(document: Document, cancellationToken?: CancellationToken): Promise<Diagnostic[]>;
    doHover(document: Document, position: Position): Promise<Hover | null>;
    getDocumentSymbols(document: Document, cancellationToken?: CancellationToken): Promise<SymbolInformation[]>;
    getCompletions(document: Document, position: Position, completionContext?: CompletionContext, cancellationToken?: CancellationToken): Promise<AppCompletionList<CompletionResolveInfo> | null>;
    resolveCompletion(document: Document, completionItem: AppCompletionItem<CompletionResolveInfo>, cancellationToken?: CancellationToken): Promise<AppCompletionItem<CompletionResolveInfo>>;
    getDefinitions(document: Document, position: Position): Promise<DefinitionLink[]>;
    prepareRename(document: Document, position: Position): Promise<Range | null>;
    rename(document: Document, position: Position, newName: string): Promise<WorkspaceEdit | null>;
    getCodeActions(document: Document, range: Range, context: CodeActionContext, cancellationToken?: CancellationToken): Promise<CodeAction[]>;
    resolveCodeAction(document: Document, codeAction: CodeAction, cancellationToken?: CancellationToken | undefined): Promise<CodeAction>;
    executeCommand(document: Document, command: string, args?: any[]): Promise<WorkspaceEdit | null>;
    updateImports(fileRename: FileRename): Promise<WorkspaceEdit | null>;
    findReferences(document: Document, position: Position, context: ReferenceContext): Promise<Location[] | null>;
    fileReferences(uri: string): Promise<Location[] | null>;
    findComponentReferences(uri: string): Promise<Location[] | null>;
    onWatchFileChanges(onWatchFileChangesParas: OnWatchFileChangesPara[]): Promise<void>;
    updateTsOrJsFile(fileName: string, changes: TextDocumentContentChangeEvent[]): Promise<void>;
    getSelectionRange(document: Document, position: Position): Promise<SelectionRange | null>;
    getSignatureHelp(document: Document, position: Position, context: SignatureHelpContext | undefined, cancellationToken?: CancellationToken): Promise<SignatureHelp | null>;
    getSemanticTokens(textDocument: Document, range?: Range, cancellationToken?: CancellationToken): Promise<SemanticTokens | null>;
    getImplementation(document: Document, position: Position, cancellationToken?: CancellationToken): Promise<Location[] | null>;
    getTypeDefinition(document: Document, position: Position): Promise<Location[] | null>;
    getInlayHints(document: Document, range: Range, cancellationToken?: CancellationToken): Promise<InlayHint[] | null>;
    prepareCallHierarchy(document: Document, position: Position, cancellationToken?: CancellationToken): Promise<CallHierarchyItem[] | null>;
    getIncomingCalls(item: CallHierarchyItem, cancellationToken?: CancellationToken | undefined): Promise<CallHierarchyIncomingCall[] | null>;
    getOutgoingCalls(item: CallHierarchyItem, cancellationToken?: CancellationToken | undefined): Promise<CallHierarchyOutgoingCall[] | null>;
    getFoldingRanges(document: Document): Promise<FoldingRange[]>;
    getCodeLens(document: Document): Promise<CodeLens[] | null>;
    resolveCodeLens(document: Document, codeLensToResolve: CodeLens, cancellationToken?: CancellationToken): Promise<CodeLens>;
    findDocumentHighlight(document: Document, position: Position): Promise<DocumentHighlight[] | null>;
    private featureEnabled;
}
