"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const utils_1 = require("../utils");
const twoslashTemplateReg = /<!--\s*\^\?\s*-->/g;
const twoslashScriptReg = /(?<=^|\n)\s*\/\/\s*\^\?/g;
function create({ getQuickInfoAtPosition }) {
    return {
        name: 'vue-twoslash-queries',
        capabilities: {
            inlayHintProvider: {},
        },
        create(context) {
            return {
                async provideInlayHints(document, range) {
                    const info = (0, utils_1.getEmbeddedInfo)(context, document, id => id === 'template' || id.startsWith('script_'));
                    if (!info) {
                        return;
                    }
                    const { sourceScript, virtualCode, root } = info;
                    const hoverOffsets = [];
                    const inlayHints = [];
                    const twoslashReg = virtualCode.id === 'template' ? twoslashTemplateReg : twoslashScriptReg;
                    for (const pointer of document.getText(range).matchAll(twoslashReg)) {
                        const offset = pointer.index + pointer[0].indexOf('^?') + document.offsetAt(range.start);
                        const position = document.positionAt(offset);
                        hoverOffsets.push([
                            position,
                            document.offsetAt({
                                line: position.line - 1,
                                character: position.character,
                            }),
                        ]);
                    }
                    const sourceDocument = context.documents.get(sourceScript.id, sourceScript.languageId, sourceScript.snapshot);
                    for (const [pointerPosition, hoverOffset] of hoverOffsets) {
                        const map = context.language.maps.get(virtualCode, sourceScript);
                        for (const [sourceOffset] of map.toSourceLocation(hoverOffset)) {
                            const quickInfo = await getQuickInfoAtPosition(root.fileName, sourceDocument.positionAt(sourceOffset));
                            if (quickInfo) {
                                inlayHints.push({
                                    position: { line: pointerPosition.line, character: pointerPosition.character + 2 },
                                    label: quickInfo,
                                    paddingLeft: true,
                                    paddingRight: false,
                                });
                                break;
                            }
                        }
                    }
                    return inlayHints;
                },
            };
        },
    };
}
//# sourceMappingURL=vue-twoslash-queries.js.map