"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentEvents = getComponentEvents;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getComponentEvents(fileName, tag) {
    const { typescript: ts, language, languageService } = this;
    const sourceScript = language.scripts.get(fileName);
    const root = sourceScript?.generated?.root;
    if (!sourceScript?.generated || !(root instanceof language_core_1.VueVirtualCode)) {
        return [];
    }
    const program = languageService.getProgram();
    const checker = program.getTypeChecker();
    const components = (0, utils_1.getVariableType)(ts, languageService, root, '__VLS_components');
    if (!components) {
        return [];
    }
    const componentType = (0, utils_1.getComponentType)(ts, languageService, root, components, fileName, tag);
    if (!componentType) {
        return [];
    }
    const result = new Set();
    // for (const sig of componentType.getCallSignatures()) {
    // 	const emitParam = sig.parameters[1];
    // 	if (emitParam) {
    // 		// TODO
    // 	}
    // }
    for (const sig of componentType.getConstructSignatures()) {
        const instanceType = sig.getReturnType();
        const emitSymbol = instanceType.getProperty('$emit');
        if (emitSymbol) {
            const emitType = checker.getTypeOfSymbolAtLocation(emitSymbol, components.node);
            for (const call of emitType.getCallSignatures()) {
                const eventNameParamSymbol = call.parameters[0];
                if (eventNameParamSymbol) {
                    const eventNameParamType = checker.getTypeOfSymbolAtLocation(eventNameParamSymbol, components.node);
                    if (eventNameParamType.isStringLiteral()) {
                        result.add(eventNameParamType.value);
                    }
                }
            }
        }
    }
    return [...result];
}
//# sourceMappingURL=getComponentEvents.js.map