/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2021 Sifive.
 */
#ifndef ASM_ERRATA_LIST_H
#define ASM_ERRATA_LIST_H

#include <asm/alternative.h>
#include <asm/csr.h>
#include <asm/insn-def.h>
#include <asm/hwcap.h>
#include <asm/vendorid_list.h>

#ifdef CONFIG_ERRATA_ANDES
#define ERRATA_ANDESTECH_NO_IOCP	0
#define ERRATA_ANDESTECH_NUMBER		1
#endif

#ifdef CONFIG_ERRATA_SIFIVE
#define	ERRATA_SIFIVE_CIP_453 0
#define	ERRATA_SIFIVE_CIP_1200 1
#define	ERRATA_SIFIVE_NUMBER 2
#endif

#ifdef CONFIG_ERRATA_THEAD
#define	ERRATA_THEAD_PBMT 0
#define	ERRATA_THEAD_PMU 1
#define ERRATA_THEAD_VECTOR 2
#define	ERRATA_THEAD_NUMBER 3
#endif

#ifdef __ASSEMBLY__

#define ALT_INSN_FAULT(x)						\
ALTERNATIVE(__stringify(RISCV_PTR do_trap_insn_fault),			\
	    __stringify(RISCV_PTR sifive_cip_453_insn_fault_trp),	\
	    SIFIVE_VENDOR_ID, ERRATA_SIFIVE_CIP_453,			\
	    CONFIG_ERRATA_SIFIVE_CIP_453)

#define ALT_PAGE_FAULT(x)						\
ALTERNATIVE(__stringify(RISCV_PTR do_page_fault),			\
	    __stringify(RISCV_PTR sifive_cip_453_page_fault_trp),	\
	    SIFIVE_VENDOR_ID, ERRATA_SIFIVE_CIP_453,			\
	    CONFIG_ERRATA_SIFIVE_CIP_453)
#else /* !__ASSEMBLY__ */

#define ALT_FLUSH_TLB_PAGE(x)						\
asm(ALTERNATIVE("sfence.vma %0", "sfence.vma", SIFIVE_VENDOR_ID,	\
		ERRATA_SIFIVE_CIP_1200, CONFIG_ERRATA_SIFIVE_CIP_1200)	\
		: : "r" (addr) : "memory")

/*
 * _val is marked as "will be overwritten", so need to set it to 0
 * in the default case.
 */
#define ALT_SVPBMT_SHIFT 61
#define ALT_THEAD_PBMT_SHIFT 59
#define ALT_SVPBMT(_val, prot)						\
asm(ALTERNATIVE_2("li %0, 0\t\nnop",					\
		  "li %0, %1\t\nslli %0,%0,%3", 0,			\
			RISCV_ISA_EXT_SVPBMT, CONFIG_RISCV_ISA_SVPBMT,	\
		  "li %0, %2\t\nslli %0,%0,%4", THEAD_VENDOR_ID,	\
			ERRATA_THEAD_PBMT, CONFIG_ERRATA_THEAD_PBMT)	\
		: "=r"(_val)						\
		: "I"(prot##_SVPBMT >> ALT_SVPBMT_SHIFT),		\
		  "I"(prot##_THEAD >> ALT_THEAD_PBMT_SHIFT),		\
		  "I"(ALT_SVPBMT_SHIFT),				\
		  "I"(ALT_THEAD_PBMT_SHIFT))

#ifdef CONFIG_ERRATA_THEAD_PBMT
/*
 * IO/NOCACHE memory types are handled together with svpbmt,
 * so on T-Head chips, check if no other memory type is set,
 * and set the non-0 PMA type if applicable.
 */
#define ALT_THEAD_PMA(_val)						\
asm volatile(ALTERNATIVE(						\
	__nops(7),							\
	"li      t3, %1\n\t"						\
	"slli    t3, t3, %3\n\t"					\
	"and     t3, %0, t3\n\t"					\
	"bne     t3, zero, 2f\n\t"					\
	"li      t3, %2\n\t"						\
	"slli    t3, t3, %3\n\t"					\
	"or      %0, %0, t3\n\t"					\
	"2:",  THEAD_VENDOR_ID,						\
		ERRATA_THEAD_PBMT, CONFIG_ERRATA_THEAD_PBMT)		\
	: "+r"(_val)							\
	: "I"(_PAGE_MTMASK_THEAD >> ALT_THEAD_PBMT_SHIFT),		\
	  "I"(_PAGE_PMA_THEAD >> ALT_THEAD_PBMT_SHIFT),			\
	  "I"(ALT_THEAD_PBMT_SHIFT)					\
	: "t3")
#else
#define ALT_THEAD_PMA(_val)
#endif

#define ALT_CMO_OP(_op, _start, _size, _cachesize)			\
asm volatile(ALTERNATIVE(						\
	__nops(5),							\
	"mv a0, %1\n\t"							\
	"j 2f\n\t"							\
	"3:\n\t"							\
	CBO_##_op(a0)							\
	"add a0, a0, %0\n\t"						\
	"2:\n\t"							\
	"bltu a0, %2, 3b\n\t",						\
	0, RISCV_ISA_EXT_ZICBOM, CONFIG_RISCV_ISA_ZICBOM)		\
	: : "r"(_cachesize),						\
	    "r"((unsigned long)(_start) & ~((_cachesize) - 1UL)),	\
	    "r"((unsigned long)(_start) + (_size))			\
	: "a0")

#define THEAD_C9XX_RV_IRQ_PMU			17
#define THEAD_C9XX_CSR_SCOUNTEROF		0x5c5

#define ALT_SBI_PMU_OVERFLOW(__ovl)					\
asm volatile(ALTERNATIVE(						\
	"csrr %0, " __stringify(CSR_SSCOUNTOVF),			\
	"csrr %0, " __stringify(THEAD_C9XX_CSR_SCOUNTEROF),		\
		THEAD_VENDOR_ID, ERRATA_THEAD_PMU,			\
		CONFIG_ERRATA_THEAD_PMU)				\
	: "=r" (__ovl) :						\
	: "memory")

#define THEAD_C9XX_CSR_VXSAT			0x9
#define THEAD_C9XX_CSR_VXRM			0xa

	/*
	 * Vector 0.7.1 as used for example on T-Head Xuantie cores, uses an older
	 * encoding for vsetvli (ta, ma vs. d1), so provide an instruction for
	 * vsetvli	t4, x0, e8, m8, d1
	 */
#define THEAD_VSETVLI_T4X0E8M8D1	".long	0x00307ed7\n\t"

	/*
	 * While in theory, the vector-0.7.1 vsb.v and vlb.v result in the same
	 * encoding as the standard vse8.v and vle8.v, compilers seem to optimize
	 * the call resulting in a different encoding and then using a value for
	 * the "mop" field that is not part of vector-0.7.1
	 * So encode specific variants for vstate_save and _restore.
	 */
#define THEAD_VSB_V_V0T0		".long	0x02028027\n\t"
#define THEAD_VSB_V_V8T0		".long	0x02028427\n\t"
#define THEAD_VSB_V_V16T0		".long	0x02028827\n\t"
#define THEAD_VSB_V_V24T0		".long	0x02028c27\n\t"
#define THEAD_VLB_V_V0T0		".long	0x012028007\n\t"
#define THEAD_VLB_V_V8T0		".long	0x012028407\n\t"
#define THEAD_VLB_V_V16T0		".long	0x012028807\n\t"
#define THEAD_VLB_V_V24T0		".long	0x012028c07\n\t"

#define ALT_SR_VS_VECTOR_1_0_SHIFT	9
#define ALT_SR_VS_THEAD_SHIFT		23

#ifdef CONFIG_ERRATA_THEAD_VECTOR
#define ALT_SR_VS(_val, prot)							\
	asm(ALTERNATIVE("li %0, %1\t\nslli %0,%0,%3",				\
			"li %0, %2\t\nslli %0,%0,%4", THEAD_VENDOR_ID,		\
			ERRATA_THEAD_VECTOR, CONFIG_ERRATA_THEAD_VECTOR)	\
			: "=r"(_val)						\
			: "I"(prot >> ALT_SR_VS_VECTOR_1_0_SHIFT),		\
			  "I"(prot##_THEAD >> ALT_SR_VS_THEAD_SHIFT),		\
			  "I"(ALT_SR_VS_VECTOR_1_0_SHIFT),			\
			  "I"(ALT_SR_VS_THEAD_SHIFT))
#else
#define ALT_SR_VS(_val, prot) _val = prot;
#endif /* CONFIG_ERRATA_THEAD_VECTOR */

#endif /* __ASSEMBLY__ */

#endif
