package org.bouncycastle.openpgp.operator;

import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;

/**
 * An encryption method that can be applied to encrypt data in a {@link PGPEncryptedDataGenerator}.
 */
public abstract class PGPKeyEncryptionMethodGenerator
{
    /**
     * Generates a packet encoding the details of this encryption method.
     * 
     * @param encAlgorithm the {@link SymmetricKeyAlgorithmTags encryption algorithm} being used
     * @param sessionInfo session data generated by the encrypted data generator.
     * @return a packet encoding the provided information and the configuration of this instance.
     * @throws PGPException if an error occurs constructing the packet.
     */
    public abstract ContainedPacket generate(int encAlgorithm, byte[] sessionInfo)
        throws PGPException;
}
