//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armconsumption

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type BudgetComparisonExpression.
func (b BudgetComparisonExpression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", b.Name)
	populate(objectMap, "operator", b.Operator)
	populate(objectMap, "values", b.Values)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BudgetFilter.
func (b BudgetFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "and", b.And)
	populate(objectMap, "dimensions", b.Dimensions)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BudgetProperties.
func (b BudgetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "amount", b.Amount)
	populate(objectMap, "category", b.Category)
	populate(objectMap, "currentSpend", b.CurrentSpend)
	populate(objectMap, "filter", b.Filter)
	populate(objectMap, "forecastSpend", b.ForecastSpend)
	populate(objectMap, "notifications", b.Notifications)
	populate(objectMap, "timeGrain", b.TimeGrain)
	populate(objectMap, "timePeriod", b.TimePeriod)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BudgetTimePeriod.
func (b BudgetTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endDate", b.EndDate)
	populateTimeRFC3339(objectMap, "startDate", b.StartDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BudgetTimePeriod.
func (b *BudgetTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endDate":
			err = unpopulateTimeRFC3339(val, "EndDate", &b.EndDate)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateTimeRFC3339(val, "StartDate", &b.StartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChargesListResult.
func (c *ChargesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			c.Value, err = unmarshalChargeSummaryClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventProperties.
func (e EventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adjustments", e.Adjustments)
	populate(objectMap, "adjustmentsInBillingCurrency", e.AdjustmentsInBillingCurrency)
	populate(objectMap, "billingCurrency", e.BillingCurrency)
	populate(objectMap, "billingProfileDisplayName", e.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", e.BillingProfileID)
	populate(objectMap, "canceledCredit", e.CanceledCredit)
	populate(objectMap, "charges", e.Charges)
	populate(objectMap, "chargesInBillingCurrency", e.ChargesInBillingCurrency)
	populate(objectMap, "closedBalance", e.ClosedBalance)
	populate(objectMap, "closedBalanceInBillingCurrency", e.ClosedBalanceInBillingCurrency)
	populate(objectMap, "creditCurrency", e.CreditCurrency)
	populate(objectMap, "creditExpired", e.CreditExpired)
	populate(objectMap, "creditExpiredInBillingCurrency", e.CreditExpiredInBillingCurrency)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "eTag", e.ETag)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "invoiceNumber", e.InvoiceNumber)
	populate(objectMap, "lotId", e.LotID)
	populate(objectMap, "lotSource", e.LotSource)
	populate(objectMap, "newCredit", e.NewCredit)
	populate(objectMap, "newCreditInBillingCurrency", e.NewCreditInBillingCurrency)
	populate(objectMap, "reseller", e.Reseller)
	populateTimeRFC3339(objectMap, "transactionDate", e.TransactionDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventProperties.
func (e *EventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adjustments":
			err = unpopulate(val, "Adjustments", &e.Adjustments)
			delete(rawMsg, key)
		case "adjustmentsInBillingCurrency":
			err = unpopulate(val, "AdjustmentsInBillingCurrency", &e.AdjustmentsInBillingCurrency)
			delete(rawMsg, key)
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &e.BillingCurrency)
			delete(rawMsg, key)
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &e.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &e.BillingProfileID)
			delete(rawMsg, key)
		case "canceledCredit":
			err = unpopulate(val, "CanceledCredit", &e.CanceledCredit)
			delete(rawMsg, key)
		case "charges":
			err = unpopulate(val, "Charges", &e.Charges)
			delete(rawMsg, key)
		case "chargesInBillingCurrency":
			err = unpopulate(val, "ChargesInBillingCurrency", &e.ChargesInBillingCurrency)
			delete(rawMsg, key)
		case "closedBalance":
			err = unpopulate(val, "ClosedBalance", &e.ClosedBalance)
			delete(rawMsg, key)
		case "closedBalanceInBillingCurrency":
			err = unpopulate(val, "ClosedBalanceInBillingCurrency", &e.ClosedBalanceInBillingCurrency)
			delete(rawMsg, key)
		case "creditCurrency":
			err = unpopulate(val, "CreditCurrency", &e.CreditCurrency)
			delete(rawMsg, key)
		case "creditExpired":
			err = unpopulate(val, "CreditExpired", &e.CreditExpired)
			delete(rawMsg, key)
		case "creditExpiredInBillingCurrency":
			err = unpopulate(val, "CreditExpiredInBillingCurrency", &e.CreditExpiredInBillingCurrency)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &e.ETag)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "invoiceNumber":
			err = unpopulate(val, "InvoiceNumber", &e.InvoiceNumber)
			delete(rawMsg, key)
		case "lotId":
			err = unpopulate(val, "LotID", &e.LotID)
			delete(rawMsg, key)
		case "lotSource":
			err = unpopulate(val, "LotSource", &e.LotSource)
			delete(rawMsg, key)
		case "newCredit":
			err = unpopulate(val, "NewCredit", &e.NewCredit)
			delete(rawMsg, key)
		case "newCreditInBillingCurrency":
			err = unpopulate(val, "NewCreditInBillingCurrency", &e.NewCreditInBillingCurrency)
			delete(rawMsg, key)
		case "reseller":
			err = unpopulate(val, "Reseller", &e.Reseller)
			delete(rawMsg, key)
		case "transactionDate":
			err = unpopulateTimeRFC3339(val, "TransactionDate", &e.TransactionDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyChargeSummary.
func (l LegacyChargeSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", l.ETag)
	populate(objectMap, "id", l.ID)
	objectMap["kind"] = ChargeSummaryKindLegacy
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyChargeSummary.
func (l *LegacyChargeSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &l.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyReservationRecommendation.
func (l *LegacyReservationRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			l.Properties, err = unmarshalLegacyReservationRecommendationPropertiesClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &l.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyReservationRecommendationProperties.
func (l *LegacyReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &l.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateTimeRFC3339(val, "FirstUsageDate", &l.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &l.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &l.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &l.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &l.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &l.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &l.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &l.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &l.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &l.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyReservationTransactionProperties.
func (l *LegacyReservationTransactionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &l.AccountName)
			delete(rawMsg, key)
		case "accountOwnerEmail":
			err = unpopulate(val, "AccountOwnerEmail", &l.AccountOwnerEmail)
			delete(rawMsg, key)
		case "amount":
			err = unpopulate(val, "Amount", &l.Amount)
			delete(rawMsg, key)
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &l.ArmSKUName)
			delete(rawMsg, key)
		case "billingFrequency":
			err = unpopulate(val, "BillingFrequency", &l.BillingFrequency)
			delete(rawMsg, key)
		case "billingMonth":
			err = unpopulate(val, "BillingMonth", &l.BillingMonth)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &l.CostCenter)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &l.Currency)
			delete(rawMsg, key)
		case "currentEnrollment":
			err = unpopulate(val, "CurrentEnrollment", &l.CurrentEnrollment)
			delete(rawMsg, key)
		case "departmentName":
			err = unpopulate(val, "DepartmentName", &l.DepartmentName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "eventDate":
			err = unpopulateTimeRFC3339(val, "EventDate", &l.EventDate)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &l.EventType)
			delete(rawMsg, key)
		case "monetaryCommitment":
			err = unpopulate(val, "MonetaryCommitment", &l.MonetaryCommitment)
			delete(rawMsg, key)
		case "overage":
			err = unpopulate(val, "Overage", &l.Overage)
			delete(rawMsg, key)
		case "purchasingEnrollment":
			err = unpopulate(val, "PurchasingEnrollment", &l.PurchasingEnrollment)
			delete(rawMsg, key)
		case "purchasingSubscriptionGuid":
			err = unpopulate(val, "PurchasingSubscriptionGUID", &l.PurchasingSubscriptionGUID)
			delete(rawMsg, key)
		case "purchasingSubscriptionName":
			err = unpopulate(val, "PurchasingSubscriptionName", &l.PurchasingSubscriptionName)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &l.Quantity)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &l.Region)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &l.ReservationOrderID)
			delete(rawMsg, key)
		case "reservationOrderName":
			err = unpopulate(val, "ReservationOrderName", &l.ReservationOrderName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacySharedScopeReservationRecommendationProperties.
func (l *LegacySharedScopeReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &l.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateTimeRFC3339(val, "FirstUsageDate", &l.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &l.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &l.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &l.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &l.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &l.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &l.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &l.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &l.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &l.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacySingleScopeReservationRecommendationProperties.
func (l *LegacySingleScopeReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &l.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateTimeRFC3339(val, "FirstUsageDate", &l.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &l.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &l.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &l.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &l.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &l.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &l.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &l.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &l.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &l.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyUsageDetail.
func (l *LegacyUsageDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyUsageDetailProperties.
func (l *LegacyUsageDetailProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &l.AccountName)
			delete(rawMsg, key)
		case "accountOwnerId":
			err = unpopulate(val, "AccountOwnerID", &l.AccountOwnerID)
			delete(rawMsg, key)
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &l.AdditionalInfo)
			delete(rawMsg, key)
		case "benefitId":
			err = unpopulate(val, "BenefitID", &l.BenefitID)
			delete(rawMsg, key)
		case "benefitName":
			err = unpopulate(val, "BenefitName", &l.BenefitName)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &l.BillingAccountID)
			delete(rawMsg, key)
		case "billingAccountName":
			err = unpopulate(val, "BillingAccountName", &l.BillingAccountName)
			delete(rawMsg, key)
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &l.BillingCurrency)
			delete(rawMsg, key)
		case "billingPeriodEndDate":
			err = unpopulateTimeRFC3339(val, "BillingPeriodEndDate", &l.BillingPeriodEndDate)
			delete(rawMsg, key)
		case "billingPeriodStartDate":
			err = unpopulateTimeRFC3339(val, "BillingPeriodStartDate", &l.BillingPeriodStartDate)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &l.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileName":
			err = unpopulate(val, "BillingProfileName", &l.BillingProfileName)
			delete(rawMsg, key)
		case "chargeType":
			err = unpopulate(val, "ChargeType", &l.ChargeType)
			delete(rawMsg, key)
		case "consumedService":
			err = unpopulate(val, "ConsumedService", &l.ConsumedService)
			delete(rawMsg, key)
		case "cost":
			err = unpopulate(val, "Cost", &l.Cost)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &l.CostCenter)
			delete(rawMsg, key)
		case "date":
			err = unpopulateTimeRFC3339(val, "Date", &l.Date)
			delete(rawMsg, key)
		case "effectivePrice":
			err = unpopulate(val, "EffectivePrice", &l.EffectivePrice)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &l.Frequency)
			delete(rawMsg, key)
		case "invoiceSection":
			err = unpopulate(val, "InvoiceSection", &l.InvoiceSection)
			delete(rawMsg, key)
		case "isAzureCreditEligible":
			err = unpopulate(val, "IsAzureCreditEligible", &l.IsAzureCreditEligible)
			delete(rawMsg, key)
		case "meterDetails":
			err = unpopulate(val, "MeterDetails", &l.MeterDetails)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &l.OfferID)
			delete(rawMsg, key)
		case "partNumber":
			err = unpopulate(val, "PartNumber", &l.PartNumber)
			delete(rawMsg, key)
		case "payGPrice":
			err = unpopulate(val, "PayGPrice", &l.PayGPrice)
			delete(rawMsg, key)
		case "planName":
			err = unpopulate(val, "PlanName", &l.PlanName)
			delete(rawMsg, key)
		case "pricingModel":
			err = unpopulate(val, "PricingModel", &l.PricingModel)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &l.Product)
			delete(rawMsg, key)
		case "productOrderId":
			err = unpopulate(val, "ProductOrderID", &l.ProductOrderID)
			delete(rawMsg, key)
		case "productOrderName":
			err = unpopulate(val, "ProductOrderName", &l.ProductOrderName)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &l.PublisherName)
			delete(rawMsg, key)
		case "publisherType":
			err = unpopulate(val, "PublisherType", &l.PublisherType)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &l.Quantity)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &l.ReservationID)
			delete(rawMsg, key)
		case "reservationName":
			err = unpopulate(val, "ReservationName", &l.ReservationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &l.ResourceGroup)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &l.ResourceLocation)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &l.ResourceName)
			delete(rawMsg, key)
		case "serviceInfo1":
			err = unpopulate(val, "ServiceInfo1", &l.ServiceInfo1)
			delete(rawMsg, key)
		case "serviceInfo2":
			err = unpopulate(val, "ServiceInfo2", &l.ServiceInfo2)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &l.SubscriptionName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "unitPrice":
			err = unpopulate(val, "UnitPrice", &l.UnitPrice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LotProperties.
func (l LotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "billingCurrency", l.BillingCurrency)
	populate(objectMap, "closedBalance", l.ClosedBalance)
	populate(objectMap, "closedBalanceInBillingCurrency", l.ClosedBalanceInBillingCurrency)
	populate(objectMap, "creditCurrency", l.CreditCurrency)
	populate(objectMap, "eTag", l.ETag)
	populateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "originalAmount", l.OriginalAmount)
	populate(objectMap, "originalAmountInBillingCurrency", l.OriginalAmountInBillingCurrency)
	populate(objectMap, "poNumber", l.PoNumber)
	populateTimeRFC3339(objectMap, "purchasedDate", l.PurchasedDate)
	populate(objectMap, "reseller", l.Reseller)
	populate(objectMap, "source", l.Source)
	populateTimeRFC3339(objectMap, "startDate", l.StartDate)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LotProperties.
func (l *LotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &l.BillingCurrency)
			delete(rawMsg, key)
		case "closedBalance":
			err = unpopulate(val, "ClosedBalance", &l.ClosedBalance)
			delete(rawMsg, key)
		case "closedBalanceInBillingCurrency":
			err = unpopulate(val, "ClosedBalanceInBillingCurrency", &l.ClosedBalanceInBillingCurrency)
			delete(rawMsg, key)
		case "creditCurrency":
			err = unpopulate(val, "CreditCurrency", &l.CreditCurrency)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &l.ETag)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "originalAmount":
			err = unpopulate(val, "OriginalAmount", &l.OriginalAmount)
			delete(rawMsg, key)
		case "originalAmountInBillingCurrency":
			err = unpopulate(val, "OriginalAmountInBillingCurrency", &l.OriginalAmountInBillingCurrency)
			delete(rawMsg, key)
		case "poNumber":
			err = unpopulate(val, "PoNumber", &l.PoNumber)
			delete(rawMsg, key)
		case "purchasedDate":
			err = unpopulateTimeRFC3339(val, "PurchasedDate", &l.PurchasedDate)
			delete(rawMsg, key)
		case "reseller":
			err = unpopulate(val, "Reseller", &l.Reseller)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &l.Source)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateTimeRFC3339(val, "StartDate", &l.StartDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementGroupAggregatedCostProperties.
func (m *ManagementGroupAggregatedCostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureCharges":
			err = unpopulate(val, "AzureCharges", &m.AzureCharges)
			delete(rawMsg, key)
		case "billingPeriodId":
			err = unpopulate(val, "BillingPeriodID", &m.BillingPeriodID)
			delete(rawMsg, key)
		case "chargesBilledSeparately":
			err = unpopulate(val, "ChargesBilledSeparately", &m.ChargesBilledSeparately)
			delete(rawMsg, key)
		case "children":
			err = unpopulate(val, "Children", &m.Children)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &m.Currency)
			delete(rawMsg, key)
		case "excludedSubscriptions":
			err = unpopulate(val, "ExcludedSubscriptions", &m.ExcludedSubscriptions)
			delete(rawMsg, key)
		case "includedSubscriptions":
			err = unpopulate(val, "IncludedSubscriptions", &m.IncludedSubscriptions)
			delete(rawMsg, key)
		case "marketplaceCharges":
			err = unpopulate(val, "MarketplaceCharges", &m.MarketplaceCharges)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulateTimeRFC3339(val, "UsageEnd", &m.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulateTimeRFC3339(val, "UsageStart", &m.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MarketplaceProperties.
func (m *MarketplaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &m.AccountName)
			delete(rawMsg, key)
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &m.AdditionalInfo)
			delete(rawMsg, key)
		case "additionalProperties":
			err = unpopulate(val, "AdditionalProperties", &m.AdditionalProperties)
			delete(rawMsg, key)
		case "billingPeriodId":
			err = unpopulate(val, "BillingPeriodID", &m.BillingPeriodID)
			delete(rawMsg, key)
		case "consumedQuantity":
			err = unpopulate(val, "ConsumedQuantity", &m.ConsumedQuantity)
			delete(rawMsg, key)
		case "consumedService":
			err = unpopulate(val, "ConsumedService", &m.ConsumedService)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &m.CostCenter)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &m.Currency)
			delete(rawMsg, key)
		case "departmentName":
			err = unpopulate(val, "DepartmentName", &m.DepartmentName)
			delete(rawMsg, key)
		case "instanceId":
			err = unpopulate(val, "InstanceID", &m.InstanceID)
			delete(rawMsg, key)
		case "instanceName":
			err = unpopulate(val, "InstanceName", &m.InstanceName)
			delete(rawMsg, key)
		case "isEstimated":
			err = unpopulate(val, "IsEstimated", &m.IsEstimated)
			delete(rawMsg, key)
		case "isRecurringCharge":
			err = unpopulate(val, "IsRecurringCharge", &m.IsRecurringCharge)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &m.MeterID)
			delete(rawMsg, key)
		case "offerName":
			err = unpopulate(val, "OfferName", &m.OfferName)
			delete(rawMsg, key)
		case "orderNumber":
			err = unpopulate(val, "OrderNumber", &m.OrderNumber)
			delete(rawMsg, key)
		case "planName":
			err = unpopulate(val, "PlanName", &m.PlanName)
			delete(rawMsg, key)
		case "pretaxCost":
			err = unpopulate(val, "PretaxCost", &m.PretaxCost)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &m.PublisherName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &m.ResourceGroup)
			delete(rawMsg, key)
		case "resourceRate":
			err = unpopulate(val, "ResourceRate", &m.ResourceRate)
			delete(rawMsg, key)
		case "subscriptionGuid":
			err = unpopulate(val, "SubscriptionGUID", &m.SubscriptionGUID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &m.SubscriptionName)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &m.UnitOfMeasure)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulateTimeRFC3339(val, "UsageEnd", &m.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulateTimeRFC3339(val, "UsageStart", &m.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernChargeSummary.
func (m ModernChargeSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", m.ETag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = ChargeSummaryKindModern
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernChargeSummary.
func (m *ModernChargeSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &m.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationRecommendation.
func (m *ModernReservationRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &m.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationRecommendationProperties.
func (m *ModernReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &m.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateTimeRFC3339(val, "FirstUsageDate", &m.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &m.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &m.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &m.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &m.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &m.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &m.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &m.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &m.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &m.SKUName)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &m.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &m.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &m.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &m.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationTransactionProperties.
func (m *ModernReservationTransactionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &m.Amount)
			delete(rawMsg, key)
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &m.ArmSKUName)
			delete(rawMsg, key)
		case "billingFrequency":
			err = unpopulate(val, "BillingFrequency", &m.BillingFrequency)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &m.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileName":
			err = unpopulate(val, "BillingProfileName", &m.BillingProfileName)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &m.Currency)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "eventDate":
			err = unpopulateTimeRFC3339(val, "EventDate", &m.EventDate)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &m.EventType)
			delete(rawMsg, key)
		case "invoice":
			err = unpopulate(val, "Invoice", &m.Invoice)
			delete(rawMsg, key)
		case "invoiceId":
			err = unpopulate(val, "InvoiceID", &m.InvoiceID)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &m.InvoiceSectionID)
			delete(rawMsg, key)
		case "invoiceSectionName":
			err = unpopulate(val, "InvoiceSectionName", &m.InvoiceSectionName)
			delete(rawMsg, key)
		case "purchasingSubscriptionGuid":
			err = unpopulate(val, "PurchasingSubscriptionGUID", &m.PurchasingSubscriptionGUID)
			delete(rawMsg, key)
		case "purchasingSubscriptionName":
			err = unpopulate(val, "PurchasingSubscriptionName", &m.PurchasingSubscriptionName)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &m.Quantity)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &m.Region)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &m.ReservationOrderID)
			delete(rawMsg, key)
		case "reservationOrderName":
			err = unpopulate(val, "ReservationOrderName", &m.ReservationOrderName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &m.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernUsageDetail.
func (m *ModernUsageDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernUsageDetailProperties.
func (m *ModernUsageDetailProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &m.AdditionalInfo)
			delete(rawMsg, key)
		case "benefitId":
			err = unpopulate(val, "BenefitID", &m.BenefitID)
			delete(rawMsg, key)
		case "benefitName":
			err = unpopulate(val, "BenefitName", &m.BenefitName)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &m.BillingAccountID)
			delete(rawMsg, key)
		case "billingAccountName":
			err = unpopulate(val, "BillingAccountName", &m.BillingAccountName)
			delete(rawMsg, key)
		case "billingCurrencyCode":
			err = unpopulate(val, "BillingCurrencyCode", &m.BillingCurrencyCode)
			delete(rawMsg, key)
		case "billingPeriodEndDate":
			err = unpopulateTimeRFC3339(val, "BillingPeriodEndDate", &m.BillingPeriodEndDate)
			delete(rawMsg, key)
		case "billingPeriodStartDate":
			err = unpopulateTimeRFC3339(val, "BillingPeriodStartDate", &m.BillingPeriodStartDate)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &m.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileName":
			err = unpopulate(val, "BillingProfileName", &m.BillingProfileName)
			delete(rawMsg, key)
		case "chargeType":
			err = unpopulate(val, "ChargeType", &m.ChargeType)
			delete(rawMsg, key)
		case "consumedService":
			err = unpopulate(val, "ConsumedService", &m.ConsumedService)
			delete(rawMsg, key)
		case "costAllocationRuleName":
			err = unpopulate(val, "CostAllocationRuleName", &m.CostAllocationRuleName)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &m.CostCenter)
			delete(rawMsg, key)
		case "costInBillingCurrency":
			err = unpopulate(val, "CostInBillingCurrency", &m.CostInBillingCurrency)
			delete(rawMsg, key)
		case "costInPricingCurrency":
			err = unpopulate(val, "CostInPricingCurrency", &m.CostInPricingCurrency)
			delete(rawMsg, key)
		case "costInUSD":
			err = unpopulate(val, "CostInUSD", &m.CostInUSD)
			delete(rawMsg, key)
		case "customerName":
			err = unpopulate(val, "CustomerName", &m.CustomerName)
			delete(rawMsg, key)
		case "customerTenantId":
			err = unpopulate(val, "CustomerTenantID", &m.CustomerTenantID)
			delete(rawMsg, key)
		case "date":
			err = unpopulateTimeRFC3339(val, "Date", &m.Date)
			delete(rawMsg, key)
		case "effectivePrice":
			err = unpopulate(val, "EffectivePrice", &m.EffectivePrice)
			delete(rawMsg, key)
		case "exchangeRate":
			err = unpopulate(val, "ExchangeRate", &m.ExchangeRate)
			delete(rawMsg, key)
		case "exchangeRateDate":
			err = unpopulateTimeRFC3339(val, "ExchangeRateDate", &m.ExchangeRateDate)
			delete(rawMsg, key)
		case "exchangeRatePricingToBilling":
			err = unpopulate(val, "ExchangeRatePricingToBilling", &m.ExchangeRatePricingToBilling)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &m.Frequency)
			delete(rawMsg, key)
		case "instanceName":
			err = unpopulate(val, "InstanceName", &m.InstanceName)
			delete(rawMsg, key)
		case "invoiceId":
			err = unpopulate(val, "InvoiceID", &m.InvoiceID)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &m.InvoiceSectionID)
			delete(rawMsg, key)
		case "invoiceSectionName":
			err = unpopulate(val, "InvoiceSectionName", &m.InvoiceSectionName)
			delete(rawMsg, key)
		case "isAzureCreditEligible":
			err = unpopulate(val, "IsAzureCreditEligible", &m.IsAzureCreditEligible)
			delete(rawMsg, key)
		case "marketPrice":
			err = unpopulate(val, "MarketPrice", &m.MarketPrice)
			delete(rawMsg, key)
		case "meterCategory":
			err = unpopulate(val, "MeterCategory", &m.MeterCategory)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &m.MeterID)
			delete(rawMsg, key)
		case "meterName":
			err = unpopulate(val, "MeterName", &m.MeterName)
			delete(rawMsg, key)
		case "meterRegion":
			err = unpopulate(val, "MeterRegion", &m.MeterRegion)
			delete(rawMsg, key)
		case "meterSubCategory":
			err = unpopulate(val, "MeterSubCategory", &m.MeterSubCategory)
			delete(rawMsg, key)
		case "partnerEarnedCreditApplied":
			err = unpopulate(val, "PartnerEarnedCreditApplied", &m.PartnerEarnedCreditApplied)
			delete(rawMsg, key)
		case "partnerEarnedCreditRate":
			err = unpopulate(val, "PartnerEarnedCreditRate", &m.PartnerEarnedCreditRate)
			delete(rawMsg, key)
		case "partnerName":
			err = unpopulate(val, "PartnerName", &m.PartnerName)
			delete(rawMsg, key)
		case "partnerTenantId":
			err = unpopulate(val, "PartnerTenantID", &m.PartnerTenantID)
			delete(rawMsg, key)
		case "payGPrice":
			err = unpopulate(val, "PayGPrice", &m.PayGPrice)
			delete(rawMsg, key)
		case "paygCostInBillingCurrency":
			err = unpopulate(val, "PaygCostInBillingCurrency", &m.PaygCostInBillingCurrency)
			delete(rawMsg, key)
		case "paygCostInUSD":
			err = unpopulate(val, "PaygCostInUSD", &m.PaygCostInUSD)
			delete(rawMsg, key)
		case "previousInvoiceId":
			err = unpopulate(val, "PreviousInvoiceID", &m.PreviousInvoiceID)
			delete(rawMsg, key)
		case "pricingCurrencyCode":
			err = unpopulate(val, "PricingCurrencyCode", &m.PricingCurrencyCode)
			delete(rawMsg, key)
		case "pricingModel":
			err = unpopulate(val, "PricingModel", &m.PricingModel)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &m.Product)
			delete(rawMsg, key)
		case "productIdentifier":
			err = unpopulate(val, "ProductIdentifier", &m.ProductIdentifier)
			delete(rawMsg, key)
		case "productOrderId":
			err = unpopulate(val, "ProductOrderID", &m.ProductOrderID)
			delete(rawMsg, key)
		case "productOrderName":
			err = unpopulate(val, "ProductOrderName", &m.ProductOrderName)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &m.Provider)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &m.PublisherID)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &m.PublisherName)
			delete(rawMsg, key)
		case "publisherType":
			err = unpopulate(val, "PublisherType", &m.PublisherType)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &m.Quantity)
			delete(rawMsg, key)
		case "resellerMpnId":
			err = unpopulate(val, "ResellerMpnID", &m.ResellerMpnID)
			delete(rawMsg, key)
		case "resellerName":
			err = unpopulate(val, "ResellerName", &m.ResellerName)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &m.ReservationID)
			delete(rawMsg, key)
		case "reservationName":
			err = unpopulate(val, "ReservationName", &m.ReservationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &m.ResourceGroup)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &m.ResourceLocation)
			delete(rawMsg, key)
		case "resourceLocationNormalized":
			err = unpopulate(val, "ResourceLocationNormalized", &m.ResourceLocationNormalized)
			delete(rawMsg, key)
		case "serviceFamily":
			err = unpopulate(val, "ServiceFamily", &m.ServiceFamily)
			delete(rawMsg, key)
		case "serviceInfo1":
			err = unpopulate(val, "ServiceInfo1", &m.ServiceInfo1)
			delete(rawMsg, key)
		case "serviceInfo2":
			err = unpopulate(val, "ServiceInfo2", &m.ServiceInfo2)
			delete(rawMsg, key)
		case "servicePeriodEndDate":
			err = unpopulateTimeRFC3339(val, "ServicePeriodEndDate", &m.ServicePeriodEndDate)
			delete(rawMsg, key)
		case "servicePeriodStartDate":
			err = unpopulateTimeRFC3339(val, "ServicePeriodStartDate", &m.ServicePeriodStartDate)
			delete(rawMsg, key)
		case "subscriptionGuid":
			err = unpopulate(val, "SubscriptionGUID", &m.SubscriptionGUID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &m.SubscriptionName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &m.Term)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &m.UnitOfMeasure)
			delete(rawMsg, key)
		case "unitPrice":
			err = unpopulate(val, "UnitPrice", &m.UnitPrice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Notification.
func (n Notification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contactEmails", n.ContactEmails)
	populate(objectMap, "contactGroups", n.ContactGroups)
	populate(objectMap, "contactRoles", n.ContactRoles)
	populate(objectMap, "enabled", n.Enabled)
	populate(objectMap, "locale", n.Locale)
	populate(objectMap, "operator", n.Operator)
	populate(objectMap, "threshold", n.Threshold)
	populate(objectMap, "thresholdType", n.ThresholdType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationDetailProperties.
func (r *ReservationDetailProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &r.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &r.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "instanceId":
			err = unpopulate(val, "InstanceID", &r.InstanceID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &r.ReservationOrderID)
			delete(rawMsg, key)
		case "reservedHours":
			err = unpopulate(val, "ReservedHours", &r.ReservedHours)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &r.SKUName)
			delete(rawMsg, key)
		case "totalReservedQuantity":
			err = unpopulate(val, "TotalReservedQuantity", &r.TotalReservedQuantity)
			delete(rawMsg, key)
		case "usageDate":
			err = unpopulateTimeRFC3339(val, "UsageDate", &r.UsageDate)
			delete(rawMsg, key)
		case "usedHours":
			err = unpopulate(val, "UsedHours", &r.UsedHours)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationsListResult.
func (r *ReservationRecommendationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "previousLink":
			err = unpopulate(val, "PreviousLink", &r.PreviousLink)
			delete(rawMsg, key)
		case "value":
			r.Value, err = unmarshalReservationRecommendationClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSummaryProperties.
func (r *ReservationSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avgUtilizationPercentage":
			err = unpopulate(val, "AvgUtilizationPercentage", &r.AvgUtilizationPercentage)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "maxUtilizationPercentage":
			err = unpopulate(val, "MaxUtilizationPercentage", &r.MaxUtilizationPercentage)
			delete(rawMsg, key)
		case "minUtilizationPercentage":
			err = unpopulate(val, "MinUtilizationPercentage", &r.MinUtilizationPercentage)
			delete(rawMsg, key)
		case "purchasedQuantity":
			err = unpopulate(val, "PurchasedQuantity", &r.PurchasedQuantity)
			delete(rawMsg, key)
		case "remainingQuantity":
			err = unpopulate(val, "RemainingQuantity", &r.RemainingQuantity)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &r.ReservationOrderID)
			delete(rawMsg, key)
		case "reservedHours":
			err = unpopulate(val, "ReservedHours", &r.ReservedHours)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &r.SKUName)
			delete(rawMsg, key)
		case "totalReservedQuantity":
			err = unpopulate(val, "TotalReservedQuantity", &r.TotalReservedQuantity)
			delete(rawMsg, key)
		case "usageDate":
			err = unpopulateTimeRFC3339(val, "UsageDate", &r.UsageDate)
			delete(rawMsg, key)
		case "usedHours":
			err = unpopulate(val, "UsedHours", &r.UsedHours)
			delete(rawMsg, key)
		case "usedQuantity":
			err = unpopulate(val, "UsedQuantity", &r.UsedQuantity)
			delete(rawMsg, key)
		case "utilizedPercentage":
			err = unpopulate(val, "UtilizedPercentage", &r.UtilizedPercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Tag.
func (t Tag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", t.Key)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TagProperties.
func (t TagProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "previousLink", t.PreviousLink)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageDetailsListResult.
func (u *UsageDetailsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			u.Value, err = unmarshalUsageDetailClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
