//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesbackup

import "time"

// AzureBackupGoalFeatureSupportRequest - Azure backup goal feature specific request.
type AzureBackupGoalFeatureSupportRequest struct {
	// REQUIRED; backup support feature type.
	FeatureType *string `json:"featureType,omitempty"`
}

// GetFeatureSupportRequest implements the FeatureSupportRequestClassification interface for type AzureBackupGoalFeatureSupportRequest.
func (a *AzureBackupGoalFeatureSupportRequest) GetFeatureSupportRequest() *FeatureSupportRequest {
	return &FeatureSupportRequest{
		FeatureType: a.FeatureType,
	}
}

// AzureBackupServerContainer - AzureBackupServer (DPMVenus) workload-specific protection container.
type AzureBackupServerContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Specifies whether the container is re-registrable.
	CanReRegister *bool `json:"canReRegister,omitempty"`

	// ID of container.
	ContainerID *string `json:"containerId,omitempty"`

	// Backup engine Agent version
	DpmAgentVersion *string `json:"dpmAgentVersion,omitempty"`

	// List of BackupEngines protecting the container
	DpmServers []*string `json:"dpmServers,omitempty"`

	// Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Number of protected items in the BackupEngine
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`

	// Protection status of the container.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// To check if upgrade available
	UpgradeAvailable *bool `json:"upgradeAvailable,omitempty"`
}

// GetDpmContainer implements the DpmContainerClassification interface for type AzureBackupServerContainer.
func (a *AzureBackupServerContainer) GetDpmContainer() *DpmContainer {
	return &DpmContainer{
		CanReRegister:         a.CanReRegister,
		ContainerID:           a.ContainerID,
		ProtectedItemCount:    a.ProtectedItemCount,
		DpmAgentVersion:       a.DpmAgentVersion,
		DpmServers:            a.DpmServers,
		UpgradeAvailable:      a.UpgradeAvailable,
		ProtectionStatus:      a.ProtectionStatus,
		ExtendedInfo:          a.ExtendedInfo,
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureBackupServerContainer.
func (a *AzureBackupServerContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureBackupServerEngine - Backup engine type when Azure Backup Server is used to manage the backups.
type AzureBackupServerEngine struct {
	// REQUIRED; Type of the backup engine.
	BackupEngineType *BackupEngineType `json:"backupEngineType,omitempty"`

	// Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`

	// ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`

	// Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`

	// Type of backup management for the backup engine.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`

	// Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`

	// Extended info of the backupengine
	ExtendedInfo *BackupEngineExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`

	// To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`

	// Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// GetBackupEngineBase implements the BackupEngineBaseClassification interface for type AzureBackupServerEngine.
func (a *AzureBackupServerEngine) GetBackupEngineBase() *BackupEngineBase {
	return &BackupEngineBase{
		FriendlyName:                       a.FriendlyName,
		BackupManagementType:               a.BackupManagementType,
		RegistrationStatus:                 a.RegistrationStatus,
		BackupEngineState:                  a.BackupEngineState,
		HealthStatus:                       a.HealthStatus,
		BackupEngineType:                   a.BackupEngineType,
		CanReRegister:                      a.CanReRegister,
		BackupEngineID:                     a.BackupEngineID,
		DpmVersion:                         a.DpmVersion,
		AzureBackupAgentVersion:            a.AzureBackupAgentVersion,
		IsAzureBackupAgentUpgradeAvailable: a.IsAzureBackupAgentUpgradeAvailable,
		IsDpmUpgradeAvailable:              a.IsDpmUpgradeAvailable,
		ExtendedInfo:                       a.ExtendedInfo,
	}
}

// AzureFileShareBackupRequest - AzureFileShare workload-specific backup request.
type AzureFileShareBackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *time.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
}

// GetBackupRequest implements the BackupRequestClassification interface for type AzureFileShareBackupRequest.
func (a *AzureFileShareBackupRequest) GetBackupRequest() *BackupRequest {
	return &BackupRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureFileShareProtectableItem - Protectable item for Azure Fileshare workloads.
type AzureFileShareProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// File Share type XSync or XSMB.
	AzureFileShareType *AzureFileShareType `json:"azureFileShareType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Full Fabric ID of container to which this protectable item belongs. For example, ARM ID.
	ParentContainerFabricID *string `json:"parentContainerFabricId,omitempty"`

	// Friendly name of container to which this protectable item belongs.
	ParentContainerFriendlyName *string `json:"parentContainerFriendlyName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureFileShareProtectableItem.
func (a *AzureFileShareProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureFileShareProtectionPolicy - AzureStorage backup policy.
type AzureFileShareProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Retention policy with the details on backup copy retention ranges.
	RetentionPolicy RetentionPolicyClassification `json:"retentionPolicy,omitempty"`

	// Backup schedule specified as part of backup policy.
	SchedulePolicy SchedulePolicyClassification `json:"schedulePolicy,omitempty"`

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`

	// Type of workload for the backup management
	WorkLoadType *WorkloadType `json:"workLoadType,omitempty"`
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureFileShareProtectionPolicy.
func (a *AzureFileShareProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		ProtectedItemsCount:            a.ProtectedItemsCount,
		BackupManagementType:           a.BackupManagementType,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureFileShareProvisionILRRequest - Update snapshot Uri with the correct friendly Name of the source Azure file share.
type AzureFileShareProvisionILRRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Recovery point ID.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// Source Storage account ARM Id
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetILRRequest implements the ILRRequestClassification interface for type AzureFileShareProvisionILRRequest.
func (a *AzureFileShareProvisionILRRequest) GetILRRequest() *ILRRequest {
	return &ILRRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureFileShareRecoveryPoint - Azure File Share workload specific backup copy.
type AzureFileShareRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Contains Url to the snapshot of fileshare, if applicable
	FileShareSnapshotURI *string `json:"fileShareSnapshotUri,omitempty"`

	// Contains recovery point size
	RecoveryPointSizeInGB *int32 `json:"recoveryPointSizeInGB,omitempty"`

	// Time at which this backup copy was created.
	RecoveryPointTime *time.Time `json:"recoveryPointTime,omitempty"`

	// Type of the backup copy. Specifies whether it is a crash consistent backup or app consistent.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureFileShareRecoveryPoint.
func (a *AzureFileShareRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureFileShareRestoreRequest - AzureFileShare Restore Request
type AzureFileShareRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Options to resolve copy conflicts.
	CopyOptions *CopyOptions `json:"copyOptions,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// List of Source Files/Folders(which need to recover) and TargetFolderPath details
	RestoreFileSpecs []*RestoreFileSpecs `json:"restoreFileSpecs,omitempty"`

	// Restore Type (FullShareRestore or ItemLevelRestore)
	RestoreRequestType *RestoreRequestType `json:"restoreRequestType,omitempty"`

	// Source storage account ARM Id
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Target File Share Details
	TargetDetails *TargetAFSRestoreInfo `json:"targetDetails,omitempty"`
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureFileShareRestoreRequest.
func (a *AzureFileShareRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureFileshareProtectedItem - Azure File Share workload-specific backup item.
type AzureFileshareProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information with this backup item.
	ExtendedInfo *AzureFileshareProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the fileshare represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureFileshareProtectedItem.
func (a *AzureFileshareProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureFileshareProtectedItemExtendedInfo - Additional information about Azure File Share backup item.
type AzureFileshareProtectedItemExtendedInfo struct {
	// The oldest backup copy available for this item in the service.
	OldestRecoveryPoint *time.Time `json:"oldestRecoveryPoint,omitempty"`

	// Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string `json:"policyState,omitempty"`

	// Number of available backup copies associated with this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`

	// READ-ONLY; Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted,
	// Deleted}
	ResourceState *string `json:"resourceState,omitempty" azure:"ro"`

	// READ-ONLY; The resource state sync time for this backup item.
	ResourceStateSyncTime *time.Time `json:"resourceStateSyncTime,omitempty" azure:"ro"`
}

// AzureIaaSClassicComputeVMContainer - IaaS VM workload-specific backup item representing a classic virtual machine.
type AzureIaaSClassicComputeVMContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
}

// GetIaaSVMContainer implements the IaaSVMContainerClassification interface for type AzureIaaSClassicComputeVMContainer.
func (a *AzureIaaSClassicComputeVMContainer) GetIaaSVMContainer() *IaaSVMContainer {
	return &IaaSVMContainer{
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
		ResourceGroup:         a.ResourceGroup,
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureIaaSClassicComputeVMContainer.
func (a *AzureIaaSClassicComputeVMContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureIaaSClassicComputeVMProtectableItem - IaaS VM workload-specific backup item representing the Classic Compute VM.
type AzureIaaSClassicComputeVMProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetIaaSVMProtectableItem implements the IaaSVMProtectableItemClassification interface for type AzureIaaSClassicComputeVMProtectableItem.
func (a *AzureIaaSClassicComputeVMProtectableItem) GetIaaSVMProtectableItem() *IaaSVMProtectableItem {
	return &IaaSVMProtectableItem{
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
		ResourceGroup:         a.ResourceGroup,
		BackupManagementType:  a.BackupManagementType,
		WorkloadType:          a.WorkloadType,
		ProtectableItemType:   a.ProtectableItemType,
		FriendlyName:          a.FriendlyName,
		ProtectionState:       a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureIaaSClassicComputeVMProtectableItem.
func (a *AzureIaaSClassicComputeVMProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureIaaSClassicComputeVMProtectedItem - IaaS VM workload-specific backup item representing the Classic Compute VM.
type AzureIaaSClassicComputeVMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Extended Properties for Azure IaasVM Backup.
	ExtendedProperties *ExtendedProperties `json:"extendedProperties,omitempty"`

	// Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Health details on this backup item.
	HealthDetails []*AzureIaaSVMHealthDetails `json:"healthDetails,omitempty"`

	// Health status of protected item.
	HealthStatus *HealthStatus `json:"healthStatus,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Last backup operation status.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Data ID of the protected item.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetAzureIaaSVMProtectedItem implements the AzureIaaSVMProtectedItemClassification interface for type AzureIaaSClassicComputeVMProtectedItem.
func (a *AzureIaaSClassicComputeVMProtectedItem) GetAzureIaaSVMProtectedItem() *AzureIaaSVMProtectedItem {
	return &AzureIaaSVMProtectedItem{
		FriendlyName:                     a.FriendlyName,
		VirtualMachineID:                 a.VirtualMachineID,
		ProtectionStatus:                 a.ProtectionStatus,
		ProtectionState:                  a.ProtectionState,
		HealthStatus:                     a.HealthStatus,
		HealthDetails:                    a.HealthDetails,
		KpisHealths:                      a.KpisHealths,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		ProtectedItemDataID:              a.ProtectedItemDataID,
		ExtendedInfo:                     a.ExtendedInfo,
		ExtendedProperties:               a.ExtendedProperties,
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureIaaSClassicComputeVMProtectedItem.
func (a *AzureIaaSClassicComputeVMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureIaaSComputeVMContainer - IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
type AzureIaaSComputeVMContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
}

// GetIaaSVMContainer implements the IaaSVMContainerClassification interface for type AzureIaaSComputeVMContainer.
func (a *AzureIaaSComputeVMContainer) GetIaaSVMContainer() *IaaSVMContainer {
	return &IaaSVMContainer{
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
		ResourceGroup:         a.ResourceGroup,
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureIaaSComputeVMContainer.
func (a *AzureIaaSComputeVMContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureIaaSComputeVMProtectableItem - IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
type AzureIaaSComputeVMProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetIaaSVMProtectableItem implements the IaaSVMProtectableItemClassification interface for type AzureIaaSComputeVMProtectableItem.
func (a *AzureIaaSComputeVMProtectableItem) GetIaaSVMProtectableItem() *IaaSVMProtectableItem {
	return &IaaSVMProtectableItem{
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
		ResourceGroup:         a.ResourceGroup,
		BackupManagementType:  a.BackupManagementType,
		WorkloadType:          a.WorkloadType,
		ProtectableItemType:   a.ProtectableItemType,
		FriendlyName:          a.FriendlyName,
		ProtectionState:       a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureIaaSComputeVMProtectableItem.
func (a *AzureIaaSComputeVMProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureIaaSComputeVMProtectedItem - IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
type AzureIaaSComputeVMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Extended Properties for Azure IaasVM Backup.
	ExtendedProperties *ExtendedProperties `json:"extendedProperties,omitempty"`

	// Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Health details on this backup item.
	HealthDetails []*AzureIaaSVMHealthDetails `json:"healthDetails,omitempty"`

	// Health status of protected item.
	HealthStatus *HealthStatus `json:"healthStatus,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Last backup operation status.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Data ID of the protected item.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetAzureIaaSVMProtectedItem implements the AzureIaaSVMProtectedItemClassification interface for type AzureIaaSComputeVMProtectedItem.
func (a *AzureIaaSComputeVMProtectedItem) GetAzureIaaSVMProtectedItem() *AzureIaaSVMProtectedItem {
	return &AzureIaaSVMProtectedItem{
		FriendlyName:                     a.FriendlyName,
		VirtualMachineID:                 a.VirtualMachineID,
		ProtectionStatus:                 a.ProtectionStatus,
		ProtectionState:                  a.ProtectionState,
		HealthStatus:                     a.HealthStatus,
		HealthDetails:                    a.HealthDetails,
		KpisHealths:                      a.KpisHealths,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		ProtectedItemDataID:              a.ProtectedItemDataID,
		ExtendedInfo:                     a.ExtendedInfo,
		ExtendedProperties:               a.ExtendedProperties,
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureIaaSComputeVMProtectedItem.
func (a *AzureIaaSComputeVMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureIaaSVMErrorInfo - Azure IaaS VM workload-specific error information.
type AzureIaaSVMErrorInfo struct {
	// READ-ONLY; Error code.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Localized error string.
	ErrorString *string `json:"errorString,omitempty" azure:"ro"`

	// READ-ONLY; Title: Typically, the entity that the error pertains to.
	ErrorTitle *string `json:"errorTitle,omitempty" azure:"ro"`

	// READ-ONLY; List of localized recommendations for above error code.
	Recommendations []*string `json:"recommendations,omitempty" azure:"ro"`
}

// AzureIaaSVMHealthDetails - Azure IaaS VM workload-specific Health Details.
type AzureIaaSVMHealthDetails struct {
	// READ-ONLY; Health Code
	Code *int32 `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Health Message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Health Recommended Actions
	Recommendations []*string `json:"recommendations,omitempty" azure:"ro"`

	// READ-ONLY; Health Title
	Title *string `json:"title,omitempty" azure:"ro"`
}

// AzureIaaSVMJob - Azure IaaS VM workload-specific job object.
type AzureIaaSVMJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction `json:"actionsInfo,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Container name of the entity on which the current job is executing.
	ContainerName *string `json:"containerName,omitempty"`

	// Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// Error details on execution of this job.
	ErrorDetails []*AzureIaaSVMErrorInfo `json:"errorDetails,omitempty"`

	// Additional information for this job.
	ExtendedInfo *AzureIaaSVMJobExtendedInfo `json:"extendedInfo,omitempty"`

	// Indicated that whether the job is adhoc(true) or scheduled(false)
	IsUserTriggered *bool `json:"isUserTriggered,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`

	// Specifies whether the backup item is a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
}

// GetJob implements the JobClassification interface for type AzureIaaSVMJob.
func (a *AzureIaaSVMJob) GetJob() *Job {
	return &Job{
		EntityFriendlyName:   a.EntityFriendlyName,
		BackupManagementType: a.BackupManagementType,
		Operation:            a.Operation,
		Status:               a.Status,
		StartTime:            a.StartTime,
		EndTime:              a.EndTime,
		ActivityID:           a.ActivityID,
		JobType:              a.JobType,
	}
}

// AzureIaaSVMJobExtendedInfo - Azure IaaS VM workload-specific additional information for job.
type AzureIaaSVMJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`

	// Time remaining for execution of this job.
	EstimatedRemainingDuration *string `json:"estimatedRemainingDuration,omitempty"`

	// Job internal properties.
	InternalPropertyBag map[string]*string `json:"internalPropertyBag,omitempty"`

	// Indicates progress of the job. Null if it has not started or completed.
	ProgressPercentage *float64 `json:"progressPercentage,omitempty"`

	// Job properties.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// List of tasks associated with this job.
	TasksList []*AzureIaaSVMJobTaskDetails `json:"tasksList,omitempty"`
}

// AzureIaaSVMJobTaskDetails - Azure IaaS VM workload-specific job task details.
type AzureIaaSVMJobTaskDetails struct {
	// Time elapsed for task.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The instanceId.
	InstanceID *string `json:"instanceId,omitempty"`

	// Progress of the task.
	ProgressPercentage *float64 `json:"progressPercentage,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status.
	Status *string `json:"status,omitempty"`

	// Details about execution of the task. eg: number of bytes transferred etc
	TaskExecutionDetails *string `json:"taskExecutionDetails,omitempty"`

	// The task display name.
	TaskID *string `json:"taskId,omitempty"`
}

// AzureIaaSVMJobV2 - Azure IaaS VM workload-specific job object.
type AzureIaaSVMJobV2 struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction `json:"actionsInfo,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Container name of the entity on which the current job is executing.
	ContainerName *string `json:"containerName,omitempty"`

	// Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// Error details on execution of this job.
	ErrorDetails []*AzureIaaSVMErrorInfo `json:"errorDetails,omitempty"`

	// Additional information for this job.
	ExtendedInfo *AzureIaaSVMJobExtendedInfo `json:"extendedInfo,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`

	// Specifies whether the backup item is a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
}

// GetJob implements the JobClassification interface for type AzureIaaSVMJobV2.
func (a *AzureIaaSVMJobV2) GetJob() *Job {
	return &Job{
		EntityFriendlyName:   a.EntityFriendlyName,
		BackupManagementType: a.BackupManagementType,
		Operation:            a.Operation,
		Status:               a.Status,
		StartTime:            a.StartTime,
		EndTime:              a.EndTime,
		ActivityID:           a.ActivityID,
		JobType:              a.JobType,
	}
}

// AzureIaaSVMProtectedItemClassification provides polymorphic access to related types.
// Call the interface's GetAzureIaaSVMProtectedItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureIaaSClassicComputeVMProtectedItem, *AzureIaaSComputeVMProtectedItem, *AzureIaaSVMProtectedItem
type AzureIaaSVMProtectedItemClassification interface {
	ProtectedItemClassification
	// GetAzureIaaSVMProtectedItem returns the AzureIaaSVMProtectedItem content of the underlying type.
	GetAzureIaaSVMProtectedItem() *AzureIaaSVMProtectedItem
}

// AzureIaaSVMProtectedItem - IaaS VM workload-specific backup item.
type AzureIaaSVMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Extended Properties for Azure IaasVM Backup.
	ExtendedProperties *ExtendedProperties `json:"extendedProperties,omitempty"`

	// Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Health details on this backup item.
	HealthDetails []*AzureIaaSVMHealthDetails `json:"healthDetails,omitempty"`

	// Health status of protected item.
	HealthStatus *HealthStatus `json:"healthStatus,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Last backup operation status.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Data ID of the protected item.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetAzureIaaSVMProtectedItem implements the AzureIaaSVMProtectedItemClassification interface for type AzureIaaSVMProtectedItem.
func (a *AzureIaaSVMProtectedItem) GetAzureIaaSVMProtectedItem() *AzureIaaSVMProtectedItem { return a }

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureIaaSVMProtectedItem.
func (a *AzureIaaSVMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureIaaSVMProtectedItemExtendedInfo - Additional information on Azure IaaS VM specific backup item.
type AzureIaaSVMProtectedItemExtendedInfo struct {
	// The oldest backup copy available for this backup item.
	OldestRecoveryPoint *time.Time `json:"oldestRecoveryPoint,omitempty"`

	// Specifies if backup policy associated with the backup item is inconsistent.
	PolicyInconsistent *bool `json:"policyInconsistent,omitempty"`

	// Number of backup copies available for this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
}

// AzureIaaSVMProtectionPolicy - IaaS VM workload-specific backup policy.
type AzureIaaSVMProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string                     `json:"backupManagementType,omitempty"`
	InstantRPDetails     *InstantRPAdditionalDetails `json:"instantRPDetails,omitempty"`

	// Instant RP retention policy range in days
	InstantRpRetentionRangeInDays *int32            `json:"instantRpRetentionRangeInDays,omitempty"`
	PolicyType                    *IAASVMPolicyType `json:"policyType,omitempty"`

	// Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Retention policy with the details on backup copy retention ranges.
	RetentionPolicy RetentionPolicyClassification `json:"retentionPolicy,omitempty"`

	// Backup schedule specified as part of backup policy.
	SchedulePolicy SchedulePolicyClassification `json:"schedulePolicy,omitempty"`

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureIaaSVMProtectionPolicy.
func (a *AzureIaaSVMProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		ProtectedItemsCount:            a.ProtectedItemsCount,
		BackupManagementType:           a.BackupManagementType,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureRecoveryServiceVaultProtectionIntentClassification provides polymorphic access to related types.
// Call the interface's GetAzureRecoveryServiceVaultProtectionIntent() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureRecoveryServiceVaultProtectionIntent, *AzureWorkloadAutoProtectionIntent, *AzureWorkloadSQLAutoProtectionIntent
type AzureRecoveryServiceVaultProtectionIntentClassification interface {
	ProtectionIntentClassification
	// GetAzureRecoveryServiceVaultProtectionIntent returns the AzureRecoveryServiceVaultProtectionIntent content of the underlying type.
	GetAzureRecoveryServiceVaultProtectionIntent() *AzureRecoveryServiceVaultProtectionIntent
}

// AzureRecoveryServiceVaultProtectionIntent - Azure Recovery Services Vault specific protection intent item.
type AzureRecoveryServiceVaultProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetAzureRecoveryServiceVaultProtectionIntent implements the AzureRecoveryServiceVaultProtectionIntentClassification interface
// for type AzureRecoveryServiceVaultProtectionIntent.
func (a *AzureRecoveryServiceVaultProtectionIntent) GetAzureRecoveryServiceVaultProtectionIntent() *AzureRecoveryServiceVaultProtectionIntent {
	return a
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureRecoveryServiceVaultProtectionIntent.
func (a *AzureRecoveryServiceVaultProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// AzureResourceProtectionIntent - IaaS VM specific backup protection intent item.
type AzureResourceProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureResourceProtectionIntent.
func (a *AzureResourceProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// AzureSQLAGWorkloadContainerProtectionContainer - Container for SQL workloads under SQL Availability Group.
type AzureSQLAGWorkloadContainerProtectionContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Time stamp when this container was updated.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty"`

	// Re-Do Operation
	OperationType *OperationType `json:"operationType,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Workload type for which registration was sent.
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// GetAzureWorkloadContainer implements the AzureWorkloadContainerClassification interface for type AzureSQLAGWorkloadContainerProtectionContainer.
func (a *AzureSQLAGWorkloadContainerProtectionContainer) GetAzureWorkloadContainer() *AzureWorkloadContainer {
	return &AzureWorkloadContainer{
		SourceResourceID:      a.SourceResourceID,
		LastUpdatedTime:       a.LastUpdatedTime,
		ExtendedInfo:          a.ExtendedInfo,
		WorkloadType:          a.WorkloadType,
		OperationType:         a.OperationType,
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureSQLAGWorkloadContainerProtectionContainer.
func (a *AzureSQLAGWorkloadContainerProtectionContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureSQLContainer - Azure Sql workload-specific container.
type AzureSQLContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureSQLContainer.
func (a *AzureSQLContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureSQLProtectedItem - Azure SQL workload-specific backup item.
type AzureSQLProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureSQLProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`

	// Backup state of the backed up item.
	ProtectionState *ProtectedItemState `json:"protectionState,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureSQLProtectedItem.
func (a *AzureSQLProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureSQLProtectedItemExtendedInfo - Additional information on Azure Sql specific protected item.
type AzureSQLProtectedItemExtendedInfo struct {
	// The oldest backup copy available for this item in the service.
	OldestRecoveryPoint *time.Time `json:"oldestRecoveryPoint,omitempty"`

	// State of the backup policy associated with this backup item.
	PolicyState *string `json:"policyState,omitempty"`

	// Number of available backup copies associated with this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
}

// AzureSQLProtectionPolicy - Azure SQL workload-specific backup policy.
type AzureSQLProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Retention policy details.
	RetentionPolicy RetentionPolicyClassification `json:"retentionPolicy,omitempty"`
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureSQLProtectionPolicy.
func (a *AzureSQLProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		ProtectedItemsCount:            a.ProtectedItemsCount,
		BackupManagementType:           a.BackupManagementType,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureStorageContainer - Azure Storage Account workload-specific container.
type AzureStorageContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Whether storage account lock is to be acquired for this container or not.
	AcquireStorageAccountLock *AcquireStorageAccountLock `json:"acquireStorageAccountLock,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Number of items backed up in this container.
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Fully qualified ARM url.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Storage account version.
	StorageAccountVersion *string `json:"storageAccountVersion,omitempty"`
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureStorageContainer.
func (a *AzureStorageContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureStorageErrorInfo - Azure storage specific error information
type AzureStorageErrorInfo struct {
	// Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`

	// Localized error string.
	ErrorString *string `json:"errorString,omitempty"`

	// List of localized recommendations for above error code.
	Recommendations []*string `json:"recommendations,omitempty"`
}

// AzureStorageJob - Azure storage specific job.
type AzureStorageJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction `json:"actionsInfo,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// Error details on execution of this job.
	ErrorDetails []*AzureStorageErrorInfo `json:"errorDetails,omitempty"`

	// Additional information about the job.
	ExtendedInfo *AzureStorageJobExtendedInfo `json:"extendedInfo,omitempty"`

	// Indicated that whether the job is adhoc(true) or scheduled(false)
	IsUserTriggered *bool `json:"isUserTriggered,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`

	// Specifies friendly name of the storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// Specifies whether the Storage account is a Classic or an Azure Resource Manager Storage account.
	StorageAccountVersion *string `json:"storageAccountVersion,omitempty"`
}

// GetJob implements the JobClassification interface for type AzureStorageJob.
func (a *AzureStorageJob) GetJob() *Job {
	return &Job{
		EntityFriendlyName:   a.EntityFriendlyName,
		BackupManagementType: a.BackupManagementType,
		Operation:            a.Operation,
		Status:               a.Status,
		StartTime:            a.StartTime,
		EndTime:              a.EndTime,
		ActivityID:           a.ActivityID,
		JobType:              a.JobType,
	}
}

// AzureStorageJobExtendedInfo - Azure Storage workload-specific additional information for job.
type AzureStorageJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`

	// Job properties.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// List of tasks for this job
	TasksList []*AzureStorageJobTaskDetails `json:"tasksList,omitempty"`
}

// AzureStorageJobTaskDetails - Azure storage workload specific job task details.
type AzureStorageJobTaskDetails struct {
	// The status.
	Status *string `json:"status,omitempty"`

	// The task display name.
	TaskID *string `json:"taskId,omitempty"`
}

// AzureStorageProtectableContainer - Azure Storage-specific protectable containers
type AzureStorageProtectableContainer struct {
	// REQUIRED; Type of the container. The value of this property for
	// 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines
	ProtectableContainerType *ContainerType `json:"protectableContainerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
}

// GetProtectableContainer implements the ProtectableContainerClassification interface for type AzureStorageProtectableContainer.
func (a *AzureStorageProtectableContainer) GetProtectableContainer() *ProtectableContainer {
	return &ProtectableContainer{
		FriendlyName:             a.FriendlyName,
		BackupManagementType:     a.BackupManagementType,
		ProtectableContainerType: a.ProtectableContainerType,
		HealthStatus:             a.HealthStatus,
		ContainerID:              a.ContainerID,
	}
}

// AzureVMAppContainerProtectableContainer - Azure workload-specific container
type AzureVMAppContainerProtectableContainer struct {
	// REQUIRED; Type of the container. The value of this property for
	// 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines
	ProtectableContainerType *ContainerType `json:"protectableContainerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
}

// GetProtectableContainer implements the ProtectableContainerClassification interface for type AzureVMAppContainerProtectableContainer.
func (a *AzureVMAppContainerProtectableContainer) GetProtectableContainer() *ProtectableContainer {
	return &ProtectableContainer{
		FriendlyName:             a.FriendlyName,
		BackupManagementType:     a.BackupManagementType,
		ProtectableContainerType: a.ProtectableContainerType,
		HealthStatus:             a.HealthStatus,
		ContainerID:              a.ContainerID,
	}
}

// AzureVMAppContainerProtectionContainer - Container for SQL workloads under Azure Virtual Machines.
type AzureVMAppContainerProtectionContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Time stamp when this container was updated.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty"`

	// Re-Do Operation
	OperationType *OperationType `json:"operationType,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Workload type for which registration was sent.
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// GetAzureWorkloadContainer implements the AzureWorkloadContainerClassification interface for type AzureVMAppContainerProtectionContainer.
func (a *AzureVMAppContainerProtectionContainer) GetAzureWorkloadContainer() *AzureWorkloadContainer {
	return &AzureWorkloadContainer{
		SourceResourceID:      a.SourceResourceID,
		LastUpdatedTime:       a.LastUpdatedTime,
		ExtendedInfo:          a.ExtendedInfo,
		WorkloadType:          a.WorkloadType,
		OperationType:         a.OperationType,
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureVMAppContainerProtectionContainer.
func (a *AzureVMAppContainerProtectionContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureVMResourceFeatureSupportRequest - AzureResource(IaaS VM) Specific feature support request
type AzureVMResourceFeatureSupportRequest struct {
	// REQUIRED; backup support feature type.
	FeatureType *string `json:"featureType,omitempty"`

	// SKUs (Premium/Managed etc) in case of IaasVM
	VMSKU *string `json:"vmSku,omitempty"`

	// Size of the resource: VM size(A/D series etc) in case of IaasVM
	VMSize *string `json:"vmSize,omitempty"`
}

// GetFeatureSupportRequest implements the FeatureSupportRequestClassification interface for type AzureVMResourceFeatureSupportRequest.
func (a *AzureVMResourceFeatureSupportRequest) GetFeatureSupportRequest() *FeatureSupportRequest {
	return &FeatureSupportRequest{
		FeatureType: a.FeatureType,
	}
}

// AzureVMResourceFeatureSupportResponse - Response for feature support requests for Azure IaasVm
type AzureVMResourceFeatureSupportResponse struct {
	// Support status of feature
	SupportStatus *SupportStatus `json:"supportStatus,omitempty"`
}

// AzureVMWorkloadItemClassification provides polymorphic access to related types.
// Call the interface's GetAzureVMWorkloadItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureVMWorkloadItem, *AzureVMWorkloadSAPAseDatabaseWorkloadItem, *AzureVMWorkloadSAPAseSystemWorkloadItem, *AzureVMWorkloadSAPHanaDatabaseWorkloadItem,
// - *AzureVMWorkloadSAPHanaSystemWorkloadItem, *AzureVMWorkloadSQLDatabaseWorkloadItem, *AzureVMWorkloadSQLInstanceWorkloadItem
type AzureVMWorkloadItemClassification interface {
	WorkloadItemClassification
	// GetAzureVMWorkloadItem returns the AzureVMWorkloadItem content of the underlying type.
	GetAzureVMWorkloadItem() *AzureVMWorkloadItem
}

// AzureVMWorkloadItem - Azure VM workload-specific workload item.
type AzureVMWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadItem.
func (a *AzureVMWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem { return a }

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadItem.
func (a *AzureVMWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadProtectableItemClassification provides polymorphic access to related types.
// Call the interface's GetAzureVMWorkloadProtectableItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureVMWorkloadProtectableItem, *AzureVMWorkloadSAPAseSystemProtectableItem, *AzureVMWorkloadSAPHanaDatabaseProtectableItem,
// - *AzureVMWorkloadSAPHanaSystemProtectableItem, *AzureVMWorkloadSQLAvailabilityGroupProtectableItem, *AzureVMWorkloadSQLDatabaseProtectableItem,
// - *AzureVMWorkloadSQLInstanceProtectableItem
type AzureVMWorkloadProtectableItemClassification interface {
	WorkloadProtectableItemClassification
	// GetAzureVMWorkloadProtectableItem returns the AzureVMWorkloadProtectableItem content of the underlying type.
	GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem
}

// AzureVMWorkloadProtectableItem - Azure VM workload-specific protectable item.
type AzureVMWorkloadProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadProtectableItem.
func (a *AzureVMWorkloadProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return a
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadProtectableItem.
func (a *AzureVMWorkloadProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadProtectedItemClassification provides polymorphic access to related types.
// Call the interface's GetAzureVMWorkloadProtectedItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureVMWorkloadProtectedItem, *AzureVMWorkloadSAPAseDatabaseProtectedItem, *AzureVMWorkloadSAPHanaDatabaseProtectedItem,
// - *AzureVMWorkloadSQLDatabaseProtectedItem
type AzureVMWorkloadProtectedItemClassification interface {
	ProtectedItemClassification
	// GetAzureVMWorkloadProtectedItem returns the AzureVMWorkloadProtectedItem content of the underlying type.
	GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem
}

// AzureVMWorkloadProtectedItem - Azure VM workload-specific protected item.
type AzureVMWorkloadProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadProtectedItem.
func (a *AzureVMWorkloadProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return a
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadProtectedItem.
func (a *AzureVMWorkloadProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureVMWorkloadProtectedItemExtendedInfo - Additional information on Azure Workload for SQL specific backup item.
type AzureVMWorkloadProtectedItemExtendedInfo struct {
	// The oldest backup copy available for this backup item.
	OldestRecoveryPoint *time.Time `json:"oldestRecoveryPoint,omitempty"`

	// Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string `json:"policyState,omitempty"`

	// Indicates consistency of policy object and policy applied to this backup item.
	RecoveryModel *string `json:"recoveryModel,omitempty"`

	// Number of backup copies available for this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
}

// AzureVMWorkloadProtectionPolicy - Azure VM (Mercury) workload-specific backup policy.
type AzureVMWorkloadProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Fix the policy inconsistency
	MakePolicyConsistent *bool `json:"makePolicyConsistent,omitempty"`

	// Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Common settings for the backup management
	Settings *Settings `json:"settings,omitempty"`

	// List of sub-protection policies which includes schedule and retention
	SubProtectionPolicy []*SubProtectionPolicy `json:"subProtectionPolicy,omitempty"`

	// Type of workload for the backup management
	WorkLoadType *WorkloadType `json:"workLoadType,omitempty"`
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureVMWorkloadProtectionPolicy.
func (a *AzureVMWorkloadProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		ProtectedItemsCount:            a.ProtectedItemsCount,
		BackupManagementType:           a.BackupManagementType,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureVMWorkloadSAPAseDatabaseProtectedItem - Azure VM workload-specific protected item representing SAP ASE Database.
type AzureVMWorkloadSAPAseDatabaseProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPAseDatabaseProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return &AzureVMWorkloadProtectedItem{
		FriendlyName:                     a.FriendlyName,
		ServerName:                       a.ServerName,
		ParentName:                       a.ParentName,
		ParentType:                       a.ParentType,
		ProtectionStatus:                 a.ProtectionStatus,
		ProtectionState:                  a.ProtectionState,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastBackupErrorDetail:            a.LastBackupErrorDetail,
		ProtectedItemDataSourceID:        a.ProtectedItemDataSourceID,
		ProtectedItemHealthStatus:        a.ProtectedItemHealthStatus,
		ExtendedInfo:                     a.ExtendedInfo,
		KpisHealths:                      a.KpisHealths,
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPAseDatabaseProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureVMWorkloadSAPAseDatabaseWorkloadItem - Azure VM workload-specific workload item representing SAP ASE Database.
type AzureVMWorkloadSAPAseDatabaseWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPAseDatabaseWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		ParentName:           a.ParentName,
		ServerName:           a.ServerName,
		IsAutoProtectable:    a.IsAutoProtectable,
		Subinquireditemcount: a.Subinquireditemcount,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPAseDatabaseWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSAPAseSystemProtectableItem - Azure VM workload-specific protectable item representing SAP ASE System.
type AzureVMWorkloadSAPAseSystemProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPAseSystemProtectableItem.
func (a *AzureVMWorkloadSAPAseSystemProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		ServerName:              a.ServerName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		Prebackupvalidation:     a.Prebackupvalidation,
		BackupManagementType:    a.BackupManagementType,
		WorkloadType:            a.WorkloadType,
		ProtectableItemType:     a.ProtectableItemType,
		FriendlyName:            a.FriendlyName,
		ProtectionState:         a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPAseSystemProtectableItem.
func (a *AzureVMWorkloadSAPAseSystemProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSAPAseSystemWorkloadItem - Azure VM workload-specific workload item representing SAP ASE System.
type AzureVMWorkloadSAPAseSystemWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPAseSystemWorkloadItem.
func (a *AzureVMWorkloadSAPAseSystemWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		ParentName:           a.ParentName,
		ServerName:           a.ServerName,
		IsAutoProtectable:    a.IsAutoProtectable,
		Subinquireditemcount: a.Subinquireditemcount,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPAseSystemWorkloadItem.
func (a *AzureVMWorkloadSAPAseSystemWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSAPHanaDatabaseProtectableItem - Azure VM workload-specific protectable item representing SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		ServerName:              a.ServerName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		Prebackupvalidation:     a.Prebackupvalidation,
		BackupManagementType:    a.BackupManagementType,
		WorkloadType:            a.WorkloadType,
		ProtectableItemType:     a.ProtectableItemType,
		FriendlyName:            a.FriendlyName,
		ProtectionState:         a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSAPHanaDatabaseProtectedItem - Azure VM workload-specific protected item representing SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return &AzureVMWorkloadProtectedItem{
		FriendlyName:                     a.FriendlyName,
		ServerName:                       a.ServerName,
		ParentName:                       a.ParentName,
		ParentType:                       a.ParentType,
		ProtectionStatus:                 a.ProtectionStatus,
		ProtectionState:                  a.ProtectionState,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastBackupErrorDetail:            a.LastBackupErrorDetail,
		ProtectedItemDataSourceID:        a.ProtectedItemDataSourceID,
		ProtectedItemHealthStatus:        a.ProtectedItemHealthStatus,
		ExtendedInfo:                     a.ExtendedInfo,
		KpisHealths:                      a.KpisHealths,
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureVMWorkloadSAPHanaDatabaseWorkloadItem - Azure VM workload-specific workload item representing SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPHanaDatabaseWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		ParentName:           a.ParentName,
		ServerName:           a.ServerName,
		IsAutoProtectable:    a.IsAutoProtectable,
		Subinquireditemcount: a.Subinquireditemcount,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPHanaDatabaseWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSAPHanaSystemProtectableItem - Azure VM workload-specific protectable item representing SAP HANA System.
type AzureVMWorkloadSAPHanaSystemProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaSystemProtectableItem.
func (a *AzureVMWorkloadSAPHanaSystemProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		ServerName:              a.ServerName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		Prebackupvalidation:     a.Prebackupvalidation,
		BackupManagementType:    a.BackupManagementType,
		WorkloadType:            a.WorkloadType,
		ProtectableItemType:     a.ProtectableItemType,
		FriendlyName:            a.FriendlyName,
		ProtectionState:         a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaSystemProtectableItem.
func (a *AzureVMWorkloadSAPHanaSystemProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSAPHanaSystemWorkloadItem - Azure VM workload-specific workload item representing SAP HANA System.
type AzureVMWorkloadSAPHanaSystemWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (a *AzureVMWorkloadSAPHanaSystemWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		ParentName:           a.ParentName,
		ServerName:           a.ServerName,
		IsAutoProtectable:    a.IsAutoProtectable,
		Subinquireditemcount: a.Subinquireditemcount,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (a *AzureVMWorkloadSAPHanaSystemWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSQLAvailabilityGroupProtectableItem - Azure VM workload-specific protectable item representing SQL Availability
// Group.
type AzureVMWorkloadSQLAvailabilityGroupProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (a *AzureVMWorkloadSQLAvailabilityGroupProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		ServerName:              a.ServerName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		Prebackupvalidation:     a.Prebackupvalidation,
		BackupManagementType:    a.BackupManagementType,
		WorkloadType:            a.WorkloadType,
		ProtectableItemType:     a.ProtectableItemType,
		FriendlyName:            a.FriendlyName,
		ProtectionState:         a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (a *AzureVMWorkloadSQLAvailabilityGroupProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSQLDatabaseProtectableItem - Azure VM workload-specific protectable item representing SQL Database.
type AzureVMWorkloadSQLDatabaseProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectableItem.
func (a *AzureVMWorkloadSQLDatabaseProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		ServerName:              a.ServerName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		Prebackupvalidation:     a.Prebackupvalidation,
		BackupManagementType:    a.BackupManagementType,
		WorkloadType:            a.WorkloadType,
		ProtectableItemType:     a.ProtectableItemType,
		FriendlyName:            a.FriendlyName,
		ProtectionState:         a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectableItem.
func (a *AzureVMWorkloadSQLDatabaseProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSQLDatabaseProtectedItem - Azure VM workload-specific protected item representing SQL Database.
type AzureVMWorkloadSQLDatabaseProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the DB represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails `json:"kpisHealths,omitempty"`

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail `json:"lastBackupErrorDetail,omitempty"`

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string `json:"parentName,omitempty"`

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string `json:"parentType,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string `json:"protectedItemDataSourceId,omitempty"`

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus `json:"protectedItemHealthStatus,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// Backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectedItem.
func (a *AzureVMWorkloadSQLDatabaseProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return &AzureVMWorkloadProtectedItem{
		FriendlyName:                     a.FriendlyName,
		ServerName:                       a.ServerName,
		ParentName:                       a.ParentName,
		ParentType:                       a.ParentType,
		ProtectionStatus:                 a.ProtectionStatus,
		ProtectionState:                  a.ProtectionState,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastBackupErrorDetail:            a.LastBackupErrorDetail,
		ProtectedItemDataSourceID:        a.ProtectedItemDataSourceID,
		ProtectedItemHealthStatus:        a.ProtectedItemHealthStatus,
		ExtendedInfo:                     a.ExtendedInfo,
		KpisHealths:                      a.KpisHealths,
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectedItem.
func (a *AzureVMWorkloadSQLDatabaseProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                a.ProtectedItemType,
		BackupManagementType:             a.BackupManagementType,
		WorkloadType:                     a.WorkloadType,
		ContainerName:                    a.ContainerName,
		SourceResourceID:                 a.SourceResourceID,
		PolicyID:                         a.PolicyID,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		BackupSetName:                    a.BackupSetName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		PolicyName:                       a.PolicyName,
	}
}

// AzureVMWorkloadSQLDatabaseWorkloadItem - Azure VM workload-specific workload item representing SQL Database.
type AzureVMWorkloadSQLDatabaseWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSQLDatabaseWorkloadItem.
func (a *AzureVMWorkloadSQLDatabaseWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		ParentName:           a.ParentName,
		ServerName:           a.ServerName,
		IsAutoProtectable:    a.IsAutoProtectable,
		Subinquireditemcount: a.Subinquireditemcount,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSQLDatabaseWorkloadItem.
func (a *AzureVMWorkloadSQLDatabaseWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSQLInstanceProtectableItem - Azure VM workload-specific protectable item representing SQL Instance.
type AzureVMWorkloadSQLInstanceProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool `json:"isAutoProtected,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string `json:"parentUniqueName,omitempty"`

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation `json:"prebackupvalidation,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32 `json:"subprotectableitemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLInstanceProtectableItem.
func (a *AzureVMWorkloadSQLInstanceProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		ServerName:              a.ServerName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		Prebackupvalidation:     a.Prebackupvalidation,
		BackupManagementType:    a.BackupManagementType,
		WorkloadType:            a.WorkloadType,
		ProtectableItemType:     a.ProtectableItemType,
		FriendlyName:            a.FriendlyName,
		ProtectionState:         a.ProtectionState,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLInstanceProtectableItem.
func (a *AzureVMWorkloadSQLInstanceProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		ProtectableItemType:  a.ProtectableItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureVMWorkloadSQLInstanceWorkloadItem - Azure VM workload-specific workload item representing SQL Instance.
type AzureVMWorkloadSQLInstanceWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Data Directory Paths for default directories
	DataDirectoryPaths []*SQLDataDirectory `json:"dataDirectoryPaths,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool `json:"isAutoProtectable,omitempty"`

	// Name for instance or AG
	ParentName *string `json:"parentName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Host/Cluster Name for instance or AG
	ServerName *string `json:"serverName,omitempty"`

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32 `json:"subWorkloadItemCount,omitempty"`

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32 `json:"subinquireditemcount,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSQLInstanceWorkloadItem.
func (a *AzureVMWorkloadSQLInstanceWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		ParentName:           a.ParentName,
		ServerName:           a.ServerName,
		IsAutoProtectable:    a.IsAutoProtectable,
		Subinquireditemcount: a.Subinquireditemcount,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSQLInstanceWorkloadItem.
func (a *AzureVMWorkloadSQLInstanceWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		WorkloadType:         a.WorkloadType,
		WorkloadItemType:     a.WorkloadItemType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
	}
}

// AzureWorkloadAutoProtectionIntentClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadAutoProtectionIntent() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadAutoProtectionIntent, *AzureWorkloadSQLAutoProtectionIntent
type AzureWorkloadAutoProtectionIntentClassification interface {
	AzureRecoveryServiceVaultProtectionIntentClassification
	// GetAzureWorkloadAutoProtectionIntent returns the AzureWorkloadAutoProtectionIntent content of the underlying type.
	GetAzureWorkloadAutoProtectionIntent() *AzureWorkloadAutoProtectionIntent
}

// AzureWorkloadAutoProtectionIntent - Azure Recovery Services Vault specific protection intent item.
type AzureWorkloadAutoProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetAzureRecoveryServiceVaultProtectionIntent implements the AzureRecoveryServiceVaultProtectionIntentClassification interface
// for type AzureWorkloadAutoProtectionIntent.
func (a *AzureWorkloadAutoProtectionIntent) GetAzureRecoveryServiceVaultProtectionIntent() *AzureRecoveryServiceVaultProtectionIntent {
	return &AzureRecoveryServiceVaultProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// GetAzureWorkloadAutoProtectionIntent implements the AzureWorkloadAutoProtectionIntentClassification interface for type
// AzureWorkloadAutoProtectionIntent.
func (a *AzureWorkloadAutoProtectionIntent) GetAzureWorkloadAutoProtectionIntent() *AzureWorkloadAutoProtectionIntent {
	return a
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureWorkloadAutoProtectionIntent.
func (a *AzureWorkloadAutoProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// AzureWorkloadBackupRequest - AzureWorkload workload-specific backup request.
type AzureWorkloadBackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Type of backup, viz. Full, Differential, Log or CopyOnlyFull
	BackupType *BackupType `json:"backupType,omitempty"`

	// Bool for Compression setting
	EnableCompression *bool `json:"enableCompression,omitempty"`

	// Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *time.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
}

// GetBackupRequest implements the BackupRequestClassification interface for type AzureWorkloadBackupRequest.
func (a *AzureWorkloadBackupRequest) GetBackupRequest() *BackupRequest {
	return &BackupRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadContainerClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadContainer() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureSQLAGWorkloadContainerProtectionContainer, *AzureVMAppContainerProtectionContainer, *AzureWorkloadContainer
type AzureWorkloadContainerClassification interface {
	ProtectionContainerClassification
	// GetAzureWorkloadContainer returns the AzureWorkloadContainer content of the underlying type.
	GetAzureWorkloadContainer() *AzureWorkloadContainer
}

// AzureWorkloadContainer - Container for the workloads running inside Azure Compute or Classic Compute.
type AzureWorkloadContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Time stamp when this container was updated.
	LastUpdatedTime *time.Time `json:"lastUpdatedTime,omitempty"`

	// Re-Do Operation
	OperationType *OperationType `json:"operationType,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Workload type for which registration was sent.
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// GetAzureWorkloadContainer implements the AzureWorkloadContainerClassification interface for type AzureWorkloadContainer.
func (a *AzureWorkloadContainer) GetAzureWorkloadContainer() *AzureWorkloadContainer { return a }

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureWorkloadContainer.
func (a *AzureWorkloadContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          a.FriendlyName,
		BackupManagementType:  a.BackupManagementType,
		RegistrationStatus:    a.RegistrationStatus,
		HealthStatus:          a.HealthStatus,
		ContainerType:         a.ContainerType,
		ProtectableObjectType: a.ProtectableObjectType,
	}
}

// AzureWorkloadContainerAutoProtectionIntent - Azure workload specific protection intent item.
type AzureWorkloadContainerAutoProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureWorkloadContainerAutoProtectionIntent.
func (a *AzureWorkloadContainerAutoProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// AzureWorkloadContainerExtendedInfo - Extended information of the container.
type AzureWorkloadContainerExtendedInfo struct {
	// Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
	HostServerName *string `json:"hostServerName,omitempty"`

	// Inquiry Status for the container.
	InquiryInfo *InquiryInfo `json:"inquiryInfo,omitempty"`

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo `json:"nodesList,omitempty"`
}

// AzureWorkloadErrorInfo - Azure storage specific error information
type AzureWorkloadErrorInfo struct {
	// Additional details for above error code.
	AdditionalDetails *string `json:"additionalDetails,omitempty"`

	// Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`

	// Localized error string.
	ErrorString *string `json:"errorString,omitempty"`

	// Title: Typically, the entity that the error pertains to.
	ErrorTitle *string `json:"errorTitle,omitempty"`

	// List of localized recommendations for above error code.
	Recommendations []*string `json:"recommendations,omitempty"`
}

// AzureWorkloadJob - Azure storage specific job.
type AzureWorkloadJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction `json:"actionsInfo,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// Error details on execution of this job.
	ErrorDetails []*AzureWorkloadErrorInfo `json:"errorDetails,omitempty"`

	// Additional information about the job.
	ExtendedInfo *AzureWorkloadJobExtendedInfo `json:"extendedInfo,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`

	// Workload type of the job
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetJob implements the JobClassification interface for type AzureWorkloadJob.
func (a *AzureWorkloadJob) GetJob() *Job {
	return &Job{
		EntityFriendlyName:   a.EntityFriendlyName,
		BackupManagementType: a.BackupManagementType,
		Operation:            a.Operation,
		Status:               a.Status,
		StartTime:            a.StartTime,
		EndTime:              a.EndTime,
		ActivityID:           a.ActivityID,
		JobType:              a.JobType,
	}
}

// AzureWorkloadJobExtendedInfo - Azure VM workload-specific additional information for job.
type AzureWorkloadJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`

	// Job properties.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// List of tasks for this job
	TasksList []*AzureWorkloadJobTaskDetails `json:"tasksList,omitempty"`
}

// AzureWorkloadJobTaskDetails - Azure VM workload specific job task details.
type AzureWorkloadJobTaskDetails struct {
	// The status.
	Status *string `json:"status,omitempty"`

	// The task display name.
	TaskID *string `json:"taskId,omitempty"`
}

// AzureWorkloadPointInTimeRecoveryPointClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadPointInTimeRecoveryPoint() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadPointInTimeRecoveryPoint, *AzureWorkloadSAPHanaPointInTimeRecoveryPoint
type AzureWorkloadPointInTimeRecoveryPointClassification interface {
	AzureWorkloadRecoveryPointClassification
	// GetAzureWorkloadPointInTimeRecoveryPoint returns the AzureWorkloadPointInTimeRecoveryPoint content of the underlying type.
	GetAzureWorkloadPointInTimeRecoveryPoint() *AzureWorkloadPointInTimeRecoveryPoint
}

// AzureWorkloadPointInTimeRecoveryPoint - Recovery point specific to PointInTime
type AzureWorkloadPointInTimeRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo `json:"recoveryPointMoveReadinessInfo,omitempty"`

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2 `json:"recoveryPointTierDetails,omitempty"`

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time `json:"recoveryPointTimeInUTC,omitempty"`

	// List of log ranges
	TimeRanges []*PointInTimeRange `json:"timeRanges,omitempty"`

	// Type of restore point
	Type *RestorePointType `json:"type,omitempty"`
}

// GetAzureWorkloadPointInTimeRecoveryPoint implements the AzureWorkloadPointInTimeRecoveryPointClassification interface for
// type AzureWorkloadPointInTimeRecoveryPoint.
func (a *AzureWorkloadPointInTimeRecoveryPoint) GetAzureWorkloadPointInTimeRecoveryPoint() *AzureWorkloadPointInTimeRecoveryPoint {
	return a
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadPointInTimeRecoveryPoint.
func (a *AzureWorkloadPointInTimeRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		ObjectType:                     a.ObjectType,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadPointInTimeRecoveryPoint.
func (a *AzureWorkloadPointInTimeRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadPointInTimeRestoreRequest - AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log restore
type AzureWorkloadPointInTimeRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// PointInTime value
	PointInTime *time.Time `json:"pointInTime,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadPointInTimeRestoreRequest.
func (a *AzureWorkloadPointInTimeRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadPointInTimeRestoreRequest.
func (a *AzureWorkloadPointInTimeRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadRecoveryPointClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadRecoveryPoint() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadPointInTimeRecoveryPoint, *AzureWorkloadRecoveryPoint, *AzureWorkloadSAPHanaPointInTimeRecoveryPoint, *AzureWorkloadSAPHanaRecoveryPoint,
// - *AzureWorkloadSQLPointInTimeRecoveryPoint, *AzureWorkloadSQLRecoveryPoint
type AzureWorkloadRecoveryPointClassification interface {
	RecoveryPointClassification
	// GetAzureWorkloadRecoveryPoint returns the AzureWorkloadRecoveryPoint content of the underlying type.
	GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint
}

// AzureWorkloadRecoveryPoint - Workload specific recovery point, specifically encapsulates full/diff recovery point
type AzureWorkloadRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo `json:"recoveryPointMoveReadinessInfo,omitempty"`

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2 `json:"recoveryPointTierDetails,omitempty"`

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time `json:"recoveryPointTimeInUTC,omitempty"`

	// Type of restore point
	Type *RestorePointType `json:"type,omitempty"`
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadRecoveryPoint.
func (a *AzureWorkloadRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return a
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadRecoveryPoint.
func (a *AzureWorkloadRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadPointInTimeRestoreRequest, *AzureWorkloadRestoreRequest, *AzureWorkloadSAPHanaPointInTimeRestoreRequest,
// - *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest, *AzureWorkloadSAPHanaRestoreRequest, *AzureWorkloadSAPHanaRestoreWithRehydrateRequest,
// - *AzureWorkloadSQLPointInTimeRestoreRequest, *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest, *AzureWorkloadSQLRestoreRequest,
// - *AzureWorkloadSQLRestoreWithRehydrateRequest
type AzureWorkloadRestoreRequestClassification interface {
	RestoreRequestClassification
	// GetAzureWorkloadRestoreRequest returns the AzureWorkloadRestoreRequest content of the underlying type.
	GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest
}

// AzureWorkloadRestoreRequest - AzureWorkload-specific restore.
type AzureWorkloadRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadRestoreRequest.
func (a *AzureWorkloadRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return a
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadRestoreRequest.
func (a *AzureWorkloadRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaPointInTimeRecoveryPoint - Recovery point specific to PointInTime in SAPHana
type AzureWorkloadSAPHanaPointInTimeRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo `json:"recoveryPointMoveReadinessInfo,omitempty"`

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2 `json:"recoveryPointTierDetails,omitempty"`

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time `json:"recoveryPointTimeInUTC,omitempty"`

	// List of log ranges
	TimeRanges []*PointInTimeRange `json:"timeRanges,omitempty"`

	// Type of restore point
	Type *RestorePointType `json:"type,omitempty"`
}

// GetAzureWorkloadPointInTimeRecoveryPoint implements the AzureWorkloadPointInTimeRecoveryPointClassification interface for
// type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a *AzureWorkloadSAPHanaPointInTimeRecoveryPoint) GetAzureWorkloadPointInTimeRecoveryPoint() *AzureWorkloadPointInTimeRecoveryPoint {
	return &AzureWorkloadPointInTimeRecoveryPoint{
		TimeRanges:                     a.TimeRanges,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		ObjectType:                     a.ObjectType,
	}
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a *AzureWorkloadSAPHanaPointInTimeRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		ObjectType:                     a.ObjectType,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a *AzureWorkloadSAPHanaPointInTimeRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaPointInTimeRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadSAPHanaPointInTimeRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadSAPHanaPointInTimeRestoreRequest, *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest
type AzureWorkloadSAPHanaPointInTimeRestoreRequestClassification interface {
	AzureWorkloadSAPHanaRestoreRequestClassification
	// GetAzureWorkloadSAPHanaPointInTimeRestoreRequest returns the AzureWorkloadSAPHanaPointInTimeRestoreRequest content of the underlying type.
	GetAzureWorkloadSAPHanaPointInTimeRestoreRequest() *AzureWorkloadSAPHanaPointInTimeRestoreRequest
}

// AzureWorkloadSAPHanaPointInTimeRestoreRequest - AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log
// restore
type AzureWorkloadSAPHanaPointInTimeRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// PointInTime value
	PointInTime *time.Time `json:"pointInTime,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSAPHanaPointInTimeRestoreRequest implements the AzureWorkloadSAPHanaPointInTimeRestoreRequestClassification
// interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetAzureWorkloadSAPHanaPointInTimeRestoreRequest() *AzureWorkloadSAPHanaPointInTimeRestoreRequest {
	return a
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return &AzureWorkloadSAPHanaRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest - AzureWorkload SAP Hana-specific restore with integrated rehydration
// of recovery point.
type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// PointInTime value
	PointInTime *time.Time `json:"pointInTime,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo `json:"recoveryPointRehydrationInfo,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSAPHanaPointInTimeRestoreRequest implements the AzureWorkloadSAPHanaPointInTimeRestoreRequestClassification
// interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSAPHanaPointInTimeRestoreRequest() *AzureWorkloadSAPHanaPointInTimeRestoreRequest {
	return &AzureWorkloadSAPHanaPointInTimeRestoreRequest{
		PointInTime:            a.PointInTime,
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return &AzureWorkloadSAPHanaRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaRecoveryPoint - SAPHana specific recoverypoint, specifically encapsulates full/diff recoverypoints
type AzureWorkloadSAPHanaRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo `json:"recoveryPointMoveReadinessInfo,omitempty"`

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2 `json:"recoveryPointTierDetails,omitempty"`

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time `json:"recoveryPointTimeInUTC,omitempty"`

	// Type of restore point
	Type *RestorePointType `json:"type,omitempty"`
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSAPHanaRecoveryPoint.
func (a *AzureWorkloadSAPHanaRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		ObjectType:                     a.ObjectType,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSAPHanaRecoveryPoint.
func (a *AzureWorkloadSAPHanaRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadSAPHanaRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadSAPHanaPointInTimeRestoreRequest, *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest, *AzureWorkloadSAPHanaRestoreRequest,
// - *AzureWorkloadSAPHanaRestoreWithRehydrateRequest
type AzureWorkloadSAPHanaRestoreRequestClassification interface {
	AzureWorkloadRestoreRequestClassification
	// GetAzureWorkloadSAPHanaRestoreRequest returns the AzureWorkloadSAPHanaRestoreRequest content of the underlying type.
	GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest
}

// AzureWorkloadSAPHanaRestoreRequest - AzureWorkload SAP Hana-specific restore.
type AzureWorkloadSAPHanaRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreRequest.
func (a *AzureWorkloadSAPHanaRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaRestoreRequest.
func (a *AzureWorkloadSAPHanaRestoreRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return a
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreRequest.
func (a *AzureWorkloadSAPHanaRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaRestoreWithRehydrateRequest - AzureWorkload SAP Hana-specific restore with integrated rehydration of
// recovery point.
type AzureWorkloadSAPHanaRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo `json:"recoveryPointRehydrationInfo,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaRestoreWithRehydrateRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return &AzureWorkloadSAPHanaRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLAutoProtectionIntent - Azure Workload SQL Auto Protection intent item.
type AzureWorkloadSQLAutoProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Workload item type of the item for which intent is to be set
	WorkloadItemType *WorkloadItemType `json:"workloadItemType,omitempty"`
}

// GetAzureRecoveryServiceVaultProtectionIntent implements the AzureRecoveryServiceVaultProtectionIntentClassification interface
// for type AzureWorkloadSQLAutoProtectionIntent.
func (a *AzureWorkloadSQLAutoProtectionIntent) GetAzureRecoveryServiceVaultProtectionIntent() *AzureRecoveryServiceVaultProtectionIntent {
	return &AzureRecoveryServiceVaultProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// GetAzureWorkloadAutoProtectionIntent implements the AzureWorkloadAutoProtectionIntentClassification interface for type
// AzureWorkloadSQLAutoProtectionIntent.
func (a *AzureWorkloadSQLAutoProtectionIntent) GetAzureWorkloadAutoProtectionIntent() *AzureWorkloadAutoProtectionIntent {
	return &AzureWorkloadAutoProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureWorkloadSQLAutoProtectionIntent.
func (a *AzureWorkloadSQLAutoProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		BackupManagementType:     a.BackupManagementType,
		SourceResourceID:         a.SourceResourceID,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionState:          a.ProtectionState,
	}
}

// AzureWorkloadSQLPointInTimeRecoveryPoint - Recovery point specific to PointInTime
type AzureWorkloadSQLPointInTimeRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Extended Info that provides data directory details. Will be populated in two cases: When a specific recovery point is accessed
	// using GetRecoveryPoint Or when ListRecoveryPoints is called for Log RP
	// only with ExtendedInfo query filter
	ExtendedInfo *AzureWorkloadSQLRecoveryPointExtendedInfo `json:"extendedInfo,omitempty"`

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo `json:"recoveryPointMoveReadinessInfo,omitempty"`

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2 `json:"recoveryPointTierDetails,omitempty"`

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time `json:"recoveryPointTimeInUTC,omitempty"`

	// List of log ranges
	TimeRanges []*PointInTimeRange `json:"timeRanges,omitempty"`

	// Type of restore point
	Type *RestorePointType `json:"type,omitempty"`
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a *AzureWorkloadSQLPointInTimeRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		ObjectType:                     a.ObjectType,
	}
}

// GetAzureWorkloadSQLRecoveryPoint implements the AzureWorkloadSQLRecoveryPointClassification interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a *AzureWorkloadSQLPointInTimeRecoveryPoint) GetAzureWorkloadSQLRecoveryPoint() *AzureWorkloadSQLRecoveryPoint {
	return &AzureWorkloadSQLRecoveryPoint{
		ExtendedInfo:                   a.ExtendedInfo,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		ObjectType:                     a.ObjectType,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a *AzureWorkloadSQLPointInTimeRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLPointInTimeRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadSQLPointInTimeRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadSQLPointInTimeRestoreRequest, *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest
type AzureWorkloadSQLPointInTimeRestoreRequestClassification interface {
	AzureWorkloadSQLRestoreRequestClassification
	// GetAzureWorkloadSQLPointInTimeRestoreRequest returns the AzureWorkloadSQLPointInTimeRestoreRequest content of the underlying type.
	GetAzureWorkloadSQLPointInTimeRestoreRequest() *AzureWorkloadSQLPointInTimeRestoreRequest
}

// AzureWorkloadSQLPointInTimeRestoreRequest - AzureWorkload SQL -specific restore. Specifically for PointInTime/Log restore
type AzureWorkloadSQLPointInTimeRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping `json:"alternateDirectoryPaths,omitempty"`

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool `json:"isNonRecoverable,omitempty"`

	// PointInTime value
	PointInTime *time.Time `json:"pointInTime,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool `json:"shouldUseAlternateTargetLocation,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSQLPointInTimeRestoreRequest implements the AzureWorkloadSQLPointInTimeRestoreRequestClassification interface
// for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetAzureWorkloadSQLPointInTimeRestoreRequest() *AzureWorkloadSQLPointInTimeRestoreRequest {
	return a
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return &AzureWorkloadSQLRestoreRequest{
		ShouldUseAlternateTargetLocation: a.ShouldUseAlternateTargetLocation,
		IsNonRecoverable:                 a.IsNonRecoverable,
		AlternateDirectoryPaths:          a.AlternateDirectoryPaths,
		RecoveryType:                     a.RecoveryType,
		SourceResourceID:                 a.SourceResourceID,
		PropertyBag:                      a.PropertyBag,
		TargetInfo:                       a.TargetInfo,
		RecoveryMode:                     a.RecoveryMode,
		TargetVirtualMachineID:           a.TargetVirtualMachineID,
		ObjectType:                       a.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest - AzureWorkload SQL-specific restore with integrated rehydration
// of recovery point.
type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping `json:"alternateDirectoryPaths,omitempty"`

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool `json:"isNonRecoverable,omitempty"`

	// PointInTime value
	PointInTime *time.Time `json:"pointInTime,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo `json:"recoveryPointRehydrationInfo,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool `json:"shouldUseAlternateTargetLocation,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSQLPointInTimeRestoreRequest implements the AzureWorkloadSQLPointInTimeRestoreRequestClassification interface
// for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSQLPointInTimeRestoreRequest() *AzureWorkloadSQLPointInTimeRestoreRequest {
	return &AzureWorkloadSQLPointInTimeRestoreRequest{
		PointInTime:                      a.PointInTime,
		ShouldUseAlternateTargetLocation: a.ShouldUseAlternateTargetLocation,
		IsNonRecoverable:                 a.IsNonRecoverable,
		AlternateDirectoryPaths:          a.AlternateDirectoryPaths,
		RecoveryType:                     a.RecoveryType,
		SourceResourceID:                 a.SourceResourceID,
		PropertyBag:                      a.PropertyBag,
		TargetInfo:                       a.TargetInfo,
		RecoveryMode:                     a.RecoveryMode,
		TargetVirtualMachineID:           a.TargetVirtualMachineID,
		ObjectType:                       a.ObjectType,
	}
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return &AzureWorkloadSQLRestoreRequest{
		ShouldUseAlternateTargetLocation: a.ShouldUseAlternateTargetLocation,
		IsNonRecoverable:                 a.IsNonRecoverable,
		AlternateDirectoryPaths:          a.AlternateDirectoryPaths,
		RecoveryType:                     a.RecoveryType,
		SourceResourceID:                 a.SourceResourceID,
		PropertyBag:                      a.PropertyBag,
		TargetInfo:                       a.TargetInfo,
		RecoveryMode:                     a.RecoveryMode,
		TargetVirtualMachineID:           a.TargetVirtualMachineID,
		ObjectType:                       a.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLRecoveryPointClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadSQLRecoveryPoint() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadSQLPointInTimeRecoveryPoint, *AzureWorkloadSQLRecoveryPoint
type AzureWorkloadSQLRecoveryPointClassification interface {
	AzureWorkloadRecoveryPointClassification
	// GetAzureWorkloadSQLRecoveryPoint returns the AzureWorkloadSQLRecoveryPoint content of the underlying type.
	GetAzureWorkloadSQLRecoveryPoint() *AzureWorkloadSQLRecoveryPoint
}

// AzureWorkloadSQLRecoveryPoint - SQL specific recoverypoint, specifically encapsulates full/diff recoverypoint along with
// extended info
type AzureWorkloadSQLRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Extended Info that provides data directory details. Will be populated in two cases: When a specific recovery point is accessed
	// using GetRecoveryPoint Or when ListRecoveryPoints is called for Log RP
	// only with ExtendedInfo query filter
	ExtendedInfo *AzureWorkloadSQLRecoveryPointExtendedInfo `json:"extendedInfo,omitempty"`

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo `json:"recoveryPointMoveReadinessInfo,omitempty"`

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2 `json:"recoveryPointTierDetails,omitempty"`

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time `json:"recoveryPointTimeInUTC,omitempty"`

	// Type of restore point
	Type *RestorePointType `json:"type,omitempty"`
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSQLRecoveryPoint.
func (a *AzureWorkloadSQLRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		ObjectType:                     a.ObjectType,
	}
}

// GetAzureWorkloadSQLRecoveryPoint implements the AzureWorkloadSQLRecoveryPointClassification interface for type AzureWorkloadSQLRecoveryPoint.
func (a *AzureWorkloadSQLRecoveryPoint) GetAzureWorkloadSQLRecoveryPoint() *AzureWorkloadSQLRecoveryPoint {
	return a
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSQLRecoveryPoint.
func (a *AzureWorkloadSQLRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLRecoveryPointExtendedInfo - Extended info class details
type AzureWorkloadSQLRecoveryPointExtendedInfo struct {
	// List of data directory paths during restore operation.
	DataDirectoryPaths []*SQLDataDirectory `json:"dataDirectoryPaths,omitempty"`

	// UTC time at which data directory info was captured
	DataDirectoryTimeInUTC *time.Time `json:"dataDirectoryTimeInUTC,omitempty"`
}

// AzureWorkloadSQLRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetAzureWorkloadSQLRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureWorkloadSQLPointInTimeRestoreRequest, *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest, *AzureWorkloadSQLRestoreRequest,
// - *AzureWorkloadSQLRestoreWithRehydrateRequest
type AzureWorkloadSQLRestoreRequestClassification interface {
	AzureWorkloadRestoreRequestClassification
	// GetAzureWorkloadSQLRestoreRequest returns the AzureWorkloadSQLRestoreRequest content of the underlying type.
	GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest
}

// AzureWorkloadSQLRestoreRequest - AzureWorkload SQL -specific restore. Specifically for full/diff restore
type AzureWorkloadSQLRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping `json:"alternateDirectoryPaths,omitempty"`

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool `json:"isNonRecoverable,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool `json:"shouldUseAlternateTargetLocation,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLRestoreRequest.
func (a *AzureWorkloadSQLRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLRestoreRequest.
func (a *AzureWorkloadSQLRestoreRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return a
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLRestoreRequest.
func (a *AzureWorkloadSQLRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLRestoreWithRehydrateRequest - AzureWorkload SQL-specific restore with integrated rehydration of recovery
// point
type AzureWorkloadSQLRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping `json:"alternateDirectoryPaths,omitempty"`

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool `json:"isNonRecoverable,omitempty"`

	// Workload specific property bag.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode `json:"recoveryMode,omitempty"`

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo `json:"recoveryPointRehydrationInfo,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool `json:"shouldUseAlternateTargetLocation,omitempty"`

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Details of target database
	TargetInfo *TargetRestoreInfo `json:"targetInfo,omitempty"`

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		RecoveryType:           a.RecoveryType,
		SourceResourceID:       a.SourceResourceID,
		PropertyBag:            a.PropertyBag,
		TargetInfo:             a.TargetInfo,
		RecoveryMode:           a.RecoveryMode,
		TargetVirtualMachineID: a.TargetVirtualMachineID,
		ObjectType:             a.ObjectType,
	}
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLRestoreWithRehydrateRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return &AzureWorkloadSQLRestoreRequest{
		ShouldUseAlternateTargetLocation: a.ShouldUseAlternateTargetLocation,
		IsNonRecoverable:                 a.IsNonRecoverable,
		AlternateDirectoryPaths:          a.AlternateDirectoryPaths,
		RecoveryType:                     a.RecoveryType,
		SourceResourceID:                 a.SourceResourceID,
		PropertyBag:                      a.PropertyBag,
		TargetInfo:                       a.TargetInfo,
		RecoveryMode:                     a.RecoveryMode,
		TargetVirtualMachineID:           a.TargetVirtualMachineID,
		ObjectType:                       a.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// BEKDetails - BEK is bitlocker encryption key.
type BEKDetails struct {
	// BEK data.
	SecretData *string `json:"secretData,omitempty"`

	// Secret is BEK.
	SecretURL *string `json:"secretUrl,omitempty"`

	// ID of the Key Vault where this Secret is stored.
	SecretVaultID *string `json:"secretVaultId,omitempty"`
}

// BMSBackupEngineQueryObject - Query parameters to fetch list of backup engines.
type BMSBackupEngineQueryObject struct {
	// attribute to add extended info
	Expand *string `json:"expand,omitempty"`
}

// BMSBackupEnginesQueryObject - Query parameters to fetch list of backup engines.
type BMSBackupEnginesQueryObject struct {
	// Backup management type for the backup engine.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Attribute to add extended info.
	Expand *string `json:"expand,omitempty"`

	// Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// BMSBackupSummariesQueryObject - Query parameters to fetch backup summaries.
type BMSBackupSummariesQueryObject struct {
	// Backup management type for this container.
	Type *Type `json:"type,omitempty"`
}

// BMSContainerQueryObject - The query filters that can be used with the list containers API.
type BMSContainerQueryObject struct {
	// REQUIRED; Backup management type for this container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Backup engine name
	BackupEngineName *string `json:"backupEngineName,omitempty"`

	// Type of container for filter
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Fabric name for filter
	FabricName *string `json:"fabricName,omitempty"`

	// Friendly name of this container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of registration of this container with the Recovery Services Vault.
	Status *string `json:"status,omitempty"`
}

// BMSContainersInquiryQueryObject - The query filters that can be used with the inquire container API.
type BMSContainersInquiryQueryObject struct {
	// Backup management type for this container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Workload type for this container.
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// BMSPOQueryObject - Filters to list items that can be backed up.
type BMSPOQueryObject struct {
	// Backup management type.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Full name of the container whose Protectable Objects should be returned.
	ContainerName *string `json:"containerName,omitempty"`

	// Friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Backup status query parameter.
	Status *string `json:"status,omitempty"`

	// Workload type
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// BMSPrepareDataMoveOperationResultClientGetOptions contains the optional parameters for the BMSPrepareDataMoveOperationResultClient.Get
// method.
type BMSPrepareDataMoveOperationResultClientGetOptions struct {
	// placeholder for future optional parameters
}

// BMSRPQueryObject - Filters to list backup copies.
type BMSRPQueryObject struct {
	// Backup copies created before this time.
	EndDate *time.Time `json:"endDate,omitempty"`

	// In Get Recovery Point, it tells whether extended information about recovery point is asked.
	ExtendedInfo *bool `json:"extendedInfo,omitempty"`

	// Whether the RP can be moved to another tier
	MoveReadyRPOnly *bool `json:"moveReadyRPOnly,omitempty"`

	// RestorePoint type
	RestorePointQueryType *RestorePointQueryType `json:"restorePointQueryType,omitempty"`

	// Backup copies created after this time.
	StartDate *time.Time `json:"startDate,omitempty"`
}

// BMSRefreshContainersQueryObject - The query filters that can be used with the refresh container API.
type BMSRefreshContainersQueryObject struct {
	// Backup management type for this container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`
}

// BMSWorkloadItemQueryObject - Filters to list items that can be backed up.
type BMSWorkloadItemQueryObject struct {
	// Backup management type.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Backup status query parameter.
	ProtectionStatus *ProtectionStatus `json:"protectionStatus,omitempty"`

	// Workload Item type
	WorkloadItemType *WorkloadItemType `json:"workloadItemType,omitempty"`

	// Workload type
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// BackupEngineBaseClassification provides polymorphic access to related types.
// Call the interface's GetBackupEngineBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupServerEngine, *BackupEngineBase, *DpmBackupEngine
type BackupEngineBaseClassification interface {
	// GetBackupEngineBase returns the BackupEngineBase content of the underlying type.
	GetBackupEngineBase() *BackupEngineBase
}

// BackupEngineBase - The base backup engine class. All workload specific backup engines derive from this class.
type BackupEngineBase struct {
	// REQUIRED; Type of the backup engine.
	BackupEngineType *BackupEngineType `json:"backupEngineType,omitempty"`

	// Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`

	// ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`

	// Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`

	// Type of backup management for the backup engine.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`

	// Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`

	// Extended info of the backupengine
	ExtendedInfo *BackupEngineExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`

	// To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`

	// Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// GetBackupEngineBase implements the BackupEngineBaseClassification interface for type BackupEngineBase.
func (b *BackupEngineBase) GetBackupEngineBase() *BackupEngineBase { return b }

// BackupEngineBaseResource - The base backup engine class. All workload specific backup engines derive from this class.
type BackupEngineBaseResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// BackupEngineBaseResource properties
	Properties BackupEngineBaseClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupEngineBaseResourceList - List of BackupEngineBase resources
type BackupEngineBaseResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*BackupEngineBaseResource `json:"value,omitempty"`
}

// BackupEngineExtendedInfo - Additional information on backup engine.
type BackupEngineExtendedInfo struct {
	// Disk space currently available in the backup engine.
	AvailableDiskSpace *float64 `json:"availableDiskSpace,omitempty"`

	// Protected instances in the backup engine.
	AzureProtectedInstances *int32 `json:"azureProtectedInstances,omitempty"`

	// Database name of backup engine.
	DatabaseName *string `json:"databaseName,omitempty"`

	// Number of disks in the backup engine.
	DiskCount *int32 `json:"diskCount,omitempty"`

	// Number of protected items in the backup engine.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// Number of protected servers in the backup engine.
	ProtectedServersCount *int32 `json:"protectedServersCount,omitempty"`

	// Last refresh time in the backup engine.
	RefreshedAt *time.Time `json:"refreshedAt,omitempty"`

	// Disk space used in the backup engine.
	UsedDiskSpace *float64 `json:"usedDiskSpace,omitempty"`
}

// BackupEnginesClientGetOptions contains the optional parameters for the BackupEnginesClient.Get method.
type BackupEnginesClientGetOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupEnginesClientListOptions contains the optional parameters for the BackupEnginesClient.List method.
type BackupEnginesClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupJobsClientListOptions contains the optional parameters for the BackupJobsClient.List method.
type BackupJobsClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupManagementUsage - Backup management usages of a vault.
type BackupManagementUsage struct {
	// Current value of usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// Limit of usage.
	Limit *int64 `json:"limit,omitempty"`

	// Name of usage.
	Name *NameInfo `json:"name,omitempty"`

	// Next reset time of usage.
	NextResetTime *time.Time `json:"nextResetTime,omitempty"`

	// Quota period of usage.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`

	// Unit of the usage.
	Unit *UsagesUnit `json:"unit,omitempty"`
}

// BackupManagementUsageList - Backup management usage for vault.
type BackupManagementUsageList struct {
	// The list of backup management usages for the given vault.
	Value []*BackupManagementUsage `json:"value,omitempty"`
}

// BackupOperationResultsClientGetOptions contains the optional parameters for the BackupOperationResultsClient.Get method.
type BackupOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupOperationStatusesClientGetOptions contains the optional parameters for the BackupOperationStatusesClient.Get method.
type BackupOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupPoliciesClientListOptions contains the optional parameters for the BackupPoliciesClient.List method.
type BackupPoliciesClientListOptions struct {
	// OData filter options.
	Filter *string
}

// BackupProtectableItemsClientListOptions contains the optional parameters for the BackupProtectableItemsClient.List method.
type BackupProtectableItemsClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupProtectedItemsClientListOptions contains the optional parameters for the BackupProtectedItemsClient.List method.
type BackupProtectedItemsClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupProtectionContainersClientListOptions contains the optional parameters for the BackupProtectionContainersClient.List
// method.
type BackupProtectionContainersClientListOptions struct {
	// OData filter options.
	Filter *string
}

// BackupProtectionIntentClientListOptions contains the optional parameters for the BackupProtectionIntentClient.List method.
type BackupProtectionIntentClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupRequestClassification provides polymorphic access to related types.
// Call the interface's GetBackupRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileShareBackupRequest, *AzureWorkloadBackupRequest, *BackupRequest, *IaasVMBackupRequest
type BackupRequestClassification interface {
	// GetBackupRequest returns the BackupRequest content of the underlying type.
	GetBackupRequest() *BackupRequest
}

// BackupRequest - Base class for backup request. Workload-specific backup requests are derived from this class.
type BackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetBackupRequest implements the BackupRequestClassification interface for type BackupRequest.
func (b *BackupRequest) GetBackupRequest() *BackupRequest { return b }

// BackupRequestResource - Base class for backup request. Workload-specific backup requests are derived from this class.
type BackupRequestResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// BackupRequestResource properties
	Properties BackupRequestClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupResourceConfig - The resource storage details.
type BackupResourceConfig struct {
	// Opt in details of Cross Region Restore feature.
	CrossRegionRestoreFlag *bool `json:"crossRegionRestoreFlag,omitempty"`

	// Vault Dedup state
	DedupState *DedupState `json:"dedupState,omitempty"`

	// Storage type
	StorageModelType *StorageType `json:"storageModelType,omitempty"`

	// Storage type.
	StorageType *StorageType `json:"storageType,omitempty"`

	// Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked.
	StorageTypeState *StorageTypeState `json:"storageTypeState,omitempty"`

	// Vault x-cool state
	XcoolState *XcoolState `json:"xcoolState,omitempty"`
}

// BackupResourceConfigResource - The resource storage details.
type BackupResourceConfigResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// BackupResourceConfigResource properties
	Properties *BackupResourceConfig `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

type BackupResourceEncryptionConfig struct {
	// Encryption At Rest Type
	EncryptionAtRestType          *EncryptionAtRestType          `json:"encryptionAtRestType,omitempty"`
	InfrastructureEncryptionState *InfrastructureEncryptionState `json:"infrastructureEncryptionState,omitempty"`

	// Key Vault Key URI
	KeyURI           *string           `json:"keyUri,omitempty"`
	LastUpdateStatus *LastUpdateStatus `json:"lastUpdateStatus,omitempty"`

	// Key Vault Subscription Id
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

type BackupResourceEncryptionConfigExtended struct {
	// Encryption At Rest Type
	EncryptionAtRestType          *EncryptionAtRestType          `json:"encryptionAtRestType,omitempty"`
	InfrastructureEncryptionState *InfrastructureEncryptionState `json:"infrastructureEncryptionState,omitempty"`

	// Key Vault Key URI
	KeyURI           *string           `json:"keyUri,omitempty"`
	LastUpdateStatus *LastUpdateStatus `json:"lastUpdateStatus,omitempty"`

	// Key Vault Subscription Id
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// bool to indicate whether to use system Assigned Identity or not
	UseSystemAssignedIdentity *bool `json:"useSystemAssignedIdentity,omitempty"`

	// User Assigned Identity Id
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

type BackupResourceEncryptionConfigExtendedResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// BackupResourceEncryptionConfigExtendedResource properties
	Properties *BackupResourceEncryptionConfigExtended `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

type BackupResourceEncryptionConfigResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// BackupResourceEncryptionConfigResource properties
	Properties *BackupResourceEncryptionConfig `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupResourceEncryptionConfigsClientGetOptions contains the optional parameters for the BackupResourceEncryptionConfigsClient.Get
// method.
type BackupResourceEncryptionConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupResourceEncryptionConfigsClientUpdateOptions contains the optional parameters for the BackupResourceEncryptionConfigsClient.Update
// method.
type BackupResourceEncryptionConfigsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BackupResourceStorageConfigsNonCRRClientGetOptions contains the optional parameters for the BackupResourceStorageConfigsNonCRRClient.Get
// method.
type BackupResourceStorageConfigsNonCRRClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupResourceStorageConfigsNonCRRClientPatchOptions contains the optional parameters for the BackupResourceStorageConfigsNonCRRClient.Patch
// method.
type BackupResourceStorageConfigsNonCRRClientPatchOptions struct {
	// placeholder for future optional parameters
}

// BackupResourceStorageConfigsNonCRRClientUpdateOptions contains the optional parameters for the BackupResourceStorageConfigsNonCRRClient.Update
// method.
type BackupResourceStorageConfigsNonCRRClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BackupResourceVaultConfig - Backup resource vault config details.
type BackupResourceVaultConfig struct {
	// Enabled or Disabled.
	EnhancedSecurityState *EnhancedSecurityState `json:"enhancedSecurityState,omitempty"`

	// Is soft delete feature state editable
	IsSoftDeleteFeatureStateEditable *bool `json:"isSoftDeleteFeatureStateEditable,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Soft Delete feature state
	SoftDeleteFeatureState *SoftDeleteFeatureState `json:"softDeleteFeatureState,omitempty"`

	// Storage type.
	StorageModelType *StorageType `json:"storageModelType,omitempty"`

	// Storage type.
	StorageType *StorageType `json:"storageType,omitempty"`

	// Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked.
	StorageTypeState *StorageTypeState `json:"storageTypeState,omitempty"`
}

// BackupResourceVaultConfigResource - Backup resource vault config details.
type BackupResourceVaultConfigResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// BackupResourceVaultConfigResource properties
	Properties *BackupResourceVaultConfig `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupResourceVaultConfigsClientGetOptions contains the optional parameters for the BackupResourceVaultConfigsClient.Get
// method.
type BackupResourceVaultConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupResourceVaultConfigsClientPutOptions contains the optional parameters for the BackupResourceVaultConfigsClient.Put
// method.
type BackupResourceVaultConfigsClientPutOptions struct {
	// placeholder for future optional parameters
}

// BackupResourceVaultConfigsClientUpdateOptions contains the optional parameters for the BackupResourceVaultConfigsClient.Update
// method.
type BackupResourceVaultConfigsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BackupStatusClientGetOptions contains the optional parameters for the BackupStatusClient.Get method.
type BackupStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupStatusRequest - BackupStatus request.
type BackupStatusRequest struct {
	// Protectable Item Logical Name
	PoLogicalName *string `json:"poLogicalName,omitempty"`

	// Entire ARM resource id of the resource
	ResourceID *string `json:"resourceId,omitempty"`

	// Container Type - VM, SQLPaaS, DPM, AzureFileShare…
	ResourceType *DataSourceType `json:"resourceType,omitempty"`
}

// BackupStatusResponse - BackupStatus response.
type BackupStatusResponse struct {
	// Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;csname;vmname.
	ContainerName *string `json:"containerName,omitempty"`

	// ErrorCode in case of intent failed
	ErrorCode *string `json:"errorCode,omitempty"`

	// ErrorMessage in case of intent failed.
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Specifies the fabric name - Azure or AD
	FabricName *FabricName `json:"fabricName,omitempty"`

	// Specifies the policy name which is used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Specifies the product specific ds name. E.g. vm;iaasvmcontainer;csname;vmname.
	ProtectedItemName *string `json:"protectedItemName,omitempty"`

	// Specifies whether the container is registered or not
	ProtectionStatus *ProtectionStatus `json:"protectionStatus,omitempty"`

	// Container registration status
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// Specifies the arm resource id of the vault
	VaultID *string `json:"vaultId,omitempty"`
}

// BackupUsageSummariesClientListOptions contains the optional parameters for the BackupUsageSummariesClient.List method.
type BackupUsageSummariesClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupWorkloadItemsClientListOptions contains the optional parameters for the BackupWorkloadItemsClient.List method.
type BackupWorkloadItemsClientListOptions struct {
	// OData filter options.
	Filter *string
	// skipToken Filter.
	SkipToken *string
}

// BackupsClientTriggerOptions contains the optional parameters for the BackupsClient.Trigger method.
type BackupsClientTriggerOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginBMSPrepareDataMoveOptions contains the optional parameters for the Client.BeginBMSPrepareDataMove method.
type ClientBeginBMSPrepareDataMoveOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginBMSTriggerDataMoveOptions contains the optional parameters for the Client.BeginBMSTriggerDataMove method.
type ClientBeginBMSTriggerDataMoveOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginMoveRecoveryPointOptions contains the optional parameters for the Client.BeginMoveRecoveryPoint method.
type ClientBeginMoveRecoveryPointOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientDiscoveryDisplay - Localized display information of an operation.
type ClientDiscoveryDisplay struct {
	// Description of the operation having details of what operation is about.
	Description *string `json:"description,omitempty"`

	// Operations Name itself.
	Operation *string `json:"operation,omitempty"`

	// Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`

	// ResourceType for which this Operation can be performed.
	Resource *string `json:"resource,omitempty"`
}

// ClientDiscoveryForLogSpecification - Class to represent shoebox log specification in json client discovery.
type ClientDiscoveryForLogSpecification struct {
	// blob duration of shoebox log specification
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Localized display name
	DisplayName *string `json:"displayName,omitempty"`

	// Name for shoebox log specification.
	Name *string `json:"name,omitempty"`
}

// ClientDiscoveryForProperties - Class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	// Operation properties.
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryForServiceSpecification - Class to represent shoebox service specification in json client discovery.
type ClientDiscoveryForServiceSpecification struct {
	// List of log specifications of this operation.
	LogSpecifications []*ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryResponse - Operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	// Link to the next chunk of Response.
	NextLink *string `json:"nextLink,omitempty"`

	// List of available operations.
	Value []*ClientDiscoveryValueForSingleAPI `json:"value,omitempty"`
}

// ClientDiscoveryValueForSingleAPI - Available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	// Contains the localized display information for this particular operation
	Display *ClientDiscoveryDisplay `json:"display,omitempty"`

	// Name of the Operation.
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation;governs the display of the operation in the RBAC UX and the audit logs UX
	Origin *string `json:"origin,omitempty"`

	// ShoeBox properties for the given operation.
	Properties *ClientDiscoveryForProperties `json:"properties,omitempty"`
}

// ClientGetOperationStatusOptions contains the optional parameters for the Client.GetOperationStatus method.
type ClientGetOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// ClientScriptForConnect - Client script details for file / folder restore.
type ClientScriptForConnect struct {
	// OS type - Windows, Linux etc. for which this file / folder restore client script works.
	OSType *string `json:"osType,omitempty"`

	// File content of the client script for file / folder restore.
	ScriptContent *string `json:"scriptContent,omitempty"`

	// File extension of the client script for file / folder restore - .ps1 , .sh , etc.
	ScriptExtension *string `json:"scriptExtension,omitempty"`

	// Mandatory suffix that should be added to the name of script that is given for download to user. If its null or empty then
	// , ignore it.
	ScriptNameSuffix *string `json:"scriptNameSuffix,omitempty"`

	// URL of Executable from where to source the content. If this is not null then ScriptContent should not be used
	URL *string `json:"url,omitempty"`
}

// CloudError - An error response from the Container Instance service.
type CloudError struct {
	// The error object.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Container Instance service.
type CloudErrorBody struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ContainerIdentityInfo - Container identity information
type ContainerIdentityInfo struct {
	// Protection container identity - AAD Tenant
	AADTenantID *string `json:"aadTenantId,omitempty"`

	// Protection container identity - Audience
	Audience *string `json:"audience,omitempty"`

	// Protection container identity - AAD Service Principal
	ServicePrincipalClientID *string `json:"servicePrincipalClientId,omitempty"`

	// Unique name of the container
	UniqueName *string `json:"uniqueName,omitempty"`
}

// DPMContainerExtendedInfo - Additional information of the DPMContainer.
type DPMContainerExtendedInfo struct {
	// Last refresh time of the DPMContainer.
	LastRefreshedAt *time.Time `json:"lastRefreshedAt,omitempty"`
}

// DPMProtectedItem - Additional information on Backup engine specific backup item.
type DPMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Backup Management server protecting this backup item
	BackupEngineName *string `json:"backupEngineName,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Extended info of the backup item.
	ExtendedInfo *DPMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the managed item
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Protection state of the backup engine
	ProtectionState *ProtectedItemState `json:"protectionState,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetProtectedItem implements the ProtectedItemClassification interface for type DPMProtectedItem.
func (d *DPMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                d.ProtectedItemType,
		BackupManagementType:             d.BackupManagementType,
		WorkloadType:                     d.WorkloadType,
		ContainerName:                    d.ContainerName,
		SourceResourceID:                 d.SourceResourceID,
		PolicyID:                         d.PolicyID,
		LastRecoveryPoint:                d.LastRecoveryPoint,
		BackupSetName:                    d.BackupSetName,
		CreateMode:                       d.CreateMode,
		DeferredDeleteTimeInUTC:          d.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     d.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      d.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: d.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      d.IsRehydrate,
		ResourceGuardOperationRequests:   d.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 d.IsArchiveEnabled,
		PolicyName:                       d.PolicyName,
	}
}

// DPMProtectedItemExtendedInfo - Additional information of DPM Protected item.
type DPMProtectedItemExtendedInfo struct {
	// Used Disk storage in bytes.
	DiskStorageUsedInBytes *string `json:"diskStorageUsedInBytes,omitempty"`

	// To check if backup item is collocated.
	IsCollocated *bool `json:"isCollocated,omitempty"`

	// To check if backup item is cloud protected.
	IsPresentOnCloud *bool `json:"isPresentOnCloud,omitempty"`

	// Last backup status information on backup item.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`

	// Last refresh time on backup item.
	LastRefreshedAt *time.Time `json:"lastRefreshedAt,omitempty"`

	// Oldest cloud recovery point time.
	OldestRecoveryPoint *time.Time `json:"oldestRecoveryPoint,omitempty"`

	// latest disk recovery point time.
	OnPremiseLatestRecoveryPoint *time.Time `json:"onPremiseLatestRecoveryPoint,omitempty"`

	// Oldest disk recovery point time.
	OnPremiseOldestRecoveryPoint *time.Time `json:"onPremiseOldestRecoveryPoint,omitempty"`

	// disk recovery point count.
	OnPremiseRecoveryPointCount *int32 `json:"onPremiseRecoveryPointCount,omitempty"`

	// Attribute to provide information on various DBs.
	ProtectableObjectLoadPath map[string]*string `json:"protectableObjectLoadPath,omitempty"`

	// To check if backup item is disk protected.
	Protected *bool `json:"protected,omitempty"`

	// Protection group name of the backup item.
	ProtectionGroupName *string `json:"protectionGroupName,omitempty"`

	// cloud recovery point count.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`

	// total Disk storage in bytes.
	TotalDiskStorageSizeInBytes *string `json:"totalDiskStorageSizeInBytes,omitempty"`
}

// DailyRetentionFormat - Daily retention format.
type DailyRetentionFormat struct {
	// List of days of the month.
	DaysOfTheMonth []*Day `json:"daysOfTheMonth,omitempty"`
}

// DailyRetentionSchedule - Daily retention schedule.
type DailyRetentionSchedule struct {
	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`

	// Retention times of retention policy.
	RetentionTimes []*time.Time `json:"retentionTimes,omitempty"`
}

type DailySchedule struct {
	// List of times of day this schedule has to be run.
	ScheduleRunTimes []*time.Time `json:"scheduleRunTimes,omitempty"`
}

// Day of the week.
type Day struct {
	// Date of the month
	Date *int32 `json:"date,omitempty"`

	// Whether Date is last date of month
	IsLast *bool `json:"isLast,omitempty"`
}

type DiskExclusionProperties struct {
	// List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
	DiskLunList []*int32 `json:"diskLunList,omitempty"`

	// Flag to indicate whether DiskLunList is to be included/ excluded from backup.
	IsInclusionList *bool `json:"isInclusionList,omitempty"`
}

// DiskInformation - Disk information
type DiskInformation struct {
	Lun  *int32  `json:"lun,omitempty"`
	Name *string `json:"name,omitempty"`
}

// DistributedNodesInfo - This is used to represent the various nodes of the distributed container.
type DistributedNodesInfo struct {
	// Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`

	// Name of the node under a distributed container.
	NodeName *string `json:"nodeName,omitempty"`

	// Status of this Node. Failed | Succeeded
	Status *string `json:"status,omitempty"`
}

// DpmBackupEngine - Data Protection Manager (DPM) specific backup engine.
type DpmBackupEngine struct {
	// REQUIRED; Type of the backup engine.
	BackupEngineType *BackupEngineType `json:"backupEngineType,omitempty"`

	// Backup agent version
	AzureBackupAgentVersion *string `json:"azureBackupAgentVersion,omitempty"`

	// ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`

	// Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string `json:"backupEngineState,omitempty"`

	// Type of backup management for the backup engine.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`

	// Backup engine version
	DpmVersion *string `json:"dpmVersion,omitempty"`

	// Extended info of the backupengine
	ExtendedInfo *BackupEngineExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool `json:"isAzureBackupAgentUpgradeAvailable,omitempty"`

	// To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool `json:"isDpmUpgradeAvailable,omitempty"`

	// Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// GetBackupEngineBase implements the BackupEngineBaseClassification interface for type DpmBackupEngine.
func (d *DpmBackupEngine) GetBackupEngineBase() *BackupEngineBase {
	return &BackupEngineBase{
		FriendlyName:                       d.FriendlyName,
		BackupManagementType:               d.BackupManagementType,
		RegistrationStatus:                 d.RegistrationStatus,
		BackupEngineState:                  d.BackupEngineState,
		HealthStatus:                       d.HealthStatus,
		BackupEngineType:                   d.BackupEngineType,
		CanReRegister:                      d.CanReRegister,
		BackupEngineID:                     d.BackupEngineID,
		DpmVersion:                         d.DpmVersion,
		AzureBackupAgentVersion:            d.AzureBackupAgentVersion,
		IsAzureBackupAgentUpgradeAvailable: d.IsAzureBackupAgentUpgradeAvailable,
		IsDpmUpgradeAvailable:              d.IsDpmUpgradeAvailable,
		ExtendedInfo:                       d.ExtendedInfo,
	}
}

// DpmContainerClassification provides polymorphic access to related types.
// Call the interface's GetDpmContainer() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupServerContainer, *DpmContainer
type DpmContainerClassification interface {
	ProtectionContainerClassification
	// GetDpmContainer returns the DpmContainer content of the underlying type.
	GetDpmContainer() *DpmContainer
}

// DpmContainer - DPM workload-specific protection container.
type DpmContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Specifies whether the container is re-registrable.
	CanReRegister *bool `json:"canReRegister,omitempty"`

	// ID of container.
	ContainerID *string `json:"containerId,omitempty"`

	// Backup engine Agent version
	DpmAgentVersion *string `json:"dpmAgentVersion,omitempty"`

	// List of BackupEngines protecting the container
	DpmServers []*string `json:"dpmServers,omitempty"`

	// Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Number of protected items in the BackupEngine
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`

	// Protection status of the container.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// To check if upgrade available
	UpgradeAvailable *bool `json:"upgradeAvailable,omitempty"`
}

// GetDpmContainer implements the DpmContainerClassification interface for type DpmContainer.
func (d *DpmContainer) GetDpmContainer() *DpmContainer { return d }

// GetProtectionContainer implements the ProtectionContainerClassification interface for type DpmContainer.
func (d *DpmContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          d.FriendlyName,
		BackupManagementType:  d.BackupManagementType,
		RegistrationStatus:    d.RegistrationStatus,
		HealthStatus:          d.HealthStatus,
		ContainerType:         d.ContainerType,
		ProtectableObjectType: d.ProtectableObjectType,
	}
}

// DpmErrorInfo - DPM workload-specific error information.
type DpmErrorInfo struct {
	// Localized error string.
	ErrorString *string `json:"errorString,omitempty"`

	// List of localized recommendations for above error code.
	Recommendations []*string `json:"recommendations,omitempty"`
}

// DpmJob - DPM workload-specific job object.
type DpmJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// The state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction `json:"actionsInfo,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of cluster/server protecting current backup item, if any.
	ContainerName *string `json:"containerName,omitempty"`

	// Type of container.
	ContainerType *string `json:"containerType,omitempty"`

	// DPM server name managing the backup item or backup job.
	DpmServerName *string `json:"dpmServerName,omitempty"`

	// Time elapsed for job.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// The errors.
	ErrorDetails []*DpmErrorInfo `json:"errorDetails,omitempty"`

	// Additional information for this job.
	ExtendedInfo *DpmJobExtendedInfo `json:"extendedInfo,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`

	// Type of backup item.
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetJob implements the JobClassification interface for type DpmJob.
func (d *DpmJob) GetJob() *Job {
	return &Job{
		EntityFriendlyName:   d.EntityFriendlyName,
		BackupManagementType: d.BackupManagementType,
		Operation:            d.Operation,
		Status:               d.Status,
		StartTime:            d.StartTime,
		EndTime:              d.EndTime,
		ActivityID:           d.ActivityID,
		JobType:              d.JobType,
	}
}

// DpmJobExtendedInfo - Additional information on the DPM workload-specific job.
type DpmJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`

	// The job properties.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// List of tasks associated with this job.
	TasksList []*DpmJobTaskDetails `json:"tasksList,omitempty"`
}

// DpmJobTaskDetails - DPM workload-specific job task details.
type DpmJobTaskDetails struct {
	// Time elapsed for task.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status.
	Status *string `json:"status,omitempty"`

	// The task display name.
	TaskID *string `json:"taskId,omitempty"`
}

// EncryptionDetails - Details needed if the VM was encrypted at the time of backup.
type EncryptionDetails struct {
	// Identifies whether this backup copy represents an encrypted VM at the time of backup.
	EncryptionEnabled *bool `json:"encryptionEnabled,omitempty"`

	// Key Url.
	KekURL *string `json:"kekUrl,omitempty"`

	// ID of Key Vault where KEK is stored.
	KekVaultID *string `json:"kekVaultId,omitempty"`

	// Secret Url.
	SecretKeyURL *string `json:"secretKeyUrl,omitempty"`

	// ID of Key Vault where Secret is stored.
	SecretKeyVaultID *string `json:"secretKeyVaultId,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - Error Detail class which encapsulates Code, Message and Recommendations.
type ErrorDetail struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error Message related to the Code.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; List of recommendation strings.
	Recommendations []*string `json:"recommendations,omitempty" azure:"ro"`
}

// ExportJobsOperationResultInfo - This class is used to send blob details after exporting jobs.
type ExportJobsOperationResultInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// SAS key to access the blob. It expires in 15 mins.
	BlobSasKey *string `json:"blobSasKey,omitempty"`

	// URL of the blob into which the serialized string of list of jobs is exported.
	BlobURL *string `json:"blobUrl,omitempty"`

	// SAS key to access the blob. It expires in 15 mins.
	ExcelFileBlobSasKey *string `json:"excelFileBlobSasKey,omitempty"`

	// URL of the blob into which the ExcelFile is uploaded.
	ExcelFileBlobURL *string `json:"excelFileBlobUrl,omitempty"`
}

// GetOperationResultInfoBase implements the OperationResultInfoBaseClassification interface for type ExportJobsOperationResultInfo.
func (e *ExportJobsOperationResultInfo) GetOperationResultInfoBase() *OperationResultInfoBase {
	return &OperationResultInfoBase{
		ObjectType: e.ObjectType,
	}
}

// ExportJobsOperationResultsClientGetOptions contains the optional parameters for the ExportJobsOperationResultsClient.Get
// method.
type ExportJobsOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExtendedProperties - Extended Properties for Azure IaasVM Backup.
type ExtendedProperties struct {
	// Extended Properties for Disk Exclusion.
	DiskExclusionProperties *DiskExclusionProperties `json:"diskExclusionProperties,omitempty"`

	// Linux VM name
	LinuxVMApplicationName *string `json:"linuxVmApplicationName,omitempty"`
}

// FeatureSupportClientValidateOptions contains the optional parameters for the FeatureSupportClient.Validate method.
type FeatureSupportClientValidateOptions struct {
	// placeholder for future optional parameters
}

// FeatureSupportRequestClassification provides polymorphic access to related types.
// Call the interface's GetFeatureSupportRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupGoalFeatureSupportRequest, *AzureVMResourceFeatureSupportRequest, *FeatureSupportRequest
type FeatureSupportRequestClassification interface {
	// GetFeatureSupportRequest returns the FeatureSupportRequest content of the underlying type.
	GetFeatureSupportRequest() *FeatureSupportRequest
}

// FeatureSupportRequest - Base class for feature request
type FeatureSupportRequest struct {
	// REQUIRED; backup support feature type.
	FeatureType *string `json:"featureType,omitempty"`
}

// GetFeatureSupportRequest implements the FeatureSupportRequestClassification interface for type FeatureSupportRequest.
func (f *FeatureSupportRequest) GetFeatureSupportRequest() *FeatureSupportRequest { return f }

// GenericContainer - Base class for generic container of backup items
type GenericContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Extended information (not returned in List container API calls)
	ExtendedInformation *GenericContainerExtendedInfo `json:"extendedInformation,omitempty"`

	// Name of the container's fabric
	FabricName *string `json:"fabricName,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type GenericContainer.
func (g *GenericContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          g.FriendlyName,
		BackupManagementType:  g.BackupManagementType,
		RegistrationStatus:    g.RegistrationStatus,
		HealthStatus:          g.HealthStatus,
		ContainerType:         g.ContainerType,
		ProtectableObjectType: g.ProtectableObjectType,
	}
}

// GenericContainerExtendedInfo - Container extended information
type GenericContainerExtendedInfo struct {
	// Container identity information
	ContainerIdentityInfo *ContainerIdentityInfo `json:"containerIdentityInfo,omitempty"`

	// Public key of container cert
	RawCertData *string `json:"rawCertData,omitempty"`

	// Azure Backup Service Endpoints for the container
	ServiceEndpoints map[string]*string `json:"serviceEndpoints,omitempty"`
}

// GenericProtectedItem - Base class for backup items.
type GenericProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Name of this backup item's fabric.
	FabricName *string `json:"fabricName,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string `json:"policyState,omitempty"`

	// Data Plane Service ID of the protected item.
	ProtectedItemID *int64 `json:"protectedItemId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionState `json:"protectionState,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Loosely coupled (type, value) associations (example - parent of a protected item)
	SourceAssociations map[string]*string `json:"sourceAssociations,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetProtectedItem implements the ProtectedItemClassification interface for type GenericProtectedItem.
func (g *GenericProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                g.ProtectedItemType,
		BackupManagementType:             g.BackupManagementType,
		WorkloadType:                     g.WorkloadType,
		ContainerName:                    g.ContainerName,
		SourceResourceID:                 g.SourceResourceID,
		PolicyID:                         g.PolicyID,
		LastRecoveryPoint:                g.LastRecoveryPoint,
		BackupSetName:                    g.BackupSetName,
		CreateMode:                       g.CreateMode,
		DeferredDeleteTimeInUTC:          g.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     g.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      g.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: g.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      g.IsRehydrate,
		ResourceGuardOperationRequests:   g.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 g.IsArchiveEnabled,
		PolicyName:                       g.PolicyName,
	}
}

// GenericProtectionPolicy - Azure VM (Mercury) workload-specific backup policy.
type GenericProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Name of this policy's fabric.
	FabricName *string `json:"fabricName,omitempty"`

	// Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// List of sub-protection policies which includes schedule and retention
	SubProtectionPolicy []*SubProtectionPolicy `json:"subProtectionPolicy,omitempty"`

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type GenericProtectionPolicy.
func (g *GenericProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		ProtectedItemsCount:            g.ProtectedItemsCount,
		BackupManagementType:           g.BackupManagementType,
		ResourceGuardOperationRequests: g.ResourceGuardOperationRequests,
	}
}

// GenericRecoveryPoint - Generic backup copy.
type GenericRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Friendly name of the backup copy.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string `json:"recoveryPointAdditionalInfo,omitempty"`

	// Time at which this backup copy was created.
	RecoveryPointTime *time.Time `json:"recoveryPointTime,omitempty"`

	// Type of the backup copy.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type GenericRecoveryPoint.
func (g *GenericRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: g.ObjectType,
	}
}

// GetProtectedItemQueryObject - Filters to list backup items.
type GetProtectedItemQueryObject struct {
	// Specifies if the additional information should be provided for this item.
	Expand *string `json:"expand,omitempty"`
}

type HourlySchedule struct {
	// Interval at which backup needs to be triggered. For hourly the value can be 4/6/8/12
	Interval *int32 `json:"interval,omitempty"`

	// To specify duration of the backup window
	ScheduleWindowDuration *int32 `json:"scheduleWindowDuration,omitempty"`

	// To specify start time of the backup window
	ScheduleWindowStartTime *time.Time `json:"scheduleWindowStartTime,omitempty"`
}

// ILRRequestClassification provides polymorphic access to related types.
// Call the interface's GetILRRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileShareProvisionILRRequest, *ILRRequest, *IaasVMILRRegistrationRequest
type ILRRequestClassification interface {
	// GetILRRequest returns the ILRRequest content of the underlying type.
	GetILRRequest() *ILRRequest
}

// ILRRequest - Parameters to Provision ILR API.
type ILRRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetILRRequest implements the ILRRequestClassification interface for type ILRRequest.
func (i *ILRRequest) GetILRRequest() *ILRRequest { return i }

// ILRRequestResource - Parameters to Provision ILR API.
type ILRRequestResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ILRRequestResource properties
	Properties ILRRequestClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IaaSVMContainerClassification provides polymorphic access to related types.
// Call the interface's GetIaaSVMContainer() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureIaaSClassicComputeVMContainer, *AzureIaaSComputeVMContainer, *IaaSVMContainer
type IaaSVMContainerClassification interface {
	ProtectionContainerClassification
	// GetIaaSVMContainer returns the IaaSVMContainer content of the underlying type.
	GetIaaSVMContainer() *IaaSVMContainer
}

// IaaSVMContainer - IaaS VM workload-specific container.
type IaaSVMContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
}

// GetIaaSVMContainer implements the IaaSVMContainerClassification interface for type IaaSVMContainer.
func (i *IaaSVMContainer) GetIaaSVMContainer() *IaaSVMContainer { return i }

// GetProtectionContainer implements the ProtectionContainerClassification interface for type IaaSVMContainer.
func (i *IaaSVMContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          i.FriendlyName,
		BackupManagementType:  i.BackupManagementType,
		RegistrationStatus:    i.RegistrationStatus,
		HealthStatus:          i.HealthStatus,
		ContainerType:         i.ContainerType,
		ProtectableObjectType: i.ProtectableObjectType,
	}
}

// IaaSVMProtectableItemClassification provides polymorphic access to related types.
// Call the interface's GetIaaSVMProtectableItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureIaaSClassicComputeVMProtectableItem, *AzureIaaSComputeVMProtectableItem, *IaaSVMProtectableItem
type IaaSVMProtectableItemClassification interface {
	WorkloadProtectableItemClassification
	// GetIaaSVMProtectableItem returns the IaaSVMProtectableItem content of the underlying type.
	GetIaaSVMProtectableItem() *IaaSVMProtectableItem
}

// IaaSVMProtectableItem - IaaS VM workload-specific backup item.
type IaaSVMProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetIaaSVMProtectableItem implements the IaaSVMProtectableItemClassification interface for type IaaSVMProtectableItem.
func (i *IaaSVMProtectableItem) GetIaaSVMProtectableItem() *IaaSVMProtectableItem { return i }

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type IaaSVMProtectableItem.
func (i *IaaSVMProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: i.BackupManagementType,
		WorkloadType:         i.WorkloadType,
		ProtectableItemType:  i.ProtectableItemType,
		FriendlyName:         i.FriendlyName,
		ProtectionState:      i.ProtectionState,
	}
}

// IaasVMBackupRequest - IaaS VM workload-specific backup request.
type IaasVMBackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *time.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
}

// GetBackupRequest implements the BackupRequestClassification interface for type IaasVMBackupRequest.
func (i *IaasVMBackupRequest) GetBackupRequest() *BackupRequest {
	return &BackupRequest{
		ObjectType: i.ObjectType,
	}
}

// IaasVMILRRegistrationRequest - Restore files/folders from a backup copy of IaaS VM.
type IaasVMILRRegistrationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// iSCSI initiator name.
	InitiatorName *string `json:"initiatorName,omitempty"`

	// ID of the IaaS VM backup copy from where the files/folders have to be restored.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// Whether to renew existing registration with the iSCSI server.
	RenewExistingRegistration *bool `json:"renewExistingRegistration,omitempty"`

	// Fully qualified ARM ID of the virtual machine whose the files / folders have to be restored.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
}

// GetILRRequest implements the ILRRequestClassification interface for type IaasVMILRRegistrationRequest.
func (i *IaasVMILRRegistrationRequest) GetILRRequest() *ILRRequest {
	return &ILRRequest{
		ObjectType: i.ObjectType,
	}
}

// IaasVMRecoveryPoint - IaaS VM workload specific backup copy.
type IaasVMRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Is the session to recover items from this backup copy still active.
	IsInstantIlrSessionActive *bool `json:"isInstantIlrSessionActive,omitempty"`

	// Whether VM is with Managed Disks
	IsManagedVirtualMachine *bool `json:"isManagedVirtualMachine,omitempty"`

	// Identifies whether the VM was encrypted when the backup copy is created.
	IsSourceVMEncrypted *bool `json:"isSourceVMEncrypted,omitempty"`

	// Required details for recovering an encrypted VM. Applicable only when IsSourceVMEncrypted is true.
	KeyAndSecret *KeyAndSecretDetails `json:"keyAndSecret,omitempty"`

	// OS type
	OSType *string `json:"osType,omitempty"`

	// Original Storage Account Option
	OriginalStorageAccountOption *bool `json:"originalStorageAccountOption,omitempty"`

	// Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string `json:"recoveryPointAdditionalInfo,omitempty"`

	// Disk configuration
	RecoveryPointDiskConfiguration *RecoveryPointDiskConfiguration `json:"recoveryPointDiskConfiguration,omitempty"`

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo `json:"recoveryPointMoveReadinessInfo,omitempty"`

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2 `json:"recoveryPointTierDetails,omitempty"`

	// Time at which this backup copy was created.
	RecoveryPointTime *time.Time `json:"recoveryPointTime,omitempty"`

	// Type of the backup copy.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`

	// Storage type of the VM whose backup copy is created.
	SourceVMStorageType *string `json:"sourceVMStorageType,omitempty"`

	// Virtual Machine Size
	VirtualMachineSize *string `json:"virtualMachineSize,omitempty"`

	// Identifies the zone of the VM at the time of backup. Applicable only for zone-pinned Vms
	Zones []*string `json:"zones,omitempty"`
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type IaasVMRecoveryPoint.
func (i *IaasVMRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: i.ObjectType,
	}
}

// IaasVMRestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetIaasVMRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *IaasVMRestoreRequest, *IaasVMRestoreWithRehydrationRequest
type IaasVMRestoreRequestClassification interface {
	RestoreRequestClassification
	// GetIaasVMRestoreRequest returns the IaasVMRestoreRequest content of the underlying type.
	GetIaasVMRestoreRequest() *IaasVMRestoreRequest
}

// IaasVMRestoreRequest - IaaS VM workload-specific restore.
type IaasVMRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Affinity group associated to VM to be restored. Used only for Classic Compute Virtual Machines.
	AffinityGroup *string `json:"affinityGroup,omitempty"`

	// Should a new cloud service be created while restoring the VM. If this is false, VM will be restored to the same cloud service
	// as it was at the time of backup.
	CreateNewCloudService *bool `json:"createNewCloudService,omitempty"`

	// DiskEncryptionSet's ID - needed if the VM needs to be encrypted at rest during restore with customer managed key.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// Details needed if the VM was encrypted at the time of backup.
	EncryptionDetails *EncryptionDetails `json:"encryptionDetails,omitempty"`

	// IaaS VM workload specific restore details for restores using managed identity.
	IdentityBasedRestoreDetails *IdentityBasedRestoreDetails `json:"identityBasedRestoreDetails,omitempty"`

	// Managed Identity information required to access customer storage account.
	IdentityInfo *IdentityInfo `json:"identityInfo,omitempty"`

	// Original Storage Account Option
	OriginalStorageAccountOption *bool `json:"originalStorageAccountOption,omitempty"`

	// ID of the backup copy to be recovered.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Region in which the virtual machine is restored.
	Region *string `json:"region,omitempty"`

	// List of Disk LUNs for partial restore
	RestoreDiskLunList []*int32 `json:"restoreDiskLunList,omitempty"`

	// Flag to denote of an Unmanaged disk VM should be restored with Managed disks.
	RestoreWithManagedDisks *bool `json:"restoreWithManagedDisks,omitempty"`

	// Fully qualified ARM ID of the VM which is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Fully qualified ARM ID of the storage account to which the VM has to be restored.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// Subnet ID, is the subnet ID associated with the to be restored VM. For Classic VMs it would be {VnetID}/Subnet/{SubnetName}
	// and, for the Azure Resource Manager VMs it would be ARM resource ID used to
	// represent the subnet.
	SubnetID *string `json:"subnetId,omitempty"`

	// Fully qualified ARM ID of the domain name to be associated to the VM being restored. This applies only to Classic Virtual
	// Machines.
	TargetDomainNameID *string `json:"targetDomainNameId,omitempty"`

	// This is the ARM Id of the resource group that you want to create for this Virtual machine and other artifacts. For e.g.
	// /subscriptions/{subId}/resourcegroups/{rg}
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// This is the complete ARM Id of the VM that will be created. For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`

	// This is the virtual network Id of the vnet that will be attached to the virtual machine. User will be validated for join
	// action permissions in the linked access.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`

	// Target zone where the VM and its disks should be restored.
	Zones []*string `json:"zones,omitempty"`
}

// GetIaasVMRestoreRequest implements the IaasVMRestoreRequestClassification interface for type IaasVMRestoreRequest.
func (i *IaasVMRestoreRequest) GetIaasVMRestoreRequest() *IaasVMRestoreRequest { return i }

// GetRestoreRequest implements the RestoreRequestClassification interface for type IaasVMRestoreRequest.
func (i *IaasVMRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: i.ObjectType,
	}
}

// IaasVMRestoreWithRehydrationRequest - IaaS VM workload-specific restore with integrated rehydration of recovery point.
type IaasVMRestoreWithRehydrationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Affinity group associated to VM to be restored. Used only for Classic Compute Virtual Machines.
	AffinityGroup *string `json:"affinityGroup,omitempty"`

	// Should a new cloud service be created while restoring the VM. If this is false, VM will be restored to the same cloud service
	// as it was at the time of backup.
	CreateNewCloudService *bool `json:"createNewCloudService,omitempty"`

	// DiskEncryptionSet's ID - needed if the VM needs to be encrypted at rest during restore with customer managed key.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// Details needed if the VM was encrypted at the time of backup.
	EncryptionDetails *EncryptionDetails `json:"encryptionDetails,omitempty"`

	// IaaS VM workload specific restore details for restores using managed identity.
	IdentityBasedRestoreDetails *IdentityBasedRestoreDetails `json:"identityBasedRestoreDetails,omitempty"`

	// Managed Identity information required to access customer storage account.
	IdentityInfo *IdentityInfo `json:"identityInfo,omitempty"`

	// Original Storage Account Option
	OriginalStorageAccountOption *bool `json:"originalStorageAccountOption,omitempty"`

	// ID of the backup copy to be recovered.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo `json:"recoveryPointRehydrationInfo,omitempty"`

	// Type of this recovery.
	RecoveryType *RecoveryType `json:"recoveryType,omitempty"`

	// Region in which the virtual machine is restored.
	Region *string `json:"region,omitempty"`

	// List of Disk LUNs for partial restore
	RestoreDiskLunList []*int32 `json:"restoreDiskLunList,omitempty"`

	// Flag to denote of an Unmanaged disk VM should be restored with Managed disks.
	RestoreWithManagedDisks *bool `json:"restoreWithManagedDisks,omitempty"`

	// Fully qualified ARM ID of the VM which is being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Fully qualified ARM ID of the storage account to which the VM has to be restored.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// Subnet ID, is the subnet ID associated with the to be restored VM. For Classic VMs it would be {VnetID}/Subnet/{SubnetName}
	// and, for the Azure Resource Manager VMs it would be ARM resource ID used to
	// represent the subnet.
	SubnetID *string `json:"subnetId,omitempty"`

	// Fully qualified ARM ID of the domain name to be associated to the VM being restored. This applies only to Classic Virtual
	// Machines.
	TargetDomainNameID *string `json:"targetDomainNameId,omitempty"`

	// This is the ARM Id of the resource group that you want to create for this Virtual machine and other artifacts. For e.g.
	// /subscriptions/{subId}/resourcegroups/{rg}
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`

	// This is the complete ARM Id of the VM that will be created. For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`

	// This is the virtual network Id of the vnet that will be attached to the virtual machine. User will be validated for join
	// action permissions in the linked access.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`

	// Target zone where the VM and its disks should be restored.
	Zones []*string `json:"zones,omitempty"`
}

// GetIaasVMRestoreRequest implements the IaasVMRestoreRequestClassification interface for type IaasVMRestoreWithRehydrationRequest.
func (i *IaasVMRestoreWithRehydrationRequest) GetIaasVMRestoreRequest() *IaasVMRestoreRequest {
	return &IaasVMRestoreRequest{
		RecoveryPointID:              i.RecoveryPointID,
		RecoveryType:                 i.RecoveryType,
		SourceResourceID:             i.SourceResourceID,
		TargetVirtualMachineID:       i.TargetVirtualMachineID,
		TargetResourceGroupID:        i.TargetResourceGroupID,
		StorageAccountID:             i.StorageAccountID,
		VirtualNetworkID:             i.VirtualNetworkID,
		SubnetID:                     i.SubnetID,
		TargetDomainNameID:           i.TargetDomainNameID,
		Region:                       i.Region,
		AffinityGroup:                i.AffinityGroup,
		CreateNewCloudService:        i.CreateNewCloudService,
		OriginalStorageAccountOption: i.OriginalStorageAccountOption,
		EncryptionDetails:            i.EncryptionDetails,
		RestoreDiskLunList:           i.RestoreDiskLunList,
		RestoreWithManagedDisks:      i.RestoreWithManagedDisks,
		DiskEncryptionSetID:          i.DiskEncryptionSetID,
		Zones:                        i.Zones,
		IdentityInfo:                 i.IdentityInfo,
		IdentityBasedRestoreDetails:  i.IdentityBasedRestoreDetails,
		ObjectType:                   i.ObjectType,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type IaasVMRestoreWithRehydrationRequest.
func (i *IaasVMRestoreWithRehydrationRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: i.ObjectType,
	}
}

// IdentityBasedRestoreDetails - IaaS VM workload specific restore details for restores using managed identity
type IdentityBasedRestoreDetails struct {
	// Gets the class type.
	ObjectType *string `json:"objectType,omitempty"`

	// Fully qualified ARM ID of the target storage account.
	TargetStorageAccountID *string `json:"targetStorageAccountId,omitempty"`
}

// IdentityInfo - Encapsulates Managed Identity related information
type IdentityInfo struct {
	// To differentiate if the managed identity is system assigned or user assigned
	IsSystemAssignedIdentity *bool `json:"isSystemAssignedIdentity,omitempty"`

	// Managed Identity Resource Id Optional: Might not be required in the case of system assigned managed identity
	ManagedIdentityResourceID *string `json:"managedIdentityResourceId,omitempty"`
}

// InquiryInfo - Details about inquired protectable items under a given container.
type InquiryInfo struct {
	// Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`

	// Inquiry Details which will have workload specific details. For e.g. - For SQL and oracle this will contain different details.
	InquiryDetails []*WorkloadInquiryDetails `json:"inquiryDetails,omitempty"`

	// Inquiry Status for this container such as InProgress | Failed | Succeeded
	Status *string `json:"status,omitempty"`
}

// InquiryValidation - Validation for inquired protectable items under a given container.
type InquiryValidation struct {
	// Error Detail in case the status is non-success.
	ErrorDetail *ErrorDetail `json:"errorDetail,omitempty"`

	// Status for the Inquiry Validation.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; Error Additional Detail in case the status is non-success.
	AdditionalDetail *string `json:"additionalDetail,omitempty" azure:"ro"`
}

// InstantItemRecoveryTarget - Target details for file / folder restore.
type InstantItemRecoveryTarget struct {
	// List of client scripts.
	ClientScripts []*ClientScriptForConnect `json:"clientScripts,omitempty"`
}

type InstantRPAdditionalDetails struct {
	AzureBackupRGNamePrefix *string `json:"azureBackupRGNamePrefix,omitempty"`
	AzureBackupRGNameSuffix *string `json:"azureBackupRGNameSuffix,omitempty"`
}

// ItemLevelRecoveryConnectionsClientProvisionOptions contains the optional parameters for the ItemLevelRecoveryConnectionsClient.Provision
// method.
type ItemLevelRecoveryConnectionsClientProvisionOptions struct {
	// placeholder for future optional parameters
}

// ItemLevelRecoveryConnectionsClientRevokeOptions contains the optional parameters for the ItemLevelRecoveryConnectionsClient.Revoke
// method.
type ItemLevelRecoveryConnectionsClientRevokeOptions struct {
	// placeholder for future optional parameters
}

// JobClassification provides polymorphic access to related types.
// Call the interface's GetJob() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureIaaSVMJob, *AzureIaaSVMJobV2, *AzureStorageJob, *AzureWorkloadJob, *DpmJob, *Job, *MabJob, *VaultJob
type JobClassification interface {
	// GetJob returns the Job content of the underlying type.
	GetJob() *Job
}

// Job - Defines workload agnostic properties for a job.
type Job struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`
}

// GetJob implements the JobClassification interface for type Job.
func (j *Job) GetJob() *Job { return j }

// JobCancellationsClientTriggerOptions contains the optional parameters for the JobCancellationsClient.Trigger method.
type JobCancellationsClientTriggerOptions struct {
	// placeholder for future optional parameters
}

// JobDetailsClientGetOptions contains the optional parameters for the JobDetailsClient.Get method.
type JobDetailsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobOperationResultsClientGetOptions contains the optional parameters for the JobOperationResultsClient.Get method.
type JobOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobQueryObject - Filters to list the jobs.
type JobQueryObject struct {
	// Type of backup management for the job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Job has ended at this time. Value is in UTC.
	EndTime *time.Time `json:"endTime,omitempty"`

	// JobID represents the job uniquely.
	JobID *string `json:"jobId,omitempty"`

	// Type of operation.
	Operation *JobOperationType `json:"operation,omitempty"`

	// Job has started at this time. Value is in UTC.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Status of the job.
	Status *JobStatus `json:"status,omitempty"`
}

// JobResource - Defines workload agnostic properties for a job.
type JobResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// JobResource properties
	Properties JobClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobResourceList - List of Job resources
type JobResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*JobResource `json:"value,omitempty"`
}

// JobsClientExportOptions contains the optional parameters for the JobsClient.Export method.
type JobsClientExportOptions struct {
	// OData filter options.
	Filter *string
}

// KEKDetails - KEK is encryption key for BEK.
type KEKDetails struct {
	// KEK data.
	KeyBackupData *string `json:"keyBackupData,omitempty"`

	// Key is KEK.
	KeyURL *string `json:"keyUrl,omitempty"`

	// Key Vault ID where this Key is stored.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
}

// KPIResourceHealthDetails - KPI Resource Health Details
type KPIResourceHealthDetails struct {
	// Resource Health Status
	ResourceHealthDetails []*ResourceHealthDetails `json:"resourceHealthDetails,omitempty"`

	// Resource Health Status
	ResourceHealthStatus *ResourceHealthStatus `json:"resourceHealthStatus,omitempty"`
}

// KeyAndSecretDetails - BEK is bitlocker key. KEK is encryption key for BEK If the VM was encrypted then we will store following
// details :
// 1. Secret(BEK) - Url + Backup Data + vaultId.
// 2. Key(KEK) - Url + Backup Data + vaultId.
// 3. EncryptionMechanism BEK and KEK can potentially have different vault ids.
type KeyAndSecretDetails struct {
	// BEK is bitlocker encryption key.
	BekDetails *BEKDetails `json:"bekDetails,omitempty"`

	// Encryption mechanism: None/ SinglePass/ DoublePass
	EncryptionMechanism *string `json:"encryptionMechanism,omitempty"`

	// KEK is encryption key for BEK.
	KekDetails *KEKDetails `json:"kekDetails,omitempty"`
}

// ListRecoveryPointsRecommendedForMoveRequest Request
type ListRecoveryPointsRecommendedForMoveRequest struct {
	// List of Recovery Points excluded from Move
	ExcludedRPList []*string `json:"excludedRPList,omitempty"`

	// Gets the class type.
	ObjectType *string `json:"objectType,omitempty"`
}

// LogSchedulePolicy - Log policy schedule.
type LogSchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string `json:"schedulePolicyType,omitempty"`

	// Frequency of the log schedule operation of this policy in minutes.
	ScheduleFrequencyInMins *int32 `json:"scheduleFrequencyInMins,omitempty"`
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type LogSchedulePolicy.
func (l *LogSchedulePolicy) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: l.SchedulePolicyType,
	}
}

// LongTermRetentionPolicy - Long term retention policy.
type LongTermRetentionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	RetentionPolicyType *string `json:"retentionPolicyType,omitempty"`

	// Daily retention schedule of the protection policy.
	DailySchedule *DailyRetentionSchedule `json:"dailySchedule,omitempty"`

	// Monthly retention schedule of the protection policy.
	MonthlySchedule *MonthlyRetentionSchedule `json:"monthlySchedule,omitempty"`

	// Weekly retention schedule of the protection policy.
	WeeklySchedule *WeeklyRetentionSchedule `json:"weeklySchedule,omitempty"`

	// Yearly retention schedule of the protection policy.
	YearlySchedule *YearlyRetentionSchedule `json:"yearlySchedule,omitempty"`
}

// GetRetentionPolicy implements the RetentionPolicyClassification interface for type LongTermRetentionPolicy.
func (l *LongTermRetentionPolicy) GetRetentionPolicy() *RetentionPolicy {
	return &RetentionPolicy{
		RetentionPolicyType: l.RetentionPolicyType,
	}
}

// LongTermSchedulePolicy - Long term policy schedule.
type LongTermSchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string `json:"schedulePolicyType,omitempty"`
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type LongTermSchedulePolicy.
func (l *LongTermSchedulePolicy) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: l.SchedulePolicyType,
	}
}

// MABContainerHealthDetails - MAB workload-specific Health Details.
type MABContainerHealthDetails struct {
	// Health Code
	Code *int32 `json:"code,omitempty"`

	// Health Message
	Message *string `json:"message,omitempty"`

	// Health Recommended Actions
	Recommendations []*string `json:"recommendations,omitempty"`

	// Health Title
	Title *string `json:"title,omitempty"`
}

// MabContainer - Container with items backed up using MAB backup engine.
type MabContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Agent version of this container.
	AgentVersion *string `json:"agentVersion,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Can the container be registered one more time.
	CanReRegister *bool `json:"canReRegister,omitempty"`

	// Health state of mab container.
	ContainerHealthState *string `json:"containerHealthState,omitempty"`

	// ContainerID represents the container.
	ContainerID *int64 `json:"containerId,omitempty"`

	// Additional information for this container
	ExtendedInfo *MabContainerExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Health details on this mab container.
	MabContainerHealthDetails []*MABContainerHealthDetails `json:"mabContainerHealthDetails,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Number of items backed up in this container.
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type MabContainer.
func (m *MabContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		FriendlyName:          m.FriendlyName,
		BackupManagementType:  m.BackupManagementType,
		RegistrationStatus:    m.RegistrationStatus,
		HealthStatus:          m.HealthStatus,
		ContainerType:         m.ContainerType,
		ProtectableObjectType: m.ProtectableObjectType,
	}
}

// MabContainerExtendedInfo - Additional information of the container.
type MabContainerExtendedInfo struct {
	// Type of backup items associated with this container.
	BackupItemType *BackupItemType `json:"backupItemType,omitempty"`

	// List of backup items associated with this container.
	BackupItems []*string `json:"backupItems,omitempty"`

	// Latest backup status of this container.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`

	// Time stamp when this container was refreshed.
	LastRefreshedAt *time.Time `json:"lastRefreshedAt,omitempty"`

	// Backup policy associated with this container.
	PolicyName *string `json:"policyName,omitempty"`
}

// MabErrorInfo - MAB workload-specific error information.
type MabErrorInfo struct {
	// READ-ONLY; Localized error string.
	ErrorString *string `json:"errorString,omitempty" azure:"ro"`

	// READ-ONLY; List of localized recommendations.
	Recommendations []*string `json:"recommendations,omitempty" azure:"ro"`
}

// MabFileFolderProtectedItem - MAB workload-specific backup item.
type MabFileFolderProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Name of the computer associated with this backup item.
	ComputerName *string `json:"computerName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Sync time for deferred deletion in UTC
	DeferredDeleteSyncTimeInUTC *int64 `json:"deferredDeleteSyncTimeInUTC,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Additional information with this backup item.
	ExtendedInfo *MabFileFolderProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`

	// Friendly name of this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Status of last backup operation.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time `json:"lastBackupTime,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// Protected, ProtectionStopped, IRPending or ProtectionError
	ProtectionState *string `json:"protectionState,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetProtectedItem implements the ProtectedItemClassification interface for type MabFileFolderProtectedItem.
func (m *MabFileFolderProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		ProtectedItemType:                m.ProtectedItemType,
		BackupManagementType:             m.BackupManagementType,
		WorkloadType:                     m.WorkloadType,
		ContainerName:                    m.ContainerName,
		SourceResourceID:                 m.SourceResourceID,
		PolicyID:                         m.PolicyID,
		LastRecoveryPoint:                m.LastRecoveryPoint,
		BackupSetName:                    m.BackupSetName,
		CreateMode:                       m.CreateMode,
		DeferredDeleteTimeInUTC:          m.DeferredDeleteTimeInUTC,
		IsScheduledForDeferredDelete:     m.IsScheduledForDeferredDelete,
		DeferredDeleteTimeRemaining:      m.DeferredDeleteTimeRemaining,
		IsDeferredDeleteScheduleUpcoming: m.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      m.IsRehydrate,
		ResourceGuardOperationRequests:   m.ResourceGuardOperationRequests,
		IsArchiveEnabled:                 m.IsArchiveEnabled,
		PolicyName:                       m.PolicyName,
	}
}

// MabFileFolderProtectedItemExtendedInfo - Additional information on the backed up item.
type MabFileFolderProtectedItemExtendedInfo struct {
	// Last time when the agent data synced to service.
	LastRefreshedAt *time.Time `json:"lastRefreshedAt,omitempty"`

	// The oldest backup copy available.
	OldestRecoveryPoint *time.Time `json:"oldestRecoveryPoint,omitempty"`

	// Number of backup copies associated with the backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
}

// MabJob - MAB workload-specific job.
type MabJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// The state/actions applicable on jobs like cancel/retry.
	ActionsInfo []*JobSupportedAction `json:"actionsInfo,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Time taken by job to run.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// The errors.
	ErrorDetails []*MabErrorInfo `json:"errorDetails,omitempty"`

	// Additional information on the job.
	ExtendedInfo *MabJobExtendedInfo `json:"extendedInfo,omitempty"`

	// Name of server protecting the DS.
	MabServerName *string `json:"mabServerName,omitempty"`

	// Server type of MAB container.
	MabServerType *MabServerType `json:"mabServerType,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`

	// Workload type of backup item.
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// GetJob implements the JobClassification interface for type MabJob.
func (m *MabJob) GetJob() *Job {
	return &Job{
		EntityFriendlyName:   m.EntityFriendlyName,
		BackupManagementType: m.BackupManagementType,
		Operation:            m.Operation,
		Status:               m.Status,
		StartTime:            m.StartTime,
		EndTime:              m.EndTime,
		ActivityID:           m.ActivityID,
		JobType:              m.JobType,
	}
}

// MabJobExtendedInfo - Additional information for the MAB workload-specific job.
type MabJobExtendedInfo struct {
	// Non localized error message specific to this job.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`

	// The job properties.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`

	// List of tasks for this job.
	TasksList []*MabJobTaskDetails `json:"tasksList,omitempty"`
}

// MabJobTaskDetails - MAB workload-specific job task details.
type MabJobTaskDetails struct {
	// Time elapsed for task.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status.
	Status *string `json:"status,omitempty"`

	// The task display name.
	TaskID *string `json:"taskId,omitempty"`
}

// MabProtectionPolicy - Mab container-specific backup policy.
type MabProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// Retention policy details.
	RetentionPolicy RetentionPolicyClassification `json:"retentionPolicy,omitempty"`

	// Backup schedule of backup policy.
	SchedulePolicy SchedulePolicyClassification `json:"schedulePolicy,omitempty"`
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type MabProtectionPolicy.
func (m *MabProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		ProtectedItemsCount:            m.ProtectedItemsCount,
		BackupManagementType:           m.BackupManagementType,
		ResourceGuardOperationRequests: m.ResourceGuardOperationRequests,
	}
}

// MonthlyRetentionSchedule - Monthly retention schedule.
type MonthlyRetentionSchedule struct {
	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`

	// Daily retention format for monthly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat `json:"retentionScheduleDaily,omitempty"`

	// Retention schedule format type for monthly retention policy.
	RetentionScheduleFormatType *RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`

	// Weekly retention format for monthly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat `json:"retentionScheduleWeekly,omitempty"`

	// Retention times of retention policy.
	RetentionTimes []*time.Time `json:"retentionTimes,omitempty"`
}

type MoveRPAcrossTiersRequest struct {
	// Gets the class type.
	ObjectType *string `json:"objectType,omitempty"`

	// Source tier from where RP needs to be moved
	SourceTierType *RecoveryPointTierType `json:"sourceTierType,omitempty"`

	// Target tier where RP needs to be moved
	TargetTierType *RecoveryPointTierType `json:"targetTierType,omitempty"`
}

// NameInfo - The name of usage.
type NameInfo struct {
	// Localized value of usage.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// Value of usage.
	Value *string `json:"value,omitempty"`
}

// NewErrorResponse - The resource management error response.
type NewErrorResponse struct {
	// The error object.
	Error *NewErrorResponseError `json:"error,omitempty"`
}

// NewErrorResponseError - The error object.
type NewErrorResponseError struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*NewErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// OperationClientValidateOptions contains the optional parameters for the OperationClient.Validate method.
type OperationClientValidateOptions struct {
	// placeholder for future optional parameters
}

// OperationResultInfo - Operation result info.
type OperationResultInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// List of jobs created by this operation.
	JobList []*string `json:"jobList,omitempty"`
}

// GetOperationResultInfoBase implements the OperationResultInfoBaseClassification interface for type OperationResultInfo.
func (o *OperationResultInfo) GetOperationResultInfoBase() *OperationResultInfoBase {
	return &OperationResultInfoBase{
		ObjectType: o.ObjectType,
	}
}

// OperationResultInfoBaseClassification provides polymorphic access to related types.
// Call the interface's GetOperationResultInfoBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ExportJobsOperationResultInfo, *OperationResultInfo, *OperationResultInfoBase
type OperationResultInfoBaseClassification interface {
	// GetOperationResultInfoBase returns the OperationResultInfoBase content of the underlying type.
	GetOperationResultInfoBase() *OperationResultInfoBase
}

// OperationResultInfoBase - Base class for operation result info.
type OperationResultInfoBase struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetOperationResultInfoBase implements the OperationResultInfoBaseClassification interface for type OperationResultInfoBase.
func (o *OperationResultInfoBase) GetOperationResultInfoBase() *OperationResultInfoBase { return o }

// OperationResultInfoBaseResource - Base class for operation result info.
type OperationResultInfoBaseResource struct {
	// HTTP headers associated with this operation.
	Headers map[string][]*string `json:"headers,omitempty"`

	// OperationResultInfoBaseResource operation
	Operation OperationResultInfoBaseClassification `json:"operation,omitempty"`

	// HTTP Status Code of the operation.
	StatusCode *HTTPStatusCode `json:"statusCode,omitempty"`
}

// OperationStatus - Operation status.
type OperationStatus struct {
	// Operation end time. Format: ISO-8601.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Error information related to this operation.
	Error *OperationStatusError `json:"error,omitempty"`

	// ID of the operation.
	ID *string `json:"id,omitempty"`

	// Name of the operation.
	Name *string `json:"name,omitempty"`

	// Additional information associated with this operation.
	Properties OperationStatusExtendedInfoClassification `json:"properties,omitempty"`

	// Operation start time. Format: ISO-8601.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Operation status.
	Status *OperationStatusValues `json:"status,omitempty"`
}

// OperationStatusError - Error information associated with operation status call.
type OperationStatusError struct {
	// Error code of the operation failure.
	Code *string `json:"code,omitempty"`

	// Error message displayed if the operation failure.
	Message *string `json:"message,omitempty"`
}

// OperationStatusExtendedInfoClassification provides polymorphic access to related types.
// Call the interface's GetOperationStatusExtendedInfo() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *OperationStatusExtendedInfo, *OperationStatusJobExtendedInfo, *OperationStatusJobsExtendedInfo, *OperationStatusProvisionILRExtendedInfo,
// - *OperationStatusValidateOperationExtendedInfo
type OperationStatusExtendedInfoClassification interface {
	// GetOperationStatusExtendedInfo returns the OperationStatusExtendedInfo content of the underlying type.
	GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo
}

// OperationStatusExtendedInfo - Base class for additional information of operation status.
type OperationStatusExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusExtendedInfo.
func (o *OperationStatusExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return o
}

// OperationStatusJobExtendedInfo - Operation status job extended info.
type OperationStatusJobExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// ID of the job created for this protected item.
	JobID *string `json:"jobId,omitempty"`
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusJobExtendedInfo.
func (o *OperationStatusJobExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationStatusJobsExtendedInfo - Operation status extended info for list of jobs.
type OperationStatusJobsExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Stores all the failed jobs along with the corresponding error codes.
	FailedJobsError map[string]*string `json:"failedJobsError,omitempty"`

	// IDs of the jobs created for the protected item.
	JobIDs []*string `json:"jobIds,omitempty"`
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusJobsExtendedInfo.
func (o *OperationStatusJobsExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationStatusProvisionILRExtendedInfo - Operation status extended info for ILR provision action.
type OperationStatusProvisionILRExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Target details for file / folder restore.
	RecoveryTarget *InstantItemRecoveryTarget `json:"recoveryTarget,omitempty"`
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusProvisionILRExtendedInfo.
func (o *OperationStatusProvisionILRExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationStatusValidateOperationExtendedInfo - Operation status extended info for ValidateOperation action.
type OperationStatusValidateOperationExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Gets the validation operation response
	ValidateOperationResponse *ValidateOperationResponse `json:"validateOperationResponse,omitempty"`
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusValidateOperationExtendedInfo.
func (o *OperationStatusValidateOperationExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationWorkerResponse - This is the base class for operation result responses.
type OperationWorkerResponse struct {
	// HTTP headers associated with this operation.
	Headers map[string][]*string `json:"headers,omitempty"`

	// HTTP Status Code of the operation.
	StatusCode *HTTPStatusCode `json:"statusCode,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PointInTimeRange - Provides details for log ranges
type PointInTimeRange struct {
	// End time of the time range for log recovery.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Start time of the time range for log recovery.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// PreBackupValidation - Pre-backup validation for Azure VM Workload provider.
type PreBackupValidation struct {
	// Error code of protectable item
	Code *string `json:"code,omitempty"`

	// Message corresponding to the error code for the protectable item
	Message *string `json:"message,omitempty"`

	// Status of protectable item, i.e. InProgress,Succeeded,Failed
	Status *InquiryStatus `json:"status,omitempty"`
}

// PreValidateEnableBackupRequest - Contract to validate if backup can be enabled on the given resource in a given vault and
// given configuration. It will validate followings
// 1. Vault capacity
// 2. VM is already protected
// 3. Any VM related configuration passed in properties.
type PreValidateEnableBackupRequest struct {
	// Configuration of VM if any needs to be validated like OS type etc
	Properties *string `json:"properties,omitempty"`

	// ARM Virtual Machine Id
	ResourceID *string `json:"resourceId,omitempty"`

	// ProtectedItem Type- VM, SqlDataBase, AzureFileShare etc
	ResourceType *DataSourceType `json:"resourceType,omitempty"`

	// ARM id of the Recovery Services Vault
	VaultID *string `json:"vaultId,omitempty"`
}

// PreValidateEnableBackupResponse - Response contract for enable backup validation request
type PreValidateEnableBackupResponse struct {
	// Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required for
	// portal
	ContainerName *string `json:"containerName,omitempty"`

	// Response error code
	ErrorCode *string `json:"errorCode,omitempty"`

	// Response error message
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// Specifies the product specific ds name. E.g. vm;iaasvmcontainer;rgname;vmname. This is required for portal
	ProtectedItemName *string `json:"protectedItemName,omitempty"`

	// Recommended action for user
	Recommendation *string `json:"recommendation,omitempty"`

	// Validation Status
	Status *ValidationStatus `json:"status,omitempty"`
}

// PrepareDataMoveRequest - Prepare DataMove Request
type PrepareDataMoveRequest struct {
	// REQUIRED; DataMove Level
	DataMoveLevel *DataMoveLevel `json:"dataMoveLevel,omitempty"`

	// REQUIRED; Target Region
	TargetRegion *string `json:"targetRegion,omitempty"`

	// REQUIRED; ARM Id of target vault
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// Ignore the artifacts which are already moved.
	IgnoreMoved *bool `json:"ignoreMoved,omitempty"`

	// Source Container ArmIds This needs to be populated only if DataMoveLevel is set to container
	SourceContainerArmIDs []*string `json:"sourceContainerArmIds,omitempty"`
}

// PrepareDataMoveResponse - Prepare DataMove Response
type PrepareDataMoveResponse struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Co-relationId for move operation
	CorrelationID *string `json:"correlationId,omitempty"`

	// Source Vault Properties
	SourceVaultProperties map[string]*string `json:"sourceVaultProperties,omitempty"`
}

// GetVaultStorageConfigOperationResultResponse implements the VaultStorageConfigOperationResultResponseClassification interface
// for type PrepareDataMoveResponse.
func (p *PrepareDataMoveResponse) GetVaultStorageConfigOperationResultResponse() *VaultStorageConfigOperationResultResponse {
	return &VaultStorageConfigOperationResultResponse{
		ObjectType: p.ObjectType,
	}
}

// PrivateEndpoint - The Private Endpoint network resource that is linked to the Private Endpoint connection
type PrivateEndpoint struct {
	// Gets or sets id
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointClientGetOperationStatusOptions contains the optional parameters for the PrivateEndpointClient.GetOperationStatus
// method.
type PrivateEndpointClientGetOperationStatusOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnection - Private Endpoint Connection Response Properties
type PrivateEndpointConnection struct {
	// Gets or sets private endpoint associated with the private endpoint connection
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Gets or sets private link service connection state
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Gets or sets provisioning state of the private endpoint connection
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionClient.BeginDelete
// method.
type PrivateEndpointConnectionClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionClientBeginPutOptions contains the optional parameters for the PrivateEndpointConnectionClient.BeginPut
// method.
type PrivateEndpointConnectionClientBeginPutOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionClientGetOptions contains the optional parameters for the PrivateEndpointConnectionClient.Get
// method.
type PrivateEndpointConnectionClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionResource - Private Endpoint Connection Response Properties
type PrivateEndpointConnectionResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// PrivateEndpointConnectionResource properties
	Properties *PrivateEndpointConnection `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnectionState - Private Link Service Connection State
type PrivateLinkServiceConnectionState struct {
	// Gets or sets actions required
	ActionRequired *string `json:"actionRequired,omitempty"`

	// Gets or sets description
	Description *string `json:"description,omitempty"`

	// Gets or sets the status
	Status *PrivateEndpointConnectionStatus `json:"status,omitempty"`
}

// ProtectableContainerClassification provides polymorphic access to related types.
// Call the interface's GetProtectableContainer() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureStorageProtectableContainer, *AzureVMAppContainerProtectableContainer, *ProtectableContainer
type ProtectableContainerClassification interface {
	// GetProtectableContainer returns the ProtectableContainer content of the underlying type.
	GetProtectableContainer() *ProtectableContainer
}

// ProtectableContainer - Protectable Container Class.
type ProtectableContainer struct {
	// REQUIRED; Type of the container. The value of this property for
	// 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines
	ProtectableContainerType *ContainerType `json:"protectableContainerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Fabric Id of the container such as ARM Id.
	ContainerID *string `json:"containerId,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`
}

// GetProtectableContainer implements the ProtectableContainerClassification interface for type ProtectableContainer.
func (p *ProtectableContainer) GetProtectableContainer() *ProtectableContainer { return p }

// ProtectableContainerResource - Protectable Container Class.
type ProtectableContainerResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ProtectableContainerResource properties
	Properties ProtectableContainerClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectableContainerResourceList - List of ProtectableContainer resources
type ProtectableContainerResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*ProtectableContainerResource `json:"value,omitempty"`
}

// ProtectableContainersClientListOptions contains the optional parameters for the ProtectableContainersClient.List method.
type ProtectableContainersClientListOptions struct {
	// OData filter options.
	Filter *string
}

// ProtectedItemClassification provides polymorphic access to related types.
// Call the interface's GetProtectedItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileshareProtectedItem, *AzureIaaSClassicComputeVMProtectedItem, *AzureIaaSComputeVMProtectedItem, *AzureIaaSVMProtectedItem,
// - *AzureSQLProtectedItem, *AzureVMWorkloadProtectedItem, *AzureVMWorkloadSAPAseDatabaseProtectedItem, *AzureVMWorkloadSAPHanaDatabaseProtectedItem,
// - *AzureVMWorkloadSQLDatabaseProtectedItem, *DPMProtectedItem, *GenericProtectedItem, *MabFileFolderProtectedItem, *ProtectedItem
type ProtectedItemClassification interface {
	// GetProtectedItem returns the ProtectedItem content of the underlying type.
	GetProtectedItem() *ProtectedItem
}

// ProtectedItem - Base class for backup items.
type ProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set the backup item belongs to
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Unique name of container
	ContainerName *string `json:"containerName,omitempty"`

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time `json:"deferredDeleteTimeInUTC,omitempty"`

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string `json:"deferredDeleteTimeRemaining,omitempty"`

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool `json:"isDeferredDeleteScheduleUpcoming,omitempty"`

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool `json:"isRehydrate,omitempty"`

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool `json:"isScheduledForDeferredDelete,omitempty"`

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time `json:"lastRecoveryPoint,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Name of the policy used for protection
	PolicyName *string `json:"policyName,omitempty"`

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Type of workload this item represents.
	WorkloadType *DataSourceType `json:"workloadType,omitempty"`
}

// GetProtectedItem implements the ProtectedItemClassification interface for type ProtectedItem.
func (p *ProtectedItem) GetProtectedItem() *ProtectedItem { return p }

// ProtectedItemOperationResultsClientGetOptions contains the optional parameters for the ProtectedItemOperationResultsClient.Get
// method.
type ProtectedItemOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectedItemOperationStatusesClientGetOptions contains the optional parameters for the ProtectedItemOperationStatusesClient.Get
// method.
type ProtectedItemOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectedItemQueryObject - Filters to list backup items.
type ProtectedItemQueryObject struct {
	// Backup Engine name
	BackupEngineName *string `json:"backupEngineName,omitempty"`

	// Backup management type for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Name of the backup set.
	BackupSetName *string `json:"backupSetName,omitempty"`

	// Name of the container.
	ContainerName *string `json:"containerName,omitempty"`

	// Name of the fabric.
	FabricName *string `json:"fabricName,omitempty"`

	// Friendly name of protected item
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Health State for the backed up item.
	HealthState *HealthState `json:"healthState,omitempty"`

	// Type of workload this item represents.
	ItemType *DataSourceType `json:"itemType,omitempty"`

	// Backup policy name associated with the backup item.
	PolicyName *string `json:"policyName,omitempty"`
}

// ProtectedItemResource - Base class for backup items.
type ProtectedItemResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ProtectedItemResource properties
	Properties ProtectedItemClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectedItemResourceList - List of ProtectedItem resources
type ProtectedItemResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*ProtectedItemResource `json:"value,omitempty"`
}

// ProtectedItemsClientCreateOrUpdateOptions contains the optional parameters for the ProtectedItemsClient.CreateOrUpdate
// method.
type ProtectedItemsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProtectedItemsClientDeleteOptions contains the optional parameters for the ProtectedItemsClient.Delete method.
type ProtectedItemsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProtectedItemsClientGetOptions contains the optional parameters for the ProtectedItemsClient.Get method.
type ProtectedItemsClientGetOptions struct {
	// OData filter options.
	Filter *string
}

// ProtectionContainerClassification provides polymorphic access to related types.
// Call the interface's GetProtectionContainer() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBackupServerContainer, *AzureIaaSClassicComputeVMContainer, *AzureIaaSComputeVMContainer, *AzureSQLAGWorkloadContainerProtectionContainer,
// - *AzureSQLContainer, *AzureStorageContainer, *AzureVMAppContainerProtectionContainer, *AzureWorkloadContainer, *DpmContainer,
// - *GenericContainer, *IaaSVMContainer, *MabContainer, *ProtectionContainer
type ProtectionContainerClassification interface {
	// GetProtectionContainer returns the ProtectionContainer content of the underlying type.
	GetProtectionContainer() *ProtectionContainer
}

// ProtectionContainer - Base class for container with backup items. Containers with specific workloads are derived from this
// class.
type ProtectionContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ContainerType `json:"containerType,omitempty"`

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Status of health of the container.
	HealthStatus *string `json:"healthStatus,omitempty"`

	// Type of the protectable object associated with this container
	ProtectableObjectType *string `json:"protectableObjectType,omitempty"`

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type ProtectionContainer.
func (p *ProtectionContainer) GetProtectionContainer() *ProtectionContainer { return p }

// ProtectionContainerOperationResultsClientGetOptions contains the optional parameters for the ProtectionContainerOperationResultsClient.Get
// method.
type ProtectionContainerOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectionContainerRefreshOperationResultsClientGetOptions contains the optional parameters for the ProtectionContainerRefreshOperationResultsClient.Get
// method.
type ProtectionContainerRefreshOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectionContainerResource - Base class for container with backup items. Containers with specific workloads are derived
// from this class.
type ProtectionContainerResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ProtectionContainerResource properties
	Properties ProtectionContainerClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectionContainerResourceList - List of ProtectionContainer resources
type ProtectionContainerResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*ProtectionContainerResource `json:"value,omitempty"`
}

// ProtectionContainersClientGetOptions contains the optional parameters for the ProtectionContainersClient.Get method.
type ProtectionContainersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectionContainersClientInquireOptions contains the optional parameters for the ProtectionContainersClient.Inquire method.
type ProtectionContainersClientInquireOptions struct {
	// OData filter options.
	Filter *string
}

// ProtectionContainersClientRefreshOptions contains the optional parameters for the ProtectionContainersClient.Refresh method.
type ProtectionContainersClientRefreshOptions struct {
	// OData filter options.
	Filter *string
}

// ProtectionContainersClientRegisterOptions contains the optional parameters for the ProtectionContainersClient.Register
// method.
type ProtectionContainersClientRegisterOptions struct {
	// placeholder for future optional parameters
}

// ProtectionContainersClientUnregisterOptions contains the optional parameters for the ProtectionContainersClient.Unregister
// method.
type ProtectionContainersClientUnregisterOptions struct {
	// placeholder for future optional parameters
}

// ProtectionIntentClassification provides polymorphic access to related types.
// Call the interface's GetProtectionIntent() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureRecoveryServiceVaultProtectionIntent, *AzureResourceProtectionIntent, *AzureWorkloadAutoProtectionIntent, *AzureWorkloadContainerAutoProtectionIntent,
// - *AzureWorkloadSQLAutoProtectionIntent, *ProtectionIntent
type ProtectionIntentClassification interface {
	// GetProtectionIntent returns the ProtectionIntent content of the underlying type.
	GetProtectionIntent() *ProtectionIntent
}

// ProtectionIntent - Base class for backup ProtectionIntent.
type ProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType `json:"protectionIntentItemType,omitempty"`

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string `json:"itemId,omitempty"`

	// ID of the backup policy with which this item is backed up.
	PolicyID *string `json:"policyId,omitempty"`

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// ARM ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type ProtectionIntent.
func (p *ProtectionIntent) GetProtectionIntent() *ProtectionIntent { return p }

// ProtectionIntentClientCreateOrUpdateOptions contains the optional parameters for the ProtectionIntentClient.CreateOrUpdate
// method.
type ProtectionIntentClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProtectionIntentClientDeleteOptions contains the optional parameters for the ProtectionIntentClient.Delete method.
type ProtectionIntentClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ProtectionIntentClientGetOptions contains the optional parameters for the ProtectionIntentClient.Get method.
type ProtectionIntentClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectionIntentClientValidateOptions contains the optional parameters for the ProtectionIntentClient.Validate method.
type ProtectionIntentClientValidateOptions struct {
	// placeholder for future optional parameters
}

// ProtectionIntentQueryObject - Filters to list protection intent.
type ProtectionIntentQueryObject struct {
	// Backup management type for the backed up item
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Item name of the intent
	ItemName *string `json:"itemName,omitempty"`

	// Type of workload this item represents
	ItemType *IntentItemType `json:"itemType,omitempty"`

	// Parent name of the intent
	ParentName *string `json:"parentName,omitempty"`
}

// ProtectionIntentResource - Base class for backup ProtectionIntent.
type ProtectionIntentResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ProtectionIntentResource properties
	Properties ProtectionIntentClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectionIntentResourceList - List of ProtectionIntent resources
type ProtectionIntentResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*ProtectionIntentResource `json:"value,omitempty"`
}

// ProtectionPoliciesClientBeginDeleteOptions contains the optional parameters for the ProtectionPoliciesClient.BeginDelete
// method.
type ProtectionPoliciesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProtectionPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ProtectionPoliciesClient.CreateOrUpdate
// method.
type ProtectionPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProtectionPoliciesClientGetOptions contains the optional parameters for the ProtectionPoliciesClient.Get method.
type ProtectionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectionPolicyClassification provides polymorphic access to related types.
// Call the interface's GetProtectionPolicy() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileShareProtectionPolicy, *AzureIaaSVMProtectionPolicy, *AzureSQLProtectionPolicy, *AzureVMWorkloadProtectionPolicy,
// - *GenericProtectionPolicy, *MabProtectionPolicy, *ProtectionPolicy
type ProtectionPolicyClassification interface {
	// GetProtectionPolicy returns the ProtectionPolicy content of the underlying type.
	GetProtectionPolicy() *ProtectionPolicy
}

// ProtectionPolicy - Base class for backup policy. Workload-specific backup policies are derived from this class.
type ProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type ProtectionPolicy.
func (p *ProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy { return p }

// ProtectionPolicyOperationResultsClientGetOptions contains the optional parameters for the ProtectionPolicyOperationResultsClient.Get
// method.
type ProtectionPolicyOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectionPolicyOperationStatusesClientGetOptions contains the optional parameters for the ProtectionPolicyOperationStatusesClient.Get
// method.
type ProtectionPolicyOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProtectionPolicyQueryObject - Filters the list backup policies API.
type ProtectionPolicyQueryObject struct {
	// Backup management type for the backup policy.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Fabric name for filter
	FabricName *string `json:"fabricName,omitempty"`

	// Workload type for the backup policy.
	WorkloadType *WorkloadType `json:"workloadType,omitempty"`
}

// ProtectionPolicyResource - Base class for backup policy. Workload-specific backup policies are derived from this class.
type ProtectionPolicyResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ProtectionPolicyResource properties
	Properties ProtectionPolicyClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProtectionPolicyResourceList - List of ProtectionPolicy resources
type ProtectionPolicyResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*ProtectionPolicyResource `json:"value,omitempty"`
}

// RecoveryPointClassification provides polymorphic access to related types.
// Call the interface's GetRecoveryPoint() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileShareRecoveryPoint, *AzureWorkloadPointInTimeRecoveryPoint, *AzureWorkloadRecoveryPoint, *AzureWorkloadSAPHanaPointInTimeRecoveryPoint,
// - *AzureWorkloadSAPHanaRecoveryPoint, *AzureWorkloadSQLPointInTimeRecoveryPoint, *AzureWorkloadSQLRecoveryPoint, *GenericRecoveryPoint,
// - *IaasVMRecoveryPoint, *RecoveryPoint
type RecoveryPointClassification interface {
	// GetRecoveryPoint returns the RecoveryPoint content of the underlying type.
	GetRecoveryPoint() *RecoveryPoint
}

// RecoveryPoint - Base class for backup copies. Workload-specific backup copies are derived from this class.
type RecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type RecoveryPoint.
func (r *RecoveryPoint) GetRecoveryPoint() *RecoveryPoint { return r }

// RecoveryPointDiskConfiguration - Disk configuration
type RecoveryPointDiskConfiguration struct {
	// Information of disks excluded from backup
	ExcludedDiskList []*DiskInformation `json:"excludedDiskList,omitempty"`

	// Information of disks included in backup
	IncludedDiskList []*DiskInformation `json:"includedDiskList,omitempty"`

	// Number of disks attached to the VM
	NumberOfDisksAttachedToVM *int32 `json:"numberOfDisksAttachedToVm,omitempty"`

	// Number of disks included in backup
	NumberOfDisksIncludedInBackup *int32 `json:"numberOfDisksIncludedInBackup,omitempty"`
}

type RecoveryPointMoveReadinessInfo struct {
	AdditionalInfo *string `json:"additionalInfo,omitempty"`
	IsReadyForMove *bool   `json:"isReadyForMove,omitempty"`
}

// RecoveryPointRehydrationInfo - RP Rehydration Info
type RecoveryPointRehydrationInfo struct {
	// Rehydration Priority
	RehydrationPriority *RehydrationPriority `json:"rehydrationPriority,omitempty"`

	// How long the rehydrated RP should be kept Should be ISO8601 Duration format e.g. "P7D"
	RehydrationRetentionDuration *string `json:"rehydrationRetentionDuration,omitempty"`
}

// RecoveryPointResource - Base class for backup copies. Workload-specific backup copies are derived from this class.
type RecoveryPointResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// RecoveryPointResource properties
	Properties RecoveryPointClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoveryPointResourceList - List of RecoveryPoint resources
type RecoveryPointResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*RecoveryPointResource `json:"value,omitempty"`
}

// RecoveryPointTierInformation - Recovery point tier information.
type RecoveryPointTierInformation struct {
	// Recovery point tier status.
	ExtendedInfo map[string]*string `json:"extendedInfo,omitempty"`

	// Recovery point tier status.
	Status *RecoveryPointTierStatus `json:"status,omitempty"`

	// Recovery point tier type.
	Type *RecoveryPointTierType `json:"type,omitempty"`
}

// RecoveryPointTierInformationV2 - RecoveryPoint Tier Information V2
type RecoveryPointTierInformationV2 struct {
	// Recovery point tier status.
	ExtendedInfo map[string]*string `json:"extendedInfo,omitempty"`

	// Recovery point tier status.
	Status *RecoveryPointTierStatus `json:"status,omitempty"`

	// Recovery point tier type.
	Type *RecoveryPointTierType `json:"type,omitempty"`
}

// RecoveryPointsClientGetOptions contains the optional parameters for the RecoveryPointsClient.Get method.
type RecoveryPointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecoveryPointsClientListOptions contains the optional parameters for the RecoveryPointsClient.List method.
type RecoveryPointsClientListOptions struct {
	// OData filter options.
	Filter *string
}

// RecoveryPointsRecommendedForMoveClientListOptions contains the optional parameters for the RecoveryPointsRecommendedForMoveClient.List
// method.
type RecoveryPointsRecommendedForMoveClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - ARM Resource.
type Resource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ResourceGuardOperationDetail struct {
	DefaultResourceRequest *string `json:"defaultResourceRequest,omitempty"`
	VaultCriticalOperation *string `json:"vaultCriticalOperation,omitempty"`
}

// ResourceGuardProxiesClientGetOptions contains the optional parameters for the ResourceGuardProxiesClient.Get method.
type ResourceGuardProxiesClientGetOptions struct {
	// placeholder for future optional parameters
}

type ResourceGuardProxyBase struct {
	Description                   *string                         `json:"description,omitempty"`
	LastUpdatedTime               *string                         `json:"lastUpdatedTime,omitempty"`
	ResourceGuardOperationDetails []*ResourceGuardOperationDetail `json:"resourceGuardOperationDetails,omitempty"`
	ResourceGuardResourceID       *string                         `json:"resourceGuardResourceId,omitempty"`
}

type ResourceGuardProxyBaseResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// ResourceGuardProxyBaseResource properties
	Properties *ResourceGuardProxyBase `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceGuardProxyBaseResourceList - List of ResourceGuardProxyBase resources
type ResourceGuardProxyBaseResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*ResourceGuardProxyBaseResource `json:"value,omitempty"`
}

// ResourceGuardProxyClientDeleteOptions contains the optional parameters for the ResourceGuardProxyClient.Delete method.
type ResourceGuardProxyClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardProxyClientGetOptions contains the optional parameters for the ResourceGuardProxyClient.Get method.
type ResourceGuardProxyClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardProxyClientPutOptions contains the optional parameters for the ResourceGuardProxyClient.Put method.
type ResourceGuardProxyClientPutOptions struct {
	// placeholder for future optional parameters
}

// ResourceGuardProxyClientUnlockDeleteOptions contains the optional parameters for the ResourceGuardProxyClient.UnlockDelete
// method.
type ResourceGuardProxyClientUnlockDeleteOptions struct {
	// placeholder for future optional parameters
}

// ResourceHealthDetails - Health Details for backup items.
type ResourceHealthDetails struct {
	// READ-ONLY; Health Code
	Code *int32 `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Health Message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Health Recommended Actions
	Recommendations []*string `json:"recommendations,omitempty" azure:"ro"`

	// READ-ONLY; Health Title
	Title *string `json:"title,omitempty" azure:"ro"`
}

// ResourceList - Base for all lists of resources.
type ResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestoreFileSpecs - Restore file specs like file path, type and target folder path info.
type RestoreFileSpecs struct {
	// Indicates what the Path variable stands for
	FileSpecType *string `json:"fileSpecType,omitempty"`

	// Source File/Folder path
	Path *string `json:"path,omitempty"`

	// Destination folder path in target FileShare
	TargetFolderPath *string `json:"targetFolderPath,omitempty"`
}

// RestoreRequestClassification provides polymorphic access to related types.
// Call the interface's GetRestoreRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileShareRestoreRequest, *AzureWorkloadPointInTimeRestoreRequest, *AzureWorkloadRestoreRequest, *AzureWorkloadSAPHanaPointInTimeRestoreRequest,
// - *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest, *AzureWorkloadSAPHanaRestoreRequest, *AzureWorkloadSAPHanaRestoreWithRehydrateRequest,
// - *AzureWorkloadSQLPointInTimeRestoreRequest, *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest, *AzureWorkloadSQLRestoreRequest,
// - *AzureWorkloadSQLRestoreWithRehydrateRequest, *IaasVMRestoreRequest, *IaasVMRestoreWithRehydrationRequest, *RestoreRequest
type RestoreRequestClassification interface {
	// GetRestoreRequest returns the RestoreRequest content of the underlying type.
	GetRestoreRequest() *RestoreRequest
}

// RestoreRequest - Base class for restore request. Workload-specific restore requests are derived from this class.
type RestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type RestoreRequest.
func (r *RestoreRequest) GetRestoreRequest() *RestoreRequest { return r }

// RestoreRequestResource - Base class for restore request. Workload-specific restore requests are derived from this class.
type RestoreRequestResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// RestoreRequestResource properties
	Properties RestoreRequestClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestoresClientBeginTriggerOptions contains the optional parameters for the RestoresClient.BeginTrigger method.
type RestoresClientBeginTriggerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RetentionDuration - Retention duration.
type RetentionDuration struct {
	// Count of duration types. Retention duration is obtained by the counting the duration type Count times. For example, when
	// Count = 3 and DurationType = Weeks, retention duration will be three weeks.
	Count *int32 `json:"count,omitempty"`

	// Retention duration type of retention policy.
	DurationType *RetentionDurationType `json:"durationType,omitempty"`
}

// RetentionPolicyClassification provides polymorphic access to related types.
// Call the interface's GetRetentionPolicy() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LongTermRetentionPolicy, *RetentionPolicy, *SimpleRetentionPolicy
type RetentionPolicyClassification interface {
	// GetRetentionPolicy returns the RetentionPolicy content of the underlying type.
	GetRetentionPolicy() *RetentionPolicy
}

// RetentionPolicy - Base class for retention policy.
type RetentionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	RetentionPolicyType *string `json:"retentionPolicyType,omitempty"`
}

// GetRetentionPolicy implements the RetentionPolicyClassification interface for type RetentionPolicy.
func (r *RetentionPolicy) GetRetentionPolicy() *RetentionPolicy { return r }

// SQLDataDirectory info
type SQLDataDirectory struct {
	// Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`

	// File path
	Path *string `json:"path,omitempty"`

	// Type of data directory mapping
	Type *SQLDataDirectoryType `json:"type,omitempty"`
}

// SQLDataDirectoryMapping - Encapsulates information regarding data directory
type SQLDataDirectoryMapping struct {
	// Type of data directory mapping
	MappingType *SQLDataDirectoryType `json:"mappingType,omitempty"`

	// Restore source logical name path
	SourceLogicalName *string `json:"sourceLogicalName,omitempty"`

	// Restore source path
	SourcePath *string `json:"sourcePath,omitempty"`

	// Target path
	TargetPath *string `json:"targetPath,omitempty"`
}

// SchedulePolicyClassification provides polymorphic access to related types.
// Call the interface's GetSchedulePolicy() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LogSchedulePolicy, *LongTermSchedulePolicy, *SchedulePolicy, *SimpleSchedulePolicy, *SimpleSchedulePolicyV2
type SchedulePolicyClassification interface {
	// GetSchedulePolicy returns the SchedulePolicy content of the underlying type.
	GetSchedulePolicy() *SchedulePolicy
}

// SchedulePolicy - Base class for backup schedule.
type SchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string `json:"schedulePolicyType,omitempty"`
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type SchedulePolicy.
func (s *SchedulePolicy) GetSchedulePolicy() *SchedulePolicy { return s }

// SecurityPINsClientGetOptions contains the optional parameters for the SecurityPINsClient.Get method.
type SecurityPINsClientGetOptions struct {
	// security pin request
	Parameters *SecurityPinBase
}

// SecurityPinBase - Base class for get security pin request body
type SecurityPinBase struct {
	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`
}

// Settings - Common settings field for backup management
type Settings struct {
	// Workload compression flag. This has been added so that 'isSqlCompression' will be deprecated once clients upgrade to consider
	// this flag.
	IsCompression *bool `json:"isCompression,omitempty"`

	// SQL compression flag
	Issqlcompression *bool `json:"issqlcompression,omitempty"`

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string `json:"timeZone,omitempty"`
}

// SimpleRetentionPolicy - Simple policy retention.
type SimpleRetentionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	RetentionPolicyType *string `json:"retentionPolicyType,omitempty"`

	// Retention duration of the protection policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// GetRetentionPolicy implements the RetentionPolicyClassification interface for type SimpleRetentionPolicy.
func (s *SimpleRetentionPolicy) GetRetentionPolicy() *RetentionPolicy {
	return &RetentionPolicy{
		RetentionPolicyType: s.RetentionPolicyType,
	}
}

// SimpleSchedulePolicy - Simple policy schedule.
type SimpleSchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string `json:"schedulePolicyType,omitempty"`

	// Hourly Schedule of this Policy
	HourlySchedule *HourlySchedule `json:"hourlySchedule,omitempty"`

	// List of days of week this schedule has to be run.
	ScheduleRunDays []*DayOfWeek `json:"scheduleRunDays,omitempty"`

	// Frequency of the schedule operation of this policy.
	ScheduleRunFrequency *ScheduleRunType `json:"scheduleRunFrequency,omitempty"`

	// List of times of day this schedule has to be run.
	ScheduleRunTimes []*time.Time `json:"scheduleRunTimes,omitempty"`

	// At every number weeks this schedule has to be run.
	ScheduleWeeklyFrequency *int32 `json:"scheduleWeeklyFrequency,omitempty"`
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type SimpleSchedulePolicy.
func (s *SimpleSchedulePolicy) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: s.SchedulePolicyType,
	}
}

// SimpleSchedulePolicyV2 - The V2 policy schedule for IaaS that supports hourly backups.
type SimpleSchedulePolicyV2 struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string `json:"schedulePolicyType,omitempty"`

	// Daily schedule of this policy
	DailySchedule *DailySchedule `json:"dailySchedule,omitempty"`

	// hourly schedule of this policy
	HourlySchedule *HourlySchedule `json:"hourlySchedule,omitempty"`

	// Frequency of the schedule operation of this policy.
	ScheduleRunFrequency *ScheduleRunType `json:"scheduleRunFrequency,omitempty"`

	// Weekly schedule of this policy
	WeeklySchedule *WeeklySchedule `json:"weeklySchedule,omitempty"`
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type SimpleSchedulePolicyV2.
func (s *SimpleSchedulePolicyV2) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: s.SchedulePolicyType,
	}
}

// SubProtectionPolicy - Sub-protection policy which includes schedule and retention
type SubProtectionPolicy struct {
	// Type of backup policy type
	PolicyType *PolicyType `json:"policyType,omitempty"`

	// Retention policy with the details on backup copy retention ranges.
	RetentionPolicy RetentionPolicyClassification `json:"retentionPolicy,omitempty"`

	// Backup schedule specified as part of backup policy.
	SchedulePolicy SchedulePolicyClassification `json:"schedulePolicy,omitempty"`
}

// TargetAFSRestoreInfo - Target Azure File Share Info.
type TargetAFSRestoreInfo struct {
	// File share name
	Name *string `json:"name,omitempty"`

	// Target file share resource ARM ID
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// TargetRestoreInfo - Details about target workload during restore operation.
type TargetRestoreInfo struct {
	// Resource Id name of the container in which Target DataBase resides
	ContainerID *string `json:"containerId,omitempty"`

	// Database name InstanceName/DataBaseName for SQL or System/DbName for SAP Hana
	DatabaseName *string `json:"databaseName,omitempty"`

	// Can Overwrite if Target DataBase already exists
	OverwriteOption *OverwriteOptions `json:"overwriteOption,omitempty"`

	// Target directory location for restore as files.
	TargetDirectoryForFileRestore *string `json:"targetDirectoryForFileRestore,omitempty"`
}

// TokenInformation - The token information details.
type TokenInformation struct {
	// Expiry time of token.
	ExpiryTimeInUTCTicks *int64 `json:"expiryTimeInUtcTicks,omitempty"`

	// Security PIN
	SecurityPIN *string `json:"securityPIN,omitempty"`

	// Token value.
	Token *string `json:"token,omitempty"`
}

// TriggerDataMoveRequest - Trigger DataMove Request
type TriggerDataMoveRequest struct {
	// REQUIRED; Correlation Id
	CorrelationID *string `json:"correlationId,omitempty"`

	// REQUIRED; DataMove Level
	DataMoveLevel *DataMoveLevel `json:"dataMoveLevel,omitempty"`

	// REQUIRED; Source Region
	SourceRegion *string `json:"sourceRegion,omitempty"`

	// REQUIRED; ARM Id of source vault
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Pause GC
	PauseGC *bool `json:"pauseGC,omitempty"`

	// Source Container ArmIds
	SourceContainerArmIDs []*string `json:"sourceContainerArmIds,omitempty"`
}

// UnlockDeleteRequest - Request body of unlock delete API.
type UnlockDeleteRequest struct {
	ResourceGuardOperationRequests []*string `json:"resourceGuardOperationRequests,omitempty"`
	ResourceToBeDeleted            *string   `json:"resourceToBeDeleted,omitempty"`
}

// UnlockDeleteResponse - Response of Unlock Delete API.
type UnlockDeleteResponse struct {
	// This is the time when unlock delete privileges will get expired.
	UnlockDeleteExpiryTime *string `json:"unlockDeleteExpiryTime,omitempty"`
}

// ValidateIaasVMRestoreOperationRequest - AzureRestoreValidation request.
type ValidateIaasVMRestoreOperationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Sets restore request to be validated
	RestoreRequest RestoreRequestClassification `json:"restoreRequest,omitempty"`
}

// GetValidateOperationRequest implements the ValidateOperationRequestClassification interface for type ValidateIaasVMRestoreOperationRequest.
func (v *ValidateIaasVMRestoreOperationRequest) GetValidateOperationRequest() *ValidateOperationRequest {
	return &ValidateOperationRequest{
		ObjectType: v.ObjectType,
	}
}

// GetValidateRestoreOperationRequest implements the ValidateRestoreOperationRequestClassification interface for type ValidateIaasVMRestoreOperationRequest.
func (v *ValidateIaasVMRestoreOperationRequest) GetValidateRestoreOperationRequest() *ValidateRestoreOperationRequest {
	return &ValidateRestoreOperationRequest{
		RestoreRequest: v.RestoreRequest,
		ObjectType:     v.ObjectType,
	}
}

// ValidateOperationClientBeginTriggerOptions contains the optional parameters for the ValidateOperationClient.BeginTrigger
// method.
type ValidateOperationClientBeginTriggerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ValidateOperationRequestClassification provides polymorphic access to related types.
// Call the interface's GetValidateOperationRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ValidateIaasVMRestoreOperationRequest, *ValidateOperationRequest, *ValidateRestoreOperationRequest
type ValidateOperationRequestClassification interface {
	// GetValidateOperationRequest returns the ValidateOperationRequest content of the underlying type.
	GetValidateOperationRequest() *ValidateOperationRequest
}

// ValidateOperationRequest - Base class for validate operation request.
type ValidateOperationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetValidateOperationRequest implements the ValidateOperationRequestClassification interface for type ValidateOperationRequest.
func (v *ValidateOperationRequest) GetValidateOperationRequest() *ValidateOperationRequest { return v }

// ValidateOperationResponse - Base class for validate operation response.
type ValidateOperationResponse struct {
	// Gets the validation result
	ValidationResults []*ErrorDetail `json:"validationResults,omitempty"`
}

// ValidateOperationResultsClientGetOptions contains the optional parameters for the ValidateOperationResultsClient.Get method.
type ValidateOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ValidateOperationStatusesClientGetOptions contains the optional parameters for the ValidateOperationStatusesClient.Get
// method.
type ValidateOperationStatusesClientGetOptions struct {
	// placeholder for future optional parameters
}

type ValidateOperationsResponse struct {
	// Base class for validate operation response.
	ValidateOperationResponse *ValidateOperationResponse `json:"validateOperationResponse,omitempty"`
}

// ValidateRestoreOperationRequestClassification provides polymorphic access to related types.
// Call the interface's GetValidateRestoreOperationRequest() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ValidateIaasVMRestoreOperationRequest, *ValidateRestoreOperationRequest
type ValidateRestoreOperationRequestClassification interface {
	ValidateOperationRequestClassification
	// GetValidateRestoreOperationRequest returns the ValidateRestoreOperationRequest content of the underlying type.
	GetValidateRestoreOperationRequest() *ValidateRestoreOperationRequest
}

// ValidateRestoreOperationRequest - AzureRestoreValidation request.
type ValidateRestoreOperationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`

	// Sets restore request to be validated
	RestoreRequest RestoreRequestClassification `json:"restoreRequest,omitempty"`
}

// GetValidateOperationRequest implements the ValidateOperationRequestClassification interface for type ValidateRestoreOperationRequest.
func (v *ValidateRestoreOperationRequest) GetValidateOperationRequest() *ValidateOperationRequest {
	return &ValidateOperationRequest{
		ObjectType: v.ObjectType,
	}
}

// GetValidateRestoreOperationRequest implements the ValidateRestoreOperationRequestClassification interface for type ValidateRestoreOperationRequest.
func (v *ValidateRestoreOperationRequest) GetValidateRestoreOperationRequest() *ValidateRestoreOperationRequest {
	return v
}

// VaultJob - Vault level Job
type VaultJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string `json:"jobType,omitempty"`

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction `json:"actionsInfo,omitempty"`

	// ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType `json:"backupManagementType,omitempty"`

	// Time elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`

	// The end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`

	// Error details on execution of this job.
	ErrorDetails []*VaultJobErrorInfo `json:"errorDetails,omitempty"`

	// Additional information about the job.
	ExtendedInfo *VaultJobExtendedInfo `json:"extendedInfo,omitempty"`

	// The operation name.
	Operation *string `json:"operation,omitempty"`

	// The start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Job status.
	Status *string `json:"status,omitempty"`
}

// GetJob implements the JobClassification interface for type VaultJob.
func (v *VaultJob) GetJob() *Job {
	return &Job{
		EntityFriendlyName:   v.EntityFriendlyName,
		BackupManagementType: v.BackupManagementType,
		Operation:            v.Operation,
		Status:               v.Status,
		StartTime:            v.StartTime,
		EndTime:              v.EndTime,
		ActivityID:           v.ActivityID,
		JobType:              v.JobType,
	}
}

// VaultJobErrorInfo - Vault Job specific error information
type VaultJobErrorInfo struct {
	// Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`

	// Localized error string.
	ErrorString *string `json:"errorString,omitempty"`

	// List of localized recommendations for above error code.
	Recommendations []*string `json:"recommendations,omitempty"`
}

// VaultJobExtendedInfo - Vault Job for CMK - has CMK specific info.
type VaultJobExtendedInfo struct {
	// Job properties.
	PropertyBag map[string]*string `json:"propertyBag,omitempty"`
}

// VaultStorageConfigOperationResultResponseClassification provides polymorphic access to related types.
// Call the interface's GetVaultStorageConfigOperationResultResponse() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *PrepareDataMoveResponse, *VaultStorageConfigOperationResultResponse
type VaultStorageConfigOperationResultResponseClassification interface {
	// GetVaultStorageConfigOperationResultResponse returns the VaultStorageConfigOperationResultResponse content of the underlying type.
	GetVaultStorageConfigOperationResultResponse() *VaultStorageConfigOperationResultResponse
}

// VaultStorageConfigOperationResultResponse - Operation result response for Vault Storage Config
type VaultStorageConfigOperationResultResponse struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// GetVaultStorageConfigOperationResultResponse implements the VaultStorageConfigOperationResultResponseClassification interface
// for type VaultStorageConfigOperationResultResponse.
func (v *VaultStorageConfigOperationResultResponse) GetVaultStorageConfigOperationResultResponse() *VaultStorageConfigOperationResultResponse {
	return v
}

// WeeklyRetentionFormat - Weekly retention format.
type WeeklyRetentionFormat struct {
	// List of days of the week.
	DaysOfTheWeek []*DayOfWeek `json:"daysOfTheWeek,omitempty"`

	// List of weeks of month.
	WeeksOfTheMonth []*WeekOfMonth `json:"weeksOfTheMonth,omitempty"`
}

// WeeklyRetentionSchedule - Weekly retention schedule.
type WeeklyRetentionSchedule struct {
	// List of days of week for weekly retention policy.
	DaysOfTheWeek []*DayOfWeek `json:"daysOfTheWeek,omitempty"`

	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`

	// Retention times of retention policy.
	RetentionTimes []*time.Time `json:"retentionTimes,omitempty"`
}

type WeeklySchedule struct {
	ScheduleRunDays []*DayOfWeek `json:"scheduleRunDays,omitempty"`

	// List of times of day this schedule has to be run.
	ScheduleRunTimes []*time.Time `json:"scheduleRunTimes,omitempty"`
}

// WorkloadInquiryDetails - Details of an inquired protectable item.
type WorkloadInquiryDetails struct {
	// Inquiry validation such as permissions and other backup validations.
	InquiryValidation *InquiryValidation `json:"inquiryValidation,omitempty"`

	// Contains the protectable item Count inside this Container.
	ItemCount *int64 `json:"itemCount,omitempty"`

	// Type of the Workload such as SQL, Oracle etc.
	Type *string `json:"type,omitempty"`
}

// WorkloadItemClassification provides polymorphic access to related types.
// Call the interface's GetWorkloadItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureVMWorkloadItem, *AzureVMWorkloadSAPAseDatabaseWorkloadItem, *AzureVMWorkloadSAPAseSystemWorkloadItem, *AzureVMWorkloadSAPHanaDatabaseWorkloadItem,
// - *AzureVMWorkloadSAPHanaSystemWorkloadItem, *AzureVMWorkloadSQLDatabaseWorkloadItem, *AzureVMWorkloadSQLInstanceWorkloadItem,
// - *WorkloadItem
type WorkloadItemClassification interface {
	// GetWorkloadItem returns the WorkloadItem content of the underlying type.
	GetWorkloadItem() *WorkloadItem
}

// WorkloadItem - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string `json:"workloadItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type WorkloadItem.
func (w *WorkloadItem) GetWorkloadItem() *WorkloadItem { return w }

// WorkloadItemResource - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadItemResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// WorkloadItemResource properties
	Properties WorkloadItemClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadItemResourceList - List of WorkloadItem resources
type WorkloadItemResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*WorkloadItemResource `json:"value,omitempty"`
}

// WorkloadProtectableItemClassification provides polymorphic access to related types.
// Call the interface's GetWorkloadProtectableItem() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureFileShareProtectableItem, *AzureIaaSClassicComputeVMProtectableItem, *AzureIaaSComputeVMProtectableItem, *AzureVMWorkloadProtectableItem,
// - *AzureVMWorkloadSAPAseSystemProtectableItem, *AzureVMWorkloadSAPHanaDatabaseProtectableItem, *AzureVMWorkloadSAPHanaSystemProtectableItem,
// - *AzureVMWorkloadSQLAvailabilityGroupProtectableItem, *AzureVMWorkloadSQLDatabaseProtectableItem, *AzureVMWorkloadSQLInstanceProtectableItem,
// - *IaaSVMProtectableItem, *WorkloadProtectableItem
type WorkloadProtectableItemClassification interface {
	// GetWorkloadProtectableItem returns the WorkloadProtectableItem content of the underlying type.
	GetWorkloadProtectableItem() *WorkloadProtectableItem
}

// WorkloadProtectableItem - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string `json:"protectableItemType,omitempty"`

	// Type of backup management to backup an item.
	BackupManagementType *string `json:"backupManagementType,omitempty"`

	// Friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// State of the back up item.
	ProtectionState *ProtectionStatus `json:"protectionState,omitempty"`

	// Type of workload for the backup management
	WorkloadType *string `json:"workloadType,omitempty"`
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type WorkloadProtectableItem.
func (w *WorkloadProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem { return w }

// WorkloadProtectableItemResource - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadProtectableItemResource struct {
	// Optional ETag.
	ETag *string `json:"eTag,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// WorkloadProtectableItemResource properties
	Properties WorkloadProtectableItemClassification `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadProtectableItemResourceList - List of WorkloadProtectableItem resources
type WorkloadProtectableItemResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of resources.
	Value []*WorkloadProtectableItemResource `json:"value,omitempty"`
}

// YearlyRetentionSchedule - Yearly retention schedule.
type YearlyRetentionSchedule struct {
	// List of months of year of yearly retention policy.
	MonthsOfYear []*MonthOfYear `json:"monthsOfYear,omitempty"`

	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`

	// Daily retention format for yearly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat `json:"retentionScheduleDaily,omitempty"`

	// Retention schedule format for yearly retention policy.
	RetentionScheduleFormatType *RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`

	// Weekly retention format for yearly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat `json:"retentionScheduleWeekly,omitempty"`

	// Retention times of retention policy.
	RetentionTimes []*time.Time `json:"retentionTimes,omitempty"`
}
