//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/desktopvirtualization/armdesktopvirtualization/v2"
	"net/http"
	"net/url"
	"regexp"
)

// MsixImagesServer is a fake server for instances of the armdesktopvirtualization.MsixImagesClient type.
type MsixImagesServer struct {
	// NewExpandPager is the fake for method MsixImagesClient.NewExpandPager
	// HTTP status codes to indicate success: http.StatusOK
	NewExpandPager func(resourceGroupName string, hostPoolName string, msixImageURI armdesktopvirtualization.MSIXImageURI, options *armdesktopvirtualization.MsixImagesClientExpandOptions) (resp azfake.PagerResponder[armdesktopvirtualization.MsixImagesClientExpandResponse])
}

// NewMsixImagesServerTransport creates a new instance of MsixImagesServerTransport with the provided implementation.
// The returned MsixImagesServerTransport instance is connected to an instance of armdesktopvirtualization.MsixImagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMsixImagesServerTransport(srv *MsixImagesServer) *MsixImagesServerTransport {
	return &MsixImagesServerTransport{
		srv:            srv,
		newExpandPager: newTracker[azfake.PagerResponder[armdesktopvirtualization.MsixImagesClientExpandResponse]](),
	}
}

// MsixImagesServerTransport connects instances of armdesktopvirtualization.MsixImagesClient to instances of MsixImagesServer.
// Don't use this type directly, use NewMsixImagesServerTransport instead.
type MsixImagesServerTransport struct {
	srv            *MsixImagesServer
	newExpandPager *tracker[azfake.PagerResponder[armdesktopvirtualization.MsixImagesClientExpandResponse]]
}

// Do implements the policy.Transporter interface for MsixImagesServerTransport.
func (m *MsixImagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MsixImagesClient.NewExpandPager":
		resp, err = m.dispatchNewExpandPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MsixImagesServerTransport) dispatchNewExpandPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewExpandPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewExpandPager not implemented")}
	}
	newExpandPager := m.newExpandPager.get(req)
	if newExpandPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/hostPools/(?P<hostPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/expandMsixImage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdesktopvirtualization.MSIXImageURI](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		hostPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostPoolName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewExpandPager(resourceGroupNameParam, hostPoolNameParam, body, nil)
		newExpandPager = &resp
		m.newExpandPager.add(req, newExpandPager)
		server.PagerResponderInjectNextLinks(newExpandPager, req, func(page *armdesktopvirtualization.MsixImagesClientExpandResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newExpandPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newExpandPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newExpandPager) {
		m.newExpandPager.remove(req)
	}
	return resp, nil
}
