//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VulnerabilityAssessmentScanResultClient contains the methods for the SQLVulnerabilityAssessmentScanResult group.
// Don't use this type directly, use NewVulnerabilityAssessmentScanResultClient() instead.
type VulnerabilityAssessmentScanResultClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVulnerabilityAssessmentScanResultClient creates a new instance of VulnerabilityAssessmentScanResultClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVulnerabilityAssessmentScanResultClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VulnerabilityAssessmentScanResultClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VulnerabilityAssessmentScanResultClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets a vulnerability assessment scan record of a database.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the SQL Vulnerability Assessment.
//   - scanID - The scan id of the SQL Vulnerability Assessment scan to retrieve result from.
//   - scanResultID - The scan result id of the specific result to retrieve.
//   - options - VulnerabilityAssessmentScanResultClientGetOptions contains the optional parameters for the VulnerabilityAssessmentScanResultClient.Get
//     method.
func (client *VulnerabilityAssessmentScanResultClient) Get(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, scanResultID string, options *VulnerabilityAssessmentScanResultClientGetOptions) (VulnerabilityAssessmentScanResultClientGetResponse, error) {
	var err error
	const operationName = "VulnerabilityAssessmentScanResultClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, scanID, scanResultID, options)
	if err != nil {
		return VulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VulnerabilityAssessmentScanResultClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, scanResultID string, options *VulnerabilityAssessmentScanResultClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if scanResultID == "" {
		return nil, errors.New("parameter scanResultID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanResultId}", url.PathEscape(scanResultID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VulnerabilityAssessmentScanResultClient) getHandleResponse(resp *http.Response) (VulnerabilityAssessmentScanResultClientGetResponse, error) {
	result := VulnerabilityAssessmentScanResultClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanResults); err != nil {
		return VulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	return result, nil
}

// NewListByScanPager - Gets a vulnerability assessment scan record of a database.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the SQL Vulnerability Assessment.
//   - scanID - The scan id of the SQL Vulnerability Assessment scan to retrieve result from.
//   - options - VulnerabilityAssessmentScanResultClientListByScanOptions contains the optional parameters for the VulnerabilityAssessmentScanResultClient.NewListByScanPager
//     method.
func (client *VulnerabilityAssessmentScanResultClient) NewListByScanPager(resourceGroupName string, serverName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, options *VulnerabilityAssessmentScanResultClientListByScanOptions) *runtime.Pager[VulnerabilityAssessmentScanResultClientListByScanResponse] {
	return runtime.NewPager(runtime.PagingHandler[VulnerabilityAssessmentScanResultClientListByScanResponse]{
		More: func(page VulnerabilityAssessmentScanResultClientListByScanResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VulnerabilityAssessmentScanResultClientListByScanResponse) (VulnerabilityAssessmentScanResultClientListByScanResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VulnerabilityAssessmentScanResultClient.NewListByScanPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByScanCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, scanID, options)
			}, nil)
			if err != nil {
				return VulnerabilityAssessmentScanResultClientListByScanResponse{}, err
			}
			return client.listByScanHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByScanCreateRequest creates the ListByScan request.
func (client *VulnerabilityAssessmentScanResultClient) listByScanCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, options *VulnerabilityAssessmentScanResultClientListByScanOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByScanHandleResponse handles the ListByScan response.
func (client *VulnerabilityAssessmentScanResultClient) listByScanHandleResponse(resp *http.Response) (VulnerabilityAssessmentScanResultClientListByScanResponse, error) {
	result := VulnerabilityAssessmentScanResultClientListByScanResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanListResult); err != nil {
		return VulnerabilityAssessmentScanResultClientListByScanResponse{}, err
	}
	return result, nil
}
