//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetSqlPool.json
func ExampleSQLPoolsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLPoolsClient().Get(ctx, "sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-9187", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPool = armsynapse.SQLPool{
	// 	Name: to.Ptr("sqlcrudtest-9187"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-2080/sqlPools/sqlcrudtest-9187"),
	// 	Location: to.Ptr("Japan East"),
	// 	Tags: map[string]*string{
	// 		"tagKey1": to.Ptr("TagValue1"),
	// 	},
	// 	Properties: &armsynapse.SQLPoolResourceProperties{
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T00:56:19.200Z"); return t}()),
	// 		MaxSizeBytes: to.Ptr[int64](268435456000),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		Status: to.Ptr("Online"),
	// 		StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeGRS),
	// 	},
	// 	SKU: &armsynapse.SKU{
	// 		Name: to.Ptr("DW100c"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/UpdateSqlPool.json
func ExampleSQLPoolsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSQLPoolsClient().BeginUpdate(ctx, "ExampleResourceGroup", "ExampleWorkspace", "ExampleSqlPool", armsynapse.SQLPoolPatchInfo{
		Location: to.Ptr("West US 2"),
		Properties: &armsynapse.SQLPoolResourceProperties{
			Collation:          to.Ptr(""),
			MaxSizeBytes:       to.Ptr[int64](0),
			RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t }()),
		},
		SKU: &armsynapse.SKU{
			Name: to.Ptr(""),
			Tier: to.Ptr(""),
		},
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPool = armsynapse.SQLPool{
	// 	Name: to.Ptr("ExampleSqlPool"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
	// 	ID: to.Ptr("/subscriptions/01234567-89ab-4def-0123-456789abcdef/resourceGroups/ExampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspaces/sqlPools/ExampleSqlPool"),
	// 	Location: to.Ptr("West US 2"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armsynapse.SQLPoolResourceProperties{
	// 		Collation: to.Ptr(""),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t}()),
	// 		MaxSizeBytes: to.Ptr[int64](0),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RecoverableDatabaseID: to.Ptr(""),
	// 		RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t}()),
	// 		Status: to.Ptr("Paused"),
	// 		StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeGRS),
	// 	},
	// 	SKU: &armsynapse.SKU{
	// 		Name: to.Ptr(""),
	// 		Tier: to.Ptr(""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CreateSqlPool.json
func ExampleSQLPoolsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSQLPoolsClient().BeginCreate(ctx, "ExampleResourceGroup", "ExampleWorkspace", "ExampleSqlPool", armsynapse.SQLPool{
		Location: to.Ptr("Southeast Asia"),
		Tags:     map[string]*string{},
		Properties: &armsynapse.SQLPoolResourceProperties{
			Collation:             to.Ptr(""),
			CreateMode:            to.Ptr(armsynapse.CreateMode("")),
			MaxSizeBytes:          to.Ptr[int64](0),
			RecoverableDatabaseID: to.Ptr(""),
			SourceDatabaseID:      to.Ptr(""),
			StorageAccountType:    to.Ptr(armsynapse.StorageAccountTypeLRS),
		},
		SKU: &armsynapse.SKU{
			Name: to.Ptr(""),
			Tier: to.Ptr(""),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPool = armsynapse.SQLPool{
	// 	Name: to.Ptr("ExampleSqlPool"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
	// 	ID: to.Ptr("/subscriptions/01234567-89ab-4def-0123-456789abcdef/resourceGroups/ExampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspaces/sqlPools/ExampleSqlPool"),
	// 	Location: to.Ptr("Southeast Asia"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armsynapse.SQLPoolResourceProperties{
	// 		Collation: to.Ptr(""),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t}()),
	// 		MaxSizeBytes: to.Ptr[int64](0),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RecoverableDatabaseID: to.Ptr(""),
	// 		RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1970-01-01T00:00:00.000Z"); return t}()),
	// 		Status: to.Ptr("Paused"),
	// 		StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeLRS),
	// 	},
	// 	SKU: &armsynapse.SKU{
	// 		Name: to.Ptr(""),
	// 		Tier: to.Ptr(""),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/DeleteSqlPool.json
func ExampleSQLPoolsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSQLPoolsClient().BeginDelete(ctx, "ExampleResourceGroup", "ExampleWorkspace", "ExampleSqlPool", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPool = armsynapse.SQLPool{
	// 	Name: to.Ptr("ExampleSqlPool"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
	// 	ID: to.Ptr("/subscriptions/01234567-89ab-4def-0123-456789abcdef/resourceGroups/ExampleResourceGroup/providers/Microsoft.Synapse/workspaces/ExampleWorkspace/sqlPools/ExampleSqlPool"),
	// 	Location: to.Ptr("West US 2"),
	// 	Properties: &armsynapse.SQLPoolResourceProperties{
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Status: to.Ptr("Paused"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolsInWorkspace.json
func ExampleSQLPoolsClient_NewListByWorkspacePager_listSqlAnalyticsPoolsInAWorkspace() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSQLPoolsClient().NewListByWorkspacePager("sqlcrudtest-6845", "sqlcrudtest-7177", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SQLPoolInfoListResult = armsynapse.SQLPoolInfoListResult{
		// 	Value: []*armsynapse.SQLPool{
		// 		{
		// 			Name: to.Ptr("master"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6845/providers/Microsoft.Synapse/workspaces/sqlcrudtest-7177/sqlPools/master"),
		// 			Location: to.Ptr("Japan East"),
		// 			Properties: &armsynapse.SQLPoolResourceProperties{
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T00:59:33.483Z"); return t}()),
		// 				MaxSizeBytes: to.Ptr[int64](32212254720),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				Status: to.Ptr("Online"),
		// 				StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeGRS),
		// 			},
		// 			SKU: &armsynapse.SKU{
		// 				Name: to.Ptr("GP_Gen5_2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sqlcrudtest-1142"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6845/providers/Microsoft.Synapse/workspaces/sqlcrudtest-7177/sqlPools/sqlcrudtest-1142"),
		// 			Location: to.Ptr("Japan East"),
		// 			Properties: &armsynapse.SQLPoolResourceProperties{
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T01:03:34.040Z"); return t}()),
		// 				MaxSizeBytes: to.Ptr[int64](268435456000),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				Status: to.Ptr("Online"),
		// 				StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeGRS),
		// 			},
		// 			SKU: &armsynapse.SKU{
		// 				Name: to.Ptr("DW100c"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sqlcrudtest-2788"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6845/providers/Microsoft.Synapse/workspaces/sqlcrudtest-7177/sqlPools/sqlcrudtest-2788"),
		// 			Location: to.Ptr("Japan East"),
		// 			Properties: &armsynapse.SQLPoolResourceProperties{
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T01:00:21.067Z"); return t}()),
		// 				MaxSizeBytes: to.Ptr[int64](268435456000),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				Status: to.Ptr("Online"),
		// 				StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeGRS),
		// 			},
		// 			SKU: &armsynapse.SKU{
		// 				Name: to.Ptr("DW100c"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sqlcrudtest-6877"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6845/providers/Microsoft.Synapse/workspaces/sqlcrudtest-7177/sqlPools/sqlcrudtest-6877"),
		// 			Location: to.Ptr("Southeast Asia"),
		// 			Properties: &armsynapse.SQLPoolResourceProperties{
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T01:02:28.853Z"); return t}()),
		// 				MaxSizeBytes: to.Ptr[int64](268435456000),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				Status: to.Ptr("Online"),
		// 				StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeLRS),
		// 			},
		// 			SKU: &armsynapse.SKU{
		// 				Name: to.Ptr("DW100c"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sqlcrudtest-9888"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6845/providers/Microsoft.Synapse/workspaces/sqlcrudtest-7177/sqlPools/sqlcrudtest-9888"),
		// 			Location: to.Ptr("Japan East"),
		// 			Properties: &armsynapse.SQLPoolResourceProperties{
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T01:01:25.347Z"); return t}()),
		// 				MaxSizeBytes: to.Ptr[int64](268435456000),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				Status: to.Ptr("Online"),
		// 				StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeGRS),
		// 			},
		// 			SKU: &armsynapse.SKU{
		// 				Name: to.Ptr("DW100c"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolsInWorkspaceWithFilter.json
func ExampleSQLPoolsClient_NewListByWorkspacePager_listSqlAnalyticsPoolsInAWorkspaceWithFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSQLPoolsClient().NewListByWorkspacePager("sqlcrudtest-6845", "sqlcrudtest-7177", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SQLPoolInfoListResult = armsynapse.SQLPoolInfoListResult{
		// 	Value: []*armsynapse.SQLPool{
		// 		{
		// 			Name: to.Ptr("master"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6845/providers/Microsoft.Synapse/workspaces/sqlcrudtest-7177/sqlPools/master"),
		// 			Location: to.Ptr("Japan East"),
		// 			Properties: &armsynapse.SQLPoolResourceProperties{
		// 				Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
		// 				CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T00:59:33.483Z"); return t}()),
		// 				MaxSizeBytes: to.Ptr[int64](32212254720),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				Status: to.Ptr("Online"),
		// 				StorageAccountType: to.Ptr(armsynapse.StorageAccountTypeGRS),
		// 			},
		// 			SKU: &armsynapse.SKU{
		// 				Name: to.Ptr("GP_Gen5_2"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/PauseSqlPool.json
func ExampleSQLPoolsClient_BeginPause() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSQLPoolsClient().BeginPause(ctx, "Default-SQL-SouthEastAsia", "testsvr", "testdwdb", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPool = armsynapse.SQLPool{
	// 	Name: to.Ptr("testdwdb"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Synapse/workspaces/testsvr/sqlPools/testdwdb"),
	// 	Location: to.Ptr("Japan East"),
	// 	Tags: map[string]*string{
	// 		"tagKey1": to.Ptr("TagValue1"),
	// 	},
	// 	Properties: &armsynapse.SQLPoolResourceProperties{
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T00:56:19.200Z"); return t}()),
	// 		MaxSizeBytes: to.Ptr[int64](268435456000),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		Status: to.Ptr("Online"),
	// 	},
	// 	SKU: &armsynapse.SKU{
	// 		Name: to.Ptr("DW100c"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ResumeSqlPool.json
func ExampleSQLPoolsClient_BeginResume() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSQLPoolsClient().BeginResume(ctx, "sqlcrudtest-6852", "sqlcrudtest-2080", "sqlcrudtest-9187", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPool = armsynapse.SQLPool{
	// 	Name: to.Ptr("sqlcrudtest-9187"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-6852/providers/Microsoft.Synapse/workspaces/sqlcrudtest-2080/sqlPools/sqlcrudtest-9187"),
	// 	Location: to.Ptr("Japan East"),
	// 	Tags: map[string]*string{
	// 		"tagKey1": to.Ptr("TagValue1"),
	// 	},
	// 	Properties: &armsynapse.SQLPoolResourceProperties{
	// 		Collation: to.Ptr("SQL_Latin1_General_CP1_CI_AS"),
	// 		CreationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-10T00:56:19.200Z"); return t}()),
	// 		MaxSizeBytes: to.Ptr[int64](268435456000),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		RestorePointInTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		Status: to.Ptr("Online"),
	// 	},
	// 	SKU: &armsynapse.SKU{
	// 		Name: to.Ptr("DW100c"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/RenameSqlPool.json
func ExampleSQLPoolsClient_Rename() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSQLPoolsClient().Rename(ctx, "Default-SQL-SouthEastAsia", "testsvr", "testdb", armsynapse.ResourceMoveDefinition{
		ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Synapse/workspaces/testsvr/sqlPools/newtestdb"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
