/***********************************************************************************

    Copyright (C) 2007-2019 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_CHART_SURFACE_HEADER
#define LIFEOGRAPH_CHART_SURFACE_HEADER


#include <cairomm/surface.h>

#include "../helpers.hpp"
#include "../entry.hpp"
#include "chart.hpp"


namespace LIFEO
{

using namespace HELPERS;


class ChartSurface : public Chart
{
    public:
                                    ChartSurface( ChartElem*, int );
                                    ~ChartSurface() {}

        Glib::RefPtr< Gdk::Pixbuf > get_pixbuf()
        { return Gdk::Pixbuf::create( m_surface, 0, 0, m_width, m_height ); }

    protected:
        static constexpr float      WH_RATIO{ 0.75f };

        Cairo::RefPtr< Cairo::ImageSurface >
                                    m_surface;
};

} // end of namespace LIFEO

#endif
