_Please ensure that [pre-requisites](prerequisites-for-building.md) are installed for a successful build of the repo._

_Note_:

* Instructions below assume `c:\corert` is the repo root.


# Building ILCompiler in Visual Studio 2017 #

First, build your repo by issuing the following command at repo root, by default this builds Debug x64:

```
build.cmd
```
Then when building ILCompiler.sln in Visual Studio, remember to select the appropriate configuration that you built. By default, `build.cmd` builds Debug x64 and so `Debug` and `x64` must be selected in the solution build configuration drop downs.

---

If you changed `c:\corert\src\ILCompiler\repro\repro.csproj`

```
build.cmd clean
```

_Note: The size of NuGet packages is approximately 2.75 GB, so download might take a few moments based on the speed of your internet connection. The build artifacts require additional ~1 GB, thus make sure you have at least 4 GB of free space._

## Using RyuJIT ##

1. Open c:\corert\src\ILCompiler\ILCompiler.sln in VS

  - Set "ILCompiler" project in solution explorer as your startup project

  - Set startup command line to:
`@c:\corert\bin\obj\Windows_NT.x64.Debug\ryujit.rsp`

  - Build & run using **F5**
    - This will run the compiler. The output is `c:\corert\bin\obj\Windows_NT.x64.Debug\repro\native\repro.obj` file.

  - The repro project has a dummy program that you can modify for ad-hoc testing

  - To suppress spew from NuGet during the build, go to NuGet Package Manager in Options, and uncheck `Allow NuGet to download missing packages`.

2. Open `c:\corert\src\ILCompiler\reproNative\reproNative.vcxproj`

  - Set breakpoint at ```__managed__Main``` in main.cpp
  - Build & run using **F5**
    - Once you hit the breakpoint, go to disassembly and step into - you are looking at the code generated by RyuJIT


## Using CPP Code Generator ##

1. Open `c:\corert\src\ILCompiler\ILCompiler.sln` in VS

  - Set "ILCompiler" project in solution explorer as your startup project

  - Set startup command line to:
`@c:\corert\bin\obj\Windows_NT.x64.Debug\cpp.rsp`

    - `--codegenopt:nolinenumbers` command line option can be used to suppress generation of line number mappings in C++ files - useful for debugging

  - Build & run using **F5**
    - This will run the compiler. The output is `c:\corert\bin\obj\Windows_NT.x64.Debug\repro\native\repro.cpp` file.

  - The repro project has a dummy program that you can modify for ad-hoc testing

2. Open `c:\corert\src\ILCompiler\reproNative\reproNativeCpp.vcxproj`

  - Set breakpoint at repro::Program::Main in main.cpp
  - Build, run & step through as with any other C++ program

## Writing your repro code in IL ##

If you want to write your repro code using IL (instead of C#), you can search/replace `"repro\repro.csproj"` to `"repro\repro.ilproj"` in ILCompiler.sln which switches to repro.ilproj instead of repro.csproj. Just write your IL code in `repro.il` and build/debug as usual. All the instructions above still would work as expected. Just make sure don't check-in that change.
