# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._serialization import Deserializer, Serializer
from ...operations._replication_protection_clusters_operations import (
    build_apply_recovery_point_request,
    build_create_request,
    build_failover_commit_request,
    build_get_operation_results_request,
    build_get_request,
    build_list_by_replication_protection_containers_request,
    build_list_request,
    build_purge_request,
    build_repair_replication_request,
    build_test_failover_cleanup_request,
    build_test_failover_request,
    build_unplanned_failover_request,
)
from .._configuration import SiteRecoveryManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ReplicationProtectionClustersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.recoveryservicessiterecovery.aio.SiteRecoveryManagementClient`'s
        :attr:`replication_protection_clusters` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: SiteRecoveryManagementClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_replication_protection_containers(  # pylint: disable=name-too-long
        self, resource_name: str, fabric_name: str, protection_container_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ReplicationProtectionCluster"]:
        """Gets the list of Replication protection clusters in fabric, container.

        Gets the list of ASR replication protected clusters in the protection container.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :return: An iterator like instance of either ReplicationProtectionCluster or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectionClusterCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_replication_protection_containers_request(
                    resource_name=resource_name,
                    fabric_name=fabric_name,
                    protection_container_name=protection_container_name,
                    resource_group_name=self._config.resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionClusterCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        **kwargs: Any
    ) -> _models.ReplicationProtectionCluster:
        """Gets the details of a Replication protection cluster.

        Gets the details of an ASR replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :return: ReplicationProtectionCluster or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        replication_protection_cluster: Union[_models.ReplicationProtectionCluster, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(replication_protection_cluster, (IOBase, bytes)):
            _content = replication_protection_cluster
        else:
            _json = self._serialize.body(replication_protection_cluster, "ReplicationProtectionCluster")

        _request = build_create_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        replication_protection_cluster: _models.ReplicationProtectionCluster,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Create Replication protection Cluster.

        The operation to create an ASR replication protection cluster item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param replication_protection_cluster: Create replication protection cluster Input. Required.
        :type replication_protection_cluster:
         ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        replication_protection_cluster: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Create Replication protection Cluster.

        The operation to create an ASR replication protection cluster item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param replication_protection_cluster: Create replication protection cluster Input. Required.
        :type replication_protection_cluster: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        replication_protection_cluster: Union[_models.ReplicationProtectionCluster, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Create Replication protection Cluster.

        The operation to create an ASR replication protection cluster item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param replication_protection_cluster: Create replication protection cluster Input. Is either a
         ReplicationProtectionCluster type or a IO[bytes] type. Required.
        :type replication_protection_cluster:
         ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                replication_protection_cluster=replication_protection_cluster,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectionCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectionCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _purge_initial(
        self, fabric_name: str, protection_container_name: str, replication_protection_cluster_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_purge_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_purge(
        self, fabric_name: str, protection_container_name: str, replication_protection_cluster_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Purge the replication protection cluster.

        The operation to purge the replication protection cluster. This operation will force delete the
        replication protection cluster. Use the remove operation on replication protection cluster to
        perform a clean disable replication protection cluster.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._purge_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _apply_recovery_point_initial(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        apply_cluster_recovery_point_input: Union[_models.ApplyClusterRecoveryPointInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(apply_cluster_recovery_point_input, (IOBase, bytes)):
            _content = apply_cluster_recovery_point_input
        else:
            _json = self._serialize.body(apply_cluster_recovery_point_input, "ApplyClusterRecoveryPointInput")

        _request = build_apply_recovery_point_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_apply_recovery_point(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        apply_cluster_recovery_point_input: _models.ApplyClusterRecoveryPointInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute the change recovery point operation for cluster.

        Operation to apply a new cluster recovery point on the Protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param apply_cluster_recovery_point_input: Apply recovery point input. Required.
        :type apply_cluster_recovery_point_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyClusterRecoveryPointInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_apply_recovery_point(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        apply_cluster_recovery_point_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute the change recovery point operation for cluster.

        Operation to apply a new cluster recovery point on the Protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param apply_cluster_recovery_point_input: Apply recovery point input. Required.
        :type apply_cluster_recovery_point_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_apply_recovery_point(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        apply_cluster_recovery_point_input: Union[_models.ApplyClusterRecoveryPointInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute the change recovery point operation for cluster.

        Operation to apply a new cluster recovery point on the Protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param apply_cluster_recovery_point_input: Apply recovery point input. Is either a
         ApplyClusterRecoveryPointInput type or a IO[bytes] type. Required.
        :type apply_cluster_recovery_point_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyClusterRecoveryPointInput or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._apply_recovery_point_initial(
                resource_name=resource_name,
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                apply_cluster_recovery_point_input=apply_cluster_recovery_point_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectionCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectionCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _failover_commit_initial(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_failover_commit_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_failover_commit(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute commit failover for cluster.

        Operation to initiate commit failover of the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._failover_commit_initial(
                resource_name=resource_name,
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectionCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectionCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_operation_results(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        job_id: str,
        **kwargs: Any
    ) -> _models.ReplicationProtectionCluster:
        """Tracks the Replication protection cluster async operation.

        Track the results of an asynchronous operation on the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param job_id: job id to track. Required.
        :type job_id: str
        :return: ReplicationProtectionCluster or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)

        _request = build_get_operation_results_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            job_id=job_id,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _repair_replication_initial(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_repair_replication_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_repair_replication(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Resynchronize or repair replication of protection cluster.

        The operation to repair replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._repair_replication_initial(
                resource_name=resource_name,
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectionCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectionCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _test_failover_initial(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: Union[_models.ClusterTestFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(failover_input, (IOBase, bytes)):
            _content = failover_input
        else:
            _json = self._serialize.body(failover_input, "ClusterTestFailoverInput")

        _request = build_test_failover_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_test_failover(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: _models.ClusterTestFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute test failover for cluster.

        Operation to initiate a failover of the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param failover_input: Cluster test failover input body. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.ClusterTestFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_test_failover(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute test failover for cluster.

        Operation to initiate a failover of the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param failover_input: Cluster test failover input body. Required.
        :type failover_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_test_failover(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: Union[_models.ClusterTestFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute test failover for cluster.

        Operation to initiate a failover of the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param failover_input: Cluster test failover input body. Is either a ClusterTestFailoverInput
         type or a IO[bytes] type. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.ClusterTestFailoverInput
         or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._test_failover_initial(
                resource_name=resource_name,
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                failover_input=failover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectionCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectionCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _test_failover_cleanup_initial(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        cleanup_input: Union[_models.ClusterTestFailoverCleanupInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(cleanup_input, (IOBase, bytes)):
            _content = cleanup_input
        else:
            _json = self._serialize.body(cleanup_input, "ClusterTestFailoverCleanupInput")

        _request = build_test_failover_cleanup_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_test_failover_cleanup(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        cleanup_input: _models.ClusterTestFailoverCleanupInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute test failover cleanup for cluster.

        Operation to clean up the test failover of a replication protected cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param cleanup_input: Test failover cleanup input. Required.
        :type cleanup_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ClusterTestFailoverCleanupInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_test_failover_cleanup(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        cleanup_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute test failover cleanup for cluster.

        Operation to clean up the test failover of a replication protected cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param cleanup_input: Test failover cleanup input. Required.
        :type cleanup_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_test_failover_cleanup(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        cleanup_input: Union[_models.ClusterTestFailoverCleanupInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute test failover cleanup for cluster.

        Operation to clean up the test failover of a replication protected cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param cleanup_input: Test failover cleanup input. Is either a ClusterTestFailoverCleanupInput
         type or a IO[bytes] type. Required.
        :type cleanup_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ClusterTestFailoverCleanupInput or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._test_failover_cleanup_initial(
                resource_name=resource_name,
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                cleanup_input=cleanup_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectionCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectionCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _unplanned_failover_initial(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: Union[_models.ClusterUnplannedFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(failover_input, (IOBase, bytes)):
            _content = failover_input
        else:
            _json = self._serialize.body(failover_input, "ClusterUnplannedFailoverInput")

        _request = build_unplanned_failover_request(
            resource_name=resource_name,
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replication_protection_cluster_name=replication_protection_cluster_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_unplanned_failover(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: _models.ClusterUnplannedFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute unplanned cluster failover.

        Operation to initiate a failover of the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param failover_input: Failover input. Required.
        :type failover_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ClusterUnplannedFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_unplanned_failover(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute unplanned cluster failover.

        Operation to initiate a failover of the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param failover_input: Failover input. Required.
        :type failover_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_unplanned_failover(
        self,
        resource_name: str,
        fabric_name: str,
        protection_container_name: str,
        replication_protection_cluster_name: str,
        failover_input: Union[_models.ClusterUnplannedFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectionCluster]:
        """Execute unplanned cluster failover.

        Operation to initiate a failover of the replication protection cluster.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replication_protection_cluster_name: Replication protection cluster name. Required.
        :type replication_protection_cluster_name: str
        :param failover_input: Failover input. Is either a ClusterUnplannedFailoverInput type or a
         IO[bytes] type. Required.
        :type failover_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ClusterUnplannedFailoverInput or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectionCluster or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectionCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._unplanned_failover_initial(
                resource_name=resource_name,
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replication_protection_cluster_name=replication_protection_cluster_name,
                failover_input=failover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectionCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectionCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_name: str, skip_token: Optional[str] = None, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.ReplicationProtectionCluster"]:
        """Gets the list of Replication protection clusters in vault.

        Gets the list of ASR replication protected clusters in the vault.

        :param resource_name: The name of the recovery services vault. Required.
        :type resource_name: str
        :param skip_token: The pagination token. Possible values: "FabricId" or "FabricId_CloudId" or
         null. Default value is None.
        :type skip_token: str
        :param filter: OData filter options. Default value is None.
        :type filter: str
        :return: An iterator like instance of either ReplicationProtectionCluster or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectionClusterCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    resource_name=resource_name,
                    resource_group_name=self._config.resource_group_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    filter=filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectionClusterCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
