% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertTo.R
\name{convertTo}
\alias{convertTo}
\title{Convert to other classes}
\usage{
convertTo(
  x,
  type = c("edgeR", "DESeq2", "monocle"),
  ...,
  assay.type = 1,
  subset.row = NULL
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object.}

\item{type}{A string specifying the analysis for which the object should be prepared.}

\item{...}{Other arguments to be passed to pipeline-specific constructors.}

\item{assay.type}{A string specifying which assay of \code{x} should be put in the returned object.}

\item{subset.row}{See \code{?"\link{scran-gene-selection}"}.}
}
\value{
For \code{type="edgeR"}, a DGEList object is returned containing the count matrix.
Size factors are converted to normalization factors.
Gene-specific \code{rowData} is stored in the \code{genes} element, and cell-specific \code{colData} is stored in the \code{samples} element.

For \code{type="DESeq2"}, a DESeqDataSet object is returned containing the count matrix and size factors.
Additional gene- and cell-specific data is stored in the \code{mcols} and \code{colData} respectively.

For \code{type="monocle"}, a CellDataSet object is returned containing the count matrix and size factors.
Additional gene- and cell-specific data is stored in the \code{featureData} and \code{phenoData} respectively.
}
\description{
Convert a \linkS4class{SingleCellExperiment} object into other classes for entry into other analysis pipelines.
}
\details{
This function converts an SingleCellExperiment object into various other classes in preparation for entry into other analysis pipelines, as specified by \code{type}.
}
\examples{
library(scuttle)
sce <- mockSCE()

# Adding some additional embellishments.
sizeFactors(sce) <- 2^rnorm(ncol(sce)) 
rowData(sce)$SYMBOL <- paste0("X", seq_len(nrow(sce)))
sce$other <- sample(LETTERS, ncol(sce), replace=TRUE)

# Converting to various objects.
convertTo(sce, type="edgeR")
convertTo(sce, type="DESeq2")
convertTo(sce, type="monocle")

}
\seealso{
\code{\link[edgeR]{DGEList}},
\code{\link[DESeq2:DESeqDataSet]{DESeqDataSetFromMatrix}},
\code{\link[monocle]{newCellDataSet}}, for specific class constructors.
}
\author{
Aaron Lun
}
