% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustbase-lmrob-tidiers.R
\name{glance.lmrob}
\alias{glance.lmrob}
\title{Glance at a(n) lmrob object}
\usage{
\method{glance}{lmrob}(x, ...)
}
\arguments{
\item{x}{A \code{lmrob} object returned from \code{\link[robustbase:lmrob]{robustbase::lmrob()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\details{
For tidiers for robust models from the \pkg{MASS} package see
\code{\link[=tidy.rlm]{tidy.rlm()}}.
}
\examples{

if (requireNamespace("robustbase", quietly = TRUE)) {

# load libraries for models and data
library(robustbase)

data(coleman)
set.seed(0)

m <- lmrob(Y ~ ., data = coleman)
tidy(m)
augment(m)
glance(m)

data(carrots)

Rfit <- glmrob(cbind(success, total - success) ~ logdose + block,
  family = binomial, data = carrots, method = "Mqle",
  control = glmrobMqle.control(tcc = 1.2)
)

tidy(Rfit)
augment(Rfit)

}
}
\seealso{
\code{\link[robustbase:lmrob]{robustbase::lmrob()}}

Other robustbase tidiers: 
\code{\link{augment.glmrob}()},
\code{\link{augment.lmrob}()},
\code{\link{tidy.glmrob}()},
\code{\link{tidy.lmrob}()}
}
\concept{robustbase tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{df.residual}{Residual degrees of freedom.}
  \item{r.squared}{R squared statistic, or the percent of variation explained by the model. Also known as the coefficient of determination.}
  \item{sigma}{Estimated standard error of the residuals.}

}
