% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_chroma.R
\docType{data}
\name{max_chroma}
\alias{max_chroma}
\alias{max_chroma_table}
\title{Compute Maximum Chroma for Given Hue and Luminance in HCL}
\usage{
max_chroma(h, l, floor = FALSE)

max_chroma_table
}
\arguments{
\item{h}{hue value in the HCL color description, has to be in [0, 360].}

\item{l}{luminance value in the HCL color description, has to be in [0, 100].}

\item{floor}{logical. Should the chroma value be rounded down to the next
lower integer?}
}
\value{
A numeric vector with the maximum chroma coordinates.
}
\description{
Compute approximately the maximum chroma possible for a given hue and
luminance combination in the HCL color space.
}
\details{
As the possible combinations of chroma and luminance depend on hue, it is
not obvious which maximum chroma can be used for a given combination of hue
and luminance prior to calling \code{\link{polarLUV}}. To avoid having to
\code{fixup} the color upon conversion to RGB \code{\link{hex}} codes, the
\code{max_chroma} function computes (approximately) the maximum chroma
possible. The computations are based on interpolations of pre-computed
maxima in \code{max_chroma_table}, containing the maximum chroma for a given
hue-luminance combination (both in integers). Hence, the result may sometimes
still be very slightly larger than the actual maximum which can be avoided
by taking the \code{floor} of the approximate value.
}
\examples{
max_chroma(h = 0:36 * 10, l = 50)
max_chroma(h = 120, l = 0:10 * 10)
}
\seealso{
\code{\link[colorspace]{polarLUV}}, \code{\link[colorspace]{hex}}
}
\keyword{color}
\keyword{datasets}
