% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_datagrid.R
\name{get_datagrid.emmGrid}
\alias{get_datagrid.emmGrid}
\title{Extract a reference grid from objects created by \code{{emmeans}} and \code{{marginaleffects}}}
\usage{
\method{get_datagrid}{emmGrid}(x, ...)
}
\arguments{
\item{x}{An object created by a function such as \code{\link[emmeans:emmeans]{emmeans::emmeans()}},
\code{\link[marginaleffects:slopes]{marginaleffects::slopes()}}, etc.}

\item{...}{Currently not used}
}
\value{
A \code{data.frame} with key columns that identify the rows in \code{x}.
}
\description{
Extract a reference grid from objects created by \code{{emmeans}} and \code{{marginaleffects}}
}
\details{
Note that for \code{{emmeans}} inputs the results is a proper grid (all
combinations of values are represented), except when a nesting structure is
detected. Additionally, when the input is an \code{emm_list} object, the function
will \code{rbind()} the data-grids of all the elements in the input.

For \code{{marginaleffects}} inputs, the output may very well be a non-grid
result. See examples.
}
\examples{
data("mtcars")
mtcars$cyl <- factor(mtcars$cyl)

mod <- glm(am ~ cyl + hp + wt,
  family = binomial("logit"),
  data = mtcars
)

\dontshow{if (insight::check_if_installed("emmeans", quietly = TRUE)) withAutoprint(\{ # examplesIf}
em1 <- emmeans::emmeans(mod, ~ cyl + hp, at = list(hp = c(100, 150)))
get_datagrid(em1)

contr1 <- emmeans::contrast(em1, method = "consec", by = "hp")
get_datagrid(contr1)

eml1 <- emmeans::emmeans(mod, pairwise ~ cyl | hp, at = list(hp = c(100, 150)))
get_datagrid(eml1) # not a "true" grid
\dontshow{\}) # examplesIf}
\dontshow{if (insight::check_if_installed("marginaleffects", quietly = TRUE, minimum_version = "0.29.0")) withAutoprint(\{ # examplesIf}
mfx1 <- marginaleffects::slopes(mod, variables = "hp")
get_datagrid(mfx1) # not a "true" grid

mfx2 <- marginaleffects::slopes(mod, variables = c("hp", "wt"), by = "am")
get_datagrid(mfx2)

contr2 <- marginaleffects::avg_comparisons(mod)
get_datagrid(contr2) # not a "true" grid
\dontshow{\}) # examplesIf}
}
