/*
 * Copyright 2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.spockframework.runtime.extension.builtin;

import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IInterceptable;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

import spock.util.mop.Use;

import java.util.Arrays;

public class UseExtension extends AbstractAnnotationDrivenExtension<Use> {
  public void visitSpecAnnotation(Use annotation, SpecInfo spec) {
    addInterceptor(annotation, spec.getBottomSpec());
  }

  public void visitFeatureAnnotation(Use annotation, FeatureInfo feature) {
    addInterceptor(annotation, feature.getFeatureMethod());
  }

  @Override
  public void visitFixtureAnnotation(Use annotation, MethodInfo fixtureMethod) {
    addInterceptor(annotation, fixtureMethod);
  }

  private void addInterceptor(Use annotation, IInterceptable interceptable) {
    interceptable.addInterceptor(new UseInterceptor(Arrays.asList(annotation.value())));
  }
}