## TFSA-2022-143: OOB read in `Gather_nd` op in TF Lite Micro

### CVE Number
CVE-2022-35938

### Impact
The [`GatherNd`](https://github.com/tensorflow/tflite-micro/blob/1bc98621180a350eb4e8d3318ea8e228c7559b37/tensorflow/lite/micro/kernels/gather_nd.cc#L143-L154) function takes arguments that determine the sizes of inputs and outputs. If the inputs given are greater than or equal to the sizes of the outputs, an out-of-bounds memory read or a crash is triggered.

### Patches
We have patched the issue in GitHub commit [4142e47e9e31db481781b955ed3ff807a781b494](https://github.com/tensorflow/tflite-micro/commit/4142e47e9e31db481781b955ed3ff807a781b494).


The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Hui Peng from Baidu Security.
