/*
 * Ensuring smooth padding to limit edge effects from padding and peridiosing.
 * This file is part of ufo-serge filter set.
 * Copyright (C) 2025 Serge Cohen
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Serge Cohen <serge.cohen@cnrs.fr>
 */

#ifndef __UFO_SMOOTH_PAD_TASK_H
#define __UFO_SMOOTH_PAD_TASK_H

#include <ufo/ufo.h>

G_BEGIN_DECLS

#define UFO_TYPE_SMOOTH_PAD_TASK             (ufo_smooth_pad_task_get_type())
#define UFO_SMOOTH_PAD_TASK(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj), UFO_TYPE_SMOOTH_PAD_TASK, UfoSmoothPadTask))
#define UFO_IS_SMOOTH_PAD_TASK(obj)          (G_TYPE_CHECK_INSTANCE_TYPE((obj), UFO_TYPE_SMOOTH_PAD_TASK))
#define UFO_SMOOTH_PAD_TASK_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST((klass), UFO_TYPE_SMOOTH_PAD_TASK, UfoSmoothPadTaskClass))
#define UFO_IS_SMOOTH_PAD_TASK_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE((klass), UFO_TYPE_SMOOTH_PAD_TASK))
#define UFO_SMOOTH_PAD_TASK_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS((obj), UFO_TYPE_SMOOTH_PAD_TASK, UfoSmoothPadTaskClass))

typedef struct _UfoSmoothPadTask           UfoSmoothPadTask;
typedef struct _UfoSmoothPadTaskClass      UfoSmoothPadTaskClass;
typedef struct _UfoSmoothPadTaskPrivate    UfoSmoothPadTaskPrivate;

struct _UfoSmoothPadTask {
    UfoTaskNode parent_instance;

    UfoSmoothPadTaskPrivate *priv;
};

struct _UfoSmoothPadTaskClass {
    UfoTaskNodeClass parent_class;
};

UfoNode  *ufo_smooth_pad_task_new       (void);
GType     ufo_smooth_pad_task_get_type  (void);

G_END_DECLS

#endif
