# Сбои при навигации

> Добавлено в версии 3.4.0

При использовании `router-link` Vue Router вызывает `router.push` для запуска навигации. В большинстве случаев ожидаемое поведение ссылок заключается в переходе на новую страницу, но есть несколько ситуаций при которых пользователь остаётся на той же странице:

- Пользователь уже находится на странице, на которую пытается перейти
- [Навигационный хук](./navigation-guards.md) прерывает навигацию вызовом `next(false)`
- [Навигационный хук](./navigation-guards.md) выбрасывает ошибку или вызывает `next(new Error())`

При использовании компонента `router-link` **ни один из этих случаев не будет логироваться как ошибка**. Однако при использовании `router.push` или `router.replace` можно столкнуться с сообщением _"Uncaught (in promise) Error"_ после которого в консоли последует более конкретное сообщение. Давайте разберемся как отличать _сбои навигации_.

::: tip История вопроса
В версии 3.2.0, _навигационные сбои_ доступны через два необязательных коллбэка `router.push`: `onComplete` и `onAbort`. Начиная с версии 3.1.0, `router.push` и `router.replace` возвращают _Promise_ если не указаны коллбэки `onComplete`/`onAbort`. Этот _Promise_ разрешается вместо вызова `onComplete` и отклоняется вместо вызова `onAbort`.
 :::

## Обнаружение сбоев навигации

_Сбой навигации_ будет экземпляром `Error` с парой дополнительных свойств. Проверить произошла ли ошибка в маршрутизаторе можно с помощью функции `isNavigationFailure`:

```js
import VueRouter from 'vue-router'
const { isNavigationFailure, NavigationFailureType } = VueRouter

// попытка перехода к странице администрирования
router
  .push('/admin')
  .catch(failure => {
    if (isNavigationFailure(failure, NavigationFailureType.redirected)) {
      // отображение уведомления пользователю
      showToast('Необходимо авторизоваться для доступа к панели администрирования')
    }
  })
```

::: tip СОВЕТ
Если опустить второй параметр в `isNavigationFailure(failure)`, то будет проверяться только, является ли ошибка _сбоем навигации_.
:::

## Тип `NavigationFailureType`

Тип `NavigationFailureType` поможет разработчикам определять тип _навигационного сбоя_. Существует 4 различных типа:

- `redirected`: внутри навигационного хука был вызван `next(newLocation)` для перенаправления в другое место.
- `aborted`: внутри навигационного хука был вызван `next(false)` для отмены навигации.
- `cancelled`: произошла полностью новая навигация до того, как текущая могла закончиться. Например, во время ожидания внутри навигационного хука был вызван `router.push`.
- `duplicated`: навигация была предотвращена, потому что уже находимся в месте назначения.

## Свойства _ошибок навигации_

Все сбои навигации предоставляют доступ к свойствам `to` и `from`, чтобы отобразить текущее местоположение, а также местоположение места назначения для навигации, в которой произошёл сбой:

```js
// попытка получения доступа к странице администрирования
router
  .push('/admin')
  .catch(failure => {
    if (isNavigationFailure(failure, NavigationFailureType.redirected)) {
      console.log(failure.to.path) // '/admin'
      console.log(failure.from.path) // '/'
    }
  })
```

Во всех случаях значения `to` и `from` будут объектами нормализованных маршрутов.
