## RabbitMQ 3.8.6

RabbitMQ `3.8.6` is a maintenance release.
It focuses on bug fixes and usability improvements.

### RabbitMQ Adopts the Mozilla Public License 2.0

Starting with this release, core RabbitMQ server and all [tier 1 plugins](https://www.rabbitmq.com/plugins.html#plugin-tiers)
are [relicensed](https://github.com/rabbitmq/rabbitmq-server/issues/2372) under the [Mozilla Public License 2.0](https://www.mozilla.org/en-US/MPL/2.0/)
(previously used license: the Mozilla Public License 1.1).

The permissiveness of the MPL 2.0 is largely the same as of the MPL 1.1.
See the [MPL 2.0 FAQ](https://www.mozilla.org/en-US/MPL/2.0/FAQ/) and
[MPL 2.0 Revision and Changes FAQ](https://www.mozilla.org/en-US/MPL/2.0/Revision-FAQ/) to learn more.

### Erlang 23 Compatibility

This release is [compatible](https://groups.google.com/forum/#!topic/rabbitmq-users/wlPIWz3UYHQ) with [Erlang 23](http://blog.erlang.org/OTP-23-Highlights/).

### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 21.3**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.3` or `23.0` releases are recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


## Upgrade and Compatibility Notes

### Deprecations

This release removed HiPE precompilation support. HiPE has been deprecated and
mostly unmaintained since Erlang 22, and will be replaced with a JIT [in Erlang 24](http://erlang.org/pipermail/erlang-questions/2020-June/099645.html)
in 2021.

``` shell
rabbitmqctl hipe_compile
```

and

``` ini
hipe_compile = true
```

are both retained for backwards compatibility but they won't have any effect.


### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release from `3.7.6` or an older version, extra care has to be taken.

Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` first, then Erlang 22.x or 23.x, then RabbitMQ to most recent
3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).



## Changes Worth Mentioning

### Core Server

#### License Change

RabbitMQ has been [relicensed](https://github.com/rabbitmq/rabbitmq-server/issues/2372) under the [Mozilla Public License 2.0](https://www.mozilla.org/en-US/MPL/2.0/)
(previously used license: the Mozilla Public License 1.1).

The permissiveness of the MPL 2.0 is largely the same as of the MPL 1.1.
See the [MPL 2.0 FAQ](https://www.mozilla.org/en-US/MPL/2.0/FAQ/) and
[MPL 2.0 Revision and Changes FAQ](https://www.mozilla.org/en-US/MPL/2.0/Revision-FAQ/) to learn more.

#### Deprecations

 * Removed HiPE pre-compilation support.

   GitHub issue: [rabbitmq/rabbitmq-server#2392](https://github.com/rabbitmq/rabbitmq-server/pull/2392)

#### Bug Fixes

 * Definition import on node boot (via the **built-in `load_definitions` configuration setting**) is now performed
   after plugins are enabled.

   This resolves a long-standing chicken-and-egg dependency problem that prevented definitions
   that depend on plugins being functional from being successfully imported during node boot.

   Note that definition import via the management plugin (`management.load_definitions`) is still
   performed during management plugin activation time and therefore **can not offer any guarantees**
   as some plugins may be enabled after the management one.

   Some affected features include

   * [federation upstreams](https://www.rabbitmq.com/federation.html#getting-started)
   * [dynamic shovels](https://www.rabbitmq.com/shovel-dynamic.html)
   * exchanges of types provided by plugins such as [rabbitmq-consistent-hash-exchange](https://github.com/rabbitmq/rabbitmq-consistent-hash-exchange)

   GitHub issue: [rabbitmq/rabbitmq-server#2384](https://github.com/rabbitmq/rabbitmq-server/issues/2384)

 * Similarly, client connection listeners (both TCP and TLS-enabled) are now started after
   plugin activation. This makes certain configurations that use the trust store plugin
   behave as expected.

   GitHub issue: [rabbitmq/rabbitmq-server#2405](https://github.com/rabbitmq/rabbitmq-server/issues/2405)

 * Environment variables prefixed with `RABBITMQ_` were ignored when used in the [`rabbitmq-env.conf` file](),
   while their prefixless counterparts worked as expected.

   GitHub issue: [rabbitmq/rabbitmq-common#401](https://github.com/rabbitmq/rabbitmq-common/issues/401)

#### Enhancements

 * `rabbitmq.conf` config parser now accepts lines that only consist of whitespace.

   GitHub issue: [rabbitmq/rabbitmq-server#2393](https://github.com/rabbitmq/rabbitmq-server/pull/2393)


### CLI Tools

#### Deprecations

 * `rabbitmqctl hipe_compile` is now a no-op. HiPE support has been deprecated in Erlang 22
   [will be removed in Erlang 24](http://erlang.org/pipermail/erlang-questions/2020-June/099645.html).

   GitHub issue: [rabbitmq/rabbitmq-cli#433](https://github.com/rabbitmq/rabbitmq-cli/pull/433)

 * The use of the `` environment variable to configure the [shared secret](https://www.rabbitmq.com/cli.html#erlang-cookie) is now deprecated.
   Use the [local file](https://www.rabbitmq.com/cli.html#cookie-file-locations) option instead or, if the value absolutely must be provided on the command line,
   the `--erlang-cookie [value]` switch.

   GitHub issue: [rabbitmq/rabbitmq-cli#443](https://github.com/rabbitmq/rabbitmq-cli/issues/443)

#### Bug Fixes

 * `rabbitmqctl export_definitions` incorrectly serialised runtime parameter values.

   GitHub issue: [rabbitmq/rabbitmq-cli#435](https://github.com/rabbitmq/rabbitmq-cli/issues/435)

 * `CTL_ERL_ARGS` environment variable was unintentionally ignored starting with version `3.8.4`.

   GitHub issue: [rabbitmq/rabbitmq-server#2394](https://github.com/rabbitmq/rabbitmq-server/issues/2394)

 * `[command] --help` and `help [command]` output had minor unintentional inconsistencies.

    GitHub issue: [rabbitmq/rabbitmq-cli#437](https://github.com/rabbitmq/rabbitmq-cli/pull/437)

#### Enhancements

 * `rabbitmq-queues check_if_node_is_quorum_critical` and `rabbitmq-queues check_if_node_is_mirror_sync_critical` checks
    have been adjusted. They now special case single node clusters as the check does not make much sense
    in those environments.

    `rabbitmq-queues check_if_node_is_mirror_sync_critical` now also excludes exclusive queues from
    consideration as they, even if matched by a policy that enables classic queue mirroring,
    would not actually be mirrored.

   GitHub issue: [rabbitmq/rabbitmq-cli#432](https://github.com/rabbitmq/rabbitmq-cli/issues/432)

 * `rabbitmq-diagnostics status` now includes the total amount of memory used by the node in its
   regular output. It was previously only available when `--formatter=json` switch was used.

   GitHub issue: [rabbitmq/rabbitmq-cli#449](https://github.com/rabbitmq/rabbitmq-cli/pull/449)

 * `rabbitmq-diagnostics erlang_cookie_sources` is a new command that helps with troubleshooting
   CLI tool authentication to nodes by listing relevant environment information about the
   [shared secret](https://www.rabbitmq.com/cli.html#erlang-cookie). The actual secret
   **is not displayed** for obvious security reasons.

   GitHub issue: [rabbitmq/rabbitmq-cli#446](https://github.com/rabbitmq/rabbitmq-cli/pull/446)

* `rabbitmqct eval_file` is a new command that evaluates Erlang code expressions from a local file
   on the target node:

   ``` shell
   rabbitmqctl eval_file /path/to/code_snippet.escript
   ```

   GitHub issue: [rabbitmq/rabbitmq-cli#438](https://github.com/rabbitmq/rabbitmq-cli/issues/438)

 * `rabbitmqct eval` now accepts code snippets from standard input:

   ``` shell
   rabbitmqctl eval <<EOF
    io:format("~p~n", [
        rabbit:product_info()
    ]).
   ```

   ``` shell
   rabbitmqctl eval < code_snippet.escript
   ```

   GitHub issue: [rabbitmq/rabbitmq-cli#438](https://github.com/rabbitmq/rabbitmq-cli/issues/438)

 * `rabbitmq-diagnostics resolve_hostname` is a new command that resolves a hostname either locally
   or on the node, and returns the resolved IPv4 or IPv6 addresses.

   The command can help quickly detect hostname resolution irregularities on a node, including
   the effects of [Erlang inetrc file](https://erlang.org/doc/apps/erts/inet_cfg.html) settings.
   Hostname resolution issues can cause CLI tools, cluster formation and peer reconnection to
   not work as expected.

   Some examples:

   ``` shell
   rabbitmq-diagnostics resolve_hostname "google.com" --address-family ipv4

   rabbitmq-diagnostics resolve_hostname "google.com" --address-family ipv6 --offline
   ```

   GitHub issue: [rabbitmq/rabbitmq-cli#431](https://github.com/rabbitmq/rabbitmq-cli/pull/431)

 * All CLI tools now provide an `autocomplete [prefix]` command that lists command completion
   options. It is intended to be used to implement autocompletion of command names in shells.

   GitHub issue: [rabbitmq/rabbitmq-cli#439](https://github.com/rabbitmq/rabbitmq-cli/issues/439)


### Management Plugin

#### Bug Fixes

 * The plugin could send the `authorization` header as `null` in some cases before a successful login.

   Contributed by @furkhat.

   GitHub issue: [rabbitmq/rabbitmq-management#833](https://github.com/rabbitmq/rabbitmq-management/pull/833)

#### Enhancements

 * The UI now uses more human-friendly information units when displaying client network traffic rate values.

   Contribute by @seadog007.

   GitHub issue: [rabbitmq/rabbitmq-management#827](https://github.com/rabbitmq/rabbitmq-management/pull/827)


### Federation Plugin

#### Bug Fixes

 * In environments where `rabbitmq_federation.pgroup_name_cluster_id` is not set or set to `undefined`,
   links will treat such values as a `false` (the default) instead of failing with an exception.

   GitHub issue: [rabbitmq/rabbitmq-federation#109](https://github.com/rabbitmq/rabbitmq-federation/pull/109)


### MQTT Plugin

#### Bug Fixes

 * The plugin could fail to accept new client connections with an exception in some cases.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#235](https://github.com/rabbitmq/rabbitmq-mqtt/pull/235)


### Web STOMP Plugin

#### Enhancements

 * Certain Web Socket errors are now handled more gracefully.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#123](https://github.com/rabbitmq/rabbitmq-web-stomp/pull/123)


### Web MQTT Plugin

#### Enhancements

 * Certain Web Socket errors are now handled more gracefully.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#64](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/64)


### AuthN/AuthZ Backend HTTP Plugin

#### Bug Fixes

 * Virtual host access checks failed in certain complex configurations.

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-http#100](https://github.com/rabbitmq/rabbitmq-auth-backend-http/issues/100)


## Dependency Upgrades

 * `cuttlefish` was upgraded [from 2.2.0 to 2.3.0](https://github.com/Kyorai/cuttlefish/compare/v2.2.0...v2.3.0)
 * `credentials_obfuscation` was upgraded [from 2.0.0 to 2.1.1](https://github.com/rabbitmq/credentials-obfuscation/compare/v2.0.0...v2.1.1)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.8.6.tar.xz`.
