/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 11:49:25 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JProgressBar;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.alignment.BamUtils;
import uk.ac.sanger.artemis.components.alignment.BamView;
import uk.ac.sanger.artemis.components.alignment.CRAMReferenceSequenceFile;
import uk.ac.sanger.artemis.components.alignment.ReadCount;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class BamUtils_ESTest extends BamUtils_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      boolean boolean0 = BamUtils.isBamFile((String) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      boolean boolean0 = BamUtils.isCramFile((String) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      boolean boolean0 = BamUtils.isBamFile("_\tjb|?$'w");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      URL uRL0 = MockURL.getFileExample();
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/_fake_but_wellformed_url1.tmp");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "Indexing and sorting can be done using samtools (http://www.htslib.org). For example: ");
      BamUtils.createTempIndexFile(uRL0);
      File file0 = BamUtils.createTempIndexFile(uRL0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/_fake_but_wellformed_url1.tmp", file0.toString());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      URL uRL0 = MockURL.getFileExample();
      System.setCurrentTimeMillis(0L);
      File file0 = BamUtils.createTempIndexFile(uRL0);
      assertEquals("_fake_but_wellformed_url0.tmp", file0.getName());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      CRAMReferenceSequenceFile cRAMReferenceSequenceFile0 = new CRAMReferenceSequenceFile(entry0, (BamView) null);
      // Undeclared exception!
      try { 
        BamUtils.validateSAMFile((SamReader) null, cRAMReferenceSequenceFile0, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("htsjdk.samtools.SamFileValidator", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.getFeatureLength((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.getCount((BamView) null, 0, 0, "1f29^0EbJd+kK", false, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.createTempIndexFile((URL) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "");
      URL uRL0 = mockFile0.toURL();
      // Undeclared exception!
      try { 
        BamUtils.createTempIndexFile(uRL0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Prefix string too short
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      URL uRL0 = MockURL.getFileExample();
      FileSystemHandling.shouldAllThrowIOExceptions();
      try { 
        BamUtils.createTempIndexFile(uRL0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      int[][] intArray0 = new int[6][3];
      // Undeclared exception!
      try { 
        BamUtils.countOverRange((BamView) null, "", 2120, 0, 0, intArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.count((BamView) null, "DSnf]KdxPHpEe4}2EG", (-1114), (-1114), true, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamUtils.calculateMappedReads((BamView) null, (FeatureVector) null, false, true, false, (int[]) null, (JProgressBar) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      JProgressBar jProgressBar0 = new JProgressBar();
      // Undeclared exception!
      try { 
        BamUtils.calc((BamView) null, (String) null, (-1209), true, jProgressBar0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      int int0 = BamUtils.getFtpBufferSize();
      assertEquals(10485760, int0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      BamUtils.getFtpSocketTimeout();
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      try { 
        BamUtils.getIndexFile("httpPerforming alignment file validation...");
        fail("Expecting exception: SAMException");
      
      } catch(htsjdk.samtools.SAMException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      try { 
        BamUtils.getIndexFile("");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Alignment file is not a known file type. The file suffix may be incorrect.
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      try { 
        BamUtils.getIndexFile("*\"-f.");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // 
         // An index file could not be created.
         // The BAM/CRAM file needs to be accessible, sorted and indexed.
         // Indexing and sorting can be done using samtools (http://www.htslib.org). For example: 
         // 
         // samtools sort <in.bam> -o <sorted.bam>
         // samtools index <sorted.bam>
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("duXeNk?q");
      byte[] byteArray0 = new byte[2];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      try { 
        BamUtils.getIndexFile("duXeNk?q");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // 
         // An index file could not be created.
         // The BAM/CRAM file needs to be accessible, sorted and indexed.
         // Indexing and sorting can be done using samtools (http://www.htslib.org). For example: 
         // 
         // samtools sort <in.bam> -o <sorted.bam>
         // samtools index <sorted.bam>
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      MockFile mockFile0 = new MockFile("3vQ!2;OW|lB!S&");
      BamUtils.createIndexFileFromScratch("", mockFile0);
      assertFalse(mockFile0.canExecute());
  }
  
  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      String string0 = BamUtils.constructIndexFilename("file.bam");
      assertEquals("file.bam.bai", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      String string0 = BamUtils.constructIndexFilename("samtools index <sorted.bam>");
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      String string0 = BamUtils.constructIndexFilename("file.cram");
      assertEquals("file.cram.crai", string0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      boolean boolean0 = BamUtils.samRecordEqualityCheck((SAMRecord) null, (SAMRecord) null);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      SAMFileHeader sAMFileHeader0 = new SAMFileHeader();
      SAMRecord sAMRecord0 = new SAMRecord(sAMFileHeader0);
      // Undeclared exception!
      try { 
        BamUtils.samRecordEqualityCheck(sAMRecord0, sAMRecord0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      int[] intArray0 = new int[9];
      JProgressBar jProgressBar0 = new JProgressBar();
      Hashtable<String, List<ReadCount>> hashtable0 = (Hashtable<String, List<ReadCount>>)BamUtils.calculateMappedReads((BamView) null, featureVector0, false, true, true, intArray0, jProgressBar0);
      assertTrue(hashtable0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      boolean boolean0 = BamUtils.isCramFile("Performing alignment file validation...");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      BamUtils bamUtils0 = new BamUtils();
  }
}
