/*
	Challenge - Virtual Robot Challenge System
	Copyright (C) 1999--2008:
		Stephane Magnenat <stephane at magnenat dot net>
		(http://stephane.magnenat.net)
	3D models
	Copyright (C) 2008:
		Basilio Noris
	Aseba - an event-based framework for distributed robot control
	Copyright (C) 2007--2016:
		Stephane Magnenat <stephane at magnenat dot net>
		(http://stephane.magnenat.net)
		and other contributors, see authors.txt for details
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation, version 3 of the License.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtOpenGL>

namespace Enki
{
	// 906 Verticies
	// 1336 Texture Coordinates
	// 1120 Normals
	// 1742 Triangles
	
	static short face_indicies[1742][9] = {
	// Object #-1
		{815,814,792 ,0,0,0 ,0,0,0 }, {792,814,793 ,0,0,0 ,0,0,0 }, {814,813,793 ,0,0,0 ,0,0,0 },
		{812,793,813 ,0,0,0 ,0,0,0 }, {793,812,794 ,0,0,0 ,0,0,0 }, {811,794,812 ,0,0,0 ,0,0,0 },
		{794,811,795 ,0,0,0 ,0,0,0 }, {810,795,811 ,0,0,0 ,0,0,0 }, {795,810,796 ,0,0,0 ,0,0,0 },
		{809,796,810 ,0,0,0 ,0,0,0 }, {796,809,797 ,0,0,0 ,0,0,0 }, {808,797,809 ,0,0,0 ,0,0,0 },
		{797,808,798 ,0,0,0 ,0,0,0 }, {807,798,808 ,0,0,0 ,0,0,0 }, {798,807,799 ,0,0,0 ,0,0,0 },
		{806,799,807 ,0,0,0 ,0,0,0 }, {799,806,800 ,0,0,0 ,0,0,0 }, {805,800,806 ,0,0,0 ,0,0,0 },
		{800,805,801 ,0,0,0 ,0,0,0 }, {804,801,805 ,0,0,0 ,0,0,0 }, {804,802,801 ,0,0,0 ,0,0,0 },
		{803,802,804 ,0,0,0 ,0,0,0 }, {626,625,628 ,0,0,0 ,1,2,3 }, {624,628,625 ,0,0,0 ,4,3,2 },
		{628,624,630 ,0,0,0 ,3,4,5 }, {627,630,624 ,0,0,0 ,6,5,4 }, {630,627,632 ,0,0,0 ,5,6,7 },
		{632,627,634 ,0,0,0 ,7,6,8 }, {627,629,634 ,0,0,0 ,6,9,8 }, {631,634,629 ,0,0,0 ,10,8,9 },
		{634,631,636 ,0,0,0 ,8,10,11 }, {633,636,631 ,0,0,0 ,12,11,10 },
		{636,633,638 ,0,0,0 ,11,12,13 }, {635,638,633 ,0,0,0 ,14,13,12 },
		{638,635,640 ,0,0,0 ,13,14,15 }, {637,640,635 ,0,0,0 ,16,15,14 },
		{640,637,643 ,0,0,0 ,15,16,17 }, {639,643,637 ,0,0,0 ,18,17,16 },
		{643,639,644 ,0,0,0 ,17,18,19 }, {644,639,647 ,0,0,0 ,19,18,20 },
		{639,641,647 ,0,0,0 ,18,21,20 }, {642,647,641 ,0,0,0 ,22,20,21 },
		{647,642,646 ,0,0,0 ,20,22,23 }, {645,646,642 ,0,0,0 ,24,23,22 },
		{780,782,781 ,1,2,3 ,25,26,27 }, {778,782,780 ,4,2,1 ,28,26,25 },
		{778,784,782 ,4,5,2 ,28,29,26 }, {779,784,778 ,6,5,4 ,30,29,28 },
		{779,783,784 ,6,7,5 ,30,31,29 }, {777,783,779 ,8,7,6 ,32,31,30 },
		{777,785,783 ,8,9,7 ,32,33,31 }, {776,785,777 ,10,9,8 ,34,33,32 },
		{776,786,785 ,10,11,9 ,34,35,33 }, {775,786,776 ,12,11,10 ,36,35,34 },
		{775,787,786 ,12,13,11 ,36,37,35 }, {768,787,775 ,14,13,12 ,38,37,36 },
		{768,769,787 ,14,15,13 ,38,39,37 }, {774,769,768 ,16,15,14 ,40,39,38 },
		{774,788,769 ,16,17,15 ,40,41,39 }, {773,788,774 ,18,17,16 ,42,41,40 },
		{788,773,770 ,17,18,19 ,41,42,43 }, {770,773,789 ,19,18,20 ,43,42,44 },
		{773,791,789 ,18,21,20 ,42,45,44 }, {789,791,771 ,20,21,22 ,44,45,46 },
		{772,771,791 ,23,22,21 ,47,46,45 }, {790,771,772 ,24,22,23 ,48,46,47 },
		{25,12,24 ,25,26,27 ,49,50,51 }, {25,13,12 ,25,28,26 ,49,52,50 },
		{26,13,25 ,29,28,25 ,53,52,49 }, {26,14,13 ,29,30,28 ,53,54,52 },
		{27,14,26 ,31,30,29 ,55,54,53 }, {27,15,14 ,31,32,30 ,55,56,54 },
		{28,15,27 ,33,32,31 ,57,56,55 }, {28,16,15 ,33,34,32 ,57,58,56 },
		{29,16,28 ,35,34,33 ,59,58,57 }, {29,17,16 ,35,36,34 ,59,60,58 },
		{30,17,29 ,37,36,35 ,61,60,59 }, {30,18,17 ,37,38,36 ,61,62,60 },
		{31,18,30 ,39,38,37 ,63,62,61 }, {31,19,18 ,39,40,38 ,63,64,62 },
		{32,19,31 ,41,40,39 ,65,64,63 }, {32,20,19 ,41,42,40 ,65,66,64 },
		{33,20,32 ,43,42,41 ,67,66,65 }, {33,21,20 ,43,44,42 ,67,68,66 },
		{34,21,33 ,45,44,43 ,69,68,67 }, {34,22,21 ,45,46,44 ,69,70,68 },
		{35,22,34 ,47,46,45 ,71,70,69 }, {35,23,22 ,47,48,46 ,71,72,70 },
		{36,23,35 ,49,48,47 ,73,72,71 }, {36,0,23 ,49,50,48 ,73,74,72 },
		{37,0,36 ,51,50,49 ,75,74,73 }, {37,1,0 ,51,52,50 ,75,76,74 },
		{38,1,37 ,53,52,51 ,77,76,75 }, {38,2,1 ,53,54,52 ,77,78,76 },
		{39,2,38 ,55,54,53 ,79,78,77 }, {39,3,2 ,55,56,54 ,79,80,78 },
		{40,3,39 ,57,56,55 ,81,80,79 }, {40,4,3 ,57,58,56 ,81,82,80 },
		{41,4,40 ,59,58,57 ,83,82,81 }, {41,5,4 ,59,60,58 ,83,84,82 },
		{42,5,41 ,61,60,59 ,85,84,83 }, {42,6,5 ,61,62,60 ,85,86,84 },
		{43,6,42 ,63,62,61 ,87,86,85 }, {43,7,6 ,63,64,62 ,87,88,86 },
		{44,7,43 ,65,64,63 ,89,88,87 }, {44,8,7 ,65,66,64 ,89,90,88 },
		{45,8,44 ,67,66,65 ,91,90,89 }, {45,9,8 ,67,68,66 ,91,92,90 },
		{46,9,45 ,69,68,67 ,93,92,91 }, {46,10,9 ,69,70,68 ,93,94,92 },
		{47,10,46 ,71,70,69 ,95,94,93 }, {47,11,10 ,71,72,70 ,95,96,94 },
		{24,11,47 ,27,72,71 ,97,96,95 }, {24,12,11 ,27,26,72 ,97,98,96 },
		{49,29,48 ,73,35,74 ,99,59,100 }, {49,30,29 ,73,37,35 ,99,61,59 },
		{50,30,49 ,75,37,73 ,101,61,99 }, {50,31,30 ,75,39,37 ,101,63,61 },
		{51,31,50 ,76,39,75 ,102,63,101 }, {51,32,31 ,76,41,39 ,102,65,63 },
		{52,32,51 ,77,41,76 ,103,65,102 }, {52,33,32 ,77,43,41 ,103,67,65 },
		{53,33,52 ,78,43,77 ,104,67,103 }, {53,34,33 ,78,45,43 ,104,69,67 },
		{54,34,53 ,79,45,78 ,105,69,104 }, {54,35,34 ,79,47,45 ,105,71,69 },
		{55,35,54 ,80,47,79 ,106,71,105 }, {55,36,35 ,80,49,47 ,106,73,71 },
		{56,36,55 ,81,49,80 ,107,73,106 }, {56,37,36 ,81,51,49 ,107,75,73 },
		{57,37,56 ,82,51,81 ,108,75,107 }, {57,38,37 ,82,53,51 ,108,77,75 },
		{58,38,57 ,83,53,82 ,109,77,108 }, {58,39,38 ,83,55,53 ,109,79,77 },
		{59,39,58 ,84,55,83 ,110,79,109 }, {59,40,39 ,84,57,55 ,110,81,79 },
		{60,40,59 ,85,57,84 ,111,81,110 }, {60,41,40 ,85,59,57 ,111,83,81 },
		{61,41,60 ,86,59,85 ,112,83,111 }, {61,42,41 ,86,61,59 ,112,85,83 },
		{62,42,61 ,87,61,86 ,113,85,112 }, {62,43,42 ,87,63,61 ,113,87,85 },
		{63,43,62 ,88,63,87 ,114,87,113 }, {63,44,43 ,88,65,63 ,114,89,87 },
		{64,44,63 ,89,65,88 ,115,89,114 }, {64,45,44 ,89,67,65 ,115,91,89 },
		{65,45,64 ,90,67,89 ,116,91,115 }, {65,46,45 ,90,69,67 ,116,93,91 },
		{66,46,65 ,91,69,90 ,117,93,116 }, {66,47,46 ,91,71,69 ,117,95,93 },
		{67,47,66 ,92,71,91 ,118,95,117 }, {67,24,47 ,92,27,71 ,118,97,95 },
		{68,24,67 ,93,27,92 ,119,51,120 }, {68,25,24 ,93,25,27 ,119,49,51 },
		{69,25,68 ,94,25,93 ,121,49,119 }, {69,26,25 ,94,29,25 ,121,53,49 },
		{70,26,69 ,95,29,94 ,122,53,121 }, {70,27,26 ,95,31,29 ,122,55,53 },
		{71,27,70 ,96,31,95 ,123,55,122 }, {71,28,27 ,96,33,31 ,123,57,55 },
		{48,28,71 ,74,33,96 ,100,57,123 }, {48,29,28 ,74,35,33 ,100,59,57 },
		{809,120,808 ,97,98,99 ,124,125,126 }, {809,121,120 ,97,100,98 ,124,127,125 },
		{810,121,809 ,101,100,97 ,128,127,124 }, {810,122,121 ,101,102,100 ,128,129,127 },
		{811,122,810 ,103,102,101 ,130,129,128 }, {811,123,122 ,103,104,102 ,130,131,129 },
		{812,123,811 ,105,104,103 ,132,131,130 }, {812,124,123 ,105,106,104 ,132,133,131 },
		{813,124,812 ,107,106,105 ,134,133,132 }, {813,125,124 ,107,108,106 ,134,135,133 },
		{814,125,813 ,109,108,107 ,136,135,134 }, {814,126,125 ,109,110,108 ,136,137,135 },
		{815,126,814 ,111,110,109 ,138,137,136 }, {815,127,126 ,111,112,110 ,138,139,137 },
		{792,127,815 ,113,112,111 ,140,139,138 }, {792,128,127 ,113,114,112 ,140,141,139 },
		{793,128,792 ,115,114,113 ,142,141,140 }, {793,129,128 ,115,116,114 ,142,143,141 },
		{794,129,793 ,117,116,115 ,144,143,142 }, {794,130,129 ,117,118,116 ,144,145,143 },
		{795,130,794 ,119,118,117 ,146,145,144 }, {795,131,130 ,119,120,118 ,146,147,145 },
		{796,131,795 ,121,120,119 ,148,147,146 }, {796,132,131 ,121,122,120 ,148,149,147 },
		{797,132,796 ,123,122,121 ,150,149,148 }, {797,133,132 ,123,124,122 ,150,151,149 },
		{798,133,797 ,125,124,123 ,152,151,150 }, {798,134,133 ,125,126,124 ,152,153,151 },
		{799,134,798 ,127,126,125 ,154,153,152 }, {799,135,134 ,127,128,126 ,154,155,153 },
		{800,135,799 ,129,128,127 ,156,155,154 }, {800,136,135 ,129,130,128 ,156,157,155 },
		{801,136,800 ,131,130,129 ,158,157,156 }, {801,137,136 ,131,132,130 ,158,159,157 },
		{802,137,801 ,133,132,131 ,160,159,158 }, {802,138,137 ,133,134,132 ,160,161,159 },
		{803,138,802 ,135,134,133 ,162,161,160 }, {803,139,138 ,135,136,134 ,162,163,161 },
		{804,139,803 ,137,136,135 ,164,163,162 }, {804,140,139 ,137,138,136 ,164,165,163 },
		{805,140,804 ,139,138,137 ,166,167,168 }, {805,141,140 ,139,140,138 ,166,169,167 },
		{806,141,805 ,141,140,139 ,170,169,166 }, {806,142,141 ,141,142,140 ,170,171,169 },
		{807,142,806 ,143,142,141 ,172,171,170 }, {807,143,142 ,143,144,142 ,172,173,171 },
		{808,143,807 ,99,144,143 ,126,173,172 }, {808,120,143 ,99,98,144 ,126,125,173 },
		{73,120,121 ,145,145,145 ,174,125,127 }, {73,72,120 ,145,145,145 ,174,175,125 },
		{74,121,122 ,145,145,145 ,176,127,129 }, {74,73,121 ,145,145,145 ,176,174,127 },
		{123,74,122 ,145,145,145 ,131,176,129 }, {123,75,74 ,145,145,145 ,131,177,176 },
		{124,75,123 ,145,145,145 ,133,177,131 }, {124,76,75 ,145,145,145 ,133,178,177 },
		{125,76,124 ,145,145,145 ,135,178,133 }, {125,77,76 ,145,145,145 ,135,179,178 },
		{126,77,125 ,145,145,145 ,137,179,135 }, {126,78,77 ,145,145,145 ,137,180,179 },
		{127,78,126 ,145,145,145 ,139,180,137 }, {127,79,78 ,145,145,145 ,139,181,180 },
		{128,79,127 ,145,145,145 ,141,181,139 }, {128,80,79 ,145,145,145 ,141,182,181 },
		{129,80,128 ,145,145,145 ,143,182,141 }, {129,81,80 ,145,145,145 ,143,183,182 },
		{130,81,129 ,145,145,145 ,145,183,143 }, {130,82,81 ,145,145,145 ,145,184,183 },
		{131,82,130 ,145,145,145 ,147,184,145 }, {131,83,82 ,145,145,145 ,147,185,184 },
		{132,83,131 ,145,145,145 ,149,185,147 }, {132,84,83 ,145,145,145 ,149,186,185 },
		{133,84,132 ,145,145,145 ,151,186,149 }, {133,85,84 ,145,145,145 ,151,187,186 },
		{134,85,133 ,145,145,145 ,153,187,151 }, {134,86,85 ,145,145,145 ,153,188,187 },
		{87,134,135 ,145,145,145 ,189,153,155 }, {87,86,134 ,145,145,145 ,189,188,153 },
		{88,135,136 ,145,145,145 ,190,155,157 }, {88,87,135 ,145,145,145 ,190,189,155 },
		{89,136,137 ,145,145,145 ,191,157,159 }, {89,88,136 ,145,145,145 ,191,190,157 },
		{90,137,138 ,145,145,145 ,192,159,161 }, {90,89,137 ,145,145,145 ,192,191,159 },
		{91,138,139 ,145,145,145 ,193,161,163 }, {91,90,138 ,145,145,145 ,193,192,161 },
		{92,139,140 ,145,145,145 ,194,163,165 }, {92,91,139 ,145,145,145 ,194,193,163 },
		{93,140,141 ,145,145,145 ,195,167,169 }, {93,92,140 ,145,145,145 ,195,196,167 },
		{94,141,142 ,145,145,145 ,197,169,171 }, {94,93,141 ,145,145,145 ,197,195,169 },
		{95,142,143 ,145,145,145 ,198,171,173 }, {95,94,142 ,145,145,145 ,198,197,171 },
		{72,143,120 ,145,145,145 ,175,173,125 }, {72,95,143 ,145,145,145 ,175,198,173 },
		{144,175,156 ,146,147,148 ,199,200,201 }, {144,155,175 ,146,149,147 ,199,202,200 },
		{144,157,273 ,146,150,151 ,199,203,204 }, {144,156,157 ,146,148,150 ,199,201,203 },
		{273,231,274 ,151,152,153 ,204,205,206 }, {273,232,231 ,151,154,152 ,204,207,205 },
		{274,233,275 ,153,155,156 ,206,208,209 }, {274,231,233 ,153,152,155 ,206,205,208 },
		{275,159,145 ,156,157,158 ,209,210,211 }, {275,158,159 ,156,159,157 ,209,212,210 },
		{145,160,276 ,158,160,161 ,211,213,214 }, {145,159,160 ,158,157,160 ,211,210,213 },
		{276,234,277 ,161,162,163 ,214,215,216 }, {276,235,234 ,161,164,162 ,214,217,215 },
		{234,278,277 ,162,165,163 ,215,218,216 }, {234,236,278 ,162,166,165 ,215,219,218 },
		{161,146,278 ,167,168,165 ,220,221,218 }, {161,162,146 ,167,169,168 ,220,222,221 },
		{162,279,146 ,169,170,168 ,222,223,221 }, {162,163,279 ,169,171,170 ,222,224,223 },
		{238,280,279 ,172,173,170 ,225,226,223 }, {238,237,280 ,172,174,173 ,225,227,226 },
		{237,281,280 ,174,175,173 ,227,228,226 }, {237,239,281 ,174,176,175 ,227,229,228 },
		{164,147,281 ,177,178,175 ,230,231,228 }, {164,165,147 ,177,179,178 ,230,232,231 },
		{166,147,165 ,180,178,179 ,233,234,235 }, {166,148,147 ,180,181,178 ,233,236,234 },
		{167,148,166 ,182,181,180 ,237,236,233 }, {167,149,148 ,182,183,181 ,237,238,236 },
		{168,149,167 ,184,183,182 ,239,238,237 }, {168,150,149 ,184,185,183 ,239,240,238 },
		{169,150,168 ,186,185,184 ,241,240,239 }, {169,151,150 ,186,187,185 ,241,242,240 },
		{170,151,169 ,188,187,186 ,243,242,241 }, {170,270,151 ,188,189,187 ,243,244,242 },
		{241,270,240 ,190,189,191 ,245,244,246 }, {241,271,270 ,190,192,189 ,245,247,244 },
		{272,241,242 ,193,190,194 ,248,245,249 }, {272,271,241 ,193,192,190 ,248,247,245 },
		{152,171,172 ,195,196,197 ,250,251,252 }, {152,272,171 ,195,193,196 ,250,248,251 },
		{153,172,173 ,198,197,199 ,253,252,254 }, {153,152,172 ,198,195,197 ,253,250,252 },
		{154,173,174 ,200,199,201 ,255,254,256 }, {154,153,173 ,200,198,199 ,255,253,254 },
		{155,174,175 ,149,201,147 ,202,256,200 }, {155,154,174 ,149,200,201 ,202,255,256 },
		{175,176,156 ,147,202,148 ,200,257,201 }, {175,195,176 ,147,203,202 ,200,258,257 },
		{156,177,157 ,148,204,150 ,201,259,203 }, {156,176,177 ,148,202,204 ,201,257,259 },
		{232,243,231 ,154,205,152 ,207,260,205 }, {232,244,243 ,154,206,205 ,207,261,260 },
		{231,245,233 ,152,207,155 ,205,262,208 }, {231,243,245 ,152,205,207 ,205,260,262 },
		{158,179,159 ,159,208,157 ,212,263,210 }, {158,178,179 ,159,209,208 ,212,264,263 },
		{159,180,160 ,157,210,160 ,210,265,213 }, {159,179,180 ,157,208,210 ,210,263,265 },
		{235,246,234 ,164,211,162 ,217,266,215 }, {235,247,246 ,164,212,211 ,217,267,266 },
		{246,236,234 ,211,166,162 ,266,219,215 }, {246,248,236 ,211,213,166 ,266,268,219 },
		{181,162,161 ,214,169,167 ,269,222,220 }, {181,182,162 ,214,215,169 ,269,270,222 },
		{182,163,162 ,215,171,169 ,270,224,222 }, {182,183,163 ,215,216,171 ,270,271,224 },
		{250,237,238 ,217,174,172 ,272,227,225 }, {250,249,237 ,217,218,174 ,272,273,227 },
		{249,239,237 ,218,176,174 ,273,229,227 }, {249,251,239 ,218,219,176 ,273,274,229 },
		{184,165,164 ,220,179,177 ,275,232,230 }, {184,185,165 ,220,221,179 ,275,276,232 },
		{185,166,165 ,221,180,179 ,277,233,235 }, {185,186,166 ,221,222,180 ,277,278,233 },
		{186,167,166 ,222,182,180 ,278,237,233 }, {186,187,167 ,222,223,182 ,278,279,237 },
		{187,168,167 ,223,184,182 ,279,239,237 }, {187,188,168 ,223,224,184 ,279,280,239 },
		{188,169,168 ,224,186,184 ,280,241,239 }, {188,189,169 ,224,225,186 ,280,281,241 },
		{189,170,169 ,225,188,186 ,281,243,241 }, {189,190,170 ,225,226,188 ,281,282,243 },
		{253,241,240 ,227,190,191 ,283,245,246 }, {253,252,241 ,227,228,190 ,283,284,245 },
		{241,254,242 ,190,229,194 ,245,285,249 }, {241,252,254 ,190,228,229 ,245,284,285 },
		{171,192,172 ,196,230,197 ,251,286,252 }, {171,191,192 ,196,231,230 ,251,287,286 },
		{172,193,173 ,197,232,199 ,252,288,254 }, {172,192,193 ,197,230,232 ,252,286,288 },
		{173,194,174 ,199,233,201 ,254,289,256 }, {173,193,194 ,199,232,233 ,254,288,289 },
		{174,195,175 ,201,203,147 ,256,258,200 }, {174,194,195 ,201,233,203 ,256,289,258 },
		{195,196,176 ,203,234,202 ,258,290,257 }, {195,215,196 ,203,235,234 ,258,291,290 },
		{176,197,177 ,202,236,204 ,257,292,259 }, {176,196,197 ,202,234,236 ,257,290,292 },
		{244,849,243 ,206,237,205 ,261,293,260 }, {244,850,849 ,206,238,237 ,261,294,293 },
		{243,851,245 ,205,239,207 ,260,295,262 }, {243,849,851 ,205,237,239 ,260,293,295 },
		{178,199,179 ,209,240,208 ,264,296,263 }, {178,198,199 ,209,241,240 ,264,297,296 },
		{179,200,180 ,208,242,210 ,263,298,265 }, {179,199,200 ,208,240,242 ,263,296,298 },
		{247,255,246 ,212,243,211 ,267,299,266 }, {247,256,255 ,212,244,243 ,267,300,299 },
		{255,248,246 ,243,213,211 ,299,268,266 }, {255,257,248 ,243,245,213 ,299,301,268 },
		{201,182,181 ,246,215,214 ,302,270,269 }, {201,202,182 ,246,247,215 ,302,303,270 },
		{202,183,182 ,247,216,215 ,303,271,270 }, {202,203,183 ,247,248,216 ,303,304,271 },
		{853,249,250 ,249,218,217 ,305,273,272 }, {853,852,249 ,249,250,218 ,305,306,273 },
		{852,251,249 ,250,219,218 ,306,274,273 }, {852,854,251 ,250,251,219 ,306,307,274 },
		{204,185,184 ,252,221,220 ,308,276,275 }, {204,205,185 ,252,253,221 ,308,309,276 },
		{205,186,185 ,253,222,221 ,310,278,277 }, {205,206,186 ,253,254,222 ,310,311,278 },
		{206,187,186 ,254,223,222 ,311,279,278 }, {206,207,187 ,254,255,223 ,311,312,279 },
		{207,188,187 ,255,224,223 ,312,280,279 }, {207,208,188 ,255,256,224 ,312,313,280 },
		{208,189,188 ,256,225,224 ,313,281,280 }, {208,209,189 ,256,257,225 ,313,314,281 },
		{209,190,189 ,257,226,225 ,314,282,281 }, {209,210,190 ,257,258,226 ,314,315,282 },
		{856,252,253 ,259,228,227 ,316,284,283 }, {856,855,252 ,259,260,228 ,316,317,284 },
		{252,857,254 ,228,261,229 ,284,318,285 }, {252,855,857 ,228,260,261 ,284,317,318 },
		{191,212,192 ,231,262,230 ,287,319,286 }, {191,211,212 ,231,263,262 ,287,320,319 },
		{192,213,193 ,230,264,232 ,286,321,288 }, {192,212,213 ,230,262,264 ,286,319,321 },
		{193,214,194 ,232,265,233 ,288,322,289 }, {193,213,214 ,232,264,265 ,288,321,322 },
		{194,215,195 ,233,235,203 ,289,291,258 }, {194,214,215 ,233,265,235 ,289,322,291 },
		{196,230,216 ,234,145,145 ,290,323,324 }, {196,215,230 ,234,235,145 ,290,291,323 },
		{196,816,197 ,234,145,236 ,290,325,292 }, {196,216,816 ,234,145,145 ,290,324,325 },
		{850,258,849 ,238,145,237 ,294,326,293 }, {850,259,258 ,238,145,145 ,294,292,326 },
		{849,260,851 ,237,145,239 ,293,327,295 }, {849,258,260 ,237,145,145 ,293,326,327 },
		{198,217,199 ,241,145,240 ,297,328,296 }, {198,818,217 ,241,145,145 ,297,329,328 },
		{199,218,200 ,240,145,242 ,296,330,298 }, {199,217,218 ,240,145,145 ,296,328,330 },
		{256,261,255 ,244,145,243 ,300,331,299 }, {256,262,261 ,244,145,145 ,300,298,331 },
		{261,257,255 ,145,245,243 ,331,301,299 }, {261,263,257 ,145,145,245 ,331,332,301 },
		{220,202,201 ,145,247,246 ,333,303,302 }, {220,221,202 ,145,145,247 ,333,334,303 },
		{221,203,202 ,145,248,247 ,334,304,303 }, {221,819,203 ,145,145,248 ,334,335,304 },
		{265,852,853 ,145,250,249 ,304,306,305 }, {265,264,852 ,145,145,250 ,304,336,306 },
		{264,854,852 ,145,251,250 ,336,307,306 }, {264,266,854 ,145,145,251 ,336,337,307 },
		{821,205,204 ,145,253,252 ,338,309,308 }, {821,222,205 ,145,145,253 ,338,339,309 },
		{223,205,222 ,145,253,145 ,340,310,341 }, {223,206,205 ,145,254,253 ,340,311,310 },
		{224,206,223 ,145,254,145 ,342,311,340 }, {224,207,206 ,145,255,254 ,342,312,311 },
		{225,207,224 ,145,255,145 ,343,312,342 }, {225,208,207 ,145,256,255 ,343,313,312 },
		{226,208,225 ,145,256,145 ,344,313,343 }, {226,209,208 ,145,257,256 ,344,314,313 },
		{822,209,226 ,145,257,145 ,345,314,344 }, {822,210,209 ,145,258,257 ,345,315,314 },
		{268,856,267 ,145,259,145 ,346,316,315 }, {268,855,856 ,145,260,259 ,346,317,316 },
		{857,268,269 ,261,145,145 ,318,346,347 }, {857,855,268 ,261,260,145 ,318,317,346 },
		{212,824,227 ,262,145,145 ,319,348,349 }, {212,211,824 ,262,263,145 ,319,320,348 },
		{213,227,228 ,264,145,145 ,321,349,350 }, {213,212,227 ,264,262,145 ,321,319,349 },
		{214,228,229 ,265,145,145 ,322,350,351 }, {214,213,228 ,265,264,145 ,322,321,350 },
		{215,229,230 ,235,145,145 ,291,351,323 }, {215,214,229 ,235,265,145 ,291,322,351 },
		{216,848,825 ,266,267,268 ,324,352,353 }, {216,230,848 ,266,269,267 ,324,323,352 },
		{816,825,826 ,270,268,271 ,325,353,354 }, {816,216,825 ,270,266,268 ,325,324,353 },
		{817,826,827 ,272,271,273 ,355,354,356 }, {817,816,826 ,272,270,271 ,355,325,354 },
		{818,827,828 ,274,273,275 ,329,356,357 }, {818,817,827 ,274,272,273 ,329,355,356 },
		{217,828,829 ,276,275,277 ,328,357,358 }, {217,818,828 ,276,274,275 ,328,329,357 },
		{218,829,830 ,278,277,279 ,330,358,359 }, {218,217,829 ,278,276,277 ,330,328,358 },
		{219,830,831 ,280,279,280 ,360,359,361 }, {219,218,830 ,280,278,279 ,360,330,359 },
		{832,219,831 ,281,280,280 ,362,360,361 }, {832,220,219 ,281,282,280 ,362,333,360 },
		{833,220,832 ,283,282,281 ,363,333,362 }, {833,221,220 ,283,284,282 ,363,334,333 },
		{834,221,833 ,285,284,283 ,364,334,363 }, {834,819,221 ,285,286,284 ,364,335,334 },
		{835,819,834 ,287,286,285 ,365,335,364 }, {835,820,819 ,287,288,286 ,365,366,335 },
		{836,820,835 ,289,288,287 ,367,366,365 }, {836,821,820 ,289,290,288 ,367,338,366 },
		{837,821,836 ,291,290,289 ,368,338,367 }, {837,222,821 ,291,292,290 ,368,339,338 },
		{838,222,837 ,293,292,291 ,369,341,370 }, {838,223,222 ,293,294,292 ,369,340,341 },
		{839,223,838 ,295,294,293 ,371,340,369 }, {839,224,223 ,295,296,294 ,371,342,340 },
		{840,224,839 ,297,296,295 ,372,342,371 }, {840,225,224 ,297,298,296 ,372,343,342 },
		{841,225,840 ,299,298,297 ,373,343,372 }, {841,226,225 ,299,300,298 ,373,344,343 },
		{842,226,841 ,301,300,299 ,374,344,373 }, {842,822,226 ,301,302,300 ,374,345,344 },
		{843,822,842 ,303,302,301 ,375,345,374 }, {843,823,822 ,303,303,302 ,375,376,345 },
		{824,843,844 ,304,303,305 ,348,375,377 }, {824,823,843 ,304,303,303 ,348,376,375 },
		{227,844,845 ,306,305,307 ,349,377,378 }, {227,824,844 ,306,304,305 ,349,348,377 },
		{228,845,846 ,308,307,309 ,350,378,379 }, {228,227,845 ,308,306,307 ,350,349,378 },
		{229,846,847 ,310,309,311 ,351,379,380 }, {229,228,846 ,310,308,309 ,351,350,379 },
		{230,847,848 ,269,311,267 ,323,380,352 }, {230,229,847 ,269,310,311 ,323,351,380 },
		{273,157,232 ,312,313,314 ,204,203,207 }, {233,158,275 ,315,315,315 ,208,212,209 },
		{276,160,235 ,316,317,318 ,214,213,217 }, {236,161,278 ,319,320,321 ,219,220,218 },
		{279,163,238 ,322,322,322 ,223,224,225 }, {239,164,281 ,323,324,325 ,229,230,228 },
		{270,170,240 ,326,327,328 ,244,243,246 }, {171,272,242 ,329,330,331 ,251,248,249 },
		{157,244,232 ,313,332,314 ,203,261,207 }, {157,177,244 ,313,333,332 ,203,259,261 },
		{245,158,233 ,315,315,315 ,262,212,208 }, {245,178,158 ,315,315,315 ,262,264,212 },
		{160,247,235 ,317,334,318 ,213,267,217 }, {160,180,247 ,317,335,334 ,213,265,267 },
		{248,161,236 ,336,320,319 ,268,220,219 }, {248,181,161 ,336,337,320 ,268,269,220 },
		{163,250,238 ,322,322,322 ,224,272,225 }, {163,183,250 ,322,322,322 ,224,271,272 },
		{251,164,239 ,338,324,323 ,274,230,229 }, {251,184,164 ,338,339,324 ,274,275,230 },
		{170,253,240 ,327,340,328 ,243,283,246 }, {170,190,253 ,327,341,340 ,243,282,283 },
		{254,171,242 ,342,329,331 ,285,251,249 }, {254,191,171 ,342,343,329 ,285,287,251 },
		{177,850,244 ,333,344,332 ,259,294,261 }, {177,197,850 ,333,345,344 ,259,292,294 },
		{851,178,245 ,315,315,315 ,295,264,262 }, {851,198,178 ,315,315,315 ,295,297,264 },
		{180,256,247 ,335,346,334 ,265,300,267 }, {180,200,256 ,335,347,346 ,265,298,300 },
		{257,181,248 ,348,337,336 ,301,269,268 }, {257,201,181 ,348,349,337 ,301,302,269 },
		{183,853,250 ,322,322,322 ,271,305,272 }, {183,203,853 ,322,322,322 ,271,304,305 },
		{854,184,251 ,350,339,338 ,307,275,274 }, {854,204,184 ,350,351,339 ,307,308,275 },
		{190,856,253 ,341,352,340 ,282,316,283 }, {190,210,856 ,341,353,352 ,282,315,316 },
		{857,191,254 ,354,343,342 ,318,287,285 }, {857,211,191 ,354,355,343 ,318,320,287 },
		{259,817,258 ,145,145,145 ,292,355,326 }, {259,816,817 ,145,145,145 ,292,325,355 },
		{258,818,260 ,145,145,145 ,326,329,327 }, {258,817,818 ,145,145,145 ,326,355,329 },
		{262,219,261 ,145,145,145 ,298,360,331 }, {262,218,219 ,145,145,145 ,298,330,360 },
		{219,263,261 ,145,145,145 ,360,332,331 }, {219,220,263 ,145,145,145 ,360,333,332 },
		{819,264,265 ,145,145,145 ,335,336,304 }, {819,820,264 ,145,145,145 ,335,366,336 },
		{266,204,854 ,0,0,0 ,337,308,307 }, {266,821,204 ,0,0,0 ,337,338,308 },
		{820,266,264 ,145,145,145 ,366,337,336 }, {820,821,266 ,145,145,145 ,366,338,337 },
		{822,268,267 ,145,145,145 ,345,346,315 }, {822,823,268 ,145,145,145 ,345,376,346 },
		{268,824,269 ,145,145,145 ,346,348,347 }, {268,823,824 ,145,145,145 ,346,376,348 },
		{819,623,853 ,322,322,322 ,381,382,383 }, {819,621,623 ,322,322,322 ,381,384,382 },
		{623,605,604 ,322,322,322 ,382,385,386 }, {623,621,605 ,322,322,322 ,382,384,385 },
		{853,619,852 ,356,357,358 ,383,387,388 }, {853,623,619 ,356,359,357 ,383,382,387 },
		{601,623,604 ,360,359,361 ,389,382,386 }, {601,619,623 ,360,357,359 ,389,387,382 },
		{849,622,851 ,362,363,364 ,390,391,392 }, {849,618,622 ,362,365,363 ,390,393,391 },
		{622,600,602 ,363,366,367 ,391,394,395 }, {622,618,600 ,363,365,366 ,391,393,394 },
		{851,620,818 ,315,315,315 ,392,396,397 }, {851,622,620 ,315,315,315 ,392,391,396 },
		{603,622,602 ,315,315,315 ,398,391,395 }, {603,620,622 ,315,315,315 ,398,396,391 },
		{820,621,819 ,287,368,369 ,399,400,401 }, {820,617,621 ,287,370,368 ,399,402,400 },
		{621,599,605 ,368,371,372 ,403,404,405 }, {621,617,599 ,368,370,371 ,403,402,404 },
		{818,616,817 ,373,374,272 ,406,407,408 }, {818,620,616 ,373,375,374 ,406,409,407 },
		{594,620,603 ,376,375,377 ,410,411,412 }, {594,616,620 ,376,374,375 ,410,407,411 },
		{852,615,854 ,358,378,379 ,388,413,414 }, {852,619,615 ,358,357,378 ,388,387,413 },
		{597,619,601 ,380,357,360 ,415,387,389 }, {597,615,619 ,380,378,357 ,415,413,387 },
		{850,618,849 ,381,365,362 ,416,393,390 }, {850,613,618 ,381,382,365 ,416,417,393 },
		{618,596,600 ,365,383,366 ,393,418,394 }, {618,613,596 ,365,382,383 ,393,417,418 },
		{821,617,820 ,384,370,287 ,419,402,399 }, {821,614,617 ,384,385,370 ,419,420,402 },
		{617,598,599 ,370,385,371 ,402,421,404 }, {617,614,598 ,370,385,385 ,402,422,421 },
		{817,612,816 ,272,386,387 ,408,423,424 }, {817,616,612 ,272,374,386 ,408,407,423 },
		{595,616,594 ,388,374,376 ,425,407,410 }, {595,612,616 ,388,386,374 ,425,423,407 },
		{854,614,821 ,389,390,391 ,414,426,427 }, {854,615,614 ,389,392,390 ,414,413,426 },
		{598,615,597 ,393,392,394 ,428,413,415 }, {598,614,615 ,393,390,392 ,428,426,413 },
		{816,613,850 ,395,396,397 ,429,417,416 }, {816,612,613 ,395,398,396 ,429,430,417 },
		{613,595,596 ,396,399,400 ,417,431,418 }, {613,612,595 ,396,398,399 ,417,430,431 },
		{824,609,823 ,401,402,403 ,432,433,434 }, {824,611,609 ,401,404,402 ,432,435,433 },
		{592,611,593 ,405,404,406 ,436,437,438 }, {592,609,611 ,405,402,404 ,436,433,437 },
		{857,611,824 ,407,408,409 ,439,440,441 }, {857,608,611 ,407,410,408 ,439,442,440 },
		{611,590,593 ,408,411,412 ,443,444,445 }, {611,608,590 ,408,410,411 ,443,442,444 },
		{822,607,856 ,413,414,415 ,446,447,448 }, {822,610,607 ,413,416,414 ,446,449,447 },
		{588,610,591 ,417,416,418 ,450,451,452 }, {588,607,610 ,417,414,416 ,450,447,451 },
		{823,610,822 ,403,419,420 ,434,453,454 }, {823,609,610 ,403,402,419 ,434,433,453 },
		{610,592,591 ,419,405,421 ,455,436,456 }, {610,609,592 ,419,402,405 ,455,433,436 },
		{855,608,857 ,422,423,424 ,457,442,439 }, {855,606,608 ,422,425,423 ,457,458,442 },
		{608,589,590 ,423,426,427 ,442,459,444 }, {608,606,589 ,423,425,426 ,442,458,459 },
		{856,606,855 ,428,425,422 ,448,458,457 }, {856,607,606 ,428,429,425 ,448,447,458 },
		{589,607,588 ,426,429,430 ,459,447,450 }, {589,606,607 ,426,425,429 ,459,458,447 },
		{576,605,579 ,322,322,322 ,460,385,461 }, {576,604,605 ,322,322,322 ,460,386,385 },
		{579,599,578 ,431,371,432 ,462,404,463 }, {579,605,599 ,431,372,371 ,462,405,404 },
		{577,604,576 ,433,361,434 ,464,386,460 }, {577,601,604 ,433,360,361 ,464,389,386 },
		{574,600,570 ,435,366,295 ,465,394,466 }, {574,602,600 ,435,367,366 ,465,395,394 },
		{571,603,575 ,436,377,437 ,467,468,469 }, {571,594,603 ,436,376,377 ,467,410,468 },
		{575,602,574 ,315,315,315 ,470,395,465 }, {575,603,602 ,315,315,315 ,470,398,395 },
		{580,601,577 ,438,360,433 ,471,389,464 }, {580,597,601 ,438,380,360 ,471,415,389 },
		{570,596,573 ,295,383,439 ,466,418,472 }, {570,600,596 ,295,366,383 ,466,394,418 },
		{578,598,581 ,432,385,384 ,463,473,474 }, {578,599,598 ,432,371,385 ,463,404,473 },
		{581,597,580 ,440,394,440 ,475,415,471 }, {581,598,597 ,440,393,394 ,475,428,415 },
		{573,595,572 ,441,399,441 ,472,431,476 }, {573,596,595 ,441,400,399 ,472,418,431 },
		{572,594,571 ,387,376,436 ,477,410,467 }, {572,595,594 ,387,388,376 ,477,478,410 },
		{584,593,587 ,442,406,443 ,479,480,481 }, {584,592,593 ,442,405,406 ,479,436,480 },
		{587,590,586 ,444,411,444 ,482,444,483 }, {587,593,590 ,444,412,411 ,482,445,444 },
		{582,591,585 ,445,418,445 ,484,485,486 }, {582,588,591 ,445,417,418 ,484,450,485 },
		{585,592,584 ,446,405,442 ,487,436,479 }, {585,591,592 ,446,421,405 ,487,456,436 },
		{586,589,583 ,447,426,448 ,483,459,488 }, {586,590,589 ,447,427,426 ,483,444,459 },
		{583,588,582 ,448,430,449 ,488,450,484 }, {583,589,588 ,448,426,430 ,488,459,450 },
		{473,524,539 ,450,451,452 ,489,490,491 }, {473,472,524 ,450,453,451 ,489,492,490 },
		{472,525,524 ,453,454,451 ,492,493,494 }, {472,471,525 ,453,455,454 ,492,495,493 },
		{471,515,525 ,455,456,454 ,495,496,497 }, {471,470,515 ,455,457,456 ,495,498,496 },
		{470,511,515 ,457,458,456 ,498,499,500 }, {470,469,511 ,457,459,458 ,498,501,499 },
		{469,495,511 ,459,460,458 ,501,502,503 }, {469,468,495 ,459,461,460 ,501,504,502 },
		{468,497,495 ,461,462,460 ,504,505,506 }, {468,467,497 ,461,463,462 ,504,507,505 },
		{467,485,497 ,463,464,462 ,507,508,509 }, {467,466,485 ,463,465,464 ,507,510,508 },
		{466,488,485 ,465,466,464 ,510,511,512 }, {466,465,488 ,465,467,466 ,510,513,511 },
		{488,464,489 ,466,468,469 ,514,515,516 }, {488,465,464 ,466,467,468 ,514,513,515 },
		{489,463,499 ,469,470,471 ,517,518,519 }, {489,464,463 ,469,468,470 ,517,515,518 },
		{499,462,501 ,471,472,473 ,520,521,522 }, {499,463,462 ,471,470,472 ,520,518,521 },
		{501,461,513 ,473,474,475 ,522,523,524 }, {501,462,461 ,473,472,474 ,522,521,523 },
		{513,460,517 ,475,476,477 ,525,526,527 }, {513,461,460 ,475,474,476 ,525,523,526 },
		{517,459,528 ,477,478,479 ,528,529,530 }, {517,460,459 ,477,476,478 ,528,526,529 },
		{528,458,529 ,479,480,481 ,531,532,533 }, {528,459,458 ,479,478,480 ,531,534,532 },
		{529,457,541 ,481,482,483 ,535,536,537 }, {529,458,457 ,481,480,482 ,535,532,536 },
		{541,456,553 ,483,484,485 ,538,539,540 }, {541,457,456 ,483,482,484 ,538,536,539 },
		{553,455,551 ,485,486,487 ,541,542,543 }, {553,456,455 ,485,484,486 ,541,539,542 },
		{551,454,568 ,487,488,489 ,544,545,546 }, {551,455,454 ,487,486,488 ,544,542,545 },
		{568,453,569 ,489,490,491 ,547,548,549 }, {568,454,453 ,489,488,490 ,547,545,548 },
		{453,565,569 ,490,492,491 ,548,550,551 }, {453,452,565 ,490,493,492 ,548,552,550 },
		{452,549,565 ,493,494,492 ,552,553,554 }, {452,451,549 ,493,495,494 ,552,555,553 },
		{451,547,549 ,495,496,494 ,555,556,557 }, {451,450,547 ,495,497,496 ,555,558,556 },
		{450,539,547 ,497,452,496 ,558,559,560 }, {450,473,539 ,497,450,452 ,558,489,559 },
		{448,473,449 ,145,145,145 ,561,489,562 }, {448,472,473 ,145,145,145 ,561,492,489 },
		{447,472,448 ,145,145,145 ,563,492,561 }, {447,471,472 ,145,145,145 ,563,495,492 },
		{447,470,471 ,145,145,145 ,563,498,495 }, {447,446,470 ,145,145,145 ,563,564,498 },
		{446,469,470 ,145,145,145 ,564,501,498 }, {446,445,469 ,145,145,145 ,564,565,501 },
		{445,468,469 ,145,145,145 ,565,504,501 }, {445,444,468 ,145,145,145 ,565,566,504 },
		{444,467,468 ,145,145,145 ,566,507,504 }, {444,443,467 ,145,145,145 ,566,567,507 },
		{443,466,467 ,145,145,145 ,567,510,507 }, {443,442,466 ,145,145,145 ,567,568,510 },
		{442,465,466 ,145,145,145 ,568,513,510 }, {442,441,465 ,145,145,145 ,568,569,513 },
		{465,440,464 ,145,145,145 ,513,570,515 }, {465,441,440 ,145,145,145 ,513,569,570 },
		{464,439,463 ,145,145,145 ,515,571,518 }, {464,440,439 ,145,145,145 ,515,570,571 },
		{463,438,462 ,145,145,145 ,518,572,521 }, {463,439,438 ,145,145,145 ,518,571,572 },
		{462,437,461 ,145,145,145 ,521,573,523 }, {462,438,437 ,145,145,145 ,521,572,573 },
		{461,436,460 ,145,145,145 ,523,574,526 }, {461,437,436 ,145,145,145 ,523,573,574 },
		{460,435,459 ,145,145,145 ,526,575,529 }, {460,436,435 ,145,145,145 ,526,574,575 },
		{458,435,434 ,145,145,145 ,532,576,577 }, {458,459,435 ,145,145,145 ,532,534,576 },
		{457,434,433 ,145,145,145 ,536,577,578 }, {457,458,434 ,145,145,145 ,536,532,577 },
		{456,433,432 ,145,145,145 ,539,578,579 }, {456,457,433 ,145,145,145 ,539,536,578 },
		{455,432,431 ,145,145,145 ,542,579,580 }, {455,456,432 ,145,145,145 ,542,539,579 },
		{454,431,430 ,145,145,145 ,545,580,581 }, {454,455,431 ,145,145,145 ,545,542,580 },
		{453,430,429 ,145,145,145 ,548,581,582 }, {453,454,430 ,145,145,145 ,548,545,581 },
		{428,453,429 ,145,145,145 ,583,548,582 }, {428,452,453 ,145,145,145 ,583,552,548 },
		{427,452,428 ,145,145,145 ,584,552,583 }, {427,451,452 ,145,145,145 ,584,555,552 },
		{426,451,427 ,145,145,145 ,585,555,584 }, {426,450,451 ,145,145,145 ,585,558,555 },
		{449,450,426 ,145,145,145 ,562,558,585 }, {449,473,450 ,145,145,145 ,562,489,558 },
		{425,448,449 ,498,499,500 ,586,561,562 }, {425,424,448 ,498,501,499 ,586,587,561 },
		{424,447,448 ,501,502,499 ,587,563,561 }, {424,423,447 ,501,503,502 ,587,588,563 },
		{423,446,447 ,503,504,502 ,588,564,563 }, {423,422,446 ,503,269,504 ,588,589,564 },
		{422,445,446 ,269,505,504 ,589,565,564 }, {422,421,445 ,269,506,505 ,589,590,565 },
		{421,444,445 ,506,507,505 ,590,566,565 }, {421,420,444 ,506,508,507 ,590,591,566 },
		{420,443,444 ,508,509,507 ,591,567,566 }, {420,419,443 ,508,510,509 ,591,592,567 },
		{419,442,443 ,510,511,509 ,592,568,567 }, {419,418,442 ,510,512,511 ,592,593,568 },
		{418,441,442 ,512,303,511 ,593,569,568 }, {418,417,441 ,512,303,303 ,593,594,569 },
		{441,416,440 ,303,513,301 ,569,595,570 }, {441,417,416 ,303,303,513 ,569,594,595 },
		{440,415,439 ,301,514,515 ,570,596,571 }, {440,416,415 ,301,513,514 ,570,595,596 },
		{439,414,438 ,515,516,517 ,571,597,572 }, {439,415,414 ,515,514,516 ,571,596,597 },
		{438,413,437 ,517,518,519 ,572,598,573 }, {438,414,413 ,517,516,518 ,572,597,598 },
		{437,412,436 ,519,520,521 ,573,599,574 }, {437,413,412 ,519,518,520 ,573,598,599 },
		{436,411,435 ,521,522,523 ,574,600,575 }, {436,412,411 ,521,520,522 ,574,599,600 },
		{435,410,434 ,523,524,289 ,576,601,577 }, {435,411,410 ,523,522,524 ,576,602,601 },
		{434,409,433 ,289,525,526 ,577,603,578 }, {434,410,409 ,289,524,525 ,577,601,603 },
		{433,408,432 ,526,527,528 ,578,604,579 }, {433,409,408 ,526,525,527 ,578,603,604 },
		{432,407,431 ,528,529,530 ,579,605,580 }, {432,408,407 ,528,527,529 ,579,604,605 },
		{431,406,430 ,530,531,532 ,580,606,581 }, {431,407,406 ,530,529,531 ,580,605,606 },
		{430,405,429 ,532,280,280 ,581,607,582 }, {430,406,405 ,532,531,280 ,581,606,607 },
		{405,428,429 ,280,533,280 ,607,583,582 }, {405,404,428 ,280,278,533 ,607,608,583 },
		{404,427,428 ,278,534,533 ,608,584,583 }, {404,403,427 ,278,535,534 ,608,609,584 },
		{403,426,427 ,535,536,534 ,609,585,584 }, {403,402,426 ,535,537,536 ,609,610,585 },
		{402,449,426 ,537,500,536 ,610,562,585 }, {402,425,449 ,537,498,500 ,610,586,562 },
		{394,425,391 ,538,539,540 ,611,586,612 }, {394,424,425 ,538,541,539 ,611,587,586 },
		{378,424,394 ,542,541,538 ,613,587,611 }, {378,423,424 ,542,543,541 ,613,588,587 },
		{382,423,378 ,544,543,542 ,614,588,613 }, {382,422,423 ,544,545,543 ,614,589,588 },
		{379,422,382 ,546,545,544 ,615,589,614 }, {379,421,422 ,546,547,545 ,615,590,589 },
		{383,421,379 ,548,547,546 ,616,590,615 }, {383,420,421 ,548,549,547 ,616,591,590 },
		{384,420,383 ,550,549,548 ,617,591,616 }, {384,419,420 ,550,551,549 ,617,592,591 },
		{380,419,384 ,552,551,550 ,618,592,617 }, {380,418,419 ,552,553,551 ,618,593,592 },
		{381,418,380 ,554,553,552 ,619,593,618 }, {381,417,418 ,554,555,553 ,619,594,593 },
		{416,381,387 ,556,554,557 ,595,619,620 }, {416,417,381 ,556,555,554 ,595,594,619 },
		{415,387,390 ,558,557,559 ,596,620,621 }, {415,416,387 ,558,556,557 ,596,595,620 },
		{414,390,389 ,560,559,561 ,597,621,622 }, {414,415,390 ,560,558,559 ,597,596,621 },
		{413,389,386 ,562,561,563 ,598,622,623 }, {413,414,389 ,562,560,561 ,598,597,622 },
		{412,386,388 ,564,563,565 ,599,623,624 }, {412,413,386 ,564,562,563 ,599,598,623 },
		{411,388,385 ,566,565,567 ,600,624,625 }, {411,412,388 ,566,564,565 ,600,599,624 },
		{410,385,399 ,568,567,569 ,601,626,627 }, {410,411,385 ,568,566,567 ,601,628,626 },
		{409,399,397 ,570,569,571 ,603,627,629 }, {409,410,399 ,570,568,569 ,603,601,627 },
		{408,397,400 ,572,571,573 ,604,629,630 }, {408,409,397 ,572,570,571 ,604,603,629 },
		{407,400,401 ,574,573,575 ,605,630,631 }, {407,408,400 ,574,572,573 ,605,604,630 },
		{406,401,398 ,576,575,577 ,606,631,632 }, {406,407,401 ,576,574,575 ,606,605,631 },
		{405,398,393 ,578,577,579 ,607,632,633 }, {405,406,398 ,578,576,577 ,607,606,632 },
		{392,405,393 ,580,578,579 ,634,607,633 }, {392,404,405 ,580,581,578 ,634,608,607 },
		{396,404,392 ,582,581,580 ,635,608,634 }, {396,403,404 ,582,583,581 ,635,609,608 },
		{395,403,396 ,584,583,582 ,636,609,635 }, {395,402,403 ,584,585,583 ,636,610,609 },
		{391,402,395 ,540,585,584 ,612,610,636 }, {391,425,402 ,540,539,585 ,612,586,610 },
		{566,398,567 ,586,577,587 ,637,632,638 }, {566,393,398 ,586,579,577 ,637,633,632 },
		{567,401,550 ,587,575,588 ,639,631,640 }, {567,398,401 ,587,577,575 ,639,632,631 },
		{550,400,552 ,588,573,589 ,641,630,642 }, {550,401,400 ,588,575,573 ,641,631,630 },
		{552,397,540 ,589,571,590 ,643,629,644 }, {552,400,397 ,589,573,571 ,643,630,629 },
		{540,399,526 ,590,569,591 ,645,627,646 }, {540,397,399 ,590,571,569 ,645,629,627 },
		{526,385,527 ,591,567,592 ,647,648,649 }, {526,399,385 ,591,569,567 ,647,627,648 },
		{392,566,564 ,580,586,593 ,634,650,651 }, {392,393,566 ,580,579,586 ,634,633,650 },
		{396,564,548 ,582,593,594 ,635,652,653 }, {396,392,564 ,582,580,593 ,635,634,652 },
		{395,548,546 ,584,594,595 ,636,654,655 }, {395,396,548 ,584,582,594 ,636,635,654 },
		{391,546,538 ,540,595,596 ,612,656,657 }, {391,395,546 ,540,584,595 ,612,636,656 },
		{394,538,523 ,538,596,597 ,611,658,659 }, {394,391,538 ,538,540,596 ,611,612,658 },
		{378,523,522 ,542,597,598 ,613,660,661 }, {378,394,523 ,542,538,597 ,613,611,660 },
		{387,487,486 ,557,599,600 ,620,662,663 }, {387,381,487 ,557,554,599 ,620,619,662 },
		{390,486,498 ,559,600,601 ,621,664,665 }, {390,387,486 ,559,557,600 ,621,620,664 },
		{389,498,500 ,561,601,602 ,622,666,667 }, {389,390,498 ,561,559,601 ,622,621,666 },
		{386,500,512 ,563,602,603 ,623,667,668 }, {386,389,500 ,563,561,602 ,623,622,667 },
		{388,512,516 ,565,603,604 ,624,669,670 }, {388,386,512 ,565,563,603 ,624,623,669 },
		{385,516,527 ,567,604,592 ,625,671,672 }, {385,388,516 ,567,565,604 ,625,624,671 },
		{487,380,484 ,599,552,605 ,673,618,674 }, {487,381,380 ,599,554,552 ,673,619,618 },
		{484,384,496 ,605,550,606 ,675,617,676 }, {484,380,384 ,605,552,550 ,675,618,617 },
		{496,383,494 ,606,548,607 ,677,616,678 }, {496,384,383 ,606,550,548 ,677,617,616 },
		{494,379,510 ,607,546,608 ,678,615,679 }, {494,383,379 ,607,548,546 ,678,616,615 },
		{510,382,514 ,608,544,609 ,680,614,681 }, {510,379,382 ,608,546,544 ,680,615,614 },
		{514,378,522 ,609,542,598 ,682,613,683 }, {514,382,378 ,609,544,542 ,682,614,613 },
		{479,482,478 ,610,611,612 ,684,685,686 }, {479,481,482 ,610,613,611 ,684,687,685 },
		{478,483,480 ,612,614,615 ,688,689,690 }, {478,482,483 ,612,611,614 ,688,685,689 },
		{480,493,492 ,615,616,617 ,690,691,692 }, {480,483,493 ,615,614,616 ,690,689,691 },
		{492,508,507 ,617,618,619 ,693,694,695 }, {492,493,508 ,617,616,618 ,693,691,694 },
		{507,509,506 ,619,620,621 ,695,696,697 }, {507,508,509 ,619,618,620 ,695,694,696 },
		{506,521,520 ,621,622,623 ,698,699,700 }, {506,509,521 ,621,620,622 ,698,696,699 },
		{520,536,535 ,623,624,625 ,701,702,703 }, {520,521,536 ,623,622,624 ,701,704,702 },
		{535,537,534 ,625,626,627 ,705,706,707 }, {535,536,537 ,625,624,626 ,705,708,706 },
		{534,545,544 ,627,628,629 ,709,710,711 }, {534,537,545 ,627,626,628 ,709,706,710 },
		{544,561,560 ,629,630,631 ,711,712,713 }, {544,545,561 ,629,628,630 ,711,710,712 },
		{560,562,559 ,631,632,633 ,714,715,716 }, {560,561,562 ,631,630,632 ,714,712,715 },
		{559,563,558 ,633,634,635 ,717,718,719 }, {559,562,563 ,633,632,634 ,717,715,718 },
		{563,555,558 ,634,636,635 ,718,720,719 }, {563,556,555 ,634,637,636 ,718,721,720 },
		{556,554,555 ,637,638,636 ,721,722,720 }, {556,557,554 ,637,639,638 ,721,723,722 },
		{557,542,554 ,639,640,638 ,723,724,722 }, {557,543,542 ,639,641,640 ,723,725,724 },
		{543,531,542 ,641,642,640 ,725,726,724 }, {543,532,531 ,641,643,642 ,725,727,726 },
		{532,530,531 ,643,644,642 ,727,728,726 }, {532,533,530 ,643,645,644 ,727,729,728 },
		{533,518,530 ,645,646,644 ,729,730,728 }, {533,519,518 ,645,647,646 ,729,731,730 },
		{519,503,518 ,647,648,646 ,731,732,733 }, {519,504,503 ,647,649,648 ,731,734,732 },
		{504,502,503 ,649,650,648 ,734,735,736 }, {504,505,502 ,649,651,650 ,734,737,735 },
		{505,490,502 ,651,652,650 ,737,738,739 }, {505,491,490 ,651,653,652 ,737,740,738 },
		{491,475,490 ,653,654,652 ,740,741,742 }, {491,476,475 ,653,655,654 ,740,743,741 },
		{476,474,475 ,655,656,654 ,743,744,741 }, {476,477,474 ,655,657,656 ,743,745,744 },
		{477,479,474 ,657,610,656 ,745,746,747 }, {477,481,479 ,657,613,610 ,745,687,746 },
		{377,533,532 ,658,659,660 ,748,749,750 }, {377,376,533 ,658,661,659 ,748,751,749 },
		{376,519,533 ,661,662,659 ,751,752,749 }, {376,375,519 ,661,663,662 ,751,753,752 },
		{375,504,519 ,663,664,662 ,753,754,752 }, {375,374,504 ,663,665,664 ,753,755,754 },
		{374,505,504 ,665,666,664 ,755,756,754 }, {374,373,505 ,665,667,666 ,755,757,756 },
		{373,491,505 ,667,668,666 ,757,758,756 }, {373,372,491 ,667,669,668 ,757,759,758 },
		{372,476,491 ,669,670,668 ,759,760,758 }, {372,371,476 ,669,671,670 ,759,761,760 },
		{371,477,476 ,671,672,670 ,761,762,760 }, {371,370,477 ,671,673,672 ,761,763,762 },
		{370,481,477 ,673,674,672 ,763,764,762 }, {370,369,481 ,673,675,674 ,763,765,764 },
		{481,368,482 ,674,676,677 ,764,766,767 }, {481,369,368 ,674,675,676 ,764,765,766 },
		{482,367,483 ,677,678,679 ,767,768,769 }, {482,368,367 ,677,676,678 ,767,766,768 },
		{483,366,493 ,679,680,681 ,769,770,771 }, {483,367,366 ,679,678,680 ,769,768,770 },
		{493,365,508 ,681,682,683 ,771,772,773 }, {493,366,365 ,681,680,682 ,771,770,772 },
		{508,364,509 ,683,684,685 ,773,774,775 }, {508,365,364 ,683,682,684 ,773,772,774 },
		{509,363,521 ,685,686,687 ,775,776,777 }, {509,364,363 ,685,684,686 ,775,774,776 },
		{521,362,536 ,687,688,689 ,778,779,780 }, {521,363,362 ,687,686,688 ,778,781,779 },
		{536,361,537 ,689,690,691 ,780,782,783 }, {536,362,361 ,689,688,690 ,780,779,782 },
		{537,360,545 ,691,692,693 ,783,784,785 }, {537,361,360 ,691,690,692 ,783,782,784 },
		{545,359,561 ,693,694,695 ,785,786,787 }, {545,360,359 ,693,692,694 ,785,784,786 },
		{561,358,562 ,695,696,697 ,787,788,789 }, {561,359,358 ,695,694,696 ,787,786,788 },
		{562,357,563 ,697,698,699 ,789,790,791 }, {562,358,357 ,697,696,698 ,789,788,790 },
		{357,556,563 ,698,700,699 ,790,792,791 }, {357,356,556 ,698,701,700 ,790,793,792 },
		{356,557,556 ,701,702,700 ,793,794,792 }, {356,355,557 ,701,703,702 ,793,795,794 },
		{355,543,557 ,703,704,702 ,795,796,794 }, {355,354,543 ,703,705,704 ,795,797,796 },
		{354,532,543 ,705,660,704 ,797,750,796 }, {354,377,532 ,705,658,660 ,797,748,750 },
		{352,377,353 ,145,145,145 ,798,748,799 }, {352,376,377 ,145,145,145 ,798,751,748 },
		{351,376,352 ,145,145,145 ,800,751,798 }, {351,375,376 ,145,145,145 ,800,753,751 },
		{351,374,375 ,145,145,145 ,800,755,753 }, {351,350,374 ,145,145,145 ,800,801,755 },
		{350,373,374 ,145,145,145 ,801,757,755 }, {350,349,373 ,145,145,145 ,801,802,757 },
		{349,372,373 ,145,145,145 ,802,759,757 }, {349,348,372 ,145,145,145 ,802,803,759 },
		{348,371,372 ,145,145,145 ,803,761,759 }, {348,347,371 ,145,145,145 ,803,804,761 },
		{347,370,371 ,145,145,145 ,804,763,761 }, {347,346,370 ,145,145,145 ,804,805,763 },
		{346,369,370 ,145,145,145 ,805,765,763 }, {346,345,369 ,145,145,145 ,805,806,765 },
		{369,344,368 ,145,145,145 ,765,807,766 }, {369,345,344 ,145,145,145 ,765,806,807 },
		{368,343,367 ,145,145,145 ,766,808,768 }, {368,344,343 ,145,145,145 ,766,807,808 },
		{367,342,366 ,145,145,145 ,768,809,770 }, {367,343,342 ,145,145,145 ,768,808,809 },
		{366,341,365 ,145,145,145 ,770,810,772 }, {366,342,341 ,145,145,145 ,770,809,810 },
		{365,340,364 ,145,145,145 ,772,811,774 }, {365,341,340 ,145,145,145 ,772,810,811 },
		{364,339,363 ,145,145,145 ,774,812,776 }, {364,340,339 ,145,145,145 ,774,811,812 },
		{362,339,338 ,145,145,145 ,779,813,814 }, {362,363,339 ,145,145,145 ,779,781,813 },
		{361,338,337 ,145,145,145 ,782,814,815 }, {361,362,338 ,145,145,145 ,782,779,814 },
		{360,337,336 ,145,145,145 ,784,815,816 }, {360,361,337 ,145,145,145 ,784,782,815 },
		{359,336,335 ,145,145,145 ,786,816,817 }, {359,360,336 ,145,145,145 ,786,784,816 },
		{358,335,334 ,145,145,145 ,788,817,818 }, {358,359,335 ,145,145,145 ,788,786,817 },
		{357,334,333 ,145,145,145 ,790,818,819 }, {357,358,334 ,145,145,145 ,790,788,818 },
		{332,357,333 ,145,145,145 ,820,790,819 }, {332,356,357 ,145,145,145 ,820,793,790 },
		{331,356,332 ,145,145,145 ,821,793,820 }, {331,355,356 ,145,145,145 ,821,795,793 },
		{330,355,331 ,145,145,145 ,822,795,821 }, {330,354,355 ,145,145,145 ,822,797,795 },
		{353,354,330 ,145,145,145 ,799,797,822 }, {353,377,354 ,145,145,145 ,799,748,797 },
		{329,352,353 ,498,706,707 ,823,798,799 }, {329,328,352 ,498,708,706 ,823,824,798 },
		{328,351,352 ,708,709,706 ,824,800,798 }, {328,327,351 ,708,710,709 ,824,825,800 },
		{327,350,351 ,710,711,709 ,825,801,800 }, {327,326,350 ,710,712,711 ,825,826,801 },
		{326,349,350 ,712,505,711 ,826,802,801 }, {326,325,349 ,712,713,505 ,826,827,802 },
		{325,348,349 ,713,714,505 ,827,803,802 }, {325,324,348 ,713,715,714 ,827,828,803 },
		{324,347,348 ,715,716,714 ,828,804,803 }, {324,323,347 ,715,510,716 ,828,829,804 },
		{323,346,347 ,510,717,716 ,829,805,804 }, {323,322,346 ,510,718,717 ,829,830,805 },
		{322,345,346 ,718,303,717 ,830,806,805 }, {322,321,345 ,718,303,303 ,830,831,806 },
		{345,320,344 ,303,719,720 ,806,832,807 }, {345,321,320 ,303,303,719 ,806,831,832 },
		{344,319,343 ,720,514,721 ,807,833,808 }, {344,320,319 ,720,719,514 ,807,832,833 },
		{343,318,342 ,721,722,723 ,808,834,809 }, {343,319,318 ,721,514,722 ,808,833,834 },
		{342,317,341 ,723,724,519 ,809,835,810 }, {342,318,317 ,723,722,724 ,809,834,835 },
		{341,316,340 ,519,725,726 ,810,836,811 }, {341,317,316 ,519,724,725 ,810,835,836 },
		{340,315,339 ,726,727,728 ,811,837,812 }, {340,316,315 ,726,725,727 ,811,836,837 },
		{339,314,338 ,728,729,730 ,813,838,814 }, {339,315,314 ,728,727,729 ,813,839,838 },
		{338,313,337 ,730,525,731 ,814,840,815 }, {338,314,313 ,730,729,525 ,814,838,840 },
		{337,312,336 ,731,732,733 ,815,841,816 }, {337,313,312 ,731,525,732 ,815,840,841 },
		{336,311,335 ,733,734,530 ,816,842,817 }, {336,312,311 ,733,732,734 ,816,841,842 },
		{335,310,334 ,530,735,736 ,817,843,818 }, {335,311,310 ,530,734,735 ,817,842,843 },
		{334,309,333 ,736,280,280 ,818,844,819 }, {334,310,309 ,736,735,280 ,818,843,844 },
		{309,332,333 ,280,737,280 ,844,820,819 }, {309,308,332 ,280,738,737 ,844,845,820 },
		{308,331,332 ,738,534,737 ,845,821,820 }, {308,307,331 ,738,739,534 ,845,846,821 },
		{307,330,331 ,739,740,534 ,846,822,821 }, {307,306,330 ,739,741,740 ,846,847,822 },
		{306,353,330 ,741,707,740 ,847,799,822 }, {306,329,353 ,741,498,707 ,847,823,799 },
		{298,329,295 ,742,743,744 ,848,823,849 }, {298,328,329 ,742,745,743 ,848,824,823 },
		{282,328,298 ,746,745,742 ,850,824,848 }, {282,327,328 ,746,747,745 ,850,825,824 },
		{286,327,282 ,748,747,746 ,851,825,850 }, {286,326,327 ,748,749,747 ,851,826,825 },
		{283,326,286 ,750,749,748 ,852,826,851 }, {283,325,326 ,750,751,749 ,852,827,826 },
		{287,325,283 ,752,751,750 ,853,827,852 }, {287,324,325 ,752,753,751 ,853,828,827 },
		{288,324,287 ,754,753,752 ,854,828,853 }, {288,323,324 ,754,755,753 ,854,829,828 },
		{284,323,288 ,756,755,754 ,855,829,854 }, {284,322,323 ,756,757,755 ,855,830,829 },
		{285,322,284 ,758,757,756 ,856,830,855 }, {285,321,322 ,758,759,757 ,856,831,830 },
		{320,285,291 ,760,758,761 ,832,856,857 }, {320,321,285 ,760,759,758 ,832,831,856 },
		{319,291,294 ,762,761,763 ,833,857,858 }, {319,320,291 ,762,760,761 ,833,832,857 },
		{318,294,293 ,764,763,765 ,834,858,859 }, {318,319,294 ,764,762,763 ,834,833,858 },
		{317,293,290 ,766,765,767 ,835,859,860 }, {317,318,293 ,766,764,765 ,835,834,859 },
		{316,290,292 ,768,767,769 ,836,860,861 }, {316,317,290 ,768,766,767 ,836,835,860 },
		{315,292,289 ,770,769,771 ,837,861,862 }, {315,316,292 ,770,768,769 ,837,836,861 },
		{314,289,303 ,772,771,773 ,838,863,864 }, {314,315,289 ,772,770,771 ,838,839,863 },
		{313,303,301 ,774,773,775 ,840,864,865 }, {313,314,303 ,774,772,773 ,840,838,864 },
		{312,301,304 ,776,775,777 ,841,865,866 }, {312,313,301 ,776,774,775 ,841,840,865 },
		{311,304,305 ,778,777,779 ,842,866,867 }, {311,312,304 ,778,776,777 ,842,841,866 },
		{310,305,302 ,780,779,781 ,843,867,868 }, {310,311,305 ,780,778,779 ,843,842,867 },
		{309,302,297 ,782,781,783 ,844,868,869 }, {309,310,302 ,782,780,781 ,844,843,868 },
		{296,309,297 ,784,782,783 ,870,844,869 }, {296,308,309 ,784,785,782 ,870,845,844 },
		{300,308,296 ,786,785,784 ,871,845,870 }, {300,307,308 ,786,787,785 ,871,846,845 },
		{299,307,300 ,788,787,786 ,872,846,871 }, {299,306,307 ,788,789,787 ,872,847,846 },
		{295,306,299 ,744,789,788 ,849,847,872 }, {295,329,306 ,744,743,789 ,849,823,847 },
		{558,302,559 ,790,781,791 ,873,868,874 }, {558,297,302 ,790,783,781 ,873,869,868 },
		{559,305,560 ,791,779,792 ,874,867,875 }, {559,302,305 ,791,781,779 ,874,868,867 },
		{560,304,544 ,792,777,793 ,875,866,876 }, {560,305,304 ,792,779,777 ,875,867,866 },
		{544,301,534 ,793,775,794 ,876,865,877 }, {544,304,301 ,793,777,775 ,876,866,865 },
		{534,303,535 ,794,773,795 ,877,864,878 }, {534,301,303 ,794,775,773 ,877,865,864 },
		{535,289,520 ,795,771,796 ,878,879,880 }, {535,303,289 ,795,773,771 ,878,864,879 },
		{296,558,555 ,784,790,797 ,870,873,881 }, {296,297,558 ,784,783,790 ,870,869,873 },
		{300,555,554 ,786,797,798 ,871,881,882 }, {300,296,555 ,786,784,797 ,871,870,881 },
		{299,554,542 ,788,798,799 ,872,882,883 }, {299,300,554 ,788,786,798 ,872,871,882 },
		{295,542,531 ,744,799,800 ,849,883,884 }, {295,299,542 ,744,788,799 ,849,872,883 },
		{298,531,530 ,742,800,801 ,848,884,885 }, {298,295,531 ,742,744,800 ,848,849,884 },
		{282,530,518 ,746,801,802 ,850,885,886 }, {282,298,530 ,746,742,801 ,850,848,885 },
		{291,479,478 ,761,803,804 ,857,887,888 }, {291,285,479 ,761,758,803 ,857,856,887 },
		{294,478,480 ,763,804,805 ,858,888,889 }, {294,291,478 ,763,761,804 ,858,857,888 },
		{293,480,492 ,765,805,806 ,859,889,890 }, {293,294,480 ,765,763,805 ,859,858,889 },
		{290,492,507 ,767,806,807 ,860,890,891 }, {290,293,492 ,767,765,806 ,860,859,890 },
		{292,507,506 ,769,807,808 ,861,891,892 }, {292,290,507 ,769,767,807 ,861,860,891 },
		{289,506,520 ,771,808,796 ,862,892,893 }, {289,292,506 ,771,769,808 ,862,861,892 },
		{479,284,474 ,803,756,809 ,887,855,894 }, {479,285,284 ,803,758,756 ,887,856,855 },
		{474,288,475 ,809,754,810 ,894,854,895 }, {474,284,288 ,809,756,754 ,894,855,854 },
		{475,287,490 ,810,752,811 ,895,853,896 }, {475,288,287 ,810,754,752 ,895,854,853 },
		{490,283,502 ,811,750,812 ,896,852,897 }, {490,287,283 ,811,752,750 ,896,853,852 },
		{502,286,503 ,812,748,813 ,897,851,898 }, {502,283,286 ,812,750,748 ,897,852,851 },
		{503,282,518 ,813,746,802 ,898,850,886 }, {503,286,282 ,813,748,746 ,898,851,850 },
		{487,489,486 ,814,469,815 ,899,900,901 }, {487,488,489 ,814,466,469 ,899,902,900 },
		{486,499,498 ,815,471,816 ,903,904,905 }, {486,489,499 ,815,469,471 ,903,906,904 },
		{498,501,500 ,816,473,817 ,907,908,909 }, {498,499,501 ,816,471,473 ,907,910,908 },
		{500,513,512 ,817,475,818 ,911,912,913 }, {500,501,513 ,817,473,475 ,911,914,912 },
		{512,517,516 ,818,477,819 ,915,916,917 }, {512,513,517 ,818,475,477 ,915,918,916 },
		{516,528,527 ,819,479,820 ,919,920,921 }, {516,517,528 ,819,477,479 ,919,922,920 },
		{527,529,526 ,820,481,821 ,923,924,925 }, {527,528,529 ,820,479,481 ,923,926,924 },
		{526,541,540 ,821,483,822 ,927,928,929 }, {526,529,541 ,821,481,483 ,927,930,928 },
		{540,553,552 ,822,485,823 ,931,932,933 }, {540,541,553 ,822,483,485 ,931,934,932 },
		{552,551,550 ,823,487,824 ,935,936,937 }, {552,553,551 ,823,485,487 ,935,938,936 },
		{550,568,567 ,824,489,825 ,939,940,941 }, {550,551,568 ,824,487,489 ,939,942,940 },
		{567,569,566 ,825,491,826 ,943,944,945 }, {567,568,569 ,825,489,491 ,943,946,944 },
		{569,564,566 ,491,827,826 ,947,948,949 }, {569,565,564 ,491,492,827 ,947,950,948 },
		{565,548,564 ,492,828,827 ,951,952,953 }, {565,549,548 ,492,494,828 ,951,954,952 },
		{549,546,548 ,494,829,828 ,955,956,957 }, {549,547,546 ,494,496,829 ,955,958,956 },
		{547,538,546 ,496,830,829 ,959,960,961 }, {547,539,538 ,496,452,830 ,959,962,960 },
		{539,523,538 ,452,831,830 ,963,964,965 }, {539,524,523 ,452,451,831 ,963,966,964 },
		{524,522,523 ,451,832,831 ,967,968,969 }, {524,525,522 ,451,454,832 ,967,970,968 },
		{525,514,522 ,454,833,832 ,971,972,973 }, {525,515,514 ,454,456,833 ,971,974,972 },
		{515,510,514 ,456,834,833 ,975,976,977 }, {515,511,510 ,456,458,834 ,975,978,976 },
		{511,494,510 ,458,835,834 ,979,980,981 }, {511,495,494 ,458,460,835 ,979,982,980 },
		{495,496,494 ,460,836,835 ,983,984,985 }, {495,497,496 ,460,462,836 ,983,986,984 },
		{497,484,496 ,462,837,836 ,987,988,989 }, {497,485,484 ,462,464,837 ,987,990,988 },
		{485,487,484 ,464,814,837 ,991,992,993 }, {485,488,487 ,464,466,814 ,991,994,992 },
		{646,667,647 ,303,838,839 ,995,996,997 }, {646,668,667 ,303,840,838 ,995,998,996 },
		{647,669,644 ,839,841,842 ,999,1000,1001 }, {647,667,669 ,839,838,841 ,999,996,1000 },
		{663,646,645 ,843,303,844 ,1002,1003,1004 }, {663,668,646 ,843,840,303 ,1002,998,1003 },
		{664,645,642 ,845,844,846 ,1005,1006,1007 }, {664,663,645 ,845,843,844 ,1005,1002,1006 },
		{644,670,643 ,842,847,309 ,1008,1009,1010 }, {644,669,670 ,842,841,847 ,1008,1000,1009 },
		{643,671,640 ,309,848,849 ,1011,1012,1013 }, {643,670,671 ,309,847,848 ,1011,1009,1012 },
		{665,642,641 ,850,846,723 ,1014,1015,1016 }, {665,664,642 ,850,845,846 ,1014,1005,1015 },
		{666,641,639 ,851,723,852 ,1017,1018,1019 }, {666,665,641 ,851,850,723 ,1017,1014,1018 },
		{640,661,638 ,849,853,854 ,1020,1021,1022 }, {640,671,661 ,849,848,853 ,1020,1012,1021 },
		{659,639,637 ,855,852,856 ,1023,1024,1025 }, {659,666,639 ,855,851,852 ,1023,1017,1024 },
		{638,662,636 ,854,857,858 ,1026,1027,1028 }, {638,661,662 ,854,853,857 ,1026,1029,1027 },
		{660,637,635 ,859,856,860 ,1030,1031,1032 }, {660,659,637 ,859,855,856 ,1030,1023,1031 },
		{662,634,636 ,857,270,858 ,1033,1034,1035 }, {662,657,634 ,857,861,270 ,1033,1036,1034 },
		{633,660,635 ,290,859,860 ,1037,1030,1038 }, {633,655,660 ,290,862,859 ,1037,1039,1030 },
		{657,632,634 ,861,863,270 ,1036,1040,1041 }, {657,658,632 ,861,864,863 ,1036,1042,1040 },
		{631,655,633 ,865,862,290 ,1043,1039,1044 }, {631,656,655 ,865,866,862 ,1043,1045,1039 },
		{658,630,632 ,864,274,863 ,1042,1046,1047 }, {658,651,630 ,864,867,274 ,1042,1048,1046 },
		{629,656,631 ,732,866,865 ,1049,1045,1050 }, {629,648,656 ,732,868,866 ,1049,1051,1045 },
		{651,628,630 ,867,869,274 ,1048,1052,1053 }, {651,652,628 ,867,870,869 ,1048,1054,1052 },
		{627,648,629 ,871,868,732 ,1055,1051,1056 }, {627,649,648 ,871,872,868 ,1055,1057,1051 },
		{652,626,628 ,870,873,869 ,1054,1058,1059 }, {652,653,626 ,870,874,873 ,1054,1060,1058 },
		{624,649,627 ,875,872,871 ,1061,1057,1062 }, {624,650,649 ,875,876,872 ,1061,1063,1057 },
		{653,625,626 ,874,280,873 ,1060,1064,1065 }, {653,654,625 ,874,877,280 ,1060,1066,1064 },
		{625,650,624 ,280,876,875 ,1067,1063,1068 }, {625,654,650 ,280,877,876 ,1067,1066,1063 },
		{695,652,651 ,878,870,867 ,1069,1054,1048 }, {695,672,652 ,878,879,870 ,1069,1070,1054 },
		{672,653,652 ,879,874,870 ,1070,1060,1054 }, {672,673,653 ,879,880,874 ,1070,1071,1060 },
		{673,654,653 ,880,877,874 ,1071,1066,1060 }, {673,674,654 ,880,881,877 ,1071,1072,1066 },
		{654,675,650 ,877,882,876 ,1066,1073,1063 }, {654,674,675 ,877,881,882 ,1066,1072,1073 },
		{650,676,649 ,876,883,872 ,1063,1074,1057 }, {650,675,676 ,876,882,883 ,1063,1073,1074 },
		{649,677,648 ,872,884,868 ,1057,1075,1051 }, {649,676,677 ,872,883,884 ,1057,1074,1075 },
		{648,678,656 ,868,885,866 ,1051,1076,1045 }, {648,677,678 ,868,884,885 ,1051,1075,1076 },
		{656,679,655 ,866,886,862 ,1045,1077,1039 }, {656,678,679 ,866,885,886 ,1045,1076,1077 },
		{655,680,660 ,862,887,859 ,1039,1078,1030 }, {655,679,680 ,862,886,887 ,1039,1077,1078 },
		{660,681,659 ,859,888,855 ,1030,1079,1023 }, {660,680,681 ,859,887,888 ,1030,1078,1079 },
		{659,682,666 ,855,889,851 ,1023,1080,1017 }, {659,681,682 ,855,888,889 ,1023,1079,1080 },
		{666,683,665 ,851,890,850 ,1017,1081,1014 }, {666,682,683 ,851,889,890 ,1017,1080,1081 },
		{665,684,664 ,850,891,845 ,1014,1082,1005 }, {665,683,684 ,850,890,891 ,1014,1081,1082 },
		{664,685,663 ,845,892,843 ,1005,1083,1002 }, {664,684,685 ,845,891,892 ,1005,1082,1083 },
		{663,686,668 ,843,893,840 ,1002,1084,998 }, {663,685,686 ,843,892,893 ,1002,1083,1084 },
		{686,667,668 ,893,838,840 ,1084,996,998 }, {686,687,667 ,893,894,838 ,1084,1085,996 },
		{687,669,667 ,894,841,838 ,1085,1000,996 }, {687,688,669 ,894,895,841 ,1085,1086,1000 },
		{688,670,669 ,895,847,841 ,1086,1009,1000 }, {688,689,670 ,895,896,847 ,1086,1087,1009 },
		{689,671,670 ,896,848,847 ,1087,1012,1009 }, {689,690,671 ,896,897,848 ,1087,1088,1012 },
		{690,661,671 ,897,853,848 ,1088,1021,1012 }, {690,691,661 ,897,898,853 ,1088,1089,1021 },
		{691,662,661 ,898,857,853 ,1089,1090,1021 }, {691,692,662 ,898,899,857 ,1089,1091,1090 },
		{692,657,662 ,899,861,857 ,1092,1036,1033 }, {692,693,657 ,899,900,861 ,1092,1093,1036 },
		{693,658,657 ,900,864,861 ,1093,1042,1036 }, {693,694,658 ,900,901,864 ,1093,1094,1042 },
		{694,651,658 ,901,867,864 ,1094,1048,1042 }, {694,695,651 ,901,878,867 ,1094,1069,1048 },
		{697,765,696 ,902,903,904 ,1095,1096,1097 }, {697,764,765 ,902,905,903 ,1095,1098,1096 },
		{763,672,764 ,906,879,905 ,1099,1070,1098 }, {763,673,672 ,906,880,879 ,1099,1071,1070 },
		{699,763,698 ,907,906,908 ,1100,1099,1101 }, {699,762,763 ,907,909,906 ,1100,1102,1099 },
		{675,762,761 ,882,909,910 ,1073,1102,1103 }, {675,674,762 ,882,881,909 ,1073,1072,1102 },
		{760,701,700 ,911,912,913 ,1104,1105,1106 }, {760,761,701 ,911,910,912 ,1104,1103,1105 },
		{677,760,759 ,884,911,914 ,1075,1104,1107 }, {677,676,760 ,884,883,911 ,1075,1074,1104 },
		{758,703,702 ,915,916,917 ,1108,1109,1110 }, {758,759,703 ,915,914,916 ,1108,1107,1109 },
		{679,758,757 ,886,915,918 ,1077,1108,1111 }, {679,678,758 ,886,885,915 ,1077,1076,1108 },
		{756,705,704 ,919,920,921 ,1112,1113,1114 }, {756,757,705 ,919,918,920 ,1112,1111,1113 },
		{680,755,681 ,887,922,888 ,1078,1115,1079 }, {680,756,755 ,887,919,922 ,1078,1112,1115 },
		{755,706,754 ,922,923,924 ,1115,1116,1117 }, {755,707,706 ,922,925,923 ,1115,1118,1116 },
		{682,753,683 ,889,926,890 ,1080,1119,1081 }, {682,754,753 ,889,924,926 ,1080,1117,1119 },
		{753,708,752 ,926,927,928 ,1119,1120,1121 }, {753,709,708 ,926,929,927 ,1119,1122,1120 },
		{684,751,685 ,891,930,892 ,1082,1123,1083 }, {684,752,751 ,891,928,930 ,1082,1121,1123 },
		{751,710,750 ,930,931,932 ,1123,1124,1125 }, {751,711,710 ,930,933,931 ,1123,1126,1124 },
		{750,687,686 ,932,894,893 ,1125,1085,1084 }, {750,749,687 ,932,934,894 ,1125,1127,1085 },
		{713,748,749 ,935,936,934 ,1128,1129,1127 }, {713,712,748 ,935,937,936 ,1128,1130,1129 },
		{748,689,688 ,936,896,895 ,1129,1087,1086 }, {748,747,689 ,936,938,896 ,1129,1131,1087 },
		{715,746,747 ,939,940,938 ,1132,1133,1131 }, {715,714,746 ,939,941,940 ,1132,1134,1133 },
		{746,691,690 ,940,898,897 ,1133,1089,1088 }, {746,745,691 ,940,942,898 ,1133,1135,1089 },
		{717,744,745 ,943,944,942 ,1136,1137,1135 }, {717,716,744 ,943,945,944 ,1136,1138,1137 },
		{767,692,744 ,946,899,944 ,1139,1092,1140 }, {767,693,692 ,946,900,899 ,1139,1093,1092 },
		{719,767,718 ,947,946,948 ,1141,1139,1142 }, {719,766,767 ,947,949,946 ,1141,1143,1139 },
		{765,694,766 ,903,901,949 ,1096,1094,1143 }, {765,695,694 ,903,878,901 ,1096,1069,1094 },
		{721,696,720 ,950,904,951 ,1144,1097,1145 }, {721,697,696 ,950,902,904 ,1144,1095,1097 },
		{768,764,774 ,14,905,16 ,1146,1098,0 }, {768,763,764 ,14,906,905 ,1146,1099,1098 },
		{723,698,722 ,952,908,953 ,1147,1101,1148 }, {723,699,698 ,952,907,908 ,1147,1100,1101 },
		{761,775,776 ,910,12,10 ,1103,1149,1150 }, {761,762,775 ,910,909,12 ,1103,1102,1149 },
		{700,725,724 ,913,954,955 ,1106,1151,1152 }, {700,701,725 ,913,912,954 ,1106,1105,1151 },
		{759,777,779 ,914,8,6 ,1107,1153,1154 }, {759,760,777 ,914,911,8 ,1107,1104,1153 },
		{702,727,726 ,917,956,957 ,1110,1155,1156 }, {702,703,727 ,917,916,956 ,1110,1109,1155 },
		{757,778,780 ,918,4,1 ,1111,1157,1158 }, {757,758,778 ,918,915,4 ,1111,1108,1157 },
		{704,729,728 ,921,958,959 ,1114,1159,1160 }, {704,705,729 ,921,920,958 ,1114,1113,1159 },
		{755,781,782 ,922,3,2 ,1115,1161,1162 }, {755,756,781 ,922,919,3 ,1115,1112,1161 },
		{706,731,730 ,923,960,961 ,1116,1163,1164 }, {706,707,731 ,923,925,960 ,1116,1118,1163 },
		{753,784,783 ,926,5,7 ,1119,1165,1166 }, {753,754,784 ,926,924,5 ,1119,1117,1165 },
		{708,733,732 ,927,962,963 ,1120,1167,1168 }, {708,709,733 ,927,929,962 ,1120,1122,1167 },
		{751,785,786 ,930,9,11 ,1123,1169,1170 }, {751,752,785 ,930,928,9 ,1123,1121,1169 },
		{710,735,734 ,931,964,965 ,1124,1171,1172 }, {710,711,735 ,931,933,964 ,1124,1126,1171 },
		{769,750,787 ,15,932,13 ,1173,1125,1174 }, {769,749,750 ,15,934,932 ,1173,1127,1125 },
		{737,713,736 ,966,935,967 ,1175,1128,1176 }, {737,712,713 ,966,937,935 ,1175,1130,1128 },
		{770,748,788 ,19,936,17 ,1177,1129,1178 }, {770,747,748 ,19,938,936 ,1177,1131,1129 },
		{739,715,738 ,968,939,969 ,1179,1132,1180 }, {739,714,715 ,968,941,939 ,1179,1134,1132 },
		{771,746,789 ,22,940,20 ,1181,1133,1182 }, {771,745,746 ,22,942,940 ,1181,1135,1133 },
		{741,717,740 ,970,943,971 ,1183,1136,1184 }, {741,716,717 ,970,945,943 ,1183,1185,1136 },
		{772,744,790 ,23,944,24 ,1186,1140,1187 }, {772,767,744 ,23,946,944 ,1186,1139,1140 },
		{743,718,742 ,972,948,973 ,1188,1142,1189 }, {743,719,718 ,972,947,948 ,1188,1141,1142 },
		{773,766,791 ,18,949,21 ,1190,1143,1191 }, {773,765,766 ,18,903,949 ,1190,1096,1143 },
		{774,720,773 ,16,951,18 ,0,1145,1192 }, {774,721,720 ,16,950,951 ,0,1144,1145 },
		{775,722,768 ,12,953,14 ,1193,1148,1194 }, {775,723,722 ,12,952,953 ,1193,1147,1148 },
		{724,776,777 ,955,10,8 ,1152,1195,1196 }, {724,725,776 ,955,954,10 ,1152,1151,1195 },
		{726,779,778 ,957,6,4 ,1156,1197,1198 }, {726,727,779 ,957,956,6 ,1156,1155,1197 },
		{728,780,781 ,959,1,3 ,1160,1199,1200 }, {728,729,780 ,959,958,1 ,1160,1159,1199 },
		{730,782,784 ,961,2,5 ,1164,1201,1202 }, {730,731,782 ,961,960,2 ,1164,1163,1201 },
		{732,783,785 ,963,7,9 ,1168,1203,1204 }, {732,733,783 ,963,962,7 ,1168,1167,1203 },
		{734,786,787 ,965,11,13 ,1172,1205,1206 }, {734,735,786 ,965,964,11 ,1172,1171,1205 },
		{788,736,769 ,17,967,15 ,1178,1176,1173 }, {788,737,736 ,17,966,967 ,1178,1175,1176 },
		{789,738,770 ,20,969,19 ,1182,1180,1177 }, {789,739,738 ,20,968,969 ,1182,1179,1180 },
		{790,740,771 ,24,971,22 ,1207,1184,1181 }, {790,741,740 ,24,970,971 ,1207,1208,1184 },
		{791,742,772 ,21,973,23 ,1209,1189,1186 }, {791,743,742 ,21,972,973 ,1209,1188,1189 },
		{764,695,765 ,905,878,903 ,1098,1069,1096 }, {764,672,695 ,905,879,878 ,1098,1070,1069 },
		{762,673,763 ,909,880,906 ,1102,1071,1099 }, {762,674,673 ,909,881,880 ,1102,1072,1071 },
		{676,761,760 ,883,910,911 ,1074,1103,1104 }, {676,675,761 ,883,882,910 ,1074,1073,1103 },
		{678,759,758 ,885,914,915 ,1076,1107,1108 }, {678,677,759 ,885,884,914 ,1076,1075,1107 },
		{680,757,756 ,887,918,919 ,1078,1111,1112 }, {680,679,757 ,887,886,918 ,1078,1077,1111 },
		{682,755,754 ,889,922,924 ,1080,1115,1117 }, {682,681,755 ,889,888,922 ,1080,1079,1115 },
		{684,753,752 ,891,926,928 ,1082,1119,1121 }, {684,683,753 ,891,890,926 ,1082,1081,1119 },
		{686,751,750 ,893,930,932 ,1084,1123,1125 }, {686,685,751 ,893,892,930 ,1084,1083,1123 },
		{748,687,749 ,936,894,934 ,1129,1085,1127 }, {748,688,687 ,936,895,894 ,1129,1086,1085 },
		{746,689,747 ,940,896,938 ,1133,1087,1131 }, {746,690,689 ,940,897,896 ,1133,1088,1087 },
		{744,691,745 ,944,898,942 ,1210,1089,1135 }, {744,692,691 ,944,899,898 ,1210,1091,1089 },
		{766,693,767 ,949,900,946 ,1143,1093,1139 }, {766,694,693 ,949,901,900 ,1143,1094,1093 },
		{696,773,720 ,315,315,315 ,1097,1192,1145 }, {696,765,773 ,315,315,315 ,1097,1096,1192 },
		{774,697,721 ,974,974,975 ,1211,1095,1144 }, {774,764,697 ,974,976,974 ,1211,1098,1095 },
		{775,699,723 ,860,860,860 ,1212,1100,1147 }, {775,762,699 ,860,860,860 ,1212,1102,1100 },
		{703,779,727 ,977,977,977 ,1213,1214,1215 }, {703,759,779 ,977,977,977 ,1213,1216,1214 },
		{707,782,731 ,978,978,979 ,1118,1217,1163 }, {707,755,782 ,978,980,978 ,1118,1115,1217 },
		{784,706,730 ,981,981,982 ,1218,1116,1164 }, {784,754,706 ,981,983,981 ,1218,1117,1116 },
		{709,783,733 ,984,984,984 ,1122,1219,1167 }, {709,753,783 ,984,984,984 ,1122,1119,1219 },
		{785,708,732 ,985,985,986 ,1220,1221,1222 }, {785,752,708 ,985,987,985 ,1220,1223,1221 },
		{711,786,735 ,988,988,989 ,1126,1224,1171 }, {711,751,786 ,988,990,988 ,1126,1123,1224 },
		{787,710,734 ,858,858,858 ,1174,1124,1172 }, {787,750,710 ,858,858,858 ,1174,1125,1124 },
		{713,769,736 ,991,991,992 ,1128,1173,1176 }, {713,749,769 ,991,993,991 ,1128,1127,1173 },
		{788,712,737 ,994,994,995 ,1178,1130,1175 }, {788,748,712 ,994,996,994 ,1178,1129,1130 },
		{715,770,738 ,322,322,322 ,1132,1177,1180 }, {715,747,770 ,322,322,322 ,1132,1131,1177 },
		{789,714,739 ,997,997,998 ,1182,1134,1179 }, {789,746,714 ,997,999,997 ,1182,1133,1134 },
		{717,771,740 ,1000,1000,1001 ,1136,1225,1184 }, {717,745,771 ,1000,1002,1000 ,1136,1135,1225 },
		{790,716,741 ,280,280,280 ,1226,1227,1228 }, {790,744,716 ,280,280,280 ,1226,1229,1227 },
		{718,772,742 ,1003,1003,1004 ,1142,1186,1189 }, {718,767,772 ,1003,1005,1003 ,1142,1139,1186 },
		{791,719,743 ,1006,1006,1007 ,1230,1141,1188 }, {791,766,719 ,1006,1008,1006 ,1230,1143,1141 },
		{705,780,729 ,1009,1009,1010 ,1113,1231,1159 }, {705,757,780 ,1009,1011,1009 ,1113,1111,1231 },
		{781,704,728 ,303,303,303 ,1232,1114,1160 }, {781,756,704 ,303,303,303 ,1232,1112,1114 },
		{778,702,726 ,1012,1012,1013 ,1233,1110,1156 }, {778,758,702 ,1012,1014,1012 ,1233,1108,1110 },
		{777,700,724 ,1015,1015,1016 ,1196,1106,1152 }, {777,760,700 ,1015,1017,1015 ,1196,1104,1106 },
		{701,776,725 ,1018,1018,1019 ,1105,1234,1151 }, {701,761,776 ,1018,1020,1018 ,1105,1103,1234 },
		{698,768,722 ,1021,1021,1022 ,1101,1235,1148 }, {698,763,768 ,1021,1023,1021 ,1101,1099,1235 },
		{838,840,839 ,145,145,145 ,1236,1237,1238 }, {840,838,841 ,145,145,145 ,1237,1236,1239 },
		{837,841,838 ,145,145,145 ,1240,1239,1236 }, {841,837,842 ,145,145,145 ,1239,1240,1241 },
		{836,842,837 ,145,145,145 ,1242,1241,1240 }, {842,836,843 ,145,145,145 ,1241,1242,1243 },
		{835,843,836 ,145,145,145 ,1244,1243,1242 }, {843,835,844 ,145,145,145 ,1243,1244,1245 },
		{834,844,835 ,145,145,145 ,1246,1245,1244 }, {844,834,845 ,145,145,145 ,1245,1246,1247 },
		{833,845,834 ,145,145,145 ,1248,1247,1246 }, {845,833,846 ,145,145,145 ,1247,1248,1249 },
		{832,846,833 ,145,145,145 ,1250,1249,1248 }, {846,832,847 ,145,145,145 ,1249,1250,1251 },
		{831,847,832 ,145,145,145 ,1252,1251,1250 }, {847,831,848 ,145,145,145 ,1251,1252,1253 },
		{830,848,831 ,145,145,145 ,1254,1253,1252 }, {848,830,825 ,145,145,145 ,1253,1254,1255 },
		{829,825,830 ,145,145,145 ,1256,1255,1254 }, {825,829,826 ,145,145,145 ,1255,1256,1257 },
		{828,826,829 ,145,145,145 ,1258,1257,1256 }, {827,826,828 ,145,145,145 ,1259,1257,1258 },
		{18,858,17 ,38,1024,36 ,62,1260,60 }, {18,859,858 ,38,1025,1024 ,62,1261,1260 },
		{859,278,858 ,1025,1026,1024 ,1261,218,1260 }, {859,277,278 ,1025,1027,1026 ,1261,216,218 },
		{19,859,18 ,40,1025,38 ,64,1261,62 }, {19,860,859 ,40,1028,1025 ,64,1262,1261 },
		{860,277,859 ,1028,1027,1025 ,1262,216,1261 }, {860,276,277 ,1028,1029,1027 ,1262,214,216 },
		{20,860,19 ,42,1028,40 ,66,1262,64 }, {20,861,860 ,42,1030,1028 ,66,1263,1262 },
		{861,276,860 ,1030,1029,1028 ,1263,214,1262 }, {861,145,276 ,1030,1031,1029 ,1263,211,214 },
		{21,861,20 ,44,1030,42 ,68,1263,66 }, {21,862,861 ,44,1032,1030 ,68,1264,1263 },
		{862,145,861 ,1032,1031,1030 ,1264,211,1263 }, {862,275,145 ,1032,1033,1031 ,1264,209,211 },
		{22,862,21 ,46,1032,44 ,70,1264,68 }, {22,863,862 ,46,1034,1032 ,70,1265,1264 },
		{863,275,862 ,1034,1033,1032 ,1265,209,1264 }, {863,274,275 ,1034,1035,1033 ,1265,206,209 },
		{23,863,22 ,48,1034,46 ,72,1265,70 }, {23,864,863 ,48,1036,1034 ,72,1266,1265 },
		{864,274,863 ,1036,1035,1034 ,1266,206,1265 }, {864,273,274 ,1036,1037,1035 ,1266,204,206 },
		{0,864,23 ,50,1036,48 ,74,1266,72 }, {0,865,864 ,50,1038,1036 ,74,1267,1266 },
		{865,273,864 ,1038,1037,1036 ,1267,204,1266 }, {865,144,273 ,1038,1039,1037 ,1267,199,204 },
		{1,865,0 ,52,1038,50 ,76,1267,74 }, {1,866,865 ,52,1040,1038 ,76,1268,1267 },
		{866,144,865 ,1040,1039,1038 ,1268,199,1267 }, {866,155,144 ,1040,1041,1039 ,1268,202,199 },
		{2,866,1 ,54,1040,52 ,78,1268,76 }, {2,867,866 ,54,1042,1040 ,78,1269,1268 },
		{867,155,866 ,1042,1041,1040 ,1269,202,1268 }, {867,154,155 ,1042,1043,1041 ,1269,255,202 },
		{3,867,2 ,56,1042,54 ,80,1269,78 }, {3,868,867 ,56,1044,1042 ,80,1270,1269 },
		{868,154,867 ,1044,1043,1042 ,1270,255,1269 }, {868,153,154 ,1044,1045,1043 ,1270,253,255 },
		{4,868,3 ,58,1044,56 ,82,1270,80 }, {4,869,868 ,58,1046,1044 ,82,1271,1270 },
		{869,153,868 ,1046,1045,1044 ,1271,253,1270 }, {869,152,153 ,1046,1047,1045 ,1271,250,253 },
		{5,869,4 ,60,1046,58 ,84,1271,82 }, {5,870,869 ,60,1048,1046 ,84,1272,1271 },
		{870,152,869 ,1048,1047,1046 ,1272,250,1271 }, {870,272,152 ,1048,1049,1047 ,1272,248,250 },
		{6,870,5 ,62,1048,60 ,86,1272,84 }, {6,871,870 ,62,1050,1048 ,86,1273,1272 },
		{871,272,870 ,1050,1049,1048 ,1273,248,1272 }, {871,271,272 ,1050,1051,1049 ,1273,247,248 },
		{7,871,6 ,64,1050,62 ,88,1273,86 }, {7,872,871 ,64,1052,1050 ,88,1274,1273 },
		{872,271,871 ,1052,1051,1050 ,1274,247,1273 }, {872,270,271 ,1052,1053,1051 ,1274,244,247 },
		{8,872,7 ,66,1052,64 ,90,1274,88 }, {8,873,872 ,66,1054,1052 ,90,1275,1274 },
		{873,270,872 ,1054,1053,1052 ,1275,244,1274 }, {873,151,270 ,1054,1055,1053 ,1275,242,244 },
		{9,873,8 ,68,1054,66 ,92,1275,90 }, {9,874,873 ,68,1056,1054 ,92,1276,1275 },
		{874,151,873 ,1056,1055,1054 ,1276,242,1275 }, {874,150,151 ,1056,1057,1055 ,1276,240,242 },
		{10,874,9 ,70,1056,68 ,94,1276,92 }, {10,875,874 ,70,1058,1056 ,94,1277,1276 },
		{875,150,874 ,1058,1057,1056 ,1277,240,1276 }, {875,149,150 ,1058,1059,1057 ,1277,238,240 },
		{11,875,10 ,72,1058,70 ,96,1277,94 }, {11,876,875 ,72,1060,1058 ,96,1278,1277 },
		{876,149,875 ,1060,1059,1058 ,1278,238,1277 }, {876,148,149 ,1060,1061,1059 ,1278,236,238 },
		{12,876,11 ,26,1060,72 ,98,1278,96 }, {12,877,876 ,26,1062,1060 ,98,1279,1278 },
		{877,148,876 ,1062,1061,1060 ,1279,236,1278 }, {877,147,148 ,1062,1063,1061 ,1279,234,236 },
		{13,877,12 ,28,1062,26 ,52,1280,50 }, {13,878,877 ,28,1064,1062 ,52,1281,1280 },
		{878,147,877 ,1064,1063,1062 ,1281,231,1280 }, {878,281,147 ,1064,1065,1063 ,1281,228,231 },
		{14,878,13 ,30,1064,28 ,54,1281,52 }, {14,879,878 ,30,1066,1064 ,54,1282,1281 },
		{879,281,878 ,1066,1065,1064 ,1282,228,1281 }, {879,280,281 ,1066,1067,1065 ,1282,226,228 },
		{15,879,14 ,32,1066,30 ,56,1282,54 }, {15,880,879 ,32,1068,1066 ,56,1283,1282 },
		{880,280,879 ,1068,1067,1066 ,1283,226,1282 }, {880,279,280 ,1068,1069,1067 ,1283,223,226 },
		{16,880,15 ,34,1068,32 ,58,1283,56 }, {16,881,880 ,34,1070,1068 ,58,1284,1283 },
		{881,279,880 ,1070,1069,1068 ,1284,223,1283 }, {881,146,279 ,1070,1071,1069 ,1284,221,223 },
		{17,881,16 ,36,1070,34 ,60,1284,58 }, {17,858,881 ,36,1024,1070 ,60,1260,1284 },
		{858,146,881 ,1024,1071,1070 ,1260,221,1284 }, {858,278,146 ,1024,1026,1071 ,1260,218,221 },
		{49,882,50 ,73,1072,75 ,99,1285,101 }, {49,883,882 ,73,1073,1072 ,99,1286,1285 },
		{883,98,882 ,1073,1074,1072 ,1286,1287,1285 }, {883,97,98 ,1073,1075,1074 ,1286,1288,1287 },
		{48,883,49 ,74,1073,73 ,100,1286,99 }, {48,884,883 ,74,1076,1073 ,100,1289,1286 },
		{884,97,883 ,1076,1075,1073 ,1289,1288,1286 }, {884,96,97 ,1076,1077,1075 ,1289,1290,1288 },
		{71,884,48 ,96,1076,74 ,123,1289,100 }, {71,885,884 ,96,1078,1076 ,123,1291,1289 },
		{885,96,884 ,1078,1077,1076 ,1291,1290,1289 }, {885,119,96 ,1078,1079,1077 ,1291,1292,1290 },
		{70,885,71 ,95,1078,96 ,122,1291,123 }, {70,886,885 ,95,1080,1078 ,122,1293,1291 },
		{886,119,885 ,1080,1079,1078 ,1293,1292,1291 }, {886,118,119 ,1080,1081,1079 ,1293,1294,1292 },
		{69,886,70 ,94,1080,95 ,121,1293,122 }, {69,887,886 ,94,1082,1080 ,121,1295,1293 },
		{887,118,886 ,1082,1081,1080 ,1295,1294,1293 }, {887,117,118 ,1082,1083,1081 ,1295,1296,1294 },
		{68,887,69 ,93,1082,94 ,119,1295,121 }, {68,888,887 ,93,1084,1082 ,119,1297,1295 },
		{888,117,887 ,1084,1083,1082 ,1297,1296,1295 }, {888,116,117 ,1084,1085,1083 ,1297,1298,1296 },
		{67,888,68 ,92,1084,93 ,120,1297,119 }, {67,889,888 ,92,1086,1084 ,120,1299,1297 },
		{889,116,888 ,1086,1085,1084 ,1300,1298,1297 }, {889,115,116 ,1086,1087,1085 ,1300,1301,1298 },
		{66,889,67 ,91,1086,92 ,117,1302,118 }, {66,890,889 ,91,1088,1086 ,117,1303,1302 },
		{890,115,889 ,1088,1087,1086 ,1303,1304,1302 }, {890,114,115 ,1088,1089,1087 ,1303,1305,1304 },
		{65,890,66 ,90,1088,91 ,116,1303,117 }, {65,891,890 ,90,1090,1088 ,116,1306,1303 },
		{891,114,890 ,1090,1089,1088 ,1306,1305,1303 }, {891,113,114 ,1090,1091,1089 ,1306,1307,1305 },
		{64,891,65 ,89,1090,90 ,115,1306,116 }, {64,892,891 ,89,1092,1090 ,115,1308,1306 },
		{892,113,891 ,1092,1091,1090 ,1308,1307,1306 }, {892,112,113 ,1092,1093,1091 ,1308,1309,1307 },
		{63,892,64 ,88,1092,89 ,114,1308,115 }, {63,893,892 ,88,1094,1092 ,114,1310,1308 },
		{893,112,892 ,1094,1093,1092 ,1310,1309,1308 }, {893,111,112 ,1094,1095,1093 ,1310,1311,1309 },
		{62,893,63 ,87,1094,88 ,113,1310,114 }, {62,894,893 ,87,1096,1094 ,113,1312,1310 },
		{894,111,893 ,1096,1095,1094 ,1312,1311,1310 }, {894,110,111 ,1096,1097,1095 ,1312,1313,1311 },
		{61,894,62 ,86,1096,87 ,112,1312,113 }, {61,895,894 ,86,1098,1096 ,112,1314,1312 },
		{895,110,894 ,1098,1097,1096 ,1314,1313,1312 }, {895,109,110 ,1098,1099,1097 ,1314,1315,1313 },
		{60,895,61 ,85,1098,86 ,111,1314,112 }, {60,896,895 ,85,1100,1098 ,111,1316,1314 },
		{896,109,895 ,1100,1099,1098 ,1316,1315,1314 }, {896,108,109 ,1100,1101,1099 ,1316,1317,1315 },
		{59,896,60 ,84,1100,85 ,110,1316,111 }, {59,897,896 ,84,1102,1100 ,110,1318,1316 },
		{897,108,896 ,1102,1101,1100 ,1318,1317,1316 }, {897,107,108 ,1102,1103,1101 ,1318,1319,1317 },
		{58,897,59 ,83,1102,84 ,109,1318,110 }, {58,898,897 ,83,1104,1102 ,109,1320,1318 },
		{898,107,897 ,1104,1103,1102 ,1320,1319,1318 }, {898,106,107 ,1104,1105,1103 ,1320,1321,1319 },
		{57,898,58 ,82,1104,83 ,108,1320,109 }, {57,899,898 ,82,1106,1104 ,108,1322,1320 },
		{899,106,898 ,1106,1105,1104 ,1322,1321,1320 }, {899,105,106 ,1106,1107,1105 ,1322,1323,1321 },
		{56,899,57 ,81,1106,82 ,107,1322,108 }, {56,900,899 ,81,1108,1106 ,107,1324,1322 },
		{900,105,899 ,1108,1107,1106 ,1324,1323,1322 }, {900,104,105 ,1108,1109,1107 ,1324,1325,1323 },
		{55,900,56 ,80,1108,81 ,106,1324,107 }, {55,901,900 ,80,1110,1108 ,106,1326,1324 },
		{901,104,900 ,1110,1109,1108 ,1326,1325,1324 }, {901,103,104 ,1110,1111,1109 ,1326,1327,1325 },
		{54,901,55 ,79,1110,80 ,105,1326,106 }, {54,902,901 ,79,1112,1110 ,105,1328,1326 },
		{902,103,901 ,1112,1111,1110 ,1328,1327,1326 }, {902,102,103 ,1112,1113,1111 ,1328,1329,1327 },
		{53,902,54 ,78,1112,79 ,104,1328,105 }, {53,903,902 ,78,1114,1112 ,104,1330,1328 },
		{903,102,902 ,1114,1113,1112 ,1330,1329,1328 }, {903,101,102 ,1114,1115,1113 ,1330,1331,1329 },
		{52,903,53 ,77,1114,78 ,103,1330,104 }, {52,904,903 ,77,1116,1114 ,103,1332,1330 },
		{904,101,903 ,1116,1115,1114 ,1332,1331,1330 }, {904,100,101 ,1116,1117,1115 ,1332,1333,1331 },
		{51,904,52 ,76,1116,77 ,102,1332,103 }, {51,905,904 ,76,1118,1116 ,102,1334,1332 },
		{905,100,904 ,1118,1117,1116 ,1334,1333,1332 }, {905,99,100 ,1118,1119,1117 ,1334,1335,1333 },
		{50,905,51 ,75,1118,76 ,101,1334,102 }, {50,882,905 ,75,1072,1118 ,101,1285,1334 },
		{882,99,905 ,1072,1119,1118 ,1285,1335,1334 }, {882,98,99 ,1072,1074,1119 ,1285,1287,1335 }
	};
	static GLfloat vertices [906][3] = {
	{0.05f,0.0f,0.0585f},{0.0482963f,0.012941f,0.0585f},{0.0433013f,0.025f,0.0585f},
	{0.0353553f,0.0353553f,0.0585f},{0.025f,0.0433013f,0.0585f},{0.012941f,0.0482963f,0.0585f},
	{0.0f,0.05f,0.0585f},{-0.012941f,0.0482963f,0.0585f},{-0.025f,0.0433013f,0.0585f},
	{-0.0353553f,0.0353553f,0.0585f},{-0.0433013f,0.025f,0.0585f},{-0.0482963f,0.012941f,0.0585f},
	{-0.05f,0.0f,0.0585f},{-0.0482963f,-0.012941f,0.0585f},{-0.0433013f,-0.025f,0.0585f},
	{-0.0353553f,-0.0353553f,0.0585f},{-0.025f,-0.0433013f,0.0585f},{-0.012941f,-0.0482963f,0.0585f},
	{0.0f,-0.05f,0.0585f},{0.012941f,-0.0482963f,0.0585f},{0.025f,-0.0433013f,0.0585f},
	{0.0353553f,-0.0353553f,0.0585f},{0.0433013f,-0.025f,0.0585f},{0.0482963f,-0.012941f,0.0585f},
	{-0.054f,0.0f,0.054f},{-0.05216f,-0.0139762f,0.054f},{-0.0467654f,-0.027f,0.054f},
	{-0.0381838f,-0.0381838f,0.054f},{-0.027f,-0.0467654f,0.054f},{-0.0139762f,-0.05216f,0.054f},
	{0.0f,-0.054f,0.054f},{0.0139762f,-0.05216f,0.054f},{0.027f,-0.0467654f,0.054f},
	{0.0381838f,-0.0381838f,0.054f},{0.0467654f,-0.027f,0.054f},{0.05216f,-0.0139762f,0.054f},
	{0.054f,0.0f,0.054f},{0.05216f,0.0139762f,0.054f},{0.0467654f,0.027f,0.054f},
	{0.0381838f,0.0381838f,0.054f},{0.027f,0.0467654f,0.054f},{0.0139762f,0.05216f,0.054f},
	{0.0f,0.054f,0.054f},{-0.0139762f,0.05216f,0.054f},{-0.027f,0.0467654f,0.054f},
	{-0.0381838f,0.0381838f,0.054f},{-0.0467654f,0.027f,0.054f},{-0.05216f,0.0139762f,0.054f},
	{-0.0137174f,-0.0511941f,0.0455f},{0.0f,-0.053f,0.0455f},{0.0137174f,-0.0511941f,0.0455f},
	{0.0265f,-0.0458993f,0.0455f},{0.0374767f,-0.0374767f,0.0455f},{0.0458993f,-0.0265f,0.0455f},
	{0.0511941f,-0.0137174f,0.0455f},{0.053f,0.0f,0.0455f},{0.0511941f,0.0137174f,0.0455f},
	{0.0458993f,0.0265f,0.0455f},{0.0374767f,0.0374767f,0.0455f},{0.0265f,0.0458993f,0.0455f},
	{0.0137174f,0.0511941f,0.0455f},{0.0f,0.053f,0.0455f},{-0.0137174f,0.0511941f,0.0455f},
	{-0.0265f,0.0458993f,0.0455f},{-0.0374767f,0.0374767f,0.0455f},{-0.0458993f,0.0265f,0.0455f},
	{-0.0511941f,0.0137174f,0.0455f},{-0.053f,0.0f,0.0455f},{-0.0511941f,-0.0137174f,0.0455f},
	{-0.0458993f,-0.0265f,0.0455f},{-0.0374767f,-0.0374767f,0.0455f},{-0.0265f,-0.0458993f,0.0455f},
	{-0.0225f,-0.0389711f,0.00525f},{-0.0116469f,-0.0434667f,0.00525f},{0.0f,-0.045f,0.00525f},
	{0.0116469f,-0.0434667f,0.00525f},{0.0225f,-0.0389711f,0.00525f},{0.0318198f,-0.0318198f,0.00525f},
	{0.0389711f,-0.0225f,0.00525f},{0.0434667f,-0.0116469f,0.00525f},{0.045f,0.0f,0.00525f},
	{0.0434667f,0.0116469f,0.00525f},{0.0389711f,0.0225f,0.00525f},{0.0318198f,0.0318198f,0.00525f},
	{0.0225f,0.0389711f,0.00525f},{0.0116469f,0.0434667f,0.00525f},{0.0f,0.045f,0.00525f},
	{-0.0116469f,0.0434667f,0.00525f},{-0.0225f,0.0389711f,0.00525f},{-0.0318198f,0.0318198f,0.00525f},
	{-0.0389711f,0.0225f,0.00525f},{-0.0434667f,0.0116469f,0.00525f},{-0.045f,0.0f,0.00525f},
	{-0.0434667f,-0.0116469f,0.00525f},{-0.0389711f,-0.0225f,0.00525f},{-0.0318198f,-0.0318198f,0.00525f},
	{-0.0116469f,-0.0434667f,0.045875f},{0.0f,-0.045f,0.045875f},{0.0116469f,-0.0434667f,0.045875f},
	{0.0225f,-0.0389711f,0.045875f},{0.0318198f,-0.0318198f,0.045875f},{0.0389711f,-0.0225f,0.045875f},
	{0.0434667f,-0.0116469f,0.045875f},{0.045f,0.0f,0.045875f},{0.0434667f,0.0116469f,0.045875f},
	{0.0389711f,0.0225f,0.045875f},{0.0318198f,0.0318198f,0.045875f},{0.0225f,0.0389711f,0.045875f},
	{0.0116469f,0.0434667f,0.045875f},{0.0f,0.045f,0.045875f},{-0.0116469f,0.0434667f,0.045875f},
	{-0.0225f,0.0389711f,0.045875f},{-0.0318198f,0.0318198f,0.045875f},{-0.0389711f,0.0225f,0.045875f},
	{-0.0434667f,0.0116469f,0.045875f},{-0.045f,0.0f,0.045875f},{-0.0434667f,-0.0116469f,0.045875f},
	{-0.0389711f,-0.0225f,0.045875f},{-0.0318198f,-0.0318198f,0.045875f},{-0.0225f,-0.0389711f,0.045875f},
	{-0.023152f,-0.0401004f,0.00525f},{-0.0119843f,-0.0447262f,0.00525f},{0.0f,-0.0463039f,0.00525f},
	{0.0119843f,-0.0447262f,0.00525f},{0.023152f,-0.0401004f,0.00525f},{0.0327418f,-0.0327418f,0.00525f},
	{0.0401004f,-0.023152f,0.00525f},{0.0447262f,-0.0119843f,0.00525f},{0.0463039f,0.0f,0.00525f},
	{0.0447262f,0.0119843f,0.00525f},{0.0401004f,0.023152f,0.00525f},{0.0327418f,0.0327418f,0.00525f},
	{0.023152f,0.0401004f,0.00525f},{0.0119843f,0.0447262f,0.00525f},{0.0f,0.0463039f,0.00525f},
	{-0.0119843f,0.0447262f,0.00525f},{-0.023152f,0.0401004f,0.00525f},{-0.0327418f,0.0327418f,0.00525f},
	{-0.0401004f,0.023152f,0.00525f},{-0.0447262f,0.0119843f,0.00525f},{-0.0463039f,0.0f,0.00525f},
	{-0.0447262f,-0.0119843f,0.00525f},{-0.0401004f,-0.023152f,0.00525f},{-0.0327418f,-0.0327418f,0.00525f},
	{0.0399137f,0.0f,0.0585f},{0.0199569f,-0.0345663f,0.0585f},{-0.0199569f,-0.0345663f,0.0585f},
	{-0.0399137f,0.0f,0.0585f},{-0.0385537f,0.0103304f,0.0585f},{-0.0345663f,0.0199569f,0.0585f},
	{-0.0282233f,0.0282233f,0.0585f},{-0.0199569f,0.0345663f,0.0585f},{0.0199569f,0.0345663f,0.0585f},
	{0.0282233f,0.0282233f,0.0585f},{0.0345663f,0.0199569f,0.0585f},{0.0385537f,0.0103304f,0.0585f},
	{0.0247843f,0.0f,0.068f},{0.0239398f,-0.00641464f,0.068f},{0.0175251f,-0.0175251f,0.068f},
	{0.0123921f,-0.0214638f,0.068f},{0.00641464f,-0.0239398f,0.068f},{-0.00641464f,-0.0239398f,0.068f},
	{-0.0123921f,-0.0214638f,0.068f},{-0.0175251f,-0.0175251f,0.068f},{-0.0239398f,-0.00641464f,0.068f},
	{-0.0247843f,0.0f,0.068f},{-0.0239398f,0.00641464f,0.068f},{-0.0214638f,0.0123921f,0.068f},
	{-0.0175251f,0.0175251f,0.068f},{-0.0123921f,0.0214638f,0.068f},{-0.00641464f,0.0239398f,0.068f},
	{0.00641464f,0.0239398f,0.068f},{0.0123921f,0.0214638f,0.068f},{0.0175251f,0.0175251f,0.068f},
	{0.0214638f,0.0123921f,0.068f},{0.0239398f,0.00641464f,0.068f},{0.0247843f,0.0f,0.072f},
	{0.0239398f,-0.00641464f,0.072f},{0.0175251f,-0.0175251f,0.072f},{0.0123921f,-0.0214638f,0.072f},
	{0.00641464f,-0.0239398f,0.072f},{-0.00641464f,-0.0239398f,0.072f},{-0.0123921f,-0.0214638f,0.072f},
	{-0.0175251f,-0.0175251f,0.072f},{-0.0239398f,-0.00641464f,0.072f},{-0.0247843f,0.0f,0.072f},
	{-0.0239398f,0.00641464f,0.072f},{-0.0214638f,0.0123921f,0.072f},{-0.0175251f,0.0175251f,0.072f},
	{-0.0123921f,0.0214638f,0.072f},{-0.00641464f,0.0239398f,0.072f},{0.00641464f,0.0239398f,0.072f},
	{0.0123921f,0.0214638f,0.072f},{0.0175251f,0.0175251f,0.072f},{0.0214638f,0.0123921f,0.072f},
	{0.0239398f,0.00641464f,0.072f},{0.0237756f,0.0f,0.073f},{0.0229655f,-0.00615359f,0.073f},
	{0.0168119f,-0.0168119f,0.073f},{0.0118878f,-0.0205903f,0.073f},{0.00615359f,-0.0229655f,0.073f},
	{-0.00615359f,-0.0229655f,0.073f},{-0.0118878f,-0.0205903f,0.073f},{-0.0168119f,-0.0168119f,0.073f},
	{-0.0229655f,-0.00615359f,0.073f},{-0.0237756f,0.0f,0.073f},{-0.0229655f,0.00615359f,0.073f},
	{-0.0205903f,0.0118878f,0.073f},{-0.0168119f,0.0168119f,0.073f},{-0.0118878f,0.0205903f,0.073f},
	{-0.00615359f,0.0229655f,0.073f},{0.00615359f,0.0229655f,0.073f},{0.0118878f,0.0205903f,0.073f},
	{0.0168119f,0.0168119f,0.073f},{0.0205903f,0.0118878f,0.073f},{0.0229655f,0.00615359f,0.073f},
	{0.0207498f,0.0f,0.073f},{0.0103749f,-0.0179698f,0.073f},{0.00537043f,-0.0200427f,0.073f},
	{0.0f,-0.0207498f,0.073f},{-0.00537043f,-0.0200427f,0.073f},{-0.0103749f,-0.0179698f,0.073f},
	{-0.0207498f,0.0f,0.073f},{-0.0200427f,0.00537043f,0.073f},{-0.0179698f,0.0103749f,0.073f},
	{-0.0146723f,0.0146723f,0.073f},{-0.0103749f,0.0179698f,0.073f},{0.0103749f,0.0179698f,0.073f},
	{0.0146723f,0.0146723f,0.073f},{0.0179698f,0.0103749f,0.073f},{0.0200427f,0.00537043f,0.073f},
	{0.0246834f,-0.014251f,0.068f},{0.0275307f,-0.00737684f,0.068f},{0.0201539f,-0.0201539f,0.068f},
	{0.0f,-0.0285019f,0.068f},{0.00737684f,-0.0275307f,0.068f},{-0.00737684f,-0.0275307f,0.068f},
	{-0.0246834f,-0.014251f,0.068f},{-0.0201539f,-0.0201539f,0.068f},{-0.0275307f,-0.00737684f,0.068f},
	{-0.00737684f,0.0275307f,0.068f},{0.0f,0.0285019f,0.068f},{0.00737684f,0.0275307f,0.068f},
	{0.0246834f,-0.014251f,0.072f},{0.0275307f,-0.00737684f,0.072f},{0.0201539f,-0.0201539f,0.072f},
	{0.0f,-0.0285019f,0.072f},{0.00737684f,-0.0275307f,0.072f},{-0.00737684f,-0.0275307f,0.072f},
	{-0.0246834f,-0.014251f,0.072f},{-0.0201539f,-0.0201539f,0.072f},{-0.0275307f,-0.00737684f,0.072f},
	{0.0f,0.0285019f,0.072f},{-0.00737684f,0.0275307f,0.072f},{0.00737684f,0.0275307f,0.072f},
	{0.0f,-0.027342f,0.073f},{0.00707663f,-0.0264103f,0.073f},{-0.00707663f,-0.0264103f,0.073f},
	{0.0206653f,-0.0119311f,0.073f},{0.0230491f,-0.006176f,0.073f},{0.0168731f,-0.0168731f,0.073f},
	{0.0f,-0.0238622f,0.073f},{0.006176f,-0.0230491f,0.073f},{-0.006176f,-0.0230491f,0.073f},
	{-0.0206653f,-0.0119311f,0.073f},{-0.0168731f,-0.0168731f,0.073f},{-0.0230491f,-0.006176f,0.073f},
	{-0.006176f,0.0230491f,0.073f},{0.0f,0.0238622f,0.073f},{0.006176f,0.0230491f,0.073f},
	{-0.0103304f,0.0385537f,0.0585f},{0.0f,0.0399137f,0.0585f},{0.0103304f,0.0385537f,0.0585f},
	{0.0385537f,-0.0103304f,0.0585f},{0.0345663f,-0.0199569f,0.0585f},{0.0282233f,-0.0282233f,0.0585f},
	{0.0103304f,-0.0385537f,0.0585f},{0.0f,-0.0399137f,0.0585f},{-0.0103304f,-0.0385537f,0.0585f},
	{-0.0282233f,-0.0282233f,0.0585f},{-0.0345663f,-0.0199569f,0.0585f},{-0.0385537f,-0.0103304f,0.0585f},
	{0.030528f,0.0f,0.09781f},{0.026438f,0.015264f,0.09781f},{0.00790123f,0.0294878f,0.09781f},
	{0.0f,0.030528f,0.09781f},{0.0294878f,0.00790123f,0.09781f},{0.0215866f,0.0215866f,0.09781f},
	{0.015264f,0.026438f,0.09781f},{-0.030528f,0.0f,0.09781f},{-0.026438f,0.015264f,0.09781f},
	{-0.00790123f,0.0294878f,0.09781f},{-0.0294878f,0.00790123f,0.09781f},{-0.0215866f,0.0215866f,0.09781f},
	{-0.015264f,0.026438f,0.09781f},{0.026438f,-0.015264f,0.09781f},{0.00790123f,-0.0294878f,0.09781f},
	{0.0f,-0.030528f,0.09781f},{0.0294878f,-0.00790123f,0.09781f},{0.0215866f,-0.0215866f,0.09781f},
	{0.015264f,-0.026438f,0.09781f},{-0.026438f,-0.015264f,0.09781f},{-0.00790123f,-0.0294878f,0.09781f},
	{-0.0294878f,-0.00790123f,0.09781f},{-0.0215866f,-0.0215866f,0.09781f},{-0.015264f,-0.026438f,0.09781f},
	{0.0211586f,-0.0211586f,0.09961f},{0.0149614f,-0.0259139f,0.09961f},{0.0077446f,-0.0289032f,0.09961f},
	{0.0f,-0.0299228f,0.09961f},{-0.0077446f,-0.0289032f,0.09961f},{-0.0149614f,-0.0259139f,0.09961f},
	{-0.0211586f,-0.0211586f,0.09961f},{-0.0259139f,-0.0149614f,0.09961f},{-0.0289032f,-0.0077446f,0.09961f},
	{-0.0299228f,0.0f,0.09961f},{-0.0289032f,0.0077446f,0.09961f},{-0.0259139f,0.0149614f,0.09961f},
	{-0.0211586f,0.0211586f,0.09961f},{-0.0149614f,0.0259139f,0.09961f},{-0.0077446f,0.0289032f,0.09961f},
	{0.0f,0.0299228f,0.09961f},{0.0077446f,0.0289032f,0.09961f},{0.0149614f,0.0259139f,0.09961f},
	{0.0211586f,0.0211586f,0.09961f},{0.0259139f,0.0149614f,0.09961f},{0.0289032f,0.0077446f,0.09961f},
	{0.0299228f,0.0f,0.09961f},{0.0289032f,-0.0077446f,0.09961f},{0.0259139f,-0.0149614f,0.09961f},
	{0.0211586f,-0.0211586f,0.09811f},{0.0149614f,-0.0259139f,0.09811f},{0.0077446f,-0.0289032f,0.09811f},
	{0.0f,-0.0299228f,0.09811f},{-0.0077446f,-0.0289032f,0.09811f},{-0.0149614f,-0.0259139f,0.09811f},
	{-0.0211586f,-0.0211586f,0.09811f},{-0.0259139f,-0.0149614f,0.09811f},{-0.0289032f,-0.0077446f,0.09811f},
	{-0.0299228f,0.0f,0.09811f},{-0.0289032f,0.0077446f,0.09811f},{-0.0259139f,0.0149614f,0.09811f},
	{-0.0211586f,0.0211586f,0.09811f},{-0.0149614f,0.0259139f,0.09811f},{-0.0077446f,0.0289032f,0.09811f},
	{0.0f,0.0299228f,0.09811f},{0.0077446f,0.0289032f,0.09811f},{0.0149614f,0.0259139f,0.09811f},
	{0.0211586f,0.0211586f,0.09811f},{0.0259139f,0.0149614f,0.09811f},{0.0289032f,0.0077446f,0.09811f},
	{0.0299228f,0.0f,0.09811f},{0.0289032f,-0.0077446f,0.09811f},{0.0259139f,-0.0149614f,0.09811f},
	{0.0203028f,-0.0203028f,0.09811f},{0.0143562f,-0.0248657f,0.09811f},{0.00743133f,-0.0277341f,0.09811f},
	{0.0f,-0.0287125f,0.09811f},{-0.00743133f,-0.0277341f,0.09811f},{-0.0143562f,-0.0248657f,0.09811f},
	{-0.0203028f,-0.0203028f,0.09811f},{-0.0248657f,-0.0143562f,0.09811f},{-0.0277341f,-0.00743133f,0.09811f},
	{-0.0287125f,0.0f,0.09811f},{-0.0277341f,0.00743133f,0.09811f},{-0.0248657f,0.0143562f,0.09811f},
	{-0.0203028f,0.0203028f,0.09811f},{-0.0143562f,0.0248657f,0.09811f},{-0.00743133f,0.0277341f,0.09811f},
	{0.0f,0.0287125f,0.09811f},{0.00743133f,0.0277341f,0.09811f},{0.0143562f,0.0248657f,0.09811f},
	{0.0203028f,0.0203028f,0.09811f},{0.0248657f,0.0143562f,0.09811f},{0.0277341f,0.00743133f,0.09811f},
	{0.0287125f,0.0f,0.09811f},{0.0277341f,-0.00743133f,0.09811f},{0.0248657f,-0.0143562f,0.09811f},
	{0.02544f,0.0f,0.08131f},{0.0220317f,0.01272f,0.08131f},{0.00658436f,0.0245732f,0.08131f},
	{0.0f,0.02544f,0.08131f},{0.0245732f,0.00658436f,0.08131f},{0.0179888f,0.0179888f,0.08131f},
	{0.01272f,0.0220317f,0.08131f},{-0.02544f,0.0f,0.08131f},{-0.0220317f,0.01272f,0.08131f},
	{-0.00658436f,0.0245732f,0.08131f},{-0.0245732f,0.00658436f,0.08131f},{-0.0179888f,0.0179888f,0.08131f},
	{-0.01272f,0.0220317f,0.08131f},{0.0220317f,-0.01272f,0.08131f},{0.00658436f,-0.0245732f,0.08131f},
	{0.0f,-0.02544f,0.08131f},{0.0245732f,-0.00658436f,0.08131f},{0.0179888f,-0.0179888f,0.08131f},
	{0.01272f,-0.0220317f,0.08131f},{-0.0220317f,-0.01272f,0.08131f},{-0.00658436f,-0.0245732f,0.08131f},
	{-0.0245732f,-0.00658436f,0.08131f},{-0.0179888f,-0.0179888f,0.08131f},{-0.01272f,-0.0220317f,0.08131f},
	{0.0176322f,-0.0176322f,0.08311f},{0.0124678f,-0.0215949f,0.08311f},{0.00645383f,-0.024086f,0.08311f},
	{0.0f,-0.0249357f,0.08311f},{-0.00645383f,-0.024086f,0.08311f},{-0.0124678f,-0.0215949f,0.08311f},
	{-0.0176322f,-0.0176322f,0.08311f},{-0.0215949f,-0.0124678f,0.08311f},{-0.024086f,-0.00645383f,0.08311f},
	{-0.0249357f,0.0f,0.08311f},{-0.024086f,0.00645383f,0.08311f},{-0.0215949f,0.0124678f,0.08311f},
	{-0.0176322f,0.0176322f,0.08311f},{-0.0124678f,0.0215949f,0.08311f},{-0.00645383f,0.024086f,0.08311f},
	{0.0f,0.0249357f,0.08311f},{0.00645383f,0.024086f,0.08311f},{0.0124678f,0.0215949f,0.08311f},
	{0.0176322f,0.0176322f,0.08311f},{0.0215949f,0.0124678f,0.08311f},{0.024086f,0.00645383f,0.08311f},
	{0.0249357f,0.0f,0.08311f},{0.024086f,-0.00645383f,0.08311f},{0.0215949f,-0.0124678f,0.08311f},
	{0.0176322f,-0.0176322f,0.08161f},{0.0124678f,-0.0215949f,0.08161f},{0.00645383f,-0.024086f,0.08161f},
	{0.0f,-0.0249357f,0.08161f},{-0.00645383f,-0.024086f,0.08161f},{-0.0124678f,-0.0215949f,0.08161f},
	{-0.0176322f,-0.0176322f,0.08161f},{-0.0215949f,-0.0124678f,0.08161f},{-0.024086f,-0.00645383f,0.08161f},
	{-0.0249357f,0.0f,0.08161f},{-0.024086f,0.00645383f,0.08161f},{-0.0215949f,0.0124678f,0.08161f},
	{-0.0176322f,0.0176322f,0.08161f},{-0.0124678f,0.0215949f,0.08161f},{-0.00645383f,0.024086f,0.08161f},
	{0.0f,0.0249357f,0.08161f},{0.00645383f,0.024086f,0.08161f},{0.0124678f,0.0215949f,0.08161f},
	{0.0176322f,0.0176322f,0.08161f},{0.0215949f,0.0124678f,0.08161f},{0.024086f,0.00645383f,0.08161f},
	{0.0249357f,0.0f,0.08161f},{0.024086f,-0.00645383f,0.08161f},{0.0215949f,-0.0124678f,0.08161f},
	{0.016919f,-0.016919f,0.08161f},{0.0119635f,-0.0207214f,0.08161f},{0.00619278f,-0.0231118f,0.08161f},
	{0.0f,-0.0239271f,0.08161f},{-0.00619278f,-0.0231118f,0.08161f},{-0.0119635f,-0.0207214f,0.08161f},
	{-0.016919f,-0.016919f,0.08161f},{-0.0207214f,-0.0119635f,0.08161f},{-0.0231118f,-0.00619278f,0.08161f},
	{-0.0239271f,0.0f,0.08161f},{-0.0231118f,0.00619278f,0.08161f},{-0.0207214f,0.0119635f,0.08161f},
	{-0.016919f,0.016919f,0.08161f},{-0.0119635f,0.0207214f,0.08161f},{-0.00619278f,0.0231118f,0.08161f},
	{0.0f,0.0239271f,0.08161f},{0.00619278f,0.0231118f,0.08161f},{0.0119635f,0.0207214f,0.08161f},
	{0.016919f,0.016919f,0.08161f},{0.0207214f,0.0119635f,0.08161f},{0.0231118f,0.00619278f,0.08161f},
	{0.0239271f,0.0f,0.08161f},{0.0231118f,-0.00619278f,0.08161f},{0.0207214f,-0.0119635f,0.08161f},
	{0.00766419f,0.0286031f,0.09639f},{0.0148061f,0.0256449f,0.09639f},{0.0149305f,0.0258604f,0.09751f},
	{0.00772859f,0.0288435f,0.09751f},{-0.00766419f,0.0286031f,0.09639f},{0.0f,0.0296122f,0.09639f},
	{-0.0148061f,0.0256449f,0.09639f},{0.0f,0.029861f,0.09751f},{-0.00772859f,0.0288435f,0.09751f},
	{-0.0149305f,0.0258604f,0.09751f},{0.00638683f,0.023836f,0.07989f},{0.00644049f,0.0240362f,0.08101f},
	{-0.00638683f,0.023836f,0.07989f},{0.0f,0.0246768f,0.07989f},{0.0f,0.0248841f,0.08101f},
	{-0.00644049f,0.0240362f,0.08101f},{0.020939f,0.020939f,0.09639f},{0.0211149f,0.0211149f,0.09751f},
	{-0.020939f,0.020939f,0.09639f},{-0.0211149f,0.0211149f,0.09751f},{0.0174491f,0.0174491f,0.07989f},
	{0.0175957f,0.0175957f,0.08101f},{0.0123384f,0.0213707f,0.07989f},{0.0124421f,0.0215503f,0.08101f},
	{-0.0123384f,0.0213707f,0.07989f},{-0.0124421f,0.0215503f,0.08101f},{-0.0174491f,0.0174491f,0.07989f},
	{-0.0175957f,0.0175957f,0.08101f},{0.0256449f,0.0148061f,0.09639f},{0.0286031f,0.00766419f,0.09639f},
	{0.0288435f,0.00772859f,0.09751f},{0.0258604f,0.0149305f,0.09751f},{-0.0286031f,0.00766419f,0.09639f},
	{-0.0256449f,0.0148061f,0.09639f},{-0.0258604f,0.0149305f,0.09751f},{-0.0288435f,0.00772859f,0.09751f},
	{0.0213707f,0.0123384f,0.07989f},{0.0215503f,0.0124421f,0.08101f},{-0.0213707f,0.0123384f,0.07989f},
	{-0.0215503f,0.0124421f,0.08101f},{0.023836f,0.00638683f,0.07989f},{0.0240362f,0.00644049f,0.08101f},
	{-0.023836f,0.00638683f,0.07989f},{-0.0240362f,0.00644049f,0.08101f},{0.0296122f,0.0f,0.09639f},
	{0.029861f,0.0f,0.09751f},{-0.0296122f,0.0f,0.09639f},{-0.029861f,0.0f,0.09751f},
	{0.0246768f,0.0f,0.07989f},{0.023836f,-0.00638683f,0.07989f},{0.0240362f,-0.00644049f,0.08101f},
	{0.0248841f,0.0f,0.08101f},{-0.023836f,-0.00638683f,0.07989f},{-0.0246768f,0.0f,0.07989f},
	{-0.0248841f,0.0f,0.08101f},{-0.0240362f,-0.00644049f,0.08101f},{0.0286031f,-0.00766419f,0.09639f},
	{0.0256449f,-0.0148061f,0.09639f},{0.0258604f,-0.0149305f,0.09751f},{0.0288435f,-0.00772859f,0.09751f},
	{-0.0256449f,-0.0148061f,0.09639f},{-0.0286031f,-0.00766419f,0.09639f},{-0.0288435f,-0.00772859f,0.09751f},
	{-0.0258604f,-0.0149305f,0.09751f},{0.0213707f,-0.0123384f,0.07989f},{0.0215503f,-0.0124421f,0.08101f},
	{-0.0213707f,-0.0123384f,0.07989f},{-0.0215503f,-0.0124421f,0.08101f},{0.020939f,-0.020939f,0.09639f},
	{0.0211149f,-0.0211149f,0.09751f},{-0.020939f,-0.020939f,0.09639f},{-0.0211149f,-0.0211149f,0.09751f},
	{0.0174491f,-0.0174491f,0.07989f},{0.0175957f,-0.0175957f,0.08101f},{0.0123384f,-0.0213707f,0.07989f},
	{0.0124421f,-0.0215503f,0.08101f},{-0.0123384f,-0.0213707f,0.07989f},{-0.0124421f,-0.0215503f,0.08101f},
	{-0.0174491f,-0.0174491f,0.07989f},{-0.0175957f,-0.0175957f,0.08101f},{0.0148061f,-0.0256449f,0.09639f},
	{0.00766419f,-0.0286031f,0.09639f},{0.00772859f,-0.0288435f,0.09751f},{0.0149305f,-0.0258604f,0.09751f},
	{0.0f,-0.0296122f,0.09639f},{-0.00766419f,-0.0286031f,0.09639f},{-0.0148061f,-0.0256449f,0.09639f},
	{-0.0149305f,-0.0258604f,0.09751f},{-0.00772859f,-0.0288435f,0.09751f},{0.0f,-0.029861f,0.09751f},
	{0.00638683f,-0.023836f,0.07989f},{0.00644049f,-0.0240362f,0.08101f},{0.0f,-0.0246768f,0.07989f},
	{-0.00638683f,-0.023836f,0.07989f},{-0.00644049f,-0.0240362f,0.08101f},{0.0f,-0.0248841f,0.08101f},
	{0.0245917f,-0.014198f,0.105f},{0.0213841f,-0.0123461f,0.105f},{0.0238508f,-0.00639081f,0.105f},
	{0.0274285f,-0.00734944f,0.105f},{0.020079f,-0.020079f,0.105f},{0.01746f,-0.01746f,0.105f},
	{-0.020079f,-0.020079f,0.105f},{-0.0245917f,-0.014198f,0.105f},{-0.0213841f,-0.0123461f,0.105f},
	{-0.01746f,-0.01746f,0.105f},{-0.0274285f,-0.00734944f,0.105f},{-0.0238508f,-0.00639081f,0.105f},
	{-0.00734944f,0.0274285f,0.105f},{0.0f,0.028396f,0.105f},{0.0f,0.0246922f,0.105f},
	{-0.00639081f,0.0238508f,0.105f},{0.00734944f,0.0274285f,0.105f},{0.00639081f,0.0238508f,0.105f},
	{-0.00734944f,0.0274285f,0.0955f},{0.0f,0.028396f,0.0955f},{0.00734944f,0.0274285f,0.0955f},
	{-0.00639081f,0.0238508f,0.0955f},{0.0f,0.0246922f,0.0955f},{0.00639081f,0.0238508f,0.0955f},
	{0.0213841f,-0.0123461f,0.0955f},{0.0238508f,-0.00639081f,0.0955f},{0.0274285f,-0.00734944f,0.0955f},
	{-0.0274285f,-0.00734944f,0.0955f},{-0.0238508f,-0.00639081f,0.0955f},{-0.0213841f,-0.0123461f,0.0955f},
	{0.0245917f,-0.014198f,0.0955f},{-0.0245917f,-0.014198f,0.0955f},{0.020079f,-0.020079f,0.0955f},
	{0.01746f,-0.01746f,0.0955f},{-0.020079f,-0.020079f,0.0955f},{-0.01746f,-0.01746f,0.0955f},
	{0.0f,0.0238622f,0.081f},{-0.006176f,0.0230491f,0.081f},{0.006176f,0.0230491f,0.081f},
	{0.0f,0.0207498f,0.081f},{-0.00537043f,0.0200427f,0.081f},{0.00537043f,0.0200427f,0.081f},
	{0.0200427f,-0.00537043f,0.081f},{0.0230491f,-0.006176f,0.081f},{-0.0200427f,-0.00537043f,0.081f},
	{-0.0230491f,-0.006176f,0.081f},{0.0179698f,-0.0103749f,0.081f},{-0.0179698f,-0.0103749f,0.081f},
	{0.0206653f,-0.0119311f,0.081f},{-0.0206653f,-0.0119311f,0.081f},{0.0146723f,-0.0146723f,0.081f},
	{-0.0146723f,-0.0146723f,0.081f},{0.0168731f,-0.0168731f,0.081f},{-0.0168731f,-0.0168731f,0.081f},
	{0.00745399f,0.0278187f,0.1025f},{0.0f,0.0288f,0.1025f},{-0.00745399f,0.0278187f,0.1025f},
	{0.0144f,0.0249415f,0.1025f},{-0.0144f,0.0249415f,0.1025f},{0.0203647f,0.0203647f,0.1025f},
	{-0.0203647f,0.0203647f,0.1025f},{0.0249415f,0.0144f,0.1025f},{-0.0249415f,0.0144f,0.1025f},
	{0.0278187f,0.00745399f,0.1025f},{-0.0278187f,0.00745399f,0.1025f},{0.0288f,0.0f,0.1025f},
	{-0.0288f,0.0f,0.1025f},{0.0278187f,-0.00745399f,0.1025f},{-0.0278187f,-0.00745399f,0.1025f},
	{0.0249415f,-0.0144f,0.1025f},{-0.0249415f,-0.0144f,0.1025f},{0.0203647f,-0.0203647f,0.1025f},
	{0.0144f,-0.0249415f,0.1025f},{-0.0203647f,-0.0203647f,0.1025f},{-0.0144f,-0.0249415f,0.1025f},
	{0.00745399f,-0.0278187f,0.1025f},{0.0f,-0.0288f,0.1025f},{-0.00745399f,-0.0278187f,0.1025f},
	{0.0203647f,0.0203647f,0.1055f},{0.0144f,0.0249415f,0.1055f},{0.00745399f,0.0278187f,0.1055f},
	{-0.0203647f,0.0203647f,0.1055f},{-0.0144f,0.0249415f,0.1055f},{-0.00745399f,0.0278187f,0.1055f},
	{0.0f,0.0288f,0.1055f},{0.0278187f,0.00745399f,0.1055f},{0.0249415f,0.0144f,0.1055f},
	{-0.0278187f,0.00745399f,0.1055f},{-0.0249415f,0.0144f,0.1055f},{0.0278187f,-0.00745399f,0.1055f},
	{0.0288f,0.0f,0.1055f},{-0.0278187f,-0.00745399f,0.1055f},{-0.0288f,0.0f,0.1055f},
	{0.00745399f,-0.0278187f,0.1055f},{0.0144f,-0.0249415f,0.1055f},{0.0203647f,-0.0203647f,0.1055f},
	{0.0249415f,-0.0144f,0.1055f},{-0.00745399f,-0.0278187f,0.1055f},{0.0f,-0.0288f,0.1055f},
	{-0.0144f,-0.0249415f,0.1055f},{-0.0203647f,-0.0203647f,0.1055f},{-0.0249415f,-0.0144f,0.1055f},
	{-0.0123827f,0.0214475f,0.112f},{-0.00640978f,0.0239216f,0.112f},{0.0f,0.0247655f,0.112f},
	{0.00640978f,0.0239216f,0.112f},{0.0123827f,0.0214475f,0.112f},{0.0175118f,0.0175118f,0.112f},
	{0.0214475f,0.0123827f,0.112f},{0.0239216f,0.00640978f,0.112f},{0.0247655f,0.0f,0.112f},
	{0.0239216f,-0.00640978f,0.112f},{0.0214475f,-0.0123827f,0.112f},{0.0175118f,-0.0175118f,0.112f},
	{0.0123827f,-0.0214475f,0.112f},{0.00640978f,-0.0239216f,0.112f},{0.0f,-0.0247655f,0.112f},
	{-0.00640978f,-0.0239216f,0.112f},{-0.0123827f,-0.0214475f,0.112f},{-0.0175118f,-0.0175118f,0.112f},
	{-0.0214475f,-0.0123827f,0.112f},{-0.0239216f,-0.00640978f,0.112f},{-0.0247655f,0.0f,0.112f},
	{-0.0239216f,0.00640978f,0.112f},{-0.0214475f,0.0123827f,0.112f},{-0.0175118f,0.0175118f,0.112f},
	{-0.0136329f,0.0136329f,0.112f},{-0.0096399f,0.0166968f,0.112f},{-0.00498998f,0.0186229f,0.112f},
	{0.0f,0.0192798f,0.112f},{0.0096399f,0.0166968f,0.112f},{0.00498998f,0.0186229f,0.112f},
	{0.0166968f,0.0096399f,0.112f},{0.0136329f,0.0136329f,0.112f},{0.0192798f,0.0f,0.112f},
	{0.0186229f,0.00498998f,0.112f},{0.0166968f,-0.0096399f,0.112f},{0.0186229f,-0.00498998f,0.112f},
	{0.0096399f,-0.0166968f,0.112f},{0.0136329f,-0.0136329f,0.112f},{0.0f,-0.0192798f,0.112f},
	{0.00498998f,-0.0186229f,0.112f},{-0.0096399f,-0.0166968f,0.112f},{-0.00498998f,-0.0186229f,0.112f},
	{-0.0166968f,-0.0096399f,0.112f},{-0.0136329f,-0.0136329f,0.112f},{-0.0192798f,0.0f,0.112f},
	{-0.0186229f,-0.00498998f,0.112f},{-0.0186229f,0.00498998f,0.112f},{-0.0166968f,0.0096399f,0.112f},
	{-0.0129696f,0.0129696f,0.1115f},{-0.00917089f,0.0158844f,0.1115f},{-0.0047472f,0.0177168f,0.1115f},
	{0.0f,0.0183418f,0.1115f},{0.00917089f,0.0158844f,0.1115f},{0.0047472f,0.0177168f,0.1115f},
	{0.0158844f,0.00917089f,0.1115f},{0.0129696f,0.0129696f,0.1115f},{0.0183418f,0.0f,0.1115f},
	{0.0177168f,0.0047472f,0.1115f},{0.0158844f,-0.00917089f,0.1115f},{0.0177168f,-0.0047472f,0.1115f},
	{0.00917089f,-0.0158844f,0.1115f},{0.0129696f,-0.0129696f,0.1115f},{0.0f,-0.0183418f,0.1115f},
	{0.0047472f,-0.0177168f,0.1115f},{-0.0047472f,-0.0177168f,0.1115f},{-0.00917089f,-0.0158844f,0.1115f},
	{-0.0129696f,-0.0129696f,0.1115f},{-0.0158844f,-0.00917089f,0.1115f},{-0.0177168f,-0.0047472f,0.1115f},
	{-0.0183418f,0.0f,0.1115f},{-0.0177168f,0.0047472f,0.1115f},{-0.0158844f,0.00917089f,0.1115f},
	{-0.020731f,0.0f,0.112f},{-0.0200246f,-0.00536557f,0.112f},{-0.0179535f,-0.0103655f,0.112f},
	{-0.014659f,-0.014659f,0.112f},{-0.0103655f,-0.0179535f,0.112f},{-0.00536557f,-0.0200246f,0.112f},
	{0.0f,-0.020731f,0.112f},{0.00536557f,-0.0200246f,0.112f},{0.0103655f,-0.0179535f,0.112f},
	{0.014659f,-0.014659f,0.112f},{0.0179535f,-0.0103655f,0.112f},{0.0200246f,-0.00536557f,0.112f},
	{0.020731f,0.0f,0.112f},{0.0200246f,0.00536557f,0.112f},{0.0179535f,0.0103655f,0.112f},
	{0.014659f,0.014659f,0.112f},{0.0103655f,0.0179535f,0.112f},{0.00536557f,0.0200246f,0.112f},
	{0.0f,0.020731f,0.112f},{-0.00536557f,0.0200246f,0.112f},{-0.0103655f,0.0179535f,0.112f},
	{-0.014659f,0.014659f,0.112f},{-0.0179535f,0.0103655f,0.112f},{-0.0200246f,0.00536557f,0.112f},
	{-0.00473931f,0.0176874f,0.1105f},{-0.00473931f,-0.0176874f,0.1105f},{-0.012948f,-0.012948f,0.1105f},
	{-0.0176874f,-0.00473931f,0.1105f},{-0.0176874f,0.00473931f,0.1105f},{-0.012948f,0.012948f,0.1105f},
	{-0.00915565f,0.015858f,0.1105f},{0.0f,0.0183113f,0.1105f},{0.00473931f,0.0176874f,0.1105f},
	{0.00915565f,0.015858f,0.1105f},{0.015858f,0.00915565f,0.1105f},{0.012948f,0.012948f,0.1105f},
	{0.0176874f,0.00473931f,0.1105f},{0.0183113f,0.0f,0.1105f},{0.0176874f,-0.00473931f,0.1105f},
	{0.012948f,-0.012948f,0.1105f},{0.015858f,-0.00915565f,0.1105f},{0.00915565f,-0.015858f,0.1105f},
	{0.00473931f,-0.0176874f,0.1105f},{0.0f,-0.0183113f,0.1105f},{-0.00915565f,-0.015858f,0.1105f},
	{-0.015858f,-0.00915565f,0.1105f},{-0.0183113f,0.0f,0.1105f},{-0.015858f,0.00915565f,0.1105f},
	{0.04723f,0.0f,9.71445e-018f},{0.0456207f,0.012224f,9.71445e-018f},{0.0409024f,0.023615f,9.71445e-018f},
	{0.0333967f,0.0333967f,9.71445e-018f},{0.023615f,0.0409024f,9.71445e-018f},{0.012224f,0.0456207f,9.71445e-018f},
	{0.0f,0.04723f,9.71445e-018f},{-0.012224f,0.0456207f,9.71445e-018f},{-0.023615f,0.0409024f,9.71445e-018f},
	{-0.0333967f,0.0333967f,9.71445e-018f},{-0.0409024f,0.023615f,9.71445e-018f},{-0.0456207f,0.012224f,9.71445e-018f},
	{-0.04723f,0.0f,9.71445e-018f},{-0.0456207f,-0.012224f,9.71445e-018f},{-0.0409024f,-0.023615f,9.71445e-018f},
	{-0.0333967f,-0.0333967f,9.71445e-018f},{-0.023615f,-0.0409024f,9.71445e-018f},{-0.012224f,-0.0456207f,9.71445e-018f},
	{0.0f,-0.04723f,9.71445e-018f},{0.012224f,-0.0456207f,9.71445e-018f},{0.023615f,-0.0409024f,9.71445e-018f},
	{0.0333967f,-0.0333967f,9.71445e-018f},{0.0409024f,-0.023615f,9.71445e-018f},{0.0456207f,-0.012224f,9.71445e-018f},
	{0.0200427f,-0.00537043f,0.073f},{0.0179698f,-0.0103749f,0.073f},{0.0146723f,-0.0146723f,0.073f},
	{-0.0146723f,-0.0146723f,0.073f},{-0.0179698f,-0.0103749f,0.073f},{-0.0200427f,-0.00537043f,0.073f},
	{-0.00537043f,0.0200427f,0.073f},{0.0f,0.0207498f,0.073f},{0.00537043f,0.0200427f,0.073f},
	{0.0207498f,0.0f,0.059f},{0.0200427f,-0.00537043f,0.059f},{0.0179698f,-0.0103749f,0.059f},
	{0.0146723f,-0.0146723f,0.059f},{0.0103749f,-0.0179698f,0.059f},{0.00537043f,-0.0200427f,0.059f},
	{0.0f,-0.0207498f,0.059f},{-0.00537043f,-0.0200427f,0.059f},{-0.0103749f,-0.0179698f,0.059f},
	{-0.0146723f,-0.0146723f,0.059f},{-0.0179698f,-0.0103749f,0.059f},{-0.0200427f,-0.00537043f,0.059f},
	{-0.0207498f,0.0f,0.059f},{-0.0200427f,0.00537043f,0.059f},{-0.0179698f,0.0103749f,0.059f},
	{-0.0146723f,0.0146723f,0.059f},{-0.0103749f,0.0179698f,0.059f},{-0.00537043f,0.0200427f,0.059f},
	{0.0f,0.0207498f,0.059f},{0.00537043f,0.0200427f,0.059f},{0.0103749f,0.0179698f,0.059f},
	{0.0146723f,0.0146723f,0.059f},{0.0179698f,0.0103749f,0.059f},{0.0200427f,0.00537043f,0.059f},
	{0.0236789f,-0.013671f,0.073f},{0.0264103f,-0.00707663f,0.073f},{0.0193337f,-0.0193337f,0.073f},
	{-0.0236789f,-0.013671f,0.073f},{-0.0193337f,-0.0193337f,0.073f},{-0.0264103f,-0.00707663f,0.073f},
	{0.0f,0.027342f,0.073f},{-0.00707663f,0.0264103f,0.073f},{0.00707663f,0.0264103f,0.073f},
	{-0.0107935f,-0.0402819f,0.0605f},{0.0f,-0.0417029f,0.0605f},{0.0107935f,-0.0402819f,0.0605f},
	{0.0208515f,-0.0361158f,0.0605f},{0.0294884f,-0.0294884f,0.0605f},{0.0361158f,-0.0208515f,0.0605f},
	{0.0402819f,-0.0107935f,0.0605f},{0.0417029f,0.0f,0.0605f},{0.0402819f,0.0107935f,0.0605f},
	{0.0361158f,0.0208515f,0.0605f},{0.0294884f,0.0294884f,0.0605f},{0.0208515f,0.0361158f,0.0605f},
	{0.0107935f,0.0402819f,0.0605f},{0.0f,0.0417029f,0.0605f},{-0.0107935f,0.0402819f,0.0605f},
	{-0.0208515f,0.0361158f,0.0605f},{-0.0294884f,0.0294884f,0.0605f},{-0.0361158f,0.0208515f,0.0605f},
	{-0.0402819f,0.0107935f,0.0605f},{-0.0417029f,0.0f,0.0605f},{-0.0402819f,-0.0107935f,0.0605f},
	{-0.0361158f,-0.0208515f,0.0605f},{-0.0294884f,-0.0294884f,0.0605f},{-0.0208515f,-0.0361158f,0.0605f},
	{0.0127727f,-0.0476684f,0.0436563f},{0.0f,-0.04935f,0.0436563f},{-0.0127727f,-0.0476684f,0.0436563f},
	{-0.024675f,-0.0427384f,0.0436563f},{-0.0348957f,-0.0348957f,0.0436563f},{-0.0427384f,-0.024675f,0.0436563f},
	{-0.0476684f,-0.0127727f,0.0436563f},{-0.04935f,0.0f,0.0436563f},{-0.0476684f,0.0127727f,0.0436563f},
	{-0.0427384f,0.024675f,0.0436563f},{-0.0348957f,0.0348957f,0.0436563f},{-0.024675f,0.0427384f,0.0436563f},
	{-0.0127727f,0.0476684f,0.0436563f},{0.0f,0.04935f,0.0436563f},{0.0127727f,0.0476684f,0.0436563f},
	{0.024675f,0.0427384f,0.0436563f},{0.0348957f,0.0348957f,0.0436563f},{0.0427384f,0.024675f,0.0436563f},
	{0.0476684f,0.0127727f,0.0436563f},{0.04935f,0.0f,0.0436563f},{0.0476684f,-0.0127727f,0.0436563f},
	{0.0427384f,-0.024675f,0.0436563f},{0.0348957f,-0.0348957f,0.0436563f},{0.024675f,-0.0427384f,0.0436563f}
	};
	static GLfloat normals [1120][3] = {
	{0.0f,0.0f,-1.0f},{-0.642879f,-0.120633f,0.756409f},{-0.510493f,0.179497f,0.840939f},
	{-0.599576f,0.00232919f,0.800314f},{-0.344303f,-0.197004f,0.917957f},{-0.342762f,0.199673f,0.917957f},
	{-0.410695f,-0.352352f,0.840938f},{-0.352352f,0.410695f,0.840938f},{-0.199673f,-0.342762f,0.917957f},
	{-0.197004f,0.344303f,0.917957f},{-0.179497f,-0.510493f,0.840939f},{-0.0997984f,0.531849f,0.840938f},
	{0.0217163f,-0.537577f,0.842935f},{-0.0147114f,0.364173f,0.931215f},{0.104156f,-0.382762f,0.917957f},
	{0.101179f,0.38356f,0.917957f},{0.305506f,-0.446642f,0.840938f},{0.234051f,0.487896f,0.840939f},
	{0.238465f,-0.236619f,0.941884f},{0.338546f,0.341187f,0.876914f},{0.446642f,0.305506f,0.840938f},
	{0.487896f,-0.234051f,0.840939f},{0.382762f,0.104156f,0.917957f},{0.464749f,-0.122596f,0.876914f},
	{0.794308f,0.060733f,0.604471f},{-0.919649f,-0.252459f,0.300848f},{-0.513813f,-0.0117484f,0.857822f},
	{-0.953654f,-0.0058336f,0.300848f},{-0.493264f,-0.144333f,0.857822f},{-0.822972f,-0.481879f,0.300848f},
	{-0.439101f,-0.267081f,0.857822f},{-0.67021f,-0.67846f,0.300848f},{-0.355013f,-0.371628f,0.857822f},
	{-0.471775f,-0.828806f,0.300848f},{-0.246732f,-0.450849f,0.857822f},{-0.241189f,-0.922669f,0.300848f},
	{-0.121636f,-0.499346f,0.857822f},{0.0058336f,-0.953654f,0.300848f},{0.0117484f,-0.513813f,0.857822f},
	{0.252459f,-0.919649f,0.300848f},{0.144333f,-0.493264f,0.857822f},{0.481879f,-0.822972f,0.300848f},
	{0.267081f,-0.439101f,0.857822f},{0.67846f,-0.67021f,0.300848f},{0.371628f,-0.355013f,0.857822f},
	{0.828806f,-0.471775f,0.300848f},{0.450849f,-0.246732f,0.857822f},{0.922669f,-0.241189f,0.300848f},
	{0.499346f,-0.121636f,0.857822f},{0.953654f,0.0058336f,0.300848f},{0.513813f,0.0117484f,0.857822f},
	{0.919649f,0.252459f,0.300848f},{0.493264f,0.144333f,0.857822f},{0.822972f,0.481879f,0.300848f},
	{0.439101f,0.267081f,0.857822f},{0.67021f,0.67846f,0.300848f},{0.355013f,0.371628f,0.857822f},
	{0.471775f,0.828806f,0.300848f},{0.246732f,0.450849f,0.857822f},{0.241189f,0.922669f,0.300848f},
	{0.121636f,0.499346f,0.857822f},{-0.0058336f,0.953654f,0.300848f},{-0.0117484f,0.513813f,0.857822f},
	{-0.252459f,0.919649f,0.300848f},{-0.144333f,0.493264f,0.857822f},{-0.481879f,0.822972f,0.300848f},
	{-0.267081f,0.439101f,0.857822f},{-0.67846f,0.67021f,0.300848f},{-0.371628f,0.355013f,0.857822f},
	{-0.828806f,0.471775f,0.300848f},{-0.450849f,0.246732f,0.857822f},{-0.922669f,0.241189f,0.300848f},
	{-0.499346f,0.121636f,0.857822f},{-0.0133848f,-0.818495f,-0.574358f},{-0.224771f,-0.787141f,-0.574358f},
	{0.198913f,-0.794069f,-0.574358f},{0.397656f,-0.71553f,-0.574358f},{0.569299f,-0.588228f,-0.574358f},
	{0.702145f,-0.420839f,-0.574358f},{0.787141f,-0.224771f,-0.574358f},{0.818495f,-0.0133848f,-0.574358f},
	{0.79407f,0.198913f,-0.574358f},{0.71553f,0.397656f,-0.574358f},{0.588228f,0.569299f,-0.574358f},
	{0.420839f,0.702145f,-0.574358f},{0.224771f,0.787141f,-0.574358f},{0.0133848f,0.818495f,-0.574358f},
	{-0.198913f,0.79407f,-0.574358f},{-0.397656f,0.71553f,-0.574358f},{-0.569299f,0.588228f,-0.574358f},
	{-0.702145f,0.420839f,-0.574358f},{-0.787141f,0.224771f,-0.574358f},{-0.818495f,0.0133848f,-0.574358f},
	{-0.79407f,-0.198913f,-0.574358f},{-0.71553f,-0.397656f,-0.574358f},{-0.588228f,-0.569299f,-0.574358f},
	{-0.420839f,-0.702145f,-0.574358f},{-0.296352f,-0.939178f,0.173552f},{-0.454547f,-0.873652f,0.173552f},
	{-0.529331f,-0.830475f,0.173552f},{-0.212941f,-0.961528f,0.173552f},{-0.0431767f,-0.983878f,0.173552f},
	{0.0431767f,-0.983878f,0.173552f},{0.212941f,-0.961528f,0.173552f},{0.296352f,-0.939178f,0.173552f},
	{0.454547f,-0.873652f,0.173552f},{0.529331f,-0.830475f,0.173552f},{0.665176f,-0.726237f,0.173552f},
	{0.726237f,-0.665176f,0.173552f},{0.830475f,-0.529331f,0.173552f},{0.873652f,-0.454547f,0.173552f},
	{0.939178f,-0.296352f,0.173552f},{0.961528f,-0.212941f,0.173552f},{0.983878f,-0.0431767f,0.173552f},
	{0.983878f,0.0431767f,0.173552f},{0.961528f,0.212941f,0.173552f},{0.939178f,0.296352f,0.173552f},
	{0.873652f,0.454547f,0.173552f},{0.830475f,0.529331f,0.173552f},{0.726237f,0.665176f,0.173552f},
	{0.665176f,0.726237f,0.173552f},{0.529331f,0.830475f,0.173552f},{0.454547f,0.873652f,0.173552f},
	{0.296352f,0.939178f,0.173552f},{0.212941f,0.961528f,0.173552f},{0.0431767f,0.983878f,0.173552f},
	{-0.0431767f,0.983878f,0.173552f},{-0.212941f,0.961528f,0.173552f},{-0.296352f,0.939178f,0.173552f},
	{-0.454547f,0.873652f,0.173552f},{-0.529331f,0.830475f,0.173552f},{-0.665176f,0.726237f,0.173552f},
	{-0.726237f,0.665176f,0.173552f},{-0.830475f,0.529331f,0.173552f},{-0.873652f,0.454547f,0.173552f},
	{-0.939178f,0.296352f,0.173552f},{-0.961528f,0.212941f,0.173552f},{-0.983878f,0.0431767f,0.173552f},
	{-0.983878f,-0.0431767f,0.173552f},{-0.961528f,-0.212941f,0.173552f},{-0.939178f,-0.296352f,0.173552f},
	{-0.873652f,-0.454547f,0.173552f},{-0.830475f,-0.529331f,0.173552f},{-0.726237f,-0.665176f,0.173552f},
	{-0.665176f,-0.726237f,0.173552f},{0.0f,0.0f,1.0f},{0.531773f,0.0f,0.846887f},
	{0.853836f,0.189092f,0.484982f},{0.921994f,-0.0298231f,0.386054f},{0.507475f,0.160131f,0.846656f},
	{0.768078f,-0.10112f,0.632322f},{0.575534f,-0.188199f,0.795827f},{0.779391f,-0.459944f,0.425443f},
	{0.539827f,-0.344076f,0.768244f},{0.887379f,-0.367564f,0.278308f},{0.659094f,-0.505741f,0.556616f},
	{0.388989f,-0.415388f,0.822277f},{0.42707f,-0.762948f,0.485306f},{0.24561f,-0.472069f,0.846656f},
	{0.577535f,-0.752659f,0.316161f},{0.296467f,-0.715735f,0.632322f},{0.124782f,-0.592527f,0.795827f},
	{0.0f,-0.828548f,0.559917f},{0.0f,-0.639794f,0.768547f},{0.12537f,-0.952275f,0.278308f},
	{-0.124782f,-0.592527f,0.795827f},{-0.12537f,-0.952275f,0.278308f},{-0.296467f,-0.715735f,0.632322f},
	{-0.24561f,-0.472069f,0.846656f},{-0.427069f,-0.762948f,0.485306f},{-0.388989f,-0.415388f,0.822277f},
	{-0.577535f,-0.752659f,0.316161f},{-0.659094f,-0.505741f,0.556616f},{-0.539827f,-0.344076f,0.768244f},
	{-0.779391f,-0.459944f,0.425443f},{-0.575534f,-0.188199f,0.795827f},{-0.887379f,-0.367564f,0.278308f},
	{-0.768078f,-0.10112f,0.632322f},{-0.531773f,0.0f,0.846887f},{-0.921994f,-0.0298231f,0.386054f},
	{-0.853836f,0.189092f,0.484982f},{-0.507475f,0.160131f,0.846656f},{-0.775802f,0.403637f,0.484982f},
	{-0.448739f,0.286019f,0.846656f},{-0.644898f,0.590676f,0.484982f},{-0.359421f,0.392415f,0.846656f},
	{-0.470046f,0.737461f,0.484982f},{-0.24561f,0.472069f,0.846656f},{-0.335263f,0.809398f,0.482156f},
	{-0.124782f,0.592527f,0.795827f},{0.0f,0.904978f,0.425458f},{-0.118306f,0.898622f,0.42247f},
	{0.0f,0.639794f,0.768547f},{0.124782f,0.592527f,0.795827f},{0.118306f,0.898622f,0.42247f},
	{0.24561f,0.472069f,0.846656f},{0.335263f,0.809398f,0.482156f},{0.470046f,0.737461f,0.484982f},
	{0.359421f,0.392415f,0.846656f},{0.644898f,0.590676f,0.484982f},{0.448739f,0.286019f,0.846656f},
	{0.775802f,0.403637f,0.484982f},{0.922687f,0.00694728f,0.385488f},{0.889449f,0.245519f,0.385488f},
	{0.959261f,-0.126289f,0.252725f},{0.791018f,-0.447136f,0.417564f},{0.773674f,-0.320466f,0.546562f},
	{0.763154f,-0.585589f,0.273281f},{0.46736f,-0.795596f,0.385489f},{0.525273f,-0.684549f,0.505451f},
	{0.370261f,-0.893889f,0.252726f},{0.0f,-0.961312f,0.275461f},{0.109305f,-0.830255f,0.546562f},
	{-0.109305f,-0.830255f,0.546562f},{-0.370261f,-0.893889f,0.252726f},{-0.46736f,-0.795596f,0.385489f},
	{-0.525273f,-0.684549f,0.505451f},{-0.763154f,-0.585589f,0.273281f},{-0.791018f,-0.447136f,0.417564f},
	{-0.773674f,-0.320466f,0.546562f},{-0.959261f,-0.126289f,0.252725f},{-0.922687f,0.00694727f,0.385488f},
	{-0.889449f,0.245519f,0.385488f},{-0.795596f,0.46736f,0.385489f},{-0.647525f,0.65735f,0.385489f},
	{-0.455327f,0.802544f,0.385489f},{-0.3302f,0.797174f,0.505451f},{-0.125558f,0.953705f,0.273281f},
	{1.35725e-009f,0.835259f,0.549856f},{0.125558f,0.953705f,0.273281f},{0.455327f,0.802544f,0.385489f},
	{0.3302f,0.797174f,0.505451f},{0.647525f,0.65735f,0.385489f},{0.795596f,0.46736f,0.385489f},
	{0.324903f,0.0142582f,0.94564f},{0.362573f,0.114408f,0.924906f},{0.501124f,-0.0659745f,0.862857f},
	{0.308664f,-0.160593f,0.937516f},{0.214088f,-0.0886779f,0.972781f},{0.367682f,-0.282133f,0.886121f},
	{0.20435f,-0.320608f,0.924906f},{0.153849f,-0.200499f,0.967538f},{0.193426f,-0.466973f,0.862857f},
	{0.0f,-0.460332f,0.887747f},{0.0302465f,-0.229744f,0.972781f},{-0.0302465f,-0.229744f,0.972781f},
	{-0.193426f,-0.466973f,0.862857f},{-0.20435f,-0.320608f,0.924906f},{-0.153849f,-0.200499f,0.967538f},
	{-0.367682f,-0.282133f,0.886121f},{-0.308664f,-0.160593f,0.937516f},{-0.214088f,-0.0886779f,0.972781f},
	{-0.501124f,-0.0659745f,0.862857f},{-0.324903f,0.0142582f,0.94564f},{-0.362573f,0.114408f,0.924906f},
	{-0.320608f,0.20435f,0.924906f},{-0.256794f,0.280367f,0.924906f},{-0.175479f,0.337276f,0.924906f},
	{-0.146446f,0.353552f,0.92388f},{-0.0457209f,0.347284f,0.936645f},{0.0f,0.347648f,0.937625f},
	{0.0457209f,0.347284f,0.936645f},{0.175479f,0.337276f,0.924906f},{0.146446f,0.353552f,0.92388f},
	{0.256794f,0.280367f,0.924906f},{0.320608f,0.20435f,0.924906f},{-0.999038f,-0.0438421f,0.0f},
	{-0.976344f,-0.216222f,0.0f},{-0.999038f,0.0438421f,0.0f},{-0.95365f,-0.300918f,0.0f},
	{-0.976344f,0.216222f,0.0f},{-0.95365f,0.300918f,0.0f},{-0.887114f,0.461551f,0.0f},
	{-0.843272f,0.537487f,0.0f},{-0.737428f,0.675426f,0.0f},{-0.675426f,0.737428f,0.0f},
	{-0.537487f,0.843272f,0.0f},{-0.461551f,0.887114f,0.0f},{-0.300918f,0.95365f,0.0f},
	{-0.216222f,0.976344f,0.0f},{0.0f,1.0f,0.0f},{0.216222f,0.976344f,0.0f},
	{0.300918f,0.95365f,0.0f},{0.461551f,0.887114f,0.0f},{0.537487f,0.843272f,0.0f},
	{0.675426f,0.737428f,0.0f},{0.737428f,0.675426f,0.0f},{0.843272f,0.537487f,0.0f},
	{0.887114f,0.461551f,0.0f},{0.95365f,0.300918f,0.0f},{0.976344f,0.216222f,0.0f},
	{0.999038f,0.0438421f,0.0f},{0.999038f,-0.0438421f,0.0f},{0.976344f,-0.216222f,0.0f},
	{0.95365f,-0.300918f,0.0f},{0.887114f,-0.461551f,0.0f},{0.843272f,-0.537487f,0.0f},
	{0.737428f,-0.675426f,0.0f},{0.675426f,-0.737428f,0.0f},{0.537487f,-0.843272f,0.0f},
	{0.461551f,-0.887114f,0.0f},{0.300918f,-0.95365f,0.0f},{0.216222f,-0.976344f,0.0f},
	{0.0f,-1.0f,0.0f},{-0.216222f,-0.976344f,0.0f},{-0.300918f,-0.95365f,0.0f},
	{-0.461551f,-0.887114f,0.0f},{-0.537487f,-0.843272f,0.0f},{-0.675426f,-0.737428f,0.0f},
	{-0.737428f,-0.675426f,0.0f},{-0.843272f,-0.537487f,0.0f},{-0.887114f,-0.461551f,0.0f},
	{0.258819f,0.965926f,-2.73578e-007f},{0.258819f,0.965926f,-9.11928e-008f},{0.258819f,0.965926f,-1.36789e-007f},
	{-0.707107f,-0.707107f,0.0f},{0.965926f,0.258819f,2.73578e-007f},{0.965926f,0.258819f,9.11928e-008f},
	{0.965926f,0.258819f,1.36789e-007f},{-0.965926f,0.258819f,1.36789e-007f},{-0.965926f,0.258819f,9.11928e-008f},
	{-0.965926f,0.258819f,2.73578e-007f},{0.707107f,-0.707107f,0.0f},{-0.258819f,0.965926f,-1.36789e-007f},
	{-0.258819f,0.965926f,-9.11928e-008f},{-0.258819f,0.965926f,-2.73578e-007f},{-0.965926f,-0.258819f,2.73578e-007f},
	{-0.965926f,-0.258819f,9.11928e-008f},{-0.965926f,-0.258819f,1.36789e-007f},{0.965926f,-0.258819f,9.11928e-008f},
	{0.965926f,-0.258819f,2.73578e-007f},{0.965926f,-0.258819f,1.36789e-007f},{0.258819f,0.965926f,2.83893e-008f},
	{0.258819f,0.965926f,-5.00732e-008f},{0.965926f,0.258819f,-2.83893e-008f},{0.965926f,0.258819f,5.00732e-008f},
	{-0.965926f,0.258819f,-2.83893e-008f},{-0.965926f,0.258819f,5.00732e-008f},{-0.258819f,0.965926f,2.83893e-008f},
	{-0.258819f,0.965926f,-5.00732e-008f},{-0.965926f,-0.258819f,-2.83893e-008f},{-0.965926f,-0.258819f,5.00732e-008f},
	{0.965926f,-0.258819f,-2.83893e-008f},{0.965926f,-0.258819f,5.00732e-008f},{0.258819f,0.965926f,-7.51099e-008f},
	{0.258819f,0.965926f,-2.35388e-007f},{0.965926f,0.258819f,7.51099e-008f},{0.965926f,0.258819f,2.35388e-007f},
	{-0.965926f,0.258819f,7.51099e-008f},{-0.965926f,0.258819f,2.35388e-007f},{-0.258819f,0.965926f,-7.51099e-008f},
	{-0.258819f,0.965926f,-2.35388e-007f},{-0.965926f,-0.258819f,7.51099e-008f},{-0.965926f,-0.258819f,2.35388e-007f},
	{0.965926f,-0.258819f,7.51099e-008f},{0.965926f,-0.258819f,2.35388e-007f},{-0.728498f,-0.558997f,0.395996f},
	{-0.865207f,-0.498531f,0.0537052f},{-0.813614f,-0.42331f,0.398549f},{-0.791451f,-0.607302f,-0.0691995f},
	{-0.856592f,-0.493405f,-0.151001f},{-0.789401f,-0.605728f,-0.0996988f},{0.773404f,-0.492955f,0.398549f},
	{0.792228f,-0.607898f,0.0532471f},{0.728498f,-0.558996f,0.395996f},{0.885836f,-0.460886f,0.0536537f},
	{0.833621f,-0.531336f,-0.150859f},{0.784409f,-0.601898f,-0.149739f},{0.786488f,0.603493f,0.131274f},
	{0.793353f,0.608762f,0.0f},{0.87932f,0.457496f,0.132262f},{0.835863f,0.532766f,0.132262f},
	{0.786488f,0.603494f,0.131274f},{-0.793353f,0.608762f,0.0f},{-0.858021f,0.496259f,0.132387f},
	{-0.78113f,0.599382f,0.174862f},{-0.858784f,0.494938f,0.132387f},{-0.790315f,0.606431f,0.087431f},
	{-0.90964f,-0.376785f,0.174895f},{-0.848354f,-0.3514f,0.395996f},{-0.905327f,-0.374998f,-0.199398f},
	{0.848355f,-0.3514f,0.395996f},{0.922569f,-0.38214f,0.0532471f},{0.913463f,-0.378369f,-0.149739f},
	{0.92388f,0.382683f,0.0f},{0.915884f,0.379371f,0.131274f},{-0.920342f,0.381218f,0.087431f},
	{-0.92388f,0.382683f,0.0f},{-0.909645f,0.376787f,0.174862f},{-0.258819f,0.965926f,-3.77292e-008f},
	{-0.258819f,0.965926f,-2.99322e-008f},{-0.258819f,0.965926f,0.0f},{-0.258819f,0.965926f,-3.71331e-008f},
	{-0.258819f,0.965926f,-1.19803e-008f},{-0.258819f,0.965926f,-7.20088e-009f},{0.258819f,0.965926f,-1.78135e-008f},
	{0.258819f,0.965926f,-1.7892e-008f},{0.258819f,0.965926f,-3.5627e-008f},{0.258819f,0.965926f,-7.16916e-009f},
	{0.258819f,0.965926f,-8.98524e-009f},{0.258819f,0.965926f,-1.08013e-008f},{-0.130526f,-0.991445f,0.0f},
	{-0.0265392f,-0.994029f,0.105841f},{0.0438421f,-0.999038f,0.0f},{-0.128516f,-0.97617f,0.174862f},
	{0.0189613f,-0.988315f,0.151239f},{-0.130027f,-0.987648f,0.087431f},{0.965926f,-0.258819f,3.77292e-008f},
	{0.965926f,-0.258819f,2.65559e-008f},{0.965926f,-0.258819f,0.0f},{0.965926f,-0.258819f,2.86898e-008f},
	{0.965926f,-0.258819f,7.69129e-009f},{0.965926f,-0.258819f,2.44219e-008f},{-0.965926f,-0.258819f,1.78135e-008f},
	{-0.965926f,-0.258819f,5.84943e-009f},{-0.965926f,-0.258819f,3.5627e-008f},{-0.965926f,-0.258819f,1.02551e-008f},
	{-0.965926f,-0.258819f,1.02551e-008f},{-0.965926f,-0.258819f,1.62813e-008f},{0.129397f,-0.982865f,0.131274f},
	{0.130526f,-0.991445f,0.0f},{0.129397f,-0.982865f,0.131274f},{0.0402096f,0.916265f,0.398549f},
	{0.130341f,0.990038f,0.0532471f},{0.119856f,0.910396f,0.395996f},{-0.0256932f,0.991478f,0.127717f},
	{0.0190093f,0.984828f,-0.172491f},{0.129055f,0.980267f,-0.149739f},{-0.119856f,0.910396f,0.395996f},
	{-0.130214f,0.989068f,-0.0691995f},{-0.129876f,0.986505f,-0.0996988f},{0.793353f,0.608762f,0.0f},
	{0.887114f,0.461551f,0.0f},{-0.843272f,-0.537487f,0.0f},{-0.793353f,-0.608761f,0.0f},
	{0.793353f,-0.608761f,0.0f},{-0.843272f,0.537488f,0.0f},{-0.793353f,0.608762f,0.0f},
	{-0.92388f,-0.382683f,0.0f},{0.92388f,-0.382683f,0.0f},{-0.258819f,0.965926f,0.0f},
	{0.258819f,0.965926f,0.0f},{-0.0438421f,-0.999038f,0.0f},{-0.130527f,-0.991445f,0.0f},
	{0.965926f,-0.258819f,0.0f},{-0.965926f,-0.258819f,0.0f},{0.130527f,-0.991445f,0.0f},
	{0.130526f,0.991445f,0.0f},{-0.043842f,0.999038f,0.0f},{-0.130526f,0.991445f,0.0f},
	{-0.471526f,0.245327f,-0.847041f},{-0.886602f,0.225269f,-0.403968f},{-0.798088f,0.447063f,-0.403968f},
	{-0.518954f,0.114928f,-0.847041f},{-0.914696f,-0.0118764f,-0.403968f},{-0.531017f,-0.0233032f,-0.847041f},
	{-0.880455f,-0.248213f,-0.403968f},{-0.506891f,-0.159947f,-0.847041f},{-0.786212f,-0.467633f,-0.403968f},
	{-0.448223f,-0.28569f,-0.84704f},{-0.63839f,-0.655186f,-0.403968f},{-0.359008f,-0.391964f,-0.84704f},
	{-0.447063f,-0.798088f,-0.403968f},{-0.245327f,-0.471526f,-0.847041f},{-0.225269f,-0.886602f,-0.403968f},
	{-0.114928f,-0.518954f,-0.847041f},{0.0f,-0.803073f,-0.59588f},{0.0f,-0.531161f,-0.847271f},
	{0.114928f,-0.518954f,-0.847041f},{0.225269f,-0.886602f,-0.403968f},{0.245327f,-0.471526f,-0.847041f},
	{0.447063f,-0.798088f,-0.403968f},{0.359008f,-0.391964f,-0.84704f},{0.63839f,-0.655186f,-0.403968f},
	{0.448223f,-0.28569f,-0.84704f},{0.786212f,-0.467633f,-0.403968f},{0.506891f,-0.159947f,-0.847041f},
	{0.880455f,-0.248212f,-0.403968f},{0.531017f,-0.0233032f,-0.847041f},{0.914696f,-0.0118764f,-0.403968f},
	{0.518954f,0.114928f,-0.847041f},{0.886602f,0.225269f,-0.403968f},{0.471526f,0.245327f,-0.847041f},
	{0.798088f,0.447063f,-0.403968f},{0.391964f,0.359008f,-0.84704f},{0.655186f,0.63839f,-0.403968f},
	{0.28569f,0.448223f,-0.84704f},{0.467633f,0.786212f,-0.403968f},{0.159947f,0.506891f,-0.847041f},
	{0.248213f,0.880455f,-0.403968f},{0.0f,0.531161f,-0.847271f},{2.9484e-008f,0.981474f,-0.191594f},
	{-0.248213f,0.880454f,-0.403968f},{-0.159947f,0.506891f,-0.847041f},{-0.467633f,0.786211f,-0.403969f},
	{-0.28569f,0.448223f,-0.84704f},{-0.655185f,0.63839f,-0.403968f},{-0.391964f,0.359008f,-0.84704f},
	{-0.887114f,0.461551f,0.0f},{-0.95365f,0.300918f,0.0f},{-0.843272f,0.537488f,0.0f},
	{-0.976344f,0.216222f,0.0f},{-0.999038f,0.0438421f,0.0f},{-0.999038f,-0.0438421f,0.0f},
	{-0.976344f,-0.216222f,0.0f},{-0.887114f,-0.461551f,0.0f},{-0.843272f,-0.537488f,0.0f},
	{-0.737428f,-0.675426f,0.0f},{-0.675426f,-0.737428f,0.0f},{-0.537488f,-0.843272f,0.0f},
	{-0.461551f,-0.887114f,0.0f},{-0.300918f,-0.95365f,0.0f},{-0.216222f,-0.976344f,0.0f},
	{0.216222f,-0.976344f,0.0f},{0.461551f,-0.887114f,0.0f},{0.537488f,-0.843272f,0.0f},
	{0.675426f,-0.737428f,0.0f},{0.737428f,-0.675426f,0.0f},{0.843272f,-0.537488f,0.0f},
	{0.887114f,-0.461551f,0.0f},{0.95365f,-0.300918f,0.0f},{0.976344f,-0.216222f,0.0f},
	{0.999038f,-0.0438421f,0.0f},{0.999038f,0.0438421f,0.0f},{0.976344f,0.216222f,0.0f},
	{0.887114f,0.461551f,0.0f},{0.843272f,0.537488f,0.0f},{0.737428f,0.675426f,0.0f},
	{0.675426f,0.737428f,0.0f},{0.537488f,0.843272f,0.0f},{0.461551f,0.887114f,0.0f},
	{0.300918f,0.95365f,0.0f},{0.216222f,0.976344f,0.0f},{-0.216222f,0.976344f,0.0f},
	{-0.461551f,0.887114f,0.0f},{-0.537488f,0.843272f,0.0f},{-0.675426f,0.737428f,0.0f},
	{-0.737428f,0.675426f,0.0f},{0.94787f,-0.299094f,-0.109932f},{0.85428f,-0.444468f,0.269545f},
	{0.838161f,-0.53423f,-0.109932f},{0.940207f,-0.208219f,0.269545f},{0.985772f,-0.0194754f,-0.166958f},
	{0.962062f,0.0422195f,0.269545f},{0.960554f,0.255399f,-0.110037f},{0.918353f,0.289781f,0.269545f},
	{0.861722f,0.495305f,-0.110037f},{0.81206f,0.517594f,0.269545f},{0.704165f,0.701458f,-0.110037f},
	{0.650427f,0.710134f,0.269546f},{0.49862f,0.859808f,-0.110036f},{0.444468f,0.85428f,0.269545f},
	{0.259096f,0.959563f,-0.110037f},{0.208219f,0.940207f,0.269545f},{-2.67402e-009f,0.999728f,0.0233349f},
	{0.0f,0.96292f,0.269786f},{-0.208219f,0.940207f,0.269545f},{-0.259096f,0.959563f,-0.110037f},
	{-0.444468f,0.85428f,0.269545f},{-0.49862f,0.859808f,-0.110036f},{-0.650427f,0.710134f,0.269546f},
	{-0.704165f,0.701458f,-0.110037f},{-0.81206f,0.517594f,0.269545f},{-0.861722f,0.495306f,-0.110037f},
	{-0.918353f,0.289781f,0.269545f},{-0.960554f,0.255399f,-0.110037f},{-0.962062f,0.0422195f,0.269545f},
	{-0.985772f,-0.0194754f,-0.166958f},{-0.940207f,-0.208219f,0.269545f},{-0.94787f,-0.299095f,-0.109932f},
	{-0.85428f,-0.444468f,0.269545f},{-0.838161f,-0.53423f,-0.109933f},{-0.710134f,-0.650427f,0.269546f},
	{-0.671332f,-0.732958f,-0.109932f},{-0.517594f,-0.81206f,0.269545f},{-0.458753f,-0.881737f,-0.109933f},
	{-0.289781f,-0.918353f,0.269545f},{-0.214912f,-0.970427f,-0.109932f},{0.0f,-0.96292f,0.269786f},
	{0.0f,-0.993928f,-0.110036f},{0.214912f,-0.970427f,-0.109932f},{0.289781f,-0.918353f,0.269545f},
	{0.458753f,-0.881737f,-0.109932f},{0.517594f,-0.81206f,0.269545f},{0.671332f,-0.732958f,-0.109932f},
	{0.710134f,-0.650427f,0.269546f},{-9.93818e-008f,-0.880837f,-0.47342f},{-0.265117f,-0.84019f,-0.473068f},
	{-0.473541f,-0.742944f,-0.473067f},{-0.649693f,-0.595068f,-0.473067f},{-0.781571f,-0.406639f,-0.473067f},
	{-0.860185f,-0.190498f,-0.473067f},{-0.880836f,2.70018e-007f,-0.473421f},{0.265117f,-0.840191f,-0.473066f},
	{0.473541f,-0.742945f,-0.473066f},{0.649694f,-0.595068f,-0.473066f},{0.781571f,-0.406639f,-0.473066f},
	{0.860185f,-0.190498f,-0.473067f},{0.880836f,2.70018e-007f,-0.473421f},{0.0f,0.880836f,-0.473421f},
	{-0.265117f,0.840191f,-0.473067f},{-0.473541f,0.742945f,-0.473067f},{-0.649693f,0.595068f,-0.473067f},
	{-0.781571f,0.406639f,-0.473067f},{-0.860185f,0.190497f,-0.473068f},{0.265117f,0.840191f,-0.473067f},
	{0.473541f,0.742945f,-0.473067f},{0.649693f,0.595068f,-0.473068f},{0.78157f,0.406638f,-0.473068f},
	{0.860185f,0.190498f,-0.473068f},{3.75593e-009f,-0.976202f,0.216863f},{0.211086f,-0.953152f,0.216664f},
	{0.29377f,-0.930997f,0.216663f},{0.0f,-0.976202f,0.216862f},{0.450588f,-0.866042f,0.216662f},
	{0.524721f,-0.823241f,0.216661f},{0.659383f,-0.719911f,0.216661f},{0.719912f,-0.659382f,0.216661f},
	{0.823241f,-0.524721f,0.216661f},{0.866042f,-0.450588f,0.216662f},{0.930997f,-0.29377f,0.216663f},
	{0.953152f,-0.211086f,0.216664f},{0.975308f,-0.0428008f,0.216664f},{0.975308f,0.0428005f,0.216663f},
	{0.953153f,0.211086f,0.216663f},{0.930997f,0.293771f,0.216663f},{0.866042f,0.450588f,0.216663f},
	{0.823241f,0.52472f,0.216662f},{0.719912f,0.659383f,0.21666f},{0.659383f,0.719912f,0.21666f},
	{0.52472f,0.823241f,0.216662f},{0.450587f,0.866042f,0.216663f},{0.29377f,0.930997f,0.216664f},
	{0.211086f,0.953152f,0.216664f},{7.88745e-008f,0.976203f,0.216861f},{1.95308e-007f,0.976203f,0.216859f},
	{-0.211086f,0.953153f,0.216662f},{-0.29377f,0.930998f,0.216662f},{-0.450588f,0.866042f,0.216661f},
	{-0.524721f,0.823242f,0.21666f},{-0.659383f,0.719912f,0.216659f},{-0.719912f,0.659383f,0.216659f},
	{-0.823242f,0.524721f,0.21666f},{-0.866042f,0.450588f,0.216661f},{-0.930998f,0.29377f,0.216662f},
	{-0.953153f,0.211086f,0.216663f},{-0.975308f,0.0428005f,0.216663f},{-0.975308f,-0.0428008f,0.216664f},
	{-0.953152f,-0.211086f,0.216664f},{-0.930997f,-0.29377f,0.216664f},{-0.866041f,-0.450587f,0.216664f},
	{-0.823241f,-0.52472f,0.216662f},{-0.719911f,-0.659382f,0.216662f},{-0.659383f,-0.719911f,0.216661f},
	{-0.524721f,-0.823241f,0.216661f},{-0.450588f,-0.866042f,0.216662f},{-0.29377f,-0.930997f,0.216663f},
	{-0.211086f,-0.953152f,0.216664f},{-0.411082f,0.213879f,-0.886153f},{-0.441914f,0.139443f,-0.886153f},
	{-0.390766f,0.249068f,-0.886153f},{-0.452431f,0.100196f,-0.886153f},{-0.462947f,0.0203161f,-0.886153f},
	{-0.462947f,-0.0203161f,-0.886153f},{-0.452431f,-0.100196f,-0.886153f},{-0.441914f,-0.139443f,-0.886153f},
	{-0.411082f,-0.213879f,-0.886153f},{-0.390766f,-0.249068f,-0.886153f},{-0.341719f,-0.312988f,-0.886153f},
	{-0.312988f,-0.341719f,-0.886153f},{-0.249068f,-0.390766f,-0.886153f},{-0.213879f,-0.411082f,-0.886153f},
	{-0.139443f,-0.441914f,-0.886153f},{-0.100196f,-0.452431f,-0.886153f},{0.0f,-0.463043f,-0.886336f},
	{0.0f,-0.463043f,-0.886336f},{0.100196f,-0.452431f,-0.886153f},{0.139443f,-0.441914f,-0.886153f},
	{0.213879f,-0.411082f,-0.886153f},{0.249068f,-0.390766f,-0.886153f},{0.312988f,-0.341719f,-0.886153f},
	{0.341719f,-0.312988f,-0.886153f},{0.390766f,-0.249068f,-0.886153f},{0.411082f,-0.213879f,-0.886153f},
	{0.441914f,-0.139443f,-0.886153f},{0.452431f,-0.100196f,-0.886153f},{0.462947f,-0.0203161f,-0.886153f},
	{0.462947f,0.0203161f,-0.886153f},{0.452431f,0.100196f,-0.886153f},{0.441914f,0.139443f,-0.886153f},
	{0.411082f,0.213879f,-0.886153f},{0.390766f,0.249068f,-0.886153f},{0.341719f,0.312988f,-0.886153f},
	{0.312988f,0.341719f,-0.886153f},{0.249068f,0.390766f,-0.886153f},{0.213879f,0.411082f,-0.886153f},
	{0.139443f,0.441914f,-0.886153f},{0.100196f,0.452431f,-0.886153f},{0.0f,0.463043f,-0.886336f},
	{0.0f,0.463043f,-0.886336f},{-0.100196f,0.452431f,-0.886153f},{-0.139443f,0.441914f,-0.886153f},
	{-0.213879f,0.411082f,-0.886153f},{-0.249068f,0.390766f,-0.886153f},{-0.312988f,0.341719f,-0.886153f},
	{-0.341719f,0.312988f,-0.886153f},{-0.95365f,0.300918f,0.0f},{-0.843272f,0.537488f,0.0f},
	{-0.976344f,0.216222f,0.0f},{-0.999038f,0.0438421f,0.0f},{-0.999038f,-0.0438421f,0.0f},
	{-0.976344f,-0.216222f,0.0f},{-0.95365f,-0.300918f,0.0f},{-0.843272f,-0.537488f,0.0f},
	{-0.737428f,-0.675426f,0.0f},{-0.675426f,-0.737428f,0.0f},{-0.537488f,-0.843272f,0.0f},
	{-0.300918f,-0.95365f,0.0f},{-0.216222f,-0.976344f,0.0f},{0.216222f,-0.976344f,0.0f},
	{0.300918f,-0.95365f,0.0f},{0.537488f,-0.843272f,0.0f},{0.675426f,-0.737428f,0.0f},
	{0.737428f,-0.675426f,0.0f},{0.843272f,-0.537488f,0.0f},{0.95365f,-0.300918f,0.0f},
	{0.976344f,-0.216222f,0.0f},{0.999038f,-0.0438421f,0.0f},{0.999038f,0.0438421f,0.0f},
	{0.976344f,0.216222f,0.0f},{0.95365f,0.300918f,0.0f},{0.843272f,0.537488f,0.0f},
	{0.737428f,0.675426f,0.0f},{0.675426f,0.737428f,0.0f},{0.537488f,0.843272f,0.0f},
	{0.300918f,0.95365f,0.0f},{0.216222f,0.976344f,0.0f},{-0.216222f,0.976344f,0.0f},
	{-0.300918f,0.95365f,0.0f},{-0.537488f,0.843272f,0.0f},{-0.675426f,0.737428f,0.0f},
	{-0.737428f,0.675426f,0.0f},{0.946266f,-0.298589f,-0.124198f},{0.840944f,-0.43753f,0.318404f},
	{0.836743f,-0.533326f,-0.124197f},{0.92553f,-0.204969f,0.318404f},{0.981189f,-0.0197148f,-0.192041f},
	{0.947043f,0.0415604f,0.318404f},{0.959098f,0.254317f,-0.124317f},{0.904017f,0.285257f,0.318404f},
	{0.860595f,0.493884f,-0.124317f},{0.799384f,0.509514f,0.318404f},{0.703445f,0.699793f,-0.124316f},
	{0.640274f,0.699049f,0.318403f},{0.498355f,0.858014f,-0.124316f},{0.43753f,0.840944f,0.318404f},
	{0.259304f,0.957761f,-0.124317f},{0.204969f,0.92553f,0.318404f},{-1.37059e-009f,0.999405f,0.0344856f},
	{0.0f,0.947862f,0.31868f},{-0.204969f,0.92553f,0.318404f},{-0.259304f,0.957761f,-0.124317f},
	{-0.43753f,0.840944f,0.318404f},{-0.498355f,0.858014f,-0.124316f},{-0.640274f,0.699049f,0.318403f},
	{-0.703445f,0.699793f,-0.124316f},{-0.799384f,0.509514f,0.318403f},{-0.860595f,0.493884f,-0.124315f},
	{-0.904017f,0.285257f,0.318404f},{-0.959098f,0.254317f,-0.124316f},{-0.947043f,0.0415604f,0.318404f},
	{-0.981189f,-0.0197148f,-0.192041f},{-0.92553f,-0.204969f,0.318404f},{-0.946266f,-0.298589f,-0.124198f},
	{-0.840944f,-0.43753f,0.318404f},{-0.836743f,-0.533326f,-0.124199f},{-0.699049f,-0.640274f,0.318403f},
	{-0.670196f,-0.731718f,-0.124198f},{-0.509514f,-0.799384f,0.318403f},{-0.457977f,-0.880245f,-0.1242f},
	{-0.285257f,-0.904017f,0.318404f},{-0.214548f,-0.968785f,-0.124199f},{1.87709e-009f,-0.947862f,0.31868f},
	{0.0f,-0.992243f,-0.124315f},{0.214548f,-0.968785f,-0.124198f},{0.285257f,-0.904017f,0.318404f},
	{0.457978f,-0.880245f,-0.124197f},{0.509514f,-0.799384f,0.318404f},{0.670197f,-0.731718f,-0.124197f},
	{0.699049f,-0.640274f,0.318403f},{-1.72409e-007f,-0.840375f,-0.542006f},{-0.252955f,-0.801648f,-0.54164f},
	{-0.451818f,-0.708864f,-0.541638f},{-0.619891f,-0.567772f,-0.541637f},{-0.745718f,-0.387985f,-0.541639f},
	{-0.820726f,-0.181759f,-0.541638f},{-0.840373f,5.13479e-007f,-0.542009f},{0.252956f,-0.80165f,-0.541636f},
	{0.451819f,-0.708866f,-0.541635f},{0.619892f,-0.567772f,-0.541635f},{0.745719f,-0.387986f,-0.541636f},
	{0.820726f,-0.181759f,-0.541638f},{0.840373f,5.13479e-007f,-0.542009f},{-1.87401e-009f,0.840373f,-0.542009f},
	{-0.252955f,0.801649f,-0.541639f},{-0.451819f,0.708865f,-0.541637f},{-0.619891f,0.567771f,-0.541638f},
	{-0.745719f,0.387986f,-0.541637f},{-0.820725f,0.181758f,-0.541641f},{0.252955f,0.801649f,-0.541639f},
	{0.451819f,0.708865f,-0.541637f},{0.61989f,0.56777f,-0.541639f},{0.745717f,0.387985f,-0.54164f},
	{0.820725f,0.181759f,-0.541641f},{-3.75637e-009f,-0.983292f,0.182032f},{0.2959f,-0.937747f,0.181863f},
	{0.528525f,-0.829209f,0.181862f},{0.72513f,-0.664163f,0.181862f},{0.87232f,-0.453854f,0.181862f},
	{0.960062f,-0.212616f,0.181863f},{0.982378f,0.0431109f,0.181863f},{0.937747f,0.2959f,0.181863f},
	{0.829209f,0.528524f,0.181862f},{0.664163f,0.72513f,0.181862f},{0.453854f,0.87232f,0.181863f},
	{0.212617f,0.960063f,0.181863f},{9.76658e-008f,0.983293f,0.182031f},{-0.212617f,0.960063f,0.181862f},
	{-0.453854f,0.87232f,0.181862f},{-0.664163f,0.725131f,0.181861f},{-0.829209f,0.528525f,0.181861f},
	{-0.937747f,0.2959f,0.181862f},{-0.982378f,0.0431109f,0.181863f},{-0.960062f,-0.212616f,0.181863f},
	{-0.87232f,-0.453854f,0.181863f},{-0.72513f,-0.664163f,0.181863f},{-0.528525f,-0.829209f,0.181862f},
	{-0.2959f,-0.937747f,0.181863f},{-0.207931f,-0.938903f,0.274273f},{-0.300918f,-0.95365f,0.0f},
	{0.0f,-0.961582f,0.274517f},{-0.443852f,-0.853095f,0.274273f},{-0.537488f,-0.843272f,0.0f},
	{0.20793f,-0.938903f,0.274273f},{0.300918f,-0.95365f,0.0f},{0.443852f,-0.853095f,0.274273f},
	{0.537488f,-0.843272f,0.0f},{-0.649525f,-0.709149f,0.274273f},{-0.810934f,-0.516876f,0.274273f},
	{-0.887114f,-0.461551f,0.0f},{0.649525f,-0.709149f,0.274273f},{0.810934f,-0.516876f,0.274273f},
	{0.887114f,-0.461551f,0.0f},{-0.917079f,-0.289379f,0.274273f},{-0.976344f,-0.216222f,0.0f},
	{0.917079f,-0.289379f,0.274273f},{0.976344f,-0.216222f,0.0f},{-0.971825f,-0.0166231f,0.235116f},
	{-1.0f,0.0f,0.0f},{0.971825f,-0.0166231f,0.235116f},{1.0f,0.0f,0.0f},
	{-0.927937f,0.25214f,0.274515f},{0.927937f,0.25214f,0.274515f},{-0.887114f,0.461551f,0.0f},
	{-0.83106f,0.483716f,0.274515f},{0.887114f,0.461551f,0.0f},{0.83106f,0.483716f,0.274515f},
	{-0.677547f,0.682328f,0.274515f},{0.677547f,0.682328f,0.274515f},{-0.537488f,0.843272f,0.0f},
	{-0.477861f,0.83444f,0.274515f},{0.537488f,0.843272f,0.0f},{0.477861f,0.83444f,0.274515f},
	{-0.300918f,0.95365f,0.0f},{-0.245609f,0.929687f,0.274515f},{0.300918f,0.95365f,0.0f},
	{0.245609f,0.929687f,0.274515f},{1.29446e-009f,0.931311f,0.364226f},{-0.327561f,0.35763f,0.874531f},
	{-0.223838f,0.430223f,0.874531f},{-0.104861f,0.473497f,0.874531f},{0.0f,0.484613f,0.874729f},
	{0.104861f,0.473497f,0.874531f},{0.223838f,0.430223f,0.874531f},{0.327561f,0.35763f,0.874531f},
	{0.408961f,0.260665f,0.874531f},{0.462491f,0.145936f,0.874531f},{0.413769f,0.0181579f,0.910201f},
	{0.565112f,-0.12515f,0.815466f},{0.367414f,-0.19116f,0.910201f},{0.426827f,-0.39094f,0.815466f},
	{0.22261f,-0.349256f,0.910201f},{0.174173f,-0.551977f,0.815466f},{0.0f,-0.552422f,0.833565f},
	{-0.124631f,-0.394971f,0.910201f},{-0.3111f,-0.48809f,0.815466f},{-0.305419f,-0.27974f,0.910201f},
	{-0.513465f,-0.267148f,0.815466f},{-0.40437f,-0.0895523f,0.910201f},{-0.484503f,0.021262f,0.874531f},
	{-0.462491f,0.145936f,0.874531f},{-0.408961f,0.260665f,0.874531f},{0.0987417f,-0.128683f,0.986758f},
	{0.0716307f,-0.0549642f,0.995916f},{0.197484f,-0.257365f,0.945919f},{0.070037f,-0.169084f,0.98311f},
	{0.0345519f,-0.0834157f,0.995916f},{0.0211715f,-0.160813f,0.986758f},{0.042343f,-0.321627f,0.945919f},
	{-0.011785f,-0.0895161f,0.995916f},{-0.0238883f,-0.18145f,0.98311f},{-0.0549642f,-0.0716307f,0.995916f},
	{-0.0620718f,-0.149854f,0.986758f},{-0.124143f,-0.299708f,0.945919f},{-0.111413f,-0.145196f,0.98311f},
	{-0.0834157f,-0.0345519f,0.995916f},{-0.128683f,-0.0987419f,0.986758f},{-0.257365f,-0.197484f,0.945919f},
	{-0.169084f,-0.070037f,0.98311f},{-0.107781f,0.0141897f,0.994073f},{-0.160814f,-0.0211715f,0.986758f},
	{-0.321627f,-0.0423429f,0.945919f},{-0.135323f,0.0178156f,0.990641f},{-0.225572f,0.0934349f,0.969736f},
	{-0.108285f,0.0830902f,0.990641f},{-0.225572f,0.093435f,0.969736f},{-0.108285f,0.0830902f,0.990641f},
	{-0.148633f,0.193703f,0.969736f},{-0.0522327f,0.126101f,0.990641f},{-0.148634f,0.193703f,0.969736f},
	{-0.0522327f,0.126101f,0.990641f},{-0.0318689f,0.242068f,0.969736f},{0.0238883f,0.18145f,0.98311f},
	{-0.031869f,0.242069f,0.969736f},{0.0178156f,0.135323f,0.990641f},{0.0934349f,0.225572f,0.969736f},
	{0.0830902f,0.108285f,0.990641f},{0.0934347f,0.225571f,0.969736f},{0.0830903f,0.108285f,0.990641f},
	{0.193703f,0.148633f,0.969736f},{0.126101f,0.0522327f,0.990641f},{0.193702f,0.148633f,0.969736f},
	{0.126101f,0.0522327f,0.990641f},{0.242068f,0.0318689f,0.969736f},{0.15507f,-0.0204154f,0.987693f},
	{0.242068f,0.0318689f,0.969736f},{0.0895161f,-0.011785f,0.995916f},{0.149854f,-0.0620716f,0.986758f},
	{0.299708f,-0.124143f,0.945919f},{0.145196f,-0.111413f,0.98311f},{0.447907f,-0.583724f,0.677234f},
	{0.568939f,-0.741456f,0.355741f},{0.0960368f,-0.729473f,0.677234f},{0.121988f,-0.926589f,0.355741f},
	{-0.281566f,-0.67976f,0.677234f},{-0.357651f,-0.863443f,0.355742f},{-0.583724f,-0.447907f,0.677234f},
	{-0.741456f,-0.568939f,0.355741f},{-0.729473f,-0.0960367f,0.677234f},{-0.926589f,-0.121988f,0.355741f},
	{-0.67976f,0.281566f,0.677234f},{-0.863443f,0.357651f,0.355742f},{-0.447907f,0.583724f,0.677234f},
	{-0.568939f,0.741456f,0.355741f},{-0.0960367f,0.729473f,0.677234f},{-0.121988f,0.926589f,0.355741f},
	{0.281566f,0.67976f,0.677234f},{0.357651f,0.863443f,0.355742f},{0.583724f,0.447907f,0.677234f},
	{0.741456f,0.568939f,0.355741f},{0.729473f,0.0960368f,0.677234f},{0.926589f,0.121988f,0.355741f},
	{0.67976f,-0.281566f,0.677234f},{0.863443f,-0.357651f,0.355742f},{0.866025f,0.5f,-1.14726e-006f},
	{0.866025f,0.5f,-1.01958e-006f},{0.866025f,0.5f,-1.27495e-006f},{-0.707107f,0.707107f,0.0f},
	{0.258819f,0.965926f,-6.06457e-009f},{0.25882f,0.965926f,-3.94458e-007f},{0.258819f,0.965926f,3.82329e-007f},
	{-0.5f,-0.866025f,1.14726e-006f},{-0.5f,-0.866025f,1.01958e-006f},{-0.5f,-0.866025f,1.27495e-006f},
	{0.707107f,0.707107f,0.0f},{-0.866025f,-0.5f,-1.14726e-006f},{-0.866025f,-0.5f,-1.01958e-006f},
	{-0.866025f,-0.5f,-1.27495e-006f},{0.965926f,0.258819f,6.06457e-009f},{0.965926f,0.25882f,3.94458e-007f},
	{0.965926f,0.258819f,-3.82329e-007f},{0.965926f,-0.258819f,-6.06457e-009f},{0.965926f,-0.25882f,-3.94458e-007f},
	{0.965926f,-0.258819f,3.82329e-007f},{-0.866025f,0.5f,1.14726e-006f},{-0.866025f,0.5f,1.01958e-006f},
	{-0.866025f,0.5f,1.27495e-006f},{-0.5f,0.866025f,-1.14726e-006f},{-0.5f,0.866025f,-1.01958e-006f},
	{-0.5f,0.866025f,-1.27495e-006f},{0.258819f,-0.965926f,6.06457e-009f},{0.25882f,-0.965926f,3.94458e-007f},
	{0.258819f,-0.965926f,-3.82329e-007f},{-0.258819f,-0.965926f,-6.06457e-009f},{-0.25882f,-0.965926f,-3.94458e-007f},
	{-0.258819f,-0.965926f,3.82329e-007f},{0.5f,0.866025f,1.14726e-006f},{0.5f,0.866025f,1.01958e-006f},
	{0.5f,0.866025f,1.27495e-006f},{-0.258819f,0.965926f,6.06457e-009f},{-0.25882f,0.965926f,3.94458e-007f},
	{-0.258819f,0.965926f,-3.82329e-007f},{0.5f,-0.866025f,-1.14726e-006f},{0.5f,-0.866025f,-1.01958e-006f},
	{0.5f,-0.866025f,-1.27495e-006f},{0.866025f,-0.5f,1.14726e-006f},{0.866025f,-0.5f,1.01958e-006f},
	{0.866025f,-0.5f,1.27495e-006f},{-0.965926f,0.258819f,-6.06457e-009f},{-0.965926f,0.25882f,-3.94458e-007f},
	{-0.965926f,0.258819f,3.82329e-007f},{-0.965926f,-0.258819f,6.06457e-009f},{-0.965926f,-0.25882f,3.94458e-007f},
	{-0.965926f,-0.258819f,-3.82329e-007f},{0.100846f,0.279747f,0.954763f},{0.0250064f,0.296316f,0.954763f},
	{0.161218f,0.727974f,0.666381f},{-0.0326891f,0.744895f,0.666381f},{-0.0525378f,0.292691f,0.954763f},
	{-0.224368f,0.711053f,0.666381f},{-0.126502f,0.26912f,0.954763f},{-0.400757f,0.628754f,0.66638f},
	{-0.191845f,0.227209f,0.954763f},{-0.549835f,0.503606f,0.66638f},{-0.244114f,0.169814f,0.954763f},
	{-0.661443f,0.344138f,0.66638f},{-0.279747f,0.100846f,0.954763f},{-0.727974f,0.161218f,0.666381f},
	{-0.296316f,0.0250064f,0.954763f},{-0.744895f,-0.0326891f,0.666381f},{-0.292691f,-0.0525378f,0.954763f},
	{-0.711053f,-0.224368f,0.666381f},{-0.26912f,-0.126502f,0.954763f},{-0.628754f,-0.400757f,0.66638f},
	{-0.227209f,-0.191845f,0.954763f},{-0.503606f,-0.549835f,0.66638f},{-0.169814f,-0.244114f,0.954763f},
	{-0.344138f,-0.661443f,0.66638f},{-0.100846f,-0.279747f,0.954763f},{-0.161218f,-0.727974f,0.666381f},
	{-0.0250064f,-0.296316f,0.954763f},{0.0326891f,-0.744895f,0.666381f},{0.0525378f,-0.292691f,0.954763f},
	{0.224368f,-0.711053f,0.666381f},{0.126502f,-0.26912f,0.954763f},{0.400757f,-0.628754f,0.66638f},
	{0.191845f,-0.227209f,0.954763f},{0.549835f,-0.503606f,0.66638f},{0.244114f,-0.169814f,0.954763f},
	{0.661443f,-0.344138f,0.66638f},{0.279747f,-0.100846f,0.954763f},{0.727974f,-0.161218f,0.666381f},
	{0.296316f,-0.0250064f,0.954763f},{0.744895f,0.0326891f,0.666381f},{0.292691f,0.0525378f,0.954763f},
	{0.711053f,0.224368f,0.666381f},{0.26912f,0.126502f,0.954763f},{0.628754f,0.400757f,0.66638f},
	{0.227209f,0.191845f,0.954763f},{0.503606f,0.549835f,0.66638f},{0.169814f,0.244114f,0.954763f},
	{0.344138f,0.661443f,0.66638f},{-0.0220152f,-0.00388201f,-0.99975f},{-0.0222698f,0.00194827f,-0.99975f},
	{-0.098319f,0.443956f,-0.890638f},{0.0199355f,0.454276f,-0.890638f},{-0.0210067f,0.00764576f,-0.99975f},
	{0.136831f,0.433637f,-0.890638f},{-0.018312f,0.0128223f,-0.99975f},{0.244403f,0.383447f,-0.890638f},
	{-0.0143694f,0.0171249f,-0.99975f},{0.335318f,0.307125f,-0.890638f},{-0.00944765f,0.0202604f,-0.99975f},
	{0.403382f,0.209873f,-0.890638f},{-0.00388199f,0.0220152f,-0.99975f},{0.443956f,0.0983189f,-0.890638f},
	{0.00194827f,0.0222698f,-0.99975f},{0.454276f,-0.0199355f,-0.890638f},{0.00764569f,0.0210067f,-0.99975f},
	{0.433637f,-0.136831f,-0.890638f},{0.0128222f,0.018312f,-0.99975f},{0.383447f,-0.244403f,-0.890638f},
	{0.0171249f,0.0143693f,-0.99975f},{0.307125f,-0.335318f,-0.890638f},{0.0202604f,0.00944754f,-0.99975f},
	{0.209873f,-0.403382f,-0.890638f},{0.0220152f,0.00388201f,-0.99975f},{0.098319f,-0.443956f,-0.890638f},
	{0.0222698f,-0.00194827f,-0.99975f},{-0.0199355f,-0.454276f,-0.890638f},{0.0210067f,-0.00764576f,-0.99975f},
	{-0.136831f,-0.433637f,-0.890638f},{0.018312f,-0.0128223f,-0.99975f},{-0.244403f,-0.383447f,-0.890638f},
	{0.0143694f,-0.0171249f,-0.99975f},{-0.335318f,-0.307125f,-0.890638f},{0.00944765f,-0.0202604f,-0.99975f},
	{-0.403382f,-0.209873f,-0.890638f},{0.00388199f,-0.0220152f,-0.99975f},{-0.443956f,-0.0983189f,-0.890638f},
	{-0.00194827f,-0.0222698f,-0.99975f},{-0.454276f,0.0199355f,-0.890638f},{-0.00764569f,-0.0210067f,-0.99975f},
	{-0.433637f,0.136831f,-0.890638f},{-0.0128222f,-0.018312f,-0.99975f},{-0.383447f,0.244403f,-0.890638f},
	{-0.0171249f,-0.0143693f,-0.99975f},{-0.307125f,0.335318f,-0.890638f},{-0.0202604f,-0.00944754f,-0.99975f},
	{-0.209873f,0.403382f,-0.890638f}
	};
	static GLfloat textures [1336][2] = {
	{0.833333f,0.877434f},{0.689598f,0.0838223f},{0.7f,0.0851918f},
	{0.679904f,0.0798071f},{0.710403f,0.0838223f},{0.67158f,0.0734198f},
	{0.720096f,0.0798071f},{0.665193f,0.0650959f},{0.661178f,0.0554024f},
	{0.72842f,0.0734198f},{0.734807f,0.0650959f},{0.659809f,0.045f},
	{0.738822f,0.0554024f},{0.661178f,0.0345976f},{0.740192f,0.045f},
	{0.665193f,0.0249041f},{0.738822f,0.0345976f},{0.67158f,0.0165801f},
	{0.734807f,0.0249041f},{0.679904f,0.0101929f},{0.689598f,0.00617772f},
	{0.72842f,0.0165801f},{0.720096f,0.0101929f},{0.7f,0.00480825f},
	{0.710403f,0.00617772f},{0.992578f,0.186864f},{0.992578f,0.113136f},
	{0.997431f,0.15f},{0.978349f,0.221215f},{0.978349f,0.0787847f},
	{0.955714f,0.250714f},{0.955714f,0.0492863f},{0.926215f,0.273349f},
	{0.926215f,0.0266514f},{0.891864f,0.287578f},{0.891864f,0.0124225f},
	{0.855f,0.292431f},{0.855f,0.00756931f},{0.818136f,0.287578f},
	{0.818136f,0.0124225f},{0.783785f,0.273349f},{0.783785f,0.0266514f},
	{0.754286f,0.250714f},{0.754286f,0.0492863f},{0.731651f,0.0787847f},
	{0.731651f,0.221215f},{0.717423f,0.113136f},{0.717423f,0.186864f},
	{0.712569f,0.15f},{0.0452214f,0.482945f},{0.00387793f,0.50869f},
	{0.00387793f,0.482945f},{0.0452214f,0.50869f},{0.086565f,0.482945f},
	{0.086565f,0.50869f},{0.127908f,0.482945f},{0.127908f,0.50869f},
	{0.169252f,0.482945f},{0.169252f,0.50869f},{0.210595f,0.482945f},
	{0.210595f,0.50869f},{0.251939f,0.482945f},{0.251939f,0.50869f},
	{0.293282f,0.482945f},{0.293282f,0.50869f},{0.334626f,0.482945f},
	{0.334626f,0.50869f},{0.375969f,0.482945f},{0.375969f,0.50869f},
	{0.417313f,0.482945f},{0.417313f,0.50869f},{0.458656f,0.482945f},
	{0.458656f,0.50869f},{0.5f,0.482945f},{0.5f,0.50869f},
	{0.541343f,0.482945f},{0.541343f,0.50869f},{0.582687f,0.482945f},
	{0.582687f,0.50869f},{0.62403f,0.482945f},{0.62403f,0.50869f},
	{0.665374f,0.482945f},{0.665374f,0.50869f},{0.706717f,0.482945f},
	{0.706717f,0.50869f},{0.748061f,0.482945f},{0.748061f,0.50869f},
	{0.789404f,0.482945f},{0.789404f,0.50869f},{0.830748f,0.482945f},
	{0.830748f,0.50869f},{0.872092f,0.482945f},{0.872092f,0.50869f},
	{0.913435f,0.482945f},{0.913435f,0.50869f},{0.954778f,0.482945f},
	{0.954778f,0.50869f},{0.996122f,0.482945f},{0.996122f,0.50869f},
	{0.251939f,0.453871f},{0.210595f,0.453871f},{0.293282f,0.453871f},
	{0.334626f,0.453871f},{0.375969f,0.453871f},{0.417313f,0.453871f},
	{0.458656f,0.453871f},{0.5f,0.453871f},{0.541343f,0.453871f},
	{0.582687f,0.453871f},{0.62403f,0.453871f},{0.665374f,0.453871f},
	{0.706717f,0.453871f},{0.748061f,0.453871f},{0.789404f,0.453871f},
	{0.830748f,0.453871f},{0.872092f,0.453871f},{0.913435f,0.453871f},
	{0.954778f,0.453871f},{0.996122f,0.453871f},{0.0452214f,0.453871f},
	{0.00387793f,0.453871f},{0.0865649f,0.453871f},{0.127908f,0.453871f},
	{0.169252f,0.453871f},{0.210595f,0.296823f},{0.169252f,0.316521f},
	{0.169252f,0.296823f},{0.210595f,0.316521f},{0.251939f,0.296823f},
	{0.251939f,0.316521f},{0.293282f,0.296823f},{0.293282f,0.316521f},
	{0.334626f,0.296823f},{0.334626f,0.316521f},{0.375969f,0.296823f},
	{0.375969f,0.316521f},{0.417313f,0.296823f},{0.417313f,0.316521f},
	{0.458656f,0.296823f},{0.458656f,0.316521f},{0.5f,0.296823f},
	{0.5f,0.316521f},{0.541343f,0.296823f},{0.541343f,0.316521f},
	{0.582687f,0.296823f},{0.582687f,0.316521f},{0.62403f,0.296823f},
	{0.62403f,0.316521f},{0.665374f,0.296823f},{0.665374f,0.316521f},
	{0.706717f,0.296823f},{0.706717f,0.316521f},{0.748061f,0.296823f},
	{0.748061f,0.316521f},{0.789404f,0.296823f},{0.789404f,0.316521f},
	{0.830748f,0.296823f},{0.830748f,0.316521f},{0.872092f,0.296823f},
	{0.872092f,0.316521f},{0.913435f,0.296823f},{0.913435f,0.316521f},
	{0.954778f,0.296823f},{0.954778f,0.316521f},{0.996122f,0.296823f},
	{0.996122f,0.316521f},{0.0452214f,0.296823f},{0.00387793f,0.316521f},
	{0.00387793f,0.296823f},{0.0452214f,0.316521f},{0.086565f,0.296823f},
	{0.086565f,0.316521f},{0.127908f,0.296823f},{0.127908f,0.316521f},
	{0.210595f,0.326379f},{0.169252f,0.326379f},{0.251939f,0.326379f},
	{0.293282f,0.326379f},{0.334626f,0.326379f},{0.375969f,0.326379f},
	{0.417313f,0.326379f},{0.458656f,0.326379f},{0.5f,0.326379f},
	{0.541343f,0.326379f},{0.582687f,0.326379f},{0.62403f,0.326379f},
	{0.665374f,0.326379f},{0.706717f,0.326379f},{0.748061f,0.326379f},
	{0.789404f,0.326379f},{0.830748f,0.326379f},{0.872092f,0.326379f},
	{0.913435f,0.326379f},{0.954778f,0.326379f},{0.996122f,0.326379f},
	{0.0452214f,0.326379f},{0.00387793f,0.326379f},{0.086565f,0.326379f},
	{0.127908f,0.326379f},{0.5f,0.536405f},{0.541343f,0.597238f},
	{0.5f,0.597238f},{0.541343f,0.536405f},{0.458656f,0.597238f},
	{0.458656f,0.536405f},{0.417313f,0.597238f},{0.417313f,0.536405f},
	{0.433734f,0.597238f},{0.400892f,0.597238f},{0.375969f,0.536405f},
	{0.334626f,0.597238f},{0.334626f,0.536405f},{0.375969f,0.597238f},
	{0.293282f,0.597238f},{0.293282f,0.536405f},{0.251939f,0.597238f},
	{0.251939f,0.536405f},{0.26836f,0.597238f},{0.210595f,0.536405f},
	{0.235518f,0.597238f},{0.210595f,0.597238f},{0.169252f,0.536405f},
	{0.169252f,0.597238f},{0.127908f,0.536405f},{0.127908f,0.597238f},
	{0.102986f,0.597238f},{0.086565f,0.536405f},{0.086565f,0.597238f},
	{0.0452214f,0.536405f},{0.0701439f,0.597238f},{0.0452214f,0.597238f},
	{0.00387793f,0.536405f},{0.00387793f,0.597238f},{0.954778f,0.597238f},
	{0.996122f,0.536405f},{0.996122f,0.597238f},{0.954778f,0.536405f},
	{0.913435f,0.597238f},{0.913435f,0.536405f},{0.872092f,0.597238f},
	{0.872092f,0.536405f},{0.830748f,0.597238f},{0.830748f,0.536405f},
	{0.789404f,0.597238f},{0.789404f,0.536405f},{0.748061f,0.597238f},
	{0.764482f,0.597238f},{0.748061f,0.536405f},{0.706717f,0.536405f},
	{0.73164f,0.597238f},{0.665374f,0.536405f},{0.706717f,0.597238f},
	{0.665374f,0.597238f},{0.62403f,0.536405f},{0.62403f,0.597238f},
	{0.582687f,0.536405f},{0.582687f,0.597238f},{0.5f,0.620583f},
	{0.541343f,0.620583f},{0.458656f,0.620583f},{0.417313f,0.622226f},
	{0.433734f,0.622226f},{0.400892f,0.622226f},{0.334626f,0.620583f},
	{0.375969f,0.620583f},{0.293282f,0.620583f},{0.251939f,0.622226f},
	{0.26836f,0.622226f},{0.235518f,0.622226f},{0.210595f,0.620583f},
	{0.169252f,0.620583f},{0.127908f,0.620583f},{0.102986f,0.622226f},
	{0.086565f,0.622226f},{0.0701439f,0.622226f},{0.0452214f,0.620583f},
	{0.00387793f,0.620583f},{0.996122f,0.620583f},{0.954778f,0.620583f},
	{0.913435f,0.620583f},{0.872092f,0.620583f},{0.830748f,0.620583f},
	{0.789404f,0.620583f},{0.764482f,0.622226f},{0.748061f,0.622226f},
	{0.73164f,0.622226f},{0.665374f,0.620583f},{0.706717f,0.620583f},
	{0.62403f,0.620583f},{0.582687f,0.620583f},{0.5f,0.645131f},
	{0.541343f,0.645131f},{0.458656f,0.645131f},{0.417313f,0.635328f},
	{0.433734f,0.635328f},{0.400892f,0.635328f},{0.334626f,0.645131f},
	{0.375969f,0.645131f},{0.293282f,0.645131f},{0.251939f,0.635328f},
	{0.26836f,0.635328f},{0.235518f,0.635328f},{0.210595f,0.645131f},
	{0.169252f,0.645131f},{0.127908f,0.645131f},{0.102986f,0.635328f},
	{0.086565f,0.635328f},{0.0701439f,0.635328f},{0.0452214f,0.645131f},
	{0.00387793f,0.645131f},{0.996122f,0.645131f},{0.954778f,0.645131f},
	{0.913435f,0.645131f},{0.872092f,0.645131f},{0.830748f,0.645131f},
	{0.789404f,0.645131f},{0.764482f,0.635328f},{0.748061f,0.635328f},
	{0.73164f,0.635328f},{0.665374f,0.645131f},{0.706717f,0.645131f},
	{0.62403f,0.645131f},{0.582687f,0.645131f},{0.541343f,0.664846f},
	{0.5f,0.664846f},{0.458656f,0.664846f},{0.417313f,0.645131f},
	{0.375969f,0.645131f},{0.334626f,0.664846f},{0.375969f,0.664846f},
	{0.293282f,0.664846f},{0.251939f,0.645131f},{0.210595f,0.645131f},
	{0.210595f,0.664846f},{0.169252f,0.664846f},{0.127908f,0.664846f},
	{0.086565f,0.645131f},{0.0452214f,0.645131f},{0.0452214f,0.664846f},
	{0.00387793f,0.664846f},{0.954778f,0.664846f},{0.996122f,0.664846f},
	{0.913435f,0.664846f},{0.872092f,0.664846f},{0.830748f,0.664846f},
	{0.789404f,0.664846f},{0.748061f,0.645131f},{0.706717f,0.645131f},
	{0.706717f,0.664846f},{0.665374f,0.664846f},{0.62403f,0.664846f},
	{0.582687f,0.664846f},{0.541343f,0.682511f},{0.5f,0.682511f},
	{0.458656f,0.682511f},{0.417313f,0.664846f},{0.417313f,0.682511f},
	{0.375969f,0.682511f},{0.334626f,0.682511f},{0.293282f,0.682511f},
	{0.251939f,0.664846f},{0.251939f,0.682511f},{0.210595f,0.682511f},
	{0.169252f,0.682511f},{0.127908f,0.682511f},{0.086565f,0.682511f},
	{0.086565f,0.664846f},{0.0452214f,0.682511f},{0.00387793f,0.682511f},
	{0.954778f,0.682511f},{0.996122f,0.682511f},{0.913435f,0.682511f},
	{0.872092f,0.682511f},{0.830748f,0.682511f},{0.789404f,0.682511f},
	{0.748061f,0.682511f},{0.748061f,0.664846f},{0.706717f,0.682511f},
	{0.665374f,0.682511f},{0.62403f,0.682511f},{0.582687f,0.682511f},
	{0.0873171f,0.00496423f},{0.0707076f,0.0767393f},{0.0707076f,0.00496423f},
	{0.0873171f,0.0767393f},{0.0873171f,0.206831f},{0.0707076f,0.206831f},
	{0.0476387f,0.0767393f},{0.0476387f,0.00496423f},{0.0476387f,0.206831f},
	{0.188851f,0.00496423f},{0.165783f,0.0767393f},{0.165783f,0.00496423f},
	{0.188851f,0.0767393f},{0.188851f,0.206831f},{0.165783f,0.206831f},
	{0.143637f,0.0767393f},{0.143637f,0.00496423f},{0.143637f,0.206831f},
	{0.115147f,0.00496423f},{0.13637f,0.0767393f},{0.13637f,0.00496423f},
	{0.115147f,0.0767393f},{0.13637f,0.0767393f},{0.115147f,0.206831f},
	{0.13637f,0.206831f},{0.23975f,0.00496423f},{0.260974f,0.0767393f},
	{0.260974f,0.00496423f},{0.23975f,0.0767393f},{0.260974f,0.206831f},
	{0.23975f,0.0767393f},{0.23975f,0.206831f},{0.02457f,0.0767393f},
	{0.02457f,0.00496423f},{0.02457f,0.206831f},{0.21192f,0.00496423f},
	{0.21192f,0.0767393f},{0.21192f,0.206831f},{0.093924f,0.00496423f},
	{0.093924f,0.0767393f},{0.093924f,0.206831f},{0.093924f,0.0767393f},
	{0.282197f,0.0767393f},{0.282197f,0.00496423f},{0.282197f,0.206831f},
	{0.00796044f,0.0767393f},{0.00796044f,0.00496423f},{0.00796044f,0.206831f},
	{0.234066f,0.00496423f},{0.234066f,0.0767393f},{0.234066f,0.206831f},
	{0.380193f,0.00496423f},{0.401416f,0.0767393f},{0.401416f,0.00496423f},
	{0.380193f,0.0767393f},{0.401416f,0.206831f},{0.380193f,0.0767393f},
	{0.380193f,0.206831f},{0.308255f,0.00496423f},{0.286109f,0.0767393f},
	{0.286109f,0.00496423f},{0.308255f,0.0767393f},{0.286109f,0.0767393f},
	{0.308255f,0.206831f},{0.286109f,0.206831f},{0.376539f,0.00496423f},
	{0.354393f,0.0767393f},{0.354393f,0.00496423f},{0.376539f,0.0767393f},
	{0.354393f,0.206831f},{0.376539f,0.0767393f},{0.376539f,0.206831f},
	{0.422639f,0.0767393f},{0.422639f,0.00496423f},{0.422639f,0.0767393f},
	{0.422639f,0.206831f},{0.331324f,0.00496423f},{0.331324f,0.0767393f},
	{0.331324f,0.206831f},{0.0707076f,0.292064f},{0.0873171f,0.292064f},
	{0.13637f,0.292064f},{0.115147f,0.292064f},{0.0476387f,0.292064f},
	{0.165783f,0.292064f},{0.188851f,0.292064f},{0.260974f,0.292064f},
	{0.23975f,0.206831f},{0.23975f,0.292064f},{0.143637f,0.292064f},
	{0.02457f,0.292064f},{0.21192f,0.292064f},{0.093924f,0.206831f},
	{0.093924f,0.292064f},{0.00796044f,0.292064f},{0.234066f,0.292064f},
	{0.282197f,0.292064f},{0.282197f,0.206831f},{0.401416f,0.292064f},
	{0.380193f,0.206831f},{0.380193f,0.292064f},{0.286109f,0.292064f},
	{0.308255f,0.292064f},{0.354393f,0.292064f},{0.376539f,0.206831f},
	{0.376539f,0.292064f},{0.422639f,0.292064f},{0.331324f,0.292064f},
	{0.416667f,0.928725f},{0.458333f,0.932075f},{0.416667f,0.932075f},
	{0.458333f,0.928725f},{0.5f,0.932075f},{0.458333f,0.932075f},
	{0.5f,0.928725f},{0.541667f,0.932075f},{0.5f,0.932075f},
	{0.541667f,0.928725f},{0.583333f,0.932075f},{0.541667f,0.932075f},
	{0.583333f,0.928725f},{0.625f,0.932075f},{0.583333f,0.932075f},
	{0.625f,0.928725f},{0.666667f,0.932075f},{0.625f,0.932075f},
	{0.666667f,0.928725f},{0.708333f,0.932075f},{0.666667f,0.932075f},
	{0.708333f,0.928725f},{0.75f,0.932075f},{0.708333f,0.932075f},
	{0.75f,0.928725f},{0.75f,0.932075f},{0.791667f,0.928725f},
	{0.791667f,0.932075f},{0.791667f,0.932075f},{0.833333f,0.928725f},
	{0.833333f,0.932075f},{0.833333f,0.932075f},{0.875f,0.928725f},
	{0.875f,0.932075f},{0.916667f,0.928725f},{0.916667f,0.932075f},
	{0.916667f,0.932075f},{0.958333f,0.928725f},{0.958333f,0.932075f},
	{0.958333f,0.932075f},{1.0f,0.928725f},{1.0f,0.932075f},
	{-9.76026e-009f,0.932075f},{0.0416666f,0.928725f},{0.0416666f,0.932075f},
	{-9.76026e-009f,0.928725f},{0.0416666f,0.932075f},{0.0833334f,0.928725f},
	{0.0833334f,0.932075f},{0.0833334f,0.932075f},{0.125f,0.928725f},
	{0.125f,0.932075f},{0.125f,0.932075f},{0.166667f,0.928725f},
	{0.166667f,0.932075f},{0.166667f,0.932075f},{0.208333f,0.928725f},
	{0.208333f,0.932075f},{0.208333f,0.932075f},{0.25f,0.928725f},
	{0.25f,0.932075f},{0.291667f,0.932075f},{0.25f,0.932075f},
	{0.291667f,0.928725f},{0.333333f,0.932075f},{0.291667f,0.932075f},
	{0.333333f,0.928725f},{0.375f,0.932075f},{0.333333f,0.932075f},
	{0.375f,0.928725f},{0.416667f,0.932075f},{0.375f,0.932075f},
	{0.458333f,0.92489f},{0.416667f,0.92489f},{0.5f,0.92489f},
	{0.541667f,0.92489f},{0.583333f,0.92489f},{0.625f,0.92489f},
	{0.666667f,0.92489f},{0.708333f,0.92489f},{0.75f,0.92489f},
	{0.791667f,0.92489f},{0.833333f,0.92489f},{0.875f,0.92489f},
	{0.916667f,0.92489f},{0.958333f,0.92489f},{1.0f,0.92489f},
	{-9.76026e-009f,0.92489f},{0.0416666f,0.92489f},{0.0833334f,0.92489f},
	{0.125f,0.92489f},{0.166667f,0.92489f},{0.208333f,0.92489f},
	{0.25f,0.92489f},{0.291667f,0.92489f},{0.333333f,0.92489f},
	{0.375f,0.92489f},{0.416667f,0.916394f},{0.458333f,0.916394f},
	{0.5f,0.916394f},{0.541667f,0.916394f},{0.583333f,0.916394f},
	{0.625f,0.916394f},{0.666667f,0.916394f},{0.708333f,0.916394f},
	{0.75f,0.916394f},{0.791667f,0.916394f},{0.833333f,0.916394f},
	{0.875f,0.916394f},{0.916667f,0.916394f},{0.958333f,0.916394f},
	{1.0f,0.916394f},{0.0416666f,0.916394f},{-9.76026e-009f,0.916394f},
	{0.0833334f,0.916394f},{0.125f,0.916394f},{0.166667f,0.916394f},
	{0.208333f,0.916394f},{0.25f,0.916394f},{0.291667f,0.916394f},
	{0.333333f,0.916394f},{0.375f,0.916394f},{0.458333f,0.901894f},
	{0.416667f,0.901894f},{0.5f,0.901894f},{0.541667f,0.901894f},
	{0.583333f,0.901894f},{0.625f,0.901894f},{0.666667f,0.901894f},
	{0.708333f,0.901894f},{0.75f,0.901894f},{0.791667f,0.901894f},
	{0.833333f,0.901894f},{0.875f,0.901894f},{0.916667f,0.901894f},
	{0.958333f,0.901894f},{1.0f,0.901894f},{-9.76026e-009f,0.901894f},
	{0.0416666f,0.901894f},{-9.76026e-009f,0.916394f},{0.0833334f,0.901894f},
	{0.125f,0.901894f},{0.166667f,0.901894f},{0.208333f,0.901894f},
	{0.25f,0.901894f},{0.291667f,0.901894f},{0.333333f,0.901894f},
	{0.375f,0.901894f},{0.25f,0.883031f},{0.208333f,0.883032f},
	{0.208333f,0.883032f},{0.166667f,0.883032f},{0.166667f,0.883032f},
	{0.125f,0.883031f},{0.125f,0.883031f},{0.0833334f,0.883032f},
	{0.0833334f,0.883032f},{0.0416666f,0.883031f},{0.0416666f,0.883031f},
	{-9.76026e-009f,0.901894f},{-9.76026e-009f,0.883032f},{0.25f,0.883031f},
	{0.291667f,0.883031f},{0.291667f,0.883031f},{0.333333f,0.883031f},
	{0.333333f,0.883031f},{0.375f,0.883031f},{0.375f,0.883031f},
	{0.416667f,0.883031f},{0.416667f,0.883031f},{0.458333f,0.883031f},
	{0.458333f,0.883031f},{0.5f,0.883032f},{0.75f,0.883032f},
	{0.791667f,0.883032f},{0.791667f,0.883032f},{0.833333f,0.883031f},
	{0.833333f,0.883031f},{0.875f,0.883032f},{0.916667f,0.883031f},
	{0.916667f,0.883031f},{0.958333f,0.883032f},{0.958333f,0.883032f},
	{1.0f,0.883032f},{0.75f,0.883032f},{0.708333f,0.883032f},
	{0.708333f,0.883032f},{0.666667f,0.883031f},{0.666667f,0.883031f},
	{0.625f,0.883032f},{0.583333f,0.883032f},{0.583333f,0.883032f},
	{0.541667f,0.883032f},{0.541667f,0.883032f},{0.5f,0.883032f},
	{0.75f,0.999942f},{0.791667f,0.992004f},{0.791667f,0.999942f},
	{0.75f,0.992004f},{0.791667f,0.999942f},{0.833333f,0.992004f},
	{0.833333f,0.999942f},{0.875f,0.992004f},{0.875f,0.999942f},
	{0.875f,0.999942f},{0.916667f,0.992004f},{0.916667f,0.999942f},
	{0.958333f,0.992004f},{0.958333f,0.999942f},{0.958333f,0.999942f},
	{1.0f,0.992004f},{1.0f,0.999942f},{0.000100007f,0.999942f},
	{0.04135f,0.992004f},{0.04135f,0.999942f},{0.000100007f,0.992004f},
	{0.0416666f,0.999942f},{0.0833334f,0.992004f},{0.0833334f,0.999942f},
	{0.0416666f,0.992004f},{0.0833334f,0.999942f},{0.125f,0.992004f},
	{0.125f,0.999942f},{0.166667f,0.992004f},{0.166667f,0.999942f},
	{0.166667f,0.999942f},{0.208333f,0.992004f},{0.208333f,0.999942f},
	{0.208333f,0.999942f},{0.25f,0.992004f},{0.25f,0.999942f},
	{0.291667f,0.999942f},{0.291667f,0.992004f},{0.333333f,0.999942f},
	{0.333333f,0.992004f},{0.375f,0.999942f},{0.375f,0.992004f},
	{0.416667f,0.999942f},{0.416667f,0.992004f},{0.458333f,0.999942f},
	{0.458333f,0.992004f},{0.5f,0.999942f},{0.5f,0.992004f},
	{0.541667f,0.999942f},{0.5f,0.999942f},{0.541667f,0.992004f},
	{0.583333f,0.999942f},{0.541667f,0.999942f},{0.583333f,0.992004f},
	{0.625f,0.999942f},{0.583333f,0.999942f},{0.625f,0.992004f},
	{0.666667f,0.999942f},{0.625f,0.999942f},{0.666667f,0.992004f},
	{0.708333f,0.999942f},{0.708333f,0.992004f},{0.75f,0.999942f},
	{0.708333f,0.999942f},{0.416667f,0.988601f},{0.458333f,0.991951f},
	{0.416667f,0.991951f},{0.458333f,0.988601f},{0.5f,0.991951f},
	{0.5f,0.988601f},{0.541667f,0.991951f},{0.541667f,0.988601f},
	{0.583333f,0.991951f},{0.583333f,0.988601f},{0.625f,0.991951f},
	{0.625f,0.988601f},{0.666667f,0.991951f},{0.666667f,0.988601f},
	{0.708333f,0.991951f},{0.708333f,0.988601f},{0.75f,0.991951f},
	{0.75f,0.988601f},{0.791667f,0.988601f},{0.791667f,0.991951f},
	{0.833333f,0.988601f},{0.833333f,0.991951f},{0.875f,0.988601f},
	{0.875f,0.991951f},{0.916667f,0.988601f},{0.916667f,0.991951f},
	{0.958333f,0.988601f},{0.958333f,0.991951f},{1.0f,0.988601f},
	{1.0f,0.991951f},{-9.76026e-009f,0.991951f},{0.0416666f,0.988601f},
	{0.0416666f,0.991951f},{-9.76026e-009f,0.988601f},{0.0833334f,0.988601f},
	{0.0833334f,0.991951f},{0.125f,0.988601f},{0.125f,0.991951f},
	{0.166667f,0.988601f},{0.166667f,0.991951f},{0.208333f,0.988601f},
	{0.208333f,0.991951f},{0.25f,0.988601f},{0.25f,0.991951f},
	{0.291667f,0.991951f},{0.291667f,0.988601f},{0.333333f,0.991951f},
	{0.333333f,0.988601f},{0.375f,0.991951f},{0.375f,0.988601f},
	{0.458333f,0.984765f},{0.416667f,0.984765f},{0.5f,0.984765f},
	{0.541667f,0.984765f},{0.583333f,0.984765f},{0.625f,0.984765f},
	{0.666667f,0.984765f},{0.708333f,0.984765f},{0.75f,0.984765f},
	{0.791667f,0.984765f},{0.833333f,0.984765f},{0.875f,0.984765f},
	{0.916667f,0.984765f},{0.958333f,0.984765f},{1.0f,0.984765f},
	{-9.76026e-009f,0.984765f},{0.0416666f,0.984765f},{0.0833334f,0.984765f},
	{0.125f,0.984765f},{0.166667f,0.984765f},{0.208333f,0.984765f},
	{0.25f,0.984765f},{0.291667f,0.984765f},{0.333333f,0.984765f},
	{0.375f,0.984765f},{0.416667f,0.976269f},{0.458333f,0.976269f},
	{0.5f,0.976269f},{0.541667f,0.976269f},{0.583333f,0.976269f},
	{0.625f,0.976269f},{0.666667f,0.976269f},{0.708333f,0.976269f},
	{0.75f,0.976269f},{0.791667f,0.976269f},{0.833333f,0.976269f},
	{0.875f,0.976269f},{0.916667f,0.976269f},{0.958333f,0.976269f},
	{1.0f,0.976269f},{0.0416666f,0.976269f},{-9.76026e-009f,0.976269f},
	{0.0833334f,0.976269f},{0.125f,0.976269f},{0.166667f,0.976269f},
	{0.208333f,0.976269f},{0.25f,0.976269f},{0.291667f,0.976269f},
	{0.333333f,0.976269f},{0.375f,0.976269f},{0.458333f,0.96177f},
	{0.416667f,0.96177f},{0.5f,0.96177f},{0.541667f,0.96177f},
	{0.583333f,0.96177f},{0.625f,0.96177f},{0.666667f,0.96177f},
	{0.708333f,0.96177f},{0.75f,0.96177f},{0.791667f,0.96177f},
	{0.833333f,0.96177f},{0.875f,0.96177f},{0.916667f,0.96177f},
	{0.958333f,0.96177f},{1.0f,0.96177f},{-9.76026e-009f,0.96177f},
	{0.0416666f,0.96177f},{0.0833334f,0.96177f},{0.125f,0.96177f},
	{0.166667f,0.96177f},{0.208333f,0.96177f},{0.25f,0.96177f},
	{0.291667f,0.96177f},{0.333333f,0.96177f},{0.375f,0.96177f},
	{0.25f,0.942907f},{0.208333f,0.942908f},{0.166667f,0.942908f},
	{0.125f,0.942907f},{0.0833334f,0.942908f},{0.0416666f,0.942907f},
	{-9.76026e-009f,0.96177f},{-9.76026e-009f,0.942908f},{0.291667f,0.942907f},
	{0.333333f,0.942907f},{0.375f,0.942907f},{0.416667f,0.942907f},
	{0.458333f,0.942907f},{0.5f,0.942908f},{0.75f,0.942908f},
	{0.791667f,0.942908f},{0.833333f,0.942907f},{0.875f,0.942908f},
	{0.916667f,0.942907f},{0.958333f,0.942908f},{1.0f,0.942908f},
	{0.708333f,0.942908f},{0.666667f,0.942907f},{0.625f,0.942908f},
	{0.583333f,0.942908f},{0.541667f,0.942908f},{0.75f,0.940066f},
	{0.791667f,0.932128f},{0.791667f,0.940066f},{0.75f,0.932128f},
	{0.791667f,0.940066f},{0.833333f,0.932128f},{0.833333f,0.940066f},
	{0.791667f,0.932128f},{0.833333f,0.940066f},{0.875f,0.932128f},
	{0.875f,0.940066f},{0.833333f,0.932128f},{0.875f,0.940066f},
	{0.916667f,0.932128f},{0.916667f,0.940066f},{0.875f,0.932128f},
	{0.916667f,0.940066f},{0.958333f,0.932128f},{0.958333f,0.940066f},
	{0.916667f,0.932128f},{0.958333f,0.940066f},{1.0f,0.932128f},
	{1.0f,0.940066f},{0.958333f,0.932128f},{0.000100007f,0.940066f},
	{0.04135f,0.932128f},{0.04135f,0.940066f},{0.000100007f,0.932128f},
	{0.0416666f,0.940066f},{0.0833334f,0.932128f},{0.0833334f,0.940066f},
	{0.0416666f,0.932128f},{0.0833334f,0.940066f},{0.125f,0.932128f},
	{0.125f,0.940066f},{0.0833334f,0.932128f},{0.125f,0.940066f},
	{0.166667f,0.932128f},{0.166667f,0.940066f},{0.125f,0.932128f},
	{0.166667f,0.940066f},{0.208333f,0.932128f},{0.208333f,0.940066f},
	{0.166667f,0.932128f},{0.208333f,0.940066f},{0.25f,0.932128f},
	{0.25f,0.940066f},{0.208333f,0.932128f},{0.25f,0.932128f},
	{0.291667f,0.940066f},{0.25f,0.940066f},{0.291667f,0.932128f},
	{0.291667f,0.932128f},{0.333333f,0.940066f},{0.291667f,0.940066f},
	{0.333333f,0.932128f},{0.333333f,0.932128f},{0.375f,0.940066f},
	{0.333333f,0.940066f},{0.375f,0.932128f},{0.375f,0.932128f},
	{0.416667f,0.940066f},{0.375f,0.940066f},{0.416667f,0.932128f},
	{0.416667f,0.932128f},{0.458333f,0.940066f},{0.416667f,0.940066f},
	{0.458333f,0.932128f},{0.458333f,0.932128f},{0.5f,0.940066f},
	{0.458333f,0.940066f},{0.5f,0.932128f},{0.5f,0.932128f},
	{0.541667f,0.940066f},{0.5f,0.940066f},{0.541667f,0.932128f},
	{0.541667f,0.932128f},{0.583333f,0.940066f},{0.541667f,0.940066f},
	{0.583333f,0.932128f},{0.583333f,0.932128f},{0.625f,0.940066f},
	{0.583333f,0.940066f},{0.625f,0.932128f},{0.625f,0.932128f},
	{0.666667f,0.940066f},{0.625f,0.940066f},{0.666667f,0.932128f},
	{0.666667f,0.932128f},{0.708333f,0.940066f},{0.666667f,0.940066f},
	{0.708333f,0.932128f},{0.708333f,0.932128f},{0.75f,0.940066f},
	{0.708333f,0.940066f},{0.75f,0.932128f},{0.25f,0.688802f},
	{0.208333f,0.718573f},{0.208333f,0.688802f},{0.25f,0.718573f},
	{0.208333f,0.688802f},{0.166667f,0.718573f},{0.166667f,0.688802f},
	{0.291667f,0.718573f},{0.25f,0.688802f},{0.291667f,0.688802f},
	{0.333333f,0.718573f},{0.291667f,0.688802f},{0.333333f,0.688802f},
	{0.166667f,0.688802f},{0.125f,0.718573f},{0.125f,0.688802f},
	{0.125f,0.688802f},{0.0833333f,0.718573f},{0.0833333f,0.688802f},
	{0.375f,0.718573f},{0.333333f,0.688802f},{0.375f,0.688802f},
	{0.416667f,0.718573f},{0.375f,0.688802f},{0.416667f,0.688802f},
	{0.0833333f,0.688802f},{0.0416667f,0.718573f},{0.0416667f,0.688802f},
	{0.458333f,0.718573f},{0.416667f,0.688802f},{0.458333f,0.688802f},
	{0.0416667f,0.688802f},{-4.64916e-008f,0.718573f},{-4.64916e-008f,0.688802f},
	{0.0416667f,0.718573f},{0.5f,0.718573f},{0.458333f,0.688802f},
	{0.5f,0.688802f},{1.0f,0.718573f},{0.958333f,0.688802f},
	{1.0f,0.688802f},{0.958333f,0.718573f},{0.541667f,0.688802f},
	{0.5f,0.688802f},{0.541667f,0.718573f},{0.916667f,0.688802f},
	{0.958333f,0.688802f},{0.916667f,0.718573f},{0.583333f,0.688802f},
	{0.541667f,0.688802f},{0.583333f,0.718573f},{0.875f,0.688802f},
	{0.916667f,0.688802f},{0.875f,0.718573f},{0.625f,0.688802f},
	{0.583333f,0.688802f},{0.625f,0.718573f},{0.833333f,0.688802f},
	{0.875f,0.688802f},{0.833333f,0.718573f},{0.666667f,0.688802f},
	{0.625f,0.688802f},{0.666667f,0.718573f},{0.791667f,0.688802f},
	{0.833333f,0.688802f},{0.791667f,0.718573f},{0.708333f,0.688802f},
	{0.666667f,0.688802f},{0.708333f,0.718573f},{0.75f,0.688802f},
	{0.791667f,0.688802f},{0.75f,0.718573f},{0.75f,0.688802f},
	{0.708333f,0.688802f},{0.875f,0.759873f},{0.833333f,0.759873f},
	{0.791667f,0.759873f},{0.75f,0.759873f},{0.708333f,0.759873f},
	{0.666667f,0.759873f},{0.625f,0.759873f},{0.583333f,0.759873f},
	{0.541667f,0.759873f},{0.5f,0.759873f},{0.458333f,0.759873f},
	{0.416667f,0.759873f},{0.375f,0.759873f},{0.333333f,0.759873f},
	{0.291667f,0.759873f},{0.25f,0.759873f},{0.208333f,0.759873f},
	{0.166667f,0.759873f},{0.125f,0.759873f},{0.0833333f,0.759873f},
	{0.0416667f,0.759873f},{-4.64916e-008f,0.718573f},{-4.64916e-008f,0.759873f},
	{1.0f,0.759873f},{0.958333f,0.759873f},{0.916667f,0.759873f},
	{0.847333f,0.826228f},{0.875f,0.787382f},{0.859f,0.826228f},
	{0.833333f,0.787382f},{0.791667f,0.787382f},{0.764f,0.826228f},
	{0.775667f,0.826228f},{0.75f,0.787382f},{0.708333f,0.787382f},
	{0.666667f,0.787382f},{0.692333f,0.826228f},{0.680667f,0.826228f},
	{0.625f,0.787382f},{0.583333f,0.787382f},{0.609f,0.826228f},
	{0.597333f,0.826228f},{0.541667f,0.787382f},{0.5f,0.787382f},
	{0.525667f,0.826228f},{0.514f,0.826228f},{0.458333f,0.787382f},
	{0.430667f,0.826228f},{0.416667f,0.787382f},{0.442333f,0.826228f},
	{0.375f,0.787382f},{0.347333f,0.826228f},{0.333333f,0.787382f},
	{0.359f,0.826228f},{0.291667f,0.787382f},{0.264f,0.826228f},
	{0.25f,0.787382f},{0.275667f,0.826228f},{0.208333f,0.787382f},
	{0.192333f,0.826228f},{0.166667f,0.787382f},{0.180667f,0.826228f},
	{0.125f,0.787382f},{0.109f,0.826228f},{0.0833333f,0.787382f},
	{0.0973333f,0.826228f},{0.0416667f,0.787382f},{0.0256667f,0.826228f},
	{-4.64916e-008f,0.787382f},{0.014f,0.826228f},{0.958333f,0.787382f},
	{1.0f,0.787382f},{0.930667f,0.826228f},{0.942333f,0.826228f},
	{0.916667f,0.787382f},{0.847333f,0.856245f},{0.859f,0.856245f},
	{0.791667f,0.877434f},{0.764f,0.856245f},{0.775667f,0.856245f},
	{0.75f,0.877434f},{0.708333f,0.877434f},{0.692333f,0.856245f},
	{0.680667f,0.856245f},{0.666667f,0.877434f},{0.625f,0.877434f},
	{0.609f,0.856245f},{0.597333f,0.856245f},{0.583333f,0.877434f},
	{0.541667f,0.877434f},{0.525667f,0.856245f},{0.514f,0.856245f},
	{0.5f,0.877434f},{0.458333f,0.877434f},{0.442333f,0.856245f},
	{0.430667f,0.856245f},{0.416667f,0.877434f},{0.375f,0.877434f},
	{0.359f,0.856245f},{0.347333f,0.856245f},{0.333333f,0.877434f},
	{0.291667f,0.877434f},{0.275667f,0.856245f},{0.264f,0.856245f},
	{0.208333f,0.877434f},{0.25f,0.877434f},{0.180667f,0.856245f},
	{0.192333f,0.856245f},{0.125f,0.877434f},{0.166667f,0.877434f},
	{0.0973333f,0.856245f},{0.109f,0.856245f},{0.0416667f,0.877434f},
	{0.0833333f,0.877434f},{0.014f,0.856245f},{0.0256667f,0.856245f},
	{0.014f,0.826228f},{0.958333f,0.877434f},{1.0f,0.8774f},
	{0.930667f,0.856245f},{0.942333f,0.856245f},{0.875f,0.877434f},
	{0.916667f,0.877434f},{0.875f,0.877434f},{0.75f,0.877434f},
	{0.791667f,0.877434f},{0.708333f,0.877434f},{0.666667f,0.877434f},
	{0.625f,0.877434f},{0.583333f,0.877434f},{0.541667f,0.877434f},
	{0.5f,0.877434f},{0.458333f,0.877434f},{0.416667f,0.877434f},
	{0.375f,0.877434f},{0.333333f,0.877434f},{0.291667f,0.877434f},
	{0.25f,0.877434f},{-4.64916e-008f,0.877434f},{0.014f,0.856245f},
	{0.916667f,0.877434f},{-4.64916e-008f,0.787382f},{0.833333f,0.877434f},
	{0.75f,0.877434f},{0.609f,0.826228f},{0.625f,0.877434f},
	{0.609f,0.856245f},{0.625f,0.787382f},{0.458333f,0.877434f},
	{0.416667f,0.877434f},{0.375f,0.877434f},{0.333333f,0.877434f},
	{0.347333f,0.826228f},{0.347333f,0.856245f},{0.333333f,0.787382f},
	{0.291667f,0.877434f},{0.0416667f,0.877434f},{1.22488e-007f,0.8774f},
	{0.0139999f,0.826228f},{0.0139999f,0.856245f},{-5.63264e-008f,0.787382f},
	{0.916667f,0.877434f},{0.541667f,0.877434f},{0.5f,0.877434f},
	{0.583333f,0.877434f},{0.708333f,0.877434f},{0.791667f,0.877434f},
	{0.591642f,0.121618f},{0.60326f,0.14174f},{0.596126f,0.132444f},
	{0.612556f,0.148874f},{0.590112f,0.11f},{0.623382f,0.153358f},
	{0.591642f,0.0983822f},{0.635f,0.154888f},{0.596126f,0.0875561f},
	{0.646618f,0.153358f},{0.60326f,0.0782596f},{0.657444f,0.148874f},
	{0.612556f,0.0711261f},{0.66674f,0.14174f},{0.623382f,0.0666418f},
	{0.673874f,0.132444f},{0.635f,0.0651123f},{0.678358f,0.121618f},
	{0.646618f,0.0666418f},{0.679888f,0.11f},{0.657444f,0.0711261f},
	{0.678358f,0.0983822f},{0.66674f,0.0782596f},{0.673874f,0.0875561f},
	{0.210595f,0.528618f},{0.251939f,0.528618f},{0.293282f,0.528618f},
	{0.334626f,0.528618f},{0.375969f,0.528618f},{0.417313f,0.528618f},
	{0.458656f,0.528618f},{0.5f,0.528618f},{0.541343f,0.528618f},
	{0.582687f,0.528618f},{0.62403f,0.528618f},{0.665374f,0.528618f},
	{0.706717f,0.528618f},{0.748061f,0.528618f},{0.789404f,0.528618f},
	{0.830748f,0.528618f},{0.872092f,0.528618f},{0.913435f,0.528618f},
	{0.954778f,0.528618f},{0.996122f,0.528618f},{0.00387793f,0.528618f},
	{0.0452214f,0.528618f},{0.086565f,0.528618f},{0.127908f,0.528618f},
	{0.169252f,0.528618f},{0.293282f,0.441509f},{0.251939f,0.441509f},
	{0.293282f,0.428389f},{0.251939f,0.428389f},{0.210595f,0.441509f},
	{0.210595f,0.428389f},{0.169252f,0.441509f},{0.169252f,0.428389f},
	{0.127908f,0.441509f},{0.127908f,0.428389f},{0.086565f,0.441509f},
	{0.086565f,0.428389f},{0.0452214f,0.441509f},{0.0452214f,0.428389f},
	{0.00387793f,0.441509f},{0.00387793f,0.441406f},{0.00387793f,0.428389f},
	{0.996122f,0.441509f},{0.954778f,0.441509f},{0.996122f,0.428389f},
	{0.954778f,0.428389f},{0.913435f,0.441509f},{0.913435f,0.428389f},
	{0.872092f,0.441509f},{0.872092f,0.428389f},{0.830748f,0.441509f},
	{0.830748f,0.428389f},{0.789404f,0.441509f},{0.789404f,0.428389f},
	{0.748061f,0.441509f},{0.748061f,0.428389f},{0.706717f,0.441509f},
	{0.706717f,0.428389f},{0.665374f,0.441509f},{0.665374f,0.428389f},
	{0.62403f,0.441509f},{0.62403f,0.428389f},{0.582687f,0.441509f},
	{0.582687f,0.428389f},{0.541343f,0.441509f},{0.541343f,0.428389f},
	{0.5f,0.441509f},{0.5f,0.428389f},{0.458656f,0.441509f},
	{0.458656f,0.428389f},{0.417313f,0.441509f},{0.417313f,0.428389f},
	{0.375969f,0.441509f},{0.375969f,0.428389f},{0.334626f,0.441509f},
	{0.334626f,0.428389f}
	};
	GLint GenFeederBase()
	{
		GLint lid=glGenLists(1);
		glNewList(lid, GL_COMPILE);
		
			glBegin (GL_TRIANGLES);
			for(size_t i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
			{
				for(size_t j=0;j<3;j++)
				{
					int vi=face_indicies[i][j];
					int ni=face_indicies[i][j+3];//Normal index
					int ti=face_indicies[i][j+6];//Texture index
					/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
					glTexCoord2f(textures[ti][0],textures[ti][1]);
					glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
					
					// rotate 90 deg around z
					glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
					glTexCoord2f(textures[ti][0],textures[ti][1]);
					glVertex3f (100.f*vertices[vi][1],-100.f*vertices[vi][0],100.f*vertices[vi][2]);
				}
			}
			glEnd ();
		
		glEndList();
		return lid;
	};
}

