#ifndef BULLET_DATA_EXTRACTOR_H
#define BULLET_DATA_EXTRACTOR_H


#include "../BulletFileLoader/autogenerated/bullet.h"

namespace bParse
{
	class btBulletFile;
};

class btBulletDataExtractor
{
	public:

	btBulletDataExtractor();
	
	virtual ~btBulletDataExtractor();
	
	virtual void convertAllObjects(bParse::btBulletFile* bulletFile);
	
	virtual void* convertCollisionShape(  Bullet::btCollisionShapeData* shapeData  );

	virtual void* createPlaneShape( const Bullet::btVector3FloatData& planeNormal, float planeConstant, const Bullet::btVector3FloatData& localScaling);
	
	virtual void* createBoxShape( const Bullet::btVector3FloatData& halfDimensions, const Bullet::btVector3FloatData& localScaling, float collisionMargin);

	virtual void* createSphereShape( float radius, const Bullet::btVector3FloatData& localScaling, float collisionMargin);

};
	
#endif //BULLET_DATA_EXTRACTOR_H