/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <fsoaudio.h>
#include <gio/gio.h>


#define FSO_AUDIO_TYPE_MANAGER (fso_audio_manager_get_type ())
#define FSO_AUDIO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_AUDIO_TYPE_MANAGER, FsoAudioManager))
#define FSO_AUDIO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_AUDIO_TYPE_MANAGER, FsoAudioManagerClass))
#define FSO_AUDIO_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_AUDIO_TYPE_MANAGER))
#define FSO_AUDIO_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_AUDIO_TYPE_MANAGER))
#define FSO_AUDIO_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_AUDIO_TYPE_MANAGER, FsoAudioManagerClass))

typedef struct _FsoAudioManager FsoAudioManager;
typedef struct _FsoAudioManagerClass FsoAudioManagerClass;
typedef struct _FsoAudioManagerPrivate FsoAudioManagerPrivate;

#define FSO_AUDIO_TYPE_DEVICE_INFO (fso_audio_device_info_get_type ())
#define FSO_AUDIO_DEVICE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_AUDIO_TYPE_DEVICE_INFO, FsoAudioDeviceInfo))
#define FSO_AUDIO_DEVICE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_AUDIO_TYPE_DEVICE_INFO, FsoAudioDeviceInfoClass))
#define FSO_AUDIO_IS_DEVICE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_AUDIO_TYPE_DEVICE_INFO))
#define FSO_AUDIO_IS_DEVICE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_AUDIO_TYPE_DEVICE_INFO))
#define FSO_AUDIO_DEVICE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_AUDIO_TYPE_DEVICE_INFO, FsoAudioDeviceInfoClass))

typedef struct _FsoAudioDeviceInfo FsoAudioDeviceInfo;
typedef struct _FsoAudioDeviceInfoClass FsoAudioDeviceInfoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fso_audio_device_info_unref0(var) ((var == NULL) ? NULL : (var = (fso_audio_device_info_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FsoAudioManagerGetInfoData FsoAudioManagerGetInfoData;
typedef struct _FsoAudioManagerGetAvailableDevicesData FsoAudioManagerGetAvailableDevicesData;
typedef struct _FsoAudioManagerGetModeData FsoAudioManagerGetModeData;
typedef struct _FsoAudioManagerGetDeviceData FsoAudioManagerGetDeviceData;
typedef struct _FsoAudioManagerSetModeData FsoAudioManagerSetModeData;
typedef struct _FsoAudioManagerSetDeviceData FsoAudioManagerSetDeviceData;
typedef struct _FsoAudioManagerPushDeviceData FsoAudioManagerPushDeviceData;
typedef struct _FsoAudioManagerPullDeviceData FsoAudioManagerPullDeviceData;
typedef struct _FsoAudioManagerSetMuteData FsoAudioManagerSetMuteData;
typedef struct _FsoAudioManagerGetMuteData FsoAudioManagerGetMuteData;
typedef struct _FsoAudioManagerSetVolumeData FsoAudioManagerSetVolumeData;
typedef struct _FsoAudioManagerGetVolumeData FsoAudioManagerGetVolumeData;
typedef struct _FsoAudioManagerRegisterSessionData FsoAudioManagerRegisterSessionData;
typedef struct _FsoAudioManagerReleaseSessionData FsoAudioManagerReleaseSessionData;

struct _FsoAudioManager {
	FsoFrameworkAbstractObject parent_instance;
	FsoAudioManagerPrivate * priv;
};

struct _FsoAudioManagerClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _FsoAudioManagerPrivate {
	FsoFrameworkSubsystem* subsystem;
	FreeSmartphoneAudioMode current_mode;
	FsoAudioIRouter* router;
	FsoAudioDeviceInfo** devices;
	gint devices_length1;
	gint _devices_size_;
	FreeSmartphoneAudioDevice* default_devices;
	gint default_devices_length1;
	gint _default_devices_size_;
	FreeSmartphoneAudioDevice* current_devices;
	gint current_devices_length1;
	gint _current_devices_size_;
	GQueue* device_stack;
	FsoAudioSessionHandler* sessionhandler;
	FsoAudioAbstractSessionPolicy* policy;
	FsoAudioAbstractStreamControl* streamcontrol;
};

struct _FsoAudioManagerGetInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	GHashTable* result;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* dict;
};

struct _FsoAudioManagerGetAvailableDevicesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioMode mode;
	FreeSmartphoneAudioDevice* result;
	gint result_length1;
	FsoAudioIRouter* _tmp0_;
	FreeSmartphoneAudioMode _tmp1_;
	gint _tmp2_;
	FreeSmartphoneAudioDevice* _tmp3_;
	FreeSmartphoneAudioDevice* _tmp4_;
	gint _tmp4__length1;
};

struct _FsoAudioManagerGetModeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioMode result;
	FreeSmartphoneAudioMode _tmp0_;
};

struct _FsoAudioManagerGetDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioDevice result;
	FreeSmartphoneAudioDevice* _tmp0_;
	gint _tmp0__length1;
	FreeSmartphoneAudioMode _tmp1_;
	FreeSmartphoneAudioDevice _tmp2_;
};

struct _FsoAudioManagerSetModeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioMode mode;
	FreeSmartphoneAudioMode _tmp0_;
	FreeSmartphoneAudioMode _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	FreeSmartphoneAudioMode _tmp3_;
	GEnumValue* _tmp4_;
	FreeSmartphoneAudioMode _tmp5_;
	GEnumValue* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	GQueue* _tmp10_;
	FreeSmartphoneAudioMode _tmp11_;
	FreeSmartphoneAudioMode previous_mode;
	FreeSmartphoneAudioMode _tmp12_;
	FsoAudioIRouter* _tmp13_;
	FreeSmartphoneAudioDevice* _tmp14_;
	gint _tmp14__length1;
	FreeSmartphoneAudioMode _tmp15_;
	FreeSmartphoneAudioDevice _tmp16_;
	FsoAudioIRouter* _tmp17_;
	FreeSmartphoneAudioMode _tmp18_;
	FreeSmartphoneAudioMode _tmp19_;
	FreeSmartphoneAudioDevice* _tmp20_;
	gint _tmp20__length1;
	FreeSmartphoneAudioMode _tmp21_;
	FreeSmartphoneAudioDevice _tmp22_;
	FreeSmartphoneAudioDevice* _tmp23_;
	gint _tmp23__length1;
	FreeSmartphoneAudioMode _tmp24_;
	FreeSmartphoneAudioDevice _tmp25_;
	FreeSmartphoneAudioDevice* _tmp26_;
	gint _tmp26__length1;
	FreeSmartphoneAudioMode _tmp27_;
	FreeSmartphoneAudioDevice _tmp28_;
};

struct _FsoAudioManagerSetDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioDevice device;
	FsoAudioIRouter* _tmp0_;
	FreeSmartphoneAudioMode _tmp1_;
	gint _tmp2_;
	FreeSmartphoneAudioDevice* _tmp3_;
	FreeSmartphoneAudioDevice* supported_devices;
	gint supported_devices_length1;
	gint _supported_devices_size_;
	FreeSmartphoneAudioDevice _tmp4_;
	FreeSmartphoneAudioDevice* _tmp5_;
	gint _tmp5__length1;
	GError* _tmp6_;
	FsoFrameworkLogger* _tmp7_;
	FreeSmartphoneAudioDevice* _tmp8_;
	gint _tmp8__length1;
	FreeSmartphoneAudioMode _tmp9_;
	FreeSmartphoneAudioDevice _tmp10_;
	GEnumValue* _tmp11_;
	FreeSmartphoneAudioDevice _tmp12_;
	GEnumValue* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	FreeSmartphoneAudioDevice* _tmp17_;
	gint _tmp17__length1;
	FreeSmartphoneAudioMode _tmp18_;
	FreeSmartphoneAudioDevice _tmp19_;
	FreeSmartphoneAudioDevice _tmp20_;
	FsoAudioIRouter* _tmp21_;
	FreeSmartphoneAudioDevice* _tmp22_;
	gint _tmp22__length1;
	FreeSmartphoneAudioMode _tmp23_;
	FreeSmartphoneAudioDevice _tmp24_;
	FreeSmartphoneAudioDevice* _tmp25_;
	gint _tmp25__length1;
	FreeSmartphoneAudioMode _tmp26_;
	FreeSmartphoneAudioDevice _tmp27_;
	GError * _inner_error_;
};

struct _FsoAudioManagerPushDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioDevice device;
	FreeSmartphoneAudioDevice _tmp0_;
	GQueue* _tmp1_;
	FreeSmartphoneAudioDevice _tmp2_;
};

struct _FsoAudioManagerPullDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioDevice result;
	GQueue* _tmp0_;
	GQueue* _tmp1_;
	gboolean _tmp2_;
	GError* _tmp3_;
	GQueue* _tmp4_;
	gconstpointer _tmp5_;
	FreeSmartphoneAudioDevice device;
	GError * _inner_error_;
};

struct _FsoAudioManagerSetMuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioControl control;
	gboolean mute;
	FreeSmartphoneAudioDevice* _tmp0_;
	gint _tmp0__length1;
	FreeSmartphoneAudioMode _tmp1_;
	FreeSmartphoneAudioDevice _tmp2_;
	FreeSmartphoneAudioDevice current_device;
	FsoAudioDeviceInfo** _tmp3_;
	gint _tmp3__length1;
	FreeSmartphoneAudioDevice _tmp4_;
	FsoAudioDeviceInfo* _tmp5_;
	FreeSmartphoneAudioMode _tmp6_;
	FreeSmartphoneAudioControl _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	FsoAudioDeviceInfo** _tmp10_;
	gint _tmp10__length1;
	FreeSmartphoneAudioDevice _tmp11_;
	FsoAudioDeviceInfo* _tmp12_;
	FreeSmartphoneAudioMode _tmp13_;
	FreeSmartphoneAudioControl _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	FsoAudioIRouter* _tmp17_;
	FreeSmartphoneAudioControl _tmp18_;
	FsoAudioDeviceInfo** _tmp19_;
	gint _tmp19__length1;
	FreeSmartphoneAudioDevice _tmp20_;
	FsoAudioDeviceInfo* _tmp21_;
	FreeSmartphoneAudioMode _tmp22_;
	FreeSmartphoneAudioControl _tmp23_;
	gint _tmp24_;
	gint level;
	FsoAudioIRouter* _tmp25_;
	FreeSmartphoneAudioControl _tmp26_;
	gint _tmp27_;
	FreeSmartphoneAudioControl _tmp28_;
	gboolean _tmp29_;
};

struct _FsoAudioManagerGetMuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioControl control;
	gboolean result;
	FreeSmartphoneAudioDevice* _tmp0_;
	gint _tmp0__length1;
	FreeSmartphoneAudioMode _tmp1_;
	FreeSmartphoneAudioDevice _tmp2_;
	FreeSmartphoneAudioDevice current_device;
	FsoAudioDeviceInfo** _tmp3_;
	gint _tmp3__length1;
	FsoAudioDeviceInfo* _tmp4_;
	FreeSmartphoneAudioMode _tmp5_;
	FreeSmartphoneAudioControl _tmp6_;
	gboolean _tmp7_;
};

struct _FsoAudioManagerSetVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioControl control;
	gint volume;
	gboolean _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	GError* _tmp4_;
	FreeSmartphoneAudioDevice* _tmp5_;
	gint _tmp5__length1;
	FreeSmartphoneAudioMode _tmp6_;
	FreeSmartphoneAudioDevice _tmp7_;
	FreeSmartphoneAudioDevice current_device;
	FsoAudioDeviceInfo** _tmp8_;
	gint _tmp8__length1;
	FreeSmartphoneAudioDevice _tmp9_;
	FsoAudioDeviceInfo* _tmp10_;
	FreeSmartphoneAudioMode _tmp11_;
	FreeSmartphoneAudioControl _tmp12_;
	gint _tmp13_;
	FsoAudioDeviceInfo** _tmp14_;
	gint _tmp14__length1;
	FreeSmartphoneAudioDevice _tmp15_;
	FsoAudioDeviceInfo* _tmp16_;
	FreeSmartphoneAudioMode _tmp17_;
	FreeSmartphoneAudioControl _tmp18_;
	gboolean _tmp19_;
	FsoAudioIRouter* _tmp20_;
	FreeSmartphoneAudioControl _tmp21_;
	gint _tmp22_;
	FreeSmartphoneAudioControl _tmp23_;
	gint _tmp24_;
	GError * _inner_error_;
};

struct _FsoAudioManagerGetVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioControl control;
	gint result;
	FreeSmartphoneAudioDevice* _tmp0_;
	gint _tmp0__length1;
	FreeSmartphoneAudioMode _tmp1_;
	FreeSmartphoneAudioDevice _tmp2_;
	FreeSmartphoneAudioDevice current_device;
	FsoAudioDeviceInfo** _tmp3_;
	gint _tmp3__length1;
	FsoAudioDeviceInfo* _tmp4_;
	FreeSmartphoneAudioMode _tmp5_;
	FreeSmartphoneAudioControl _tmp6_;
	gint _tmp7_;
};

struct _FsoAudioManagerRegisterSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	FreeSmartphoneAudioStream stream;
	gchar* result;
	FsoAudioSessionHandler* _tmp0_;
	FreeSmartphoneAudioStream _tmp1_;
	gchar* _tmp2_;
	gchar* token;
	FsoAudioAbstractSessionPolicy* _tmp3_;
	FreeSmartphoneAudioStream _tmp4_;
	GError * _inner_error_;
};

struct _FsoAudioManagerReleaseSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoAudioManager* self;
	gchar* token;
	FsoAudioSessionHandler* _tmp0_;
	const gchar* _tmp1_;
	FreeSmartphoneAudioStream _tmp2_;
	FreeSmartphoneAudioStream stream;
	FsoAudioSessionHandler* _tmp3_;
	const gchar* _tmp4_;
	FsoAudioAbstractSessionPolicy* _tmp5_;
	GError * _inner_error_;
};


static gpointer fso_audio_manager_parent_class = NULL;
static FreeSmartphoneAudioManagerIface* fso_audio_manager_free_smartphone_audio_manager_parent_iface = NULL;
static FreeSmartphoneInfoIface* fso_audio_manager_free_smartphone_info_parent_iface = NULL;
static GType fso_audio_manager_type_id = 0;
extern FsoAudioManager* instance;
FsoAudioManager* instance = NULL;

#define FSO_AUDIO_MANAGER_MODULE_NAME "fsoaudio.manager"
GType fso_audio_manager_get_type (void) G_GNUC_CONST;
GType fso_audio_manager_register_type (GTypeModule * module);
gpointer fso_audio_device_info_ref (gpointer instance);
void fso_audio_device_info_unref (gpointer instance);
GParamSpec* fso_audio_param_spec_device_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_audio_value_set_device_info (GValue* value, gpointer v_object);
void fso_audio_value_take_device_info (GValue* value, gpointer v_object);
gpointer fso_audio_value_get_device_info (const GValue* value);
GType fso_audio_device_info_get_type (void) G_GNUC_CONST;
GType fso_audio_device_info_register_type (GTypeModule * module);
#define FSO_AUDIO_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_AUDIO_TYPE_MANAGER, FsoAudioManagerPrivate))
enum  {
	FSO_AUDIO_MANAGER_DUMMY_PROPERTY
};
FsoAudioManager* fso_audio_manager_new (FsoFrameworkSubsystem* subsystem);
FsoAudioManager* fso_audio_manager_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
static void fso_audio_manager_createRouter (FsoAudioManager* self);
static void fso_audio_manager_createStreamControl (FsoAudioManager* self);
static void fso_audio_manager_createSessionPolicy (FsoAudioManager* self);
FsoAudioDeviceInfo* fso_audio_device_info_new (FreeSmartphoneAudioDevice type);
FsoAudioDeviceInfo* fso_audio_device_info_construct (GType object_type, FreeSmartphoneAudioDevice type);
static void fso_audio_manager_readConfiguration (FsoAudioManager* self);
static gboolean _vala_free_smartphone_audio_device_array_contains (FreeSmartphoneAudioDevice* stack, int stack_length, FreeSmartphoneAudioDevice needle);
static void fso_audio_manager_adjustVolumeSettings (FsoAudioManager* self);
gint fso_audio_device_info_get_volume (FsoAudioDeviceInfo* self, FreeSmartphoneAudioMode mode, FreeSmartphoneAudioControl ctrl);
static gchar* fso_audio_manager_real_repr (FsoFrameworkAbstractObject* base);
static void fso_audio_manager_real_get_info_data_free (gpointer _data);
static void fso_audio_manager_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_get_info_co (FsoAudioManagerGetInfoData* _data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void fso_audio_manager_real_get_available_devices_data_free (gpointer _data);
static void fso_audio_manager_real_get_available_devices (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioMode mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_get_available_devices_co (FsoAudioManagerGetAvailableDevicesData* _data_);
static void fso_audio_manager_real_get_mode_data_free (gpointer _data);
static void fso_audio_manager_real_get_mode (FreeSmartphoneAudioManager* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_get_mode_co (FsoAudioManagerGetModeData* _data_);
static void fso_audio_manager_real_get_device_data_free (gpointer _data);
static void fso_audio_manager_real_get_device (FreeSmartphoneAudioManager* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_get_device_co (FsoAudioManagerGetDeviceData* _data_);
static void fso_audio_manager_real_set_mode_data_free (gpointer _data);
static void fso_audio_manager_real_set_mode (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioMode mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_set_mode_co (FsoAudioManagerSetModeData* _data_);
const gchar* free_smartphone_audio_mode_to_string (FreeSmartphoneAudioMode self);
static void fso_audio_manager_real_set_device_data_free (gpointer _data);
static void fso_audio_manager_real_set_device (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioDevice device, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_set_device_co (FsoAudioManagerSetDeviceData* _data_);
const gchar* free_smartphone_audio_device_to_string (FreeSmartphoneAudioDevice self);
static void fso_audio_manager_real_push_device_data_free (gpointer _data);
static void fso_audio_manager_real_push_device (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioDevice device, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_push_device_co (FsoAudioManagerPushDeviceData* _data_);
static void fso_audio_manager_real_pull_device_data_free (gpointer _data);
static void fso_audio_manager_real_pull_device (FreeSmartphoneAudioManager* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_pull_device_co (FsoAudioManagerPullDeviceData* _data_);
static void fso_audio_manager_real_set_mute_data_free (gpointer _data);
static void fso_audio_manager_real_set_mute (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, gboolean mute, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_set_mute_co (FsoAudioManagerSetMuteData* _data_);
gboolean fso_audio_device_info_get_mute (FsoAudioDeviceInfo* self, FreeSmartphoneAudioMode mode, FreeSmartphoneAudioControl ctrl);
void fso_audio_device_info_set_mute (FsoAudioDeviceInfo* self, FreeSmartphoneAudioMode mode, FreeSmartphoneAudioControl ctrl, gboolean mute);
static void fso_audio_manager_real_get_mute_data_free (gpointer _data);
static void fso_audio_manager_real_get_mute (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_get_mute_co (FsoAudioManagerGetMuteData* _data_);
static void fso_audio_manager_real_set_volume_data_free (gpointer _data);
static void fso_audio_manager_real_set_volume (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, gint volume, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_set_volume_co (FsoAudioManagerSetVolumeData* _data_);
void fso_audio_device_info_set_volume (FsoAudioDeviceInfo* self, FreeSmartphoneAudioMode mode, FreeSmartphoneAudioControl ctrl, gint volume);
static void fso_audio_manager_real_get_volume_data_free (gpointer _data);
static void fso_audio_manager_real_get_volume (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_get_volume_co (FsoAudioManagerGetVolumeData* _data_);
static void fso_audio_manager_real_register_session_data_free (gpointer _data);
static void fso_audio_manager_real_register_session (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioStream stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_register_session_co (FsoAudioManagerRegisterSessionData* _data_);
static void fso_audio_manager_real_release_session_data_free (gpointer _data);
static void fso_audio_manager_real_release_session (FreeSmartphoneAudioManager* base, const gchar* token, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_audio_manager_real_release_session_co (FsoAudioManagerReleaseSessionData* _data_);
static void fso_audio_manager_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FsoAudioManager* fso_audio_manager_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	FsoAudioManager * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	FsoFrameworkSubsystem* _tmp2_;
	FsoFrameworkSubsystem* _tmp3_;
	GQueue* _tmp4_;
	FsoAudioDeviceInfo* _tmp5_;
	FsoAudioDeviceInfo* _tmp6_;
	FsoAudioDeviceInfo* _tmp7_;
	FsoAudioDeviceInfo* _tmp8_;
	FsoAudioDeviceInfo* _tmp9_;
	FsoAudioDeviceInfo** _tmp10_ = NULL;
	FreeSmartphoneAudioDevice* _tmp11_ = NULL;
	FreeSmartphoneAudioDevice* _tmp12_;
	gint _tmp12__length1;
	FreeSmartphoneAudioDevice _tmp13_;
	FreeSmartphoneAudioDevice* _tmp14_;
	gint _tmp14__length1;
	FreeSmartphoneAudioDevice _tmp15_;
	FreeSmartphoneAudioDevice* _tmp16_ = NULL;
	FsoAudioIRouter* _tmp17_;
	FreeSmartphoneAudioDevice* _tmp18_;
	gint _tmp18__length1;
	FreeSmartphoneAudioMode _tmp19_;
	FreeSmartphoneAudioDevice _tmp20_;
	FsoAudioIRouter* _tmp21_;
	FreeSmartphoneAudioMode _tmp22_;
	FsoAudioAbstractSessionPolicy* _tmp23_;
	FsoAudioSessionHandler* _tmp24_;
	FsoFrameworkLogger* _tmp25_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	self = (FsoAudioManager*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = subsystem;
	fso_framework_subsystem_registerObjectForService (_tmp2_, FREE_SMARTPHONE_AUDIO_TYPE_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_AUDIO_ServiceDBusName, FSO_FRAMEWORK_AUDIO_ServicePathPrefix, (FreeSmartphoneAudioManager*) self);
	_tmp3_ = subsystem;
	fso_framework_subsystem_registerObjectForService (_tmp3_, FREE_SMARTPHONE_TYPE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_AUDIO_ServiceDBusName, FSO_FRAMEWORK_AUDIO_ServicePathPrefix, (FreeSmartphoneInfo*) self);
	fso_audio_manager_createRouter (self);
	fso_audio_manager_createStreamControl (self);
	fso_audio_manager_createSessionPolicy (self);
	_tmp4_ = g_queue_new ();
	_g_queue_free0 (self->priv->device_stack);
	self->priv->device_stack = _tmp4_;
	_tmp5_ = fso_audio_device_info_new (FREE_SMARTPHONE_AUDIO_DEVICE_BACKSPEAKER);
	_tmp6_ = fso_audio_device_info_new (FREE_SMARTPHONE_AUDIO_DEVICE_FRONTSPEAKER);
	_tmp7_ = fso_audio_device_info_new (FREE_SMARTPHONE_AUDIO_DEVICE_HEADSET);
	_tmp8_ = fso_audio_device_info_new (FREE_SMARTPHONE_AUDIO_DEVICE_BLUETOOTH_SCO);
	_tmp9_ = fso_audio_device_info_new (FREE_SMARTPHONE_AUDIO_DEVICE_BLUETOOTH_A2DP);
	_tmp10_ = g_new0 (FsoAudioDeviceInfo*, 5 + 1);
	_tmp10_[0] = _tmp5_;
	_tmp10_[1] = _tmp6_;
	_tmp10_[2] = _tmp7_;
	_tmp10_[3] = _tmp8_;
	_tmp10_[4] = _tmp9_;
	self->priv->devices = (_vala_array_free (self->priv->devices, self->priv->devices_length1, (GDestroyNotify) fso_audio_device_info_unref), NULL);
	self->priv->devices = _tmp10_;
	self->priv->devices_length1 = 5;
	self->priv->_devices_size_ = self->priv->devices_length1;
	_tmp11_ = g_new0 (FreeSmartphoneAudioDevice, 2);
	_tmp11_[0] = FREE_SMARTPHONE_AUDIO_DEVICE_BACKSPEAKER;
	_tmp11_[1] = FREE_SMARTPHONE_AUDIO_DEVICE_FRONTSPEAKER;
	self->priv->default_devices = (g_free (self->priv->default_devices), NULL);
	self->priv->default_devices = _tmp11_;
	self->priv->default_devices_length1 = 2;
	self->priv->_default_devices_size_ = self->priv->default_devices_length1;
	fso_audio_manager_readConfiguration (self);
	self->priv->current_mode = FREE_SMARTPHONE_AUDIO_MODE_NORMAL;
	_tmp12_ = self->priv->default_devices;
	_tmp12__length1 = self->priv->default_devices_length1;
	_tmp13_ = _tmp12_[FREE_SMARTPHONE_AUDIO_MODE_NORMAL];
	_tmp14_ = self->priv->default_devices;
	_tmp14__length1 = self->priv->default_devices_length1;
	_tmp15_ = _tmp14_[FREE_SMARTPHONE_AUDIO_MODE_CALL];
	_tmp16_ = g_new0 (FreeSmartphoneAudioDevice, 2);
	_tmp16_[0] = _tmp13_;
	_tmp16_[1] = _tmp15_;
	self->priv->current_devices = (g_free (self->priv->current_devices), NULL);
	self->priv->current_devices = _tmp16_;
	self->priv->current_devices_length1 = 2;
	self->priv->_current_devices_size_ = self->priv->current_devices_length1;
	_tmp17_ = self->priv->router;
	_tmp18_ = self->priv->current_devices;
	_tmp18__length1 = self->priv->current_devices_length1;
	_tmp19_ = self->priv->current_mode;
	_tmp20_ = _tmp18_[_tmp19_];
	fso_audio_irouter_set_device (_tmp17_, _tmp20_, FALSE);
	_tmp21_ = self->priv->router;
	_tmp22_ = self->priv->current_mode;
	fso_audio_irouter_set_mode (_tmp21_, _tmp22_, TRUE);
	_tmp23_ = self->priv->policy;
	_tmp24_ = fso_audio_session_handler_new (_tmp23_);
	_g_object_unref0 (self->priv->sessionhandler);
	self->priv->sessionhandler = _tmp24_;
	_tmp25_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp25_, "Created");
	return self;
}


FsoAudioManager* fso_audio_manager_new (FsoFrameworkSubsystem* subsystem) {
	return fso_audio_manager_construct (FSO_AUDIO_TYPE_MANAGER, subsystem);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void fso_audio_manager_createStreamControl (FsoAudioManager* self) {
	FsoFrameworkSmartKeyFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* sctrlname;
	gchar* _tmp2_;
	gchar* typename;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	const gchar* _tmp9_;
	FsoAudioAbstractStreamControl* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp1_ = fso_framework_smart_key_file_stringValue (_tmp0_, FSO_AUDIO_MANAGER_MODULE_NAME, "streamcontrol_type", "none");
	sctrlname = _tmp1_;
	_tmp2_ = g_strdup ("");
	typename = _tmp2_;
	_tmp3_ = sctrlname;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("alsa")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("FsoAudioStreamControlAlsa");
				_g_free0 (typename);
				typename = _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				FsoAudioNullStreamControl* _tmp8_;
				_tmp8_ = fso_audio_null_stream_control_new ();
				_g_object_unref0 (self->priv->streamcontrol);
				self->priv->streamcontrol = (FsoAudioAbstractStreamControl*) _tmp8_;
				break;
			}
		}
	}
	_tmp9_ = sctrlname;
	if (g_strcmp0 (_tmp9_, "none") != 0) {
		const gchar* _tmp10_;
		GType _tmp11_ = 0UL;
		GType sctrltype;
		GType _tmp12_;
		_tmp10_ = typename;
		_tmp11_ = g_type_from_name (_tmp10_);
		sctrltype = _tmp11_;
		_tmp12_ = sctrltype;
		if (_tmp12_ == G_TYPE_INVALID) {
			FsoFrameworkLogger* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			FsoAudioNullStreamControl* _tmp18_;
			_tmp13_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp14_ = typename;
			_tmp15_ = string_to_string (_tmp14_);
			_tmp16_ = g_strconcat ("Can't instanciate requested stream control type ", _tmp15_, "; will no be able to control associated streams!", NULL);
			_tmp17_ = _tmp16_;
			fso_framework_logger_warning (_tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_tmp18_ = fso_audio_null_stream_control_new ();
			_g_object_unref0 (self->priv->streamcontrol);
			self->priv->streamcontrol = (FsoAudioAbstractStreamControl*) _tmp18_;
		} else {
			GType _tmp19_;
			GObject* _tmp20_ = NULL;
			GObject* _tmp21_;
			_tmp19_ = sctrltype;
			_tmp20_ = g_object_new (_tmp19_, NULL);
			_tmp21_ = G_IS_INITIALLY_UNOWNED (_tmp20_) ? g_object_ref_sink (_tmp20_) : _tmp20_;
			_g_object_unref0 (self->priv->streamcontrol);
			self->priv->streamcontrol = FSO_AUDIO_ABSTRACT_STREAM_CONTROL (_tmp21_);
		}
	}
	_tmp22_ = self->priv->streamcontrol;
	fso_audio_abstract_stream_control_setup (_tmp22_);
	_g_free0 (typename);
	_g_free0 (sctrlname);
}


static void fso_audio_manager_createSessionPolicy (FsoAudioManager* self) {
	FsoFrameworkSmartKeyFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* policyname;
	gchar* _tmp2_;
	gchar* typename;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	const gchar* _tmp9_;
	FsoAudioAbstractSessionPolicy* _tmp22_;
	FsoAudioAbstractStreamControl* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp1_ = fso_framework_smart_key_file_stringValue (_tmp0_, FSO_AUDIO_MANAGER_MODULE_NAME, "policy_type", "none");
	policyname = _tmp1_;
	_tmp2_ = g_strdup ("");
	typename = _tmp2_;
	_tmp3_ = policyname;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("default")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("FsoAudioDefaultSessionPolicy");
				_g_free0 (typename);
				typename = _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				FsoAudioNullSessionPolicy* _tmp8_;
				_tmp8_ = fso_audio_null_session_policy_new ();
				_g_object_unref0 (self->priv->policy);
				self->priv->policy = (FsoAudioAbstractSessionPolicy*) _tmp8_;
				break;
			}
		}
	}
	_tmp9_ = policyname;
	if (g_strcmp0 (_tmp9_, "none") != 0) {
		const gchar* _tmp10_;
		GType _tmp11_ = 0UL;
		GType policytype;
		GType _tmp12_;
		_tmp10_ = typename;
		_tmp11_ = g_type_from_name (_tmp10_);
		policytype = _tmp11_;
		_tmp12_ = policytype;
		if (_tmp12_ == G_TYPE_INVALID) {
			FsoFrameworkLogger* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			FsoAudioNullSessionPolicy* _tmp18_;
			_tmp13_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp14_ = typename;
			_tmp15_ = string_to_string (_tmp14_);
			_tmp16_ = g_strconcat ("Can't instanciate requested session policy type ", _tmp15_, "; will no be able to handle audio sessions", NULL);
			_tmp17_ = _tmp16_;
			fso_framework_logger_warning (_tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_tmp18_ = fso_audio_null_session_policy_new ();
			_g_object_unref0 (self->priv->policy);
			self->priv->policy = (FsoAudioAbstractSessionPolicy*) _tmp18_;
		} else {
			GType _tmp19_;
			GObject* _tmp20_ = NULL;
			GObject* _tmp21_;
			_tmp19_ = policytype;
			_tmp20_ = g_object_new (_tmp19_, NULL);
			_tmp21_ = G_IS_INITIALLY_UNOWNED (_tmp20_) ? g_object_ref_sink (_tmp20_) : _tmp20_;
			_g_object_unref0 (self->priv->policy);
			self->priv->policy = FSO_AUDIO_ABSTRACT_SESSION_POLICY (_tmp21_);
		}
	}
	_tmp22_ = self->priv->policy;
	_tmp23_ = self->priv->streamcontrol;
	fso_audio_abstract_session_policy_provideStreamControl (_tmp22_, _tmp23_);
	_g_free0 (typename);
	_g_free0 (policyname);
}


static void fso_audio_manager_createRouter (FsoAudioManager* self) {
	FsoFrameworkSmartKeyFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* routername;
	gchar* _tmp2_;
	gchar* typename;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp1_ = fso_framework_smart_key_file_stringValue (_tmp0_, FSO_AUDIO_MANAGER_MODULE_NAME, "router_type", "");
	routername = _tmp1_;
	_tmp2_ = g_strdup ("");
	typename = _tmp2_;
	_tmp3_ = routername;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("alsa")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("RouterLibAlsa");
				_g_free0 (typename);
				typename = _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				FsoAudioNullRouter* _tmp8_;
				_tmp8_ = fso_audio_null_router_new ();
				_g_object_unref0 (self->priv->router);
				self->priv->router = (FsoAudioIRouter*) _tmp8_;
				break;
			}
		}
	}
	_tmp9_ = routername;
	if (g_strcmp0 (_tmp9_, "none") != 0) {
		const gchar* _tmp10_;
		GType _tmp11_ = 0UL;
		GType routertype;
		GType _tmp12_;
		_tmp10_ = typename;
		_tmp11_ = g_type_from_name (_tmp10_);
		routertype = _tmp11_;
		_tmp12_ = routertype;
		if (_tmp12_ == G_TYPE_INVALID) {
			FsoFrameworkLogger* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			FsoAudioNullRouter* _tmp18_;
			_tmp13_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp14_ = typename;
			_tmp15_ = string_to_string (_tmp14_);
			_tmp16_ = g_strconcat ("Can't instanciate requested router type ", _tmp15_, "; will not be able to route audio", NULL);
			_tmp17_ = _tmp16_;
			fso_framework_logger_warning (_tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_tmp18_ = fso_audio_null_router_new ();
			_g_object_unref0 (self->priv->router);
			self->priv->router = (FsoAudioIRouter*) _tmp18_;
		} else {
			GType _tmp19_;
			GObject* _tmp20_ = NULL;
			GObject* _tmp21_;
			_tmp19_ = routertype;
			_tmp20_ = g_object_new (_tmp19_, NULL);
			_tmp21_ = G_IS_INITIALLY_UNOWNED (_tmp20_) ? g_object_ref_sink (_tmp20_) : _tmp20_;
			_g_object_unref0 (self->priv->router);
			self->priv->router = FSO_AUDIO_IROUTER (_tmp21_);
		}
	}
	_g_free0 (typename);
	_g_free0 (routername);
}


static gboolean _vala_free_smartphone_audio_device_array_contains (FreeSmartphoneAudioDevice* stack, int stack_length, FreeSmartphoneAudioDevice needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static void fso_audio_manager_readConfiguration (FsoAudioManager* self) {
	FsoFrameworkSmartKeyFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* device_str;
	const gchar* _tmp2_;
	gpointer _tmp3_ = NULL;
	FreeSmartphoneAudioDevice device;
	FreeSmartphoneAudioDevice _tmp4_;
	FsoAudioIRouter* _tmp5_;
	gint _tmp6_ = 0;
	FreeSmartphoneAudioDevice* _tmp7_ = NULL;
	FreeSmartphoneAudioDevice* _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_;
	FreeSmartphoneAudioDevice* _tmp10_;
	gint _tmp10__length1;
	FreeSmartphoneAudioDevice _tmp11_;
	FreeSmartphoneAudioDevice _tmp12_;
	FsoFrameworkSmartKeyFile* _tmp13_;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	FreeSmartphoneAudioDevice _tmp17_;
	FsoAudioIRouter* _tmp18_;
	gint _tmp19_ = 0;
	FreeSmartphoneAudioDevice* _tmp20_ = NULL;
	FreeSmartphoneAudioDevice* _tmp21_;
	gint _tmp21__length1;
	gboolean _tmp22_;
	FreeSmartphoneAudioDevice* _tmp23_;
	gint _tmp23__length1;
	FreeSmartphoneAudioDevice _tmp24_;
	FreeSmartphoneAudioDevice _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp1_ = fso_framework_smart_key_file_stringValue (_tmp0_, FSO_AUDIO_MANAGER_MODULE_NAME, "normal_default_device", "backspeaker");
	device_str = _tmp1_;
	_tmp2_ = device_str;
	_tmp3_ = fso_framework_string_handling_enumFromString (FREE_SMARTPHONE_AUDIO_TYPE_DEVICE, NULL, NULL, _tmp2_, GINT_TO_POINTER (FREE_SMARTPHONE_AUDIO_DEVICE_BACKSPEAKER));
	device = GPOINTER_TO_INT (_tmp3_);
	_tmp4_ = device;
	_tmp5_ = self->priv->router;
	_tmp7_ = fso_audio_irouter_get_available_devices (_tmp5_, FREE_SMARTPHONE_AUDIO_MODE_NORMAL, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = !_vala_free_smartphone_audio_device_array_contains (_tmp8_, _tmp6_, _tmp4_);
	_tmp8_ = (g_free (_tmp8_), NULL);
	if (_tmp9_) {
		device = FREE_SMARTPHONE_AUDIO_DEVICE_BACKSPEAKER;
	}
	_tmp10_ = self->priv->default_devices;
	_tmp10__length1 = self->priv->default_devices_length1;
	_tmp11_ = device;
	_tmp10_[FREE_SMARTPHONE_AUDIO_MODE_NORMAL] = _tmp11_;
	_tmp12_ = _tmp10_[FREE_SMARTPHONE_AUDIO_MODE_NORMAL];
	_tmp13_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp14_ = fso_framework_smart_key_file_stringValue (_tmp13_, FSO_AUDIO_MANAGER_MODULE_NAME, "call_default_device", "frontspeaker");
	_g_free0 (device_str);
	device_str = _tmp14_;
	_tmp15_ = device_str;
	_tmp16_ = fso_framework_string_handling_enumFromString (FREE_SMARTPHONE_AUDIO_TYPE_DEVICE, NULL, NULL, _tmp15_, GINT_TO_POINTER (FREE_SMARTPHONE_AUDIO_DEVICE_FRONTSPEAKER));
	device = GPOINTER_TO_INT (_tmp16_);
	_tmp17_ = device;
	_tmp18_ = self->priv->router;
	_tmp20_ = fso_audio_irouter_get_available_devices (_tmp18_, FREE_SMARTPHONE_AUDIO_MODE_CALL, &_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _tmp19_;
	_tmp22_ = !_vala_free_smartphone_audio_device_array_contains (_tmp21_, _tmp19_, _tmp17_);
	_tmp21_ = (g_free (_tmp21_), NULL);
	if (_tmp22_) {
		device = FREE_SMARTPHONE_AUDIO_DEVICE_FRONTSPEAKER;
	}
	_tmp23_ = self->priv->default_devices;
	_tmp23__length1 = self->priv->default_devices_length1;
	_tmp24_ = device;
	_tmp23_[FREE_SMARTPHONE_AUDIO_MODE_CALL] = _tmp24_;
	_tmp25_ = _tmp23_[FREE_SMARTPHONE_AUDIO_MODE_CALL];
	_g_free0 (device_str);
}


/**
         * Adjust the volume settings for current mode:device combination as defined in
         * device configuration data.
         **/
static gpointer _fso_audio_device_info_ref0 (gpointer self) {
	return self ? fso_audio_device_info_ref (self) : NULL;
}


static void fso_audio_manager_adjustVolumeSettings (FsoAudioManager* self) {
	FreeSmartphoneAudioDevice* _tmp0_;
	gint _tmp0__length1;
	FreeSmartphoneAudioMode _tmp1_;
	FreeSmartphoneAudioDevice _tmp2_;
	FreeSmartphoneAudioDevice device_type;
	FsoAudioDeviceInfo** _tmp3_;
	gint _tmp3__length1;
	FreeSmartphoneAudioDevice _tmp4_;
	FsoAudioDeviceInfo* _tmp5_;
	FsoAudioDeviceInfo* _tmp6_;
	FsoAudioDeviceInfo* device;
	FreeSmartphoneAudioControl* _tmp7_ = NULL;
	FreeSmartphoneAudioControl* controls;
	gint controls_length1;
	gint _controls_size_;
	FreeSmartphoneAudioControl* _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_devices;
	_tmp0__length1 = self->priv->current_devices_length1;
	_tmp1_ = self->priv->current_mode;
	_tmp2_ = _tmp0_[_tmp1_];
	device_type = _tmp2_;
	_tmp3_ = self->priv->devices;
	_tmp3__length1 = self->priv->devices_length1;
	_tmp4_ = device_type;
	_tmp5_ = _tmp3_[_tmp4_];
	_tmp6_ = _fso_audio_device_info_ref0 (_tmp5_);
	device = _tmp6_;
	_tmp7_ = g_new0 (FreeSmartphoneAudioControl, 2);
	_tmp7_[0] = FREE_SMARTPHONE_AUDIO_CONTROL_SPEAKER;
	_tmp7_[1] = FREE_SMARTPHONE_AUDIO_CONTROL_MICROPHONE;
	controls = _tmp7_;
	controls_length1 = 2;
	_controls_size_ = controls_length1;
	_tmp8_ = controls;
	_tmp8__length1 = controls_length1;
	{
		FreeSmartphoneAudioControl* ctrl_collection = NULL;
		gint ctrl_collection_length1 = 0;
		gint _ctrl_collection_size_ = 0;
		gint ctrl_it = 0;
		ctrl_collection = _tmp8_;
		ctrl_collection_length1 = _tmp8__length1;
		for (ctrl_it = 0; ctrl_it < _tmp8__length1; ctrl_it = ctrl_it + 1) {
			FreeSmartphoneAudioControl ctrl = 0;
			ctrl = ctrl_collection[ctrl_it];
			{
				FsoAudioDeviceInfo* _tmp9_;
				FreeSmartphoneAudioMode _tmp10_;
				FreeSmartphoneAudioControl _tmp11_;
				gint _tmp12_ = 0;
				gint volume;
				FsoAudioIRouter* _tmp13_;
				FreeSmartphoneAudioControl _tmp14_;
				gint _tmp15_;
				FreeSmartphoneAudioControl _tmp16_;
				gint _tmp17_;
				_tmp9_ = device;
				_tmp10_ = self->priv->current_mode;
				_tmp11_ = ctrl;
				_tmp12_ = fso_audio_device_info_get_volume (_tmp9_, _tmp10_, _tmp11_);
				volume = _tmp12_;
				_tmp13_ = self->priv->router;
				_tmp14_ = ctrl;
				_tmp15_ = volume;
				fso_audio_irouter_set_volume (_tmp13_, _tmp14_, (guint) _tmp15_);
				_tmp16_ = ctrl;
				_tmp17_ = volume;
				g_signal_emit_by_name ((FreeSmartphoneAudioManager*) self, "volume-changed", _tmp16_, _tmp17_);
			}
		}
	}
	controls = (g_free (controls), NULL);
	_fso_audio_device_info_unref0 (device);
}


static gchar* fso_audio_manager_real_repr (FsoFrameworkAbstractObject* base) {
	FsoAudioManager * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (FsoAudioManager*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


static void fso_audio_manager_real_get_info_data_free (gpointer _data) {
	FsoAudioManagerGetInfoData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerGetInfoData, _data_);
}


static void fso_audio_manager_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerGetInfoData* _data_;
	FsoAudioManager* _tmp0_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerGetInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_get_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_get_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_audio_manager_real_get_info_co (_data_);
}


static GHashTable* fso_audio_manager_real_get_info_finish (FreeSmartphoneInfo* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	FsoAudioManagerGetInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean fso_audio_manager_real_get_info_co (FsoAudioManagerGetInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_variant_unref0_);
	_data_->dict = _data_->_tmp2_;
	_data_->result = _data_->dict;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->dict);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_get_available_devices_data_free (gpointer _data) {
	FsoAudioManagerGetAvailableDevicesData* _data_;
	_data_ = _data;
	_data_->result = (g_free (_data_->result), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerGetAvailableDevicesData, _data_);
}


static void fso_audio_manager_real_get_available_devices (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioMode mode, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerGetAvailableDevicesData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioMode _tmp1_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerGetAvailableDevicesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_get_available_devices);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_get_available_devices_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = mode;
	_data_->mode = _tmp1_;
	fso_audio_manager_real_get_available_devices_co (_data_);
}


static FreeSmartphoneAudioDevice* fso_audio_manager_real_get_available_devices_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, int* result_length1, GError** error) {
	FreeSmartphoneAudioDevice* result;
	FsoAudioManagerGetAvailableDevicesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static gboolean fso_audio_manager_real_get_available_devices_co (FsoAudioManagerGetAvailableDevicesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->router;
	_data_->_tmp1_ = _data_->mode;
	_data_->_tmp2_ = 0;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = fso_audio_irouter_get_available_devices (_data_->_tmp0_, _data_->_tmp1_, &_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = _data_->_tmp2_;
	_data_->result_length1 = _data_->_tmp4__length1;
	_data_->result = _data_->_tmp4_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_get_mode_data_free (gpointer _data) {
	FsoAudioManagerGetModeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerGetModeData, _data_);
}


static void fso_audio_manager_real_get_mode (FreeSmartphoneAudioManager* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerGetModeData* _data_;
	FsoAudioManager* _tmp0_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerGetModeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_get_mode);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_get_mode_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_audio_manager_real_get_mode_co (_data_);
}


static FreeSmartphoneAudioMode fso_audio_manager_real_get_mode_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FreeSmartphoneAudioMode result;
	FsoAudioManagerGetModeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean fso_audio_manager_real_get_mode_co (FsoAudioManagerGetModeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_mode;
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_get_device_data_free (gpointer _data) {
	FsoAudioManagerGetDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerGetDeviceData, _data_);
}


static void fso_audio_manager_real_get_device (FreeSmartphoneAudioManager* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerGetDeviceData* _data_;
	FsoAudioManager* _tmp0_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerGetDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_get_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_get_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_audio_manager_real_get_device_co (_data_);
}


static FreeSmartphoneAudioDevice fso_audio_manager_real_get_device_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FreeSmartphoneAudioDevice result;
	FsoAudioManagerGetDeviceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean fso_audio_manager_real_get_device_co (FsoAudioManagerGetDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_devices;
	_data_->_tmp0__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp1_ = _data_->self->priv->current_mode;
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
	_data_->result = _data_->_tmp2_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_set_mode_data_free (gpointer _data) {
	FsoAudioManagerSetModeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerSetModeData, _data_);
}


static void fso_audio_manager_real_set_mode (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioMode mode, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerSetModeData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioMode _tmp1_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerSetModeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_set_mode);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_set_mode_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = mode;
	_data_->mode = _tmp1_;
	fso_audio_manager_real_set_mode_co (_data_);
}


static void fso_audio_manager_real_set_mode_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FsoAudioManagerSetModeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_audio_manager_real_set_mode_co (FsoAudioManagerSetModeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->mode;
	_data_->_tmp1_ = _data_->self->priv->current_mode;
	if (_data_->_tmp0_ == _data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp3_ = _data_->self->priv->current_mode;
	_data_->_tmp4_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_AUDIO_TYPE_MODE), _data_->_tmp3_);
	_data_->_tmp5_ = _data_->mode;
	_data_->_tmp6_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_AUDIO_TYPE_MODE), _data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strconcat ("Switching mode: ", (_data_->_tmp4_ != NULL) ? _data_->_tmp4_->value_name : NULL, " -> ", (_data_->_tmp6_ != NULL) ? _data_->_tmp6_->value_name : NULL, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = FALSE;
	_data_->_tmp9_ = fso_framework_logger_debug (_data_->_tmp2_, _data_->_tmp8_);
	g_assert (_data_->_tmp9_);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->self->priv->device_stack;
	g_queue_clear (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->self->priv->current_mode;
	_data_->previous_mode = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->mode;
	_data_->self->priv->current_mode = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->priv->router;
	_data_->_tmp14_ = _data_->self->priv->current_devices;
	_data_->_tmp14__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp15_ = _data_->self->priv->current_mode;
	_data_->_tmp16_ = _data_->_tmp14_[_data_->_tmp15_];
	fso_audio_irouter_set_device (_data_->_tmp13_, _data_->_tmp16_, FALSE);
	_data_->_tmp17_ = _data_->self->priv->router;
	_data_->_tmp18_ = _data_->self->priv->current_mode;
	fso_audio_irouter_set_mode (_data_->_tmp17_, _data_->_tmp18_, FALSE);
	_data_->_tmp19_ = _data_->self->priv->current_mode;
	g_signal_emit_by_name ((FreeSmartphoneAudioManager*) _data_->self, "mode-changed", _data_->_tmp19_);
	_data_->_tmp20_ = _data_->self->priv->current_devices;
	_data_->_tmp20__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp21_ = _data_->previous_mode;
	_data_->_tmp22_ = _data_->_tmp20_[_data_->_tmp21_];
	_data_->_tmp23_ = _data_->self->priv->current_devices;
	_data_->_tmp23__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp24_ = _data_->self->priv->current_mode;
	_data_->_tmp25_ = _data_->_tmp23_[_data_->_tmp24_];
	if (_data_->_tmp22_ != _data_->_tmp25_) {
		_data_->_tmp26_ = _data_->self->priv->current_devices;
		_data_->_tmp26__length1 = _data_->self->priv->current_devices_length1;
		_data_->_tmp27_ = _data_->self->priv->current_mode;
		_data_->_tmp28_ = _data_->_tmp26_[_data_->_tmp27_];
		g_signal_emit_by_name ((FreeSmartphoneAudioManager*) _data_->self, "device-changed", _data_->_tmp28_);
	}
	fso_audio_manager_adjustVolumeSettings (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_set_device_data_free (gpointer _data) {
	FsoAudioManagerSetDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerSetDeviceData, _data_);
}


static void fso_audio_manager_real_set_device (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioDevice device, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerSetDeviceData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioDevice _tmp1_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerSetDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_set_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_set_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = device;
	_data_->device = _tmp1_;
	fso_audio_manager_real_set_device_co (_data_);
}


static void fso_audio_manager_real_set_device_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FsoAudioManagerSetDeviceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_audio_manager_real_set_device_co (FsoAudioManagerSetDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->router;
	_data_->_tmp1_ = _data_->self->priv->current_mode;
	_data_->_tmp2_ = 0;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = fso_audio_irouter_get_available_devices (_data_->_tmp0_, _data_->_tmp1_, &_data_->_tmp2_);
	_data_->supported_devices = _data_->_tmp3_;
	_data_->supported_devices_length1 = _data_->_tmp2_;
	_data_->_supported_devices_size_ = _data_->supported_devices_length1;
	_data_->_tmp4_ = _data_->device;
	_data_->_tmp5_ = _data_->supported_devices;
	_data_->_tmp5__length1 = _data_->supported_devices_length1;
	if (!_vala_free_smartphone_audio_device_array_contains (_data_->_tmp5_, _data_->_tmp5__length1, _data_->_tmp4_)) {
		_data_->_tmp6_ = g_error_new_literal (FREE_SMARTPHONE_AUDIO_ERROR, FREE_SMARTPHONE_AUDIO_ERROR_NOT_SUPPORTED_DEVICE, "The supplied audio device is not supported by the current router");
		_data_->_inner_error_ = _data_->_tmp6_;
		if ((((_data_->_inner_error_->domain == FREE_SMARTPHONE_AUDIO_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_data_->supported_devices = (g_free (_data_->supported_devices), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->supported_devices = (g_free (_data_->supported_devices), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp7_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp8_ = _data_->self->priv->current_devices;
	_data_->_tmp8__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp9_ = _data_->self->priv->current_mode;
	_data_->_tmp10_ = _data_->_tmp8_[_data_->_tmp9_];
	_data_->_tmp11_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_AUDIO_TYPE_DEVICE), _data_->_tmp10_);
	_data_->_tmp12_ = _data_->device;
	_data_->_tmp13_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_AUDIO_TYPE_DEVICE), _data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strconcat ("Switching output device: ", (_data_->_tmp11_ != NULL) ? _data_->_tmp11_->value_name : NULL, " -> ", (_data_->_tmp13_ != NULL) ? _data_->_tmp13_->value_name : NULL, NULL);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = FALSE;
	_data_->_tmp16_ = fso_framework_logger_debug (_data_->_tmp7_, _data_->_tmp15_);
	g_assert (_data_->_tmp16_);
	_g_free0 (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->self->priv->current_devices;
	_data_->_tmp17__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp18_ = _data_->self->priv->current_mode;
	_data_->_tmp19_ = _data_->device;
	_data_->_tmp17_[_data_->_tmp18_] = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->_tmp17_[_data_->_tmp18_];
	_data_->_tmp21_ = _data_->self->priv->router;
	_data_->_tmp22_ = _data_->self->priv->current_devices;
	_data_->_tmp22__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp23_ = _data_->self->priv->current_mode;
	_data_->_tmp24_ = _data_->_tmp22_[_data_->_tmp23_];
	fso_audio_irouter_set_device (_data_->_tmp21_, _data_->_tmp24_, TRUE);
	_data_->_tmp25_ = _data_->self->priv->current_devices;
	_data_->_tmp25__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp26_ = _data_->self->priv->current_mode;
	_data_->_tmp27_ = _data_->_tmp25_[_data_->_tmp26_];
	g_signal_emit_by_name ((FreeSmartphoneAudioManager*) _data_->self, "device-changed", _data_->_tmp27_);
	fso_audio_manager_adjustVolumeSettings (_data_->self);
	_data_->supported_devices = (g_free (_data_->supported_devices), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_push_device_data_free (gpointer _data) {
	FsoAudioManagerPushDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerPushDeviceData, _data_);
}


static void fso_audio_manager_real_push_device (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioDevice device, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerPushDeviceData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioDevice _tmp1_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerPushDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_push_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_push_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = device;
	_data_->device = _tmp1_;
	fso_audio_manager_real_push_device_co (_data_);
}


static void fso_audio_manager_real_push_device_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FsoAudioManagerPushDeviceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_audio_manager_real_push_device_co (FsoAudioManagerPushDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->device;
	free_smartphone_audio_manager_set_device ((FreeSmartphoneAudioManager*) _data_->self, _data_->_tmp0_, NULL, NULL);
	_data_->_tmp1_ = _data_->self->priv->device_stack;
	_data_->_tmp2_ = _data_->device;
	g_queue_push_head (_data_->_tmp1_, GINT_TO_POINTER (_data_->_tmp2_));
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_pull_device_data_free (gpointer _data) {
	FsoAudioManagerPullDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerPullDeviceData, _data_);
}


static void fso_audio_manager_real_pull_device (FreeSmartphoneAudioManager* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerPullDeviceData* _data_;
	FsoAudioManager* _tmp0_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerPullDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_pull_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_pull_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_audio_manager_real_pull_device_co (_data_);
}


static FreeSmartphoneAudioDevice fso_audio_manager_real_pull_device_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FreeSmartphoneAudioDevice result;
	FsoAudioManagerPullDeviceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean fso_audio_manager_real_pull_device_co (FsoAudioManagerPullDeviceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->device_stack;
	g_queue_pop_head (_data_->_tmp0_);
	_data_->_tmp1_ = _data_->self->priv->device_stack;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = g_queue_is_empty (_data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = g_error_new_literal (FREE_SMARTPHONE_AUDIO_ERROR, FREE_SMARTPHONE_AUDIO_ERROR_DEVICE_STACK_UNDERFLOW, "No device left to active");
		_data_->_inner_error_ = _data_->_tmp3_;
		if ((((_data_->_inner_error_->domain == FREE_SMARTPHONE_AUDIO_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp4_ = _data_->self->priv->device_stack;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_queue_peek_head (_data_->_tmp4_);
	_data_->device = GPOINTER_TO_INT (_data_->_tmp5_);
	free_smartphone_audio_manager_set_device ((FreeSmartphoneAudioManager*) _data_->self, _data_->device, NULL, NULL);
	_data_->result = _data_->device;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_set_mute_data_free (gpointer _data) {
	FsoAudioManagerSetMuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerSetMuteData, _data_);
}


static void fso_audio_manager_real_set_mute (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, gboolean mute, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerSetMuteData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioControl _tmp1_;
	gboolean _tmp2_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerSetMuteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_set_mute);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_set_mute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = control;
	_data_->control = _tmp1_;
	_tmp2_ = mute;
	_data_->mute = _tmp2_;
	fso_audio_manager_real_set_mute_co (_data_);
}


static void fso_audio_manager_real_set_mute_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FsoAudioManagerSetMuteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_audio_manager_real_set_mute_co (FsoAudioManagerSetMuteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_devices;
	_data_->_tmp0__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp1_ = _data_->self->priv->current_mode;
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
	_data_->current_device = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->devices;
	_data_->_tmp3__length1 = _data_->self->priv->devices_length1;
	_data_->_tmp4_ = _data_->current_device;
	_data_->_tmp5_ = _data_->_tmp3_[_data_->_tmp4_];
	_data_->_tmp6_ = _data_->self->priv->current_mode;
	_data_->_tmp7_ = _data_->control;
	_data_->_tmp8_ = FALSE;
	_data_->_tmp8_ = fso_audio_device_info_get_mute (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_);
	_data_->_tmp9_ = _data_->mute;
	if (_data_->_tmp8_ == _data_->_tmp9_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->self->priv->devices;
	_data_->_tmp10__length1 = _data_->self->priv->devices_length1;
	_data_->_tmp11_ = _data_->current_device;
	_data_->_tmp12_ = _data_->_tmp10_[_data_->_tmp11_];
	_data_->_tmp13_ = _data_->self->priv->current_mode;
	_data_->_tmp14_ = _data_->control;
	_data_->_tmp15_ = _data_->mute;
	fso_audio_device_info_set_mute (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_);
	_data_->_tmp16_ = _data_->mute;
	if (_data_->_tmp16_) {
		_data_->_tmp17_ = _data_->self->priv->router;
		_data_->_tmp18_ = _data_->control;
		fso_audio_irouter_set_volume (_data_->_tmp17_, _data_->_tmp18_, (guint) 0);
	} else {
		_data_->_tmp19_ = _data_->self->priv->devices;
		_data_->_tmp19__length1 = _data_->self->priv->devices_length1;
		_data_->_tmp20_ = _data_->current_device;
		_data_->_tmp21_ = _data_->_tmp19_[_data_->_tmp20_];
		_data_->_tmp22_ = _data_->self->priv->current_mode;
		_data_->_tmp23_ = _data_->control;
		_data_->_tmp24_ = 0;
		_data_->_tmp24_ = fso_audio_device_info_get_volume (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_);
		_data_->level = _data_->_tmp24_;
		_data_->_tmp25_ = _data_->self->priv->router;
		_data_->_tmp26_ = _data_->control;
		_data_->_tmp27_ = _data_->level;
		fso_audio_irouter_set_volume (_data_->_tmp25_, _data_->_tmp26_, (guint) _data_->_tmp27_);
	}
	_data_->_tmp28_ = _data_->control;
	_data_->_tmp29_ = _data_->mute;
	g_signal_emit_by_name ((FreeSmartphoneAudioManager*) _data_->self, "mute-changed", _data_->_tmp28_, _data_->_tmp29_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_get_mute_data_free (gpointer _data) {
	FsoAudioManagerGetMuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerGetMuteData, _data_);
}


static void fso_audio_manager_real_get_mute (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerGetMuteData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioControl _tmp1_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerGetMuteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_get_mute);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_get_mute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = control;
	_data_->control = _tmp1_;
	fso_audio_manager_real_get_mute_co (_data_);
}


static gboolean fso_audio_manager_real_get_mute_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	FsoAudioManagerGetMuteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean fso_audio_manager_real_get_mute_co (FsoAudioManagerGetMuteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_devices;
	_data_->_tmp0__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp1_ = _data_->self->priv->current_mode;
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
	_data_->current_device = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->devices;
	_data_->_tmp3__length1 = _data_->self->priv->devices_length1;
	_data_->_tmp4_ = _data_->_tmp3_[_data_->current_device];
	_data_->_tmp5_ = _data_->self->priv->current_mode;
	_data_->_tmp6_ = _data_->control;
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = fso_audio_device_info_get_mute (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_set_volume_data_free (gpointer _data) {
	FsoAudioManagerSetVolumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerSetVolumeData, _data_);
}


static void fso_audio_manager_real_set_volume (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, gint volume, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerSetVolumeData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioControl _tmp1_;
	gint _tmp2_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerSetVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_set_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_set_volume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = control;
	_data_->control = _tmp1_;
	_tmp2_ = volume;
	_data_->volume = _tmp2_;
	fso_audio_manager_real_set_volume_co (_data_);
}


static void fso_audio_manager_real_set_volume_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FsoAudioManagerSetVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_audio_manager_real_set_volume_co (FsoAudioManagerSetVolumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->volume;
	if (_data_->_tmp1_ < 0) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->volume;
		_data_->_tmp0_ = _data_->_tmp2_ > 100;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, "Supplied volume level is out of range 0 - 100");
		_data_->_inner_error_ = _data_->_tmp4_;
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp5_ = _data_->self->priv->current_devices;
	_data_->_tmp5__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp6_ = _data_->self->priv->current_mode;
	_data_->_tmp7_ = _data_->_tmp5_[_data_->_tmp6_];
	_data_->current_device = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->self->priv->devices;
	_data_->_tmp8__length1 = _data_->self->priv->devices_length1;
	_data_->_tmp9_ = _data_->current_device;
	_data_->_tmp10_ = _data_->_tmp8_[_data_->_tmp9_];
	_data_->_tmp11_ = _data_->self->priv->current_mode;
	_data_->_tmp12_ = _data_->control;
	_data_->_tmp13_ = _data_->volume;
	fso_audio_device_info_set_volume (_data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_, _data_->_tmp13_);
	_data_->_tmp14_ = _data_->self->priv->devices;
	_data_->_tmp14__length1 = _data_->self->priv->devices_length1;
	_data_->_tmp15_ = _data_->current_device;
	_data_->_tmp16_ = _data_->_tmp14_[_data_->_tmp15_];
	_data_->_tmp17_ = _data_->self->priv->current_mode;
	_data_->_tmp18_ = _data_->control;
	_data_->_tmp19_ = FALSE;
	_data_->_tmp19_ = fso_audio_device_info_get_mute (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
	if (!_data_->_tmp19_) {
		_data_->_tmp20_ = _data_->self->priv->router;
		_data_->_tmp21_ = _data_->control;
		_data_->_tmp22_ = _data_->volume;
		fso_audio_irouter_set_volume (_data_->_tmp20_, _data_->_tmp21_, (guint) _data_->_tmp22_);
	}
	_data_->_tmp23_ = _data_->control;
	_data_->_tmp24_ = _data_->volume;
	g_signal_emit_by_name ((FreeSmartphoneAudioManager*) _data_->self, "volume-changed", _data_->_tmp23_, _data_->_tmp24_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_get_volume_data_free (gpointer _data) {
	FsoAudioManagerGetVolumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerGetVolumeData, _data_);
}


static void fso_audio_manager_real_get_volume (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioControl control, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerGetVolumeData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioControl _tmp1_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerGetVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_get_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_get_volume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = control;
	_data_->control = _tmp1_;
	fso_audio_manager_real_get_volume_co (_data_);
}


static gint fso_audio_manager_real_get_volume_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	gint result;
	FsoAudioManagerGetVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean fso_audio_manager_real_get_volume_co (FsoAudioManagerGetVolumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_devices;
	_data_->_tmp0__length1 = _data_->self->priv->current_devices_length1;
	_data_->_tmp1_ = _data_->self->priv->current_mode;
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
	_data_->current_device = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->devices;
	_data_->_tmp3__length1 = _data_->self->priv->devices_length1;
	_data_->_tmp4_ = _data_->_tmp3_[_data_->current_device];
	_data_->_tmp5_ = _data_->self->priv->current_mode;
	_data_->_tmp6_ = _data_->control;
	_data_->_tmp7_ = 0;
	_data_->_tmp7_ = fso_audio_device_info_get_volume (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_register_session_data_free (gpointer _data) {
	FsoAudioManagerRegisterSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerRegisterSessionData, _data_);
}


static void fso_audio_manager_real_register_session (FreeSmartphoneAudioManager* base, FreeSmartphoneAudioStream stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerRegisterSessionData* _data_;
	FsoAudioManager* _tmp0_;
	FreeSmartphoneAudioStream _tmp1_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerRegisterSessionData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_register_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_register_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = stream;
	_data_->stream = _tmp1_;
	fso_audio_manager_real_register_session_co (_data_);
}


static gchar* fso_audio_manager_real_register_session_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	gchar* result;
	FsoAudioManagerRegisterSessionData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean fso_audio_manager_real_register_session_co (FsoAudioManagerRegisterSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sessionhandler;
	_data_->_tmp1_ = _data_->stream;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = fso_audio_session_handler_register_session (_data_->_tmp0_, _data_->_tmp1_, &_data_->_inner_error_);
	_data_->token = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->self->priv->policy;
	_data_->_tmp4_ = _data_->stream;
	fso_audio_abstract_session_policy_handleConnectingStream (_data_->_tmp3_, _data_->_tmp4_);
	_data_->result = _data_->token;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->token);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_real_release_session_data_free (gpointer _data) {
	FsoAudioManagerReleaseSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->token);
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoAudioManagerReleaseSessionData, _data_);
}


static void fso_audio_manager_real_release_session (FreeSmartphoneAudioManager* base, const gchar* token, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoAudioManager * self;
	FsoAudioManagerReleaseSessionData* _data_;
	FsoAudioManager* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (FsoAudioManager*) base;
	_data_ = g_slice_new0 (FsoAudioManagerReleaseSessionData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_audio_manager_real_release_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_audio_manager_real_release_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = token;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->token = _tmp2_;
	fso_audio_manager_real_release_session_co (_data_);
}


static void fso_audio_manager_real_release_session_finish (FreeSmartphoneAudioManager* base, GAsyncResult* _res_, GError** error) {
	FsoAudioManagerReleaseSessionData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_audio_manager_real_release_session_co (FsoAudioManagerReleaseSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sessionhandler;
	_data_->_tmp1_ = _data_->token;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = fso_audio_session_handler_streamTypeForToken (_data_->_tmp0_, _data_->_tmp1_);
	_data_->stream = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->sessionhandler;
	_data_->_tmp4_ = _data_->token;
	fso_audio_session_handler_release_session (_data_->_tmp3_, _data_->_tmp4_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp5_ = _data_->self->priv->policy;
	fso_audio_abstract_session_policy_handleDisconnectingStream (_data_->_tmp5_, _data_->stream);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_audio_manager_class_init (FsoAudioManagerClass * klass) {
	fso_audio_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoAudioManagerPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = fso_audio_manager_real_repr;
	G_OBJECT_CLASS (klass)->finalize = fso_audio_manager_finalize;
}


static void fso_audio_manager_free_smartphone_audio_manager_interface_init (FreeSmartphoneAudioManagerIface * iface) {
	fso_audio_manager_free_smartphone_audio_manager_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_available_devices = (FreeSmartphoneAudioDevice* (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioMode, int*, GError**)) fso_audio_manager_real_get_available_devices;
	iface->get_available_devices_finish = fso_audio_manager_real_get_available_devices_finish;
	iface->get_mode = (FreeSmartphoneAudioMode (*)(FreeSmartphoneAudioManager*, GError**)) fso_audio_manager_real_get_mode;
	iface->get_mode_finish = fso_audio_manager_real_get_mode_finish;
	iface->get_device = (FreeSmartphoneAudioDevice (*)(FreeSmartphoneAudioManager*, GError**)) fso_audio_manager_real_get_device;
	iface->get_device_finish = fso_audio_manager_real_get_device_finish;
	iface->set_mode = (void (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioMode, GError**)) fso_audio_manager_real_set_mode;
	iface->set_mode_finish = fso_audio_manager_real_set_mode_finish;
	iface->set_device = (void (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioDevice, GError**)) fso_audio_manager_real_set_device;
	iface->set_device_finish = fso_audio_manager_real_set_device_finish;
	iface->push_device = (void (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioDevice, GError**)) fso_audio_manager_real_push_device;
	iface->push_device_finish = fso_audio_manager_real_push_device_finish;
	iface->pull_device = (FreeSmartphoneAudioDevice (*)(FreeSmartphoneAudioManager*, GError**)) fso_audio_manager_real_pull_device;
	iface->pull_device_finish = fso_audio_manager_real_pull_device_finish;
	iface->set_mute = (void (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioControl, gboolean, GError**)) fso_audio_manager_real_set_mute;
	iface->set_mute_finish = fso_audio_manager_real_set_mute_finish;
	iface->get_mute = (gboolean (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioControl, GError**)) fso_audio_manager_real_get_mute;
	iface->get_mute_finish = fso_audio_manager_real_get_mute_finish;
	iface->set_volume = (void (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioControl, gint, GError**)) fso_audio_manager_real_set_volume;
	iface->set_volume_finish = fso_audio_manager_real_set_volume_finish;
	iface->get_volume = (gint (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioControl, GError**)) fso_audio_manager_real_get_volume;
	iface->get_volume_finish = fso_audio_manager_real_get_volume_finish;
	iface->register_session = (gchar* (*)(FreeSmartphoneAudioManager*, FreeSmartphoneAudioStream, GError**)) fso_audio_manager_real_register_session;
	iface->register_session_finish = fso_audio_manager_real_register_session_finish;
	iface->release_session = (void (*)(FreeSmartphoneAudioManager*, const gchar*, GError**)) fso_audio_manager_real_release_session;
	iface->release_session_finish = fso_audio_manager_real_release_session_finish;
}


static void fso_audio_manager_free_smartphone_info_interface_init (FreeSmartphoneInfoIface * iface) {
	fso_audio_manager_free_smartphone_info_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_info = (GHashTable* (*)(FreeSmartphoneInfo*, GError**)) fso_audio_manager_real_get_info;
	iface->get_info_finish = fso_audio_manager_real_get_info_finish;
}


static void fso_audio_manager_instance_init (FsoAudioManager * self) {
	self->priv = FSO_AUDIO_MANAGER_GET_PRIVATE (self);
}


static void fso_audio_manager_finalize (GObject* obj) {
	FsoAudioManager * self;
	self = FSO_AUDIO_MANAGER (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_object_unref0 (self->priv->router);
	self->priv->devices = (_vala_array_free (self->priv->devices, self->priv->devices_length1, (GDestroyNotify) fso_audio_device_info_unref), NULL);
	self->priv->default_devices = (g_free (self->priv->default_devices), NULL);
	self->priv->current_devices = (g_free (self->priv->current_devices), NULL);
	_g_queue_free0 (self->priv->device_stack);
	_g_object_unref0 (self->priv->sessionhandler);
	_g_object_unref0 (self->priv->policy);
	_g_object_unref0 (self->priv->streamcontrol);
	G_OBJECT_CLASS (fso_audio_manager_parent_class)->finalize (obj);
}


/**
     * The audio subsystem manager. Here all features come together and are wrapped into a
     * simple API which can be used with DBus.
     **/
GType fso_audio_manager_get_type (void) {
	return fso_audio_manager_type_id;
}


GType fso_audio_manager_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (FsoAudioManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_audio_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoAudioManager), 0, (GInstanceInitFunc) fso_audio_manager_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_audio_manager_info = { (GInterfaceInitFunc) fso_audio_manager_free_smartphone_audio_manager_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo free_smartphone_info_info = { (GInterfaceInitFunc) fso_audio_manager_free_smartphone_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	fso_audio_manager_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "FsoAudioManager", &g_define_type_info, 0);
	g_type_module_add_interface (module, fso_audio_manager_type_id, FREE_SMARTPHONE_AUDIO_TYPE_MANAGER, &free_smartphone_audio_manager_info);
	g_type_module_add_interface (module, fso_audio_manager_type_id, FREE_SMARTPHONE_TYPE_INFO, &free_smartphone_info_info);
	return fso_audio_manager_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoAudioManager* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = subsystem;
	_tmp1_ = fso_audio_manager_new (_tmp0_);
	_g_object_unref0 (instance);
	instance = _tmp1_;
	_tmp2_ = g_strdup (FSO_AUDIO_MANAGER_MODULE_NAME);
	result = _tmp2_;
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	fso_audio_manager_register_type (module);
	fso_audio_device_info_register_type (module);
	fso_audio_control_info_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsoaudio.manager fso_register_function");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



