// generated by scripts/build-jcm800-preamp.py
// DO NOT MODIFY!
#include <iostream>
#include <cmath>

#include <float.h>
#include <Eigen/Core>

#include "gx_compiler.h"
#include "gx_plugin.h"

using namespace Eigen;

#define N_(x) (x)

#define creal double

static inline int sign(creal v) {
    return v < 0 ? -1 : 1;
}

static inline int Heaviside(creal v) {
    return v < 0 ? 0 : 1;  // Heaviside(0) == 1/2 in sympy but shouldn't matter
}

static Matrix<creal, 7, 1> g_x;
creal g_v_data[8];
static Map<Matrix<creal, 8, 1> >g_v(g_v_data);
static int g_info;
static int g_nfev;


static creal x0_data[] = {-101.11169547,-4.28127308,-514.34759921,-230.31382521,-1133.65846006,-4.20085902,-20.3466745};

#define real realtype  // real conflicts with Eigen::real of new eigen library version
typedef double real;
#ifndef _INTPP_H
#define _INTPP_H 1

#ifndef NO_INTPP_INCLUDES
typedef double real;
typedef double treal;
//typedef float real;
//typedef float treal;
#endif

template<typename M>
struct splinecoeffs {
    real *x0;
    real *xe;
    real *stepi; // 1/h
    int *k;
    int *n;
    int *nmap;
    M **map;
    treal **t;
    treal **c;
    int (*eval)(splinecoeffs *p, real *x, real *res);
};

template<typename M>
struct splinedata {
    splinecoeffs<M> *sc;
    int m;
    int n_input;
    int n_output;
    int n_state;
    const char *func_id;
    template<int K0> static int splev(splinecoeffs<M> *p, real *x, real *res);
    template<int K0> static int splev_pp(splinecoeffs<M> *p, real *x, real *res);
    template<int K0, int K1> static int splev(splinecoeffs<M> *p, real *x, real *res);
    template<int K0, int K1> static int splevgr(splinecoeffs<M> *p, real xi[2], real res[1], real grad[2]);
    template<int K0, int K1, int K2> static int splev(splinecoeffs<M> *p, real *x, real *res);
    template<int K0, int K1, int K2, int K3> static int splev(splinecoeffs<M> *p, real *x, real *res);
    union retval {
	char c[4];
	int i;
    };
};

template<typename M>
class SplineCalc {
  protected:
    splinedata<M> *sd;
    real *s0;
    real *temp;
  public:
    SplineCalc(splinedata<M> *sd_, real *s0_);
    ~SplineCalc();
    void reset();
    void calc(real *in, real *out);
};

//#define CHECK_BOUNDS

#ifdef CHECK_BOUNDS
template<typename M>
void report(splinedata<M> *sd, real *t, int i);
template<typename M>
static inline void check(splinedata<M> *sd, creal *t, int i) { if (i) report(sd, t, i); }
#else
#define check(sd, t, i) i
#endif

#endif /* !_INTPP_H */

#define NO_INTPP_INCLUDES
#include <cstdio>
#include <cstdlib>

#ifndef NO_INTPP_INCLUDES
#include "intpp.h"
#include "intpp_inst.cc"
#endif

#define always_inline inline __attribute__((always_inline))

/****************************************************************
 ** fpbspl evaluates the k non-zero b-splines of order k
 ** at t[0] <= x < t[1] using the stable recurrence relation
 ** of de boor and cox.
 **
 ** t: knot array
 ** K: order (> 0)
 ** h[K]: output array
 */
template<int K> static always_inline void fpbspl(treal *t, real x, real *h)
{
    real hh[K-1];
    h[0] = 1;
    for (int j = 0; j < K-1; j++) {
	for (int i = 0; i <= j; i++) {
	    hh[i] = h[i];
	}
	h[0] = 0;
	for (int i = 0; i <= j; i++) {
	    int li = i+1;
	    int lj = i-j;
	    real f = hh[i]/(t[li]-t[lj]);
	    h[i] = h[i]+f*(t[li]-x);
	    h[i+1] = f*(x-t[lj]);
	}
    }
}

template<> always_inline void fpbspl<2>(treal *t, real x, real *h)
{
    h[0] = (t[1]-x)/(t[1]-t[0]);
    h[1] = 1-h[0];
}


/****************************************************************
 ** search for knot interval
 ** n: len(map)
 ** k: order
 ** returns index l: t[l] <= x < t[l+1]
 */
static always_inline int find_index(int n, int k, real xi, real x0, real xe, real stepi, char* cl)
{
    int l;
    if (k % 2) {
	l = static_cast<int>((xi - x0) * stepi + 0.5);
    } else {
	l = static_cast<int>((xi - x0) * stepi);
    }
    if (l < 0) {
	*cl = -1;
	return 0;
    }
    if (l > n-2) {
	*cl = 1;
	return n-2;
    }
    return l;
}

template<int K, typename M>
static always_inline int forward(int i, splinecoeffs<M> *p, real *xi, int ll,
			  typename splinedata<M>::retval *cl, real *h)
{
    int l = p->map[i][find_index(p->nmap[i], K, xi[i], p->x0[i], p->xe[i], p->stepi[i], &cl->c[i])];
    fpbspl<K>(p->t[i]+l, xi[i], h);
    return ll*p->n[i] + l-K+1;
}

/****************************************************************
 ** evaluate the spline function at x
 **
 ** t[n+k]: knot array
 ** c[m][n]: coefficents
 ** k: order (k > 0), order = degree + 1
 ** x: function argument
 ** res: output array (size m)
 */
template<>
template<int K0>
always_inline int splinedata<unsigned short>::splev(splinecoeffs<unsigned short> *p, real xi[1], real *res)
{
    real h[K0];
    retval cl;
    cl.i = 0;
    int ll = 0;
    ll = forward<K0>(0, p, xi, ll, &cl, h);
    treal *c = p->c[0]+ll;
    real sp = 0;
    for (int j = 0; j < K0; j++) {
	sp += c[j]*h[j];
    }
    *res = sp;
    return cl.i;
}

template<>
template<int K0>
always_inline int splinedata<unsigned char>::splev(splinecoeffs<unsigned char> *p, real xi[1], real *res)
{
    real h[K0];
    retval cl;
    cl.i = 0;
    int ll = 0;
    ll = forward<K0>(0, p, xi, ll, &cl, h);
    treal *c = p->c[0]+ll;
    real sp = 0;
    for (int j = 0; j < K0; j++) {
	sp += c[j]*h[j];
    }
    *res = sp;
    return cl.i;
}

template<>
template<>
always_inline int splinedata<unsigned short>::splev_pp<4>(splinecoeffs<unsigned short> *p, real xi[1], real *res)
{
    retval cl;
    cl.i = 0;
    int l = p->map[0][find_index(p->nmap[0], 4, xi[0], p->x0[0], p->xe[0], p->stepi[0], &cl.c[0])];
    treal x = xi[0] - p->t[0][l];
    treal *c = p->c[0] + (l-3)*4;
    *res = ((c[0] * x + c[1]) * x + c[2]) * x + c[3];
    return cl.i;
}

template<>
template<>
always_inline int splinedata<unsigned char>::splev_pp<4>(splinecoeffs<unsigned char> *p, real xi[1], real *res)
{
    retval cl;
    cl.i = 0;
    int l = p->map[0][find_index(p->nmap[0], 4, xi[0], p->x0[0], p->xe[0], p->stepi[0], &cl.c[0])];
    treal x = xi[0] - p->t[0][l];
    treal *c = p->c[0] + (l-3)*4;
    *res = ((c[0] * x + c[1]) * x + c[2]) * x + c[3];
    return cl.i;
}

template<>
template<>
always_inline int splinedata<unsigned short>::splev_pp<2>(splinecoeffs<unsigned short> *p, real xi[1], real *res)
{
    retval cl;
    cl.i = 0;
    int l = p->map[0][find_index(p->nmap[0], 2, xi[0], p->x0[0], p->xe[0], p->stepi[0], &cl.c[0])];
    treal x = xi[0] - p->t[0][l];
    treal *c = p->c[0] + (l-1)*2;
    *res = c[0] * x + c[1];
    return cl.i;
}

template<>
template<>
always_inline int splinedata<unsigned char>::splev_pp<2>(splinecoeffs<unsigned char> *p, real xi[1], real *res)
{
    retval cl;
    cl.i = 0;
    int l = p->map[0][find_index(p->nmap[0], 2, xi[0], p->x0[0], p->xe[0], p->stepi[0], &cl.c[0])];
    treal x = xi[0] - p->t[0][l];
    treal *c = p->c[0] + (l-1)*2;
    *res = c[0] * x + c[1];
    return cl.i;
}

/****************************************************************
 ** evaluate the X-dim spline function
 **
 ** t: array of pointers to knot arrays
 ** c[m][n[0]]...[n[X-1]]: coefficents
 ** k: orders (2 <= k[i] <= 5), order = degree + 1
 ** x: function arguments
 ** res[m]: output array
 */
template<typename M>
template<int K0, int K1>
int splinedata<M>::splev(splinecoeffs<M> *p, real xi[2], real *res)
{
    real h[2][6];
    retval cl;
    cl.i = 0;
    int ll = 0;
    ll = forward<K0>(0, p, xi, ll, &cl, h[0]);
    ll = forward<K1>(1, p, xi, ll, &cl, h[1]);
    treal *c = p->c[0]+ll;
    int j[2];
    real sp = 0;
    for (j[0] = 0; j[0] < K0; j[0]++) {
	for (j[1] = 0; j[1] < K1; j[1]++) {
	    sp += c[j[1]]*h[0][j[0]]*h[1][j[1]];
	}
	c += p->n[1];
    }
    *res = sp;
    return cl.i;
}

template<int K, int S>
static inline void deriv(real *t, real *wrk) {
    for (int i = 0; i < K-1; i++, wrk += S) {
	real fac = t[i+1] - t[i+1-(K-1)];
	if (fac > 0) {
	    wrk[0] = (K-1) * (wrk[S] - wrk[0]) / fac;
	}
    }
}

template<int K0, int K1, int S0, int S1>
static inline void deriv2d(real *t, real *c) {
    for (int i = 0; i < K0; i++) {
	deriv<K1, S1>(t, c);
	c += S0;
    }
}

template<int K0, int K1>
static inline void copy2d(real *c, real *wrk, int n)  {
    int j[2];
    for (j[0] = 0; j[0] < K0; j[0]++) {
	for (j[1] = 0; j[1] < K1; j[1]++) {
	    *wrk++ = *c++;
	}
	c += n - K1;
    }
}

template<int K0, int K1, int S>
static inline real eval2d(real *c, real *h0, real *h1) {
    int j[2];
    real sp = 0;
    for (j[0] = 0; j[0] < K0; j[0]++) {
	for (j[1] = 0; j[1] < K1; j[1]++) {
	    sp += *c++ * h0[j[0]] * h1[j[1]];
	}
	c += S;
    }
    return sp;
}

template<typename M>
template<int K0, int K1>
int splinedata<M>::splevgr(splinecoeffs<M> *p, real xi[2], real res[1], real grad[2])
{
    real h0[K0];
    real h1[K1];
    retval cl;
    cl.i = 0;
    int ll = 0;
//  ll = forward<K0>(0, p, xi, ll, &cl, h0);
    int l[2];
    l[0] = p->map[0][find_index(p->nmap[0], K0, xi[0], p->x0[0], p->xe[0], p->stepi[0], &cl.c[0])];
    fpbspl<K0>(p->t[0]+l[0], xi[0], h0);
    ll = l[0]-(K0-1);
//  ll = forward<K1>(1, p, xi, ll, &cl, h1);
    l[1] = p->map[1][find_index(p->nmap[1], K1, xi[1], p->x0[1], p->xe[1], p->stepi[1], &cl.c[1])];
    fpbspl<K1>(p->t[1]+l[1], xi[1], h1);
    ll = ll*p->n[1] + l[1]-(K1-1);
//    
    treal wrk[K0*K1];
    copy2d<K0, K1>(p->c[0]+ll, wrk, p->n[1]);
    res[0] = eval2d<K0, K1, 0>(wrk, h0, h1);

    deriv2d<K1, K0, 1, K1>(p->t[0]+l[0], wrk);
    real hx[6];
    fpbspl<K0-1>(p->t[0]+l[0], xi[0], hx);
    grad[0] = eval2d<K0-1, K1, 0>(wrk, hx, h1);

    copy2d<K0, K1>(p->c[0]+ll, wrk, p->n[1]);
    deriv2d<K0, K1, K1, 1>(p->t[1]+l[1], wrk);
    fpbspl<K1-1>(p->t[1]+l[1], xi[1], hx);
    grad[1] = eval2d<K0, K1-1, 1>(wrk, h0, hx);
    return cl.i;
}

template<typename M>
template<int K0, int K1, int K2>
int splinedata<M>::splev(splinecoeffs<M> *p, real xi[3], real *res)
{
    real h[3][6];
    retval cl;
    cl.i = 0;
    int ll = 0;
    ll = forward<K0>(0, p, xi, ll, &cl, h[0]);
    ll = forward<K1>(1, p, xi, ll, &cl, h[1]);
    ll = forward<K2>(2, p, xi, ll, &cl, h[2]);
    treal *cc = p->c[0];
    int lc = ll;
    int j[3];
    real sp = 0;
    for (j[0] = 0; j[0] < K0; j[0]++) {
	for (j[1] = 0; j[1] < K1; j[1]++) {
	    for (j[2] = 0; j[2] < K2; j[2]++) {
		sp += cc[lc]*h[0][j[0]]*h[1][j[1]]*h[2][j[2]];
		lc += 1;
	    }
	    lc += p->n[2]-K2;
	}
	lc += (p->n[1]-K1)*p->n[2];
    }
    *res = sp;
    return cl.i;
}

template<typename M>
template<int K0, int K1, int K2, int K3>
int splinedata<M>::splev(splinecoeffs<M> *p, real xi[4], real *res)
{
    real h[4][6];
    retval cl;
    cl.i = 0;
    int ll = 0;
    ll = forward<K0>(0, p, xi, ll, &cl, h[0]);
    ll = forward<K1>(1, p, xi, ll, &cl, h[1]);
    ll = forward<K2>(2, p, xi, ll, &cl, h[2]);
    ll = forward<K3>(3, p, xi, ll, &cl, h[3]);
    treal *cc = p->c[0];
    int lc = ll;
    int j[4];
    real sp = 0;
    for (j[0] = 0; j[0] < K0; j[0]++) {
	for (j[1] = 0; j[1] < K1; j[1]++) {
	    for (j[2] = 0; j[2] < K2; j[2]++) {
		for (j[3] = 0; j[3] < K3; j[3]++) {
		    sp += cc[lc]*h[0][j[0]]*h[1][j[1]]*h[2][j[2]]*h[3][j[3]];
		    lc += 1;
		}
		lc += p->n[3]-K3;
	    }
	    lc += (p->n[2]-K2)*p->n[3];
	}
	lc += (p->n[1]-K1)*p->n[2]*p->n[3];
    }
    *res = sp;
    return cl.i;
}

template<typename M>
SplineCalc<M>::SplineCalc(splinedata<M> *sd_, real *s0_)
    : sd(sd_),
      s0(s0_),
      temp(new real[sd->n_input+sd->n_state]) {
}

template<typename M>
SplineCalc<M>::~SplineCalc() {
    delete[] temp;
}

#ifdef CHECK_BOUNDS
void report(splinedata *sd, real *t, int i)
{
    printf("%s:", sd->func_id);
    splinedata::retval cl;
    cl.i = i;
    for (int n = 0; n < 4; n++) {
	if (cl.c[n] < 0) {
	    printf(" %d:L[%g]", n, t[n]);
	} else if (cl.c[n] > 0) {
	    printf(" %d:U[%g]", n, t[n]);
	}
    }
    printf("\n");
}
#endif

template<typename M>
void SplineCalc<M>::calc(real *in, real *out)
{
    for (int i = 0; i < sd->n_input; i++) {
	temp[i] = in[i];
    }
    real t[sd->m];
    for (int i = 0; i < sd->m; i++) {
	splinecoeffs<M> *p = &sd->sc[i];
	check(sd, temp, (*p->eval)(p, temp, &t[i]));
    }
    for (int i = 0; i < sd->n_output; i++) {
	out[i] = t[i];
    }
    for (int i = 0; i < sd->n_state; i++) {
	temp[i+sd->n_input] = t[i+sd->n_output];
    }
}

template<typename M>
void SplineCalc<M>::reset()
{
    for (int i = 0; i < sd->n_state; i++) {
	temp[i+sd->n_input] = s0[i];
    }
}

template int splinedata<unsigned char>::splev_pp<4>(splinecoeffs<unsigned char> *p, real xi[2], real *res);

#ifndef NO_INTPP_INCLUDES
#include "intpp.h"
#endif
namespace AmpData {
namespace nonlin_0 {
typedef unsigned char maptype;
real x0_0[1] = {-119.508269216};
real xe_0[1] = {148.877449521};
real hi_0[1] = {1.31899715702};
int k_0[1] = {4};
int nmap_0[1] = {355};
int n_0[1] = {39};
treal t0_0[43] = {
  -215.79354119211405,-215.79354119211405,-215.79354119211405,-215.79354119211405,-118.75011746798432,-70.22840560591945,-58.09797764040323,-56.5816741447137,-55.82352239686894,-55.065370649024175,
  -54.30721890117941,-53.54906715333465,-52.03276365764512,-49.000156666266065,-45.96754967488702,-39.902335692128915,-33.837121709370805,-21.706693743854586,-9.57626577833837,-3.5110517955802605,
  -1.9947482998907333,-0.47844480420120616,2.554162187177848,8.619376169935958,14.684590152694065,20.749804135452173,26.815018118210283,29.847625109589334,32.880232100968385,35.91283909234744,
  38.945446083726495,45.010660066484604,51.075874049242714,63.20630201475893,75.33672998027515,87.46715794579137,99.59758591130759,123.85844184234001,148.11929777337244,172.38015370440488,
  172.38015370440488,172.38015370440488,172.38015370440488};
maptype a0_0[354] = {
  3,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,6,6,7,8,9,10,11,11,12,
  12,12,12,13,13,13,13,14,14,14,
  14,14,14,14,14,15,15,15,15,15,
  15,15,15,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,16,17,
  17,17,17,17,17,17,17,17,17,17,
  17,17,17,17,17,18,18,18,18,18,
  18,18,18,19,19,20,20,21,21,21,
  21,22,22,22,22,22,22,22,22,23,
  23,23,23,23,23,23,23,24,24,24,
  24,24,24,24,24,25,25,25,25,25,
  25,25,25,26,26,26,26,27,27,27,
  27,28,28,28,28,29,29,29,29,30,
  30,30,30,30,30,30,30,31,31,31,
  31,31,31,31,31,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,
  32,33,33,33,33,33,33,33,33,33,
  33,33,33,33,33,33,33,34,34,34,
  34,34,34,34,34,34,34,34,34,34,
  34,34,34,35,35,35,35,35,35,35,
  35,35,35,35,35,35,35,35,35,36,
  36,36,36,36,36,36,36,36,36,36,
  36,36,36,36,36,36,36,36,36,36,
  36,36,36,36,36,36,36,36,36,36,
  36,37,37,37,37,37,37,37,37,37,
  37,37,37,37,37,37,37,37,37,37,
  37,37,37,37,37,37,37,37,37,37,
  37,37,37,38};
treal c0_0[144] = {
  -1.6873137730947968e-08,2.283373705907306e-06,-7.08366044887381e-05,0.00016094985081404104,1.0773629819818119e-07,-2.6289074572326475e-06,-0.00010436838272959129,-0.0006301219261502878,-4.3813060254044074e-06,1.3053741397540291e-05,
  0.00040146240593189064,0.0004238755997537633,0.006950938857027557,-0.00014638761001061073,-0.001215934482642564,-0.0006058448954747285,0.03812445957054991,0.03147281105169455,0.04628443088943314,0.02144656244395482,
  -0.014607563382236495,0.11818518802884288,0.15974790447129264,0.09124148997352426,-0.015591328547518634,0.08496093889885559,0.3137634956694214,0.27392108803937953,-0.009927806034353953,0.049499159930285946,
  0.41570465461211475,0.5538420679993398,-0.003613308257829718,0.026918809438658223,0.4736410716559274,0.8931347516741054,-0.0007786511779558718,0.010482193611605111,0.5303523433233364,1.660612560301017,
  -0.0001771877081884625,0.0033981645932615705,0.5724460146582606,3.3436478532585276,-5.90972253293622e-05,0.0017861425453452849,0.5881679807322562,5.105961793530823,-2.0878100771578455e-05,0.0007108305931157232,
  0.6033126571262213,8.725847190649315,1.6272671169467374e-06,0.0003309401469160916,0.6096312195854904,12.406558431601251,-3.0490891639089684e-05,0.00039015848654441857,0.6183784546147153,19.85324757556291,
  0.0002813674649289688,-0.0007194442073525958,0.6143840778983787,27.357428628715304,0.0022374857272430527,0.004400217440388554,0.6367087551787501,31.120112155359543,-0.002443033099687247,0.01457833972971075,
  0.6654860077589153,32.103473174672544,-7.445119777083006e-05,0.003465200842287768,0.6928454914028523,33.1375530858228,-7.304069647906582e-05,0.0027878571736586763,0.7118085588595104,35.26847315413927,
  -9.203191801796418e-06,0.0014588348128730133,0.7375656544766893,39.672003944499636,9.846820433221443e-06,0.001291376830066232,0.7542462765889886,44.19710994426894,5.541887360394889e-05,0.0014705460489980809,
  0.770997929854389,48.821477677302184,7.87978917166114e-05,0.0024789280302722062,0.7949523352645198,53.56420687160392,3.6233408602374344e-05,0.0031958171422493816,0.8121616071490032,55.9999805241572,
  -2.454176271533914e-05,0.0035254622069965445,0.8325446058945382,58.493349029632526,-6.88566870740012e-05,0.0033021856434226346,0.8532501785003934,61.04986778901328,-6.210649668334695e-05,0.002675739831551187,
  0.871378877089742,63.66588906101117,-3.604600421055791e-05,0.001545672255239319,0.8969826447055279,69.03556317416984,-1.3518555506066317e-05,0.0008897920689580184,0.9117542569791581,74.52477263891492,
  -4.171710256724323e-06,0.000397834477665508,0.9273737180494612,85.69154238626115,-2.214325453001808e-06,0.0002460205853789093,0.9351839555119544,96.99207639859175,-1.225126751269013e-06,0.0001654384391793668,
  0.9401751295701202,108.36850678476425,-6.209590726258885e-07,0.00012085450376467978,0.9436479854915386,119.79539048410334,-2.850430075249797e-07,7.565950796454724e-05,0.9484155836185306,142.7513648625841,
  -1.8920535850098484e-07,5.4913345945412075e-05,0.9515833928157438,165.80120074168525};
maptype *map_0[1] = {a0_0};
treal *t_0[1] = {t0_0};
treal *c_0[1] = {c0_0};
real x0_1[2] = {-119.508269216};
real xe_1[2] = {124.61659359};
real hi_1[2] = {1.31899715702};
int k_1[2] = {4};
int nmap_1[2] = {323};
int n_1[2] = {48};
treal t0_1[52] = {
  -215.79354119211405,-215.79354119211405,-215.79354119211405,-215.79354119211405,-118.75011746798432,-70.22840560591945,-58.09797764040323,-56.5816741447137,-55.82352239686894,-55.065370649024175,
  -54.30721890117941,-53.54906715333465,-52.03276365764512,-49.000156666266065,-45.96754967488702,-39.902335692128915,-33.837121709370805,-21.706693743854586,-9.57626577833837,-3.5110517955802605,
  -2.752900047735497,-1.9947482998907333,-0.47844480420120616,2.554162187177848,5.586769178556903,8.619376169935958,11.651983161315012,14.684590152694065,17.71719714407312,20.749804135452173,
  23.782411126831228,26.815018118210283,29.847625109589334,31.363928605278858,32.880232100968385,34.39653559665791,35.91283909234744,38.945446083726495,41.97805307510555,45.010660066484604,
  48.04326705786366,51.075874049242714,57.14108803200082,63.20630201475893,75.33672998027515,87.46715794579137,99.59758591130759,123.85844184234001,172.38015370440488,172.38015370440488,
  172.38015370440488,172.38015370440488};
maptype a0_1[322] = {
  3,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,6,6,7,8,9,10,11,11,12,
  12,12,12,13,13,13,13,14,14,14,
  14,14,14,14,14,15,15,15,15,15,
  15,15,15,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,16,17,
  17,17,17,17,17,17,17,17,17,17,
  17,17,17,17,17,18,18,18,18,18,
  18,18,18,19,20,21,21,22,22,22,
  22,23,23,23,23,24,24,24,24,25,
  25,25,25,26,26,26,26,27,27,27,
  27,28,28,28,28,29,29,29,29,30,
  30,30,30,31,31,31,31,32,32,33,
  33,34,34,35,35,36,36,36,36,37,
  37,37,37,38,38,38,38,39,39,39,
  39,40,40,40,40,41,41,41,41,41,
  41,41,41,42,42,42,42,42,42,42,
  42,43,43,43,43,43,43,43,43,43,
  43,43,43,43,43,43,43,44,44,44,
  44,44,44,44,44,44,44,44,44,44,
  44,44,44,45,45,45,45,45,45,45,
  45,45,45,45,45,45,45,45,45,46,
  46,46,46,46,46,46,46,46,46,46,
  46,46,46,46,46,46,46,46,46,46,
  46,46,46,46,46,46,46,46,46,46,
  46,47};
treal c0_1[180] = {
  1.0848462380964293e-07,-1.468078678975303e-05,0.0004554388467900852,-0.0010348154739325075,-6.926827699175401e-07,1.6902371157982944e-05,0.0006710289999751239,0.004051323541752485,2.816929130984947e-05,-8.392809016328463e-05,
  -0.0025811736249478504,-0.0027252776403900265,-0.0446905647929792,0.0009411885870580284,0.00781776308031648,0.003895235708224949,-0.2451185155078063,-0.202352190272743,-0.2975824428460169,-0.1378891432531651,
  0.09391838287499231,-0.7598632831568145,-1.0270877858299128,-0.5866306558994957,0.10024296672209858,-0.5462501247625271,-2.0173199489274425,-1.7611561080801312,0.0638315030566027,-0.31825198347401656,
  -2.672743733302461,-3.5608880938752137,0.023229400313225696,-0.17307008664425141,-3.0452404195173335,-5.742346215974677,0.00500927083550711,-0.06740162395110483,-3.4098685149075125,-10.676790074493017,
  0.0011289600690984286,-0.02182817467869464,-3.6804674260715875,-21.497745510124755,0.0003955061366950978,-0.01155709808308764,-3.781711837658065,-32.828417357041296,8.065543929835555e-05,-0.004360610031438406,
  -3.8782561434877505,-56.102212462956054,7.077390934567486e-05,-0.0028930325367847536,-3.9222510378184667,-79.76708299563707,-8.396783874579635e-05,-0.00031747910931770134,-3.9611959180739635,-127.64503998619958,
  0.0010273344018808912,-0.0033731765672955936,-4.005965150904645,-175.8926371084096,0.12607956503023027,0.015319832370473666,-3.933506127080011,-200.0845426084335,-0.10427536142116145,0.30208216015600353,
  -3.6928672516766516,-203.00298830956112,-0.0022972441895976986,0.06491251760020961,-3.414629595286053,-205.6745482707608,-0.0029323318617046723,0.05446255941479127,-3.2336207487100004,-210.7109265064872,
  -0.0006268694165330165,0.02778472910024383,-2.984197046537335,-220.09813400834423,-0.00047699613857886777,0.022081583374464628,-2.8329721186922416,-228.90998625697446,-0.0001790534620116404,0.017741957900319367,
  -2.712202969000859,-237.31150291731925,-2.904731792126768e-05,0.016112961558137993,-2.6095343035585663,-245.3783748469969,0.0001587550867705028,0.015848694259911453,-2.512607162668699,-253.1446907929159,
  0.0004013802026051694,0.0172930196180831,-2.4121013694560083,-260.6142573945086,0.000731603729069995,0.020944704843947833,-2.296141378918027,-267.7589795778188,0.001100295647572758,0.027600704595037797,
  -2.1489222308540006,-274.5092472790924,0.0011320046972310152,0.03761099741527707,-1.9511607674177924,-280.74156108060157,0.000699100446660465,0.04790977349256718,-1.6918098796545378,-286.2811960086408,
  0.0002823183542081732,0.05108991884589529,-1.5416963000895396,-288.7339029896136,-0.000268385091836766,0.05237415976804479,-1.3848133560089262,-290.95313351651595,-0.000667354611794246,0.05115330000921566,
  -1.2278343068488093,-292.9334490799787,-0.0010856376846818574,0.048117563617031234,-1.0773095493122127,-294.679934641371,-0.0011223717443227808,0.03824062631901892,-0.8154190987493068,-297.53474649344264,
  -0.0008682804034554786,0.02802948912274021,-0.614447883341131,-299.6872073270599,-0.0006109637917904033,0.02013002945675068,-0.46839899059551743,-301.3170236603891,-0.0004477728214474514,0.014571590257361577,
  -0.36316261603832334,-302.56940354366094,-0.0002492843938587625,0.010497833290748378,-0.2871369069164824,-303.5492107932738,-0.000128473559440053,0.005961943716801739,-0.18730483725720898,-304.96019598427785,
  -5.509644364222013e-05,0.0036242848294101957,-0.1291623098368094,-305.9055839607225,-1.903179046664134e-05,0.0016192545071359696,-0.06555593363048545,-307.03741931311396,-1.0521608343926757e-05,0.0009266632172047965,
  -0.03467286206923881,-307.6283429185529,-4.137357935808846e-06,0.0005437683809126627,-0.016835897490056075,-307.9313642448178,-1.3662724279523318e-06,0.00024264084646534635,0.00224306347819632,-308.07884150099943,
};
maptype *map_1[2] = {a0_1};
treal *t_1[2] = {t0_1};
treal *c_1[1] = {c0_1};
splinecoeffs<maptype> sc[2] = {
	{x0_0, xe_0, hi_0, k_0, n_0, nmap_0, map_0, t_0, c_0, splinedata<unsigned char>::splev_pp<4>},
	{x0_1, xe_1, hi_1, k_1, n_1, nmap_1, map_1, t_1, c_1, splinedata<unsigned char>::splev_pp<4>},
};
splinedata<maptype> sd = {
	sc,
	2, /* number of calculated values */
	2, /* number of input values */
	2, /* number of output values */
	0, /* number of state values */
	"nonlin_0",
};
}; /* ! namespace nonlin_0 */
} // namespace AmpData

// nonlin_0: 2420 bytes
// data size sum: 2436 bytes
#ifndef NO_INTPP_INCLUDES
#include "intpp.h"
#endif
namespace AmpData {
namespace nonlin_1 {
typedef unsigned char maptype;
real x0_0[1] = {-84.3557465684};
real xe_0[1] = {477.417648954};
real hi_0[1] = {5.01625748471};
int k_0[1] = {4};
int nmap_0[1] = {2819};
int n_0[1] = {97};
treal t0_0[101] = {
  -288.2926463625786,-288.2926463625786,-288.2926463625786,-288.2926463625786,-84.15639476023611,-58.639363309943306,-45.880847584796896,-39.5015897222237,-38.704182489402044,-38.305478872991216,
  -37.906775256580396,-37.508071640169575,-37.30871983196416,-37.10936802375875,-36.910016215553334,-36.71066440734792,-36.51131259914251,-36.31196079093709,-36.11260898273168,-35.913257174526265,
  -35.71390536632086,-35.514553558115445,-35.31520174991003,-35.115849941704624,-34.7171463252938,-34.31844270888297,-33.91973909247214,-33.521035476061314,-33.122331859650494,-32.72362824323967,
  -32.324924626828846,-31.527517394007194,-30.730110161185543,-29.932702928363895,-29.135295695542244,-28.337888462720592,-27.540481229898944,-26.743073997077293,-25.148259531433993,-23.55344506579069,
  -21.95863060014739,-20.36381613450409,-18.76900166886079,-17.17418720321749,-13.984558271930888,-10.794929340644288,-9.997522107822636,-9.598818491411812,-9.200114875000986,-8.80141125859016,
  -8.402707642179337,-7.605300409357685,-6.8078931765360355,-6.010485943714385,-5.213078710892734,-4.415671478071085,-2.820857012427784,-1.226042546784483,0.36877191885881744,1.963586384502118,
  3.5584008501454187,5.153215315788719,6.748029781432019,8.34284424707532,11.532473178361922,13.127287644005222,14.722102109648523,16.316916575291824,17.911731040935123,21.101359972221726,
  24.290988903508328,27.480617834794927,30.67024676608153,33.85987569736813,37.04950462865473,40.23913355994134,43.428762491227936,49.80802035380114,56.18727821637434,62.56653607894754,
  68.94579394152075,75.32505180409395,81.70430966666714,94.46282539181355,107.22134111695996,119.97985684210636,132.73837256725278,145.49688829239918,171.013919742692,196.5309511929848,
  222.0479826432776,247.56501409357043,273.0820455438632,324.11610844444886,375.15017134503444,426.1842342456201,477.2182971462057,528.2523600467913,528.2523600467913,528.2523600467913,
  528.2523600467913};
maptype a0_0[2818] = {
  3,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,7,7,7,7,8,
  8,9,9,10,10,11,12,13,14,15,
  16,17,18,19,20,21,22,23,23,24,
  24,25,25,26,26,27,27,28,28,29,
  29,30,30,30,30,31,31,31,31,32,
  32,32,32,33,33,33,33,34,34,34,
  34,35,35,35,35,36,36,36,36,37,
  37,37,37,37,37,37,37,38,38,38,
  38,38,38,38,38,39,39,39,39,39,
  39,39,39,40,40,40,40,40,40,40,
  40,41,41,41,41,41,41,41,41,42,
  42,42,42,42,42,42,42,43,43,43,
  43,43,43,43,43,43,43,43,43,43,
  43,43,43,44,44,44,44,44,44,44,
  44,44,44,44,44,44,44,44,44,45,
  45,45,45,46,46,47,47,48,48,49,
  49,50,50,50,50,51,51,51,51,52,
  52,52,52,53,53,53,53,54,54,54,
  54,55,55,55,55,55,55,55,55,56,
  56,56,56,56,56,56,56,57,57,57,
  57,57,57,57,57,58,58,58,58,58,
  58,58,58,59,59,59,59,59,59,59,
  59,60,60,60,60,60,60,60,60,61,
  61,61,61,61,61,61,61,62,62,62,
  62,62,62,62,62,63,63,63,63,63,
  63,63,63,63,63,63,63,63,63,63,
  63,64,64,64,64,64,64,64,64,65,
  65,65,65,65,65,65,65,66,66,66,
  66,66,66,66,66,67,67,67,67,67,
  67,67,67,68,68,68,68,68,68,68,
  68,68,68,68,68,68,68,68,68,69,
  69,69,69,69,69,69,69,69,69,69,
  69,69,69,69,69,70,70,70,70,70,
  70,70,70,70,70,70,70,70,70,70,
  70,71,71,71,71,71,71,71,71,71,
  71,71,71,71,71,71,71,72,72,72,
  72,72,72,72,72,72,72,72,72,72,
  72,72,72,73,73,73,73,73,73,73,
  73,73,73,73,73,73,73,73,73,74,
  74,74,74,74,74,74,74,74,74,74,
  74,74,74,74,74,75,75,75,75,75,
  75,75,75,75,75,75,75,75,75,75,
  75,76,76,76,76,76,76,76,76,76,
  76,76,76,76,76,76,76,76,76,76,
  76,76,76,76,76,76,76,76,76,76,
  76,76,76,77,77,77,77,77,77,77,
  77,77,77,77,77,77,77,77,77,77,
  77,77,77,77,77,77,77,77,77,77,
  77,77,77,77,77,78,78,78,78,78,
  78,78,78,78,78,78,78,78,78,78,
  78,78,78,78,78,78,78,78,78,78,
  78,78,78,78,78,78,78,79,79,79,
  79,79,79,79,79,79,79,79,79,79,
  79,79,79,79,79,79,79,79,79,79,
  79,79,79,79,79,79,79,79,79,80,
  80,80,80,80,80,80,80,80,80,80,
  80,80,80,80,80,80,80,80,80,80,
  80,80,80,80,80,80,80,80,80,80,
  80,81,81,81,81,81,81,81,81,81,
  81,81,81,81,81,81,81,81,81,81,
  81,81,81,81,81,81,81,81,81,81,
  81,81,81,82,82,82,82,82,82,82,
  82,82,82,82,82,82,82,82,82,82,
  82,82,82,82,82,82,82,82,82,82,
  82,82,82,82,82,82,82,82,82,82,
  82,82,82,82,82,82,82,82,82,82,
  82,82,82,82,82,82,82,82,82,82,
  82,82,82,82,82,82,82,83,83,83,
  83,83,83,83,83,83,83,83,83,83,
  83,83,83,83,83,83,83,83,83,83,
  83,83,83,83,83,83,83,83,83,83,
  83,83,83,83,83,83,83,83,83,83,
  83,83,83,83,83,83,83,83,83,83,
  83,83,83,83,83,83,83,83,83,83,
  83,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,84,84,84,84,84,
  84,84,84,84,84,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,85,
  85,85,85,85,85,85,85,85,85,86,
  86,86,86,86,86,86,86,86,86,86,
  86,86,86,86,86,86,86,86,86,86,
  86,86,86,86,86,86,86,86,86,86,
  86,86,86,86,86,86,86,86,86,86,
  86,86,86,86,86,86,86,86,86,86,
  86,86,86,86,86,86,86,86,86,86,
  86,86,86,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,87,87,87,87,87,87,87,87,87,
  87,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,88,
  88,88,88,88,88,88,88,88,88,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,89,89,89,
  89,89,89,89,89,89,89,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,90,90,90,90,90,
  90,90,90,90,90,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,96};
treal c0_0[376] = {
  -1.4098306912781866e-10,3.785479628582994e-08,-2.324316285693539e-06,9.634462871282249e-06,1.960181358648102e-08,-4.848446952761055e-08,-4.494217937028353e-06,-8.667118842496641e-05,-3.8377800906645655e-07,1.4520558117794282e-06,
  3.1320756145940964e-05,9.275726642802674e-05,8.058124288697283e-06,-1.3237257479139876e-05,-0.000119040924651099,-6.831191554306465e-05,0.003638822081560925,0.00014097730069965273,0.0006958457504287977,0.0007255229802391752,
  0.004670889111060192,0.008845846441063149,0.007862004002203824,0.0032150580837461157,0.019412623179141764,0.014432747582364111,0.01714326362430375,0.00805188350667582,0.02478657002351342,0.03765239677899713,
  0.03790979904245813,0.018411627490388327,0.03409415836165908,0.06729988209938163,0.0797546521818247,0.041082765292381376,0.025629482570435055,0.08769007845529703,0.11065218107208565,0.05992668359129099,
  0.020535568540425205,0.10301792953665312,0.14867016730453342,0.08567334873170579,0.008508184988790085,0.11529933769983304,0.19219210929059144,0.11956775812526615,-0.002017129445343131,0.12038770388601742,
  0.2391767472013153,0.16253113598277213,-0.010668228781033587,0.11918134867907682,0.28693527102022465,0.21497981738085598,-0.015769209180709426,0.11280115658553257,0.33318140291674647,0.2768327668595422,
  -0.017917922338409296,0.10337029549310106,0.376275572771012,0.34761099786708965,-0.017927268404173198,0.09265438484076285,0.41535344724845596,0.42658831324184804,-0.016771949403814695,0.08193288472309611,
  0.450157735125656,0.5129299369683228,-0.014908007435508353,0.0719023294007556,0.4808250632269129,0.605792926721149,-0.013485932663309642,0.06298651468373057,0.5077153982018933,0.7043856450680901,
  -0.01056455946308883,0.054921179498429167,0.531220510238437,0.8079959419870516,-0.007597694694493399,0.04228479530726693,0.5699768839302077,1.0278564232767526,-0.0055921681762785445,0.0331971102540273,
  0.6000717926510764,1.2613485126383768,-0.004140082247370856,0.026508257227647908,0.6238765385851577,1.505522040732009,-0.003131611937591421,0.02155625993485283,0.643040035398887,1.7582153492909371,
  -0.002381741262315317,0.01781050492071384,0.6587357069131958,2.0178259377903167,-0.0019408210578741607,0.014961678356793871,0.6718020949036164,2.2831465315515485,-0.0013465173267465796,0.012640241233051724,
  0.6828070800639686,2.5532518243701197,-0.0008707301246721087,0.00941907326664953,0.7003973369971179,3.1050817954162833,-0.0006129355368492403,0.007336093768901817,0.7137580283784015,3.669131400390254,
  -0.0004409042020333111,0.005869816077890806,0.7242885164062246,4.242641149168397,-0.00032996881823149003,0.004815075478842343,0.7328087262154785,4.823702866857068,-0.00025047713097302743,0.004025716912052134,
  0.7398584380118525,5.410944244369379,-0.0002046610334437265,0.003426520084369212,0.7458009056934999,6.0033454981714325,-0.00014426760687552426,0.0029369255193348676,0.7508751632435607,6.600127544913067,
  -9.629140369029607e-05,0.002246685320228387,0.7591420607947615,7.8045187976839046,-7.098927230493294e-05,0.001785984549661238,0.7655734210384255,9.020533244497143,-5.255961182529003e-05,0.001446340394529043,
  0.7707283796170799,10.24573538917235,-4.7213527913433756e-05,0.0011948719067863356,0.7749406232020526,11.47836963045112,-1.974761181272241e-05,0.0009689814549151415,0.778391567844825,12.71710371077832,
  -5.4972617037243696e-05,0.0008745001239726269,0.7813315789339821,13.960878280377749,6.31178681843194e-05,0.0003484733747810334,0.7852324105878037,16.460149134814554,-0.0027661275165766067,0.000952441110106551,
  0.7893818450659309,18.97034262648757,0.03337280476381055,-0.0056647491557689856,0.785624216547036,19.599004505008278,-0.01078621129881676,0.034252824691541936,0.7970223856493744,19.913450386887725,
  -0.010582718433596582,0.02135132033491328,0.8191919593588541,20.23598745270275,-0.0009923009464007993,0.00869321600211588,0.8311708246498142,20.5653256229164,-0.001182329596975872,0.007506314074422235,
  0.8376296358754858,20.89803545814931,-0.00044052603991519946,0.0046779195577992295,0.8473454319002081,21.570140854252692,-0.00031459625000537306,0.003624083606375253,0.8539655092702291,22.248571360858524,
  -0.0001962409273418918,0.002871499630856695,0.8591451343249928,22.93167452589906,-0.0001517235006254813,0.0024020478263425374,0.8633502992099917,23.61848943530459,-9.808807298711842e-05,0.002039091575979201,
  0.8668916958913723,24.3083816408078,-6.16744044887281e-05,0.0015697947428584037,0.8726471999975167,25.695701475686946,-4.442835797282901e-05,0.0012747170455427246,0.8771836685453517,27.091154351545278,
  -3.348954139243773e-05,0.001062152081603185,0.8809105412336393,28.493161497868602,-2.6683222559134847e-05,0.0009019232664219256,0.8840428770102831,29.90061604105042,-2.2088178681282497e-05,0.0007742588984400619,
  0.8867160765738583,31.312686155853683,-1.667711339966583e-05,0.0006685792577981921,0.8890171357370091,32.72871346109606,-1.3575572323023186e-05,0.0005887885527133097,0.8910224041098471,34.14816368859959,
  3.870682341339684e-06,0.0005238369953528771,0.8927968354287474,35.57062158557842,1.652501762750896e-05,0.0005608751164921488,0.8962566645628054,38.42376718451725,1.025533165799457e-05,0.0006399381279642342,
  0.8981717388956004,39.85462385696781,4.217489203709734e-06,0.0006890041817986525,0.9002911553152158,41.288710377401316,-1.3606583009440145e-06,0.0007091825201709647,0.902521003693187,42.72627727870422,
  -6.5919455386986025e-06,0.0007026725275475353,0.90477265054668,44.16742907004963,-8.337302371781329e-06,0.0006395949469364391,0.909053985716819,47.060252983472736,-7.449588627944947e-06,0.0005598162443746847,
  0.9128796623531339,49.966034395389734,-6.315093844706993e-06,0.0004885319741330542,0.916223504160949,52.88323545568578,-5.222210236886068e-06,0.0004281035560404521,0.9191472313674356,55.810413718287215,
  -4.3340984409028905e-06,0.00037813281746995354,0.92171882622984,58.746338267744775,-3.584018510477514e-06,0.00033666032013550954,0.9239987511014315,61.689985681248636,-3.1164047298666206e-06,0.0003023652527416521,
  0.9260370055565125,64.64050761939896,-2.397927550774463e-06,0.0002725447286777092,0.9278707550661331,67.59719709834856,-1.7582332772723927e-06,0.0002266537341312325,0.9310552707849915,73.52679258666676,
  -1.3590446900958163e-06,0.00019300506375639925,0.9337323824710142,79.47500145791733,-1.0705780458318834e-06,0.00016699597418175295,0.9360289219228157,85.43902261536246,-8.554633498108393e-07,0.00014650749393263905,
  0.9380288413867284,91.41671043899811,-7.26565013231226e-07,0.00013013583003136704,0.9397936204862541,97.40637833182979,-5.433695525704639e-07,0.00011623099331138935,0.9413652579811407,103.40667142433091,
  -3.875120433256194e-07,9.543322636828125e-05,0.9440657792563745,115.43488643542663,-2.955848690540261e-07,8.060099087292065e-05,0.9463117145852102,127.49449432411251,-2.2764651014780293e-07,6.928731827309727e-05,
  0.9482240669344653,139.5805335437144,-1.889365693472967e-07,6.057402353461092e-05,0.9498809049060076,151.6892710006018,-1.3662970839616652e-07,5.334237296139283e-05,0.9513343090420538,163.81780929697055,
  -9.405186200125871e-08,4.288321926282487e-05,0.9537897005051623,188.12549895656414,-7.014801524368798e-08,3.5683446300890725e-05,0.9557944885812962,212.4897401795494,-5.297669610422804e-08,3.0313538967444306e-05,
  0.9574785357300128,236.90084688807764,-4.3382495941391207e-08,2.625811490557173e-05,0.9589220764010857,261.35171432750417,-3.079907645361472e-08,2.2937137365585694e-05,0.9601773932004939,285.8369354804065,
  -2.0795670460507038e-08,1.8221731350544535e-05,0.9622778974954699,334.89433445484354,-1.5313305483537226e-08,1.5037868687520437e-05,0.9639752700158608,384.0479791602135,-1.148795673562738e-08,1.2693368101732272e-05,
  0.9653905076984746,433.2806840883545,-9.203493258516892e-09,1.093453678179663e-05,0.9665963356825096,482.58001660466164};
maptype *map_0[1] = {a0_0};
treal *t_0[1] = {t0_0};
treal *c_0[1] = {c0_0};
real x0_1[2] = {-84.2062327123};
real xe_1[2] = {426.234072198};
real hi_1[2] = {20.0650299388};
int k_1[2] = {4};
int nmap_1[2] = {10243};
int n_1[2] = {195};
treal t0_1[199] = {
  -288.2926463625786,-288.2926463625786,-288.2926463625786,-288.2926463625786,-84.15639476023611,-58.639363309943306,-45.880847584796896,-42.6912186535103,-41.096404187866995,-39.5015897222237,
  -39.10288610581287,-38.704182489402044,-38.50483068119663,-38.305478872991216,-38.10612706478581,-38.0064511606831,-37.906775256580396,-37.80709935247769,-37.70742344837498,-37.60774754427228,
  -37.508071640169575,-37.408395736066865,-37.30871983196416,-37.258881879912806,-37.20904392786146,-37.1592059758101,-37.10936802375875,-37.05953007170739,-37.00969211965604,-36.95985416760469,
  -36.910016215553334,-36.86017826350198,-36.81034031145063,-36.760502359399275,-36.71066440734792,-36.660826455296565,-36.61098850324521,-36.56115055119386,-36.51131259914251,-36.46147464709115,
  -36.4116366950398,-36.36179874298845,-36.31196079093709,-36.26212283888574,-36.21228488683438,-36.162446934783034,-36.11260898273168,-36.062771030680324,-36.012933078628976,-35.96309512657762,
  -35.913257174526265,-35.81358127042356,-35.71390536632086,-35.61422946221815,-35.514553558115445,-35.41487765401274,-35.31520174991003,-35.21552584580733,-35.115849941704624,-35.016174037601914,
  -34.91649813349921,-34.81682222939651,-34.7171463252938,-34.617470421191086,-34.51779451708838,-34.41811861298568,-34.31844270888297,-34.21876680478026,-34.119090900677556,-33.91973909247214,
  -33.72038728426673,-33.521035476061314,-33.32168366785591,-33.122331859650494,-32.92298005144508,-32.72362824323967,-32.52427643503426,-32.324924626828846,-32.12557281862343,-31.92622101041802,
  -31.726869202212605,-31.527517394007194,-31.12881377759637,-30.730110161185543,-30.33140654477472,-29.932702928363895,-29.533999311953067,-29.135295695542244,-28.73659207913142,-28.337888462720592,
  -27.939184846309768,-27.540481229898944,-26.743073997077293,-25.94566676425564,-25.148259531433993,-24.35085229861234,-23.55344506579069,-22.756037832969042,-21.95863060014739,-21.16122336732574,
  -20.36381613450409,-18.76900166886079,-17.17418720321749,-15.57937273757419,-13.984558271930888,-10.794929340644288,-9.997522107822636,-9.598818491411812,-9.499142587309105,-9.399466683206398,
  -9.200114875000986,-9.000763066795574,-8.80141125859016,-8.602059450384749,-8.402707642179337,-8.004004025768511,-7.605300409357685,-7.20659679294686,-6.8078931765360355,-6.40918956012521,
  -6.010485943714385,-5.61178232730356,-5.213078710892734,-4.8143750944819095,-4.415671478071085,-3.618264245249434,-2.820857012427784,-2.0234497796061337,-1.226042546784483,-0.42863531396283283,
  0.36877191885881744,1.1661791516804678,1.963586384502118,2.760993617323768,3.5584008501454187,4.355808082967069,5.153215315788719,5.950622548610369,6.748029781432019,7.54543701425367,
  7.944140630664495,8.34284424707532,8.741547863486145,9.140251479896971,9.538955096307795,9.937658712718621,10.336362329129447,10.73506594554027,11.133769561951096,11.532473178361922,
  11.931176794772746,12.329880411183572,12.728584027594398,13.127287644005222,13.525991260416047,13.924694876826873,14.323398493237697,14.722102109648523,15.519509342470172,16.316916575291824,
  17.114323808113475,17.911731040935123,18.709138273756775,19.506545506578426,20.303952739400074,21.101359972221726,21.898767205043377,22.696174437865025,24.290988903508328,25.885803369151628,
  27.480617834794927,29.07543230043823,30.67024676608153,32.26506123172483,33.85987569736813,37.04950462865473,40.23913355994134,43.428762491227936,46.618391422514534,49.80802035380114,
  56.18727821637434,62.56653607894754,68.94579394152075,75.32505180409395,81.70430966666714,94.46282539181355,107.22134111695996,119.97985684210636,145.49688829239918,171.013919742692,
  196.5309511929848,222.0479826432776,273.0820455438632,324.11610844444886,426.1842342456201,528.2523600467913,528.2523600467913,528.2523600467913,528.2523600467913};
maptype a0_1[10242] = {
  3,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,
  6,6,6,7,7,7,7,7,7,7,
  7,7,7,7,7,7,7,7,7,7,
  7,7,7,7,7,7,7,7,7,7,
  7,7,7,7,7,8,8,8,8,8,
  8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,8,9,9,9,
  9,9,9,9,9,10,10,10,10,10,
  10,10,10,11,11,11,11,12,12,12,
  12,13,13,13,13,14,14,15,15,16,
  16,17,17,18,18,19,19,20,20,21,
  21,22,23,24,25,26,27,28,29,30,
  31,32,33,34,35,36,37,38,39,40,
  41,42,43,44,45,46,47,48,49,50,
  50,51,51,52,52,53,53,54,54,55,
  55,56,56,57,57,58,58,59,59,60,
  60,61,61,62,62,63,63,64,64,65,
  65,66,66,67,67,68,68,68,68,69,
  69,69,69,70,70,70,70,71,71,71,
  71,72,72,72,72,73,73,73,73,74,
  74,74,74,75,75,75,75,76,76,76,
  76,77,77,77,77,78,78,78,78,79,
  79,79,79,80,80,80,80,81,81,81,
  81,81,81,81,81,82,82,82,82,82,
  82,82,82,83,83,83,83,83,83,83,
  83,84,84,84,84,84,84,84,84,85,
  85,85,85,85,85,85,85,86,86,86,
  86,86,86,86,86,87,87,87,87,87,
  87,87,87,88,88,88,88,88,88,88,
  88,89,89,89,89,89,89,89,89,90,
  90,90,90,90,90,90,90,91,91,91,
  91,91,91,91,91,91,91,91,91,91,
  91,91,91,92,92,92,92,92,92,92,
  92,92,92,92,92,92,92,92,92,93,
  93,93,93,93,93,93,93,93,93,93,
  93,93,93,93,93,94,94,94,94,94,
  94,94,94,94,94,94,94,94,94,94,
  94,95,95,95,95,95,95,95,95,95,
  95,95,95,95,95,95,95,96,96,96,
  96,96,96,96,96,96,96,96,96,96,
  96,96,96,97,97,97,97,97,97,97,
  97,97,97,97,97,97,97,97,97,98,
  98,98,98,98,98,98,98,98,98,98,
  98,98,98,98,98,99,99,99,99,99,
  99,99,99,99,99,99,99,99,99,99,
  99,100,100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,100,100,
  100,100,100,100,100,100,100,100,100,100,
  100,100,100,101,101,101,101,101,101,101,
  101,101,101,101,101,101,101,101,101,101,
  101,101,101,101,101,101,101,101,101,101,
  101,101,101,101,101,102,102,102,102,102,
  102,102,102,102,102,102,102,102,102,102,
  102,102,102,102,102,102,102,102,102,102,
  102,102,102,102,102,102,102,103,103,103,
  103,103,103,103,103,103,103,103,103,103,
  103,103,103,103,103,103,103,103,103,103,
  103,103,103,103,103,103,103,103,103,104,
  104,104,104,104,104,104,104,104,104,104,
  104,104,104,104,104,104,104,104,104,104,
  104,104,104,104,104,104,104,104,104,104,
  104,104,104,104,104,104,104,104,104,104,
  104,104,104,104,104,104,104,104,104,104,
  104,104,104,104,104,104,104,104,104,104,
  104,104,104,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,106,
  106,106,106,106,106,106,106,107,107,108,
  108,109,109,109,109,110,110,110,110,111,
  111,111,111,112,112,112,112,113,113,113,
  113,114,114,114,114,114,114,114,114,115,
  115,115,115,115,115,115,115,116,116,116,
  116,116,116,116,116,117,117,117,117,117,
  117,117,117,118,118,118,118,118,118,118,
  118,119,119,119,119,119,119,119,119,120,
  120,120,120,120,120,120,120,121,121,121,
  121,121,121,121,121,122,122,122,122,122,
  122,122,122,123,123,123,123,123,123,123,
  123,124,124,124,124,124,124,124,124,124,
  124,124,124,124,124,124,124,125,125,125,
  125,125,125,125,125,125,125,125,125,125,
  125,125,125,126,126,126,126,126,126,126,
  126,126,126,126,126,126,126,126,126,127,
  127,127,127,127,127,127,127,127,127,127,
  127,127,127,127,127,128,128,128,128,128,
  128,128,128,128,128,128,128,128,128,128,
  128,129,129,129,129,129,129,129,129,129,
  129,129,129,129,129,129,129,130,130,130,
  130,130,130,130,130,130,130,130,130,130,
  130,130,130,131,131,131,131,131,131,131,
  131,131,131,131,131,131,131,131,131,132,
  132,132,132,132,132,132,132,132,132,132,
  132,132,132,132,132,133,133,133,133,133,
  133,133,133,133,133,133,133,133,133,133,
  133,134,134,134,134,134,134,134,134,134,
  134,134,134,134,134,134,134,135,135,135,
  135,135,135,135,135,135,135,135,135,135,
  135,135,135,136,136,136,136,136,136,136,
  136,136,136,136,136,136,136,136,136,137,
  137,137,137,137,137,137,137,137,137,137,
  137,137,137,137,137,138,138,138,138,138,
  138,138,138,138,138,138,138,138,138,138,
  138,139,139,139,139,139,139,139,139,140,
  140,140,140,140,140,140,140,141,141,141,
  141,141,141,141,141,142,142,142,142,142,
  142,142,142,143,143,143,143,143,143,143,
  143,144,144,144,144,144,144,144,144,145,
  145,145,145,145,145,145,145,146,146,146,
  146,146,146,146,146,147,147,147,147,147,
  147,147,147,148,148,148,148,148,148,148,
  148,149,149,149,149,149,149,149,149,150,
  150,150,150,150,150,150,150,151,151,151,
  151,151,151,151,151,152,152,152,152,152,
  152,152,152,153,153,153,153,153,153,153,
  153,154,154,154,154,154,154,154,154,155,
  155,155,155,155,155,155,155,156,156,156,
  156,156,156,156,156,157,157,157,157,157,
  157,157,157,157,157,157,157,157,157,157,
  157,158,158,158,158,158,158,158,158,158,
  158,158,158,158,158,158,158,159,159,159,
  159,159,159,159,159,159,159,159,159,159,
  159,159,159,160,160,160,160,160,160,160,
  160,160,160,160,160,160,160,160,160,161,
  161,161,161,161,161,161,161,161,161,161,
  161,161,161,161,161,162,162,162,162,162,
  162,162,162,162,162,162,162,162,162,162,
  162,163,163,163,163,163,163,163,163,163,
  163,163,163,163,163,163,163,164,164,164,
  164,164,164,164,164,164,164,164,164,164,
  164,164,164,165,165,165,165,165,165,165,
  165,165,165,165,165,165,165,165,165,166,
  166,166,166,166,166,166,166,166,166,166,
  166,166,166,166,166,167,167,167,167,167,
  167,167,167,167,167,167,167,167,167,167,
  167,167,167,167,167,167,167,167,167,167,
  167,167,167,167,167,167,167,168,168,168,
  168,168,168,168,168,168,168,168,168,168,
  168,168,168,168,168,168,168,168,168,168,
  168,168,168,168,168,168,168,168,168,169,
  169,169,169,169,169,169,169,169,169,169,
  169,169,169,169,169,169,169,169,169,169,
  169,169,169,169,169,169,169,169,169,169,
  169,170,170,170,170,170,170,170,170,170,
  170,170,170,170,170,170,170,170,170,170,
  170,170,170,170,170,170,170,170,170,170,
  170,170,170,171,171,171,171,171,171,171,
  171,171,171,171,171,171,171,171,171,171,
  171,171,171,171,171,171,171,171,171,171,
  171,171,171,171,171,172,172,172,172,172,
  172,172,172,172,172,172,172,172,172,172,
  172,172,172,172,172,172,172,172,172,172,
  172,172,172,172,172,172,172,173,173,173,
  173,173,173,173,173,173,173,173,173,173,
  173,173,173,173,173,173,173,173,173,173,
  173,173,173,173,173,173,173,173,173,174,
  174,174,174,174,174,174,174,174,174,174,
  174,174,174,174,174,174,174,174,174,174,
  174,174,174,174,174,174,174,174,174,174,
  174,174,174,174,174,174,174,174,174,174,
  174,174,174,174,174,174,174,174,174,174,
  174,174,174,174,174,174,174,174,174,174,
  174,174,174,175,175,175,175,175,175,175,
  175,175,175,175,175,175,175,175,175,175,
  175,175,175,175,175,175,175,175,175,175,
  175,175,175,175,175,175,175,175,175,175,
  175,175,175,175,175,175,175,175,175,175,
  175,175,175,175,175,175,175,175,175,175,
  175,175,175,175,175,175,175,176,176,176,
  176,176,176,176,176,176,176,176,176,176,
  176,176,176,176,176,176,176,176,176,176,
  176,176,176,176,176,176,176,176,176,176,
  176,176,176,176,176,176,176,176,176,176,
  176,176,176,176,176,176,176,176,176,176,
  176,176,176,176,176,176,176,176,176,176,
  176,177,177,177,177,177,177,177,177,177,
  177,177,177,177,177,177,177,177,177,177,
  177,177,177,177,177,177,177,177,177,177,
  177,177,177,177,177,177,177,177,177,177,
  177,177,177,177,177,177,177,177,177,177,
  177,177,177,177,177,177,177,177,177,177,
  177,177,177,177,177,178,178,178,178,178,
  178,178,178,178,178,178,178,178,178,178,
  178,178,178,178,178,178,178,178,178,178,
  178,178,178,178,178,178,178,178,178,178,
  178,178,178,178,178,178,178,178,178,178,
  178,178,178,178,178,178,178,178,178,178,
  178,178,178,178,178,178,178,178,178,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,179,179,179,
  179,179,179,179,179,179,179,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,180,180,180,180,180,
  180,180,180,180,180,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,181,181,181,181,181,181,181,
  181,181,181,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,182,182,182,182,182,182,182,182,182,
  182,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,183,
  183,183,183,183,183,183,183,183,183,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,184,184,184,184,184,
  184,184,184,184,184,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,185,185,185,185,185,185,185,185,185,
  185,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,186,186,186,
  186,186,186,186,186,186,186,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,187,
  187,187,187,187,187,187,187,187,187,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,188,188,188,188,188,188,188,188,188,
  188,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,189,189,189,189,189,189,189,
  189,189,189,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,190,190,190,190,190,
  190,190,190,190,190,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,191,
  191,191,191,191,191,191,191,191,191,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,192,192,192,192,192,192,192,
  192,192,192,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,193,193,193,193,193,193,193,193,193,
  193,194};
treal c0_1[768] = {
  4.758132187241876e-10,-1.277407818568957e-07,7.842343643041684e-06,-3.249730423203469e-05,-6.659405609327934e-08,1.636513989427078e-07,1.51730024076664e-05,0.0002928390839064367,1.3652402880314968e-06,-4.934196472261609e-06,
  -0.00010655714626325138,-0.00031986944119434904,-8.036914681457448e-05,4.732112257809819e-05,0.00043423711699868344,0.0003528011907137261,0.001031708537008783,-0.0007217221450096626,-0.0017168518954382972,-0.0003887246361204182,
  -0.011789414681082473,0.004214428952438226,0.0038533674452996126,-0.0007775134306049452,-0.10092424815904007,-0.052191358272135085,-0.07266093345089891,-0.03173443910946691,-0.18705435381703153,-0.17290794644579432,
  -0.16240884029350022,-0.07539774672947357,-0.3823221169606225,-0.3966456884425172,-0.38949193426340206,-0.17949243495638517,-0.5000679827535931,-0.6252955044415826,-0.593217758944445,-0.2759304445750457,
  -0.7443466542453533,-0.9243638742042699,-0.9021451581799735,-0.423001208804493,-0.9513162022909202,-1.3695244285706374,-1.3594359391593827,-0.6454778178096151,-1.0673903359450871,-1.6539943362233507,
  -1.6608079056117337,-0.7955295374202644,-1.216663740339414,-1.973173626520795,-2.022349151630617,-0.9785620193218263,-1.3536298863545688,-2.3369898014427184,-2.4519685881432873,-1.2009504160162128,
  -1.4738143026995427,-2.741762649671241,-2.958197830421928,-1.4699117749153536,-1.562815057862952,-3.1824739689744574,-3.54870147150378,-1.793472544837961,-1.6084985603056616,-3.6497989804878825,
  -4.229714454817882,-2.1803590302130664,-1.5923057425051776,-4.130784625227007,-5.00525116016424,-2.639814348749391,-1.5353024599628842,-4.606928168703397,-5.876190582689012,-3.1813346835435867,
  -1.4872167535380243,-4.836477159855271,-6.346830564655231,-3.485824828023705,-1.4124784494678153,-5.05883667161364,-6.83999274092102,-3.8143349116087966,-1.324190681413058,-5.270021771328088,
  -7.354761892745586,-4.167966237668229,-1.2201526402987273,-5.4680066263894345,-7.889923237157122,-4.547766221100498,-1.1028492821842337,-5.650436352737062,-8.444043665236556,-4.9547164302671085,
  -0.9740272918787632,-5.81532760167317,-9.01547385942861,-5.389721468813564,-0.8360551749729735,-5.960958178081245,-9.602379825462982,-5.853599031711619,-0.69144153101802,-6.085960011249016,
  -10.202773556549424,-6.347071426983463,-0.5428328314153126,-6.189340100856591,-10.814549374952538,-6.870758796956554,-0.3928779618852645,-6.270501130728513,-11.435522344819686,-7.425174202459737,
  -0.24413338870808318,-6.329241829807929,-12.063467730346302,-8.010720655868898,-0.09897088159728572,-6.365743154169634,-12.69615978327045,-8.627690109823265,0.04049532423209753,-6.380540672324211,
  -13.331408465448215,-9.27626433328757,0.17246210672753484,-6.374486060242061,-13.967092876159606,-9.956517540185265,0.29546987712551875,-6.348700585624777,-14.601190442156671,-10.668420581708274,
  0.40841482060540657,-6.304523744918373,-15.231801229637322,-11.41184647384948,0.5105430853054584,-6.243460070179188,-15.857167045355334,-12.186577007501413,0.6014300835524821,-6.167126804762385,
  -16.475685278957762,-12.992310179113149,0.6809486620060904,-6.077204673763392,-17.08591768408543,-13.828668183819053,0.7492295828039622,-5.97539341346391,-17.686594489650922,-14.69520572786125,
  0.8066190487374586,-5.8633732093941875,-18.276614372948107,-15.591418440346017,0.8536317621973758,-5.742772484970126,-18.855040905564877,-16.516751193136336,0.8909188387291441,-5.615142708468424,
  -19.421096138378747,-17.47060616941952,0.919189347906291,-5.4819379973697275,-19.97415191450633,-18.452350553961754,0.9393216829518062,-5.344506453428517,-20.51371973393187,-19.461323749469692,
  0.9517882073269205,-5.204064846441286,-21.03943892458501,-20.496844052518632,0.9586669931621209,-5.061759321321873,-21.551066577225633,-21.558214748292713,0.9568019924633494,-4.918425322406581,
  -22.048458540963445,-22.64472960545432,0.9390996294140703,-4.632315011468424,-23.000437218592587,-24.89034807690646,0.9074117420140406,-4.35149819765534,-23.895906922501812,-27.228030826813868,
  0.8668130679370982,-4.080156940319346,-24.7363397714617,-29.65221171452345,0.8206147406307873,-3.820955811615341,-25.523890328428188,-32.15750785854976,0.7715526841311134,-3.5755692630382034,
  -26.261145652462595,-34.73877432966058,0.7216089208322907,-3.3448536289772783,-26.950945060997334,-37.39113799281977,0.6722170809183882,-3.1290725641996744,-27.59623950739642,-40.11001526963585,
  0.624359607369657,-2.928061028318213,-28.199989774501496,-42.89111792041162,0.57867743706858,-2.7413602032688615,-28.76509446149904,-45.730450211511304,0.5355531113256744,-2.568319613097924,
  -29.29434159769127,-48.624300136579166,0.4951858346738723,-2.408174391398717,-29.79037813685116,-51.56922674710293,0.45762467013713537,-2.2601001040887962,-30.255692617788498,-54.562045135640396,
  0.42288693506746533,-2.1232576458819254,-30.692607764522457,-57.59981020252892,0.39070120887578375,-1.996802733123713,-31.103278507757565,-60.67980001382201,0.361604477451065,-1.8799722444375744,
  -31.489699558648727,-63.799499310830555,0.3329489110164922,-1.7718424847850052,-31.85369749339958,-66.95658354589249,0.31387788500953867,-1.67228153360826,-32.196993668774795,-70.14890368197416,
  0.2769571725739628,-1.5784233477097496,-32.52101061679124,-73.37447189440188,0.2370414298576837,-1.4127876082655146,-33.11731392958875,-79.91812832962906,0.2053914303716691,-1.2710236952803367,
  -33.65233656583274,-86.57439258604857,0.17827157083626777,-1.148188236176871,-34.134610838800846,-93.33193145856792,0.1555294279964258,-1.0415719561833863,-34.57114349268408,-100.18094581409619,
  0.13624319417159467,-0.9485567380826627,-34.967879246447495,-107.11292686455853,0.11986609364233064,-0.8670757567412967,-35.32982886732716,-114.12045416837498,0.10588933926891464,-0.795389189210945,
  -35.66124426038084,-121.19702838329417,0.09392616261924326,-0.732061495452141,-35.96574431631303,-128.3369326803239,0.08360125461384792,-0.6758884443843154,-36.246421682682126,-135.5351176770351,
  0.07481172149803667,-0.6258902605577801,-36.50593362139564,-142.78710563173624,0.06671196217014098,-0.5811487046909998,-36.74655902169238,-150.08891041047778,0.06144571340761554,-0.5412512538283535,
  -36.97031148295289,-157.43697038737002,0.05205463381114172,-0.5045033116055148,-37.178784546511196,-164.82809197337897,0.0425475829025917,-0.4422401993511847,-37.55625460814311,-179.72830677001144,
  0.035583294235618006,-0.39134857383277627,-37.88860946661102,-194.76972517071823,0.029938266180490333,-0.3487870095461223,-38.183704200338525,-209.93600608474796,0.025448839154870645,-0.3129775245604282,
  -38.447552113299224,-225.2135343358435,0.02180602146999261,-0.28253789194691503,-38.68498626348911,-240.59085180326693,0.01882159126876444,-0.25645547308806066,-38.89988486734999,-256.05822718268286,
  0.016389229604109032,-0.23394276357167235,-39.095408417787716,-271.6073263844652,0.014251730784279671,-0.21433942823163535,-39.27414014883227,-287.2309569721039,0.01288740242120183,-0.19729277842021803,
  -39.438259398255525,-302.92286778557286,0.010593037750441023,-0.1818780165657937,-39.58943616545382,-318.6775901946797,0.008378973144853608,-0.1565371218065303,-39.85929084448825,-350.35677050913574,
  0.006851161526608891,-0.13649276043855635,-40.09295499202336,-382.23614429322754,0.005664009912174691,-0.12010326317491435,-40.29756651716601,-414.28987284372425,0.0047596828494130715,-0.10655369576268947,
  -40.47830441559222,-446.4969406374878,0.004052674412552565,-0.09516747917251202,-40.639158339498834,-478.8399730620576,0.0034945094504017136,-0.0854725835059901,-40.78320203201602,-511.30439002885726,
  0.003053968967146449,-0.07711294217324828,-40.91284890614476,-543.8777869089324,0.002684662635651774,-0.06980717134360194,-41.030004067310074,-576.5494729676333,0.0023932127670595366,-0.06338486313353768,
  -41.13621235895637,-609.3101212165715,0.0015596372184436913,-0.051934672112731325,-41.32012562193839,-675.0662553138166,0.0028810043990807857,-0.04447267612134229,-41.4738774554964,-741.0899553833864,
  -0.0031306627025035646,-0.030688673647634238,-41.59374586336524,-807.3345221460247,0.008388011487938994,-0.045667152142642144,-41.715519238871714,-873.7595832397402,-0.19930101332082575,0.034596780211041595,
  -41.750829617464845,-1007.0090210893836,2.433625142411732,-0.44217542838109075,-42.07583577945931,-1040.380489140858,48.971722589839835,2.4687100074225015,-41.26784911401392,-1057.0723247039582,
  -43.20498994073569,17.11261218125022,-39.31606312133157,-1061.1127104170844,-0.7968980419427997,4.193122878976662,-37.192394716630716,-1064.9043421337747,-2.14365943913158,3.716533682126714,
  -35.61559037889096,-1072.1583871741286,-0.6441709722819802,2.4345065260242746,-34.389369391051865,-1079.127703293355,-0.5868080515311245,2.049256581670718,-33.49552310796814,-1085.8916396158936,
  -0.3875586308209203,1.6983128432440453,-32.74843836673607,-1092.4922418829885,-0.25912851530469183,1.4665313017247528,-32.11752096374823,-1098.9562798141626,-0.16048282422165924,1.1565848732233068,
  -31.0716750585307,-1111.5449485499355,-0.11489892294922227,0.9646296260563116,-30.22593916648484,-1123.7596531036963,-0.0846634234717707,0.8271977777516207,-29.511531100602596,-1135.6647846865267,
  -0.06545837616447249,0.7259309384038725,-28.8922930647199,-1147.3050096666695,-0.05191907988992061,0.6476354645004063,-28.344647172501556,-1158.7132228313324,-0.04212521232173599,0.5855344897619047,
  -27.852977852088003,-1169.914675687671,-0.034826883286433616,0.5351480662776548,-27.4061576641465,-1180.9293493299783,-0.028909545824213956,0.4934912533337983,-26.996035447435045,-1191.7734212375267,
  -0.02526236103962193,0.4589122319270726,-26.61630873357926,-1202.4602228522433,-0.019520877469643566,0.428695647810353,-26.262416261973208,-1213.0008917346343,-0.014146475223449013,0.3819973811543961,
  -25.615963777078623,-1233.6800405563704,-0.010428608822282597,0.34815587616806454,-25.033734288621403,-1253.870671945005,-0.007361956267790338,0.3232083318585971,-24.498383613283366,-1273.6166626304837,
  -0.004745205058638106,0.305596900331639,-23.996969773098773,-1292.9500690089515,-0.002320590723947715,0.29424531782669927,-23.51865124978753,-1311.893515947133,6.998293164097783e-05,0.28869395034361506,
  -23.053811261052765,-1330.4615368615189,0.002564141393466003,0.2888613650312088,-22.59326447521829,-1348.661208778152,0.0052742266236749874,0.2949953597105903,-22.12769289997762,-1366.4922662715633,
  0.008288885683037095,0.30761247908236716,-21.647169050769094,-1383.946799155879,0.011655771958827514,0.327441331269424,-21.14077254916363,-1401.0086076005714,0.015347815312938098,0.3553245218616905,
  -20.596330119553233,-1417.65229633277,0.019208550271511072,0.39203989867733363,-20.00037632506185,-1433.8422409694233,0.02288213382428557,0.4379910094328972,-19.338503675469234,-1449.5316644236761,
  0.02575399262336515,0.49273014647453195,-18.596339894008523,-1464.6622247985301,0.02699035030290703,0.5543394064502524,-17.76139905923897,-1479.164715930211,0.02674548419601983,0.5866228572721445,
  -17.306493278504565,-1486.1564189985259,0.02610752961738128,0.6186134210869795,-16.82596121569326,-1492.9616330814902,0.02458558314876305,0.6498409205089875,-16.320223882446932,-1499.5702123602714,
  0.022238045617284232,0.6792480032479301,-15.790311322013478,-1505.9722847297862,0.019039954330748825,0.7058471708764904,-15.238068867016892,-1512.1585531470448,0.015065685132781413,0.72862106682039,
  -14.666141193020682,-1518.120614869245,0.010444388317418436,0.7466412962588302,-14.077948753706217,-1523.8512786050258,0.005364981759812201,0.7591339424388913,-13.477590720535563,-1529.344856206654,
  5.626542738983064e-05,0.765551055327737,-12.869693298038676,-1534.5974049326608,-0.00523541868359845,0.7656183550158747,-12.259210516797047,-1539.6068991294126,-0.010272151508455337,0.7593562139281482,
  -11.651197641224528,-1544.3733163208788,-0.014847987524013714,0.747069582063925,-11.05058022850793,-1548.8986312654881,-0.018805983820875314,0.7293097430971838,-10.461942452372023,-1553.1867210301098,
  -0.02204823059374292,0.7068157018185445,-9.889354043864518,-1557.2431928266783,-0.024531787744151757,0.6804435739989891,-9.336248753696605,-1561.0751528025348,-0.026278125446918002,0.6511008365271409,
  -8.805357181808215,-1564.6909373402355,-0.02730153682087663,0.6196692855825904,-8.298696538496241,-1568.0998286265044,-0.027770088184381175,0.5870136211904199,-7.817587699704714,-1571.311773848647,
  -0.02682844206244422,0.5205814136674581,-6.934383407871695,-1577.1863978333915,-0.02467025269423413,0.4564018324296692,-6.155329901088271,-1582.3985123476052,-0.022015597233066158,0.3973851186279088,
  -5.474514011026212,-1587.0291187958235,-0.019242302436464593,0.3447189292223032,-4.882754875764231,-1591.153017984893,-0.016602655309313468,0.2986870758053675,-4.369698273714283,-1594.8371262269575,
  -0.01420543131965738,0.25896984352229346,-3.925018612809365,-1598.1400507581184,-0.012130710582860318,0.22498730248335558,-3.5391076842087386,-1601.1124235593193,-0.010244457455243031,0.19596795340923867,
  -3.2034349184656947,-1603.7976243131725,-0.009023080299305116,0.17146093999580522,-2.910444461316857,-1606.2326529675643,-0.006977522343578057,0.14987573151681596,-2.6542082752818588,-1608.4490126154064,
  -0.005051171062352146,0.11649217081315302,-2.229400891462962,-1612.3290864112505,-0.0037917873941223728,0.09232512877711892,-1.8963760413998256,-1615.608766235762,-0.002865646205514306,0.0741835366167481,
  -1.6308256131747267,-1618.413692025501,-0.0022096286505687637,0.060473014550837936,-1.416073397479023,-1620.8374993681507,-0.001707876074498925,0.04990117134395709,-1.2400470491804012,-1622.9510275607652,
  -0.0014083409577640446,0.041729934936546156,-1.0939124353813559,-1624.8086799025677,-0.0009903018095198516,0.03499180734054603,-0.9715554909684919,-1626.4528426366505,-0.0006461640125836153,0.02551572143349606,
  -0.7785589266301509,-1629.2278825654937,-0.00045485040217716123,0.019332651146817235,-0.6355092599268627,-1631.472574814074,-0.0003218345015424164,0.01498023914024238,-0.5260638723511945,-1633.3176884022605,
  -0.00024912556479836443,0.0119006412286247,-0.440323838628202,-1634.853675668811,-0.00016019485748280127,0.009516786901612763,-0.372010190230245,-1636.1451556128413,-9.450151686048652e-05,0.006451013989189905,
  -0.2701474708495888,-1638.1726066976096,-6.24634070532337e-05,0.004642465355817846,-0.19937930551465466,-1639.6579564272442,-4.1724745556267604e-05,0.003447054814115491,-0.1477741703661629,-1640.7571393392832,
  -3.099778109578605e-05,0.0026485360806544323,-0.10888882422367227,-1641.570383108307,-1.8922451071226797e-05,0.0020553075643215844,-0.07888179266714404,-1642.1652781348098,-1.0407470208263524e-05,0.0013310403956699026,
  -0.03567701896877518,-1642.876428999755,-7.0151441709385675e-06,0.0009326887787365337,-0.006795194699637968,-1643.1365629417298,-3.6965334785274006e-06,0.0006641802970792673,0.013578484515157922,-1643.0860059641059,
  -1.7553825060999973e-06,0.0003812066139933353,0.040253655202721984,-1642.3684795110685,-1.0198267500457514e-06,0.00024683016214699296,0.05627928937143526,-1641.1222799119394,-6.51456320227278e-07,0.00016876130838269098,
  0.06688394999541464,-1639.5424277680972,-3.360576856798921e-07,0.00011889161414749654,0.07422399866638607,-1637.7366879361261,-1.653971536144579e-07,6.744044693985803e-05,0.08373328079231387,-1633.6837531836497,
  -7.256835212030929e-08,4.2117780716443815e-05,0.08932448227380227,-1629.2568407564909,-2.479725332251944e-08,1.989703363624556e-05,0.09565421814668884,-1619.778043861927};
maptype *map_1[2] = {a0_1};
treal *t_1[2] = {t0_1};
treal *c_1[1] = {c0_1};
splinecoeffs<maptype> sc[2] = {
	{x0_0, xe_0, hi_0, k_0, n_0, nmap_0, map_0, t_0, c_0, splinedata<unsigned char>::splev_pp<4>},
	{x0_1, xe_1, hi_1, k_1, n_1, nmap_1, map_1, t_1, c_1, splinedata<unsigned char>::splev_pp<4>},
};
splinedata<maptype> sd = {
	sc,
	2, /* number of calculated values */
	2, /* number of input values */
	2, /* number of output values */
	0, /* number of state values */
	"nonlin_1",
};
}; /* ! namespace nonlin_1 */
} // namespace AmpData

// nonlin_1: 18904 bytes
// data size sum: 18920 bytes
#ifndef NO_INTPP_INCLUDES
#include "intpp.h"
#endif
namespace AmpData {
namespace nonlin_2 {
typedef unsigned char maptype;
real x0_0[1] = {-4.75089365365};
real xe_0[1] = {11.2145908347};
real hi_0[1] = {28.1858029632};
int k_0[1] = {4};
int nmap_0[1] = {451};
int n_0[1] = {61};
treal t0_0[65] = {
  -22.880588261487706,-22.880588261487706,-22.880588261487706,-22.880588261487706,-4.7154147992349715,-4.431583963887272,-4.1477531285395735,-3.863922293191875,-3.7220068755180256,-3.580091457844176,
  -3.438176040170326,-3.2962606224964768,-3.1543452048226275,-3.012429787148778,-2.870514369474929,-2.728598951801079,-2.5866835341272294,-2.44476811645338,-2.302852698779531,-2.160937281105681,
  -2.0190218634318313,-1.877106445757982,-1.7351910280841325,-1.593275610410283,-1.4513601927364337,-1.3094447750625842,-1.0256139397148851,-0.7417831043671862,-0.4579522690194872,-0.17412143367178823,
  -0.13864257925332585,-0.10316372483486348,-0.032206015997938736,0.10970940167591076,0.2516248193497602,0.39354023702360974,0.6773710723713087,0.9612019077190077,1.2450327430667065,1.5288635784144056,
  1.8126944137621046,2.0965252491098036,2.3803560844575027,2.6641869198052017,2.9480177551529003,3.2318485905005994,3.5156794258482984,3.799510261195997,4.0833410965436965,4.367171931891395,
  4.651002767239094,4.934833602586793,5.218664437934493,5.502495273282191,6.070156943977589,6.637818614672987,7.2054802853683855,7.7731419560637836,8.90846529745458,10.043788638845376,
  11.179111980236172,13.449758663017763,13.449758663017763,13.449758663017763,13.449758663017763};
maptype a0_0[450] = {
  3,4,4,4,4,4,4,4,4,5,
  5,5,5,5,5,5,5,6,6,6,
  6,6,6,6,6,7,7,7,7,8,
  8,8,8,9,9,9,9,10,10,10,
  10,11,11,11,11,12,12,12,12,13,
  13,13,13,14,14,14,14,15,15,15,
  15,16,16,16,16,17,17,17,17,18,
  18,18,18,19,19,19,19,20,20,20,
  20,21,21,21,21,22,22,22,22,23,
  23,23,23,24,24,24,24,25,25,25,
  25,25,25,25,25,26,26,26,26,26,
  26,26,26,27,27,27,27,27,27,27,
  27,28,28,28,28,28,28,28,28,29,
  30,31,31,32,32,32,32,33,33,33,
  33,34,34,34,34,35,35,35,35,35,
  35,35,35,36,36,36,36,36,36,36,
  36,37,37,37,37,37,37,37,37,38,
  38,38,38,38,38,38,38,39,39,39,
  39,39,39,39,39,40,40,40,40,40,
  40,40,40,41,41,41,41,41,41,41,
  41,42,42,42,42,42,42,42,42,43,
  43,43,43,43,43,43,43,44,44,44,
  44,44,44,44,44,45,45,45,45,45,
  45,45,45,46,46,46,46,46,46,46,
  46,47,47,47,47,47,47,47,47,48,
  48,48,48,48,48,48,48,49,49,49,
  49,49,49,49,49,50,50,50,50,50,
  50,50,50,51,51,51,51,51,51,51,
  51,52,52,52,52,52,52,52,52,53,
  53,53,53,53,53,53,53,53,53,53,
  53,53,53,53,53,54,54,54,54,54,
  54,54,54,54,54,54,54,54,54,54,
  54,55,55,55,55,55,55,55,55,55,
  55,55,55,55,55,55,55,56,56,56,
  56,56,56,56,56,56,56,56,56,56,
  56,56,56,57,57,57,57,57,57,57,
  57,57,57,57,57,57,57,57,57,57,
  57,57,57,57,57,57,57,57,57,57,
  57,57,57,57,57,58,58,58,58,58,
  58,58,58,58,58,58,58,58,58,58,
  58,58,58,58,58,58,58,58,58,58,
  58,58,58,58,58,58,58,59,59,59,
  59,59,59,59,59,59,59,59,59,59,
  59,59,59,59,59,59,59,59,59,59,
  59,59,59,59,59,59,59,59,59,60,
};
treal c0_0[232] = {
  -0.000195288986670558,0.003874285259094822,-0.017419511850232897,0.0036391123722735786,-3.911625052543035,-0.006768089695319922,-0.06998597140009832,-0.20494510361710774,2.588056268956672,-3.3374875083861553,
  -1.019188831419784,-0.3147953728737259,-5.798723652671069,-1.1337769901516943,-2.2882715691002904,-0.8137634627107487,0.9229005861632151,-6.071346725015958,-4.333307851959838,-1.687172615767033,
  -6.274847934791513,-5.678425258545579,-6.000781650579467,-2.421774835240409,-2.106813393550019,-8.349918255063072,-7.991619879585479,-3.4056762837898646,-3.3440645061788614,-9.246886163182607,
  -10.488877728325859,-4.713999232062049,-1.8868443463090936,-10.67060909655061,-13.315477387127812,-6.398322771457918,-1.1830725989690192,-11.473926007026598,-16.45812833554519,-8.508293152161304,
  -0.21480164803790938,-11.977614733090123,-19.786263534774147,-11.078421443503954,0.5105725124286403,-12.069065729885116,-23.19885823634687,-14.12824022816317,1.072007089991766,-11.851691395822824,
  -26.59358247491643,-17.66212739109876,1.433794036344243,-11.395288394046295,-29.89268732145125,-21.671795668253864,1.6406125018892979,-10.784855955468093,-33.040391770878855,-26.13943178747002,
  1.7298676376958875,-10.086371330128417,-36.00234070848012,-31.04089047444895,1.7406621878272723,-9.349886665156154,-38.76064537989763,-36.34837280486629,1.7023663565404792,-8.6088062609124,
  -41.30926078737706,-42.03243745141675,1.6376973693433978,-7.884030163345347,-43.649848557152076,-48.06337402537929,1.5564891502040463,-7.186786644764148,-45.788629819161,-54.41206394524746,
  1.4834493612964401,-6.524117221196081,-47.73441846798475,-61.05046953394228,1.3631880314284788,-5.8925442140769135,-49.4965341616863,-67.95187513913834,1.3470273913985873,-5.312172017532418,
  -51.08665614561209,-75.0909759854829,0.8760266374453151,-4.165188288321739,-53.77662323811381,-89.9880922351998,1.8727369637506195,-3.41925817144292,-55.9293230124387,-105.56707276661317,
  -2.5246570414261105,-1.8246366810193646,-57.41770206888857,-121.67417360920557,1327.3238267799318,-3.9743632321226343,-59.0636370584169,-138.17580786122895,-1031.7622219061657,137.3014232173221,
  -54.333345707160404,-140.21704384450825,-33.59275323989736,27.484198220887777,-48.48694063389831,-142.01797810730113,-25.732235422049598,20.333203810605884,-45.0939273432094,-145.33211922671052,
  -5.3166326970335565,9.377800997799904,-40.87747768631475,-151.39567954363125,-4.471287869217019,7.114264548346018,-38.53699931602895,-157.02315094821859,-1.8985980494629013,5.210630491846168,
  -36.78790668861372,-162.3616438361954,-0.8927973101793615,3.593988480740467,-34.28888433070625,-172.4268302225494,-0.49416800307010306,2.833778261707306,-32.464485926777144,-181.8899555617798,
  -0.23820800727001548,2.4129979103668315,-30.97528906297494,-190.88738805305897,-0.051887750840627,2.2101655772969537,-29.663092708322345,-199.49018596899734,0.12020831289412044,2.1659835463007284,
  -28.421006646965516,-207.73262197222857,0.29540132328420354,2.268340023894156,-27.16240888383511,-215.6221399083563,0.47110162543185874,2.5198720369458694,-25.80336665478496,-223.14217730044857,
  0.609185387110233,2.9210115405858192,-24.259076123944563,-230.2521957397629,0.6298654487691794,3.439728332501145,-22.453702012336876,-236.88842379221887,0.44879420002418713,3.9760540419435735,
  -20.348874306241484,-242.96997034942552,0.07485206532557996,4.358198940019776,-17.983356320371776,-248.41503579771214,-0.34178558759495653,4.421934912706355,-15.491283594487912,-253.1664590637666,
  -0.6264525040894139,4.130907046195713,-13.063723316695883,-257.21494726485275,-0.7208488086061818,3.597487433571645,-10.870166655606972,-260.604373214559,-0.680120091453524,2.9836900750533872,
  -9.002225545762442,-263.41633080728263,-0.5699216517440676,2.4045729139713647,-7.472870360514456,-265.7466253164484,-0.47995754073240837,1.9192888984795866,-6.245625050358484,-267.6869755804271,
  -0.32092204477696457,1.510608649327067,-5.272114364207498,-269.3160331705012,-0.18618767911248998,0.9640832170238418,-3.867326644898429,-271.8807363082429,-0.11467972561685451,0.6470083900601576,
  -2.9527716915777917,-273.79946149622714,-0.07692796338424553,0.45171053614449724,-2.3290710703038036,-275.2881225501753,-0.0411070967008294,0.3207033674908116,-1.8906013032978302,-276.4787597315005,
  -0.019208247652961807,0.18069382834703096,-1.3213533635552355,-278.2719855225347,-0.011203512302054344,0.11527111262416341,-0.9853374578372892,-279.5673509539689,-0.006389022384987176,0.07711228555791973,
  -0.7669200953850905,-280.5538428762878};
maptype *map_0[1] = {a0_0};
treal *t_0[1] = {t0_0};
treal *c_0[1] = {c0_0};
real x0_1[2] = {-4.78637250807};
real xe_1[2] = {12.3853930305};
real hi_1[2] = {14.0929014816};
int k_1[2] = {4};
int nmap_1[2] = {243};
int n_1[2] = {25};
treal t0_1[29] = {
  -22.880588261487706,-22.880588261487706,-22.880588261487706,-22.880588261487706,-4.7154147992349715,-2.44476811645338,-0.17412143367178823,-0.10316372483486348,-0.032206015997938736,0.10970940167591076,
  0.39354023702360974,0.6773710723713087,0.9612019077190077,1.5288635784144056,2.0965252491098036,2.6641869198052017,3.2318485905005994,4.367171931891395,5.502495273282191,6.637818614672987,
  7.7731419560637836,8.90846529745458,10.043788638845376,11.179111980236172,12.314435321626966,13.449758663017763,13.449758663017763,13.449758663017763,13.449758663017763};
maptype a0_1[242] = {
  3,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,4,4,4,4,4,4,4,
  4,4,4,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,6,7,8,8,9,
  9,9,9,10,10,10,10,11,11,11,
  11,12,12,12,12,12,12,12,12,13,
  13,13,13,13,13,13,13,14,14,14,
  14,14,14,14,14,15,15,15,15,15,
  15,15,15,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,16,17,
  17,17,17,17,17,17,17,17,17,17,
  17,17,17,17,17,18,18,18,18,18,
  18,18,18,18,18,18,18,18,18,18,
  18,19,19,19,19,19,19,19,19,19,
  19,19,19,19,19,19,19,20,20,20,
  20,20,20,20,20,20,20,20,20,20,
  20,20,20,21,21,21,21,21,21,21,
  21,21,21,21,21,21,21,21,21,22,
  22,22,22,22,22,22,22,22,22,22,
  22,22,22,22,22,23,23,23,23,23,
  23,23,23,23,23,23,23,23,23,23,
  23,24};
treal c0_1[88] = {
  -6.36713549620182e-07,1.5160737693134769e-05,-8.260878166471392e-05,3.0323347755798663e-05,-0.00024411341807896697,-1.953729853071704e-05,-0.00016210976844749798,-0.0002841152100597304,4.079265842363113e-05,-0.0016824232674811633,
  -0.004026660881887453,-0.0036107963114564135,-6.657477252583585,-0.0014045461238867815,-0.011036077690245387,-0.020950656511001066,6.877363335753862,-1.418602543555714,-0.11179652730609937,-0.024119352142066425,
  -0.543466789153841,0.04540329187677823,-0.20923559998181623,-0.03673774827884677,0.15884805273658337,-0.18597565724712148,-0.22918498592674946,-0.06707040710458527,-0.000158610240520944,-0.05071773074238208,
  -0.29636586796108727,-0.14347023785330212,0.020447788838923116,-0.05085278617356736,-0.3251947126240388,-0.23167745391366554,0.0063615717881664625,-0.03344164721207264,-0.349120072067046,-0.32760689162074325,
  0.0035234959952906452,-0.02260798580351479,-0.3809373003865383,-0.5354015249270402,0.0020889306817305545,-0.016607524933389094,-0.4031984427286225,-0.7582856924455624,0.0015310232367928712,-0.013050107291114964,
  -0.42003394378605413,-0.9921354853038521,0.0008540032791263473,-0.010442797665701014,-0.43336996546332845,-1.234497859565131,0.00044321938261310733,-0.007534088096451751,-0.45377954347461635,-1.7387234999051162,
  0.00032202398681367554,-0.006024496165139314,-0.4691729206630146,-2.26297253804347,0.000229710864700529,-0.004927692118987451,-0.4816071956612905,-2.8029295899308724,0.0001731016159887567,-0.00414530379959073,
  -0.49190797970399575,-3.355724918582023,0.00013330936859535112,-0.003555724884397225,-0.5006511373216473,-3.9192893424003685,0.00010574464725677569,-0.003101677171020111,-0.5082094412681857,-4.49207836542927,
  8.520738916512169e-05,-0.00274151407224685,-0.514843352674877,-5.072903596231896,7.168736855737352e-05,-0.002451300258912455,-0.5207388759925508,-5.66082627992181};
maptype *map_1[2] = {a0_1};
treal *t_1[2] = {t0_1};
treal *c_1[1] = {c0_1};
splinecoeffs<maptype> sc[2] = {
	{x0_0, xe_0, hi_0, k_0, n_0, nmap_0, map_0, t_0, c_0, splinedata<unsigned char>::splev_pp<4>},
	{x0_1, xe_1, hi_1, k_1, n_1, nmap_1, map_1, t_1, c_1, splinedata<unsigned char>::splev_pp<4>},
};
splinedata<maptype> sd = {
	sc,
	2, /* number of calculated values */
	2, /* number of input values */
	2, /* number of output values */
	0, /* number of state values */
	"nonlin_2",
};
}; /* ! namespace nonlin_2 */
} // namespace AmpData

// nonlin_2: 2416 bytes
// data size sum: 2432 bytes


static const creal __attribute__((aligned(16))) mo_data[1*16] = { -0.0102546428492310,-0.0926671566150658,0.00748481645910352,-0.0140923636667521,0.000146229606693146,0.0922823518597244,0.0130923463909865,0,0,0,-6.05681847115581e-5,0.000595161081745525,0,0,-21.3106335449389,0 };
static const Map<const Matrix<creal, 1, 16>, Aligned> Mo(mo_data);
static const creal __attribute__((aligned(16))) moc_data[1*1] = { 0.991243408620221 };
static const Map<const Matrix<creal, 1, 1>, Aligned> Moc(moc_data);
static const creal __attribute__((aligned(16))) mp_data[8*8] = { -1.60878766662268,0.201098738795714,18.3957218365136,-3.91398582031719,-0.0123843269016959,-1.04506003104504,-24.3073622142207,1.77200291622517,-8.88487051956217,1.11060977505219,166.234892997965,-35.3691437462083,-0.000977781651230822,-5.92128424260976,-174.653665466717,3.68076212702878,1.04505825382188,-0.130632444077542,-13.4269526764931,2.85680017523035,-0.0102398010071506,0.397763818919637,17.2035996438699,-1.21549433886385,-1.84036955719718,0.230046482676040,25.2801788968119,-5.37876475830232,0.0273903892012099,-0.172407562001718,-32.6789072654108,2.68046580539187,0.0674042024831012,-0.00842551253086225,-0.262319945235929,0.0558128269821166,0.00219678736800143,-0.0979397222211214,0.718340583633752,0.0276587628679819,4.46885219353691,-0.558606977146733,-165.544595019239,35.2222717021849,0.00120351074120639,-9.02952049284388,173.869107367223,-13.5602699048151,1.81354621649064,-0.226693368766333,-23.4862546943112,4.99707877518569,-0.00778901763100761,-1.57796122950664,32.8564145535054,-2.48722216637614,0,0,0,0,1.00000000000000,0,0,0 };
static const Map<const Matrix<creal, 8, 8>, Aligned> Mp(mp_data);
static const creal __attribute__((aligned(16))) mx_data[7*16] = { 1.05970174364689,-0.108282638352014,-0.00216390308520815,0.0114004550526571,-0.00614983937551424,0.00735634823212811,-0.0373376868458086,0.713522975253478,0.136120723019377,-0.102112632757899,0.113894820137347,-0.0489364044915694,0.206120132777242,-0.416089362653296,-0.0433301281262144,0.0664125136110350,1.00099915170040,-0.00502767212096184,0.00451528271064754,-0.0174164531743976,0.0283669734091872,0.0839522390879246,-0.105966821882551,-0.00316747488536151,1.00956830159365,-0.00857286923940689,0.0523569880167113,-0.0541206842484787,-0.00113061827397934,-0.00185742158800730,0.000224251694312446,-0.000856211240495214,1.00005450259739,-0.00387940275141992,0.000605868723121882,-0.545624721365257,0.306950247693952,0.0301073642157915,-0.0692961838570507,0.0696324581496592,0.257432975682703,0.538969989890965,-0.0830857401055198,0.0447852476649801,0.0103831526772016,-0.0271123453953327,0.00934503192093945,-0.102249000232238,1.01250767475771,0,0,0,0,0,0,0,-0.00211533957944378,0.00141132471136906,0.000931758428019313,-0.00121834618938154,-0.000342312419688939,0.000825499399629477,-0.00246640352687999,-0.00221019875914748,0.00147461751870934,0.000973541761263861,-0.00127298054725860,-0.000357662778471990,0.000862519622708971,-0.00257700485411471,0.000307278441346321,-0.000309004853953255,-2.23695668047990e-5,2.14873885323795e-5,-3.73067441519218e-5,0.000244734225363349,-0.000321720947551207,7.14531190632612e-5,-7.18548354480381e-5,-5.20173748404662e-6,4.99656752844864e-6,-8.67512148539013e-6,5.69095647660407e-5,-7.48114618591209e-5,-0.000185944022067206,-0.0328978757987105,-0.00205975139324839,0.00928258649842950,-0.000657578027217151,-0.0327275668944848,0.00532525400921149,-0.00753019147704296,0.000217644735509446,0.00119267447325060,0.00834739377311968,-0.00139172521333547,0.000380292343123624,0.00128078974223338,-1360.53531039429,169.083565190700,76.3715942748210,-236.747433234904,188.837967496056,-44.3875870949356,1237.07312474557,8676.03975995143,-3217.70398451414,-3777.02751206018,5337.82542445813,1498.14652753079,-3011.78616932036,10648.3974067810 };
static const Map<const Matrix<creal, 7, 16>, Aligned> Mx(mx_data);
static const creal __attribute__((aligned(16))) mxc_data[7*1] = { 0.841296047660765,-6.14125311669919,-0.333988273569845,-0.217191975968813,0.0159661555945044,-6.13970274163824,-0.147713788505921 };
static const Map<const Matrix<creal, 7, 1>, Aligned> Mxc(mxc_data);


static Matrix<creal, 0, 1> last_pot;

struct nonlin_param {
    Matrix<creal, 8, 1> *p;
    Matrix<creal, 8, 1> *i;
    Map<Matrix<creal, 8, 1> >*v;
    int *info;
    int *nfev;
    creal *fnorm;
    Array<creal, 8, 1> *p_val;
    inline nonlin_param(Matrix<creal, 8, 1> *p_, Matrix<creal, 8, 1> *i_, Map<Matrix<creal, 8, 1> >*v_, int *info_, int *nfev_, creal *fnorm_, Array<creal, 8, 1> *p_val_): p(p_), i(i_), v(v_), info(info_), nfev(nfev_), fnorm(fnorm_), p_val(p_val_) {}
};



namespace nonlin_0 {
static inline int nonlin(nonlin_param& par) {
    real t[AmpData::nonlin_0::sd.m];
    real m[2+0];
    Map<Matrix<real, 2+0, 1> >mp(m);
    mp << last_pot.cast<real>(), (*par.p).head<2>().cast<real>();
    for (int j = 0; j < AmpData::nonlin_0::sd.m; j++) {
        splinecoeffs<AmpData::nonlin_0::maptype> *pc = &AmpData::nonlin_0::sd.sc[j];
        check(&AmpData::nonlin_0::sd, m, (*pc->eval)(pc, m, &t[j]));
    }
    (*par.i).head<2>() = Map<Matrix<real, 2, 1> >(t).cast<creal>();
    return 0;
}




} // end nonlin_0

namespace nonlin_1 {
static inline int nonlin(nonlin_param& par) {
    real t[AmpData::nonlin_1::sd.m];
    real m[2+0];
    Map<Matrix<real, 2+0, 1> >mp(m);
    mp << last_pot.cast<real>(), (*par.p).segment<2>(2).cast<real>();
    for (int j = 0; j < AmpData::nonlin_1::sd.m; j++) {
        splinecoeffs<AmpData::nonlin_1::maptype> *pc = &AmpData::nonlin_1::sd.sc[j];
        check(&AmpData::nonlin_1::sd, m, (*pc->eval)(pc, m, &t[j]));
    }
    (*par.i).segment<2>(2) = Map<Matrix<real, 2, 1> >(t).cast<creal>();
    return 0;
}




} // end nonlin_1

namespace nonlin_2 {
static inline int nonlin(nonlin_param& par) {
    real t[AmpData::nonlin_2::sd.m];
    real m[2+0];
    Map<Matrix<real, 2+0, 1> >mp(m);
    mp << last_pot.cast<real>(), (*par.p).segment<2>(4).cast<real>();
    for (int j = 0; j < AmpData::nonlin_2::sd.m; j++) {
        splinecoeffs<AmpData::nonlin_2::maptype> *pc = &AmpData::nonlin_2::sd.sc[j];
        check(&AmpData::nonlin_2::sd, m, (*pc->eval)(pc, m, &t[j]));
    }
    (*par.i).segment<2>(4) = Map<Matrix<real, 2, 1> >(t).cast<creal>();
    return 0;
}




} // end nonlin_2

namespace nonlin {
static const creal __attribute__((aligned(16))) kl_data[2*8] = { -0.0219270321823620,0.999759573727441,0.999759573727441,0.0219270321823619,1.00000000000000,0,0,0,0,1.00000000000000,0,0,551772.224409347,-13096.8526917654,-13096.8526917654,777788.180707371 };
static const Map<const Matrix<creal, 2, 8>, Aligned> Kl(kl_data);
static const creal __attribute__((aligned(16))) ku_data[6*2] = { 13096.8531048342,98362.8920522104,-431770.787790270,-8133.82959730492,0,0,-695224.597054545,-13096.8526917654,0,0,-7.46011600940896,51016.6019816278 };
static const Map<const Matrix<creal, 6, 2>, Aligned> Ku(ku_data);
static const creal __attribute__((aligned(16))) mpc_data[8*1] = { 0,0,0,0,0,0,347.381890451386,146.019756212607 };
static const Map<const Matrix<creal, 8, 1>, Aligned> Mpc(mpc_data);
static const creal __attribute__((aligned(16))) sam0_data[3*1] = { 0.984867796815516,0.990325823322304,0.572071777232610 };
static const Map<const Array<creal, 3, 1>, Aligned> Sam0(sam0_data);
static const creal __attribute__((aligned(16))) sam1_data[3*1] = { 0.529599326055711,0.294766829526201,-0.300692171196462 };
static const Map<const Array<creal, 3, 1>, Aligned> Sam1(sam1_data);
static const creal __attribute__((aligned(16))) sam2_data[3*1] = { 1.01047167427495,1.00954543304385,1.54972907825715 };
static const Map<const Array<creal, 3, 1>, Aligned> Sam2(sam2_data);
static const creal __attribute__((aligned(16))) spm0_data[3*1] = { 1.14429961087212e-7,3.70660566459397e-8,2.10374116872319e-7 };
static const Map<const Array<creal, 3, 1>, Aligned> Spm0(spm0_data);
static const creal __attribute__((aligned(16))) spm1_data[3*1] = { 0.000487812975465725,0.000184802678889708,-4.75770783104045e-6 };
static const Map<const Array<creal, 3, 1>, Aligned> Spm1(spm1_data);
static const creal __attribute__((aligned(16))) spm2_data[3*1] = { 9.83498403815797e-6,6.65101858921353e-6,1.00009613179018e-5 };
static const Map<const Array<creal, 3, 1>, Aligned> Spm2(spm2_data);
static const creal __attribute__((aligned(16))) ssm0_data[3*1] = { 0.00264912280520554,0.00263637203310291,0.00300240315205226 };
static const Map<const Array<creal, 3, 1>, Aligned> Ssm0(ssm0_data);
static const creal __attribute__((aligned(16))) ssm1_data[3*1] = { -0.138762806132000,-0.0809751016083964,0.00281682007847420 };
static const Map<const Array<creal, 3, 1>, Aligned> Ssm1(ssm1_data);
static const creal __attribute__((aligned(16))) ssm2_data[3*1] = { -0.00275908822697312,-0.00262552318516037,-0.00534179693076565 };
static const Map<const Array<creal, 3, 1>, Aligned> Ssm2(ssm2_data);



typedef int root_fcn(void*p, const creal *v, creal *fvec, int iflag);
static int fcn(void *p, const creal *v, creal *fvec, int iflag) {
    nonlin_param& par = *static_cast<nonlin_param *>(p);
    const Map<const Matrix<creal, 2, 1> > Mv(v);
    Array<creal, 6, 1> pt;
    pt = (*par.p).head<6>() + Ku * Mv;
    Array<creal, 3, 1> PP1;
    PP1 << pt(1), pt(3), pt(5);
    Array<creal, 3, 1> PP0;
    PP0 << pt(0), pt(2), pt(4);
    pt.head<3>() = (Spm1 * PP1 + Ssm1) * PP1 + Sam1 + ((Spm2 * PP1 + Ssm2) * PP1 + Sam2) * PP0;
    Array<creal, 6, 1> res;
    splinedata<AmpData::nonlin_0::maptype>::splev_pp<4>(&AmpData::nonlin_0::sd.sc[0], &pt(0), &res(0));
    splinedata<AmpData::nonlin_0::maptype>::splev_pp<4>(&AmpData::nonlin_0::sd.sc[1], &pt(0), &res(3));
    splinedata<AmpData::nonlin_1::maptype>::splev_pp<4>(&AmpData::nonlin_1::sd.sc[0], &pt(1), &res(1));
    splinedata<AmpData::nonlin_1::maptype>::splev_pp<4>(&AmpData::nonlin_1::sd.sc[1], &pt(1), &res(4));
    splinedata<AmpData::nonlin_2::maptype>::splev_pp<4>(&AmpData::nonlin_2::sd.sc[0], &pt(2), &res(2));
    splinedata<AmpData::nonlin_2::maptype>::splev_pp<4>(&AmpData::nonlin_2::sd.sc[1], &pt(2), &res(5));
    pt.head<3>() = ((Spm0 * PP1 + Ssm0) * PP1 + Sam0) * res.head<3>();
    pt.tail<3>() = ((Spm0 * PP1 + Ssm0) * PP1 + Sam0) * res.tail<3>();
    (*par.i).head<6>() << pt(0), pt(3), pt(1), pt(4), pt(2), pt(5);
    (*par.i).segment<2>(6) = Mv;
    Map<Matrix<creal, 2, 1>, Aligned> Mfvec(fvec);
    Mfvec = (*par.p).segment<2>(6) + Kl * (*par.i).head<8>();
    
    return 0;
}



#if 0
#define real_EPSILON FLT_EPSILON
#define real_MIN FLT_MIN
#define real_MAX FLT_MAX
#else
#define real_EPSILON DBL_EPSILON
#define real_MIN DBL_MIN
#define real_MAX DBL_MAX
#endif

real inline dpmpar(int i)
{
    switch(i) {
    case 1:
	return real_EPSILON;
    case 2:
	return real_MIN;
    default:
	return real_MAX;
    }
}

template<int N>
real inline enorm(const real *fvec) {
    real s = 0;
    for (int i = 0; i < N; i++) {
	s += fvec[i] * fvec[i];
    }
    return sqrt(s);
}

real inline enorm(int n, const real *fvec) {
    real s = 0;
    for (int i = 0; i < n; i++) {
	s += fvec[i] * fvec[i];
    }
    return sqrt(s);
}

template<int N>
real enorm2(const real *fvec) {
    real s = 0;
    for (int i = 0; i < N; i++) {
	s += fvec[i] * fvec[i];
    }
    return s;
}

template<int N>
void qform(real *q, int	ldq, real *wa)
{
    /* System generated locals */
    int q_dim1, q_offset;

    /* Local variables */
    int i, j, k, l;
    real sum, temp;

    /* Parameter adjustments */
#pragma GCC diagnostic push 
#pragma GCC diagnostic ignored "-Warray-bounds"
    --wa;
    q_dim1 = ldq;
    q_offset = 1 + q_dim1 * 1;
    q -= q_offset;
#pragma GCC diagnostic pop

    /* Function Body */

/*     zero out upper triangle of q in the first min(m,n) columns. */

    if (N >= 2) {
        for (j = 2; j <= N; ++j) {
            for (i = 1; i <= j-1; ++i) {
                q[i + j * q_dim1] = 0.;
            }
        }
    }

/*     accumulate q from its factored form. */

    for (l = 1; l <= N; ++l) {
	k = N - l + 1;
	for (i = k; i <= N; ++i) {
	    wa[i] = q[i + k * q_dim1];
	    q[i + k * q_dim1] = 0.;
	}
	q[k + k * q_dim1] = 1.;
	if (wa[k] != 0.) {
            for (j = k; j <= N; ++j) {
                sum = 0.;
                for (i = k; i <= N; ++i) {
                    sum += q[i + j * q_dim1] * wa[i];
                }
                temp = sum / wa[k];
                for (i = k; i <= N; ++i) {
                    q[i + j * q_dim1] -= temp * wa[i];
                }
            }
        }
    }
} /* qform_ */

template<int N>
void r1updt(real *s, int ls, const real *u, real *v, real *w, int *sing)
{
    /* Initialized data */

#define p5 .5
#define p25 .25

    /* Local variables */
    int i, j, l, jj, nm1;
    real tan;
    int nmj;
    real cos, sin, tau, temp, giant, cotan;

    /* Parameter adjustments */
    --w;
    --u;
    --v;
    --s;
    (void)ls;

    /* Function Body */

/*     giant is the largest magnitude. */

    giant = dpmpar(3);

/*     initialize the diagonal element pointer. */

    jj = N * ((N << 1) - N + 1) / 2 - (N - N);

/*     move the nontrivial part of the last column of s into w. */

    l = jj;
    for (i = N; i <= N; ++i) {
	w[i] = s[l];
	++l;
    }

/*     rotate the vector v into a multiple of the n-th unit vector */
/*     in such a way that a spike is introduced into w. */

    nm1 = N - 1;
    if (nm1 >= 1) {
        for (nmj = 1; nmj <= nm1; ++nmj) {
            j = N - nmj;
            jj -= N - j + 1;
            w[j] = 0.;
            if (v[j] != 0.) {

/*        determine a givens rotation which eliminates the */
/*        j-th element of v. */

                if (fabs(v[N]) < fabs(v[j])) {
                    cotan = v[N] / v[j];
                    sin = p5 / sqrt(p25 + p25 * (cotan * cotan));
                    cos = sin * cotan;
                    tau = 1.;
                    if (fabs(cos) * giant > 1.) {
                        tau = 1. / cos;
                    }
                } else {
                    tan = v[j] / v[N];
                    cos = p5 / sqrt(p25 + p25 * (tan * tan));
                    sin = cos * tan;
                    tau = sin;
                }

/*        apply the transformation to v and store the information */
/*        necessary to recover the givens rotation. */

                v[N] = sin * v[j] + cos * v[N];
                v[j] = tau;

/*        apply the transformation to s and extend the spike in w. */

                l = jj;
                for (i = j; i <= N; ++i) {
                    temp = cos * s[l] - sin * w[i];
                    w[i] = sin * s[l] + cos * w[i];
                    s[l] = temp;
                    ++l;
                }
            }
        }
    }

/*     add the spike from the rank 1 update to w. */

    for (i = 1; i <= N; ++i) {
	w[i] += v[N] * u[i];
    }

/*     eliminate the spike. */

    *sing = false;
    if (nm1 >= 1) {
        for (j = 1; j <= nm1; ++j) {
            if (w[j] != 0.) {

/*        determine a givens rotation which eliminates the */
/*        j-th element of the spike. */

                if (fabs(s[jj]) < fabs(w[j])) {
                    cotan = s[jj] / w[j];
                    sin = p5 / sqrt(p25 + p25 * (cotan * cotan));
                    cos = sin * cotan;
                    tau = 1.;
                    if (fabs(cos) * giant > 1.) {
                        tau = 1. / cos;
                    }
                } else {
                    tan = w[j] / s[jj];
                    cos = p5 / sqrt(p25 + p25 * (tan * tan));
                    sin = cos * tan;
                    tau = sin;
                }

/*        apply the transformation to s and reduce the spike in w. */

                l = jj;
                for (i = j; i <= N; ++i) {
                    temp = cos * s[l] + sin * w[i];
                    w[i] = -sin * s[l] + cos * w[i];
                    s[l] = temp;
                    ++l;
                }

/*        store the information necessary to recover the */
/*        givens rotation. */

                w[j] = tau;
            }

/*        test for zero diagonal elements in the output s. */

            if (s[jj] == 0.) {
                *sing = true;
            }
            jj += N - j + 1;
        }
    }

/*     move w back into the last column of the output s. */

    l = jj;
    for (i = N; i <= N; ++i) {
	s[l] = w[i];
	++l;
    }
    if (s[jj] == 0.) {
	*sing = true;
    }

/*     last card of subroutine r1updt. */

} /* __minpack_func__(r1updt) */

template<int M, int N>
void r1mpyq(real *a, int lda, const real *v, const real *w)
{
    /* System generated locals */
    int a_dim1, a_offset;

    /* Local variables */
    int i, j, nm1, nmj;
    real cos, sin, temp;

    /* Parameter adjustments */
    --w;
    --v;
    a_dim1 = lda;
    a_offset = 1 + a_dim1 * 1;
    a -= a_offset;

    /* Function Body */

/*     apply the first set of givens rotations to a. */

    nm1 = N - 1;
    if (nm1 < 1) {
        return;
    }
    for (nmj = 1; nmj <= nm1; ++nmj) {
	j = N - nmj;
	if (fabs(v[j]) > 1.) {
	    cos = 1. / v[j];
	    sin = sqrt(1. - cos * cos);
	} else {
	    sin = v[j];
	    cos = sqrt(1. - sin * sin);
	}
	for (i = 1; i <= M; ++i) {
	    temp = cos * a[i + j * a_dim1] - sin * a[i + N * a_dim1];
	    a[i + N * a_dim1] = sin * a[i + j * a_dim1] + cos * a[
		    i + N * a_dim1];
	    a[i + j * a_dim1] = temp;
	}
    }

/*     apply the second set of givens rotations to a. */

    for (j = 1; j <= nm1; ++j) {
	if (fabs(w[j]) > 1.) {
	    cos = 1. / w[j];
	    sin = sqrt(1. - cos * cos);
	} else {
	    sin = w[j];
	    cos = sqrt(1. - sin * sin);
	}
	for (i = 1; i <= M; ++i) {
	    temp = cos * a[i + j * a_dim1] + sin * a[i + N * a_dim1];
	    a[i + N * a_dim1] = -sin * a[i + j * a_dim1] + cos * a[i + N * a_dim1];
	    a[i + j * a_dim1] = temp;
	}
    }

/*     last card of subroutine r1mpyq. */

} /* r1mpyq_ */

template<int N>
int fdjac1(root_fcn *fcn_nn, void *p, real *x, const real *fvec, real *fjac, int ldfjac, int ml, 
	int mu, real epsfcn, real *wa1, real *wa2)
{
    /* System generated locals */
    int fjac_dim1, fjac_offset;

    /* Local variables */
    real h;
    int i, j, k;
    real eps, temp;
    int msum;
    real epsmch;
    int iflag = 0;

    /* Parameter adjustments */
    --wa2;
    --wa1;
    --fvec;
    --x;
    fjac_dim1 = ldfjac;
    fjac_offset = 1 + fjac_dim1 * 1;
    fjac -= fjac_offset;

    /* Function Body */

/*     epsmch is the machine precision. */

    epsmch = dpmpar(1);

    eps = sqrt((std::max(epsfcn,epsmch)));
    msum = ml + mu + 1;
    if (msum >= N) {

/*        computation of dense approximate jacobian. */

        for (j = 1; j <= N; ++j) {
            temp = x[j];
            h = eps * fabs(temp);
            if (h == 0.) {
                h = eps;
            }
            x[j] = temp + h;
            /* the last parameter of fcn_nn() is set to 2 to tell calls
               made to compute the function from calls made to compute
               the Jacobian (see fcn() in tlmfdrv.c) */
            iflag = fcn_nn(p, &x[1], &wa1[1], 2);
            if (iflag < 0) {
                return iflag;
            }
            x[j] = temp;
            for (i = 1; i <= N; ++i) {
                fjac[i + j * fjac_dim1] = (wa1[i] - fvec[i]) / h;
            }
        }
        return 0;
    }

/*        computation of banded approximate jacobian. */

    for (k = 1; k <= msum; ++k) {
	for (j = k; msum < 0 ? j >= N : j <= N; j += msum) {
	    wa2[j] = x[j];
	    h = eps * fabs(wa2[j]);
	    if (h == 0.) {
		h = eps;
	    }
	    x[j] = wa2[j] + h;
	}
	iflag = fcn_nn(p, &x[1], &wa1[1], 1);
	if (iflag < 0) {
            return iflag;
	}
	for (j = k; msum < 0 ? j >= N : j <= N; j += msum) {
	    x[j] = wa2[j];
	    h = eps * fabs(wa2[j]);
	    if (h == 0.) {
		h = eps;
	    }
	    for (i = 1; i <= N; ++i) {
		fjac[i + j * fjac_dim1] = 0.;
		if (i >= j - mu && i <= j + ml) {
		    fjac[i + j * fjac_dim1] = (wa1[i] - fvec[i]) / h;
		}
	    }
	}
    }
    return 0;

} /* fdjac1_ */

template<int N>
void qrfac(real *a, int lda, int pivot, int *ipvt, int lipvt, real *rdiag,
	 real *acnorm, real *wa)
{
#ifdef USE_LAPACK
    int i, j, k;
    double t;
    double* tau = wa;
    const int ltau = N;
    int lwork = -1;
    int info = 0;
    double* work;

    if (pivot) {
        assert( lipvt >= N );
        /* set all columns free */
        memset(ipvt, 0, sizeof(int)*N);
    }
    
    /* query optimal size of work */
    lwork = -1;
    if (pivot) {
        dgeqp3_(&m,&n,a,&lda,ipvt,tau,tau,&lwork,&info);
        lwork = (int)tau[0];
        assert( lwork >= 3*n+1  );
    } else {
        dgeqrf_(&m,&n,a,&lda,tau,tau,&lwork,&info);
        lwork = (int)tau[0];
        assert( lwork >= 1 && lwork >= n );
    }
    
    assert( info == 0 );
    
    /* alloc work area */
    work = (double *)malloc(sizeof(double)*lwork);
    assert(work != NULL);
    
    /* set acnorm first (from the doc of qrfac, acnorm may point to the same area as rdiag) */
    if (acnorm != rdiag) {
        for (j = 0; j < n; ++j) {
            acnorm[j] = enorm<N>(&a[j * lda]);
        }
    }
    
    /* QR decomposition */
    if (pivot) {
        dgeqp3_(&m,&n,a,&lda,ipvt,tau,work,&lwork,&info);
    } else {
        dgeqrf_(&m,&n,a,&lda,tau,work,&lwork,&info);
    }
    assert(info == 0);
    
    /* set rdiag, before the diagonal is replaced */
    memset(rdiag, 0, sizeof(double)*n);
    for(i=0 ; i<n ; ++i) {
        rdiag[i] = a[i*lda+i];
    }
    
    /* modify lower trinagular part to look like qrfac's output */
    for(i=0 ; i<ltau ; ++i) {
        k = i*lda+i;
        t = tau[i];
        a[k] = t;
        for(j=i+1 ; j<m ; j++) {
            k++;
            a[k] *= t;
        }
    }
    
    free(work);
#else /* !USE_LAPACK */
    /* Initialized data */

#define p05 .05

    /* System generated locals */
    real d1;

    /* Local variables */
    int i, j, k, jp1;
    real sum;
    real temp;
    real epsmch;
    real ajnorm;

/*     ********** */

/*     subroutine qrfac */

/*     this subroutine uses householder transformations with column */
/*     pivoting (optional) to compute a qr factorization of the */
/*     m by n matrix a. that is, qrfac determines an orthogonal */
/*     matrix q, a permutation matrix p, and an upper trapezoidal */
/*     matrix r with diagonal elements of nonincreasing magnitude, */
/*     such that a*p = q*r. the householder transformation for */
/*     column k, k = 1,2,...,min(m,n), is of the form */

/*                           t */
/*           i - (1/u(k))*u*u */

/*     where u has zeros in the first k-1 positions. the form of */
/*     this transformation and the method of pivoting first */
/*     appeared in the corresponding linpack subroutine. */

/*     the subroutine statement is */

/*       subroutine qrfac(m,n,a,lda,pivot,ipvt,lipvt,rdiag,acnorm,wa) */

/*     where */

/*       m is a positive integer input variable set to the number */
/*         of rows of a. */

/*       n is a positive integer input variable set to the number */
/*         of columns of a. */

/*       a is an m by n array. on input a contains the matrix for */
/*         which the qr factorization is to be computed. on output */
/*         the strict upper trapezoidal part of a contains the strict */
/*         upper trapezoidal part of r, and the lower trapezoidal */
/*         part of a contains a factored form of q (the non-trivial */
/*         elements of the u vectors described above). */

/*       lda is a positive integer input variable not less than m */
/*         which specifies the leading dimension of the array a. */

/*       pivot is a logical input variable. if pivot is set true, */
/*         then column pivoting is enforced. if pivot is set false, */
/*         then no column pivoting is done. */

/*       ipvt is an integer output array of length lipvt. ipvt */
/*         defines the permutation matrix p such that a*p = q*r. */
/*         column j of p is column ipvt(j) of the identity matrix. */
/*         if pivot is false, ipvt is not referenced. */

/*       lipvt is a positive integer input variable. if pivot is false, */
/*         then lipvt may be as small as 1. if pivot is true, then */
/*         lipvt must be at least n. */

/*       rdiag is an output array of length n which contains the */
/*         diagonal elements of r. */

/*       acnorm is an output array of length n which contains the */
/*         norms of the corresponding columns of the input matrix a. */
/*         if this information is not needed, then acnorm can coincide */
/*         with rdiag. */

/*       wa is a work array of length n. if pivot is false, then wa */
/*         can coincide with rdiag. */

/*     subprograms called */

/*       minpack-supplied ... dpmpar,enorm */

/*       fortran-supplied ... dmax1,dsqrt,min0 */

/*     argonne national laboratory. minpack project. march 1980. */
/*     burton s. garbow, kenneth e. hillstrom, jorge j. more */

/*     ********** */
    (void)lipvt;

/*     epsmch is the machine precision. */

    epsmch = dpmpar(1);

/*     compute the initial column norms and initialize several arrays. */

    for (j = 0; j < N; ++j) {
	acnorm[j] = enorm<N>(&a[j * lda + 0]);
	rdiag[j] = acnorm[j];
	wa[j] = rdiag[j];
	if (pivot) {
	    ipvt[j] = j+1;
	}
    }

/*     reduce a to r with householder transformations. */

    for (j = 0; j < N; ++j) {
	if (pivot) {

/*        bring the column of largest norm into the pivot position. */

            int kmax = j;
            for (k = j; k < N; ++k) {
                if (rdiag[k] > rdiag[kmax]) {
                    kmax = k;
                }
            }
            if (kmax != j) {
                for (i = 0; i < N; ++i) {
                    temp = a[i + j * lda];
                    a[i + j * lda] = a[i + kmax * lda];
                    a[i + kmax * lda] = temp;
                }
                rdiag[kmax] = rdiag[j];
                wa[kmax] = wa[j];
                k = ipvt[j];
                ipvt[j] = ipvt[kmax];
                ipvt[kmax] = k;
            }
        }

/*        compute the householder transformation to reduce the */
/*        j-th column of a to a multiple of the j-th unit vector. */

	ajnorm = enorm(N - (j+1) + 1, &a[j + j * lda]);
	if (ajnorm != 0.) {
            if (a[j + j * lda] < 0.) {
                ajnorm = -ajnorm;
            }
            for (i = j; i < N; ++i) {
                a[i + j * lda] /= ajnorm;
            }
            a[j + j * lda] += 1.;

/*        apply the transformation to the remaining columns */
/*        and update the norms. */

            jp1 = j + 1;
            if (N > jp1) {
                for (k = jp1; k < N; ++k) {
                    sum = 0.;
                    for (i = j; i < N; ++i) {
                        sum += a[i + j * lda] * a[i + k * lda];
                    }
                    temp = sum / a[j + j * lda];
                    for (i = j; i < N; ++i) {
                        a[i + k * lda] -= temp * a[i + j * lda];
                    }
                    if (pivot && rdiag[k] != 0.) {
                        temp = a[j + k * lda] / rdiag[k];
                        /* Computing MAX */
                        d1 = 1. - temp * temp;
                        rdiag[k] *= sqrt((std::max((real)0.,d1)));
                        /* Computing 2nd power */
                        d1 = rdiag[k] / wa[k];
                        if (p05 * (d1 * d1) <= epsmch) {
                            rdiag[k] = enorm(N - (j+1), &a[jp1 + k * lda]);
                            wa[k] = rdiag[k];
                        }
                    }
                }
            }
        }
	rdiag[j] = -ajnorm;
    }

/*     last card of subroutine qrfac. */
#endif /* !USE_LAPACK */
} /* qrfac_ */

template<int N>
void dogleg(const real *r, int lr, const real *diag, const real *qtb, real delta, real *x, 
	    real *wa1, real *wa2)
{
    /* System generated locals */
    real d1, d2, d3, d4;

    /* Local variables */
    int i, j, k, l, jj, jp1;
    real sum, temp, alpha, bnorm;
    real gnorm, qnorm, epsmch;
    real sgnorm;

    /* Parameter adjustments */
    --wa2;
    --wa1;
    --x;
    --qtb;
    --diag;
    --r;
    (void)lr;

    /* Function Body */

/*     epsmch is the machine precision. */

    epsmch = dpmpar(1);

/*     first, calculate the gauss-newton direction. */

    jj = N * (N + 1) / 2 + 1;
    for (k = 1; k <= N; ++k) {
	j = N - k + 1;
	jp1 = j + 1;
	jj -= k;
	l = jj + 1;
	sum = 0.;
	if (N >= jp1) {
            for (i = jp1; i <= N; ++i) {
                sum += r[l] * x[i];
                ++l;
            }
        }
	temp = r[jj];
	if (temp == 0.) {
            l = j;
            for (i = 1; i <= j; ++i) {
                /* Computing MAX */
                d2 = fabs(r[l]);
                temp = std::max(temp,d2);
                l = l + N - i;
            }
            temp = epsmch * temp;
            if (temp == 0.) {
                temp = epsmch;
            }
        }
	x[j] = (qtb[j] - sum) / temp;
    }

/*     test whether the gauss-newton direction is acceptable. */

    for (j = 1; j <= N; ++j) {
	wa1[j] = 0.;
	wa2[j] = diag[j] * x[j];
    }
    qnorm = enorm<N>(&wa2[1]);
    if (qnorm <= delta) {
        return;
    }

/*     the gauss-newton direction is not acceptable. */
/*     next, calculate the scaled gradient direction. */

    l = 1;
    for (j = 1; j <= N; ++j) {
	temp = qtb[j];
	for (i = j; i <= N; ++i) {
	    wa1[i] += r[l] * temp;
	    ++l;
	}
	wa1[j] /= diag[j];
    }

/*     calculate the norm of the scaled gradient and test for */
/*     the special case in which the scaled gradient is zero. */

    gnorm = enorm<N>(&wa1[1]);
    sgnorm = 0.;
    alpha = delta / qnorm;
    if (gnorm != 0.) {

/*     calculate the point along the scaled gradient */
/*     at which the quadratic is minimized. */

        for (j = 1; j <= N; ++j) {
            wa1[j] = wa1[j] / gnorm / diag[j];
        }
        l = 1;
        for (j = 1; j <= N; ++j) {
            sum = 0.;
            for (i = j; i <= N; ++i) {
                sum += r[l] * wa1[i];
                ++l;
            }
            wa2[j] = sum;
        }
        temp = enorm<N>(&wa2[1]);
        sgnorm = gnorm / temp / temp;

/*     test whether the scaled gradient direction is acceptable. */

        alpha = 0.;
        if (sgnorm < delta) {

/*     the scaled gradient direction is not acceptable. */
/*     finally, calculate the point along the dogleg */
/*     at which the quadratic is minimized. */

            bnorm = enorm<N>(&qtb[1]);
            temp = bnorm / gnorm * (bnorm / qnorm) * (sgnorm / delta);
            /* Computing 2nd power */
            d1 = sgnorm / delta;
            /* Computing 2nd power */
            d2 = temp - delta / qnorm;
            /* Computing 2nd power */
            d3 = delta / qnorm;
            /* Computing 2nd power */
            d4 = sgnorm / delta;
            temp = temp - delta / qnorm * (d1 * d1)
                   + sqrt(d2 * d2
                          + (1. - d3 * d3) * (1. - d4 * d4));
            /* Computing 2nd power */
            d1 = sgnorm / delta;
            alpha = delta / qnorm * (1. - d1 * d1) / temp;
        }
    }

/*     form appropriate convex combination of the gauss-newton */
/*     direction and the scaled gradient direction. */

    temp = (1. - alpha) * std::min(sgnorm,delta);
    for (j = 1; j <= N; ++j) {
	x[j] = temp * wa1[j] + alpha * x[j];
    }

} /* dogleg_ */

template<int N>
int hybrdX(root_fcn *fcn_nn, void *p, real *x, real *
	fvec, real xtol, int maxfev, int ml, int mu, 
	real epsfcn, real *diag, int mode, real
	factor, int nprint, int *nfev, real *
	fjac, int ldfjac, real *r, int lr, real *qtf, 
	real *wa1, real *wa2, real *wa3, real *wa4)
{
    /* Initialized data */

#define p1 .1
#define p5 .5
#define p001 .001
#define p0001 1e-4

    /* System generated locals */
    int fjac_dim1, fjac_offset, i1;
    real d1, d2;

    /* Local variables */
    int i, j, l, jm1, iwa[1];
    real sum;
    int sing;
    int iter;
    real temp;
    int msum, iflag;
    real delta = 0.;
    int jeval;
    int ncsuc;
    real ratio;
    real fnorm;
    real pnorm, xnorm = 0., fnorm1;
    int nslow1, nslow2;
    int ncfail;
    real actred, epsmch, prered;
    int info;

    /* Parameter adjustments */
#pragma GCC diagnostic push 
#pragma GCC diagnostic ignored "-Warray-bounds"
    --wa4;
    --wa3;
    --wa2;
    --wa1;
    --qtf;
    --diag;
    --fvec;
    --x;
    fjac_dim1 = ldfjac;
    fjac_offset = 1 + fjac_dim1 * 1;
    fjac -= fjac_offset;
    --r;
#pragma GCC diagnostic pop

    /* Function Body */

/*     epsmch is the machine precision. */

    epsmch = dpmpar(1);

    info = 0;
    iflag = 0;
    *nfev = 0;

/*     check the input parameters for errors. */

    if (N <= 0 || xtol < 0. || maxfev <= 0 || ml < 0 || mu < 0 ||
	    factor <= 0. || ldfjac < N || lr < N * (N + 1) / 2) {
	goto TERMINATE;
    }
    if (mode == 2) {
        for (j = 1; j <= N; ++j) {
            if (diag[j] <= 0.) {
                goto TERMINATE;
            }
        }
    }

/*     evaluate the function at the starting point */
/*     and calculate its norm. */

    iflag = fcn_nn(p, &x[1], &fvec[1], 1);
    *nfev = 1;
    if (iflag < 0) {
	goto TERMINATE;
    }
    fnorm = enorm2<N>(&fvec[1]);

/*     determine the number of calls to fcn needed to compute */
/*     the jacobian matrix. */

/* Computing MIN */
    i1 = ml + mu + 1;
    msum = std::min(i1,N);

/*     initialize iteration counter and monitors. */

    iter = 1;
    ncsuc = 0;
    ncfail = 0;
    nslow1 = 0;
    nslow2 = 0;

/*     beginning of the outer loop. */

    for (;;) {
        jeval = true;

/*        calculate the jacobian matrix. */

        iflag = fdjac1<N>(fcn_nn, p, &x[1], &fvec[1], &fjac[fjac_offset], ldfjac,
			  ml, mu, epsfcn, &wa1[1], &wa2[1]);
        *nfev += msum;
        if (iflag < 0) {
            goto TERMINATE;
        }

/*        compute the qr factorization of the jacobian. */

        qrfac<N>(&fjac[fjac_offset], ldfjac, false, iwa, 1, &wa1[1], &wa2[1], &wa3[1]);

/*        on the first iteration and if mode is 1, scale according */
/*        to the norms of the columns of the initial jacobian. */

        if (iter == 1) {
            if (mode != 2) {
                for (j = 1; j <= N; ++j) {
                    diag[j] = wa2[j];
                    if (wa2[j] == 0.) {
                        diag[j] = 1.;
                    }
                }
            }

/*        on the first iteration, calculate the norm of the scaled x */
/*        and initialize the step bound delta. */

            for (j = 1; j <= N; ++j) {
                wa3[j] = diag[j] * x[j];
            }
            xnorm = enorm<N>(&wa3[1]);
            delta = factor * xnorm;
            if (delta == 0.) {
                delta = factor;
            }
        }

/*        form (q transpose)*fvec and store in qtf. */

        for (i = 1; i <= N; ++i) {
            qtf[i] = fvec[i];
        }
        for (j = 1; j <= N; ++j) {
            if (fjac[j + j * fjac_dim1] != 0.) {
                sum = 0.;
                for (i = j; i <= N; ++i) {
                    sum += fjac[i + j * fjac_dim1] * qtf[i];
                }
                temp = -sum / fjac[j + j * fjac_dim1];
                for (i = j; i <= N; ++i) {
                    qtf[i] += fjac[i + j * fjac_dim1] * temp;
                }
            }
        }

/*        copy the triangular factor of the qr factorization into r. */

        sing = false;
        for (j = 1; j <= N; ++j) {
            l = j;
            jm1 = j - 1;
            if (jm1 >= 1) {
                for (i = 1; i <= jm1; ++i) {
                    r[l] = fjac[i + j * fjac_dim1];
                    l = l + N - i;
                }
            }
            r[l] = wa1[j];
            if (wa1[j] == 0.) {
                sing = true;
            }
        }

/*        accumulate the orthogonal factor in fjac. */

        qform<N>(&fjac[fjac_offset], ldfjac, &wa1[1]);

/*        rescale if necessary. */

        if (mode != 2) {
            for (j = 1; j <= N; ++j) {
                /* Computing MAX */
                d1 = diag[j], d2 = wa2[j];
                diag[j] = std::max(d1,d2);
            }
        }

/*        beginning of the inner loop. */

        for (;;) {

/*           if requested, call fcn to enable printing of iterates. */

            if (nprint > 0) {
                iflag = 0;
                if ((iter - 1) % nprint == 0) {
                    iflag = fcn_nn(p, &x[1], &fvec[1], 0);
                }
                if (iflag < 0) {
                    goto TERMINATE;
                }
            }

/*           determine the direction p. */

            dogleg<N>(&r[1], lr, &diag[1], &qtf[1], delta, &wa1[1], &wa2[1], &wa3[1]);

/*           store the direction p and x + p. calculate the norm of p. */

            for (j = 1; j <= N; ++j) {
                wa1[j] = -wa1[j];
                wa2[j] = x[j] + wa1[j];
                wa3[j] = diag[j] * wa1[j];
            }
            pnorm = enorm<N>(&wa3[1]);

/*           on the first iteration, adjust the initial step bound. */

            if (iter == 1) {
                delta = std::min(delta,pnorm);
            }

/*           evaluate the function at x + p and calculate its norm. */

            iflag = fcn_nn(p, &wa2[1], &wa4[1], 1);
            ++(*nfev);
            if (iflag < 0) {
                goto TERMINATE;
            }
            fnorm1 = enorm2<N>(&wa4[1]);

/*           compute the scaled actual reduction. */

            actred = -1.;
            if (fnorm1 < fnorm) {
                /* already 2nd power */
                actred = 1. - fnorm1 / fnorm;
            }

/*           compute the scaled predicted reduction. */

            l = 1;
            for (i = 1; i <= N; ++i) {
                sum = 0.;
                for (j = i; j <= N; ++j) {
                    sum += r[l] * wa1[j];
                    ++l;
                }
                wa3[i] = qtf[i] + sum;
            }
            temp = enorm2<N>(&wa3[1]);
            prered = 0.;
            if (temp < fnorm) {
                /* already 2nd power */
                prered = 1. - temp / fnorm;
            }

/*           compute the ratio of the actual to the predicted */
/*           reduction. */

            ratio = 0.;
            if (prered > 0.) {
                ratio = actred / prered;
            }

/*           update the step bound. */

            if (ratio < p1) {
                ncsuc = 0;
                ++ncfail;
                delta = p5 * delta;
            } else {
                ncfail = 0;
                ++ncsuc;
                if (ratio >= p5 || ncsuc > 1) {
                    /* Computing MAX */
                    d1 = pnorm / p5;
                    delta = std::max(delta,d1);
                }
                if (fabs(ratio - 1.) <= p1) {
                    delta = pnorm / p5;
                }
            }

/*           test for successful iteration. */

            if (ratio >= p0001) {

/*           successful iteration. update x, fvec, and their norms. */

                for (j = 1; j <= N; ++j) {
                    x[j] = wa2[j];
                    wa2[j] = diag[j] * x[j];
                    fvec[j] = wa4[j];
                }
                xnorm = enorm<N>(&wa2[1]);
                fnorm = fnorm1;
                ++iter;
            }

/*           determine the progress of the iteration. */

            ++nslow1;
            if (actred >= p001) {
                nslow1 = 0;
            }
            if (jeval) {
                ++nslow2;
            }
            if (actred >= p1) {
                nslow2 = 0;
            }

/*           test for convergence. */

            if (delta <= xtol * xnorm || fnorm == 0.) {
                info = 1;
            }
            if (info != 0) {
                goto TERMINATE;
            }

/*           tests for termination and stringent tolerances. */

            if (*nfev >= maxfev) {
                info = 2;
            }
            /* Computing MAX */
            d1 = p1 * delta;
            if (p1 * std::max(d1,pnorm) <= epsmch * xnorm) {
                info = 3;
            }
            if (nslow2 == 5) {
                info = 4;
            }
            if (nslow1 == 10) {
                info = 5;
            }
            if (info != 0) {
                goto TERMINATE;
            }

/*           criterion for recalculating jacobian approximation */
/*           by forward differences. */

            if (ncfail == 2) {
                goto TERMINATE_INNER_LOOP;
            }

/*           calculate the rank one modification to the jacobian */
/*           and update qtf if necessary. */

            for (j = 1; j <= N; ++j) {
                sum = 0.;
                for (i = 1; i <= N; ++i) {
                    sum += fjac[i + j * fjac_dim1] * wa4[i];
                }
                wa2[j] = (sum - wa3[j]) / pnorm;
                wa1[j] = diag[j] * (diag[j] * wa1[j] / pnorm);
                if (ratio >= p0001) {
                    qtf[j] = sum;
                }
            }

/*           compute the qr factorization of the updated jacobian. */

            r1updt<N>(&r[1], lr, &wa1[1], &wa2[1], &wa3[1], &sing);
            r1mpyq<N, N>(&fjac[fjac_offset], ldfjac, &wa2[1], &wa3[1]);
            r1mpyq<1, N>(&qtf[1], 1, &wa2[1], &wa3[1]);

/*           end of the inner loop. */

            jeval = false;
        }
TERMINATE_INNER_LOOP:
        ;
/*        end of the outer loop. */

    }
TERMINATE:

/*     termination, either normal or user imposed. */

    if (iflag < 0) {
	info = iflag;
    }
    if (nprint > 0) {
	fcn_nn(p, &x[1], &fvec[1], 0);
    }
    return info;

/*     last card of subroutine hybrd. */

} /* hybrd_ */


static int nonlin(struct nonlin_param &par) {
    int maxfev, mode, nprint, ldfjac;
    creal xtol, epsfcn, factor;
    creal __attribute__((aligned(16))) fvec[2];
    creal __attribute__((aligned(16))) fjac[2*2];
    creal __attribute__((aligned(16))) qtf[2];
    creal __attribute__((aligned(16))) wa1[2];
    creal __attribute__((aligned(16))) wa2[2];
    creal __attribute__((aligned(16))) wa3[2];
    creal __attribute__((aligned(16))) wa4[2];
    creal diag[2] = {};
    int ml, mu, lr;
    creal r[(2*(2+1))/2];
    lr = (2*(2+1))/2;
    ml = 2-1; /* unbanded jacobian */
    mu = 2-1; /* unbanded jacobian */
    ldfjac = 2;

    /* parameter */
    xtol = 0.1;
    maxfev = 12;
    epsfcn = 0.;
    //mode = 2;  /* explicit variable scaling with diag */
    mode = 1;  /* automatic variable scaling */
    factor = 100000.0;
    nprint = 0;
    /**/

    
    (*par.p_val).head<8>() = (*par.p).head<8>();

    Matrix<creal, 8, 1> p2;
    Matrix<creal, 8, 1> *p_old;
    p2.head<8>() = (*par.p).head<8>() + Mpc;
    p_old = par.p;
    par.p = &p2;
    

    *par.info = hybrdX<2>(fcn, &par, &(*par.v)(6), fvec, xtol, maxfev, ml, mu, epsfcn,
                          diag, mode, factor, nprint, par.nfev, fjac, ldfjac, r, lr,
                          qtf, wa1, wa2, wa3, wa4);
    *par.fnorm = enorm<2>(fvec);
    
    int ret = 0;
    if (*par.info != 1) {
        if (!(*par.info == 5 && *par.fnorm < 1e-20)) {
            ret = -1;
        }
    }
    par.p = p_old;
    
    return ret;
}


} // end namespace nonlin






#include <zita-resampler/resampler.h>

class FixedRateResampler {
private:
    Resampler r_up, r_down;
    int inputRate, outputRate;
    int last_in_count;
public:
    int setup(int _inputRate, int _outputRate);
    int up(int count, float *input, float *output);
    void down(float *input, float *output);
    int max_out_count(int in_count) {
	return static_cast<int>(ceil((in_count*static_cast<double>(outputRate))/inputRate)); }
};

int FixedRateResampler::setup(int _inputRate, int _outputRate)
{
    const int qual = 16; // resulting in a total delay of 2*qual (0.7ms @44100)
    inputRate = _inputRate;
    outputRate = _outputRate;
    if (inputRate == outputRate) {
	return 0;
    }
    // upsampler
    int ret = r_up.setup(inputRate, outputRate, 1, qual);
    if (ret) {
	return ret;
    }
    // k == filtlen() == 2 * qual
    // pre-fill with k-1 zeros
    r_up.inp_count = r_up.filtlen() - 1;
    r_up.out_count = 1;
    r_up.inp_data = r_up.out_data = 0;
    r_up.process();
    // downsampler
    ret = r_down.setup(outputRate, inputRate, 1, qual);
    if (ret) {
	return ret;
    }
    // k == filtlen() == 2 * qual * fact
    // pre-fill with k-2 zeros
    r_down.inp_count = r_down.filtlen() - 2;
    r_down.out_count = 1;
    r_down.inp_data = r_down.out_data = 0;
    r_down.process();
    return 0;
}

int FixedRateResampler::up(int count, float *input, float *output)
{
    if (inputRate == outputRate) {
	memcpy(output, input, count*sizeof(float));
	r_down.out_count = count;
	return count;
    }
    r_up.inp_count = count;
    r_down.out_count = count+1; // +1 == trick to drain input
    r_up.inp_data = input;
    int m = max_out_count(count);
    r_up.out_count = m;
    r_up.out_data = output;
    r_up.process();
    assert(r_up.inp_count == 0);
    assert(r_up.out_count <= 1);
    r_down.inp_count = m - r_up.out_count;
    return r_down.inp_count;
}

void FixedRateResampler::down(float *input, float *output)
{
    if (inputRate == outputRate) {
	memcpy(output, input, r_down.out_count*sizeof(float));
	return;
    }
    r_down.inp_data = input;
    r_down.out_data = output;
    r_down.process();
    assert(r_down.inp_count == 0);
    assert(r_down.out_count == 1);
}

FixedRateResampler smp;

class DKPlugin: public PluginDef {
public:
    float pots[0+1];
private:
    creal pots_last[0+1];
    Matrix<creal, 7, 1> x_last;
    Array<double, 6, 1> K0;
    Array<double, 6, 1> K1;
    Array<double, 6, 1> K2;
    Array<double, 6, 1> K3;
    Array<double, 6, 1> K4;
    Array<double, 6, 1> K5;
    Array<double, 6, 1> Y;
    Array<double, 6, 1> X;
    bool resamp;
    unsigned int bufsize;
public:
    EIGEN_MAKE_ALIGNED_OPERATOR_NEW;
    DKPlugin();
    static void init(unsigned int samplingFreq, PluginDef *plugin);
    static void process(int count, float *input, float *output, PluginDef *plugin);
    static int registerparam(const ParamReg& reg);
    static int uiloader(const UiBuilder& builder, int form);
    static void del_instance(PluginDef *plugin);
};

DKPlugin::DKPlugin():
    PluginDef(), pots(), pots_last(), x_last(), K0(), K1(), K2(), K3(), K4(), K5(), Y(), X() {
    version = PLUGINDEF_VERSION;
    flags = 0;
    id = "JCM800Pre";
    name = N_("JCM 800 Preamp");
    groups = 0;
    description = N_("Simulation of JCM 800 preamp circuit");
    category = N_("Distortion");
    shortname = N_("JCM800Pre");
    mono_audio = process;
    set_samplerate = init;
    register_params = registerparam;
    load_ui = uiloader;
    delete_instance = del_instance;
    for (int i = 0; i < 7; i++) {
        x_last(i) = x0_data[i];
    }
}

#define PARAM(p) ("JCM800Pre" "." p)

int DKPlugin::registerparam(const ParamReg& reg) {
            DKPlugin& self = *static_cast<DKPlugin*>(reg.plugin);
        
        reg.registerVar(PARAM("P6v"), N_("Volume"), "S", N_(""), &self.pots[0], 0.5, 0, 1, 0.01);
        return 0;
}

void DKPlugin::init(unsigned int samplingFreq, PluginDef *plugin) {
    DKPlugin& self = *static_cast<DKPlugin*>(plugin);
    if(samplingFreq != 96000) self.resamp = true;
    else self.resamp = false;
    if( self.resamp) smp.setup(samplingFreq, 96000);
    self.X.setZero();
    self.Y.setZero();
    unsigned int fs = samplingFreq;
       self.K5(0) = 1.75171807136529e-7*pow(fs,2);
       self.K4(0) = -7.00687228546118e-7*pow(fs,2);
       self.K3(0) = 1.05103084281918e-6*pow(fs,2) + 0.000200534456453583*fs;
       self.K2(0) = -7.00687228546118e-7*pow(fs,2) - 0.000401068912907166*fs;
       self.K1(0) = 1.75171807136529e-7*pow(fs,2) + 0.000200534456453583*fs + 0.0107626291380964;
       self.K0(0) = 0.0;
       self.K5(1) = -3.50343614273059e-7*pow(fs,2);
       self.K4(1) = 1.40137445709224e-6*pow(fs,2);
       self.K3(1) = -2.10206168563835e-6*pow(fs,2);
       self.K2(1) = 1.40137445709224e-6*pow(fs,2);
       self.K1(1) = -3.50343614273059e-7*pow(fs,2) + 0.0215252582761928;
       self.K0(1) = 0.0;
       self.K5(2) = 1.75171807136529e-7*pow(fs,2);
       self.K4(2) = -7.00687228546118e-7*pow(fs,2);
       self.K3(2) = 1.05103084281918e-6*pow(fs,2) - 0.000200534456453583*fs;
       self.K2(2) = -7.00687228546118e-7*pow(fs,2) + 0.000401068912907166*fs;
       self.K1(2) = 1.75171807136529e-7*pow(fs,2) - 0.000200534456453583*fs + 0.0107626291380964;
       self.K0(2) = 0.0;
       self.K5(3) = 1.70232916580416e-7*pow(fs,2);
       self.K4(3) = -6.75992775765549e-7*pow(fs,2);
       self.K3(3) = 1.00164193725804e-6*pow(fs,2) + 7.7521112860407e-5*fs;
       self.K2(3) = -6.51298322984981e-7*pow(fs,2) - 3.20288821276382e-5*fs;
       self.K1(3) = 1.50477354355961e-7*pow(fs,2) - 0.000168505574325945*fs - 0.00752160890512768;
       self.K0(3) = 4.93889055611368e-9*pow(fs,2) + 0.000123013343593176*fs + 0.0182842380432241;
       self.K5(4) = -3.40465833160831e-7*pow(fs,2);
       self.K4(4) = 1.3519855515311e-6*pow(fs,2);
       self.K3(4) = -2.00328387451608e-6*pow(fs,2);
       self.K2(4) = 1.30259664596996e-6*pow(fs,2);
       self.K1(4) = -3.00954708711922e-7*pow(fs,2) - 0.0150432178102554;
       self.K0(4) = -9.87778111222735e-9*pow(fs,2) + 0.0365684760864481;
       self.K5(5) = 1.70232916580416e-7*pow(fs,2);
       self.K4(5) = -6.75992775765549e-7*pow(fs,2);
       self.K3(5) = 1.00164193725804e-6*pow(fs,2) - 7.7521112860407e-5*fs;
       self.K2(5) = -6.51298322984981e-7*pow(fs,2) + 3.20288821276382e-5*fs;
       self.K1(5) = 1.50477354355961e-7*pow(fs,2) + 0.000168505574325945*fs - 0.00752160890512768;
       self.K0(5) = 4.93889055611368e-9*pow(fs,2) - 0.000123013343593176*fs + 0.0182842380432241;
}

void DKPlugin::process(int n, float *u, float *o, PluginDef *plugin) {
    DKPlugin& self = *static_cast<DKPlugin*>(plugin);
    creal t[0+1];
    t[0] = (exp(5 * self.pots[0]) - 1) / (exp(5) - 1);
        for (int j = 0; j < n; j++) {
        self.pots_last[0] = 0.01 * t[0] + (1-0.01) * self.pots_last[0];
        double P6v = self.pots_last[0];
        Array<double, 6, 1> AB;
        AB = (((((self.K5 * P6v + self.K4) * P6v + self.K3) * P6v + self.K2) * P6v + self.K1) * P6v + self.K0);
        double out;
        out = ((u[j] * AB(0) + self.X(0) * AB(1) + self.X(1) * AB(2)) - (self.Y(0) * AB(4) + self.Y(1) * AB(5))) / AB(3);
        self.Y(1) = self.Y(0);
        self.Y(0) = out;
        self.X(1) = self.X(0);
        self.X(0) = u[j];
        o[j] = out;
    }
    u = o;

// start copied and modified code
    Matrix<creal, 8, 1> mi;
    creal fnorm;
    Matrix<creal, 8, 1> mp;
    Array<creal, 8, 1> p_val;
    nonlin_param par(&mp, &mi, &g_v, &g_info, &g_nfev, &fnorm, &p_val);
    
    if( self.resamp) {
        self.bufsize = smp.max_out_count(n);
    } else {
        self.bufsize = n;
    }
    float buf[self.bufsize];
    if( self.resamp) {
        n = smp.up(n, u, buf);
    } else {
        memcpy(buf, u, n * sizeof(float));
    }
     
#define GET_U (buf+j*1)
#define DTP_U float
    for (int j = 0; j < n; j++) {
        
        Matrix<creal, 8, 1> dp;
        dp << self.x_last, Map<Matrix<float,1,1> >(GET_U).cast<creal>();
        mp = Mp * dp;
        nonlin::nonlin(par);
        Matrix<creal, 16, 1> d;
        d << self.x_last, Map<Matrix<float,1,1> >(GET_U).cast<creal>(), mi;
        Matrix<creal, 7, 1>& xn = self.x_last;
        xn = Mx * d + Mxc;
        Map<Matrix<float, 1, 1> > xo(buf+1*j);
        xo = (Mo * d).cast<float>();
        {
            static double y;
            static double xm1;
            y = 0.999345929619 * (buf[j] - xm1) + 0.998691859237 * y;
            xm1 = buf[j];
            buf[j] = y;
        }

    }
#undef GET_U
#undef DTP_U
    if (self.resamp) smp.down(buf, o);
    else memcpy(o, buf, n * sizeof(float));
// end copied code
}

int DKPlugin::uiloader(const UiBuilder& b, int form) {
    if (!(form & UI_FORM_STACK)) {
        return -1;
    }
    
b.openHorizontalhideBox("");
    b.create_master_slider(PARAM("P6v"), "Volume");
b.closeBox();
b.openHorizontalBox("");

    b.create_mid_rackknob(PARAM("P6v"), "Volume");
b.closeBox();

    return 0;
}

void DKPlugin::del_instance(PluginDef *p)
{
    delete static_cast<DKPlugin*>(p);
}


namespace pluginlib { namespace jcm800pre {
PluginDef *plugin() {
    return new DKPlugin;
}
}}

#ifdef LV2_COMPILE
#include "lv2/lv2plug.in/ns/lv2core/lv2.h"

#define LV2_PLUGIN_URI "http://guitarix.sourceforge.net/plugins/JCM800Pre#JCM800Pre"

typedef enum {
	PORT_in0 = 0,
	PORT_out0 = 1,
	PORT_P6v = 2,
} PortIndex;

class LV2_DKPlugin: public DKPlugin {
public:
	// Port buffers
	float* ports[3];
public:
    LV2_DKPlugin(): DKPlugin() {}
};

static LV2_Handle
instantiate(const LV2_Descriptor*     descriptor,
            double                    rate,
            const char*               bundle_path,
            const LV2_Feature* const* features)
{
    LV2_DKPlugin *p = new LV2_DKPlugin;
    p->set_samplerate(rate, p);
    return static_cast<LV2_Handle>(p);
}

static void
connect_port(LV2_Handle instance,
             uint32_t   port,
             void*      data)
{
	static_cast<LV2_DKPlugin*>(instance)->ports[port] = static_cast<float*>(data);
}

static void
activate(LV2_Handle instance)
{
}

static void
run(LV2_Handle instance, uint32_t n_samples)
{
    LV2_DKPlugin* p = static_cast<LV2_DKPlugin*>(instance);

	p->pots[0] = *(p->ports[2]);
	p->process(n_samples, p->ports[0], p->ports[1], p);
}

static void
deactivate(LV2_Handle instance)
{
}

static void
cleanup(LV2_Handle instance)
{
    LV2_DKPlugin* p = static_cast<LV2_DKPlugin*>(instance);
    p->delete_instance(p);
}

static const void*
extension_data(const char* uri)
{
	return NULL;
}

static const LV2_Descriptor descriptor = {
	LV2_PLUGIN_URI,
	instantiate,
	connect_port,
	activate,
	run,
	deactivate,
	cleanup,
	extension_data
};

LV2_SYMBOL_EXPORT
extern "C" __attribute__ ((visibility ("default")))
const LV2_Descriptor*
lv2_descriptor(uint32_t index)
{
	switch (index) {
	case 0:
		return &descriptor;
	default:
		return NULL;
	}
}
#endif
