;;;
;;;     形態素解析システムＪＵＭＡＮ： 連接規則辞書
;;;
;;;     ;       コメント開始記号 (Comment Character)
;;;

; <注意> 語まで与える場合は，品詞，細分類，活用型まで正確に指定．
;        活用形が固定ならば指定，その場合も語は基本形で与える．
;
; <注意> 基本連体形という活用形はない
;        基本形と同型の場合は活用形はたてず，他はより詳細な名称
;
; <注意> NominalFollowはBackwardAllNominalに後接するものを集めたもの
;        BackwardAllNominalの後接変更後にはチェックの必要あり．
;
; <注意> 活用形と語を指定する場合, 形態素の場合は基本形，連語の場合は
;        活用した形を指定する．(不統一で問題)
;
; <注意> 同一の(別スコアの)接続が複数定義されている場合は，後ろの定義
;        が優先される．

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               マクロ定義
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#define NormalNominal (名詞 普通名詞) \
                      (名詞 時相名詞) \
                      (名詞 サ変名詞) \
                      (未定義語) \
                      (名詞 固有名詞) \
                      (名詞 地名) \
                      (名詞 人名) \
                      (名詞 組織名) \
                      (副詞) \
                      (指示詞 名詞形態指示詞) \
                      (指示詞 副詞形態指示詞) \
                      (動詞 * * 基本連用形) \
                      (接尾辞 動詞性接尾辞 * 基本連用形) \
                      (接尾辞 名詞性述語接尾辞) \
                      (接尾辞 名詞性名詞接尾辞)

; 副詞は名詞的に働く 「古来は」「どれほどが」

#define BackwardNormalNominal NormalNominal \
                              (名詞 数詞) \
                              (接尾辞 名詞性名詞助数辞) \
                              (接尾辞 名詞性特殊接尾辞) \
                              (形容詞 * ナ形容詞 語幹) \
			      (形容詞 * ナ形容詞特殊 語幹) \
			      (形容詞 * ナノ形容詞 語幹) \
                              (接尾辞 形容詞性名詞接尾辞 ナ形容詞 語幹) \
			      (接尾辞 形容詞性名詞接尾辞 ナノ形容詞 語幹) \
                              (接尾辞 形容詞性述語接尾辞 ナ形容詞 語幹) \
			      (接尾辞 形容詞性述語接尾辞 ナノ形容詞 語幹)

#define BackwardAllNominal BackwardNormalNominal \
                           (名詞 形式名詞) \
                           (名詞 副詞的名詞) \
                           (感動詞)

; 「ありがとうが言えない」などを扱うため，感動詞も名詞扱いするが，
; 最後にペナルティを与えている．

#define VerbBasicBasicForm (動詞 * * 基本形) \
			(接尾辞 動詞性接尾辞 * 基本形)
#define VerbTaBasicForm (動詞 * * タ形) \
			(接尾辞 動詞性接尾辞 * タ形)
#define VerbBasicForm VerbBasicBasicForm \
                      VerbTaBasicForm

#define AuxBasicForm (助動詞 * 助動詞ぬ型 基本形) \
			(助動詞 * 助動詞ぬ型 音便基本形) \
			(助動詞 * 助動詞ぬ型 タ形) \
			(助動詞 * 無活用型 基本形) \
			(助動詞 * 助動詞だろう型 基本形) \
			(助動詞 * 助動詞そうだ型 基本形) \
			(助動詞 * 助動詞そうだ型 デアル列基本形) \
			(助動詞 * 助動詞そうだ型 デス列基本形)

#define IAdjBasicBasicForm (* * イ形容詞アウオ段 基本形) \
			(* * イ形容詞イ段 基本形) \
			(* * イ形容詞イ段特殊 基本形)
#define IAdjTaBasicForm (* * イ形容詞アウオ段 タ形) \
			(* * イ形容詞イ段 タ形) \
			(* * イ形容詞イ段特殊 タ形)
#define IAdjBasicForm IAdjBasicBasicForm \
			IAdjTaBasicForm

#define IAdjBasicRenyoForm (* * イ形容詞アウオ段 基本連用形) \
			(* * イ形容詞イ段 基本連用形) \
			(* * イ形容詞イ段特殊 基本連用形)
  
#define IAdjBungoRenyoForm (* * イ形容詞アウオ段 文語連用形) \
			(* * イ形容詞イ段 文語連用形) \
			(* * イ形容詞イ段特殊 文語連用形)

#define NaAdjStem (* * ナ形容詞 語幹) \
			(* * ナ形容詞特殊 語幹) \
			(* * ナノ形容詞 語幹) \
			(* * 助動詞そうだ型 語幹)

#define NaAdjDaBasicBasicForm (* * ナ形容詞 基本形) \
			(* * ナ形容詞特殊 基本形) \
			(* * ナノ形容詞 基本形) \
			(* * 判定詞 基本形)

#define NaAdjBasicForm  (* * * ダ列タ形) \
			(* * * デアル列基本形) \
			(* * * デアル列タ形) \
			(* * * デス列基本形) \
			(* * * デス列タ形) \
			(* * * ヤ列基本形) \
			(* * * ヤ列タ形)

#define NaAdjAllBasicForm  NaAdjBasicForm \
			NaAdjDaBasicBasicForm

; ナ形容詞の連体形 (判定詞は除く)
#define NaAdjDaBasicRentaiForm   (* * ナ形容詞 ダ列基本連体形) \
			(* * ナ形容詞特殊 ダ列基本連体形) \
			(* * ナ形容詞特殊 ダ列特殊連体形) \
			(* * ナノ形容詞 ダ列基本連体形) \
			(* * ナノ形容詞 ダ列特殊連体形)

#define AllNaAdjGuessForm (* * * ダ列基本推量形) \
			(* * * ダ列タ系推量形) \
			(* * * デアル列基本推量形) \
			(* * * デアル列タ系推量形) \
			(* * * デス列基本推量形) \
			(* * * デス列タ系推量形) \
			(* * * ヤ列基本推量形) \
			(* * * ヤ列タ系推量形)

#define AllNaAdjClippedGuessForm (* * * ダ列基本省略推量形) \
			(* * * ダ列タ系省略推量形) \
			(* * * デアル列基本省略推量形) \
			(* * * デアル列タ系省略推量形) \
			(* * * デス列基本省略推量形) \
			(* * * デス列タ系省略推量形) \
			(* * * ヤ列基本省略推量形) \
			(* * * ヤ列タ系省略推量形)

#define BunsetsuTop     (動詞) \
                        (形容詞) \
                        (名詞 普通名詞) \
                        (名詞 時相名詞) \
                        (名詞 サ変名詞) \
                        (未定義語) \
                        (名詞 固有名詞) \
                        (名詞 地名) \
                        (名詞 人名) \
                        (名詞 組織名) \
                        (名詞 数詞) \
                        (指示詞) \
                        (副詞) \
                        (連体詞) \
                        (接頭辞) \
                        (感動詞)

; 接続詞をBunsetsuTopに含めると副作用が大きいので，文頭などを個別指定
; 例)「ついては」「にもかかわらず」「とはいえ」「と同時に」「とすれば」

; 基本形と連体形が同型のもの --- 文末 ○  文節末 ○  形式名詞の前 ○

#define BunsetsuEndSentenceEnd  (動詞 * * 基本形) \
                        (接尾辞 動詞性接尾辞 * 基本形) \
                        (動詞 * * 文語基本形) \
                        (接尾辞 動詞性接尾辞 * 文語基本形) \
                        (* * イ形容詞アウオ段 基本形) \
                        (* * イ形容詞イ段 基本形) \
                        (* * イ形容詞イ段特殊 基本形) \
                        (助動詞 * 助動詞ぬ型 基本形) \
                        (助動詞 * 助動詞ぬ型 音便基本形) \
                        (助動詞 * 助動詞だろう型 基本形) \
                        (* * 動詞性接尾辞うる型 基本形) \
                        (* * * タ形) \
                        (* * * ダ列タ形) \
                        (* * * デアル列基本形) \
                        (* * * デアル列タ形) \
                        (* * * 基本推量形) \
                        (* * * 基本省略推量形) \
                        (助動詞 * 助動詞ぬ型 音便推量形) \
                        (助動詞 * 助動詞ぬ型 音便省略推量形) \
                        (* * * タ系推量形) \
                        (* * * タ系省略推量形) \
                        (* * * ダ列基本推量形) \
                        (* * * ダ列基本省略推量形) \
                        (* * * ダ列タ系推量形) \
                        (* * * ダ列タ系省略推量形) \
                        (* * * デアル列基本推量形) \
                        (* * * デアル列基本省略推量形) \
                        (* * * デアル列タ系推量形) \
                        (* * * デアル列タ系省略推量形) \
                        (* * * デス列基本推量形) \
                        (* * * デス列基本省略推量形) \
                        (* * * デス列タ系推量形) \
                        (* * * デス列タ系省略推量形) \
                        (* * * ヤ列基本推量形) \
                        (* * * ヤ列基本省略推量形) \
                        (* * * ヤ列タ系推量形) \
                        (* * * ヤ列タ系省略推量形)

; 基本形だけ(連体形と別)，命令形など --- 文末 ○  文節末 ×  形式名詞の前 ×
; <注意> ナ形容詞，判定詞，そうだ型，ます型の基本形は文節末とはならない
;       (「静かだ」，「学生だ」，「静かそうだ」，「走ります」など)

#define SentenceEnd     (* * ナ形容詞 基本形) \
                        (* * ナノ形容詞 基本形) \
                        (* * ナ形容詞特殊 基本形) \
                        (* * 判定詞 基本形) \
                        (* * 無活用型 基本形) \
                        (* * 助動詞そうだ型 基本形) \
                        (* * 助動詞く型 基本形) \
                        (* * 動詞性接尾辞ます型 基本形) \
                        (* * * デス列基本形) \
                        (* * * デス列タ形) \
                        (* * * ヤ列基本形) \
                        (* * * ヤ列タ形) \
                        (形容詞 * * 文語基本形) \
                        (* * * 意志形) \
                        (* * * 省略意志形) \
                        (* * * 命令形) \
                        (* * * 文語命令形) \
                        (* * * デアル列命令形) \
                        (助詞 終助詞)
; 文語基本形はサ変動詞「す」，ザ変動詞「ず」，イ形容詞「〜し」

; 連体形だけ(基本形と別) --- 文末 ×  文節末 ○  形式名詞の前 ○
; <注意> 判定詞ダ列基本連体形(「学生な〜」)は文節末とならないので区別 
#define BunsetsuEnd     (* * タル形容詞 基本形) \
                        (* * * 文語連体形) \
                        (* * * ダ列特殊連体形) \
                        (* * ナ形容詞 ダ列基本連体形) \
                        (* * ナノ形容詞 ダ列基本連体形) \
                        (* * * ダ列文語連体形) \
                        (連体詞) \
                        (指示詞 連体詞形態指示詞)

#define AdverbialSuffix (接尾辞 名詞性名詞助数辞) \
                        (接尾辞 名詞性特殊接尾辞) \
                        (接尾辞 名詞性名詞接尾辞 * * 程) \
                        (接尾辞 名詞性名詞接尾辞 * * ほど) \
                        (接尾辞 名詞性名詞接尾辞 * * 間) \
                        (接尾辞 名詞性名詞接尾辞 * * 前) \
                        (接尾辞 名詞性名詞接尾辞 * * 後) \
                        (接尾辞 名詞性名詞接尾辞 * * 前後) \
                        (接尾辞 名詞性名詞接尾辞 * * 程度) \
                        (接尾辞 名詞性名詞接尾辞 * * 頃) \
                        (接尾辞 名詞性名詞接尾辞 * * ころ) \
                        (接尾辞 名詞性名詞接尾辞 * * ごろ) \
                        (接尾辞 名詞性名詞接尾辞 * * ずつ) \
                        (接尾辞 名詞性名詞接尾辞 * * あたり) \
                        (接尾辞 名詞性名詞接尾辞 * * 当たり) \
                        (接尾辞 名詞性名詞接尾辞 * * 当り) \
                        (接尾辞 名詞性名詞接尾辞 * * 辺り) \
                        (接尾辞 名詞性名詞接尾辞 * * 通り) \
                        (接尾辞 名詞性名詞接尾辞 * * どおり) \
                        (接尾辞 名詞性名詞接尾辞 * * 上) \
                        (接尾辞 名詞性名詞接尾辞 * * 中) \
                        (接尾辞 名詞性名詞接尾辞 * * 下) \
                        (接尾辞 名詞性名詞接尾辞 * * 以上) \
                        (接尾辞 名詞性名詞接尾辞 * * 以下) \
                        (接尾辞 名詞性名詞接尾辞 * * 未満) \
                        (接尾辞 名詞性名詞接尾辞 * * 近く) \
                        (接尾辞 名詞性名詞接尾辞 * * ちかく) \
                        (接尾辞 名詞性名詞接尾辞 * * 以外) \
                        (接尾辞 名詞性名詞接尾辞 * * 自体) \
                        (接尾辞 名詞性名詞接尾辞 * * その他)

; 連用形，条件形など --- 文末 △  文節末 ○  形式名詞の前 ×

#define BunsetsuEndSentenceCanEnd       (* * * 基本連用形) \
                        (* * * 基本条件形) \
                        (* * * 音便条件形) \
                        (* * * 音便条件形２) \
                        (* * * 文語条件形) \
                        (* * * 文語音便条件形) \
                        (* * * タ系条件形) \
                        (* * * タ系連用テ形) \
                        (* * * タ系連用タリ形) \
                        (* * * タ系連用チャ形) \
                        (* * * タ系連用チャ形２) \
                        (* * * ダ列基本条件形) \
                        (* * * ダ列文語条件形) \
                        (* * * ダ列基本連用形) \
                        (* * * ダ列特殊連用形) \
                        (* * * ダ列タ系条件形) \
                        (* * * ダ列タ系連用テ形) \
                        (* * * ダ列タ系連用タリ形) \
                        (* * * ダ列タ系連用ジャ形) \
                        (* * * デアル列基本条件形) \
                        (* * * デアル列基本連用形) \
                        (* * * デアル列タ系条件形) \
                        (* * * デアル列タ系連用テ形) \
                        (* * * デアル列タ系連用タリ形) \
                        (* * * デス列タ系条件形) \
                        (* * * デス列タ系連用テ形) \
                        (* * * デス列タ系連用タリ形) \
                        (* * * ヤ列タ系条件形) \
                        (* * * ヤ列タ系連用タリ形) \
                        (副詞) \
                        (名詞 副詞的名詞) \
                        (名詞 時相名詞) \
                        AdverbialSuffix \
                        (指示詞 副詞形態指示詞) \
                        (助詞 格助詞) \
                        (助詞 副助詞) \
                        (助詞 接続助詞) \
                        (接続詞)

#define NominalFollow   (判定詞) \
                        (助詞 格助詞) \
                        (助詞 副助詞) \
                        (助詞 接続助詞 * * の) \
                        (助詞 接続助詞 * * と) \
                        (助詞 接続助詞 * * や) \
                        (助詞 接続助詞 * * および) \
                        (助詞 接続助詞 * * 及び) \
                        (助詞 接続助詞 * * ならびに) \
                        (助詞 接続助詞 * * 並びに) \
                        (助詞 接続助詞 * * も) \
                        (助詞 接続助詞 * * やら) \
                        (助詞 接続助詞 * * だの) \
                        (助詞 接続助詞 * * に) \
                        (助詞 接続助詞 * * か) \
                        (助詞 接続助詞 * * かも) \
                        (助詞 接続助詞 * * なり) \
                        (助詞 接続助詞 * * または) \
                        (助詞 接続助詞 * * 又は) \
                        (助詞 接続助詞 * * また) \
                        (助詞 接続助詞 * * 又) \
                        (助詞 接続助詞 * * かつ) \
                        (助詞 接続助詞 * * かつまた) \
                        (助詞 接続助詞 * * もしくは) \
                        (助詞 接続助詞 * * 若しくは) \
                        (助詞 接続助詞 * * あるいは) \
                        (助詞 接続助詞 * * 或いは) \
                        (助詞 接続助詞 * * ないし) \
                        (助詞 接続助詞 * * 乃至) \
                        (助詞 接続助詞 * * ないしは) \
                        (助詞 接続助詞 * * 乃至は) \
                        (助詞 接続助詞 * * そして) \
                        (助詞 接続助詞 * * それとも) \
		        (助詞 接続助詞 * * ながら) \
                        (助詞 終助詞 * * さ) \
                        (助詞 終助詞 * * さあ) \
                        (助詞 終助詞 * * か) \
                        (助詞 終助詞 * * かしら) \
                        (助詞 終助詞 * * ね) \
                        (助詞 終助詞 * * ネ) \
                        (助詞 終助詞 * * ねえ) \
                        (助詞 終助詞 * * ねぇ) \
                        (助詞 終助詞 * * よ) \
                        (助詞 終助詞 * * ヨ) \
                        (助詞 終助詞 * * やろ) \
                        (助詞 終助詞 * * なあ) \
                        (助詞 終助詞 * * なぁ) \
                        (助詞 終助詞 * * かい) \
                        (助動詞 * イ形容詞イ段 * らしい) \
                        (助動詞 * ナ形容詞 * みたいだ) \
			(接尾辞 名詞性名詞接尾辞)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               優先度の低いペナルティ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 名詞と文節始まりとのペナルティ (以降のペナルティなしのものが優先)
;
; 「嘘言わぬ」(名詞＋動詞)
; 「夜遅い」(名詞＋形容詞)
; 「過去最大だ」(名詞＋形容詞)
; 「書いたの知らなかった」(形式名詞＋動詞)
; 「過去名だたる‥」(名詞＋連体詞)
;
; などのため
;
; <注意> 20にすると実質的ペナルティが40となり，付属語関連の誤りがでる

((BackwardAllNominal)
	(BunsetsuTop)
 30 )

((BackwardAllNominal)		; ○「情報通だ」「過去最大の」「準備不足だったり」
        ((形容詞 * ナ形容詞)	; ×「事業主に」「全米オープンで」「水不足に(苦しむ)」
         (形容詞 * ナ形容詞特殊 語幹)
         (形容詞 * ナノ形容詞))
 20 )

((BackwardNormalNominal)
        ((形容詞 * イ形容詞アウオ段 * よい)	; 「体裁よい」
         (形容詞 * イ形容詞アウオ段 * 良い)	; 「体裁良い」
         (形容詞 * イ形容詞アウオ段 * ない)	; 「問題ない」
         (動詞 * 子音動詞ラ行 * ある)		; 「問題ある」
         (動詞 * 母音動詞 * できる))		; 「プリントアウトできる」
)

(((名詞 形式名詞 * * こと))
        ((形容詞 * イ形容詞アウオ段 * ない))	; 「〜ことなく」
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               文節の外の規則
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((文頭)
  BunsetsuEndSentenceEnd
  BunsetsuEnd
  BunsetsuEndSentenceCanEnd
  (* * * デアル列命令形)		; 「学生であれ〜」
  (動詞 * サ変動詞 命令形 する)		; 「〜にしろ〜」
  (動詞 * サ変動詞 文語命令形 する)	; 「〜にせよ〜」
  (感動詞)
  (特殊 句点)
  (特殊 読点)
  (特殊 括弧始))
	(BunsetsuTop))

((BunsetsuEndSentenceEnd
  BunsetsuEnd
  BunsetsuEndSentenceCanEnd
  (* * * デアル列命令形)		; 「学生であれ〜」
  (動詞 * サ変動詞 命令形 する)		; 「〜にしろ〜」
  (動詞 * サ変動詞 文語命令形 する)	; 「〜にせよ〜」
  (感動詞)
  BackwardAllNominal)
        ((特殊 読点)
	 (特殊 括弧始)))

(((接頭辞 名詞接頭辞 * * 同))		; 2008/8/4
        ((特殊 読点)			; 「同，太郎さん」
	 (特殊 括弧始)))		; 「同「京都センター」」

((SentenceEnd)
        ((特殊 読点))
 20 )

(((文頭)
  BunsetsuEndSentenceEnd
  BunsetsuEnd
  BunsetsuEndSentenceCanEnd
  (* * * デアル列命令形)		; 「学生であれ〜」
  (動詞 * サ変動詞 命令形 する)		; 「〜にしろ〜」
  (動詞 * サ変動詞 文語命令形 する)	; 「〜にせよ〜」
  (感動詞)
  (特殊 句点)
  (特殊 読点)
  (特殊 括弧始)
  BackwardAllNominal)
        ((特殊 括弧始)))

((SentenceEnd)
         ((特殊 括弧始 * * （)
          (特殊 括弧始 * * 〔)
          (特殊 括弧始 * * ［)
          (特殊 括弧始 * * ｛)
          (特殊 括弧始 * * 〈)
          (特殊 括弧始 * * ＜)
          (特殊 括弧始 * * 《)
          (特殊 括弧始 * * 【)))

((BunsetsuEndSentenceEnd
  SentenceEnd
  (感動詞))
        ((特殊 句点)
         (文末)))

((BunsetsuEndSentenceCanEnd
  BackwardAllNominal
  NaAdjStem)
        ((特殊 句点)
         (文末))
 12 ) ; 04/03/20 30 -> 12

((BunsetsuEnd)
        ((特殊 句点)
	 (文末))	; 06/07/16 「馬鹿な．」
 30 )

(((動詞 * サ変動詞 基本連用形 する))
        ((特殊 句点)
	 (文末))	; 06/11/08 「し」で終ることはない
 30 )

(((特殊 括弧始))
         ((文末))
 30 )

(((特殊 句点))          
         ((文末)))

; 句点・読点の連続，読点で終わる文（ブログなどで） 07/09/20

(((特殊 句点))
        ((特殊 句点)))

(((特殊 読点))
        ((特殊 読点)
         (文末)))

; 接続詞はBunsetsuTopには含めず出現を制限

(((文頭)
  (特殊 句点)
  (特殊 読点)
  (助詞 副助詞 * * は)
  (特殊 括弧始))
        ((接続詞)))

(((* * * 基本連用形)
  (* * * タ系連用テ形)
  (* * * ダ列基本連用形)
  (* * * ダ列特殊連用形)
  (* * * ダ列タ系連用テ形)
  (* * * デアル列基本連用形)
  (* * * デアル列タ系連用テ形)
  (* * * デス列タ系連用テ形))
        ((接続詞 * * * しかも)))
; ※ 接続詞のいくつかは接続助詞にも登録したが，「しかも」はしなかった．
; 接続詞は読点の後としているが，「〜でしかも」などは可能．


; 括弧終，空白は透過処理で扱うが，以下は例外的に連接で扱う

; 『(文末表現)」(名詞後接)』  例) 『「美しい」の問題』
; 『(文末表現)」「(文頭表現)』  例) 『「〜書く」「しかし〜」』

((BunsetsuEndSentenceEnd
  SentenceEnd
  (感動詞))
        ((特殊 括弧終))
 5 )

((BunsetsuEnd
  BunsetsuEndSentenceCanEnd
  NaAdjStem)
        ((特殊 括弧終))
 25 )

(((特殊 括弧終))
        (NominalFollow)
 5 )

(((特殊 括弧終))
        ((特殊 括弧始)))

; 括弧終だけ，空白だけの場合

(((文頭))
        ((特殊 括弧終)
         (特殊 空白))
 30 )

(((特殊 括弧終)
  (特殊 空白))
         ((文末))
 30 )

(((* * * 意志形))
	(BunsetsuTop)
 30 )			; 「歩こう会」など

(((助詞 終助詞))
	(BunsetsuTop)
 30 )			; 2011/9/13
			; 「さすが大分だね　大分は最強最強は大分」
			; 「太郎って完全に年だな　スタミナなさすぎ」
			; 「よく作ったものだな我ながら…」
			; 「傑作なんだなこれが」


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               名詞関係
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 連体 ＋ 形式名詞，副詞的名詞

((BunsetsuEndSentenceEnd
  BunsetsuEnd
  (助詞 接続助詞 * * の)
  (助詞 副助詞 * * って)	;「学生ってのは」
  (* * 判定詞 ダ列基本連体形))	;「学生なだけで」
        ((名詞 形式名詞)
         (名詞 副詞的名詞))
)

; 終助詞,接続助詞的な「もの」は判定詞基本形にも続く
; 「子どもだもの，できないわ」「田舎なんだもん」

(((* * 判定詞 基本形)
  (* * ナ形容詞 基本形)
  (* * ナノ形容詞 基本形)
  (* * ナ形容詞特殊 基本形))
        ((名詞 形式名詞 * * もの)
         (名詞 形式名詞 * * もん))
)

; 副詞的名詞の例外

(((助詞 接続助詞 * * が))
        ((名詞 副詞的名詞 * * ため)	; 「書いたがため(に)」
         (名詞 副詞的名詞 * * 為)
 	 (名詞 副詞的名詞 * * あまり)	; 「書くがあまり」
 	 (名詞 副詞的名詞 * * ゆえ)
         (名詞 副詞的名詞 * * 故))
)

; 判定詞 ダ列基本連体形 ＋ BunsetsuTop
; ※ 07/07/20
;    判定詞ダ列基本連体形はBunsetsuEndに入れておらず
;    ここでペナルティをつけて許す
;    例) 「フォーマルな(未知語のナ形容詞)」「お困りな様子」「初めてなものですから」

(((* * 判定詞 ダ列基本連体形))
        (BunsetsuTop)
 70 )

; 複合名詞

((BackwardNormalNominal)
        ((名詞 普通名詞)
         (名詞 時相名詞)
         (名詞 サ変名詞)
         (未定義語)
         (名詞 固有名詞)
         (名詞 地名)
         (名詞 人名)
         (名詞 組織名)
         (名詞 数詞)
         ; (接頭辞 名詞接頭辞)            ; 「学生約三人」
	 (接頭辞)
         (形容詞 * ナ形容詞 語幹)
         (形容詞 * ナ形容詞特殊 語幹)
         (形容詞 * ナノ形容詞 語幹))
)

; サ変名詞

(((名詞 サ変名詞)
  (未定義語)
  (接尾辞 名詞性名詞接尾辞 * * 化)
  (接尾辞 名詞性名詞助数辞 * * 倍)
  (接尾辞 名詞性名詞助数辞 * * 戦)
  (接尾辞 名詞性名詞助数辞 * * 勝)
  (接尾辞 名詞性名詞助数辞 * * 敗)
  (接尾辞 名詞性名詞助数辞 * * 泊)
  (接尾辞 名詞性名詞接尾辞 * * 入り)	; 追加 95/12/04 yamaji
  (接尾辞 名詞性名詞接尾辞 * * あけ))	; 追加 95/12/04 yamaji
        ((動詞 * サ変動詞 * する)
         (動詞 * 母音動詞 * できる)
         (動詞 * 母音動詞 * 出来る)
         (動詞 * 子音動詞サ行 * いたす)	; 「〜いたします」
         (動詞 * 子音動詞サ行 * 致す)
         (形容詞 * ナ形容詞 * 可能だ)
         (形容詞 * ナ形容詞 * 不可能だ))
 5 )

(((名詞 サ変名詞)
  (名詞 普通名詞 * * 御覧)
  (名詞 普通名詞 * * ご覧)
  (名詞 普通名詞 * * ごらん))
        ((動詞 * 子音動詞ラ行イ形 * 下さる)
         (動詞 * 子音動詞ラ行イ形 * くださる)))

; 特別

(((* * * 意志形))
        ((名詞 形式名詞 * * もの)		; 「しようものなら」
         (名詞 形式名詞 * * もん)))		; 「しようものなら」

((BackwardNormalNominal
 (名詞 形式名詞))
        ((名詞 時相名詞))       ; 「今日午前」
)

((NormalNominal
 (接尾辞 名詞性名詞助数辞)
 (接尾辞 名詞性特殊接尾辞)
 (名詞 形式名詞))
        ((副詞))                 ; 「周囲わずか」
)
; 数詞＋副詞は許さない

(((指示詞 名詞形態指示詞 * * ここ))
        ((副詞)                  ; 「ここ数日」
         (名詞 時相名詞))
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               その他
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((接尾辞 名詞性名詞接尾辞 * * 的))
        ((形容詞))              ; 「比較的簡単な、意味的曖昧さ」
)

(((連体詞 * * * 何たる)
  (連体詞 * * * なんたる))
        ((助詞 接続助詞 * * か))
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               文節の内部の規則
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               記号
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((特殊 記号))
        (BunsetsuTop
         NominalFollow
	 (特殊)
	 (文末)))

((BunsetsuEndSentenceEnd
  BunsetsuEnd
  BunsetsuEndSentenceCanEnd
  SentenceEnd
  BackwardAllNominal
  (感動詞)
  (特殊)
  (文頭)
  (特殊 括弧始))
        ((特殊 記号)))

(((特殊 記号 * * ・))
        ((接尾辞 名詞性名詞接尾辞))
 0 )

(((接頭辞 名詞接頭辞 * * 準))
        ((特殊 記号 * * 々)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 判定詞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((特殊 読点))
	((判定詞))
 30 )

((BackwardAllNominal)
        ((判定詞)))

(((助動詞 * 助動詞ぬ型 音便基本形))             ; 「ませんでした」
        ((判定詞 * 判定詞 デス列タ形)))         ; kuro 93/10/21

(((* * * タ系連用テ形)                          ; 「ついてだ」「座ってだ」
  (* * * 基本条件形) 				; 06/0/16 「書ければです」
  (* * * タ系条件形))				; 06/0/16 「書けたらです」
        ((判定詞)))                             ; kuro 96/05/08

(((助詞 格助詞 * * まで)
  (助詞 格助詞 * * から)        ; 「体験からだ」
  (助詞 副助詞 * * だけ)        ; 「だけです」
  (助詞 副助詞 * * ばかり)      ; 「ばかりだ」
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * くらい)	; 「彼くらいだ」
  (助詞 副助詞 * * ぐらい)	; 「彼ぐらいです」
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * も)		; 「ミルクもです」
  (助詞 接続助詞 * * か)	; 「どっちかで」
  (助詞 接続助詞 * * から)	; 「書くからだ」
  (助詞 接続助詞 * * か)	; 「書くかだ」
  (助詞 接続助詞 * * の))	; 「彼のだ」
         ((判定詞)))

(((助動詞 * ナ形容詞 ダ列基本連用形 のだ))	; 「〜のにである」
        ((判定詞)))                             ; kuro 00/06/13

; 「〜どころ(副助詞)」は「で(は/も)ない」「じゃ」だけが続くので連語で扱う


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               接頭辞 ＋ ＊
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((接頭辞 名詞接頭辞))
        ((名詞 普通名詞)
         (名詞 時相名詞)
         (名詞 サ変名詞)
         (未定義語)
         (名詞 数詞)))

; 2006/01/28 「本好き」「本嫌い」「名でよく知られている」「中に詰め」など
; の解析誤りとなるので名詞接頭辞と動詞基本連用形の接続は下のものだけに制限

(((接頭辞 名詞接頭辞 * * 御)
  (接頭辞 名詞接頭辞 * * お)	; 「お手伝い」「お勧め」「お知らせ」
  (接頭辞 名詞接頭辞 * * 大)	; 「大揺れ」「大違い」
  (接頭辞 名詞接頭辞 * * おお)	;
  (接頭辞 名詞接頭辞 * * 初)	; 「初生け」「初釣り」
  (接頭辞 名詞接頭辞 * * 総)	; 「総売り上げ」
  (接頭辞 名詞接頭辞 * * ひと))	; 「ひと暴れ」「ひと押し」
        ((動詞 * * 基本連用形)))

(((接頭辞 名詞接頭辞 * * ご)	; 「ごゆっくり」「ご都合」など
  (接頭辞 名詞接頭辞 * * 御)
  (接頭辞 名詞接頭辞 * * お))	; 「おあいにく」「お独り」ぐらい
        ((副詞)
         (動詞 * * 基本連用形))); 「お手伝い」「お勧め」「お知らせ」

(((接頭辞 名詞接頭辞 * * 元)	; 「元副大統領」
  (接頭辞 名詞接頭辞 * * 前)	; 「前副社長」
  (接頭辞 名詞接頭辞 * * 超))	; 「超低所得」
        ((接頭辞 名詞接頭辞)))

(((接頭辞 名詞接頭辞 * * まる))
        ((名詞 普通名詞)
         (名詞 時相名詞)
         (名詞 サ変名詞)
         (未定義語)
         (動詞 * * 基本連用形))
 0 )
	; 「まる」は数詞だけに接続
	; 「約」は「半分」,「半数」,「半月」,「半年」などがあるので
	; とりあえず数詞以外も許しておく

(((接頭辞 名詞接頭辞 * * 全)	; 「全日本」,「全豪州」
  (接頭辞 名詞接頭辞 * * 前)	; 「前アメリカ大統領」
  (接頭辞 名詞接頭辞 * * 元))	; 「元アメリカ大統領」
        ((名詞 地名)
         (名詞 組織名)
         (名詞 固有名詞))
 6 )
    ; 「全日本大学」,「レーガン前アメリカ大統領」などを正しく解析

(((接頭辞 名詞接頭辞 * * 故))	; 「故ニクソン」
        ((名詞 人名)
         (名詞 固有名詞)
         (特殊 記号 * * ・)))

(((接頭辞 名詞接頭辞 * * 同))	; 「同大阪本社」
        ((名詞 地名)))

(((接頭辞 名詞接頭辞 * * お))	; 「お 待た せ する」
        ((動詞 * * 未然形)))

(((接頭辞 名詞接頭辞 * * 真っ)
  (接頭辞 名詞接頭辞 * * まっ))
        ((名詞 副詞的名詞 * * 最中)
         (名詞 副詞的名詞 * * さいちゅう)))

(((接頭辞 動詞接頭辞))
        ((動詞))
)

(((接頭辞 イ形容詞接頭辞))
        ((形容詞 * イ形容詞アウオ段)
         (形容詞 * イ形容詞イ段)
         (形容詞 * イ形容詞イ段特殊))
)

(((接頭辞 ナ形容詞接頭辞))
        ((形容詞 * ナ形容詞)
         (形容詞 * ナ形容詞特殊)
         (形容詞 * ナノ形容詞))
)

(((接頭辞 ナ形容詞接頭辞))
        ((名詞 普通名詞)
         (名詞 時相名詞)
         (名詞 サ変名詞)
         (副詞)		; 「非公然」
         (未定義語))
 11 )

(((接頭辞 ナ形容詞接頭辞))
        ((名詞 地名)
         (名詞 人名)
    	 (名詞 組織名))	; 「非自民」
 12 )
; ※ 優先規則的にweightを与えたが，やりすぎかも


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 動詞性接尾辞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((動詞 * 子音動詞カ行 未然形)
  (動詞 * 子音動詞カ行促音便形 未然形)
  (動詞 * 子音動詞ガ行 未然形)
  (動詞 * 子音動詞サ行 未然形)
  (動詞 * 子音動詞タ行 未然形)
  (動詞 * 子音動詞ナ行 未然形)
  (動詞 * 子音動詞バ行 未然形)
  (動詞 * 子音動詞マ行 未然形)
  (動詞 * 子音動詞ラ行 未然形)
  (動詞 * 子音動詞ラ行イ形 未然形)
  (動詞 * 子音動詞ワ行 未然形)
  (動詞 * 子音動詞ワ行文語音便形 未然形)
  (動詞 * サ変動詞 未然形)
  (接尾辞 動詞性接尾辞 子音動詞カ行 未然形)
  (接尾辞 動詞性接尾辞 子音動詞カ行促音便形 未然形)
  (接尾辞 動詞性接尾辞 子音動詞サ行 未然形)
  (接尾辞 動詞性接尾辞 子音動詞ラ行 未然形)
  (接尾辞 動詞性接尾辞 子音動詞ラ行イ形 未然形)
  (接尾辞 動詞性接尾辞 子音動詞ワ行 未然形)
  (接尾辞 動詞性接尾辞 サ変動詞 未然形))
        ((接尾辞 動詞性接尾辞 母音動詞 * れる)
         (接尾辞 動詞性接尾辞 母音動詞 * せる)
         (接尾辞 動詞性接尾辞 子音動詞サ行 * す))
 5 )

(((動詞 * 母音動詞   未然形)
  (動詞 * カ変動詞   未然形)
  (動詞 * カ変動詞来 未然形)
  (動詞 * サ変動詞   文語未然形)
  (動詞 * ザ変動詞   文語未然形)
  (接尾辞 動詞性接尾辞 母音動詞 未然形)
  (接尾辞 動詞性接尾辞 カ変動詞 未然形)
  (接尾辞 動詞性接尾辞 カ変動詞来 未然形))
        ((接尾辞 動詞性接尾辞 母音動詞 * れる)		;「見れる」など
         (接尾辞 動詞性接尾辞 母音動詞 * られる)
         (接尾辞 動詞性接尾辞 母音動詞 * させる)
         (接尾辞 動詞性接尾辞 子音動詞サ行 * さす))
 5 )

(((動詞 * * タ系連用テ形)
  (接尾辞 動詞性接尾辞 * タ系連用テ形))
        ((接尾辞 動詞性接尾辞 母音動詞 * られる)	;「書いてられる」
         (接尾辞 動詞性接尾辞 母音動詞 * れる)))	;「書いてれる」

(((動詞 * 子音動詞カ行 未然形)		; 「書かしめる」
  (動詞 * 子音動詞カ行促音便形 未然形)
  (動詞 * 子音動詞ガ行 未然形)
  (動詞 * 子音動詞サ行 未然形)
  (動詞 * 子音動詞タ行 未然形)
  (動詞 * 子音動詞ナ行 未然形)
  (動詞 * 子音動詞バ行 未然形)
  (動詞 * 子音動詞マ行 未然形)
  (動詞 * 子音動詞ラ行 未然形)
  (動詞 * 子音動詞ワ行 未然形)
  (動詞 * 子音動詞ワ行文語音便形 未然形)
  (動詞 * サ変動詞 文語未然形))		; 「せしめる」
        ((接尾辞 動詞性接尾辞 母音動詞 * しめる)))

(((動詞 * * タ系連用テ形)
  (接尾辞 動詞性接尾辞 * タ系連用テ形)
  (助動詞 * 助動詞ぬ型 タ系連用テ形))
        ((接尾辞 動詞性接尾辞 母音動詞 * いる)
         (接尾辞 動詞性接尾辞 母音動詞 * る)
         (接尾辞 動詞性接尾辞 母音動詞 * みる)
         (接尾辞 動詞性接尾辞 カ変動詞 * くる)
         (接尾辞 動詞性接尾辞 カ変動詞来 * 来る)
         (接尾辞 動詞性接尾辞 子音動詞カ行 * おく)
         (接尾辞 動詞性接尾辞 母音動詞 * おける)
         (接尾辞 動詞性接尾辞 子音動詞ラ行 * ある)
         (接尾辞 動詞性接尾辞 子音動詞ラ行 * おる)
         (接尾辞 動詞性接尾辞 子音動詞ラ行 * 居る)
         (接尾辞 動詞性接尾辞 子音動詞カ行促音便形 * いく)
         (接尾辞 動詞性接尾辞 母音動詞 * いける)
         (接尾辞 動詞性接尾辞 母音動詞 * くれる)
         (接尾辞 動詞性接尾辞 子音動詞ワ行 * もらう)
         (接尾辞 動詞性接尾辞 母音動詞 * もらえる)
         (接尾辞 動詞性接尾辞 子音動詞ワ行 * しまう)
         (接尾辞 動詞性接尾辞 母音動詞 * しまえる)
         (接尾辞 動詞性接尾辞 子音動詞ラ行イ形 * 下さる)
         (接尾辞 動詞性接尾辞 子音動詞ラ行イ形 * くださる))
)

(((動詞 * * タ系連用チャ形))			; 06/01/12 「しちゃいない」
	((接尾辞 動詞性接尾辞 母音動詞 * いる))
 11 )
; 「しちゃいます」「しちゃいな」の「い」は接尾辞「う」なので，
; そこで「いる」と多義にならないようにコストを与える
  
((IAdjBasicRenyoForm
  (* * * ダ列基本連用形)
  (* * タル形容詞 基本連用形))	; 「悠々とする」
        ((接尾辞 動詞性接尾辞 サ変動詞 * する)
         (接尾辞 動詞性接尾辞 子音動詞ラ行 * なる)
         (接尾辞 動詞性接尾辞 母音動詞 * なれる)))

(((* * * タ系連用タリ形)	; 「書いたりする」,「美しかったり」
  (* * * ダ列タ系連用タリ形)	; 「静かだったりする」
  (* * * デアル列タ系連用タリ形); 「静かであったりする」
  (* * * デス列タ系連用タリ形)	; 「静かでしたりする」
  (* * * ヤ列タ系連用タリ形))	; 「静かやったりする」
        ((接尾辞 動詞性接尾辞 サ変動詞 * する)))   ; Kuro 96/05/08

(((動詞 * * タ系連用テ形)		; 「書いてございます」
  (接尾辞 動詞性接尾辞 * タ系連用テ形)	; 「書かされてございます」
  IAdjBungoRenyoForm		; 「おいしゅうございます」
  (* * * ダ列タ系連用テ形)	; 「静かでございます」
  (* * * ダ列タ系連用ジャ形)	; 「静かじゃございませんか」
  (感動詞 * * * ありがとう)	; 「ありがとうございます/した」
  (感動詞 * * * おめでとう)	; 「おめでとうございます/した」
  (感動詞 * * * おはよう))	; 「おはようございます」
        ((接尾辞 動詞性接尾辞 動詞性接尾辞ます型 * 御座います)
         (接尾辞 動詞性接尾辞 動詞性接尾辞ます型 * ございます)))

; 「でもある」と同様に「でもございます」などがありえるが，とりあえず無視．

((IAdjBungoRenyoForm)		; 「おいしゅうぞんじます」
        ((接尾辞 動詞性接尾辞 動詞性接尾辞ます型 * 存じます)
         (接尾辞 動詞性接尾辞 動詞性接尾辞ます型 * ぞんじます)))

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (* * * デアル列基本連用形))			; 「〜でありうる」
        ((接尾辞 動詞性接尾辞 母音動詞 * える)
         (接尾辞 動詞性接尾辞 母音動詞 * 得る)
         (接尾辞 動詞性接尾辞 動詞性接尾辞うる型 * うる)))

(((接尾辞 動詞性接尾辞 * 基本連用形))		; 「書いていえる」禁止
        ((接尾辞 動詞性接尾辞 母音動詞 * える)
         (接尾辞 動詞性接尾辞 母音動詞 * 得る)
         (接尾辞 動詞性接尾辞 動詞性接尾辞うる型 * うる))
 0 )

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)

  (動詞 * 子音動詞ラ行イ形 命令形)	; 「下さいます」
  (接尾辞 動詞性接尾辞 子音動詞ラ行イ形 命令形)
					; 「書いて下さいます」	

  (動詞 * * タ系連用テ形)		; 「書いてます」	
  (接尾辞 動詞性接尾辞 * タ系連用テ形)	; 「書かされてます」	

  (* * * デアル列基本連用形))		; 「〜であります」
        ((接尾辞 動詞性接尾辞 動詞性接尾辞ます型 * ます)
         (接尾辞 動詞性接尾辞 子音動詞ラ行イ形 * なさる)))

(((* * 子音動詞ラ行イ形 命令形))        ; 「下さいます」,「なさいます」
        ((接尾辞 動詞性接尾辞 動詞性接尾辞ます型 * ます)))

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形))
        ((接尾辞 動詞性接尾辞 子音動詞ラ行 * かかる)
         (接尾辞 動詞性接尾辞 子音動詞ラ行 * 掛かる)
         (接尾辞 動詞性接尾辞 子音動詞ラ行 * 掛る)
         (接尾辞 動詞性接尾辞 母音動詞 * かける)
         (接尾辞 動詞性接尾辞 母音動詞 * 掛ける)
         (接尾辞 動詞性接尾辞 母音動詞 * かねる)	   ; 96/01/24
         (接尾辞 動詞性接尾辞 母音動詞 * 兼ねる)
         (接尾辞 動詞性接尾辞 子音動詞マ行 * あぐむ)	   ; 02/09/30
         (接尾辞 動詞性接尾辞 母音動詞 * あぐねる)
         (接尾辞 動詞性接尾辞 母音動詞 * そびれる))
)                                           

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (形容詞 * * 語幹)
  (接尾辞 形容詞性述語接尾辞 * 語幹)
  (接尾辞 形容詞性名詞接尾辞 * 語幹))
        ((接尾辞 動詞性接尾辞 母音動詞 * すぎる)
         (接尾辞 動詞性接尾辞 母音動詞 * 過ぎる))       ; 95/11/19 
)

(((形容詞 * イ形容詞アウオ段 語幹)
  (形容詞 * イ形容詞イ段 語幹)
  (形容詞 * イ形容詞イ段特殊 語幹)
  (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 語幹)
  (接尾辞 形容詞性名詞接尾辞 イ形容詞アウオ段 語幹)
  NaAdjStem)						; 「残念がる」「不思議がる」
        ((接尾辞 動詞性接尾辞 子音動詞ラ行 * がる))
)

;(((名詞 普通名詞)
;  (名詞 時相名詞)
;  (名詞 サ変名詞)
;  (未定義語)
;  (名詞 固有名詞)
;  (名詞 地名)
;  (名詞 人名)
;  (名詞 組織名))
;        ((接尾辞 動詞性接尾辞 子音動詞カ行 * めく))     ; 「圧力めいた…」
;)

((BackwardNormalNominal)
        ((接尾辞 動詞性接尾辞 子音動詞カ行 * めく)     ; 「圧力めく」
         (接尾辞 動詞性接尾辞 子音動詞ラ行 * がかる)   ; 「芝居がかる」「青味がかる」
         (接尾辞 動詞性接尾辞 母音動詞 * じみる)       ; 「世帯じみる」
         (接尾辞 動詞性接尾辞 母音動詞 * 染みる))
)

(((動詞 * * タ系連用チャ形)
  (接尾辞 動詞性接尾辞 * タ系連用チャ形))
        ((接尾辞 動詞性接尾辞 子音動詞ワ行 * う)))

(((* * 母音動詞 タ接連用形)
  (* * 子音動詞カ行 タ接連用形)
  (* * 子音動詞カ行促音便形 タ接連用形)
  (* * 子音動詞サ行 タ接連用形)
  (* * 子音動詞タ行 タ接連用形)
  (* * 子音動詞ラ行 タ接連用形)
  (* * 子音動詞ラ行イ形 タ接連用形)
  (* * 子音動詞ワ行 タ接連用形)
  (* * 子音動詞ワ行文語音便形 タ接連用形)
  (* * カ変動詞 タ接連用形)
  (* * カ変動詞来 タ接連用形)
  (* * サ変動詞 タ接連用形)
  (* * ザ変動詞 タ接連用形))
        ((接尾辞 動詞性接尾辞 子音動詞カ行 * とく)
         (接尾辞 動詞性接尾辞 子音動詞ワ行 * ちまう)))

(((* * 子音動詞ガ行 タ接連用形)
  (* * 子音動詞ナ行 タ接連用形)
  (* * 子音動詞バ行 タ接連用形)
  (* * 子音動詞マ行 タ接連用形))
        ((接尾辞 動詞性接尾辞 子音動詞カ行 * どく)
         (接尾辞 動詞性接尾辞 子音動詞ワ行 * じまう)))

(((動詞 * * 基本連用形)			; 「書きやがる」
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (動詞 * * タ系連用テ形)		; 「書いてやがる」
  (接尾辞 動詞性接尾辞 * タ系連用テ形))
	((接尾辞 動詞性接尾辞 子音動詞ラ行 * やがる)))	; 06/07/16

;  06/07/20 「ダフる」「サチる」
(((未定義語))
	((接尾辞 動詞性接尾辞 子音動詞ラ行 * る))
)
;((NormalNominal)
;	((接尾辞 動詞性接尾辞 子音動詞ラ行 * る))
; 100 )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 形容詞性接尾辞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

((BackwardNormalNominal)
        ((接尾辞 形容詞性名詞接尾辞))
)

((VerbBasicForm)						; 09/06/01
        ((接尾辞 形容詞性名詞接尾辞 イ形容詞アウオ段 * っぽい))	; 口語「やるっぽい」
)


; 形容詞性述語接尾辞全体だったが，「ない」は特別なので区別 96/04/17 Kuro
(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形))
        ((接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * たい)
         (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * やすい)
         (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * 易い)
         (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * よい)
         (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * にくい)
         (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * がたい)
         (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * 難い)
         (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * づらい)
         (接尾辞 形容詞性述語接尾辞 ナノ形容詞 * がちだ)
         (接尾辞 形容詞性述語接尾辞 ナノ形容詞 * 気味だ)
         (接尾辞 形容詞性述語接尾辞 ナノ形容詞 * ぎみだ)
         (接尾辞 形容詞性述語接尾辞 ナ形容詞 * そうだ))
)

(((動詞 * * タ系連用テ形)
  (接尾辞 動詞性接尾辞 * タ系連用テ形))				; 09/06/01
 	((接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * たい)	; 口語「見てたい」
;        (接尾辞 形容詞性述語接尾辞 ナ形容詞 * そうだ)		; 口語「見てそうだ」
;         ※これを許すと「果たしてそうだろうか」を誤る
        )
)


(((形容詞 * * 語幹)			; 「元気そうだ」
  (接尾辞 形容詞性述語接尾辞 * 語幹)
  (接尾辞 形容詞性名詞接尾辞 * 語幹)
  (接尾辞 名詞性述語接尾辞 * * さ))	; 「なさそうだ」 kuro 01/01/17
  					; 連語にすると，「ではない」等の
  					; 他の連語との重なりが問題になる．
  					; 「さそうだ」でも副作用はない．
        ((接尾辞 形容詞性述語接尾辞 ナ形容詞 * そうだ))
)

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (形容詞 * * 語幹)
  (接尾辞 形容詞性述語接尾辞 * 語幹)
  (接尾辞 形容詞性名詞接尾辞 * 語幹)
  (接尾辞 名詞性述語接尾辞 * * さ))
        ((接尾辞 形容詞性述語接尾辞 ナ形容詞 ダ列文語連体形 そうだ)) 「にそうなる〜」
 50 )

(((動詞 * 母音動詞 未然形)
  (動詞 * カ変動詞 未然形)
  (動詞 * カ変動詞来 未然形)
  (動詞 * 子音動詞カ行 未然形)
  (動詞 * 子音動詞カ行促音便形 未然形)
  (動詞 * 子音動詞ガ行 未然形)
  (動詞 * 子音動詞サ行 未然形)
  (動詞 * 子音動詞タ行 未然形)
  (動詞 * 子音動詞ナ行 未然形)
  (動詞 * 子音動詞バ行 未然形)
  (動詞 * 子音動詞マ行 未然形)
  (動詞 * 子音動詞ラ行 未然形)
  (動詞 * 子音動詞ラ行イ形 未然形)
  (動詞 * 子音動詞ワ行 未然形)
  (動詞 * 子音動詞ワ行文語音便形 未然形)
  (動詞 * サ変動詞 基本連用形)          ; サ変は未然形ではない
  (接尾辞 動詞性接尾辞 母音動詞 未然形) ; Kuro 動詞性接尾辞にあわせて追加
  (接尾辞 動詞性接尾辞 子音動詞カ行 未然形)
  (接尾辞 動詞性接尾辞 子音動詞カ行促音便形 未然形)
  (接尾辞 動詞性接尾辞 子音動詞サ行 未然形)
  (接尾辞 動詞性接尾辞 子音動詞ラ行 未然形)
  (接尾辞 動詞性接尾辞 子音動詞ワ行 未然形)
  (接尾辞 動詞性接尾辞 カ変動詞 未然形)
  (接尾辞 動詞性接尾辞 カ変動詞来 未然形)
  (接尾辞 動詞性接尾辞 サ変動詞 基本連用形)     ; サ変は未然形ではない
  ; 動詞性接尾辞ます型 とはつながらない
  IAdjBasicRenyoForm
  (* * * ダ列タ系連用テ形) 
  (接尾辞 形容詞性述語接尾辞 ナ形容詞 ダ列基本連用形 そうだ) ; 「〜そうにない」
  (* * * ダ列タ系連用ジャ形)

  (* * * ヤ列基本形)			; 「学生やない」

  (動詞 * * タ系連用テ形)		; 「似てない」
  (接尾辞 動詞性接尾辞 * タ系連用テ形)	; 「読まされてない」

  (接尾辞 名詞性述語接尾辞 * * っこ))	; 「できっこない」「解けっこない」

        ((接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 * ない))
)

(((形容詞 * * 語幹)
  (接尾辞 形容詞性述語接尾辞 * 語幹)
  (接尾辞 形容詞性名詞接尾辞 * 語幹))
	((接尾辞 形容詞性述語接尾辞 ナノ形容詞 * めだ)   ; 02/11/01「少なめだ」
	 (接尾辞 形容詞性述語接尾辞 ナノ形容詞 * 目だ))) ; 06/07/15「少な目だ」

(((形容詞 * イ形容詞アウオ段 語幹)
  (形容詞 * イ形容詞イ段 語幹)
  (形容詞 * イ形容詞イ段特殊 語幹))
	((接尾辞 形容詞性述語接尾辞 ナノ形容詞 * めだ))
 2 )
; ※ 「薄め(動詞連用形)に刻む」「太め(名詞)に刻む」に勝つため

(((接尾辞 形容詞性述語接尾辞 ナノ形容詞 * 目だ))
    	((接尾辞 形容詞性名詞接尾辞 ナ形容詞 * 的だ))
 0 )
; ※ 06/07/18 「目的だ」の解析誤りを防ぐ


(((形容詞 * イ形容詞アウオ段 語幹)
  (形容詞 * イ形容詞イ段 語幹)
  (形容詞 * イ形容詞イ段特殊 語幹)
  (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 語幹)
  (接尾辞 形容詞性名詞接尾辞 イ形容詞アウオ段 語幹))
        ((接尾辞 形容詞性述語接尾辞 ナノ形容詞 * 気だ)
         (接尾辞 形容詞性述語接尾辞 ナノ形容詞 * げだ))
)

; 07/03/05 「ナウい」「ウザい」
((BackwardNormalNominal)
	((接尾辞 形容詞性名詞接尾辞 イ形容詞アウオ段 * い))
 0 )
(((未定義語))
	((接尾辞 形容詞性名詞接尾辞 イ形容詞アウオ段 * い))
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 名詞性名詞接尾辞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

((BackwardNormalNominal)
        ((接尾辞 名詞性名詞接尾辞)))

(((副詞))                        	; ただし，副詞には原則としてつかない
        ((接尾辞 名詞性名詞接尾辞))	; 例外的につくものは連語で扱う
 0 )

; ※ 基本連用形と名詞性名詞接尾辞の制限は優先規則のところで扱う


; 例外

(((助詞 副助詞 * * など))
        ((接尾辞 名詞性名詞接尾辞 * * 以外)))

(((名詞 形式名詞 * * こと)
  (助詞 * * * か))
        ((接尾辞 名詞性名詞接尾辞 * * 自体)))

(((助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位))
       ((接尾辞 名詞性名詞接尾辞 * * ずつ)))	; 06/07/16 「七日ぐらいずつ」

(((指示詞 名詞形態指示詞))		; 「あれども」は動詞＋助詞
        ((接尾辞 名詞性名詞接尾辞 * * ども))
 0 )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 名詞性名詞助数辞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 原則として数詞に続く．
; 助数辞の連続を単純に認めると，「日 本」「条 項」などが助数辞となり問題

(((名詞 数詞))
        ((接尾辞 名詞性名詞助数辞))
 5 )

(((接尾辞 名詞性名詞助数辞)
  (接尾辞 名詞性特殊接尾辞 * * 半)
  (名詞 普通名詞 * * 半数)
  (名詞 普通名詞 * * 半分)
  (名詞 時相名詞 * * 半日)
  (名詞 時相名詞 * * 半月)
  (名詞 時相名詞 * * 半年))
        ((接尾辞 名詞性名詞助数辞 * * 台)
         (接尾辞 名詞性名詞助数辞 * * 号)       ; 「３月号」,「１２号」
         (接尾辞 名詞性名詞助数辞 * * 連続)	; 「３連続」,「３回連続」
         (接尾辞 名詞性名詞助数辞 * * 分)	; 「３分」,「３回分」
         (接尾辞 名詞性名詞助数辞 * * 単位)	; 「３単位」,「３個単位」
         (接尾辞 名詞性名詞助数辞 * * 余り)	; 「３余り」,「３個余り」
         (接尾辞 名詞性名詞助数辞 * * 余)
         (接尾辞 名詞性名詞助数辞 * * あまり)))

(((名詞 サ変名詞)                               ; 「遭遇時」等
  (未定義語))
        ((接尾辞 名詞性名詞助数辞 * * 時)))

; ※「好天(普通名詞)時」は解析できないが，一般に普通名詞につけていいか
; どうかわからない
; 「来(普通名詞)日(地名)時」も「来日」がサ変でなくなったのでダメ

(((名詞 普通名詞 * * 最多))                              ; 「最多勝」
        ((接尾辞 名詞性名詞助数辞 * * 勝)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 名詞性特殊接尾辞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 名詞性特殊接尾辞は単純に名詞・数詞に続くわけではないもの．以下に個別指定

(((接尾辞 名詞性名詞助数辞)
  (名詞 普通名詞 * * 半数)
  (名詞 普通名詞 * * 半分)
  (名詞 時相名詞 * * 半日)
  (名詞 時相名詞 * * 半月)
  (名詞 時相名詞 * * 半年))
        ((接尾辞 名詞性特殊接尾辞 * * 超)       ;「三〇〇ドル超」
         (接尾辞 名詞性特殊接尾辞 * * 以内)     ;「三回以内」「３時間以内」
         (接尾辞 名詞性特殊接尾辞 * * 半)     	;「三時半」
         (接尾辞 名詞性特殊接尾辞 * * 強)	;「三回強」
         (接尾辞 名詞性特殊接尾辞 * * 弱)       ;「三％弱」
         (接尾辞 名詞性特殊接尾辞 * * 増)       ;「３％増」
         (接尾辞 名詞性特殊接尾辞 * * 減)       ;「３％減」
         (接尾辞 名詞性特殊接尾辞 * * がかり))) ;「３人がかり」「３日がかり」

(((接尾辞 名詞性名詞助数辞)      
  (名詞 時相名詞))
        ((接尾辞 名詞性特殊接尾辞 * * 限り)))	;「三回限り」

(((接尾辞 名詞性名詞助数辞 * * 年度)
  (接尾辞 名詞性名詞助数辞 * * 年)
  (接尾辞 名詞性名詞助数辞 * * 月)
  (名詞  時相名詞))
        ((接尾辞 名詞性特殊接尾辞 * * 暮れ)))	;「一二月暮れ」

(((接尾辞 名詞性名詞助数辞 * * 世紀)
  (接尾辞 名詞性名詞助数辞 * * 年)
  (接尾辞 名詞性名詞助数辞 * * 年度)
  (接尾辞 名詞性名詞助数辞 * * 月)		;「３月末」
  (接尾辞 名詞性名詞助数辞 * * 週)
  (名詞  時相名詞))			        ;「月末」
        ((接尾辞 名詞性特殊接尾辞 * * 末)))	; kuro 03/10/05

(((接尾辞 名詞性名詞助数辞 * * 日)		;「３日付」
  (名詞 時相名詞 * * 元日))			;「元日付」
        ((接尾辞 名詞性特殊接尾辞 * * 付)))	; kuro 01/11/08

(((名詞 数詞)
  (接尾辞 名詞性名詞助数辞 * * 世紀)    
  (接尾辞 名詞性名詞助数辞 * * 年)
  (接尾辞 名詞性名詞助数辞 * * 年度)
  (接尾辞 名詞性名詞助数辞 * * 月)      
  (接尾辞 名詞性名詞助数辞 * * 週)
  (接尾辞 名詞性名詞助数辞 * * 日)      
  (接尾辞 名詞性名詞助数辞 * * 時)
  (接尾辞 名詞性名詞助数辞 * * 分)      
  (接尾辞 名詞性名詞助数辞 * * 秒)      
  (接尾辞 名詞性名詞助数辞 * * キロ)	; マラソン特別？「１０キロ過ぎに」など
  (名詞 時相名詞))
        ((接尾辞 名詞性特殊接尾辞 * * 過ぎ)  ;「一九九五年過ぎ」「３０過ぎ」
         (接尾辞 名詞性特殊接尾辞 * * すぎ)
         (接尾辞 名詞性特殊接尾辞 * * 以降)  ;「昭和二〇年以降」「三〇以降」
         (接尾辞 名詞性特殊接尾辞 * * 以来)
         (接尾辞 名詞性特殊接尾辞 * * 以後)
         (接尾辞 名詞性特殊接尾辞 * * 以前)))

; ※ ↑これらの数詞との接続は例外的
;    「３０(才)以後」のように何らかの助数辞の省略

(((接尾辞 名詞性名詞助数辞)		;「３回以降」「昨年の１０％以降…」
					; (「３時以降」などは上と重複)
  (接尾辞 名詞性名詞接尾辞 * * 目)	;「３回目以降」
  (接尾辞 名詞性名詞接尾辞 * * 戦)	;「３回戦以降」
  (名詞 サ変名詞)			;「変換以後」
  (未定義語)
  (名詞 固有名詞)
  (名詞 人名)				;「千代の富士以来」
  (名詞 地名)				;「東京以来」
  (名詞 組織名))
        ((接尾辞 名詞性特殊接尾辞 * * 以降)
         (接尾辞 名詞性特殊接尾辞 * * 以来)
         (接尾辞 名詞性特殊接尾辞 * * 以後)
         (接尾辞 名詞性特殊接尾辞 * * 以前)))

; 「都道府県郡市町村区州」は地名，未定義語，数詞とのみ接続
; ※ ただし「北海道」は一語．「京都府」「大阪府」は連語の方がよいか？

(((名詞 地名)
  (未定義語)
  (名詞 数詞))
        ((接尾辞 名詞性特殊接尾辞 * * 都)
;    	 (接尾辞 名詞性特殊接尾辞 * * 道) ;「関越道」などを間違うので
    	 (接尾辞 名詞性特殊接尾辞 * * 府)
         (接尾辞 名詞性特殊接尾辞 * * 県)
    	 (接尾辞 名詞性特殊接尾辞 * * 郡)
	 (接尾辞 名詞性特殊接尾辞 * * 市)
	 (接尾辞 名詞性特殊接尾辞 * * 村)
    	 (接尾辞 名詞性特殊接尾辞 * * 町)
    	 (接尾辞 名詞性特殊接尾辞 * * 区)
    	 (接尾辞 名詞性特殊接尾辞 * * 州)
         (接尾辞 名詞性特殊接尾辞 * * 省)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 名詞性述語接尾辞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((形容詞 * * 語幹)
  (接尾辞 形容詞性述語接尾辞 * 語幹)
  (接尾辞 形容詞性名詞接尾辞 * 語幹))
        ((接尾辞 名詞性述語接尾辞 * * さ)
         (接尾辞 名詞性述語接尾辞 * * め))
)

(((形容詞 * イ形容詞アウオ段 語幹)
  (形容詞 * イ形容詞イ段 語幹)
  (形容詞 * イ形容詞イ段特殊 語幹)
  (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 語幹)
  (接尾辞 形容詞性名詞接尾辞 イ形容詞アウオ段 語幹))
        ((接尾辞 名詞性述語接尾辞 * * み)
         (接尾辞 名詞性述語接尾辞 * * 味))
)

((NaAdjStem)			;「問題そのもの、静かそのもの」
       ((接尾辞 名詞性名詞接尾辞 * * そのもの))
)

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形))
        ((接尾辞 名詞性述語接尾辞 * * かた)
         (接尾辞 名詞性述語接尾辞 * * 方)
         (接尾辞 名詞性述語接尾辞 * * 手)
         (接尾辞 名詞性述語接尾辞 * * たて)
         (接尾辞 名詞性述語接尾辞 * * ぶり)
         (接尾辞 名詞性述語接尾辞 * * っぷり)
         (接尾辞 名詞性述語接尾辞 * * よう)
         (接尾辞 名詞性述語接尾辞 * * 様)
         (接尾辞 名詞性述語接尾辞 * * がい)
         (接尾辞 名詞性述語接尾辞 * * っこ)
         (接尾辞 名詞性述語接尾辞 * * さし)
         (接尾辞 名詞性述語接尾辞 * * 止し))
)

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (接尾辞 形容詞性述語接尾辞 イ形容詞アウオ段 基本形 たい))
        ((接尾辞 名詞性述語接尾辞 * * 放題)
         (接尾辞 名詞性述語接尾辞 * * ほうだい))
)

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (形容詞 * * 語幹)
  (接尾辞 形容詞性述語接尾辞 * 語幹)
  (接尾辞 形容詞性名詞接尾辞 * 語幹))
        ((接尾辞 名詞性述語接尾辞 * * そう))
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               数詞関係の整理
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 「数」などと数詞の連続は「数十」などだけに制限

(((名詞 数詞 * * 数)
  (名詞 数詞 * * すう)
  (名詞 数詞 * * 何)
  (名詞 数詞 * * なん)
  (名詞 数詞 * * 幾)
  (名詞 数詞 * * いく))
	((名詞 数詞))
 0 )

(((名詞 数詞 * * 数)
  (名詞 数詞 * * すう)
  (名詞 数詞 * * 何)
  (名詞 数詞 * * なん)
  (名詞 数詞 * * 幾)
  (名詞 数詞 * * いく))
    	(;(名詞 数詞 * * １)	; 「数１０」など
	 ;(名詞 数詞 * * 一)	; 「数一〇」など
	 (名詞 数詞 * * 十)
	 (名詞 数詞 * * 百)
	 (名詞 数詞 * * 千)
	 (名詞 数詞 * * 万)
	 (名詞 数詞 * * 億)
	 (名詞 数詞 * * 兆)))


; 数詞の「分の」「・」の前後は数詞だけ

(((名詞 数詞 * * 分の)
  (名詞 数詞 * * ・))
        ((* *))
 0 )

(((名詞 数詞 * * 分の)
  (名詞 数詞 * * ・))
	((名詞 数詞)))

(((* *))
        ((名詞 数詞 * * 分の)
         (名詞 数詞 * * ・))
 0 )

(((名詞 数詞))
        ((名詞 数詞 * * 分の)
         (名詞 数詞 * * ・)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 格助詞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

((SentenceEnd
  BunsetsuEndSentenceEnd
  BunsetsuEnd
  BunsetsuEndSentenceCanEnd)
    	((助詞 格助詞))			; 06/07/20 「飛んで行くを演奏」
 80 )

(((特殊 読点))
	((助詞 格助詞))
 30 )

(((特殊 読点)
  BunsetsuEndSentenceEnd
  SentenceEnd
  BackwardAllNominal
  NaAdjStem			; 「静かと〜」
  (感動詞))
        ((助詞 格助詞 * * と)
         (助詞 格助詞 * * っと)))

(((* * * 省略意志形)
  (* * * 基本省略推量形)
  (* * * タ系省略推量形)
  AllNaAdjClippedGuessForm
  (助動詞 * 助動詞ぬ型 音便省略推量形))
        ((助詞 格助詞 * * と)
         (助詞 格助詞 * * っと))
 20 )

((BunsetsuEnd			; 「静かな」,「大きな」など
  BunsetsuEndSentenceCanEnd)	; 「静かに」,「美しく」など
        ((助詞 格助詞 * * と))
 20 )

; 「っと」を接続させると「もっと」「でもっとも」などがおかしくなる
; ※ BunsetsuEndSentenceCanEndに「も」(副助詞)が含まれる

(((文頭)
  (特殊 句点))
        ((助詞 格助詞 * * と)		; 「，といった」
         (助詞 格助詞 * * っと)
         (助詞 接続助詞 * * が))	; 「，ができない」
 20 )

((BackwardAllNominal
  (助詞 接続助詞 * * の))
        ((助詞 格助詞))
)

(((助動詞 * 助動詞ぬ型 文語連体形)      ; 追加 91/8/15 「〜ざるを得ない」
  (動詞 * * 文語基本形)                 ; 追加 96/6/3  「奏すを得ない」
  (接尾辞 動詞性接尾辞 * 文語基本形))
        ((助詞 格助詞 * * を)))

((VerbBasicForm	         		;「書いたに(ちがいない)」(ふさわしい/限る/しても/したがって/も関わらず)
  IAdjBasicForm         		;「美しい(にちがいない)」
  NaAdjBasicForm	       		;「静かだった(にちがいない)」
  (* * イ形容詞アウオ段 文語連体形)	;「なきに(等しい)」「なきに(しもあらず)」「遅きに失する」「良きに計らう」
  (* * イ形容詞イ段 文語連体形)
  (* * イ形容詞イ段特殊 文語連体形))
        ((助詞 格助詞 * * に)))

(((動詞 * * タ形))                      ;「なったまではよかった」
        ((助詞 格助詞 * * まで)))       ; 95/12/21 yamaji


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 副助詞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((特殊 読点))
        ((助詞 副助詞 * * は) 		; 「，でも」は接続詞なので個別列挙
         (助詞 副助詞 * * って) 	; 
         (助詞 副助詞 * * など) 	; 
         (助詞 副助詞 * * なんて)) 	; 「といったら、なんて古臭いと」は副詞だがあきらめる
 30 )

((BunsetsuEndSentenceEnd
  SentenceEnd
  BunsetsuEnd
  BunsetsuEndSentenceCanEnd
  BackwardAllNominal
  NaAdjStem
  (感動詞))
        ((助詞 副助詞 * * は))
 20 )

((BackwardAllNominal
  (助詞 接続助詞 * * の))
        ((助詞 副助詞))
)

(((形容詞 * ナ形容詞 語幹)
  (形容詞 * ナ形容詞特殊 語幹)
  (形容詞 * ナノ形容詞 語幹)
  (接尾辞 形容詞性名詞接尾辞 ナ形容詞 語幹)
  (接尾辞 形容詞性名詞接尾辞 ナノ形容詞 語幹)
  (接尾辞 形容詞性述語接尾辞 ナ形容詞 語幹)
  (接尾辞 形容詞性述語接尾辞 ナノ形容詞 語幹))
        ((助詞 副助詞 * * でも))	; ○「優先で も」<->「優先 でも」
 11 )

(((動詞 * * タ系連用テ形)
  (接尾辞 * * タ系連用テ形)     ; Kuro 93/08/24 変更 動詞性接尾辞だけだった
  (助動詞 * * タ系連用テ形))
        ((助詞 副助詞 * * は)
         (助詞 副助詞 * * も)
         (助詞 副助詞 * * さえ)
         (助詞 副助詞 * * でも)
         (助詞 副助詞 * * だけ) ; 「関してだけ」
         (助詞 副助詞 * * すら)
         (助詞 副助詞 * * まで)
         (助詞 副助詞 * * ばかり)
	 (助詞 副助詞 * * ばっかり)
	 (助詞 副助詞 * * ばっか)
         (助詞 副助詞 * * のみ)
         (助詞 副助詞 * * しか)
         (助詞 副助詞 * * こそ)
         (助詞 副助詞 * * など)
         (助詞 副助詞 * * なんか)
         (助詞 副助詞 * * なんて)
         (助詞 副助詞 * * なんぞ)
         (助詞 副助詞 * * って)))
  
((IAdjBasicRenyoForm
  (* * イ形容詞アウオ段 タ系連用テ形)   ; 95/12/07 yamaji 「なくても」 
  (* * イ形容詞イ段 タ系連用テ形)       ; 95/12/07 yamaji
  (* * イ形容詞イ段特殊 タ系連用テ形)       ; 95/12/07 yamaji
  (* * タル形容詞 基本連用形))
        ((助詞 副助詞 * * は)
         (助詞 副助詞 * * も)
         (助詞 副助詞 * * さえ)
         (助詞 副助詞 * * すら)
         (助詞 副助詞 * * など)
         (助詞 副助詞 * * なんか)
         (助詞 副助詞 * * なんて)
         (助詞 副助詞 * * なんぞ)
         (助詞 副助詞 * * って)))

(((* * ナ形容詞 ダ列基本連用形)
  (* * ナ形容詞 ダ列タ系連用テ形)
  (* * ナ形容詞特殊 ダ列基本連用形)
  (* * ナ形容詞特殊 ダ列タ系連用テ形)
  (* * ナノ形容詞 ダ列基本連用形)
  (* * ナノ形容詞 ダ列タ系連用テ形)
  (* * タル形容詞 基本連用形)
;  (* * 判定詞 ダ列基本連用形)
;  (* * 判定詞 ダ列タ系連用テ形)
)
        ((助詞 副助詞 * * は)
         (助詞 副助詞 * * も)
         (助詞 副助詞 * * さえ)
         (助詞 副助詞 * * すら)
         (助詞 副助詞 * * のみ)
         (助詞 副助詞 * * しか)
         (助詞 副助詞 * * こそ)
         (助詞 副助詞 * * など)
         (助詞 副助詞 * * なんか)
         (助詞 副助詞 * * なんて)
         (助詞 副助詞 * * なんぞ)))

(((* * * タ系連用タリ形))
	((助詞 副助詞 * * は)
	 (助詞 副助詞 * * も)		; 「試みたりもする」
	 (助詞 副助詞 * * さえ)
	 (助詞 副助詞 * * すら)
	 (助詞 副助詞 * * など)
	 (助詞 副助詞 * * なんか)
	 (助詞 副助詞 * * なんて)
         (助詞 副助詞 * * なんぞ)))

(((* * ナ形容詞 デアル列タ系連用テ形)
  (* * ナ形容詞特殊 デアル列タ系連用テ形)
  (* * ナノ形容詞 デアル列タ系連用テ形)
  (* * 判定詞 デアル列タ系連用テ形))
	((助詞 副助詞 * * は)
	 (助詞 副助詞 * * も)
	 (助詞 副助詞 * * さえ)
	 (助詞 副助詞 * * すら)
	 (助詞 副助詞 * * でも)
	 (助詞 副助詞 * * こそ)))

(((* * * デアル列基本連用形))		; 「〜でありさえ」
        ((助詞 副助詞 * * さえ)
         (助詞 副助詞 * * こそ)))

(((* * * 基本条件形)
  (* * * 音便条件形)                    ; 「なきゃ」(音便条件形２)はだめ
  (* * * 文語条件形)
  (* * * ダ列基本条件形)
  (* * * ダ列文語条件形)                ; 追加 95/05/09 kuro
  (* * * デアル列基本条件形))
        ((助詞 副助詞 * * こそ)))       ; 追加 94/01/17 kuro

(((* * * 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形)
  (* * * タ形)
  (* * * ダ列タ形)
  (* * * デアル列基本形)
  (* * * デアル列タ形)
  (* * * デス列基本形)
  (* * * デス列タ形)
  (* * * ヤ列基本形)
  (* * * ヤ列タ形))
        ((助詞 副助詞 * * だけ)
         (助詞 副助詞 * * のみ)
         (助詞 副助詞 * * なんて)
         (助詞 副助詞 * * なんぞ)
	 (助詞 副助詞 * * って)
	 (助詞 副助詞 * * など)
         (助詞 副助詞 * * ばかり)
	 (助詞 副助詞 * * ばっかり)
	 (助詞 副助詞 * * ばっか)
         (助詞 副助詞 * * どころ)))

(((* * * 意志形)
  (* * * 省略意志形)
  (* * * 基本推量形)
  (* * * 基本省略推量形)
  (* * * タ系推量形)
  (* * * タ系省略推量形))
	((助詞 副助詞 * * なんて)
         (助詞 副助詞 * * なんぞ)))	; 06/08/06「行こうなんて」

(((動詞 * * 基本形)
  (接尾辞 動詞性接尾辞 * 基本形))	
        ((助詞 副助詞 * * しか)))	;「するしか」

; 「するまで」の「まで」は接続助詞
; 「するなら」の「なら」は接続助詞
; 「するばかりだ」などは助動詞だが,「するばかりが」は副助詞

(((* * * ダ列基本連体形))
        ((助詞 副助詞 * * だけ)))	; 「賑やかなだけ」

((VerbBasicForm			; 「書くとて」
  NaAdjStem)			; 「静かとて」
    	((助詞 副助詞 * * とて)))


; 「〜位」は接続を大幅に制限

((BackwardAllNominal)
        ((助詞 副助詞 * * 位))
 0 )

(((副詞 * * * 幾ら)
  (副詞 * * * いくら)
  (指示詞 名詞形態指示詞)	; 「どれ位」
  (接尾辞 名詞性名詞助数辞) 	; 「３人位」
  (接尾辞 名詞性名詞接尾辞))	; 「３分後位」
        ((助詞 副助詞 * * 位)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 接続助詞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((特殊 読点))
         ((助詞 接続助詞 * * の))
 30 )
; <注意> 他の接続助詞は，同型の接続詞が読点に後接するのでここでは扱わない


((BackwardAllNominal			; 「太郎の」
  (* * * タ系連用テ形)			; 「にらんでのかけひき」
  (* * * タ系連用タリ形)		; 「〜したりのやりくりで」
  (* * * ダ列タ系連用タリ形)		; 「〜だったりの」
  (* * * デアル列タ系連用タリ形)	; 「〜であったりの」
  (助動詞 * 助動詞ぬ型 基本連用形))	; 「飲まず食わずの生活」
        ((助詞 接続助詞 * * の))
)

((BackwardAllNominal			; 「太郎と花子」
  VerbBasicBasicForm			; 「書くと困る」
  IAdjBasicBasicForm
  NaAdjDaBasicBasicForm
  (* * * デアル列基本形)
  (* * * デス列基本形)

  (* * * 意志形)			; 「書こうと(も)」
  (* * * 基本推量形)			; 「美しかろうと(も)」
  AllNaAdjGuessForm)			; 「静かであろうと(も)」
        ((助詞 接続助詞 * * と)))

; 上記以外に「も」が続く場合には
; 	「美しくとも」 --- IAdjBasicRenyoForm
; 	「書かずとも」 --- (助動詞 * 助動詞ぬ型 基本連用形)
; なども接続助詞の「と」と考えられ,連語で扱うことも考えられるが,
; 当面これらは格助詞として扱っておく

((BackwardAllNominal)			; 「太郎や」
        ((助詞 接続助詞 * * や)
         (助詞 接続助詞 * * および)
         (助詞 接続助詞 * * 及び)
	 (助詞 接続助詞 * * ならびに)
	 (助詞 接続助詞 * * 並びに)))

((BackwardAllNominal			; 「太郎も」
  VerbBasicForm
  IAdjBasicForm
  NaAdjBasicForm
  (* * * 命令形)			; 「」
  (* * * デアル列命令形)		; 「」
  (* * * 文語命令形))			; 「せよも」
        ((助詞 接続助詞 * * も)
         (助詞 接続助詞 * * やら)   
         (助詞 接続助詞 * * だの)))   

((BackwardAllNominal			;「太郎に花子に」
  VerbBasicForm	         		;「思うに」(語彙は制限されるはず),「書くには」
  AllNaAdjGuessForm			;「よいだろうに」「任務であろうに」
  (助動詞 * 助動詞ぬ型 基本連用形))	; 「〜ずに」
        ((助詞 接続助詞 * * に))
)

; 意志形は連語「にも」に接続するとする(下の連語の接続で規定)

((BackwardAllNominal			; 「太郎か」
  VerbBasicForm
  IAdjBasicForm
  NaAdjAllBasicForm			; 「どれ/どうしてだか分からない」「学生だかどうか」
  (助動詞 * 助動詞ぬ型 音便基本形)
  (* * * タ系連用テ形)                  ; 「反映してか、」
  NaAdjStem)				; 「静かか」
        ((助詞 接続助詞 * * か)
         (助詞 接続助詞 * * かも))
)

(((* * * 意志形))			; 「書こうか」
        ((助詞 接続助詞 * * か)))

((BackwardAllNominal			; 「太郎なり」
  VerbBasicBasicForm
  VerbTaBasicForm)
        ((助詞 接続助詞 * * なり)))

((BackwardAllNominal			; 「太郎または」
  BunsetsuEndSentenceEnd		; 「書くまたは」
  BunsetsuEnd				; 「静かなまたは」
  BunsetsuEndSentenceCanEnd		; 「書けまたは」
  (感動詞))
        ((助詞 接続助詞 * * または)
         (助詞 接続助詞 * * 又は)
         (助詞 接続助詞 * * また)
         (助詞 接続助詞 * * 又)
         (助詞 接続助詞 * * かつ)   
         (助詞 接続助詞 * * かつまた)       

         (助詞 接続助詞 * * もしくは)       
         (助詞 接続助詞 * * 若しくは)       
         (助詞 接続助詞 * * あるいは)       
         (助詞 接続助詞 * * 或いは)       

         (助詞 接続助詞 * * そして)
         (助詞 接続助詞 * * それとも)))

((BackwardAllNominal			; 「太郎ないし」
  BunsetsuEndSentenceEnd		; 「書くないし」
  (感動詞))
        ((助詞 接続助詞 * * ないし) 
         (助詞 接続助詞 * * 乃至) 
         (助詞 接続助詞 * * ないしは)
         (助詞 接続助詞 * * 乃至は)))

((NaAdjStem)				; 「静かまたは」 追加 00/06/13
        ((助詞 接続助詞 * * または)
         (助詞 接続助詞 * * 又は)
         (助詞 接続助詞 * * また)
         (助詞 接続助詞 * * 又)
         (助詞 接続助詞 * * かつ)   
         (助詞 接続助詞 * * かつまた)       

         (助詞 接続助詞 * * もしくは)       
         (助詞 接続助詞 * * 若しくは)       
         (助詞 接続助詞 * * あるいは)       
         (助詞 接続助詞 * * 或いは)       
         (助詞 接続助詞 * * ないし) 
         (助詞 接続助詞 * * 乃至)
         (助詞 接続助詞 * * ないしは)
         (助詞 接続助詞 * * 乃至は)

         (助詞 接続助詞 * * そして)
         (助詞 接続助詞 * * それとも))
 20 )					; 名詞などと重なる場合はそちらを優先

((VerbBasicForm
  IAdjBasicForm
  NaAdjAllBasicForm
  AuxBasicForm
  AllNaAdjGuessForm
  (* * * 意志形)                	; 「書こうが」
  (* * * 基本推量形)            	; 「美しかろうが」
  (助動詞 * 助動詞ぬ型 音便推量形)
  (* * * タ系推量形))           	; 「書いたろうが」
        ((助詞 接続助詞 * * し)
         (助詞 接続助詞 * * が)))

(((感動詞 * * * すみません)
  (感動詞 * * * すいません))
        ((助詞 接続助詞 * * が)))	; 「すみませんが」

((VerbBasicForm
  IAdjBasicForm
  NaAdjAllBasicForm
  AuxBasicForm
  NaAdjStem)				; 「静かなら」
        ((助詞 接続助詞 * * なら)))

((VerbBasicForm
  IAdjBasicForm
  NaAdjAllBasicForm
  AuxBasicForm
  AllNaAdjGuessForm
  (* * * タ系推量形))           ; 「書いたろうけど」
        ((助詞 接続助詞 * * けど)
         (助詞 接続助詞 * * けども)
         (助詞 接続助詞 * * けれど)
         (助詞 接続助詞 * * けれども)))

((VerbBasicForm
  IAdjBasicForm
  NaAdjAllBasicForm
  AuxBasicForm
  AllNaAdjGuessForm
  (* * * タ系推量形)		; 「書いたろうから」

  (動詞 * * タ系連用テ形)	; 「書いてから」
  (接尾辞 動詞性接尾辞 * タ系連用テ形))
        ((助詞 接続助詞 * * から)))

((VerbBasicBasicForm
  VerbTaBasicForm            	; ?「走ったまではよかった」
  IAdjBasicBasicForm            	; ?「美しいまではよかった」
  IAdjTaBasicForm            	; ?「美しかったまではよかった」
  NaAdjDaBasicRentaiForm	; ?「執拗なまでの」
  (* * * ダ列タ形)         	; ?「学生だったまではよかった」
  (* * * デアル列タ形))        ; ?「学生であったまではよかった」
        ((助詞 接続助詞 * * まで)))

((VerbBasicForm			; 「思うより」,「思ったより」
  IAdjBasicForm			; 「美しいより」,「まずかったより」
  (* * * ダ列タ形)
  (* * * デアル列基本形)
  (* * * デアル列タ形))
        ((助詞 接続助詞 * * より)))

((VerbTaBasicForm
  IAdjBasicForm
  NaAdjDaBasicRentaiForm	; 「静かなまま」
  (* * * ダ列タ形)
  (* * * デアル列基本形)
  (* * * デアル列タ形))
        ((助詞 接続助詞 * * まま)))

((VerbTaBasicForm
  (指示詞 名詞形態指示詞 * * これ)
  (指示詞 名詞形態指示詞 * * それ)
  (指示詞 名詞形態指示詞 * * あれ))
        ((助詞 接続助詞 * * きり)
	 (助詞 接続助詞 * * っきり))
)

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形))
        ((助詞 接続助詞 * * つつ))
)

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  NaAdjStem				;「静かながら」
  (* * * デアル列基本連用形)		;「静かでありながら」
  BackwardAllNominal			;「敵ながら」,「今さらながら」
  IAdjBasicBasicForm			;「若いながら」
  (形容詞 * * 文語基本形))		;「恥ずかしながら」
        ((助詞 接続助詞 * * ながら))
)

((VerbBasicBasicForm)
        ((助詞 接続助詞 * * やいなや))
)

(((* * 子音動詞カ行 命令形)		; 「書けども」,「走っていけども」
  (* * 子音動詞カ行促音便形 命令形)
  (* * 子音動詞ガ行 命令形)
  (* * 子音動詞サ行 命令形)
  (* * 子音動詞タ行 命令形)
  (* * 子音動詞ナ行 命令形)
  (* * 子音動詞バ行 命令形)
  (* * 子音動詞マ行 命令形)
  (* * 子音動詞ラ行 命令形)
  (* * 子音動詞ラ行イ形 命令形)
  (* * 子音動詞ワ行 命令形)
  (* * 子音動詞ワ行文語音便形 命令形))
          ((助詞 接続助詞 * * ど)
           (助詞 接続助詞 * * ども)))

; ※ 本来は文語巳然形に接続するが，JUMANでは文語巳然形はたてていない．
;
; 子音動詞では文語巳然形と命令形が同形なので，とりあえず命令形とする．
;
; 子音動詞以外との接続は現代語にはほとんど残っていない
; (？, 「すれど」はありそうだが,とりあえず保留)


(((動詞 * 子音動詞ワ行 基本連用形 思う))
          ((助詞 接続助詞 * * きや)))	; 「思いきや」 02/10/22


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 終助詞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

((BackwardAllNominal
  VerbBasicForm
  IAdjBasicForm
  NaAdjStem
  (* * * ダ列タ形)
  AuxBasicForm			; 09/06/01
  (助動詞 * 判定詞 語幹))
    	((助詞 終助詞 * * さ)
    	 (助詞 終助詞 * * さあ))
)

((VerbBasicForm

  (動詞 * * 意志形)
  (動詞 * * 省略意志形)
  (動詞 * * タ系推量形)
  (動詞 * * タ系省略推量形)
  (接尾辞 動詞性接尾辞 * 意志形)
  (接尾辞 動詞性接尾辞 * 省略意志形)
  (接尾辞 動詞性接尾辞 * タ系推量形)
  (接尾辞 動詞性接尾辞 * タ系省略推量形)

  IAdjBasicForm

  (* * イ形容詞アウオ段 基本推量形)
  (* * イ形容詞アウオ段 基本省略推量形)
  (* * イ形容詞イ段 基本推量形)
  (* * イ形容詞イ段 基本省略推量形)
  (* * イ形容詞イ段特殊 基本推量形)
  (* * イ形容詞イ段特殊 基本省略推量形)
  (* * イ形容詞アウオ段 タ系推量形)
  (* * イ形容詞アウオ段 タ系省略推量形)
  (* * イ形容詞イ段 タ系推量形)
  (* * イ形容詞イ段 タ系省略推量形)
  (* * イ形容詞イ段特殊 タ系推量形)
  (* * イ形容詞イ段特殊 タ系省略推量形)

  NaAdjBasicForm
  AllNaAdjGuessForm
  AllNaAdjClippedGuessForm

  (助動詞 * 無活用型 基本形 です)
  (助動詞 * 助動詞だろう型 基本形)

  (助動詞 * 助動詞ぬ型 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形)
  (助動詞 * 助動詞ぬ型 基本推量形)
  (助動詞 * 助動詞ぬ型 基本省略推量形)
  (助動詞 * 助動詞ぬ型 音便推量形)
  (助動詞 * 助動詞ぬ型 音便省略推量形)
  (助動詞 * 助動詞ぬ型 タ系推量形)
  (助動詞 * 助動詞ぬ型 タ系省略推量形))
        ((助詞 終助詞 * * か)
         (助詞 終助詞 * * かしら)
         (助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)
         (助詞 終助詞 * * な)
         (助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)
         (助詞 終助詞 * * なあ)
         (助詞 終助詞 * * なぁ)
         (助詞 終助詞 * * ぞ)
         (助詞 終助詞 * * ぜ)
         (助詞 終助詞 * * で)
         (助詞 終助詞 * * わ)
         (助詞 終助詞 * * ねん)		; タ形にはつかないが近似
         (助詞 終助詞 * * かい))
)

(((助動詞 * 無活用型 基本形 まい))
        ((助詞 終助詞 * * か)))

((BackwardAllNominal)
        ((助詞 終助詞 * * か)
         (助詞 終助詞 * * かしら)
         (助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)
         (助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)
         (助詞 終助詞 * * なあ)
         (助詞 終助詞 * * なぁ)
         (助詞 終助詞 * * かい))
)

(((指示詞 名詞形態指示詞 * * ここ)	; 2011/9/13 「ここぞと言うとき」
  (名詞 形式名詞 * * もの))		;           「何するものぞ」
	((助詞 終助詞 * * ぞ)))

((NaAdjStem)
        ((助詞 終助詞 * * か)
         (助詞 終助詞 * * かしら)
         (助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)
         (助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)
         (助詞 終助詞 * * かい))
)

; BunsetsuEndSentenceCanEnd からもってきたので,整理必要！！
; 特に文語はあやしい
  
((IAdjBasicRenyoForm
  (* * * 基本条件形)
  (* * * 音便条件形)
  (* * * 音便条件形２)
  (* * * 文語条件形)
  (* * * タ系条件形)
  (* * * タ系連用テ形)
  (* * * タ系連用タリ形)
  (* * * タ系連用チャ形)
  (* * * ダ列基本条件形)
  (* * * ダ列文語条件形)
  (* * * ダ列基本連用形)
  (* * * ダ列特殊連用形)
  (* * * ダ列タ系条件形)
  (* * * ダ列タ系連用テ形)
  (* * * ダ列タ系連用タリ形)
  (* * * デアル列基本条件形)
  (* * * デアル列基本連用形)
  (* * * デアル列タ系条件形)
  (* * * デアル列タ系連用テ形)
  (* * * デアル列タ系連用タリ形)
  (* * * デス列タ系条件形)
  (* * * デス列タ系連用テ形)
  (* * * デス列タ系連用タリ形)
  (* * * ヤ列タ系条件形)
  (* * * ヤ列タ系連用タリ形))
    	((助詞 終助詞 * * さ)
    	 (助詞 終助詞 * * さあ)
    	 (助詞 終助詞 * * か)
         (助詞 終助詞 * * かしら)
         (助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)
         (助詞 終助詞 * * な)
         (助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)
         (助詞 終助詞 * * なあ)
         (助詞 終助詞 * * なぁ)
         (助詞 終助詞 * * かい))
)

(((* * * 基本連用形))
        ((助詞 終助詞 * * な))		; 06/01/12 「書きな」「書いていな」「しちゃいな」
)

(((* * * ダ列タ系連用ジャ形)
  (* * 子音動詞ラ行イ形 命令形))	; 「下さいね」,「しなさいね」など
        ((助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)
         (助詞 終助詞 * * な)
         (助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)
         (助詞 終助詞 * * なあ)
         (助詞 終助詞 * * なぁ))
)

(((* * * 命令形))		; 2006/7/16 「黙れよ」「書いておけよ」など
        ((助詞 終助詞 * * よ)
         (助詞 終助詞 * * ヨ)))

((NaAdjAllBasicForm
  (助動詞 * 助動詞そうだ型 基本形)
  (助動詞 * 助動詞そうだ型 デアル列基本形)
  (助動詞 * 助動詞そうだ型 デス列基本形))
        ((助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)
         (助詞 終助詞 * * な)
         (助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)
         (助詞 終助詞 * * なあ)
         (助詞 終助詞 * * なぁ)
         (助詞 終助詞 * * ぞ)
         (助詞 終助詞 * * ぜ)
         (助詞 終助詞 * * わ))
)

(((* * * タ形)
  (* * * ダ列タ形)
  (* * * デス列タ形)
  (* * * ヤ列タ形))
        ((助詞 終助詞 * * っけ))
)

(((動詞 * * 基本形)
  (接尾辞 動詞性接尾辞 * 基本形))
        ((助詞 終助詞 * * な))      ; 禁止の「な」
)

(((接続詞))				; 「だけどね」
        ((助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)
         (助詞 終助詞 * * な)
         (助詞 終助詞 * * よ)  
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)
         (助詞 終助詞 * * さ)
	 (助詞 終助詞 * * さあ)
         (助詞 終助詞 * * なあ)
         (助詞 終助詞 * * なぁ))
)

(((助動詞 * 助動詞く型 *))	; 「〜べきね」,「〜ごとくさ」
    	((助詞 終助詞 * * *)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               助詞 ＋ 助詞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  *  +  格助詞

(((助詞 格助詞 * * まで)
  (助詞 格助詞 * * から)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * のみ)
  (助詞 副助詞 * * こそ)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の)  
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * か) 
  (助詞 接続助詞 * * ながら)
  (助詞 終助詞 * * か)) 
        ((助詞 格助詞 * * が)))

(((助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * から) 
  (助詞 副助詞 * * のみ)
  (助詞 副助詞 * * こそ)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * まで)  
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 終助詞 * * か)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * か))
        ((助詞 格助詞 * * を)))

(((助詞 格助詞 * * まで)
  (助詞 格助詞 * * から)	; 「彼からに違いない」
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * こそ)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * すら)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * か)  
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * きり)  
  (助詞 接続助詞 * * っきり))
         ((助詞 格助詞 * * に)))

(((助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * まで)
  (助詞 副助詞 * * さえ) 
  (助詞 副助詞 * * すら)
  (助詞 副助詞 * * まで)  
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * のみ)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * と))
        ((助詞 格助詞 * * から))) 

(((助詞 格助詞)
  (助詞 副助詞)
  (助詞 接続助詞))
        ((助詞 格助詞 * * と)))

; 「っと」を接続させると「もっと」「でもっとも」などがおかしくなる

; 引用助詞を別に設ける場合は以下のものだけ
;
;(((助詞 副助詞 * * など)
;  (助詞 副助詞 * * なんか)
;  (助詞 副助詞 * * だけ)
;  (助詞 副助詞 * * ばかり)
;  (助詞 副助詞 * * ばっかり)
;  (助詞 副助詞 * * ばっか)
;  (助詞 副助詞 * * のみ)
;  (助詞 副助詞 * * すら)
;  (助詞 接続助詞 * * やら) ; ?
;  (助詞 接続助詞 * * だの)
;  (助詞 接続助詞 * * の)
;  (助詞 接続助詞 * * まで))     
;        ((助詞 格助詞 * * と)))

(((助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * まで)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * のみ)
  (助詞 接続助詞 * * や)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * か)	; 「太郎か次郎かでかわってくる」
  (助詞 接続助詞 * * か)	; 「走るか歩くかでかわってくる」
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * まま)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり) 
  (助詞 接続助詞 * * ながら))
        ((助詞 格助詞 * * で)))

(((助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * のみ)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * か))
        ((助詞 格助詞 * * へ)))

(((助詞 格助詞 * * に)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の))
        ((助詞 格助詞 * * まで)))

; 「とまで」「っとまで」は格助詞＋副助詞と解釈

(((助詞 格助詞 * * まで)
   (助詞 副助詞 * * だけ)
   (助詞 副助詞 * * など)
   (助詞 副助詞 * * なんか)
   (助詞 接続助詞 * * やら)
   (助詞 接続助詞 * * だの)
   (助詞 接続助詞 * * の)
   (助詞 接続助詞 * * と)
   (助詞 接続助詞 * * まで)  
   (助詞 接続助詞 * * か))
         ((助詞 格助詞 * * より)))

(((助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * から)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * どころ)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の)  
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * か))
        ((助詞 格助詞 * * の)))

(((助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ)
  (助詞 接続助詞 * * やら)
  (助詞 接続助詞 * * だの)
  (助詞 接続助詞 * * の)
  (助詞 接続助詞 * * と))
        ((助詞 格助詞 * * にて)))

; ＊ ＋ 副助詞   

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * こそ)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * より)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * に)
  (助詞 接続助詞 * * か))
      ((助詞 副助詞 * * は)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 接続助詞 * * も)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり) 
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * まま))
      ((助詞 副助詞 * * なら)))

(((助詞 格助詞)
  (助詞 終助詞)
  (助詞 接続助詞)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * すら)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * は)
  (助詞 副助詞 * * なら)
  (助詞 副助詞 * * ったら)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * でも)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * のみ)
  (助詞 副助詞 * * しか)
  (助詞 副助詞 * * こそ)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * なんて)
  (助詞 副助詞 * * なんぞ)
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * とて)
  (助詞 副助詞 * * じゃ))
         ((助詞 副助詞 * * って))
 25 )
; 「にとって」,「をもって」,「よって」などが助詞連続になることを防ぐため

(((助詞 格助詞 * * に)
;  (助詞 格助詞 * * を) 
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * すら)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * など)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * より)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * に)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * と))	; 「書こうとも」
        ((助詞 副助詞 * * も)))

(((助詞 格助詞 * * を)) 
        ((助詞 副助詞 * * も))
 15 )
; 「をもたらす」などで「を(助詞)も(助詞)」となるのを防ぐため

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * など)
  (助詞 接続助詞 * * か))
        ((助詞 副助詞 * * さえ)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * だけ)
  (助詞 接続助詞 * * から))
        ((助詞 副助詞 * * でも)))

(((助詞 格助詞 * * を)	; 「学生をすら悩ます」
  (助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * など)
  (助詞 接続助詞 * * か))
        ((助詞 副助詞 * * すら)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * など)
  (助詞 接続助詞 * * か))
      ((助詞 副助詞 * * だって)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * で)
  (助詞 副助詞 * * など)  
  (助詞 接続助詞 * * か))
        ((助詞 副助詞 * * まで)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか) 
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * まま)
  (助詞 接続助詞 * * または)
  (助詞 接続助詞 * * 又は)
  (助詞 接続助詞 * * か))
        ((助詞 副助詞 * * だけ)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 接続助詞 * * から)	; 「果たしていたからばかりではない」 01/01/17
  (助詞 副助詞 * * など))
        ((助詞 副助詞 * * ばかり)
	 (助詞 副助詞 * * ばっかり)
	 (助詞 副助詞 * * ばっか)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * など))
         ((助詞 副助詞 * * のみ)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
; (助詞 格助詞 * * より)        ; 削除 96/05/22 masako
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * など))
        ((助詞 副助詞 * * しか)))           
         
(((助詞 格助詞 * * を)
  (助詞 格助詞 * * に)
  (助詞 格助詞 * * から) 
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 副助詞 * * など)  
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * なら))       
        ((助詞 副助詞 * * こそ)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * など)	; 「などなど」
  (助詞 副助詞 * * まで)
  (助詞 接続助詞 * * か))
        ((助詞 副助詞 * * など)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
; (助詞 格助詞 * * より)        ; 削除 96/05/22 masako
  (助詞 副助詞 * * まで)
  (助詞 接続助詞 * * か))        
      ((助詞 副助詞 * * なんか)))

(((助詞 格助詞 * * を)
  (助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * など)
  (助詞 接続助詞 * * か)
  (助詞 終助詞))
        ((助詞 副助詞 * * なんて)
         (助詞 副助詞 * * なんぞ)))

(((助詞 格助詞 * * に)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * など)
  (助詞 接続助詞 * * か))
        ((助詞 副助詞 * * くらい)
         (助詞 副助詞 * * ぐらい)
         (助詞 副助詞 * * 位)))

; * ＋ 接続助詞

(((助詞 格助詞 * * から)
  (助詞 格助詞 * * まで)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * の)
  (助詞 格助詞 * * より)
  (助詞 格助詞 * * へ)
  (助詞 副助詞 * * まで)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * のみ))
        ((助詞 接続助詞 * * と)))

(((助詞 格助詞 * * から)
  (助詞 格助詞 * * まで)  
  (助詞 格助詞 * * と)
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * へ)
  (助詞 格助詞 * * まで)
  (助詞 副助詞 * * こそ) ; 追加
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * くらい) 
  (助詞 副助詞 * * ぐらい) 
  (助詞 副助詞 * * 位)
  (助詞 終助詞 * * か)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり)  
  (助詞 接続助詞 * * ながら) 
  (助詞 接続助詞 * * か))
        ((助詞 接続助詞 * * の)))

(((助詞 格助詞)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * すら)
  (助詞 副助詞 * * だけ)
  (助詞 副助詞 * * のみ)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * し))
        ((助詞 接続助詞 * * または)
         (助詞 接続助詞 * * 又は)
         (助詞 接続助詞 * * もしくは)
         (助詞 接続助詞 * * 若しくは)
         (助詞 接続助詞 * * あるいは)
         (助詞 接続助詞 * * 或いは)))

; 実際，名詞にしか後接せず，「は/もないし」は解析誤りとなる
;(((助詞 格助詞)
;  (助詞 副助詞 * * だけ)
;  (助詞 副助詞 * * など))
;         ((助詞 接続助詞 * * ないしは)
;          (助詞 接続助詞 * * 乃至は)
;          (助詞 接続助詞 * * ないし)
;          (助詞 接続助詞 * * 乃至)))

; * ＋ 接続助詞

(((助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり))
        ((助詞 接続助詞 * * が)))
 
(((助詞 副助詞 * * まで)
  (助詞 副助詞 * * だけ) 
  (助詞 副助詞 * * のみ) 
  (助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * も)
  (助詞 接続助詞 * * も)
  (助詞 接続助詞 * * の)
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり)  
  (助詞 接続助詞 * * つつ))
         ((助詞 接続助詞 * * なら)))


(((助詞 副助詞 * * くらい)
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * など)  
  (助詞 接続助詞 * * の))
         ((助詞 接続助詞 * * まで)))
    
(((助詞 副助詞 * * だけ)
  (助詞 副助詞 * * なんか)
  (助詞 副助詞 * * など))
        ((助詞 接続助詞 * * より)))
   
(((助詞 格助詞 * * と)			; 「彼とか」,「走るとか」,「走れとか」
  (助詞 格助詞 * * っと)
  (助詞 格助詞 * * から)
  (助詞 格助詞 * * の)
  (助詞 格助詞 * * で)
  (助詞 格助詞 * * より)
  (助詞 副助詞 * * って)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * など)		; ?
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * でも)   
  (助詞 副助詞 * * まで) 
  (助詞 副助詞 * * だけ) 
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ) 
  (助詞 副助詞 * * くらい) 
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 接続助詞 * * の)
  (助詞 接続助詞 * * から)    
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり)   
  (助詞 接続助詞 * * まま))
        ((助詞 接続助詞 * * か)
         (助詞 接続助詞 * * かも)))

(((助詞 副助詞 * * どころ))	; 「どころか」
        ((助詞 接続助詞 * * か)))

(((助詞 接続助詞 * * か))	; 「とかかも」
        ((助詞 接続助詞 * * かも)))

(((助詞 接続助詞 * * が))		; 「されるがまま」
        ((助詞 接続助詞 * * まま)))

(((助詞 格助詞 * * から)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * まで) 
  (助詞 副助詞 * * だけ) 
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * まで))
	((助詞 接続助詞 * * や)))	; 05/04/30
 
; 上記以外の接続助詞は助詞に後接しない．

; * ＋ 終助詞 文末以外に来る終助詞を否定。文中の「か」は接続助詞 96/05/27

(((助詞 格助詞)
  (助詞 副助詞 * * は)
  (助詞 副助詞 * * なら)
  (助詞 副助詞 * * ったら)
  (助詞 副助詞 * * って)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * でも) 
  (助詞 副助詞 * * すら) 
  (助詞 副助詞 * * だって)  
  (助詞 副助詞 * * まで) 
  (助詞 副助詞 * * だけ) 
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ) 
  (助詞 副助詞 * * しか) 
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)  
  (助詞 副助詞 * * なんて) 
  (助詞 副助詞 * * なんぞ)
  (助詞 副助詞 * * くらい) 
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * とて)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * より)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * に)   
  (助詞 接続助詞 * * し)
  (助詞 接続助詞 * * から)  
  (助詞 接続助詞 * * けれども)  
  (助詞 接続助詞 * * なら)  
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * より)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり)   
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * に)
  (助詞 接続助詞 * * けれど)
  (助詞 接続助詞 * * けど)
  (助詞 接続助詞 * * まま)
;  (助詞 接続助詞 * * ものの)
  (助詞 接続助詞 * * やいなや)
  (助詞 接続助詞 * * けども)
  (助詞 接続助詞 * * ど)
  (助詞 接続助詞 * * ども)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * も))
        ((助詞 終助詞 * * さ)
	 (助詞 終助詞 * * さあ))) 
   
(((助詞 格助詞)
  (助詞 副助詞 * * って)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * でも)   
  (助詞 副助詞 * * まで) 
  (助詞 副助詞 * * だけ) 
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ) 
  (助詞 副助詞 * * こそ) 
  (助詞 副助詞 * * など)   
  (助詞 副助詞 * * くらい) 
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 終助詞 * * っけ)
  (助詞 接続助詞 * * から)    
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり)   
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * まま)
  (助詞 接続助詞 * * も))
        ((助詞 終助詞 * * か)
         (助詞 終助詞 * * かい)))

(((助詞 格助詞)
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * でも)    
  (助詞 副助詞 * * まで) 
  (助詞 副助詞 * * だけ) 
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ) 
  (助詞 副助詞 * * くらい) 
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり)   
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * まま)
  (助詞 接続助詞 * * も))
        ((助詞 終助詞 * * かしら)))
 
(((助詞 格助詞) 
  (助詞 副助詞 * * は)
  (助詞 副助詞 * * なら)
  (助詞 副助詞 * * ったら)
  (助詞 副助詞 * * って)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * でも) 
  (助詞 副助詞 * * すら) 
  (助詞 副助詞 * * だって)  
  (助詞 副助詞 * * まで) 
  (助詞 副助詞 * * だけ) 
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ) 
  (助詞 副助詞 * * しか) 
  (助詞 副助詞 * * こそ) 
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)  
  (助詞 副助詞 * * なんて) 
  (助詞 副助詞 * * なんぞ)
  (助詞 副助詞 * * くらい) 
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * じゃ)
  (助詞 終助詞 * * か)
  (助詞 終助詞 * * かしら)
  (助詞 終助詞 * * よ)
  (助詞 終助詞 * * ヨ)
  (助詞 終助詞 * * やろ)
  (助詞 終助詞 * * わ)
  (助詞 終助詞 * * っけ)
  (助詞 終助詞 * * や)
  (助詞 終助詞 * * かい)
  (助詞 接続助詞 * * し)
  (助詞 接続助詞 * * が)  
  (助詞 接続助詞 * * から)  
  (助詞 接続助詞 * * けれども)  
  (助詞 接続助詞 * * なら)  
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * より)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * けれど)
  (助詞 接続助詞 * * けど)
  (助詞 接続助詞 * * まま)
;  (助詞 接続助詞 * * ものの)
  (助詞 接続助詞 * * やいなや)
  (助詞 接続助詞 * * けども)
  (助詞 接続助詞 * * ど)
  (助詞 接続助詞 * * ども)
  (助詞 接続助詞 * * のみならず)
  (助詞 接続助詞 * * そして)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * ならびに)
  (助詞 接続助詞 * * 並びに)
  (助詞 接続助詞 * * も))
        ((助詞 終助詞 * * ね)
         (助詞 終助詞 * * ネ)
	 (助詞 終助詞 * * ねえ)
         (助詞 終助詞 * * ねぇ)))
 
(((助詞 格助詞)
  (助詞 副助詞)
  (助詞 終助詞 * * わ)
  (助詞 接続助詞 * * し) 
  (助詞 接続助詞 * * から)  
  (助詞 接続助詞 * * けれども)  
  (助詞 接続助詞 * * なら)  
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり) 
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * けれど)
  (助詞 接続助詞 * * けど)
  (助詞 接続助詞 * * まま)
;  (助詞 接続助詞 * * ものの)
  (助詞 接続助詞 * * やいなや)
  (助詞 接続助詞 * * けども)
  (助詞 接続助詞 * * ど)
  (助詞 接続助詞 * * ども)
  (助詞 接続助詞 * * も)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * ならびに)
  (助詞 接続助詞 * * 並びに))       
        ((助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)
	 (助詞 終助詞 * * やろ)))

(((助詞 終助詞 * * な))		; 06/01/12 「書くなよ」(禁止の「な」)
	((助詞 終助詞 * * よ)
	 (助詞 終助詞 * * ヨ)))

(((助詞 格助詞)
  (助詞 副助詞 * * は)
  (助詞 副助詞 * * なら)
  (助詞 副助詞 * * ったら)
  (助詞 副助詞 * * って)
  (助詞 副助詞 * * も)
  (助詞 副助詞 * * さえ)
  (助詞 副助詞 * * でも) 
  (助詞 副助詞 * * すら) 
  (助詞 副助詞 * * だって)  
  (助詞 副助詞 * * まで) 
  (助詞 副助詞 * * だけ) 
  (助詞 副助詞 * * ばかり)
  (助詞 副助詞 * * ばっかり)
  (助詞 副助詞 * * ばっか)
  (助詞 副助詞 * * のみ) 
  (助詞 副助詞 * * しか) 
  (助詞 副助詞 * * こそ) 
  (助詞 副助詞 * * など)
  (助詞 副助詞 * * なんか)  
  (助詞 副助詞 * * なんて) 
  (助詞 副助詞 * * なんぞ)
  (助詞 副助詞 * * くらい) 
  (助詞 副助詞 * * ぐらい)
  (助詞 副助詞 * * 位)
  (助詞 副助詞 * * とて)  
  (助詞 副助詞 * * じゃ)
  (助詞 終助詞 * * か)
  (助詞 終助詞 * * わ)
  (助詞 終助詞 * * ねん)
  (助詞 終助詞 * * っけ)
  (助詞 終助詞 * * かい)
  (助詞 終助詞 * * よ)
  (助詞 終助詞 * * ヨ)
  (助詞 接続助詞 * * し)
  (助詞 接続助詞 * * が)  
  (助詞 接続助詞 * * から)  
  (助詞 接続助詞 * * けれども)  
  (助詞 接続助詞 * * なら)  
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * まで)
  (助詞 接続助詞 * * なり)
  (助詞 接続助詞 * * より)
  (助詞 接続助詞 * * か)
  (助詞 接続助詞 * * きり)
  (助詞 接続助詞 * * っきり)   
  (助詞 接続助詞 * * ながら)
  (助詞 接続助詞 * * つつ)
  (助詞 接続助詞 * * から)
  (助詞 接続助詞 * * に)
  (助詞 接続助詞 * * けれど)
  (助詞 接続助詞 * * けど)
  (助詞 接続助詞 * * とどうじに)
  (助詞 接続助詞 * * まま)
  (助詞 接続助詞 * * けども)
  (助詞 接続助詞 * * ど)
  (助詞 接続助詞 * * ども)
  (助詞 接続助詞 * * も)
  (助詞 接続助詞 * * と)
  (助詞 接続助詞 * * ならびに)
  (助詞 接続助詞 * * 並びに)
  (助詞 接続助詞 * * そして))
        ((助詞 終助詞 * * な)
         (助詞 終助詞 * * なあ)
         (助詞 終助詞 * * なぁ)))

; 確認、同意／命令では用法が違う。命令は用言にしかつかない。
; 起きてナ、 早くしナ、

; 以下の終助詞は他の助詞と連接なし : ぞ, ぜ，わ，や


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               ＊ ＋ 助動詞
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

((VerbBasicForm
  IAdjBasicForm
  NaAdjDaBasicRentaiForm
  (* * 判定詞 ダ列特殊連体形)

  (* * * ダ列タ形)
  (* * * デアル列基本形)
  (* * * デアル列タ形)

  (助動詞 * 助動詞ぬ型 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形)
  (助動詞 * 助動詞ぬ型 タ形))
        ((助動詞 * 判定詞 * はずだ)             ; 活用型注意
         (助動詞 * ナノ形容詞 * ばかりだ)       ; 追加 94/02/25
         (助動詞 * ナノ形容詞 * ばっかりだ)
         (助動詞 * ナノ形容詞 * ばっかだ)
         (助動詞 * ナ形容詞 * ようだ)
         (助動詞 * ナ形容詞 * ふうだ))
)

((VerbBasicForm
  IAdjBasicForm
  (* * * ダ列基本連体形)
  (* * * ダ列タ形)
  (* * * デアル列基本形)
  (* * * デアル列タ形)
  (* * * デス列基本形)		; 「学生ですので」	01/08/01
  (* * * デス列タ形)		; 「学生でしたので」	01/08/01
  (* * * ヤ列基本形)
  (* * * ヤ列タ形)
  (助動詞 * 無活用型 基本形)	; 助動詞「です」	01/08/01

  (助動詞 * 助動詞ぬ型 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形)
  (助動詞 * 助動詞ぬ型 タ形))
        ((助動詞 * ナ形容詞 * のだ)
         (助動詞 * ナ形容詞 * わけだ))
)

((VerbBasicForm
  IAdjBasicForm
  (* * * ダ列基本連体形)
  (* * * ダ列タ形)
  (* * * デアル列基本形)
  (* * * デアル列タ形)
  (* * * デス列基本形)
  (* * * デス列タ形)
  (* * * ヤ列基本形)
  (* * * ヤ列タ形)
  (助動詞 * 無活用型 基本形)

  (動詞 * * タ系連用テ形)		; 06/07/16 「どうなってんだろう」
  (接尾辞 動詞性接尾辞 * タ系連用テ形)
  (助動詞 * 助動詞ぬ型 タ系連用テ形))
        ((助動詞 * ナ形容詞 * んだ))
)

((VerbBasicForm
  (助動詞 * 助動詞ぬ型 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形))
        ((助動詞 * 無活用型 * ことだ)
         (助動詞 * 判定詞 * つもりだ)); 活用型注意
)

((VerbBasicForm			; 「書くだろう」
  IAdjBasicForm			; 「美しいだろう」
  (* * * ダ列タ形)		; 「〜だっただろう」
  (* * * デアル列基本形)	; 「〜であるだろう」
  (* * * デアル列タ形)		; 「〜であっただろう」
  (助動詞 * 助動詞ぬ型 基本形)		; 「書か ぬ だろう/でしょう」※実は「ぬだろう」は一語
  (助動詞 * 助動詞ぬ型 音便基本形))	; 「書か ん だろう/でしょう」※実は「んだろう」は一語
        ((助動詞 * 助動詞だろう型))
)

((BackwardAllNominal
  VerbBasicForm
  IAdjBasicForm
  NaAdjBasicForm
  NaAdjStem
  (助動詞 * 判定詞 語幹))
        ((助動詞 * イ形容詞イ段 * らしい)
         (助動詞 * ナ形容詞 * みたいだ))
)

((IAdjBasicForm)
        ((助動詞 * 無活用型 * です))
)

((VerbBasicForm

  IAdjBasicForm

  NaAdjDaBasicBasicForm		; 「静かだそうだ」
  (* * * ダ列タ形)		; 「静かだったそうだ」
  (* * * デアル列基本形)	; 「静かであるそうだ」
  (* * * デアル列タ形)		; 「静かであったそうだ」
				; ※デス列は付かない
  (助動詞 * 助動詞ぬ型 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形)
  (助動詞 * 助動詞ぬ型 タ形))
        ((助動詞 * 助動詞そうだ型 * そうだ))
)

((VerbBasicBasicForm
  (動詞 * サ変動詞 文語基本形)  ; 追加 (「すべき」) 94/01/17 kuro
  (接尾辞 動詞性接尾辞 サ変動詞 文語基本形)

  (動詞 * ザ変動詞 文語基本形)  ; 追加 (「講ずべき」) 

  (* * * デアル列基本形)

  (助動詞 * 助動詞ぬ型 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形))
        ((助動詞 * ナ形容詞 * べきだ)
         (助動詞 * 助動詞く型 * べし))        ; 追加 96/05/07
)

((VerbBasicForm
  (* * * デアル列基本形)
  (判定詞 * 判定詞 ダ列特殊連体形)
				; 「太郎のごとし」
  (助動詞 * 助動詞ぬ型 基本形)
  (助動詞 * 助動詞ぬ型 音便基本形)

  (助詞 接続助詞 * * が))	; 「眠るがごとく」
				; ▼「太郎がごとし」のように動詞的に働く場合
				; は扱えていない
        ((助動詞 * 助動詞く型 * ごとし)
	 (助動詞 * 助動詞く型 * 如し)))

((VerbBasicBasicForm
  (動詞 * 母音動詞 基本連用形)
  (動詞 * サ変動詞 基本連用形)
  (接尾辞 動詞性接尾辞 母音動詞 基本連用形))
        ((助動詞 *  無活用型 * まい))
)

(((動詞 * * 未然形)
  (接尾辞 動詞性接尾辞 * 未然形)
  (* * * 文語未然形))			; 「せぬ」,「美しからず」
        ((助動詞 * 助動詞ぬ型 * ぬ))
)

(((動詞 * サ変動詞 未然形)
  (動詞 * ザ変動詞 未然形)
  (接尾辞 動詞性接尾辞 サ変動詞 未然形))
        ((助動詞 * 助動詞ぬ型 * ぬ))	; サ変について上の定義を修正
 0 )
; ※ 「ない」の接続の定義では動詞の活用をすべて書いているが，ここれでは
; このように後から例外を削除している．記述方法が不統一なのは問題．

(((動詞 * サ変動詞 基本連用形)
  (動詞 * ザ変動詞 基本連用形)
  (接尾辞 動詞性接尾辞 サ変動詞 基本連用形))
	((助動詞 * 助動詞ぬ型 タ系連用テ形 ぬ))	
)
; 「しないで」などのため．しかし「ないで」を「ぬ」の活用として扱って
; いることは妥当でない．

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               優先規則
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 優先規則では，細かい問題(動詞連用形を名詞とみなす問題や，接辞の問題な
; ど)は扱わない．それらを考慮しても，むしろ副作用を生むことの方が多い．

; 非常に有効な規則(形式名詞の指定と重複するが、優先規則なので改めて書く)

((BunsetsuEndSentenceEnd
  BunsetsuEnd
  (助詞 接続助詞 * * の))
        ((名詞)
	 (未定義語)
    	 (接頭辞 名詞接頭辞)
         (指示詞 名詞形態指示詞)

         (形容詞 * ナ形容詞 語幹)	; added by kuro on 03/04/02
         (形容詞 * ナ形容詞特殊 語幹)
         (形容詞 * ナノ形容詞 語幹))
 4 )

; かなり有効な規則

(((助詞 格助詞)
  (助詞 副助詞)
  (接尾辞 名詞性名詞助数辞)
  AdverbialSuffix)
        ((動詞)
         (形容詞)
         (名詞 サ変名詞))	; added by kuro on 00/03/29
 8 )

; これと同じ感じで，「副詞＋形容詞」などを優先することも考えられるが，
; 「これに*合わせて*積極的に‥」というように副詞とはならないケースも多い

; 誤りもあるが，解を絞りたいという場合には有効な規則

(((文頭)
  (特殊 句点))
        ((副詞)
         (接続詞))
 8 )

; 動詞連用形を BackwardAllNominal としているが，名詞と競合する
; 場合に名詞を優先するようにするために以下のペナルティを与える

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (感動詞))
        (NominalFollow)
 20 )

; 基本連用形と名詞性名詞接尾辞の接続の一般化は難しい
; 当面，つくものを個別指定
;
; 付かない例)
;   対し近く 整列させ上から 強い者 とりわけ下流域
; 付く例)
;   試み自体 伸び率 狙い通り 勝ち数 休みなし 切り目 つかみどころ 受け入れ側
;   売り出し中 切り下げ後 足洗い用 幕引き以外

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形))
        ((接尾辞 名詞性名詞接尾辞))
 0 )

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形))
        ((接尾辞 名詞性名詞接尾辞 * * 自体)
         (接尾辞 名詞性名詞接尾辞 * * 率)
         (接尾辞 名詞性名詞接尾辞 * * 通り)
         (接尾辞 名詞性名詞接尾辞 * * どおり)
         (接尾辞 名詞性名詞接尾辞 * * 数)
         (接尾辞 名詞性名詞接尾辞 * * なし)
         (接尾辞 名詞性名詞接尾辞 * * 目)
         (接尾辞 名詞性名詞接尾辞 * * どころ)
         (接尾辞 名詞性名詞接尾辞 * * ごと)
         (接尾辞 名詞性名詞接尾辞 * * 側)
         (接尾辞 名詞性名詞接尾辞 * * 中)
         (接尾辞 名詞性名詞接尾辞 * * 前)
         (接尾辞 名詞性名詞接尾辞 * * 後)
         (接尾辞 名詞性名詞接尾辞 * * 用)
         (接尾辞 名詞性名詞接尾辞 * * 以外)
         (接尾辞 名詞性名詞接尾辞 * * 作り)
         (接尾辞 名詞性名詞接尾辞 * * づくり)
         (接尾辞 名詞性名詞接尾辞 * * 型)
         (接尾辞 名詞性名詞接尾辞 * * さん))
 20 )


; ただし助詞「に」,「ながら」は本来基本連用形に接続するものなので，
; コスト10(default)にもどす

(((動詞 * * 基本連用形)
  (接尾辞 動詞性接尾辞 * 基本連用形)
  (感動詞))
        ((助詞 格助詞 * * に)		; 「書きに帰る」
         (助詞 接続助詞 * * ながら))	; 「書きながら帰る」
 10 )

; 文頭の「はい」「いいえ」などは感動詞とする

(((文頭))
        ((感動詞))
 7 )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               解析誤りを防ぐためのペナルティ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((副詞))                               ; ←→「ことに(副詞)なり」など
        ((助詞 接続助詞 * * なり))
 100 )

(((動詞 * * 基本連用形)                 ; ←→「み(動詞)ないし」など
  (接尾辞 動詞性接尾辞 * 基本連用形))
        ((助詞 接続助詞 * * ないし))
 100 )

(((判定詞 * 判定詞 ダ列特殊連体形 だ))	; ←→「ので」
        ((動詞 * 母音動詞 基本連用形 でる))
 100 )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;               連語の固有の連接規則
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(((* * * 意志形))
        ((連語 * * * にも)))                    ;「書こうにも」

(((名詞 数詞)					; 06/07/18 「１００もの」
  (接尾辞 名詞性名詞助数辞)			; 「１００台もの」
  (接尾辞 名詞性名詞接尾辞 * * 以上)		; 「１００人以上もの」
  (接尾辞 名詞性名詞接尾辞 * * 近く)		; 06/07/18 「１００人近くもの」
  (接尾辞 名詞性名詞接尾辞 * * 前後))		; 06/07/18 「１００人前後もの」
        ((連語 * * * もの)))

(((名詞 数詞 * * いく))
        ((連語 * * * もの))
0 )
; ※ <--> 「いくもの」 06/07/18

((VerbBasicForm
  IAdjBasicForm
  NaAdjBasicForm)
        ((連語 * * * やに)	; 「しているやに見える」
         (連語 * * * やも)))	; 「しているやも知れず」

(((連語 * * * のに))	; 形式名詞＋格助詞で「書くのに続いて」などのため
	((動詞)		; 後の接続によってこの連語を使う場合を制限
	 (形容詞)
	 (名詞 サ変名詞)
         (未定義語)
	 (副詞)
	 (助詞 副助詞)))

((BunsetsuEndSentenceEnd
  BunsetsuEnd)
        ((連語 * * * へんで)))

(((動詞 * * タ系連用テ形)
  (接尾辞 動詞性接尾辞 * タ系連用テ形)
  (助動詞 * 助動詞ぬ型 タ系連用テ形))
        ((連語 * 子音動詞カ行促音便形 基本連用形 おいく); おいき
         (連語 * 母音動詞 基本連用形 おくれる)          ; おくれ
         (連語 * 子音動詞ワ行 基本連用形 おもらう)      ; おもらい
         (連語 * 子音動詞ワ行 基本連用形 おしまう)))    ; おしまい

(((動詞 * * タ系連用テ形)
  (接尾辞 動詞性接尾辞 * タ系連用テ形)
  (助動詞 * 助動詞ぬ型 タ系連用テ形))
        ((連語 * 母音動詞 * はいる)
         (連語 * 母音動詞 * もいる)
         (連語 * 母音動詞 * すらいる)
         (連語 * 母音動詞 * さえいる)
         (連語 * 母音動詞 * はみる)
         (連語 * 母音動詞 * もみる)
         (連語 * 母音動詞 * すらみる)
         (連語 * 母音動詞 * さえみる)
         (連語 * カ変動詞 * はくる)
         (連語 * カ変動詞 * もくる)
         (連語 * カ変動詞 * すらくる)
         (連語 * カ変動詞 * さえくる)
         (連語 * 子音動詞カ行 * はおく)
         (連語 * 子音動詞カ行 * もおく)
         (連語 * 子音動詞カ行 * すらおく)
         (連語 * 子音動詞カ行 * さえおく)
         (連語 * 子音動詞ラ行 * はおる)
         (連語 * 子音動詞ラ行 * もおる)
         (連語 * 子音動詞ラ行 * すらおる)
         (連語 * 子音動詞ラ行 * さえおる)
         (連語 * 子音動詞カ行促音便形 * はいく)
         (連語 * 子音動詞カ行促音便形 * もいく)
         (連語 * 子音動詞カ行促音便形 * すらいく)
         (連語 * 子音動詞カ行促音便形 * さえいく)
         (連語 * 母音動詞 * はくれる)
         (連語 * 母音動詞 * もくれる)
         (連語 * 母音動詞 * すらくれる)
         (連語 * 母音動詞 * さえくれる)
         (連語 * 子音動詞ワ行 * はもらう)
         (連語 * 子音動詞ワ行 * ももらう)
         (連語 * 子音動詞ワ行 * すらもらう)
         (連語 * 子音動詞ワ行 * さえもらう)))

((IAdjBasicRenyoForm
  (* * * ダ列基本連用形)
  (* * タル形容詞 基本連用形)
  (* * * タ系連用タリ形)
  (* * * ダ列タ系連用タリ形)
  (* * * デアル列タ系連用タリ形)
  (* * * デス列タ系連用タリ形)
  (* * * ヤ列タ系連用タリ形)

  (動詞 * * 基本連用形)         	; 「書きはする」
  (接尾辞 動詞性接尾辞 * 基本連用形))	;  ※「する」単独では接続不可

        ((連語 * サ変動詞 * はする)
         (連語 * サ変動詞 * もする)
         (連語 * サ変動詞 * すらする)
         (連語 * サ変動詞 * さえする)))

((IAdjBasicRenyoForm
  (* * * ダ列基本連用形)
  (* * タル形容詞 基本連用形))
        ((連語 * 子音動詞ラ行 * はなる)
         (連語 * 子音動詞ラ行 * もなる)
         (連語 * 子音動詞ラ行 * すらなる)
         (連語 * 子音動詞ラ行 * さえなる)))
  
((IAdjBasicRenyoForm
  (* * * ダ列タ系連用テ形)		; 「破壊的ではある」
  (接尾辞 形容詞性述語接尾辞 ナ形容詞 ダ列基本連用形 そうだ) 
    					; 「〜そうにはない」
  (接尾辞 形容詞性述語接尾辞 ナ形容詞 語幹 そうだ)
    					; 「〜そうもない」

  (動詞 * * タ系連用テ形)		; 98/12/11追加
  (接尾辞 動詞性接尾辞 * タ系連用テ形)	;「書いてもない」
  (助動詞 * 助動詞ぬ型 タ系連用テ形))	;
        ((連語 * イ形容詞アウオ段 * はない)
         (連語 * イ形容詞アウオ段 * もない)
         (連語 * イ形容詞アウオ段 * すらない)
         (連語 * イ形容詞アウオ段 * さえない)))

(((動詞 * * タ系連用テ形)
  (接尾辞 動詞性接尾辞 * タ系連用テ形)
  (助動詞 * 助動詞ぬ型 タ系連用テ形)
  IAdjBasicRenyoForm
  (* * * ダ列タ系連用テ形))		; 「破壊的ではある」
        ((連語 * 子音動詞ラ行 * はある)
         (連語 * 子音動詞ラ行 * もある)
         (連語 * 子音動詞ラ行 * すらある)
         (連語 * 子音動詞ラ行 * さえある)))

((VerbBasicForm         	;「書くではない(か)」
  (* * * 意志形)		;「書こうではない(か)」
  IAdjBasicForm         	;「美しいではない(か)」
  (* * * ダ列タ形)		;「静かだったではない(か)」
  (* * * デアル列基本形)	;「静かであるではない(か)」
  (* * * デアル列タ形))        ;「静かであったではない(か)」
        ((連語 * イ形容詞アウオ段 * ではない)
         (連語 * イ形容詞アウオ段 * じゃない)
         (連語 * イ形容詞アウオ段 * でもない)))
; 広くとれば引用と同じか ？ 「書きますではなく，書け」

(((連語 * 子音動詞ワ行 命令形 とはいえ))
        (BunsetsuTop
         (特殊 読点)
         (特殊 括弧始)))

(((副詞)			;「どうにもならない」「何にもならない」
  (助詞 格助詞 * * に)		;「〜にならない」
  (助詞 格助詞 * * と)		;「〜とならない」
  (助詞 格助詞 * * っと))
        ((連語 * イ形容詞アウオ段 * ならない)))

(((名詞 サ変名詞)
  (未定義語)
  (接尾辞 名詞性名詞接尾辞 * * 化)
  (接尾辞 名詞性名詞助数辞 * * 倍)
  (接尾辞 名詞性名詞助数辞 * * 戦)
  (接尾辞 名詞性名詞助数辞 * * 勝)
  (接尾辞 名詞性名詞助数辞 * * 敗)
  (接尾辞 名詞性名詞助数辞 * * 泊)
  (接尾辞 名詞性名詞接尾辞 * * 入り)
  (接尾辞 名詞性名詞接尾辞 * * あけ))
        ((連語 * イ形容詞アウオ段 * しようがない)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;		辞書定義文などを解析する場合の特別規則
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;(((* * * 命令形)
;  (* * * 文語命令形)
;  (* * * 文語基本形)
;  (* * * デアル列命令形)
;  (* * * 意志形)	; 「つごう」
;  (* * * 省略意志形)	; 「まと」
;  (助詞 終助詞))
;         ((文末)
;          (特殊 句点)) 0 )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
