; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=slp-vectorizer -mtriple=riscv64 -mattr=+v \
; RUN: -riscv-v-vector-bits-min=128 -riscv-v-slp-max-vf=0 -S | FileCheck %s --check-prefixes=CHECK,CHECK-128
; RUN: opt < %s -passes=slp-vectorizer -mtriple=riscv64 -mattr=+v \
; RUN: -riscv-v-vector-bits-min=256 -riscv-v-slp-max-vf=0 -S | FileCheck %s --check-prefixes=CHECK,CHECK-256
; RUN: opt < %s -passes=slp-vectorizer -mtriple=riscv64 -mattr=+v \
; RUN: -riscv-v-vector-bits-min=512 -riscv-v-slp-max-vf=0 -S | FileCheck %s --check-prefixes=CHECK,CHECK-512

target datalayout = "e-m:e-p:64:64-i64:64-i128:128-n64-S128"
target triple = "riscv64"

define void @foo(ptr nocapture writeonly %da) {
; CHECK-128-LABEL: @foo(
; CHECK-128-NEXT:  entry:
; CHECK-128-NEXT:    store i64 0, ptr [[DA:%.*]], align 8
; CHECK-128-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i64, ptr [[DA]], i64 1
; CHECK-128-NEXT:    store i64 0, ptr [[ARRAYIDX1]], align 8
; CHECK-128-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i64, ptr [[DA]], i64 2
; CHECK-128-NEXT:    store i64 0, ptr [[ARRAYIDX2]], align 8
; CHECK-128-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds i64, ptr [[DA]], i64 3
; CHECK-128-NEXT:    store i64 0, ptr [[ARRAYIDX3]], align 8
; CHECK-128-NEXT:    ret void
;
; CHECK-256-LABEL: @foo(
; CHECK-256-NEXT:  entry:
; CHECK-256-NEXT:    store <4 x i64> zeroinitializer, ptr [[DA:%.*]], align 8
; CHECK-256-NEXT:    ret void
;
; CHECK-512-LABEL: @foo(
; CHECK-512-NEXT:  entry:
; CHECK-512-NEXT:    store <4 x i64> zeroinitializer, ptr [[DA:%.*]], align 8
; CHECK-512-NEXT:    ret void
;
entry:
  store i64 0, ptr %da, align 8
  %arrayidx1 = getelementptr inbounds i64, ptr %da, i64 1
  store i64 0, ptr %arrayidx1, align 8
  %arrayidx2 = getelementptr inbounds i64, ptr %da, i64 2
  store i64 0, ptr %arrayidx2, align 8
  %arrayidx3 = getelementptr inbounds i64, ptr %da, i64 3
  store i64 0, ptr %arrayidx3, align 8
  ret void
}

define void @foo8(ptr nocapture writeonly %da) {
; CHECK-LABEL: @foo8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i8 0, ptr [[DA:%.*]], align 8
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, ptr [[DA]], i8 1
; CHECK-NEXT:    store i8 0, ptr [[ARRAYIDX1]], align 8
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i8, ptr [[DA]], i8 2
; CHECK-NEXT:    ret void
;
entry:
  store i8 0, ptr %da, align 8
  %arrayidx1 = getelementptr inbounds i8, ptr %da, i8 1
  store i8 0, ptr %arrayidx1, align 8
  %arrayidx2 = getelementptr inbounds i8, ptr %da, i8 2
  ret void
}
