/*  Lziprecover - Data recovery tool for the lzip format
    Copyright (C) 2009-2015 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class File_index
  {
  struct Member
    {
    Block dblock, mblock;		// data block, member block

    Member( const long long dp, const long long ds,
            const long long mp, const long long ms )
      : dblock( dp, ds ), mblock( mp, ms ) {}

    bool operator==( const Member & m ) const { return ( mblock == m.mblock ); }
    bool operator!=( const Member & m ) const { return ( mblock != m.mblock ); }
    };

  std::vector< Member > member_vector;
  std::string error_;
  long long isize;
  int retval_;

  void set_errno_error( const char * const msg );
  void set_num_error( const char * const msg1, unsigned long long num,
                      const char * const msg2 = "." );

public:
  File_index() : error_( "No index." ), isize( 0 ), retval_( 2 ) {}
  explicit File_index( const int infd );
  File_index( const std::vector< int > & infd_vector, const long long fsize );

  long members() const { return member_vector.size(); }
  const std::string & error() const { return error_; }
  int retval() const { return retval_; }

  bool operator==( const File_index & fi ) const
    {
    if( retval_ || fi.retval_ || isize != fi.isize ||
        member_vector.size() != fi.member_vector.size() ) return false;
    for( unsigned long i = 0; i < member_vector.size(); ++i )
      if( member_vector[i] != fi.member_vector[i] ) return false;
    return true;
    }
  bool operator!=( const File_index & fi ) const { return !( *this == fi ); }

  long long data_end() const
    { if( member_vector.size() ) return member_vector.back().dblock.end();
      else return 0; }

  long long file_end() const
    { if( member_vector.size() ) return member_vector.back().mblock.end();
      else return 0; }

  // total size including trailing garbage (if any)
  long long file_size() const
    { if( isize >= 0 ) return isize; else return 0; }

  const Block & dblock( const long i ) const
    { return member_vector[i].dblock; }
  const Block & mblock( const long i ) const
    { return member_vector[i].mblock; }
  };
