/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQLayerModel_H
#define MvQLayerModel_H

#include <QAbstractItemModel>
#include <QIcon>
#include <QList>
#include <QStyledItemDelegate>
#include <QStyleOptionViewItem>

class MgQLayerItem;
class MgQPlotScene;
class MgQSceneItem;
class MvQLayerContentsIcon;

#include "MgQLayerItem.h"
#include "MgQSceneItem.h"


//class MetaDataCollector;

using namespace std;

class MvQLayerDelegate : public QStyledItemDelegate
{
public:

	MvQLayerDelegate(QWidget* parent=0);
	void paint(QPainter *painter,const QStyleOptionViewItem &option,
		           const QModelIndex& index) const;
	QSize sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index ) const;

private:
	int itemHeight_;
};


class MvQLayerModel : public QAbstractItemModel
{
	Q_OBJECT

public:
   	MvQLayerModel(MgQPlotScene*);
 	~MvQLayerModel();

   	int columnCount (const QModelIndex& parent = QModelIndex() ) const;
   	int rowCount (const QModelIndex& parent = QModelIndex() ) const;

   	QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
   	bool setData( const QModelIndex &, const QVariant &, int role = Qt::EditRole ); 
	QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;
 
   	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;
	
	QList<MgQLayerItem*>& layers() {return layers_;}
	MgQLayerItem* layer(const QModelIndex&) const;
	string layerId(const QModelIndex&);
	QString layerName(const QModelIndex&);
	void layerMetaData(const QModelIndex&,MetaDataCollector&);
	QString layerMetaData(const QModelIndex&,QString);

	void layersAreAboutToChange();
	void resetLayers(MgQSceneItem*);

	void moveUp(const QModelIndex& index);
	void moveDown(const QModelIndex& index);
	void moveTop(const QModelIndex& index);
	void moveBottom(const QModelIndex& index);

	Qt::ItemFlags flags ( const QModelIndex &) const;

	Qt::DropActions supportedDropActions() const;
	QStringList mimeTypes() const;
	QMimeData* mimeData(const QModelIndexList &) const;
	bool dropMimeData(const QMimeData *data,
     			Qt::DropAction action, int row, int column, 
			const QModelIndex &parent);

	void setTransparency(const QModelIndex&,int );
	int transparency(const QModelIndex&);
	MgQLayerItem* rowToLayer(int) const;
	int layerToRow(MgQLayerItem*) const;
	int indexToLevel(const QModelIndex&) const;
	MvQLayerContentsIcon* indexToIcon(const QModelIndex&) const;
	
signals:
	void layerVisibilityChanged(QString,bool);
	void layerTransparencyChanged(QString,int);
	void layerStackingOrderChanged(QList<QPair<QString,int> >);
	void layerUpdate();
	void layerDragFinished();

protected:
	void clearIcons();
	MvQLayerContentsIcon* layerIcon(MgQLayerItem*,int) const;
	int rowToStackLevel(int row);
	QString label(MgQLayerItem*,const int,const int) const;
	int idToLevel(int) const;
	int idToParentRow(int) const;
	void moveLayer(int,int);

	
	MgQPlotScene *scene_;
	MgQSceneItem* sceneItem_;
	QList<MgQLayerItem*> layers_;
	Qt::CheckState state_;			
	mutable QHash<MgQLayerItem*,QList<MvQLayerContentsIcon*> > icons_;
};




#endif 
