/* $Id: Cit_pat.cpp 272611 2011-04-08 18:57:08Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'biblio.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/biblio/Cit_pat.hpp>
#include <objects/general/Date.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CCit_pat::~CCit_pat(void)
{
}


bool CCit_pat::GetLabelV1(string* label, TLabelFlags) const
{
    string date;
    string* date_ptr = &date;
    if ( IsSetDate_issue() ) {
        GetDate_issue().GetDate(&date, true);
    }
    else if ( IsSetApp_date() ) {
        GetApp_date().GetDate(&date, true);
    }
    else {
        date_ptr = 0;
    }

    return x_GetLabelV1(label, false, &GetAuthors(), 0, 0, 0, 0,
        &GetCountry(),
        IsSetNumber() ? &GetNumber() :
            (IsSetApp_number() ? &GetApp_number() : 0),
        0, date_ptr);
}


bool CCit_pat::GetLabelV2(string* label, TLabelFlags flags) const
{
    // The C equivalent (FormatCitPat from asn2gnb5.c) additionally
    // consults Patent-seq-id objects, which are neither available nor
    // usable here.  This implementation necessarily treats them as
    // absent. :-/
    MaybeAddSpace(label);

    if ((flags & fLabel_FlatNCBI) != 0) {
        *label += "Patent: ";
    } else if ((flags & fLabel_FlatEMBL) != 0) {
        *label += "Patent number ";
    }

    if (HasText(GetCountry())) {
        *label += GetCountry();
        if ((flags & (fLabel_FlatNCBI | fLabel_FlatEMBL)) != 0) {
            *label += ' ';
        }
    }

    if (CanGetNumber()  &&  HasText(GetNumber())) {
        *label += GetNumber();
    } else if (CanGetApp_number()  &&  HasText(GetApp_number())) {
        *label += '(' + GetApp_number() + ')';
    }

    if (HasText(GetDoc_type())) {
        *label += '-' + GetDoc_type();
    }

    *label += ' ';
    {{
        string date;
        if (CanGetDate_issue()) {
            GetDate_issue().GetDate(&date, "%{%2D%|01%}-%{%3N%|JAN%}-%Y");
        } else if (CanGetApp_date()) {
            GetApp_date().GetDate(&date, "%{%2D%|01%}-%{%3N%|JAN%}-%Y");
        }
        *label += date;
    }}

    if ((flags & fLabel_FlatNCBI) != 0) {
        *label += ';';
    } else if ((flags & fLabel_FlatEMBL) != 0) {
        *label += '.';
    }

    x_GetLabelV2(label, GetAuthors(), "\n");

    if (CanGetAssignees()) {
        string assignees, consortia, prefix = "\n";
        GetAssignees().GetLabel(&assignees, flags, eLabel_V2);
        GetAssignees().GetLabel(&consortia, flags | fLabel_Consortia,
                                eLabel_V2);
        if (HasText(assignees)) {
            *label += prefix + assignees + ';';
            prefix = HasText(consortia) ? kEmptyStr : " ";
        }
        if (HasText(consortia)) {
            *label += prefix + consortia + ';';
            prefix = " ";
        }
        x_GetLabelV2(label, GetAssignees(), prefix);
    }

    return true;
}


// Based on FormatCitPat from the C Toolkit's api/asn2gnb5.c.
bool CCit_pat::x_GetLabelV2(string* label, const CAuth_list& authors,
                            string prefix)
{
    if ( !authors.CanGetAffil() ) {
        return false;
    }

    switch (authors.GetAffil().Which()) {
    case CAffil::e_Str:
        if (HasText(authors.GetAffil().GetStr())) {
            if (prefix == "\n") {
                *label += prefix;
            }
            *label += authors.GetAffil().GetStr();
        }
        return true;

    case CAffil::e_Std:
    {
        const CAffil::TStd& std = authors.GetAffil().GetStd();
        if (std.CanGetAffil()  &&  HasText(std.GetAffil())) {
            if (prefix == "\n") {
                *label += prefix;
            }
            *label += std.GetAffil() + ';';
            prefix = " ";
        }
        if (std.CanGetStreet()  &&  HasText(std.GetStreet())) {
            *label += prefix + std.GetStreet() + ';';
            prefix = " ";
        }
        if (std.CanGetDiv()  &&  HasText(std.GetDiv())) {
            *label += prefix + std.GetDiv() + ';';
            prefix = " ";
        }
        if (std.CanGetCity()  &&  HasText(std.GetCity())) {
            *label += prefix + std.GetCity();
            prefix = ", ";
        }
        if (std.CanGetSub()  &&  HasText(std.GetSub())) {
            *label += prefix + std.GetSub();
        }
        if (std.CanGetCountry()  &&  HasText(std.GetCountry())) {
            if (prefix == "\n") {
                *label += prefix;
            }
            *label += ";\n" + std.GetCountry() + ';';
        }
        return true;
    }

    default:
        return false;
    }

    return false;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1880, CRC32: 6bbed461 */
