/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.mobility.javon;

import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.mobility.e2e.mapping.*;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;

/**
 *
 * @author Michal Skvor
 */
public abstract class JavonTemplate {
    
    /** Registry of classes */
    protected ClassDataRegistry registry;
    /** Javon mapping */
    protected JavonMapping mapping;
        
    /**
     * 
     * @param mapping 
     */
    public JavonTemplate( JavonMapping mapping ) {
        this.mapping = mapping;
        this.registry = mapping.getRegistry();
    }
    
    @SuppressWarnings( value = "unused" )
    private JavonTemplate() {}
    
    /**
     * Return array of all available targets
     * 
     * @return array of available targets
     */
    public abstract Set<String> getTargets();
    
    /**
     * Generate file for given output
     * 
     * @param ph progress handle 
     * @param target for generation
     * @return true when the operation ended succesfuly
     */
    public abstract boolean generateTarget( ProgressHandle ph, String target );    
}
