---
id: fast-components
title: fast-components 
hide_title: false
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->



## Classes

|  Class | Description |
|  --- | --- |
|  [Anchor](./fast-components.anchor.md) | Base class for Anchor |
|  [Avatar](./fast-components.avatar.md) | The FAST Avatar Class |
|  [Combobox](./fast-components.combobox.md) | Base class for Combobox. |
|  [DirectionalStyleSheetBehavior](./fast-components.directionalstylesheetbehavior.md) | Behavior to conditionally apply LTR and RTL stylesheets. To determine which to apply, the behavior will use the nearest DesignSystemProvider's 'direction' design system value. |
|  [Listbox](./fast-components.listbox.md) | Base class for Listbox. |
|  [Menu](./fast-components.menu.md) |  |
|  [PickerMenu](./fast-components.pickermenu.md) |  |
|  [Select](./fast-components.select.md) | Base class for Select. |

## Functions

|  Function | Description |
|  --- | --- |
|  [isDark(color)](./fast-components.isdark.md) | Determines if a color should be considered Dark Mode |
|  [provideFASTDesignSystem(element)](./fast-components.providefastdesignsystem.md) | Provides a design system for the specified element either by returning one that was already created for that element or creating one. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [ColorRecipe](./fast-components.colorrecipe.md) |  |
|  [InteractiveColorRecipe](./fast-components.interactivecolorrecipe.md) |  |
|  [InteractiveSwatchSet](./fast-components.interactiveswatchset.md) |  |
|  [Palette](./fast-components.palette.md) | A collection of [Swatch](./fast-components.swatch.md) instances |
|  [Recipe](./fast-components.recipe.md) |  |
|  [Swatch](./fast-components.swatch.md) | Represents a color in a [Palette](./fast-components.palette.md) |
|  [SwatchRGB](./fast-components.swatchrgb.md) |  |

## Variables

|  Variable | Description |
|  --- | --- |
|  [accentColor](./fast-components.accentcolor.md) |  |
|  [accentFillActive](./fast-components.accentfillactive.md) |  |
|  [accentFillActiveDelta](./fast-components.accentfillactivedelta.md) |  |
|  [accentFillFocus](./fast-components.accentfillfocus.md) |  |
|  [accentFillFocusDelta](./fast-components.accentfillfocusdelta.md) |  |
|  [accentFillHover](./fast-components.accentfillhover.md) |  |
|  [accentFillHoverDelta](./fast-components.accentfillhoverdelta.md) |  |
|  [accentFillRecipe](./fast-components.accentfillrecipe.md) |  |
|  [accentFillRest](./fast-components.accentfillrest.md) |  |
|  [accentFillRestDelta](./fast-components.accentfillrestdelta.md) |  |
|  [accentForegroundActive](./fast-components.accentforegroundactive.md) |  |
|  [accentForegroundActiveDelta](./fast-components.accentforegroundactivedelta.md) |  |
|  [accentForegroundFocus](./fast-components.accentforegroundfocus.md) |  |
|  [accentForegroundFocusDelta](./fast-components.accentforegroundfocusdelta.md) |  |
|  [accentForegroundHover](./fast-components.accentforegroundhover.md) |  |
|  [accentForegroundHoverDelta](./fast-components.accentforegroundhoverdelta.md) |  |
|  [accentForegroundRecipe](./fast-components.accentforegroundrecipe.md) |  |
|  [accentForegroundRest](./fast-components.accentforegroundrest.md) |  |
|  [accentForegroundRestDelta](./fast-components.accentforegroundrestdelta.md) |  |
|  [accentPalette](./fast-components.accentpalette.md) |  |
|  [accordionItemStyles](./fast-components.accordionitemstyles.md) | Styles for AccordionItem |
|  [accordionStyles](./fast-components.accordionstyles.md) | Styles for Accordion |
|  [ActionsStyles](./fast-components.actionsstyles.md) | Styles used for the flipper container and gradient fade actions |
|  [allComponents](./fast-components.allcomponents.md) | All Web Components |
|  [anchoredRegionStyles](./fast-components.anchoredregionstyles.md) | Styles for AnchoredRegion |
|  [anchorStyles](./fast-components.anchorstyles.md) | Styles for Anchor |
|  [avatarStyles](./fast-components.avatarstyles.md) | Styles for Avatar |
|  [badgeStyles](./fast-components.badgestyles.md) | Styles for Badge |
|  [baseHeightMultiplier](./fast-components.baseheightmultiplier.md) |  |
|  [baseHorizontalSpacingMultiplier](./fast-components.basehorizontalspacingmultiplier.md) |  |
|  [baseLayerLuminance](./fast-components.baselayerluminance.md) |  |
|  [bodyFont](./fast-components.bodyfont.md) |  |
|  [breadcrumbItemStyles](./fast-components.breadcrumbitemstyles.md) | Styles for Breadcrumb item |
|  [breadcrumbStyles](./fast-components.breadcrumbstyles.md) | Styles for Breadcrumb |
|  [buttonStyles](./fast-components.buttonstyles.md) | Styles for Button |
|  [CalendarStyles](./fast-components.calendarstyles.md) | Styles for Calendar |
|  [cardStyles](./fast-components.cardstyles.md) | Styles for Card |
|  [checkboxStyles](./fast-components.checkboxstyles.md) | Styles for Checkbox |
|  [comboboxStyles](./fast-components.comboboxstyles.md) | Styles for Combobox |
|  [controlCornerRadius](./fast-components.controlcornerradius.md) |  |
|  [dataGridCellStyles](./fast-components.datagridcellstyles.md) | Styles for Data Grid cell |
|  [dataGridRowStyles](./fast-components.datagridrowstyles.md) | Styles for Data Grid row |
|  [dataGridStyles](./fast-components.datagridstyles.md) | Styles for Data Grid |
|  [density](./fast-components.density.md) |  |
|  [designSystemProviderStyles](./fast-components.designsystemproviderstyles.md) | Styles for DesignSystemProvider. |
|  [designSystemProviderTemplate](./fast-components.designsystemprovidertemplate.md) | Template for DesignSystemProvider. |
|  [designUnit](./fast-components.designunit.md) |  |
|  [dialogStyles](./fast-components.dialogstyles.md) | Styles for Dialog |
|  [direction](./fast-components.direction.md) |  |
|  [disabledOpacity](./fast-components.disabledopacity.md) |  |
|  [disclosureStyles](./fast-components.disclosurestyles.md) | Styles for Disclosure |
|  [dividerStyles](./fast-components.dividerstyles.md) | Styles for Divider |
|  [fastAccordion](./fast-components.fastaccordion.md) | A function that returns a [Accordion](./fast-foundation.accordion.md) registration for configuring the component with a DesignSystem. Implements [accordionTemplate](./fast-foundation.accordiontemplate.md) |
|  [fastAccordionItem](./fast-components.fastaccordionitem.md) | A function that returns a [AccordionItem](./fast-foundation.accordionitem.md) registration for configuring the component with a DesignSystem. Implements [accordionItemTemplate](./fast-foundation.accordionitemtemplate.md) |
|  [fastAnchor](./fast-components.fastanchor.md) | A function that returns a [Anchor](./fast-foundation.anchor.md) registration for configuring the component with a DesignSystem. Implements [anchorTemplate](./fast-foundation.anchortemplate.md) |
|  [fastAnchoredRegion](./fast-components.fastanchoredregion.md) | <b><i>(BETA)</i></b> A function that returns a [AnchoredRegion](./fast-foundation.anchoredregion.md) registration for configuring the component with a DesignSystem. Implements [anchoredRegionTemplate](./fast-foundation.anchoredregiontemplate.md) |
|  [fastAvatar](./fast-components.fastavatar.md) | A function that returns a [Avatar](./fast-foundation.avatar.md) registration for configuring the component with a DesignSystem. [avatarTemplate](./fast-foundation.avatartemplate.md) |
|  [fastBadge](./fast-components.fastbadge.md) | A function that returns a [Badge](./fast-foundation.badge.md) registration for configuring the component with a DesignSystem. Implements [badgeTemplate](./fast-foundation.badgetemplate.md) |
|  [fastBreadcrumb](./fast-components.fastbreadcrumb.md) | A function that returns a [Breadcrumb](./fast-foundation.breadcrumb.md) registration for configuring the component with a DesignSystem. Implements [breadcrumbTemplate](./fast-foundation.breadcrumbtemplate.md) |
|  [fastBreadcrumbItem](./fast-components.fastbreadcrumbitem.md) | A function that returns a [BreadcrumbItem](./fast-foundation.breadcrumbitem.md) registration for configuring the component with a DesignSystem. Implements [breadcrumbItemTemplate](./fast-foundation.breadcrumbitemtemplate.md) |
|  [fastButton](./fast-components.fastbutton.md) | A function that returns a [Button](./fast-foundation.button.md) registration for configuring the component with a DesignSystem. Implements [buttonTemplate](./fast-foundation.buttontemplate.md) |
|  [fastCalendar](./fast-components.fastcalendar.md) | The FAST Calendar Element. Implements [Calendar](./fast-foundation.calendar.md)<!-- -->, [calendarTemplate](./fast-foundation.calendartemplate.md) |
|  [fastCard](./fast-components.fastcard.md) | A function that returns a [Card](./fast-foundation.card.md) registration for configuring the component with a DesignSystem. Implements [cardTemplate](./fast-foundation.cardtemplate.md) |
|  [fastCheckbox](./fast-components.fastcheckbox.md) | A function that returns a [Checkbox](./fast-foundation.checkbox.md) registration for configuring the component with a DesignSystem. Implements [checkboxTemplate](./fast-foundation.checkboxtemplate.md) |
|  [fastCombobox](./fast-components.fastcombobox.md) | A function that returns a [Combobox](./fast-foundation.combobox.md) registration for configuring the component with a DesignSystem. Implements [comboboxTemplate](./fast-foundation.comboboxtemplate.md) |
|  [fastDataGrid](./fast-components.fastdatagrid.md) | A function that returns a [DataGrid](./fast-foundation.datagrid.md) registration for configuring the component with a DesignSystem. |
|  [fastDataGridCell](./fast-components.fastdatagridcell.md) | A function that returns a [DataGridCell](./fast-foundation.datagridcell.md) registration for configuring the component with a DesignSystem. |
|  [fastDataGridRow](./fast-components.fastdatagridrow.md) | A function that returns a [DataGridRow](./fast-foundation.datagridrow.md) registration for configuring the component with a DesignSystem. |
|  [fastDesignSystemProvider](./fast-components.fastdesignsystemprovider.md) | A function that returns a  registration for configuring the component with a DesignSystem. |
|  [fastDialog](./fast-components.fastdialog.md) | A function that returns a [Dialog](./fast-foundation.dialog.md) registration for configuring the component with a DesignSystem. Implements [dialogTemplate](./fast-foundation.dialogtemplate.md) |
|  [fastDisclosure](./fast-components.fastdisclosure.md) | A function that returns a [Disclosure](./fast-foundation.disclosure.md) registration for configuring the component with a DesignSystem. Implements [disclosureTemplate](./fast-foundation.disclosuretemplate.md) |
|  [fastDivider](./fast-components.fastdivider.md) | A function that returns a [Divider](./fast-foundation.divider.md) registration for configuring the component with a DesignSystem. Implements [dividerTemplate](./fast-foundation.dividertemplate.md) |
|  [fastFlipper](./fast-components.fastflipper.md) | A function that returns a [Flipper](./fast-foundation.flipper.md) registration for configuring the component with a DesignSystem. Implements [flipperTemplate](./fast-foundation.flippertemplate.md) |
|  [fastHorizontalScroll](./fast-components.fasthorizontalscroll.md) | A function that returns a [HorizontalScroll](./fast-foundation.horizontalscroll.md) registration for configuring the component with a DesignSystem. Implements [horizontalScrollTemplate](./fast-foundation.horizontalscrolltemplate.md) |
|  [fastListbox](./fast-components.fastlistbox.md) | A function that returns a [ListboxElement](./fast-foundation.listboxelement.md) registration for configuring the component with a DesignSystem. Implements [listboxTemplate](./fast-foundation.listboxtemplate.md) |
|  [fastMenu](./fast-components.fastmenu.md) | A function that returns a [Menu](./fast-foundation.menu.md) registration for configuring the component with a DesignSystem. Implements [menuTemplate](./fast-foundation.menutemplate.md) |
|  [fastMenuItem](./fast-components.fastmenuitem.md) | A function that returns a [MenuItem](./fast-foundation.menuitem.md) registration for configuring the component with a DesignSystem. Implements [menuItemTemplate](./fast-foundation.menuitemtemplate.md) |
|  [fastNumberField](./fast-components.fastnumberfield.md) | A function that returns a [NumberField](./fast-foundation.numberfield.md) registration for configuring the component with a DesignSystem. Implements [numberFieldTemplate](./fast-foundation.numberfieldtemplate.md) |
|  [fastOption](./fast-components.fastoption.md) | A function that returns a [ListboxOption](./fast-foundation.listboxoption.md) registration for configuring the component with a DesignSystem. Implements [listboxOptionTemplate](./fast-foundation.listboxoptiontemplate.md) |
|  [fastProgress](./fast-components.fastprogress.md) | A function that returns a [BaseProgress](./fast-foundation.baseprogress.md) registration for configuring the component with a DesignSystem. Implements [progressTemplate](./fast-foundation.progresstemplate.md) |
|  [fastProgressRing](./fast-components.fastprogressring.md) | A function that returns a [BaseProgress](./fast-foundation.baseprogress.md) registration for configuring the component with a DesignSystem. Implements [progressRingTemplate](./fast-foundation.progressringtemplate.md) |
|  [fastRadio](./fast-components.fastradio.md) | A function that returns a [Radio](./fast-foundation.radio.md) registration for configuring the component with a DesignSystem. Implements [radioTemplate](./fast-foundation.radiotemplate.md) |
|  [fastRadioGroup](./fast-components.fastradiogroup.md) | A function that returns a [RadioGroup](./fast-foundation.radiogroup.md) registration for configuring the component with a DesignSystem. Implements [radioGroupTemplate](./fast-foundation.radiogrouptemplate.md) |
|  [fastSearch](./fast-components.fastsearch.md) | A function that returns a [Search](./fast-foundation.search.md) registration for configuring the component with a DesignSystem. Implements [searchTemplate](./fast-foundation.searchtemplate.md) |
|  [fastSelect](./fast-components.fastselect.md) | A function that returns a [Select](./fast-foundation.select.md) registration for configuring the component with a DesignSystem. Implements [selectTemplate](./fast-foundation.selecttemplate.md) |
|  [fastSkeleton](./fast-components.fastskeleton.md) | A function that returns a [Skeleton](./fast-foundation.skeleton.md) registration for configuring the component with a DesignSystem. Implements [skeletonTemplate](./fast-foundation.skeletontemplate.md) |
|  [fastSlider](./fast-components.fastslider.md) | A function that returns a [Slider](./fast-foundation.slider.md) registration for configuring the component with a DesignSystem. Implements [sliderTemplate](./fast-foundation.slidertemplate.md) |
|  [fastSliderLabel](./fast-components.fastsliderlabel.md) | A function that returns a [SliderLabel](./fast-foundation.sliderlabel.md) registration for configuring the component with a DesignSystem. Implements [sliderLabelTemplate](./fast-foundation.sliderlabeltemplate.md) |
|  [fastSwitch](./fast-components.fastswitch.md) | A function that returns a [Switch](./fast-foundation.switch.md) registration for configuring the component with a DesignSystem. Implements [switchTemplate](./fast-foundation.switchtemplate.md) |
|  [fastTab](./fast-components.fasttab.md) | A function that returns a [Tab](./fast-foundation.tab.md) registration for configuring the component with a DesignSystem. Implements [tabTemplate](./fast-foundation.tabtemplate.md) |
|  [fastTabPanel](./fast-components.fasttabpanel.md) | A function that returns a [TabPanel](./fast-foundation.tabpanel.md) registration for configuring the component with a DesignSystem. Implements [tabPanelTemplate](./fast-foundation.tabpaneltemplate.md) |
|  [fastTabs](./fast-components.fasttabs.md) | A function that returns a [Tabs](./fast-foundation.tabs.md) registration for configuring the component with a DesignSystem. Implements [tabsTemplate](./fast-foundation.tabstemplate.md) |
|  [fastTextArea](./fast-components.fasttextarea.md) | A function that returns a [TextArea](./fast-foundation.textarea.md) registration for configuring the component with a DesignSystem. Implements [textAreaTemplate](./fast-foundation.textareatemplate.md) |
|  [fastTextField](./fast-components.fasttextfield.md) | A function that returns a [TextField](./fast-foundation.textfield.md) registration for configuring the component with a DesignSystem. Implements [textFieldTemplate](./fast-foundation.textfieldtemplate.md) |
|  [fastToolbar](./fast-components.fasttoolbar.md) | A function that returns a [Toolbar](./fast-foundation.toolbar.md) registration for configuring the component with a DesignSystem. Implements [toolbarTemplate](./fast-foundation.toolbartemplate.md) |
|  [fastTooltip](./fast-components.fasttooltip.md) | A function that returns a [Tooltip](./fast-foundation.tooltip.md) registration for configuring the component with a DesignSystem. Implements [tooltipTemplate](./fast-foundation.tooltiptemplate.md) |
|  [fastTreeItem](./fast-components.fasttreeitem.md) | A function that returns a [TreeItem](./fast-foundation.treeitem.md) registration for configuring the component with a DesignSystem. Implements [treeItemTemplate](./fast-foundation.treeitemtemplate.md) |
|  [fastTreeView](./fast-components.fasttreeview.md) | A function that returns a [TreeView](./fast-foundation.treeview.md) registration for configuring the component with a DesignSystem. Implements [treeViewTemplate](./fast-foundation.treeviewtemplate.md) |
|  [fillColor](./fast-components.fillcolor.md) |  |
|  [flipperStyles](./fast-components.flipperstyles.md) | Styles for Flipper |
|  [focusStrokeInner](./fast-components.focusstrokeinner.md) |  |
|  [focusStrokeInnerRecipe](./fast-components.focusstrokeinnerrecipe.md) |  |
|  [focusStrokeOuter](./fast-components.focusstrokeouter.md) |  |
|  [focusStrokeOuterRecipe](./fast-components.focusstrokeouterrecipe.md) |  |
|  [focusStrokeWidth](./fast-components.focusstrokewidth.md) |  |
|  [foregroundOnAccentActive](./fast-components.foregroundonaccentactive.md) |  |
|  [foregroundOnAccentActiveLarge](./fast-components.foregroundonaccentactivelarge.md) |  |
|  [foregroundOnAccentFocus](./fast-components.foregroundonaccentfocus.md) |  |
|  [foregroundOnAccentFocusLarge](./fast-components.foregroundonaccentfocuslarge.md) |  |
|  [foregroundOnAccentHover](./fast-components.foregroundonaccenthover.md) |  |
|  [foregroundOnAccentHoverLarge](./fast-components.foregroundonaccenthoverlarge.md) |  |
|  [foregroundOnAccentLargeRecipe](./fast-components.foregroundonaccentlargerecipe.md) |  |
|  [foregroundOnAccentRecipe](./fast-components.foregroundonaccentrecipe.md) |  |
|  [foregroundOnAccentRest](./fast-components.foregroundonaccentrest.md) |  |
|  [foregroundOnAccentRestLarge](./fast-components.foregroundonaccentrestlarge.md) |  |
|  [heightNumberAsToken](./fast-components.heightnumberastoken.md) | The control height formula expressed as a design token. This token does not provide a CSS custom property. |
|  [horizontalScrollStyles](./fast-components.horizontalscrollstyles.md) | Horizontal Scroll styles |
|  [horizontalSliderLabelStyles](./fast-components.horizontalsliderlabelstyles.md) | Styles for Horizontal Slider label |
|  [imgTemplate](./fast-components.imgtemplate.md) | The FAST Avatar Template for Images |
|  [listboxStyles](./fast-components.listboxstyles.md) | Styles for Listbox |
|  [menuItemStyles](./fast-components.menuitemstyles.md) | Styles for Menu item |
|  [menuStyles](./fast-components.menustyles.md) | Styles for Menu |
|  [neutralColor](./fast-components.neutralcolor.md) |  |
|  [neutralFillActive](./fast-components.neutralfillactive.md) |  |
|  [neutralFillActiveDelta](./fast-components.neutralfillactivedelta.md) |  |
|  [neutralFillFocus](./fast-components.neutralfillfocus.md) |  |
|  [neutralFillFocusDelta](./fast-components.neutralfillfocusdelta.md) |  |
|  [neutralFillHover](./fast-components.neutralfillhover.md) |  |
|  [neutralFillHoverDelta](./fast-components.neutralfillhoverdelta.md) |  |
|  [neutralFillInputActive](./fast-components.neutralfillinputactive.md) |  |
|  [neutralFillInputActiveDelta](./fast-components.neutralfillinputactivedelta.md) |  |
|  [neutralFillInputFocus](./fast-components.neutralfillinputfocus.md) |  |
|  [neutralFillInputFocusDelta](./fast-components.neutralfillinputfocusdelta.md) |  |
|  [neutralFillInputHover](./fast-components.neutralfillinputhover.md) |  |
|  [neutralFillInputHoverDelta](./fast-components.neutralfillinputhoverdelta.md) |  |
|  [neutralFillInputRecipe](./fast-components.neutralfillinputrecipe.md) |  |
|  [neutralFillInputRest](./fast-components.neutralfillinputrest.md) |  |
|  [neutralFillInputRestDelta](./fast-components.neutralfillinputrestdelta.md) |  |
|  [neutralFillLayerRecipe](./fast-components.neutralfilllayerrecipe.md) |  |
|  [neutralFillLayerRest](./fast-components.neutralfilllayerrest.md) |  |
|  [neutralFillLayerRestDelta](./fast-components.neutralfilllayerrestdelta.md) |  |
|  [neutralFillRecipe](./fast-components.neutralfillrecipe.md) |  |
|  [neutralFillRest](./fast-components.neutralfillrest.md) |  |
|  [neutralFillRestDelta](./fast-components.neutralfillrestdelta.md) |  |
|  [neutralFillStealthActive](./fast-components.neutralfillstealthactive.md) |  |
|  [neutralFillStealthActiveDelta](./fast-components.neutralfillstealthactivedelta.md) |  |
|  [neutralFillStealthFocus](./fast-components.neutralfillstealthfocus.md) |  |
|  [neutralFillStealthFocusDelta](./fast-components.neutralfillstealthfocusdelta.md) |  |
|  [neutralFillStealthHover](./fast-components.neutralfillstealthhover.md) |  |
|  [neutralFillStealthHoverDelta](./fast-components.neutralfillstealthhoverdelta.md) |  |
|  [neutralFillStealthRecipe](./fast-components.neutralfillstealthrecipe.md) |  |
|  [neutralFillStealthRest](./fast-components.neutralfillstealthrest.md) |  |
|  [neutralFillStealthRestDelta](./fast-components.neutralfillstealthrestdelta.md) |  |
|  [neutralFillStrongActive](./fast-components.neutralfillstrongactive.md) |  |
|  [neutralFillStrongActiveDelta](./fast-components.neutralfillstrongactivedelta.md) |  |
|  [neutralFillStrongFocus](./fast-components.neutralfillstrongfocus.md) |  |
|  [neutralFillStrongFocusDelta](./fast-components.neutralfillstrongfocusdelta.md) |  |
|  [neutralFillStrongHover](./fast-components.neutralfillstronghover.md) |  |
|  [neutralFillStrongHoverDelta](./fast-components.neutralfillstronghoverdelta.md) |  |
|  [neutralFillStrongRecipe](./fast-components.neutralfillstrongrecipe.md) |  |
|  [neutralFillStrongRest](./fast-components.neutralfillstrongrest.md) |  |
|  [neutralFillStrongRestDelta](./fast-components.neutralfillstrongrestdelta.md) |  |
|  [neutralForegroundHint](./fast-components.neutralforegroundhint.md) |  |
|  [neutralForegroundHintRecipe](./fast-components.neutralforegroundhintrecipe.md) |  |
|  [neutralForegroundRecipe](./fast-components.neutralforegroundrecipe.md) |  |
|  [neutralForegroundRest](./fast-components.neutralforegroundrest.md) |  |
|  [neutralLayer1](./fast-components.neutrallayer1.md) |  |
|  [neutralLayer1Recipe](./fast-components.neutrallayer1recipe.md) |  |
|  [neutralLayer2](./fast-components.neutrallayer2.md) |  |
|  [neutralLayer2Recipe](./fast-components.neutrallayer2recipe.md) |  |
|  [neutralLayer3](./fast-components.neutrallayer3.md) |  |
|  [neutralLayer3Recipe](./fast-components.neutrallayer3recipe.md) |  |
|  [neutralLayer4](./fast-components.neutrallayer4.md) |  |
|  [neutralLayer4Recipe](./fast-components.neutrallayer4recipe.md) |  |
|  [neutralLayerCardContainer](./fast-components.neutrallayercardcontainer.md) |  |
|  [neutralLayerCardContainerRecipe](./fast-components.neutrallayercardcontainerrecipe.md) |  |
|  [neutralLayerFloating](./fast-components.neutrallayerfloating.md) |  |
|  [neutralLayerFloatingRecipe](./fast-components.neutrallayerfloatingrecipe.md) |  |
|  [neutralPalette](./fast-components.neutralpalette.md) |  |
|  [neutralStrokeActive](./fast-components.neutralstrokeactive.md) |  |
|  [neutralStrokeActiveDelta](./fast-components.neutralstrokeactivedelta.md) |  |
|  [neutralStrokeDividerRecipe](./fast-components.neutralstrokedividerrecipe.md) |  |
|  [neutralStrokeDividerRest](./fast-components.neutralstrokedividerrest.md) |  |
|  [neutralStrokeDividerRestDelta](./fast-components.neutralstrokedividerrestdelta.md) |  |
|  [neutralStrokeFocus](./fast-components.neutralstrokefocus.md) |  |
|  [neutralStrokeFocusDelta](./fast-components.neutralstrokefocusdelta.md) |  |
|  [neutralStrokeHover](./fast-components.neutralstrokehover.md) |  |
|  [neutralStrokeHoverDelta](./fast-components.neutralstrokehoverdelta.md) |  |
|  [neutralStrokeRecipe](./fast-components.neutralstrokerecipe.md) |  |
|  [neutralStrokeRest](./fast-components.neutralstrokerest.md) |  |
|  [neutralStrokeRestDelta](./fast-components.neutralstrokerestdelta.md) |  |
|  [numberFieldStyles](./fast-components.numberfieldstyles.md) | Styles for Number Field |
|  [optionStyles](./fast-components.optionstyles.md) | Styles for the [Listbox Option](./fast-components.fastoption.md) component. |
|  [PaletteRGB](./fast-components.palettergb.md) |  |
|  [pickerListItemStyles](./fast-components.pickerlistitemstyles.md) | Styles for Picker list item |
|  [pickerMenuOptionStyles](./fast-components.pickermenuoptionstyles.md) | Styles for Picker menu option |
|  [pickerMenuStyles](./fast-components.pickermenustyles.md) | Styles for Picker menu |
|  [pickerStyles](./fast-components.pickerstyles.md) | Styles for Picker |
|  [progressRingStyles](./fast-components.progressringstyles.md) | Styles for Progress Ring |
|  [progressStyles](./fast-components.progressstyles.md) | Styles for Progress |
|  [radioGroupStyles](./fast-components.radiogroupstyles.md) | Styles for Radio Group |
|  [radioStyles](./fast-components.radiostyles.md) | Styles for Radio |
|  [searchStyles](./fast-components.searchstyles.md) | Styles for Search |
|  [selectStyles](./fast-components.selectstyles.md) | Styles for Select. |
|  [skeletonStyles](./fast-components.skeletonstyles.md) | Styles for Skeleton |
|  [sliderLabelStyles](./fast-components.sliderlabelstyles.md) | Styles for Slider Label |
|  [sliderStyles](./fast-components.sliderstyles.md) | Styles for Slider |
|  [StandardLuminance](./fast-components.standardluminance.md) | Recommended values for light and dark mode for [baseLayerLuminance](./fast-components.baselayerluminance.md)<!-- -->. |
|  [strokeWidth](./fast-components.strokewidth.md) |  |
|  [SwatchRGB](./fast-components.swatchrgb.md) |  |
|  [switchStyles](./fast-components.switchstyles.md) | Styles for Switch |
|  [tabPanelStyles](./fast-components.tabpanelstyles.md) | Styles for Tab Panel |
|  [tabsStyles](./fast-components.tabsstyles.md) | Styles for Tabs |
|  [tabStyles](./fast-components.tabstyles.md) | Styles for Tab |
|  [textAreaStyles](./fast-components.textareastyles.md) | Styles for Text Area |
|  [textFieldStyles](./fast-components.textfieldstyles.md) | Styles for Text Field |
|  [toolbarStyles](./fast-components.toolbarstyles.md) | Styles for the Toolbar |
|  [tooltipStyles](./fast-components.tooltipstyles.md) | Styles for Tooltip |
|  [treeItemStyles](./fast-components.treeitemstyles.md) | Styles for Tree Item |
|  [treeViewStyles](./fast-components.treeviewstyles.md) | Styles for Tree View |
|  [typeRampBaseFontSize](./fast-components.typerampbasefontsize.md) |  |
|  [typeRampBaseLineHeight](./fast-components.typerampbaselineheight.md) |  |
|  [typeRampMinus1FontSize](./fast-components.typerampminus1fontsize.md) |  |
|  [typeRampMinus1LineHeight](./fast-components.typerampminus1lineheight.md) |  |
|  [typeRampMinus2FontSize](./fast-components.typerampminus2fontsize.md) |  |
|  [typeRampMinus2LineHeight](./fast-components.typerampminus2lineheight.md) |  |
|  [typeRampPlus1FontSize](./fast-components.typerampplus1fontsize.md) |  |
|  [typeRampPlus1LineHeight](./fast-components.typerampplus1lineheight.md) |  |
|  [typeRampPlus2FontSize](./fast-components.typerampplus2fontsize.md) |  |
|  [typeRampPlus2LineHeight](./fast-components.typerampplus2lineheight.md) |  |
|  [typeRampPlus3FontSize](./fast-components.typerampplus3fontsize.md) |  |
|  [typeRampPlus3LineHeight](./fast-components.typerampplus3lineheight.md) |  |
|  [typeRampPlus4FontSize](./fast-components.typerampplus4fontsize.md) |  |
|  [typeRampPlus4LineHeight](./fast-components.typerampplus4lineheight.md) |  |
|  [typeRampPlus5FontSize](./fast-components.typerampplus5fontsize.md) |  |
|  [typeRampPlus5LineHeight](./fast-components.typerampplus5lineheight.md) |  |
|  [typeRampPlus6FontSize](./fast-components.typerampplus6fontsize.md) |  |
|  [typeRampPlus6LineHeight](./fast-components.typerampplus6lineheight.md) |  |
|  [verticalSliderLabelStyles](./fast-components.verticalsliderlabelstyles.md) | Styles for Vertical slider label |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AnchorAppearance](./fast-components.anchorappearance.md) | Types of anchor appearance. |
|  [ButtonAppearance](./fast-components.buttonappearance.md) | Types of button appearance. |
|  [DisclosureAppearance](./fast-components.disclosureappearance.md) | Types of anchor appearance. |
|  [NumberFieldAppearance](./fast-components.numberfieldappearance.md) | Number field appearances |
|  [PaletteRGB](./fast-components.palettergb.md) |  |
|  [SearchAppearance](./fast-components.searchappearance.md) | Search appearances |
|  [StandardLuminance](./fast-components.standardluminance.md) | Types of recommended values for light and dark mode for [baseLayerLuminance](./fast-components.baselayerluminance.md)<!-- -->. |
|  [TextAreaAppearance](./fast-components.textareaappearance.md) | Text area appearances |
|  [TextFieldAppearance](./fast-components.textfieldappearance.md) | Text field appearances |
