///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/scene/objects/shapes/ShapeObject.h>
#include <core/viewport/Viewport.h>

namespace Core {

IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(ShapeObject, SceneObject)

/******************************************************************************
* Makes the object render itself into the viewport.
******************************************************************************/
void ShapeObject::renderObject(TimeTicks time, ObjectNode* contextNode, Viewport* vp)
{
	vp->renderNodeBezierShape(shape(), contextNode);
}

/******************************************************************************
* Saves the class' contents to the given stream.
******************************************************************************/
void ShapeObject::saveToStream(ObjectSaveStream& stream)
{
	SceneObject::saveToStream(stream);
	stream.beginChunk(0x00001);
	stream << _shapeValidity;
	_shape.saveToStream(stream);
	stream.endChunk();
}

/******************************************************************************
* Loads the class' contents from the given stream.
******************************************************************************/
void ShapeObject::loadFromStream(ObjectLoadStream& stream)
{
	SceneObject::loadFromStream(stream);
	stream.expectChunk(0x00001);
	stream >> _shapeValidity;
	_shape.loadFromStream(stream);
	stream.closeChunk();
}

/******************************************************************************
* Creates a copy of this object.
******************************************************************************/
RefTarget::SmartPtr ShapeObject::clone(bool deepCopy, CloneHelper& cloneHelper)
{
	// Let the base class create an instance of this class.
	ShapeObject::SmartPtr clone = static_object_cast<ShapeObject>(SceneObject::clone(deepCopy, cloneHelper));

	clone->_shapeValidity = this->_shapeValidity;
	clone->_shape = this->_shape;

	return clone;
}

};
