///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_ROTATION_MODE_H
#define __OVITO_ROTATION_MODE_H

#include <core/Core.h>
#include "XFormMode.h"

namespace Core {

/******************************************************************************
* This mode lets the user rotate scene nodes.
******************************************************************************/
class CORE_DLLEXPORT RotationMode : public XFormMode
{
	Q_OBJECT	
public:

	/// Prevent deletion of singleton instance.
	virtual void autoDeleteObject() {}

protected:

	/// Returns true if this is a move, rotate of scale mode.
	/// Returns false if it is a selection mode.
	bool isTransformationMode() { return true; }

	/// Is called when the xform operation begins.
	virtual void startXForm();

	/// Is called during the operation.
	virtual void doXForm();

	/// Applies the current transformation to the given nodes.
	virtual void applyXForm(const QVector<SceneNode*>& nodeSet, FloatType multiplier);

	/// Returns the display name of this xform mode.
	/// This name will be shown in the Undo menu item.
	virtual QString displayName() { return tr("Rotate"); }

	/// Returns the cursor to display when the mouse is
	/// over an object in the viewports.
	virtual QString cursorFilename() { return ":/core/main/cursor_mode_rotate.png"; }

private:

	/// The cached transformation center for off-center rotation.
	Point3 transformationCenter;

	/// The current rotation
	Rotation rot;

	/// Private ctor since this is a singleton class.
	RotationMode() {}
	
	friend class XFormManager;
};

};

#endif // __OVITO_ROTATION_MODE_H
