#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Stdlib Imports
import tarfile
from os import access,F_OK
from sys import argv

if not len(argv) == 2:
    print "Please specifiy a path to the launchpad translations."
    raise SystemExit

if not access('po', F_OK):
    print "Please call this utility from the base directory!"
    raise SystemExit

try:
    t = tarfile.open(argv[1], 'r')
except:
    print "Sorry, could not open tarfile. Permissions Okay?"
    raise SystemExit

for translation in t.getmembers():
    if translation.isfile() and translation.name.endswith(u'.po'):
        language = translation.name.split('-')[1].split('.')[0]
        f = t.extractfile(translation)
        o = open('po/%s.po' % language,'w')
        o.write(f.read())
        f.close()
        o.close()
