#!/bin/sh

set -euxf

pkg=$1

find debian/$pkg \
     -name '*.pyc' -delete
find debian/$pkg \
     -name '__pycache__' -delete

# Don't need these, and lintian will make a noise about them
find debian/$pkg \( \
     -name 'regen' \
     -o -name '*.bat' \
     -o -name 'fetch_*' \
     -o -name '*.pickle' \
     \) -delete

# Remove empty directories, because pypy3clean will
find debian/$pkg/usr/lib/pypy3/lib-python -type d -empty -delete

# Nothing in the stdlib should be executable
chmod -R a-x+X debian/$pkg/usr/lib/pypy3/lib-python/
if [ "$pkg" = "pypy3-lib" ]; then
	chmod -R a-x+X debian/$pkg/usr/lib/pypy3/lib_pypy/
fi

# Fix interpreters
find debian/$pkg \
     -name '*.py' -print0 \
     | xargs -0 sed -i -e '1s|^#!.*python.*|#!/usr/bin/pypy3|'
