// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_EMBEDDER_SUPPORT_ANDROID_UTIL_CDN_UTILS_H_
#define COMPONENTS_EMBEDDER_SUPPORT_ANDROID_UTIL_CDN_UTILS_H_

#include "base/feature_list.h"

class GURL;

namespace content {
class NavigationHandle;
}

namespace embedder_support {

extern const base::Feature kShowTrustedPublisherURL;

// This should be called from content::WebContentsObserver::DidFinishNavigation
// to get a publisher url for the committed navigation, else an empty GURL().
GURL GetPublisherURL(content::NavigationHandle* navigation_handle);

}  // namespace embedder_support

#endif  //  COMPONENTS_EMBEDDER_SUPPORT_ANDROID_UTIL_CDN_UTILS_H_
