% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFactors.R
\name{plotFactorScatters}
\alias{plotFactorScatters}
\title{Pairwise scatterplots of multiple latent factors}
\usage{
plotFactorScatters(object, factors = "all", showMissing = TRUE,
  color_by = NULL, name_color = "", shape_by = NULL,
  name_shape = "")
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{factors}{character vector with the factor name(s), or
 numeric vector with the index of the factor(s) to use. 
Default is 'all'}

\item{showMissing}{logical indicating whether to include samples for which
\code{shape_by} or \code{color_by} is missing}

\item{color_by}{specifies groups or values used to color the samples. 
This can be either: 
a character giving the name of a feature present in the training data, 
a character giving the same of a covariate (only if using \code{\link{MultiAssayExperiment}} as input), 
or a vector of the same length as the number of samples specifying discrete groups or 
continuous numeric values.}

\item{name_color}{name for color legend (usually only used if color_by is not a character itself)}

\item{shape_by}{specifies groups or values used to shape the samples. 
This can be either: 
a character giving the name of a feature present in the training data, 
a character giving the same of a covariate (only if using \code{\link{MultiAssayExperiment}} as input), 
or a vector of the same length as the number of samples specifying discrete groups.}

\item{name_shape}{name for shape legend (usually only used if shape_by is not a character itself)}
}
\value{
\code{ggplot2} object
}
\description{
Scatterplots of the sample values for pair-wise
combinations of multiple latent factors.
}
\details{
One of the first steps for the annotation of factors is to visualise and
 overlap them with known covariates such as phenotypic or clinical data.
This method generates multiple scatterplots for pairwise combinations of several latent factors.
Similar functions are \code{\link{plotFactorScatter}} for doing single scatter plots and 
\code{\link{plotFactorBeeswarm}} for doing Beeswarm plots for single factors.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
plotFactorScatters(MOFA_CLL, factors=1:3)
plotFactorScatters(MOFA_CLL, factors=1:3, color_by= "IGHV")

# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
plotFactorScatters(MOFA_scMT)
}
