% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeGMT.R
\name{writeGMT}
\alias{writeGMT}
\title{Write GMT File}
\usage{
writeGMT(df, outfile)
}
\arguments{
\item{df}{Data frame with columns ordered as Identifiers, optional 
Description column and Genes. Identifiers must be first and Genes must be 
last.}

\item{outfile}{Path to output GMT file}
}
\value{
None
}
\description{
Writes a GMT (Gene Matrix Transposed) file from a data frame.
}
\details{
The input data frame must include at least two columns: Identifiers
(first column) and Genes (last column). The Identifiers will be duplicated to
fill the Description column in the output GMT file if none is provided. If 
more than three columns are provided, then the first n columns will be 
concatenated with % separators to form the ID, where n+2 equals the total
number of columns.
}
\examples{
\donttest{
my.df <- data.frame(id=c("WP1000","WP1000","WP1000","WP1001","WP1001"),
         description=c("cancer","cancer","cancer","diabetes","diabetes"),
         gene=c("574413","2167","4690","5781","11184"))
writeGMT(my.df, "my_gmt_file.gmt")
}
}
\references{
Adapted from the GMT writer in MAGeCKFlute,
 \url{https://github.com/WubingZhang/MAGeCKFlute/blob/master/R/readGMT.R}
}
\seealso{
readPathwayGMT
}
