% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold-deprecated.R, R/bold_identify_parents.R,
%   R/bold_tax_id.R
\name{bold-deprecated}
\alias{bold-deprecated}
\alias{bold_identify_parents}
\alias{bold_tax_id}
\title{Deprecated functions in package \pkg{bold}.}
\usage{
bold_identify_parents(
  x,
  wide = FALSE,
  taxid = NULL,
  taxon = NULL,
  tax_rank = NULL,
  tax_division = NULL,
  parentid = NULL,
  parentname = NULL,
  taxonrep = NULL,
  specimenrecords = NULL,
  ...
)

bold_tax_id(
  id,
  dataTypes = "basic",
  includeTree = FALSE,
  response = FALSE,
  ...
)
}
\value{
a list of the same length as the input
}
\description{
The functions listed below are deprecated and will be defunct in
the near future. When possible, alternative functions with similar
functionality are also mentioned. Help pages for deprecated functions are
available at \code{help("<function>-deprecated")}.
}
\details{
DEPRECATED. See \code{\link{bold_identify_taxonomy}}. It's faster and gets the accurate  taxonomy directly from the record of the sequence.

This function gets unique set of taxonomic names from the input
data.frame, then queries \code{\link{bold_tax_name}} to get the
taxonomic ID, passing it to \code{\link{bold_tax_id}} to get the parent
names, then attaches those to the input data.

Records in the input data that do not have matches for parent names
simply get NA values in the added columns.
}
\section{\code{bold_identify_parents}}{

For \code{bold_identify_parents}, use \code{\link{bold_identify_taxonomy}}.
}

\section{Filtering}{

The parameters \code{taxid}, \code{taxon}, \code{tax_rank}, \code{tax_division},
\code{parentid}, \code{parentname},\code{taxonrep}, and \code{specimenrecords} are not used
in the search sent to BOLD, but are used in filtering the data down
to a subset that is closer to the target you want. For all these
parameters, you can use regex strings since we use \code{\link[base]{grep}}
internally to match. Filtering narrows down to the set that matches your
query, and removes the rest. The data.frame that we filter on with these
parameters internally is the result of a call to the
\code{\link{bold_tax_name}} function.
}

\section{wide vs long format}{

When \code{wide = FALSE} you get many rows for each record. Essentially,
we \code{cbind} the taxonomic classification onto the one row from the
result of \code{\link{bold_identify}}, giving as many rows as there are
taxa in the taxonomic classification.

When \code{wide = TRUE} you get one row for each record - thus the
dimensions of the input data stay the same. For this option, we take just
the rows for taxonomic ID and name for each taxon in the taxonomic
classification, and name the columns by the taxon rank, so you get
\code{phylum} and \code{phylum_id}, and so on.
}

\section{\code{bold_tax_id}}{

For \code{bold_tax_id}, use \code{\link{bold_tax_id2}}.
}

\examples{
\dontrun{
df <- bold_identify(sequences = sequences$seq2)

# long format
out <- bold_identify_parents(df)
str(out)
head(out[[1]])

# wide format
out <- bold_identify_parents(df, wide = TRUE)
str(out)
head(out[[1]])

x <- bold_seq(taxon = "Satyrium")
out <- bold_identify(c(x[[1]]$sequence, x[[13]]$sequence))
res <- bold_identify_parents(out)
res

x <- bold_seq(taxon = 'Diplura')
out <- bold_identify(vapply(x, "[[", "", "sequence")[1:20])
res <- bold_identify_parents(out)
}
\dontrun{
bold_tax_id(id = 88899)
bold_tax_id(id = 88899, includeTree = TRUE)
bold_tax_id(id = 88899, includeTree = TRUE, dataTypes = "stats")
bold_tax_id(id = c(88899,125295))

## dataTypes parameters
bold_tax_id(id = 88899, dataTypes = "basic")
bold_tax_id(id = 88899, dataTypes = "stats")
bold_tax_id(id = 88899, dataTypes = "images")
bold_tax_id(id = 88899, dataTypes = "geo")
bold_tax_id(id = 88899, dataTypes = "sequencinglabs")
bold_tax_id(id = 88899, dataTypes = "depository")
bold_tax_id(id = c(88899, 125295), dataTypes = "geo")
bold_tax_id(id = c(88899, 125295), dataTypes = "images")

## Passing in NA
bold_tax_id(id = NA)
bold_tax_id(id = c(88899, 125295, NA))

## get http response object only
bold_tax_id(id = 88899, response=TRUE)
bold_tax_id(id = c(88899, 125295), response=TRUE)

## curl debugging
bold_tax_id(id = 88899, verbose = TRUE)
}

}
\references{
http://v4.boldsystems.org/index.php/resources/api?type=taxonomy
}
\seealso{
\code{\link[=bold_tax_name]{bold_tax_name()}}
}
\keyword{internal}
